/* SPDX-FileCopyrightText: 2007 - Gustavo Giráldez
 * SPDX-FileCopyrightText: 2007 - Paolo Maggi
 * SPDX-FileCopyrightText: 2017 - Sébastien Wilmet <swilmet@gnome.org>
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#include <glib.h>

G_BEGIN_DECLS

G_GNUC_INTERNAL
gchar **	_gtk_source_utils_get_default_dirs		(const gchar *basename);

G_GNUC_INTERNAL
GSList *	_gtk_source_utils_get_file_list			(gchar       **path,
								 const gchar  *suffix,
								 gboolean      only_dirs);

G_GNUC_INTERNAL
gint		_gtk_source_utils_string_to_int			(const gchar *str);

G_GNUC_INTERNAL
const gchar *	_gtk_source_utils_find_escaped_char		(const gchar *str,
								 gchar        ch);

/* Note: it returns duplicated string. */
G_GNUC_INTERNAL
gchar *		_gtk_source_utils_dgettext			(const gchar *domain,
								 const gchar *msgid) G_GNUC_FORMAT(2);

G_END_DECLS
