#ifndef INCLUDED_OFFICECFG_OFFICE_IMPRESS_HXX
#define INCLUDED_OFFICECFG_OFFICE_IMPRESS_HXX

#include "sal/config.h"

#include <optional>
#include "com/sun/star/uno/Sequence.hxx"
#include "rtl/ustring.h"
#include "rtl/ustring.hxx"
#include "sal/types.h"
#include "comphelper/configuration.hxx"

namespace officecfg { namespace Office { namespace Impress {

struct Layout: public comphelper::ConfigurationGroup< Layout> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Layout"_ustr); return PATH; }

struct Display: public comphelper::ConfigurationGroup< Display> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Layout/Display"_ustr); return PATH; }

struct Ruler: public comphelper::ConfigurationProperty<Ruler, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Layout/Display/Ruler"_ustr); return PATH; }
private:
    Ruler(); // not defined
    ~Ruler(); // not defined
};

struct Helpline: public comphelper::ConfigurationProperty<Helpline, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Layout/Display/Helpline"_ustr); return PATH; }
private:
    Helpline(); // not defined
    ~Helpline(); // not defined
};

struct Guide: public comphelper::ConfigurationProperty<Guide, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Layout/Display/Guide"_ustr); return PATH; }
private:
    Guide(); // not defined
    ~Guide(); // not defined
};

struct Bezier: public comphelper::ConfigurationProperty<Bezier, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Layout/Display/Bezier"_ustr); return PATH; }
private:
    Bezier(); // not defined
    ~Bezier(); // not defined
};

struct Contour: public comphelper::ConfigurationProperty<Contour, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Layout/Display/Contour"_ustr); return PATH; }
private:
    Contour(); // not defined
    ~Contour(); // not defined
};

struct NavigationBtnScale: public comphelper::ConfigurationProperty<NavigationBtnScale, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Layout/Display/NavigationBtnScale"_ustr); return PATH; }
private:
    NavigationBtnScale(); // not defined
    ~NavigationBtnScale(); // not defined
};

private:
    Display(); // not defined
    ~Display(); // not defined
};

struct Other: public comphelper::ConfigurationGroup< Other> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Layout/Other"_ustr); return PATH; }

struct TabStop: public comphelper::ConfigurationGroup< TabStop> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Layout/Other/TabStop"_ustr); return PATH; }

struct Metric: public comphelper::ConfigurationProperty<Metric, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Layout/Other/TabStop/Metric"_ustr); return PATH; }
private:
    Metric(); // not defined
    ~Metric(); // not defined
};

struct NonMetric: public comphelper::ConfigurationProperty<NonMetric, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Layout/Other/TabStop/NonMetric"_ustr); return PATH; }
private:
    NonMetric(); // not defined
    ~NonMetric(); // not defined
};

private:
    TabStop(); // not defined
    ~TabStop(); // not defined
};

struct MeasureUnit: public comphelper::ConfigurationGroup< MeasureUnit> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Layout/Other/MeasureUnit"_ustr); return PATH; }

struct Metric: public comphelper::ConfigurationProperty<Metric, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Layout/Other/MeasureUnit/Metric"_ustr); return PATH; }
private:
    Metric(); // not defined
    ~Metric(); // not defined
};

struct NonMetric: public comphelper::ConfigurationProperty<NonMetric, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Layout/Other/MeasureUnit/NonMetric"_ustr); return PATH; }
private:
    NonMetric(); // not defined
    ~NonMetric(); // not defined
};

private:
    MeasureUnit(); // not defined
    ~MeasureUnit(); // not defined
};

private:
    Other(); // not defined
    ~Other(); // not defined
};

private:
    Layout(); // not defined
    ~Layout(); // not defined
};

struct Content: public comphelper::ConfigurationGroup< Content> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Content"_ustr); return PATH; }

struct Display: public comphelper::ConfigurationGroup< Display> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Content/Display"_ustr); return PATH; }

private:
    Display(); // not defined
    ~Display(); // not defined
};

private:
    Content(); // not defined
    ~Content(); // not defined
};

struct Misc: public comphelper::ConfigurationGroup< Misc> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc"_ustr); return PATH; }

struct BackgroundCache: public comphelper::ConfigurationProperty<BackgroundCache, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/BackgroundCache"_ustr); return PATH; }
private:
    BackgroundCache(); // not defined
    ~BackgroundCache(); // not defined
};

struct CopyWhileMoving: public comphelper::ConfigurationProperty<CopyWhileMoving, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/CopyWhileMoving"_ustr); return PATH; }
private:
    CopyWhileMoving(); // not defined
    ~CopyWhileMoving(); // not defined
};

struct ObjectMoveable: public comphelper::ConfigurationProperty<ObjectMoveable, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/ObjectMoveable"_ustr); return PATH; }
private:
    ObjectMoveable(); // not defined
    ~ObjectMoveable(); // not defined
};

struct NoDistort: public comphelper::ConfigurationProperty<NoDistort, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/NoDistort"_ustr); return PATH; }
private:
    NoDistort(); // not defined
    ~NoDistort(); // not defined
};

struct DclickTextedit: public comphelper::ConfigurationProperty<DclickTextedit, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/DclickTextedit"_ustr); return PATH; }
private:
    DclickTextedit(); // not defined
    ~DclickTextedit(); // not defined
};

struct RotateClick: public comphelper::ConfigurationProperty<RotateClick, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/RotateClick"_ustr); return PATH; }
private:
    RotateClick(); // not defined
    ~RotateClick(); // not defined
};

struct Preview: public comphelper::ConfigurationProperty<Preview, double> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/Preview"_ustr); return PATH; }
private:
    Preview(); // not defined
    ~Preview(); // not defined
};

struct ShowComments: public comphelper::ConfigurationProperty<ShowComments, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/ShowComments"_ustr); return PATH; }
private:
    ShowComments(); // not defined
    ~ShowComments(); // not defined
};

struct ModifyWithAttributes: public comphelper::ConfigurationProperty<ModifyWithAttributes, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/ModifyWithAttributes"_ustr); return PATH; }
private:
    ModifyWithAttributes(); // not defined
    ~ModifyWithAttributes(); // not defined
};

struct ShowUndoDeleteWarning: public comphelper::ConfigurationProperty<ShowUndoDeleteWarning, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/ShowUndoDeleteWarning"_ustr); return PATH; }
private:
    ShowUndoDeleteWarning(); // not defined
    ~ShowUndoDeleteWarning(); // not defined
};

struct SorterSlidesPerRow: public comphelper::ConfigurationProperty<SorterSlidesPerRow, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/SorterSlidesPerRow"_ustr); return PATH; }
private:
    SorterSlidesPerRow(); // not defined
    ~SorterSlidesPerRow(); // not defined
};

struct SlideshowRespectZOrder: public comphelper::ConfigurationProperty<SlideshowRespectZOrder, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/SlideshowRespectZOrder"_ustr); return PATH; }
private:
    SlideshowRespectZOrder(); // not defined
    ~SlideshowRespectZOrder(); // not defined
};

struct TransitionFiles: public comphelper::ConfigurationProperty<TransitionFiles, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/TransitionFiles"_ustr); return PATH; }
private:
    TransitionFiles(); // not defined
    ~TransitionFiles(); // not defined
};

struct EffectFiles: public comphelper::ConfigurationProperty<EffectFiles, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/EffectFiles"_ustr); return PATH; }
private:
    EffectFiles(); // not defined
    ~EffectFiles(); // not defined
};

struct LayoutListFiles: public comphelper::ConfigurationProperty<LayoutListFiles, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/LayoutListFiles"_ustr); return PATH; }
private:
    LayoutListFiles(); // not defined
    ~LayoutListFiles(); // not defined
};

struct PresObjListFiles: public comphelper::ConfigurationProperty<PresObjListFiles, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/PresObjListFiles"_ustr); return PATH; }
private:
    PresObjListFiles(); // not defined
    ~PresObjListFiles(); // not defined
};

struct PreviewNewEffects: public comphelper::ConfigurationProperty<PreviewNewEffects, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/PreviewNewEffects"_ustr); return PATH; }
private:
    PreviewNewEffects(); // not defined
    ~PreviewNewEffects(); // not defined
};

struct PreviewChangedEffects: public comphelper::ConfigurationProperty<PreviewChangedEffects, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/PreviewChangedEffects"_ustr); return PATH; }
private:
    PreviewChangedEffects(); // not defined
    ~PreviewChangedEffects(); // not defined
};

struct PreviewTransitions: public comphelper::ConfigurationProperty<PreviewTransitions, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/PreviewTransitions"_ustr); return PATH; }
private:
    PreviewTransitions(); // not defined
    ~PreviewTransitions(); // not defined
};

struct Display: public comphelper::ConfigurationProperty<Display, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/Display"_ustr); return PATH; }
private:
    Display(); // not defined
    ~Display(); // not defined
};

struct PenColor: public comphelper::ConfigurationProperty<PenColor, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/PenColor"_ustr); return PATH; }
private:
    PenColor(); // not defined
    ~PenColor(); // not defined
};

struct PenWidth: public comphelper::ConfigurationProperty<PenWidth, double> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/PenWidth"_ustr); return PATH; }
private:
    PenWidth(); // not defined
    ~PenWidth(); // not defined
};

struct TabBarVisible: public comphelper::ConfigurationProperty<TabBarVisible, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/TabBarVisible"_ustr); return PATH; }
private:
    TabBarVisible(); // not defined
    ~TabBarVisible(); // not defined
};

struct DragThresholdPixels: public comphelper::ConfigurationProperty<DragThresholdPixels, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/DragThresholdPixels"_ustr); return PATH; }
private:
    DragThresholdPixels(); // not defined
    ~DragThresholdPixels(); // not defined
};

struct TextObject: public comphelper::ConfigurationGroup< TextObject> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/TextObject"_ustr); return PATH; }

struct QuickEditing: public comphelper::ConfigurationProperty<QuickEditing, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/TextObject/QuickEditing"_ustr); return PATH; }
private:
    QuickEditing(); // not defined
    ~QuickEditing(); // not defined
};

struct Selectable: public comphelper::ConfigurationProperty<Selectable, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/TextObject/Selectable"_ustr); return PATH; }
private:
    Selectable(); // not defined
    ~Selectable(); // not defined
};

struct ShowBoundary: public comphelper::ConfigurationProperty<ShowBoundary, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/TextObject/ShowBoundary"_ustr); return PATH; }
private:
    ShowBoundary(); // not defined
    ~ShowBoundary(); // not defined
};

private:
    TextObject(); // not defined
    ~TextObject(); // not defined
};

struct NewDoc: public comphelper::ConfigurationGroup< NewDoc> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/NewDoc"_ustr); return PATH; }

struct AutoPilot: public comphelper::ConfigurationProperty<AutoPilot, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/NewDoc/AutoPilot"_ustr); return PATH; }
private:
    AutoPilot(); // not defined
    ~AutoPilot(); // not defined
};

struct Layout: public comphelper::ConfigurationProperty<Layout, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/NewDoc/Layout"_ustr); return PATH; }
private:
    Layout(); // not defined
    ~Layout(); // not defined
};

private:
    NewDoc(); // not defined
    ~NewDoc(); // not defined
};

struct Start: public comphelper::ConfigurationGroup< Start> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/Start"_ustr); return PATH; }

struct EnableSdremote: public comphelper::ConfigurationProperty<EnableSdremote, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/Start/EnableSdremote"_ustr); return PATH; }
private:
    EnableSdremote(); // not defined
    ~EnableSdremote(); // not defined
};

struct EnablePresenterScreen: public comphelper::ConfigurationProperty<EnablePresenterScreen, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/Start/EnablePresenterScreen"_ustr); return PATH; }
private:
    EnablePresenterScreen(); // not defined
    ~EnablePresenterScreen(); // not defined
};

struct PresenterScreenFullScreen: public comphelper::ConfigurationProperty<PresenterScreenFullScreen, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/Start/PresenterScreenFullScreen"_ustr); return PATH; }
private:
    PresenterScreenFullScreen(); // not defined
    ~PresenterScreenFullScreen(); // not defined
};

struct ShowNavigationPanel: public comphelper::ConfigurationProperty<ShowNavigationPanel, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/Start/ShowNavigationPanel"_ustr); return PATH; }
private:
    ShowNavigationPanel(); // not defined
    ~ShowNavigationPanel(); // not defined
};

private:
    Start(); // not defined
    ~Start(); // not defined
};

struct Compatibility: public comphelper::ConfigurationGroup< Compatibility> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/Compatibility"_ustr); return PATH; }

struct AddBetween: public comphelper::ConfigurationProperty<AddBetween, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/Compatibility/AddBetween"_ustr); return PATH; }
private:
    AddBetween(); // not defined
    ~AddBetween(); // not defined
};

struct PrinterIndependentLayout: public comphelper::ConfigurationProperty<PrinterIndependentLayout, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/Compatibility/PrinterIndependentLayout"_ustr); return PATH; }
private:
    PrinterIndependentLayout(); // not defined
    ~PrinterIndependentLayout(); // not defined
};

private:
    Compatibility(); // not defined
    ~Compatibility(); // not defined
};

struct DefaultObjectSize: public comphelper::ConfigurationGroup< DefaultObjectSize> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/DefaultObjectSize"_ustr); return PATH; }

struct Width: public comphelper::ConfigurationProperty<Width, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/DefaultObjectSize/Width"_ustr); return PATH; }
private:
    Width(); // not defined
    ~Width(); // not defined
};

struct Height: public comphelper::ConfigurationProperty<Height, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/DefaultObjectSize/Height"_ustr); return PATH; }
private:
    Height(); // not defined
    ~Height(); // not defined
};

private:
    DefaultObjectSize(); // not defined
    ~DefaultObjectSize(); // not defined
};

struct AuthorisedRemotes: public comphelper::ConfigurationSet< AuthorisedRemotes> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Misc/AuthorisedRemotes"_ustr); return PATH; }
private:
    AuthorisedRemotes(); // not defined
    ~AuthorisedRemotes(); // not defined
};

private:
    Misc(); // not defined
    ~Misc(); // not defined
};

struct Snap: public comphelper::ConfigurationGroup< Snap> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Snap"_ustr); return PATH; }

struct Object: public comphelper::ConfigurationGroup< Object> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Snap/Object"_ustr); return PATH; }

struct Grid: public comphelper::ConfigurationProperty<Grid, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Snap/Object/Grid"_ustr); return PATH; }
private:
    Grid(); // not defined
    ~Grid(); // not defined
};

struct SnapLine: public comphelper::ConfigurationProperty<SnapLine, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Snap/Object/SnapLine"_ustr); return PATH; }
private:
    SnapLine(); // not defined
    ~SnapLine(); // not defined
};

struct PageMargin: public comphelper::ConfigurationProperty<PageMargin, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Snap/Object/PageMargin"_ustr); return PATH; }
private:
    PageMargin(); // not defined
    ~PageMargin(); // not defined
};

struct ObjectFrame: public comphelper::ConfigurationProperty<ObjectFrame, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Snap/Object/ObjectFrame"_ustr); return PATH; }
private:
    ObjectFrame(); // not defined
    ~ObjectFrame(); // not defined
};

struct ObjectPoint: public comphelper::ConfigurationProperty<ObjectPoint, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Snap/Object/ObjectPoint"_ustr); return PATH; }
private:
    ObjectPoint(); // not defined
    ~ObjectPoint(); // not defined
};

struct Range: public comphelper::ConfigurationProperty<Range, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Snap/Object/Range"_ustr); return PATH; }
private:
    Range(); // not defined
    ~Range(); // not defined
};

private:
    Object(); // not defined
    ~Object(); // not defined
};

struct Position: public comphelper::ConfigurationGroup< Position> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Snap/Position"_ustr); return PATH; }

struct CreatingMoving: public comphelper::ConfigurationProperty<CreatingMoving, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Snap/Position/CreatingMoving"_ustr); return PATH; }
private:
    CreatingMoving(); // not defined
    ~CreatingMoving(); // not defined
};

struct ExtendEdges: public comphelper::ConfigurationProperty<ExtendEdges, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Snap/Position/ExtendEdges"_ustr); return PATH; }
private:
    ExtendEdges(); // not defined
    ~ExtendEdges(); // not defined
};

struct Rotating: public comphelper::ConfigurationProperty<Rotating, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Snap/Position/Rotating"_ustr); return PATH; }
private:
    Rotating(); // not defined
    ~Rotating(); // not defined
};

struct RotatingValue: public comphelper::ConfigurationProperty<RotatingValue, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Snap/Position/RotatingValue"_ustr); return PATH; }
private:
    RotatingValue(); // not defined
    ~RotatingValue(); // not defined
};

struct PointReduction: public comphelper::ConfigurationProperty<PointReduction, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Snap/Position/PointReduction"_ustr); return PATH; }
private:
    PointReduction(); // not defined
    ~PointReduction(); // not defined
};

private:
    Position(); // not defined
    ~Position(); // not defined
};

private:
    Snap(); // not defined
    ~Snap(); // not defined
};

struct Grid: public comphelper::ConfigurationGroup< Grid> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Grid"_ustr); return PATH; }

struct Option: public comphelper::ConfigurationGroup< Option> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Grid/Option"_ustr); return PATH; }

struct SnapToGrid: public comphelper::ConfigurationProperty<SnapToGrid, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Grid/Option/SnapToGrid"_ustr); return PATH; }
private:
    SnapToGrid(); // not defined
    ~SnapToGrid(); // not defined
};

struct VisibleGrid: public comphelper::ConfigurationProperty<VisibleGrid, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Grid/Option/VisibleGrid"_ustr); return PATH; }
private:
    VisibleGrid(); // not defined
    ~VisibleGrid(); // not defined
};

struct Synchronize: public comphelper::ConfigurationProperty<Synchronize, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Grid/Option/Synchronize"_ustr); return PATH; }
private:
    Synchronize(); // not defined
    ~Synchronize(); // not defined
};

private:
    Option(); // not defined
    ~Option(); // not defined
};

struct Resolution: public comphelper::ConfigurationGroup< Resolution> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Grid/Resolution"_ustr); return PATH; }

struct XAxis: public comphelper::ConfigurationGroup< XAxis> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Grid/Resolution/XAxis"_ustr); return PATH; }

struct Metric: public comphelper::ConfigurationProperty<Metric, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Grid/Resolution/XAxis/Metric"_ustr); return PATH; }
private:
    Metric(); // not defined
    ~Metric(); // not defined
};

struct NonMetric: public comphelper::ConfigurationProperty<NonMetric, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Grid/Resolution/XAxis/NonMetric"_ustr); return PATH; }
private:
    NonMetric(); // not defined
    ~NonMetric(); // not defined
};

private:
    XAxis(); // not defined
    ~XAxis(); // not defined
};

struct YAxis: public comphelper::ConfigurationGroup< YAxis> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Grid/Resolution/YAxis"_ustr); return PATH; }

struct Metric: public comphelper::ConfigurationProperty<Metric, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Grid/Resolution/YAxis/Metric"_ustr); return PATH; }
private:
    Metric(); // not defined
    ~Metric(); // not defined
};

struct NonMetric: public comphelper::ConfigurationProperty<NonMetric, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Grid/Resolution/YAxis/NonMetric"_ustr); return PATH; }
private:
    NonMetric(); // not defined
    ~NonMetric(); // not defined
};

private:
    YAxis(); // not defined
    ~YAxis(); // not defined
};

private:
    Resolution(); // not defined
    ~Resolution(); // not defined
};

struct Subdivision: public comphelper::ConfigurationGroup< Subdivision> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Grid/Subdivision"_ustr); return PATH; }

struct XAxis: public comphelper::ConfigurationProperty<XAxis, double> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Grid/Subdivision/XAxis"_ustr); return PATH; }
private:
    XAxis(); // not defined
    ~XAxis(); // not defined
};

struct YAxis: public comphelper::ConfigurationProperty<YAxis, double> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Grid/Subdivision/YAxis"_ustr); return PATH; }
private:
    YAxis(); // not defined
    ~YAxis(); // not defined
};

private:
    Subdivision(); // not defined
    ~Subdivision(); // not defined
};

struct SnapGrid: public comphelper::ConfigurationGroup< SnapGrid> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Grid/SnapGrid"_ustr); return PATH; }

struct Size: public comphelper::ConfigurationProperty<Size, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Grid/SnapGrid/Size"_ustr); return PATH; }
private:
    Size(); // not defined
    ~Size(); // not defined
};

private:
    SnapGrid(); // not defined
    ~SnapGrid(); // not defined
};

private:
    Grid(); // not defined
    ~Grid(); // not defined
};

struct Print: public comphelper::ConfigurationGroup< Print> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Print"_ustr); return PATH; }

struct Content: public comphelper::ConfigurationGroup< Content> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Print/Content"_ustr); return PATH; }

struct Presentation: public comphelper::ConfigurationProperty<Presentation, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Print/Content/Presentation"_ustr); return PATH; }
private:
    Presentation(); // not defined
    ~Presentation(); // not defined
};

struct Note: public comphelper::ConfigurationProperty<Note, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Print/Content/Note"_ustr); return PATH; }
private:
    Note(); // not defined
    ~Note(); // not defined
};

struct Handout: public comphelper::ConfigurationProperty<Handout, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Print/Content/Handout"_ustr); return PATH; }
private:
    Handout(); // not defined
    ~Handout(); // not defined
};

struct Outline: public comphelper::ConfigurationProperty<Outline, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Print/Content/Outline"_ustr); return PATH; }
private:
    Outline(); // not defined
    ~Outline(); // not defined
};

private:
    Content(); // not defined
    ~Content(); // not defined
};

struct Page: public comphelper::ConfigurationGroup< Page> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Print/Page"_ustr); return PATH; }

struct PageSize: public comphelper::ConfigurationProperty<PageSize, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Print/Page/PageSize"_ustr); return PATH; }
private:
    PageSize(); // not defined
    ~PageSize(); // not defined
};

struct PageTile: public comphelper::ConfigurationProperty<PageTile, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Print/Page/PageTile"_ustr); return PATH; }
private:
    PageTile(); // not defined
    ~PageTile(); // not defined
};

struct Booklet: public comphelper::ConfigurationProperty<Booklet, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Print/Page/Booklet"_ustr); return PATH; }
private:
    Booklet(); // not defined
    ~Booklet(); // not defined
};

struct BookletFront: public comphelper::ConfigurationProperty<BookletFront, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Print/Page/BookletFront"_ustr); return PATH; }
private:
    BookletFront(); // not defined
    ~BookletFront(); // not defined
};

struct BookletBack: public comphelper::ConfigurationProperty<BookletBack, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Print/Page/BookletBack"_ustr); return PATH; }
private:
    BookletBack(); // not defined
    ~BookletBack(); // not defined
};

private:
    Page(); // not defined
    ~Page(); // not defined
};

struct Other: public comphelper::ConfigurationGroup< Other> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Print/Other"_ustr); return PATH; }

struct PageName: public comphelper::ConfigurationProperty<PageName, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Print/Other/PageName"_ustr); return PATH; }
private:
    PageName(); // not defined
    ~PageName(); // not defined
};

struct Date: public comphelper::ConfigurationProperty<Date, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Print/Other/Date"_ustr); return PATH; }
private:
    Date(); // not defined
    ~Date(); // not defined
};

struct Time: public comphelper::ConfigurationProperty<Time, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Print/Other/Time"_ustr); return PATH; }
private:
    Time(); // not defined
    ~Time(); // not defined
};

struct HiddenPage: public comphelper::ConfigurationProperty<HiddenPage, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Print/Other/HiddenPage"_ustr); return PATH; }
private:
    HiddenPage(); // not defined
    ~HiddenPage(); // not defined
};

struct Quality: public comphelper::ConfigurationProperty<Quality, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Print/Other/Quality"_ustr); return PATH; }
private:
    Quality(); // not defined
    ~Quality(); // not defined
};

struct FromPrinterSetup: public comphelper::ConfigurationProperty<FromPrinterSetup, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Print/Other/FromPrinterSetup"_ustr); return PATH; }
private:
    FromPrinterSetup(); // not defined
    ~FromPrinterSetup(); // not defined
};

struct HandoutHorizontal: public comphelper::ConfigurationProperty<HandoutHorizontal, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Print/Other/HandoutHorizontal"_ustr); return PATH; }
private:
    HandoutHorizontal(); // not defined
    ~HandoutHorizontal(); // not defined
};

struct PagesPerHandout: public comphelper::ConfigurationProperty<PagesPerHandout, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Print/Other/PagesPerHandout"_ustr); return PATH; }
private:
    PagesPerHandout(); // not defined
    ~PagesPerHandout(); // not defined
};

private:
    Other(); // not defined
    ~Other(); // not defined
};

private:
    Print(); // not defined
    ~Print(); // not defined
};

struct Filter: public comphelper::ConfigurationGroup< Filter> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Filter"_ustr); return PATH; }

struct Import: public comphelper::ConfigurationGroup< Import> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Filter/Import"_ustr); return PATH; }

struct VBA: public comphelper::ConfigurationGroup< VBA> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Filter/Import/VBA"_ustr); return PATH; }

struct Load: public comphelper::ConfigurationProperty<Load, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Filter/Import/VBA/Load"_ustr); return PATH; }
private:
    Load(); // not defined
    ~Load(); // not defined
};

struct Save: public comphelper::ConfigurationProperty<Save, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Filter/Import/VBA/Save"_ustr); return PATH; }
private:
    Save(); // not defined
    ~Save(); // not defined
};

private:
    VBA(); // not defined
    ~VBA(); // not defined
};

private:
    Import(); // not defined
    ~Import(); // not defined
};

struct Export: public comphelper::ConfigurationGroup< Export> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Filter/Export"_ustr); return PATH; }

struct LastUsed: public comphelper::ConfigurationProperty<LastUsed, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Filter/Export/LastUsed"_ustr); return PATH; }
private:
    LastUsed(); // not defined
    ~LastUsed(); // not defined
};

private:
    Export(); // not defined
    ~Export(); // not defined
};

private:
    Filter(); // not defined
    ~Filter(); // not defined
};

struct MultiPaneGUI: public comphelper::ConfigurationGroup< MultiPaneGUI> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/MultiPaneGUI"_ustr); return PATH; }

struct ToolPanel: public comphelper::ConfigurationGroup< ToolPanel> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/MultiPaneGUI/ToolPanel"_ustr); return PATH; }

struct Visible: public comphelper::ConfigurationGroup< Visible> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/MultiPaneGUI/ToolPanel/Visible"_ustr); return PATH; }

struct ImpressView: public comphelper::ConfigurationProperty<ImpressView, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/MultiPaneGUI/ToolPanel/Visible/ImpressView"_ustr); return PATH; }
private:
    ImpressView(); // not defined
    ~ImpressView(); // not defined
};

struct OutlineView: public comphelper::ConfigurationProperty<OutlineView, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/MultiPaneGUI/ToolPanel/Visible/OutlineView"_ustr); return PATH; }
private:
    OutlineView(); // not defined
    ~OutlineView(); // not defined
};

struct NotesView: public comphelper::ConfigurationProperty<NotesView, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/MultiPaneGUI/ToolPanel/Visible/NotesView"_ustr); return PATH; }
private:
    NotesView(); // not defined
    ~NotesView(); // not defined
};

struct HandoutView: public comphelper::ConfigurationProperty<HandoutView, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/MultiPaneGUI/ToolPanel/Visible/HandoutView"_ustr); return PATH; }
private:
    HandoutView(); // not defined
    ~HandoutView(); // not defined
};

struct SlideSorterView: public comphelper::ConfigurationProperty<SlideSorterView, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/MultiPaneGUI/ToolPanel/Visible/SlideSorterView"_ustr); return PATH; }
private:
    SlideSorterView(); // not defined
    ~SlideSorterView(); // not defined
};

private:
    Visible(); // not defined
    ~Visible(); // not defined
};

struct RecentlyUsedMasterPages: public comphelper::ConfigurationSet< RecentlyUsedMasterPages> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/MultiPaneGUI/ToolPanel/RecentlyUsedMasterPages"_ustr); return PATH; }
private:
    RecentlyUsedMasterPages(); // not defined
    ~RecentlyUsedMasterPages(); // not defined
};

private:
    ToolPanel(); // not defined
    ~ToolPanel(); // not defined
};

struct NotesPane: public comphelper::ConfigurationGroup< NotesPane> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/MultiPaneGUI/NotesPane"_ustr); return PATH; }

struct Visible: public comphelper::ConfigurationGroup< Visible> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/MultiPaneGUI/NotesPane/Visible"_ustr); return PATH; }

struct ImpressView: public comphelper::ConfigurationProperty<ImpressView, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/MultiPaneGUI/NotesPane/Visible/ImpressView"_ustr); return PATH; }
private:
    ImpressView(); // not defined
    ~ImpressView(); // not defined
};

struct OutlineView: public comphelper::ConfigurationProperty<OutlineView, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/MultiPaneGUI/NotesPane/Visible/OutlineView"_ustr); return PATH; }
private:
    OutlineView(); // not defined
    ~OutlineView(); // not defined
};

struct NotesView: public comphelper::ConfigurationProperty<NotesView, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/MultiPaneGUI/NotesPane/Visible/NotesView"_ustr); return PATH; }
private:
    NotesView(); // not defined
    ~NotesView(); // not defined
};

struct HandoutView: public comphelper::ConfigurationProperty<HandoutView, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/MultiPaneGUI/NotesPane/Visible/HandoutView"_ustr); return PATH; }
private:
    HandoutView(); // not defined
    ~HandoutView(); // not defined
};

private:
    Visible(); // not defined
    ~Visible(); // not defined
};

private:
    NotesPane(); // not defined
    ~NotesPane(); // not defined
};

struct SlideSorterBar: public comphelper::ConfigurationGroup< SlideSorterBar> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/MultiPaneGUI/SlideSorterBar"_ustr); return PATH; }

struct Visible: public comphelper::ConfigurationGroup< Visible> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/MultiPaneGUI/SlideSorterBar/Visible"_ustr); return PATH; }

struct ImpressView: public comphelper::ConfigurationProperty<ImpressView, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/MultiPaneGUI/SlideSorterBar/Visible/ImpressView"_ustr); return PATH; }
private:
    ImpressView(); // not defined
    ~ImpressView(); // not defined
};

struct OutlineView: public comphelper::ConfigurationProperty<OutlineView, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/MultiPaneGUI/SlideSorterBar/Visible/OutlineView"_ustr); return PATH; }
private:
    OutlineView(); // not defined
    ~OutlineView(); // not defined
};

struct NotesView: public comphelper::ConfigurationProperty<NotesView, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/MultiPaneGUI/SlideSorterBar/Visible/NotesView"_ustr); return PATH; }
private:
    NotesView(); // not defined
    ~NotesView(); // not defined
};

struct HandoutView: public comphelper::ConfigurationProperty<HandoutView, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/MultiPaneGUI/SlideSorterBar/Visible/HandoutView"_ustr); return PATH; }
private:
    HandoutView(); // not defined
    ~HandoutView(); // not defined
};

struct SlideSorterView: public comphelper::ConfigurationProperty<SlideSorterView, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/MultiPaneGUI/SlideSorterBar/Visible/SlideSorterView"_ustr); return PATH; }
private:
    SlideSorterView(); // not defined
    ~SlideSorterView(); // not defined
};

struct DrawView: public comphelper::ConfigurationProperty<DrawView, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/MultiPaneGUI/SlideSorterBar/Visible/DrawView"_ustr); return PATH; }
private:
    DrawView(); // not defined
    ~DrawView(); // not defined
};

private:
    Visible(); // not defined
    ~Visible(); // not defined
};

struct PreviewCache: public comphelper::ConfigurationGroup< PreviewCache> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/MultiPaneGUI/SlideSorterBar/PreviewCache"_ustr); return PATH; }

struct CacheSize: public comphelper::ConfigurationProperty<CacheSize, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/MultiPaneGUI/SlideSorterBar/PreviewCache/CacheSize"_ustr); return PATH; }
private:
    CacheSize(); // not defined
    ~CacheSize(); // not defined
};

struct CompactionPolicy: public comphelper::ConfigurationProperty<CompactionPolicy, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/MultiPaneGUI/SlideSorterBar/PreviewCache/CompactionPolicy"_ustr); return PATH; }
private:
    CompactionPolicy(); // not defined
    ~CompactionPolicy(); // not defined
};

struct CompressionPolicy: public comphelper::ConfigurationProperty<CompressionPolicy, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/MultiPaneGUI/SlideSorterBar/PreviewCache/CompressionPolicy"_ustr); return PATH; }
private:
    CompressionPolicy(); // not defined
    ~CompressionPolicy(); // not defined
};

private:
    PreviewCache(); // not defined
    ~PreviewCache(); // not defined
};

private:
    SlideSorterBar(); // not defined
    ~SlideSorterBar(); // not defined
};

private:
    MultiPaneGUI(); // not defined
    ~MultiPaneGUI(); // not defined
};

struct Pictures: public comphelper::ConfigurationGroup< Pictures> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Pictures"_ustr); return PATH; }

struct Path: public comphelper::ConfigurationProperty<Path, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Impress/Pictures/Path"_ustr); return PATH; }
private:
    Path(); // not defined
    ~Path(); // not defined
};

private:
    Pictures(); // not defined
    ~Pictures(); // not defined
};

} } }

#endif
