#include <sal/types.h>


#include <rtl/ustring.hxx>


extern "C" {

static constexpr OUStringLiteral langID = u"\x0065\x006e";
static constexpr OUStringLiteral langDefaultName = u"\x0045\x006e\x0067\x006c\x0069\x0073\x0068";
static constexpr OUStringLiteral countryID = u"\x004e\x0047";
static constexpr OUStringLiteral countryDefaultName = u"\x004e\x0069\x0067\x0065\x0072\x0069\x0061";
static constexpr OUStringLiteral Variant = u"";

static constexpr OUString LCInfoArray[] = {
	langID,
	langDefaultName,
	countryID,
	countryDefaultName,
	Variant
};

SAL_DLLPUBLIC_EXPORT OUString const *  getLCInfo_en_NG(sal_Int16& count)
{
	count = std::size(LCInfoArray);
	return (OUString const *)LCInfoArray;
}
extern const OUString *  getLocaleItem_en_GB(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getLocaleItem_en_NG(sal_Int16& count)
{
	return getLocaleItem_en_GB(count);
}
static const sal_Unicode replaceTo0[] = {0x5b, 0x24, 0x20a6, 0x2d, 0x41, 0x38, 0x30, 0x39, 0x5d, 0x0};
extern OUString const * getAllFormats0_en_GB(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to);
SAL_DLLPUBLIC_EXPORT OUString const * getAllFormats0_en_NG(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to)
{
	to = replaceTo0;
	const sal_Unicode* tmp;
	return getAllFormats0_en_GB(count, from, tmp);
}
extern const OUString *  getDateAcceptancePatterns_en_GB(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getDateAcceptancePatterns_en_NG(sal_Int16& count)
{
	return getDateAcceptancePatterns_en_GB(count);
}
extern const OUString *  getCollatorImplementation_en_GB(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollatorImplementation_en_NG(sal_Int16& count)
{
	return getCollatorImplementation_en_GB(count);
}
extern const OUString *  getCollationOptions_en_GB(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollationOptions_en_NG(sal_Int16& count)
{
	return getCollationOptions_en_GB(count);
}
extern const OUString *  getSearchOptions_en_GB(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getSearchOptions_en_NG(sal_Int16& count)
{
	return getSearchOptions_en_GB(count);
}
extern const OUString *  getIndexAlgorithm_en_GB(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getIndexAlgorithm_en_NG(sal_Int16& count)
{
	return getIndexAlgorithm_en_GB(count);
}
extern const OUString *  getUnicodeScripts_en_GB(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getUnicodeScripts_en_NG(sal_Int16& count)
{
	return getUnicodeScripts_en_GB(count);
}
extern const OUString *  getFollowPageWords_en_GB(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getFollowPageWords_en_NG(sal_Int16& count)
{
	return getFollowPageWords_en_GB(count);
}
extern const OUString *  getAllCalendars_en_GB(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getAllCalendars_en_NG(sal_Int16& count)
{
	return getAllCalendars_en_GB(count);
}
static constexpr OUStringLiteral defaultCurrency0 = u"\x1";
static constexpr OUStringLiteral defaultCurrencyUsedInCompatibleFormatCodes0 = u"\x1";
static constexpr OUStringLiteral defaultCurrencyLegacyOnly0 = u"\x0";
static constexpr OUStringLiteral currencyID0 = u"\x004e\x0047\x004e";
static constexpr OUStringLiteral currencySymbol0 = u"\x20a6";
static constexpr OUStringLiteral bankSymbol0 = u"\x004e\x0047\x004e";
static constexpr OUStringLiteral currencyName0 = u"\x004e\x0061\x0069\x0072\x0061";
static constexpr OUStringLiteral currencyDecimalPlaces0 = u"\x2";

static const sal_Int16 currencyCount = 1;

static constexpr OUString currencies[] = {
	currencyID0,
	currencySymbol0,
	bankSymbol0,
	currencyName0,
	defaultCurrency0,
	defaultCurrencyUsedInCompatibleFormatCodes0,
	currencyDecimalPlaces0,
	defaultCurrencyLegacyOnly0,
};

SAL_DLLPUBLIC_EXPORT OUString const *  getAllCurrencies_en_NG(sal_Int16& count)
{
	count = currencyCount;
	return (OUString const *)currencies;
}
extern const OUString *  getTransliterations_en_GB(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getTransliterations_en_NG(sal_Int16& count)
{
	return getTransliterations_en_GB(count);
}
extern const OUString *  getForbiddenCharacters_en_GB(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getForbiddenCharacters_en_NG(sal_Int16& count)
{
	return getForbiddenCharacters_en_GB(count);
}
extern const OUString *  getBreakIteratorRules_en_GB(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getBreakIteratorRules_en_NG(sal_Int16& count)
{
	return getBreakIteratorRules_en_GB(count);
}
extern const OUString *  getReservedWords_en_GB(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getReservedWords_en_NG(sal_Int16& count)
{
	return getReservedWords_en_GB(count);
}
// ---> ContinuousNumbering
extern const OUString **  getContinuousNumberingLevels_en_GB(sal_Int16& nStyles, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString **  getContinuousNumberingLevels_en_NG(sal_Int16& nStyles, sal_Int16& nAttributes)
{
	return getContinuousNumberingLevels_en_GB(nStyles, nAttributes);
}
// ---> OutlineNumbering
extern const OUString ***  getOutlineNumberingLevels_en_GB(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString ***  getOutlineNumberingLevels_en_NG(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes)
{
	return getOutlineNumberingLevels_en_GB(nStyles, nLevels, nAttributes);
}
} // extern "C"

