/* SPDX-License-Identifier: (LGPL-2.1 OR BSD-2-Clause) */

/* THIS FILE IS AUTOGENERATED BY BPFTOOL! */
#ifndef __DISK_BPF_SKEL_H__
#define __DISK_BPF_SKEL_H__

#include <errno.h>
#include <stdlib.h>
#include <bpf/libbpf.h>

struct disk_bpf {
	struct bpf_object_skeleton *skeleton;
	struct bpf_object *obj;
	struct {
		struct bpf_map *tmp_disk_tp_stat;
		struct bpf_map *disk_ctrl;
		struct bpf_map *tbl_disk_iocall;
	} maps;
	struct {
		struct bpf_program *netdata_block_rq_issue;
		struct bpf_program *netdata_block_rq_complete;
	} progs;
	struct {
		struct bpf_link *netdata_block_rq_issue;
		struct bpf_link *netdata_block_rq_complete;
	} links;

#ifdef __cplusplus
	static inline struct disk_bpf *open(const struct bpf_object_open_opts *opts = nullptr);
	static inline struct disk_bpf *open_and_load();
	static inline int load(struct disk_bpf *skel);
	static inline int attach(struct disk_bpf *skel);
	static inline void detach(struct disk_bpf *skel);
	static inline void destroy(struct disk_bpf *skel);
	static inline const void *elf_bytes(size_t *sz);
#endif /* __cplusplus */
};

static void
disk_bpf__destroy(struct disk_bpf *obj)
{
	if (!obj)
		return;
	if (obj->skeleton)
		bpf_object__destroy_skeleton(obj->skeleton);
	free(obj);
}

static inline int
disk_bpf__create_skeleton(struct disk_bpf *obj);

static inline struct disk_bpf *
disk_bpf__open_opts(const struct bpf_object_open_opts *opts)
{
	struct disk_bpf *obj;
	int err;

	obj = (struct disk_bpf *)calloc(1, sizeof(*obj));
	if (!obj) {
		errno = ENOMEM;
		return NULL;
	}

	err = disk_bpf__create_skeleton(obj);
	if (err)
		goto err_out;

	err = bpf_object__open_skeleton(obj->skeleton, opts);
	if (err)
		goto err_out;

	return obj;
err_out:
	disk_bpf__destroy(obj);
	errno = -err;
	return NULL;
}

static inline struct disk_bpf *
disk_bpf__open(void)
{
	return disk_bpf__open_opts(NULL);
}

static inline int
disk_bpf__load(struct disk_bpf *obj)
{
	return bpf_object__load_skeleton(obj->skeleton);
}

static inline struct disk_bpf *
disk_bpf__open_and_load(void)
{
	struct disk_bpf *obj;
	int err;

	obj = disk_bpf__open();
	if (!obj)
		return NULL;
	err = disk_bpf__load(obj);
	if (err) {
		disk_bpf__destroy(obj);
		errno = -err;
		return NULL;
	}
	return obj;
}

static inline int
disk_bpf__attach(struct disk_bpf *obj)
{
	return bpf_object__attach_skeleton(obj->skeleton);
}

static inline void
disk_bpf__detach(struct disk_bpf *obj)
{
	bpf_object__detach_skeleton(obj->skeleton);
}

static inline const void *disk_bpf__elf_bytes(size_t *sz);

static inline int
disk_bpf__create_skeleton(struct disk_bpf *obj)
{
	struct bpf_object_skeleton *s;
	int err;

	s = (struct bpf_object_skeleton *)calloc(1, sizeof(*s));
	if (!s)	{
		err = -ENOMEM;
		goto err;
	}

	s->sz = sizeof(*s);
	s->name = "disk_bpf";
	s->obj = &obj->obj;

	/* maps */
	s->map_cnt = 3;
	s->map_skel_sz = sizeof(*s->maps);
	s->maps = (struct bpf_map_skeleton *)calloc(s->map_cnt, s->map_skel_sz);
	if (!s->maps) {
		err = -ENOMEM;
		goto err;
	}

	s->maps[0].name = "tmp_disk_tp_stat";
	s->maps[0].map = &obj->maps.tmp_disk_tp_stat;

	s->maps[1].name = "disk_ctrl";
	s->maps[1].map = &obj->maps.disk_ctrl;

	s->maps[2].name = "tbl_disk_iocall";
	s->maps[2].map = &obj->maps.tbl_disk_iocall;

	/* programs */
	s->prog_cnt = 2;
	s->prog_skel_sz = sizeof(*s->progs);
	s->progs = (struct bpf_prog_skeleton *)calloc(s->prog_cnt, s->prog_skel_sz);
	if (!s->progs) {
		err = -ENOMEM;
		goto err;
	}

	s->progs[0].name = "netdata_block_rq_issue";
	s->progs[0].prog = &obj->progs.netdata_block_rq_issue;
	s->progs[0].link = &obj->links.netdata_block_rq_issue;

	s->progs[1].name = "netdata_block_rq_complete";
	s->progs[1].prog = &obj->progs.netdata_block_rq_complete;
	s->progs[1].link = &obj->links.netdata_block_rq_complete;

	s->data = disk_bpf__elf_bytes(&s->data_sz);

	obj->skeleton = s;
	return 0;
err:
	bpf_object__destroy_skeleton(s);
	return err;
}

static inline const void *disk_bpf__elf_bytes(size_t *sz)
{
	static const char data[] __attribute__((__aligned__(8))) = "\
\x7f\x45\x4c\x46\x02\x01\x01\0\0\0\0\0\0\0\0\0\x01\0\xf7\0\x01\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x48\x23\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\x40\0\x0f\0\
\x01\0\x61\x12\x08\0\0\0\0\0\x15\x02\x28\0\0\0\0\0\xb7\x03\0\0\0\0\0\0\x7b\x3a\
\xe0\xff\0\0\0\0\x63\x2a\xe0\xff\0\0\0\0\x79\x11\x10\0\0\0\0\0\x7b\x1a\xe8\xff\
\0\0\0\0\x85\0\0\0\x05\0\0\0\x7b\x0a\xd8\xff\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\
\x02\0\0\xe0\xff\xff\xff\xbf\xa3\0\0\0\0\0\0\x07\x03\0\0\xd8\xff\xff\xff\x18\
\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb7\x04\0\0\0\0\0\0\x85\0\0\0\x02\0\0\0\xb7\
\x01\0\0\x02\0\0\0\x63\x1a\xfc\xff\0\0\0\0\xb7\x06\0\0\x01\0\0\0\x7b\x6a\xf0\
\xff\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xfc\xff\xff\xff\x18\x01\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\0\x15\0\x07\0\0\0\0\0\xdb\x60\0\0\0\0\0\0\
\x79\x01\0\0\0\0\0\0\xb7\x02\0\0\xfe\xff\xff\xff\x2d\x12\x0b\0\0\0\0\0\xb7\x01\
\0\0\x01\0\0\0\x7b\x10\0\0\0\0\0\0\x05\0\x08\0\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\
\x02\0\0\xfc\xff\xff\xff\xbf\xa3\0\0\0\0\0\0\x07\x03\0\0\xf0\xff\xff\xff\x18\
\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb7\x04\0\0\x02\0\0\0\x85\0\0\0\x02\0\0\0\xb7\
\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\xbf\x16\0\0\0\0\0\0\xb7\x01\0\0\0\0\0\0\x7b\
\x1a\xe0\xff\0\0\0\0\x61\x61\x08\0\0\0\0\0\x63\x1a\xe0\xff\0\0\0\0\x79\x61\x10\
\0\0\0\0\0\x7b\x1a\xe8\xff\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xe0\xff\xff\
\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\0\xbf\x07\0\0\0\0\0\
\0\x15\x07\x86\0\0\0\0\0\x85\0\0\0\x05\0\0\0\x79\x71\0\0\0\0\0\0\x1f\x10\0\0\0\
\0\0\0\x37\0\0\0\xe8\x03\0\0\xbf\x02\0\0\0\0\0\0\x77\x02\0\0\x20\0\0\0\x15\x02\
\x1b\0\0\0\0\0\xb7\x03\0\0\x01\0\0\0\xb7\x01\0\0\x01\0\0\0\x25\x02\x01\0\xff\
\xff\0\0\xb7\x01\0\0\0\0\0\0\x67\x01\0\0\x04\0\0\0\x7f\x12\0\0\0\0\0\0\xb7\x04\
\0\0\x01\0\0\0\x25\x02\x01\0\xff\0\0\0\xb7\x04\0\0\0\0\0\0\x67\x04\0\0\x03\0\0\
\0\x7f\x42\0\0\0\0\0\0\xb7\x05\0\0\x01\0\0\0\x25\x02\x01\0\x0f\0\0\0\xb7\x05\0\
\0\0\0\0\0\x67\x05\0\0\x02\0\0\0\x7f\x52\0\0\0\0\0\0\x25\x02\x01\0\x03\0\0\0\
\xb7\x03\0\0\0\0\0\0\x67\x03\0\0\x01\0\0\0\x7f\x32\0\0\0\0\0\0\x77\x02\0\0\x01\
\0\0\0\x4f\x21\0\0\0\0\0\0\x4f\x41\0\0\0\0\0\0\x4f\x51\0\0\0\0\0\0\x4f\x31\0\0\
\0\0\0\0\x07\x01\0\0\x20\0\0\0\x05\0\x1b\0\0\0\0\0\x67\0\0\0\x20\0\0\0\x77\0\0\
\0\x20\0\0\0\xb7\x02\0\0\x01\0\0\0\xb7\x01\0\0\x01\0\0\0\x25\0\x01\0\xff\xff\0\
\0\xb7\x01\0\0\0\0\0\0\x67\x01\0\0\x04\0\0\0\x7f\x10\0\0\0\0\0\0\xb7\x03\0\0\
\x01\0\0\0\x25\0\x01\0\xff\0\0\0\xb7\x03\0\0\0\0\0\0\x67\x03\0\0\x03\0\0\0\x7f\
\x30\0\0\0\0\0\0\xb7\x04\0\0\x01\0\0\0\x25\0\x01\0\x0f\0\0\0\xb7\x04\0\0\0\0\0\
\0\x67\x04\0\0\x02\0\0\0\x7f\x40\0\0\0\0\0\0\x25\0\x01\0\x03\0\0\0\xb7\x02\0\0\
\0\0\0\0\x67\x02\0\0\x01\0\0\0\x7f\x20\0\0\0\0\0\0\x77\0\0\0\x01\0\0\0\x4f\x01\
\0\0\0\0\0\0\x4f\x31\0\0\0\0\0\0\x4f\x41\0\0\0\0\0\0\x4f\x21\0\0\0\0\0\0\x67\
\x01\0\0\x20\0\0\0\x77\x01\0\0\x20\0\0\0\xb7\x02\0\0\x17\0\0\0\x2d\x12\x01\0\0\
\0\0\0\xb7\x01\0\0\x17\0\0\0\x63\x1a\xd8\xff\0\0\0\0\x61\x61\x08\0\0\0\0\0\xbf\
\x12\0\0\0\0\0\0\x67\x02\0\0\x0c\0\0\0\x18\x03\0\0\0\0\xf0\xff\0\0\0\0\0\0\0\0\
\x5f\x32\0\0\0\0\0\0\xbf\x13\0\0\0\0\0\0\x57\x03\0\0\xff\0\0\0\x77\x01\0\0\x0c\
\0\0\0\x57\x01\0\0\0\xff\x0f\0\x4f\x31\0\0\0\0\0\0\x4f\x21\0\0\0\0\0\0\x63\x1a\
\xdc\xff\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xd8\xff\xff\xff\x18\x01\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\0\x15\0\x08\0\0\0\0\0\xb7\x01\0\0\x01\
\0\0\0\xb7\x02\0\0\x01\0\0\0\xdb\x20\0\0\0\0\0\0\x79\x02\0\0\0\0\0\0\xb7\x03\0\
\0\xfe\xff\xff\xff\x2d\x23\x0c\0\0\0\0\0\x7b\x10\0\0\0\0\0\0\x05\0\x0a\0\0\0\0\
\0\xb7\x01\0\0\x01\0\0\0\x7b\x1a\xd0\xff\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\
\0\xd8\xff\xff\xff\xbf\xa3\0\0\0\0\0\0\x07\x03\0\0\xd0\xff\xff\xff\x18\x01\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\xb7\x04\0\0\0\0\0\0\x85\0\0\0\x02\0\0\0\xbf\xa2\0\0\0\
\0\0\0\x07\x02\0\0\xe0\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\
\0\x03\0\0\0\xb7\x01\0\0\x03\0\0\0\x63\x1a\xfc\xff\0\0\0\0\xb7\x06\0\0\x01\0\0\
\0\x7b\x6a\xf0\xff\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xfc\xff\xff\xff\x18\
\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\0\x15\0\x07\0\0\0\0\0\xdb\
\x60\0\0\0\0\0\0\x79\x01\0\0\0\0\0\0\xb7\x02\0\0\xfe\xff\xff\xff\x2d\x12\x0b\0\
\0\0\0\0\xb7\x01\0\0\x01\0\0\0\x7b\x10\0\0\0\0\0\0\x05\0\x08\0\0\0\0\0\xbf\xa2\
\0\0\0\0\0\0\x07\x02\0\0\xfc\xff\xff\xff\xbf\xa3\0\0\0\0\0\0\x07\x03\0\0\xf0\
\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb7\x04\0\0\x02\0\0\0\x85\0\0\
\0\x02\0\0\0\xb7\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\x47\x50\x4c\0\x9f\xeb\x01\0\x18\0\0\0\0\0\0\0\x90\x04\0\0\x90\x04\0\0\
\xcd\x07\0\0\0\0\0\0\0\0\0\x02\x03\0\0\0\x01\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\
\x01\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\x05\0\0\0\x05\0\0\0\0\0\0\
\x01\x04\0\0\0\x20\0\0\0\0\0\0\0\0\0\0\x02\x06\0\0\0\x19\0\0\0\0\0\0\x08\x07\0\
\0\0\x2c\0\0\0\x02\0\0\x04\x10\0\0\0\x3d\0\0\0\x08\0\0\0\0\0\0\0\x41\0\0\0\x0d\
\0\0\0\x40\0\0\0\x48\0\0\0\0\0\0\x08\x09\0\0\0\x4e\0\0\0\0\0\0\x08\x0a\0\0\0\
\x5d\0\0\0\0\0\0\x08\x0b\0\0\0\x61\0\0\0\0\0\0\x08\x0c\0\0\0\x67\0\0\0\0\0\0\
\x01\x04\0\0\0\x20\0\0\0\x74\0\0\0\0\0\0\x08\x0e\0\0\0\x7d\0\0\0\0\0\0\x08\x0f\
\0\0\0\x81\0\0\0\0\0\0\x08\x10\0\0\0\x87\0\0\0\0\0\0\x01\x08\0\0\0\x40\0\0\0\0\
\0\0\0\0\0\0\x02\x0f\0\0\0\0\0\0\0\0\0\0\x02\x13\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\
\0\x02\0\0\0\x04\0\0\0\0\x20\0\0\0\0\0\0\x04\0\0\x04\x20\0\0\0\x9a\0\0\0\x01\0\
\0\0\0\0\0\0\x9f\0\0\0\x05\0\0\0\x40\0\0\0\xa3\0\0\0\x11\0\0\0\x80\0\0\0\xa9\0\
\0\0\x12\0\0\0\xc0\0\0\0\xb5\0\0\0\0\0\0\x0e\x14\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\
\x02\x17\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\x02\0\0\0\0\0\0\0\
\0\0\0\x02\x0b\0\0\0\0\0\0\0\0\0\0\x02\x1a\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x02\
\0\0\0\x04\0\0\0\x06\0\0\0\0\0\0\0\x04\0\0\x04\x20\0\0\0\x9a\0\0\0\x16\0\0\0\0\
\0\0\0\x9f\0\0\0\x18\0\0\0\x40\0\0\0\xa3\0\0\0\x11\0\0\0\x80\0\0\0\xa9\0\0\0\
\x19\0\0\0\xc0\0\0\0\xc6\0\0\0\0\0\0\x0e\x1b\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x02\
\x1e\0\0\0\xd0\0\0\0\0\0\0\x08\x1f\0\0\0\xdc\0\0\0\x02\0\0\x04\x08\0\0\0\xe6\0\
\0\0\x0b\0\0\0\0\0\0\0\x3d\0\0\0\x0a\0\0\0\x20\0\0\0\0\0\0\0\0\0\0\x02\x21\0\0\
\0\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\0\x18\0\0\0\0\0\0\x04\0\0\x04\
\x20\0\0\0\x9a\0\0\0\x01\0\0\0\0\0\0\0\x9f\0\0\0\x1d\0\0\0\x40\0\0\0\xa3\0\0\0\
\x11\0\0\0\x80\0\0\0\xa9\0\0\0\x20\0\0\0\xc0\0\0\0\xea\0\0\0\0\0\0\x0e\x22\0\0\
\0\x01\0\0\0\0\0\0\0\0\0\0\x02\x25\0\0\0\xfa\0\0\0\x08\0\0\x04\x40\0\0\0\x11\
\x01\0\0\x0e\0\0\0\0\0\0\0\x3d\0\0\0\x08\0\0\0\x40\0\0\0\x41\0\0\0\x0d\0\0\0\
\x80\0\0\0\x15\x01\0\0\x0c\0\0\0\xc0\0\0\0\x1f\x01\0\0\x0c\0\0\0\xe0\0\0\0\x25\
\x01\0\0\x27\0\0\0\0\x01\0\0\x2a\x01\0\0\x28\0\0\0\x40\x01\0\0\x2f\x01\0\0\x02\
\0\0\0\xc0\x01\0\0\x3d\x01\0\0\0\0\0\x01\x01\0\0\0\x08\0\0\x01\0\0\0\0\0\0\0\
\x03\0\0\0\0\x26\0\0\0\x04\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x26\0\0\0\
\x04\0\0\0\x10\0\0\0\0\0\0\0\x01\0\0\x0d\x02\0\0\0\x42\x01\0\0\x24\0\0\0\xfa\0\
\0\0\x01\0\0\x0c\x29\0\0\0\0\0\0\0\0\0\0\x02\x2c\0\0\0\x73\x03\0\0\x07\0\0\x04\
\x30\0\0\0\x11\x01\0\0\x0e\0\0\0\0\0\0\0\x3d\0\0\0\x08\0\0\0\x40\0\0\0\x41\0\0\
\0\x0d\0\0\0\x80\0\0\0\x15\x01\0\0\x0c\0\0\0\xc0\0\0\0\x8d\x03\0\0\x02\0\0\0\
\xe0\0\0\0\x25\x01\0\0\x27\0\0\0\0\x01\0\0\x2f\x01\0\0\x02\0\0\0\x40\x01\0\0\0\
\0\0\0\x01\0\0\x0d\x02\0\0\0\x42\x01\0\0\x2b\0\0\0\x73\x03\0\0\x01\0\0\x0c\x2d\
\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x26\0\0\0\x04\0\0\0\x04\0\0\0\xb6\x07\0\0\0\0\
\0\x0e\x2f\0\0\0\x01\0\0\0\xbf\x07\0\0\x03\0\0\x0f\0\0\0\0\x15\0\0\0\0\0\0\0\
\x20\0\0\0\x1c\0\0\0\0\0\0\0\x20\0\0\0\x23\0\0\0\0\0\0\0\x20\0\0\0\xc5\x07\0\0\
\x01\0\0\x0f\0\0\0\0\x30\0\0\0\0\0\0\0\x04\0\0\0\0\x69\x6e\x74\0\x5f\x5f\x41\
\x52\x52\x41\x59\x5f\x53\x49\x5a\x45\x5f\x54\x59\x50\x45\x5f\x5f\0\x6e\x65\x74\
\x64\x61\x74\x61\x5f\x64\x69\x73\x6b\x5f\x6b\x65\x79\x5f\x74\0\x6e\x65\x74\x64\
\x61\x74\x61\x5f\x64\x69\x73\x6b\x5f\x6b\x65\x79\0\x64\x65\x76\0\x73\x65\x63\
\x74\x6f\x72\0\x64\x65\x76\x5f\x74\0\x5f\x5f\x6b\x65\x72\x6e\x65\x6c\x5f\x64\
\x65\x76\x5f\x74\0\x75\x33\x32\0\x5f\x5f\x75\x33\x32\0\x75\x6e\x73\x69\x67\x6e\
\x65\x64\x20\x69\x6e\x74\0\x73\x65\x63\x74\x6f\x72\x5f\x74\0\x75\x36\x34\0\x5f\
\x5f\x75\x36\x34\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x6c\x6f\x6e\x67\x20\x6c\
\x6f\x6e\x67\0\x74\x79\x70\x65\0\x6b\x65\x79\0\x76\x61\x6c\x75\x65\0\x6d\x61\
\x78\x5f\x65\x6e\x74\x72\x69\x65\x73\0\x74\x6d\x70\x5f\x64\x69\x73\x6b\x5f\x74\
\x70\x5f\x73\x74\x61\x74\0\x64\x69\x73\x6b\x5f\x63\x74\x72\x6c\0\x62\x6c\x6f\
\x63\x6b\x5f\x6b\x65\x79\x5f\x74\0\x62\x6c\x6f\x63\x6b\x5f\x6b\x65\x79\0\x62\
\x69\x6e\0\x74\x62\x6c\x5f\x64\x69\x73\x6b\x5f\x69\x6f\x63\x61\x6c\x6c\0\x6e\
\x65\x74\x64\x61\x74\x61\x5f\x62\x6c\x6f\x63\x6b\x5f\x72\x71\x5f\x69\x73\x73\
\x75\x65\0\x70\x61\x64\0\x6e\x72\x5f\x73\x65\x63\x74\x6f\x72\0\x62\x79\x74\x65\
\x73\0\x72\x77\x62\x73\0\x63\x6f\x6d\x6d\0\x64\x61\x74\x61\x5f\x6c\x6f\x63\x5f\
\x6e\x61\x6d\x65\0\x63\x68\x61\x72\0\x70\x74\x72\0\x74\x72\x61\x63\x65\x70\x6f\
\x69\x6e\x74\x2f\x62\x6c\x6f\x63\x6b\x2f\x62\x6c\x6f\x63\x6b\x5f\x72\x71\x5f\
\x69\x73\x73\x75\x65\0\x2f\x65\x62\x70\x66\x2d\x63\x6f\x2d\x72\x65\x2f\x73\x72\
\x63\x2f\x64\x69\x73\x6b\x2e\x62\x70\x66\x2e\x63\0\x20\x20\x20\x20\x69\x66\x20\
\x28\x21\x70\x74\x72\x2d\x3e\x64\x65\x76\x29\0\x20\x20\x20\x20\x6e\x65\x74\x64\
\x61\x74\x61\x5f\x64\x69\x73\x6b\x5f\x6b\x65\x79\x5f\x74\x20\x6b\x65\x79\x20\
\x3d\x20\x7b\x7d\x3b\0\x20\x20\x20\x20\x6b\x65\x79\x2e\x64\x65\x76\x20\x3d\x20\
\x70\x74\x72\x2d\x3e\x64\x65\x76\x3b\0\x20\x20\x20\x20\x6b\x65\x79\x2e\x73\x65\
\x63\x74\x6f\x72\x20\x3d\x20\x70\x74\x72\x2d\x3e\x73\x65\x63\x74\x6f\x72\x3b\0\
\x20\x20\x20\x20\x5f\x5f\x75\x36\x34\x20\x76\x61\x6c\x75\x65\x20\x3d\x20\x62\
\x70\x66\x5f\x6b\x74\x69\x6d\x65\x5f\x67\x65\x74\x5f\x6e\x73\x28\x29\x3b\0\x20\
\x20\x20\x20\x62\x70\x66\x5f\x6d\x61\x70\x5f\x75\x70\x64\x61\x74\x65\x5f\x65\
\x6c\x65\x6d\x28\x26\x74\x6d\x70\x5f\x64\x69\x73\x6b\x5f\x74\x70\x5f\x73\x74\
\x61\x74\x2c\x20\x26\x6b\x65\x79\x2c\x20\x26\x76\x61\x6c\x75\x65\x2c\x20\x42\
\x50\x46\x5f\x41\x4e\x59\x29\x3b\0\x2f\x65\x62\x70\x66\x2d\x63\x6f\x2d\x72\x65\
\x2f\x73\x72\x63\x2f\x2e\x2e\x2f\x6b\x65\x72\x6e\x65\x6c\x2d\x63\x6f\x6c\x6c\
\x65\x63\x74\x6f\x72\x2f\x69\x6e\x63\x6c\x75\x64\x65\x73\x2f\x6e\x65\x74\x64\
\x61\x74\x61\x5f\x63\x6f\x6d\x6d\x6f\x6e\x2e\x68\0\x20\x20\x20\x20\x72\x65\x73\
\x20\x3d\x20\x62\x70\x66\x5f\x6d\x61\x70\x5f\x6c\x6f\x6f\x6b\x75\x70\x5f\x65\
\x6c\x65\x6d\x28\x74\x62\x6c\x2c\x20\x26\x6b\x65\x79\x29\x3b\0\x20\x20\x20\x20\
\x69\x66\x20\x28\x72\x65\x73\x29\0\x20\x20\x20\x20\x5f\x5f\x73\x79\x6e\x63\x5f\
\x66\x65\x74\x63\x68\x5f\x61\x6e\x64\x5f\x61\x64\x64\x28\x72\x65\x73\x2c\x20\
\x76\x61\x6c\x75\x65\x29\x3b\0\x20\x20\x20\x20\x69\x66\x20\x28\x20\x28\x30\x78\
\x46\x46\x46\x46\x46\x46\x46\x46\x46\x46\x46\x46\x46\x46\x46\x46\x20\x2d\x20\
\x2a\x72\x65\x73\x29\x20\x3c\x3d\x20\x76\x61\x6c\x75\x65\x29\x20\x7b\0\x20\x20\
\x20\x20\x20\x20\x20\x20\x2a\x72\x65\x73\x20\x3d\x20\x76\x61\x6c\x75\x65\x3b\0\
\x20\x20\x20\x20\x20\x20\x20\x20\x62\x70\x66\x5f\x6d\x61\x70\x5f\x75\x70\x64\
\x61\x74\x65\x5f\x65\x6c\x65\x6d\x28\x74\x62\x6c\x2c\x20\x26\x6b\x65\x79\x2c\
\x20\x26\x76\x61\x6c\x75\x65\x2c\x20\x42\x50\x46\x5f\x45\x58\x49\x53\x54\x29\
\x3b\0\x7d\0\x6e\x65\x74\x64\x61\x74\x61\x5f\x62\x6c\x6f\x63\x6b\x5f\x72\x71\
\x5f\x63\x6f\x6d\x70\x6c\x65\x74\x65\0\x65\x72\x72\x6f\x72\0\x74\x72\x61\x63\
\x65\x70\x6f\x69\x6e\x74\x2f\x62\x6c\x6f\x63\x6b\x2f\x62\x6c\x6f\x63\x6b\x5f\
\x72\x71\x5f\x63\x6f\x6d\x70\x6c\x65\x74\x65\0\x69\x6e\x74\x20\x6e\x65\x74\x64\
\x61\x74\x61\x5f\x62\x6c\x6f\x63\x6b\x5f\x72\x71\x5f\x63\x6f\x6d\x70\x6c\x65\
\x74\x65\x28\x73\x74\x72\x75\x63\x74\x20\x6e\x65\x74\x64\x61\x74\x61\x5f\x62\
\x6c\x6f\x63\x6b\x5f\x72\x71\x5f\x63\x6f\x6d\x70\x6c\x65\x74\x65\x20\x2a\x70\
\x74\x72\x29\0\x20\x20\x20\x20\x66\x69\x6c\x6c\x20\x3d\x20\x62\x70\x66\x5f\x6d\
\x61\x70\x5f\x6c\x6f\x6f\x6b\x75\x70\x5f\x65\x6c\x65\x6d\x28\x26\x74\x6d\x70\
\x5f\x64\x69\x73\x6b\x5f\x74\x70\x5f\x73\x74\x61\x74\x20\x2c\x26\x6b\x65\x79\
\x29\x3b\0\x20\x20\x20\x20\x69\x66\x20\x28\x21\x66\x69\x6c\x6c\x29\0\x20\x20\
\x20\x20\x75\x36\x34\x20\x63\x75\x72\x72\x20\x3d\x20\x62\x70\x66\x5f\x6b\x74\
\x69\x6d\x65\x5f\x67\x65\x74\x5f\x6e\x73\x28\x29\x3b\0\x20\x20\x20\x20\x63\x75\
\x72\x72\x20\x2d\x3d\x20\x2a\x66\x69\x6c\x6c\x3b\0\x20\x20\x20\x20\x63\x75\x72\
\x72\x20\x2f\x3d\x20\x31\x30\x30\x30\x3b\0\x20\x20\x20\x20\x75\x6e\x73\x69\x67\
\x6e\x65\x64\x20\x69\x6e\x74\x20\x68\x69\x20\x3d\x20\x76\x20\x3e\x3e\x20\x33\
\x32\x3b\0\x20\x20\x20\x20\x69\x66\x20\x28\x68\x69\x29\0\x20\x20\x20\x20\x72\
\x20\x3d\x20\x28\x76\x20\x3e\x20\x30\x78\x46\x46\x46\x46\x29\x20\x3c\x3c\x20\
\x34\x3b\x20\x76\x20\x3e\x3e\x3d\x20\x72\x3b\0\x20\x20\x20\x20\x73\x68\x69\x66\
\x74\x20\x3d\x20\x28\x76\x20\x3e\x20\x30\x78\x46\x46\x29\x20\x3c\x3c\x20\x33\
\x3b\x20\x76\x20\x3e\x3e\x3d\x20\x73\x68\x69\x66\x74\x3b\x20\x72\x20\x7c\x3d\
\x20\x73\x68\x69\x66\x74\x3b\0\x20\x20\x20\x20\x73\x68\x69\x66\x74\x20\x3d\x20\
\x28\x76\x20\x3e\x20\x30\x78\x46\x29\x20\x3c\x3c\x20\x32\x3b\x20\x76\x20\x3e\
\x3e\x3d\x20\x73\x68\x69\x66\x74\x3b\x20\x72\x20\x7c\x3d\x20\x73\x68\x69\x66\
\x74\x3b\0\x20\x20\x20\x20\x73\x68\x69\x66\x74\x20\x3d\x20\x28\x76\x20\x3e\x20\
\x30\x78\x33\x29\x20\x3c\x3c\x20\x31\x3b\x20\x76\x20\x3e\x3e\x3d\x20\x73\x68\
\x69\x66\x74\x3b\x20\x72\x20\x7c\x3d\x20\x73\x68\x69\x66\x74\x3b\0\x20\x20\x20\
\x20\x72\x20\x7c\x3d\x20\x28\x76\x20\x3e\x3e\x20\x31\x29\x3b\0\x20\x20\x20\x20\
\x20\x20\x20\x20\x72\x65\x74\x75\x72\x6e\x20\x6c\x69\x62\x6e\x65\x74\x64\x61\
\x74\x61\x5f\x6c\x6f\x67\x32\x28\x68\x69\x29\x20\x2b\x20\x33\x32\x3b\0\x20\x20\
\x20\x20\x20\x20\x20\x20\x72\x65\x74\x75\x72\x6e\x20\x6c\x69\x62\x6e\x65\x74\
\x64\x61\x74\x61\x5f\x6c\x6f\x67\x32\x28\x76\x29\x3b\0\x20\x20\x20\x20\x69\x66\
\x20\x28\x72\x6c\x6f\x67\x20\x3e\x20\x65\x6e\x64\x29\0\x20\x20\x20\x20\x62\x6c\
\x6b\x2e\x62\x69\x6e\x20\x3d\x20\x6c\x69\x62\x6e\x65\x74\x64\x61\x74\x61\x5f\
\x73\x65\x6c\x65\x63\x74\x5f\x69\x64\x78\x28\x63\x75\x72\x72\x2c\x20\x4e\x45\
\x54\x44\x41\x54\x41\x5f\x46\x53\x5f\x4d\x41\x58\x5f\x42\x49\x4e\x53\x5f\x50\
\x4f\x53\x29\x3b\0\x20\x20\x20\x20\x62\x6c\x6b\x2e\x64\x65\x76\x20\x3d\x20\x6e\
\x65\x74\x64\x61\x74\x61\x5f\x6e\x65\x77\x5f\x65\x6e\x63\x6f\x64\x65\x5f\x64\
\x65\x76\x28\x70\x74\x72\x2d\x3e\x64\x65\x76\x29\x3b\0\x2f\x65\x62\x70\x66\x2d\
\x63\x6f\x2d\x72\x65\x2f\x73\x72\x63\x2f\x2e\x2e\x2f\x6b\x65\x72\x6e\x65\x6c\
\x2d\x63\x6f\x6c\x6c\x65\x63\x74\x6f\x72\x2f\x69\x6e\x63\x6c\x75\x64\x65\x73\
\x2f\x6e\x65\x74\x64\x61\x74\x61\x5f\x64\x69\x73\x6b\x2e\x68\0\x20\x20\x20\x20\
\x72\x65\x74\x75\x72\x6e\x20\x28\x6d\x69\x6e\x6f\x72\x20\x26\x20\x30\x78\x66\
\x66\x29\x20\x7c\x20\x28\x6d\x61\x6a\x6f\x72\x20\x3c\x3c\x20\x38\x29\x20\x7c\
\x20\x28\x28\x6d\x69\x6e\x6f\x72\x20\x26\x20\x7e\x30\x78\x66\x66\x29\x20\x3c\
\x3c\x20\x31\x32\x29\x3b\0\x20\x20\x20\x20\x75\x70\x64\x61\x74\x65\x20\x3d\x20\
\x62\x70\x66\x5f\x6d\x61\x70\x5f\x6c\x6f\x6f\x6b\x75\x70\x5f\x65\x6c\x65\x6d\
\x28\x26\x74\x62\x6c\x5f\x64\x69\x73\x6b\x5f\x69\x6f\x63\x61\x6c\x6c\x20\x2c\
\x26\x62\x6c\x6b\x29\x3b\0\x20\x20\x20\x20\x69\x66\x20\x28\x75\x70\x64\x61\x74\
\x65\x29\x20\x7b\0\x20\x20\x20\x20\x20\x20\x20\x20\x64\x61\x74\x61\x20\x3d\x20\
\x31\x3b\0\x20\x20\x20\x20\x20\x20\x20\x20\x62\x70\x66\x5f\x6d\x61\x70\x5f\x75\
\x70\x64\x61\x74\x65\x5f\x65\x6c\x65\x6d\x28\x26\x74\x62\x6c\x5f\x64\x69\x73\
\x6b\x5f\x69\x6f\x63\x61\x6c\x6c\x2c\x20\x26\x62\x6c\x6b\x2c\x20\x26\x64\x61\
\x74\x61\x2c\x20\x42\x50\x46\x5f\x41\x4e\x59\x29\x3b\0\x20\x20\x20\x20\x62\x70\
\x66\x5f\x6d\x61\x70\x5f\x64\x65\x6c\x65\x74\x65\x5f\x65\x6c\x65\x6d\x28\x26\
\x74\x6d\x70\x5f\x64\x69\x73\x6b\x5f\x74\x70\x5f\x73\x74\x61\x74\x2c\x20\x26\
\x6b\x65\x79\x29\x3b\0\x5f\x6c\x69\x63\x65\x6e\x73\x65\0\x2e\x6d\x61\x70\x73\0\
\x6c\x69\x63\x65\x6e\x73\x65\0\0\0\0\x9f\xeb\x01\0\x20\0\0\0\0\0\0\0\x24\0\0\0\
\x24\0\0\0\x84\x05\0\0\xa8\x05\0\0\0\0\0\0\x08\0\0\0\x46\x01\0\0\x01\0\0\0\0\0\
\0\0\x2a\0\0\0\x93\x03\0\0\x01\0\0\0\0\0\0\0\x2e\0\0\0\x10\0\0\0\x46\x01\0\0\
\x14\0\0\0\0\0\0\0\x66\x01\0\0\x81\x01\0\0\x0f\xc0\0\0\x08\0\0\0\x66\x01\0\0\
\x81\x01\0\0\x09\xc0\0\0\x18\0\0\0\x66\x01\0\0\x94\x01\0\0\x18\xcc\0\0\x20\0\0\
\0\x66\x01\0\0\xb5\x01\0\0\x0d\xd0\0\0\x28\0\0\0\x66\x01\0\0\xcd\x01\0\0\x17\
\xd4\0\0\x30\0\0\0\x66\x01\0\0\xcd\x01\0\0\x10\xd4\0\0\x38\0\0\0\x66\x01\0\0\
\xeb\x01\0\0\x13\xe8\0\0\x40\0\0\0\x66\x01\0\0\xeb\x01\0\0\x0b\xe8\0\0\x50\0\0\
\0\x66\x01\0\0\x94\x01\0\0\x18\xcc\0\0\x68\0\0\0\x66\x01\0\0\x11\x02\0\0\x05\
\xf0\0\0\xb0\0\0\0\x66\x01\0\0\x94\x01\0\0\x18\xcc\0\0\xb8\0\0\0\x54\x02\0\0\
\x92\x02\0\0\x0b\x80\0\0\xd0\0\0\0\x54\x02\0\0\xbc\x02\0\0\x09\x84\0\0\xd8\0\0\
\0\x54\x02\0\0\xc9\x02\0\0\x05\x48\0\0\xe0\0\0\0\x54\x02\0\0\xef\x02\0\0\x20\
\x4c\0\0\xf0\0\0\0\x54\x02\0\0\xef\x02\0\0\x0a\x4c\0\0\0\x01\0\0\x54\x02\0\0\
\x20\x03\0\0\x0e\x50\0\0\x18\x01\0\0\x54\x02\0\0\0\0\0\0\0\0\0\0\x30\x01\0\0\
\x54\x02\0\0\x36\x03\0\0\x09\x90\0\0\x50\x01\0\0\x66\x01\0\0\x71\x03\0\0\x01\
\x04\x01\0\x93\x03\0\0\x43\0\0\0\0\0\0\0\x66\x01\0\0\xb6\x03\0\0\0\x10\x01\0\
\x10\0\0\0\x66\x01\0\0\x94\x01\0\0\x18\x1c\x01\0\x18\0\0\0\x66\x01\0\0\xb5\x01\
\0\0\x14\x24\x01\0\x20\0\0\0\x66\x01\0\0\xb5\x01\0\0\x0d\x24\x01\0\x28\0\0\0\
\x66\x01\0\0\xcd\x01\0\0\x17\x28\x01\0\x30\0\0\0\x66\x01\0\0\xcd\x01\0\0\x10\
\x28\x01\0\x40\0\0\0\x66\x01\0\0\0\0\0\0\0\0\0\0\x48\0\0\0\x66\x01\0\0\xfb\x03\
\0\0\x0c\x3c\x01\0\x68\0\0\0\x66\x01\0\0\x34\x04\0\0\x09\x40\x01\0\x70\0\0\0\
\x66\x01\0\0\x43\x04\0\0\x10\x50\x01\0\x78\0\0\0\x66\x01\0\0\x66\x04\0\0\x0d\
\x58\x01\0\x80\0\0\0\x66\x01\0\0\x66\x04\0\0\x0a\x58\x01\0\x88\0\0\0\x66\x01\0\
\0\x79\x04\0\0\x0a\x5c\x01\0\x90\0\0\0\x54\x02\0\0\x8b\x04\0\0\x19\x30\x01\0\
\xa0\0\0\0\x54\x02\0\0\xaa\x04\0\0\x09\x34\x01\0\xb8\0\0\0\x54\x02\0\0\x8b\x04\
\0\0\x17\x30\x01\0\xc8\0\0\0\x54\x02\0\0\xb6\x04\0\0\x16\x04\x01\0\xd0\0\0\0\
\x54\x02\0\0\xb6\x04\0\0\x1e\x04\x01\0\xf0\0\0\0\x54\x02\0\0\xda\x04\0\0\x18\
\x08\x01\0\xf8\0\0\0\x54\x02\0\0\xda\x04\0\0\x20\x08\x01\0\x18\x01\0\0\x54\x02\
\0\0\x10\x05\0\0\x17\x0c\x01\0\x20\x01\0\0\x54\x02\0\0\x10\x05\0\0\x1f\x0c\x01\
\0\x38\x01\0\0\x54\x02\0\0\x45\x05\0\0\x17\x10\x01\0\x40\x01\0\0\x54\x02\0\0\
\x45\x05\0\0\x1f\x10\x01\0\x48\x01\0\0\x54\x02\0\0\x7a\x05\0\0\x0d\x14\x01\0\
\x50\x01\0\0\x54\x02\0\0\x7a\x05\0\0\x07\x14\x01\0\x70\x01\0\0\x54\x02\0\0\x8d\
\x05\0\0\x24\x38\x01\0\x80\x01\0\0\x54\x02\0\0\xb6\x05\0\0\x20\x40\x01\0\xb0\
\x01\0\0\x54\x02\0\0\xb6\x04\0\0\x16\x04\x01\0\xb8\x01\0\0\x54\x02\0\0\xb6\x04\
\0\0\x1e\x04\x01\0\xd8\x01\0\0\x54\x02\0\0\xda\x04\0\0\x18\x08\x01\0\xe0\x01\0\
\0\x54\x02\0\0\xda\x04\0\0\x20\x08\x01\0\0\x02\0\0\x54\x02\0\0\x10\x05\0\0\x17\
\x0c\x01\0\x08\x02\0\0\x54\x02\0\0\x10\x05\0\0\x1f\x0c\x01\0\x20\x02\0\0\x54\
\x02\0\0\x45\x05\0\0\x17\x10\x01\0\x28\x02\0\0\x54\x02\0\0\x45\x05\0\0\x1f\x10\
\x01\0\x30\x02\0\0\x54\x02\0\0\x7a\x05\0\0\x0d\x14\x01\0\x38\x02\0\0\x54\x02\0\
\0\x7a\x05\0\0\x07\x14\x01\0\x58\x02\0\0\x54\x02\0\0\xd9\x05\0\0\x09\x90\x01\0\
\x80\x02\0\0\x66\x01\0\0\xed\x05\0\0\x0d\x64\x01\0\x88\x02\0\0\x66\x01\0\0\x31\
\x06\0\0\x2b\x68\x01\0\x90\x02\0\0\x61\x06\0\0\x9d\x06\0\0\x3d\x5c\0\0\xb8\x02\
\0\0\x61\x06\0\0\x9d\x06\0\0\x13\x5c\0\0\xc8\x02\0\0\x61\x06\0\0\x9d\x06\0\0\
\x24\x5c\0\0\xd8\x02\0\0\x61\x06\0\0\x9d\x06\0\0\x1b\x5c\0\0\xe0\x02\0\0\x61\
\x06\0\0\x9d\x06\0\0\x2a\x5c\0\0\xe8\x02\0\0\x66\x01\0\0\x31\x06\0\0\x0d\x68\
\x01\0\xf8\x02\0\0\x54\x02\0\0\0\0\0\0\0\0\0\0\0\x03\0\0\x66\x01\0\0\xe1\x06\0\
\0\x0e\x74\x01\0\x18\x03\0\0\x66\x01\0\0\x1b\x07\0\0\x09\x78\x01\0\x28\x03\0\0\
\x54\x02\0\0\xc9\x02\0\0\x05\x48\0\0\x38\x03\0\0\x54\x02\0\0\xef\x02\0\0\x20\
\x4c\0\0\x48\x03\0\0\x54\x02\0\0\xef\x02\0\0\x0a\x4c\0\0\x50\x03\0\0\x54\x02\0\
\0\x20\x03\0\0\x0e\x50\0\0\x68\x03\0\0\x66\x01\0\0\x2d\x07\0\0\x0e\x84\x01\0\
\x78\x03\0\0\x66\x01\0\0\0\0\0\0\0\0\0\0\x90\x03\0\0\x66\x01\0\0\x3f\x07\0\0\
\x09\x88\x01\0\xb8\x03\0\0\x66\x01\0\0\x84\x07\0\0\x05\x94\x01\0\x08\x04\0\0\
\x54\x02\0\0\x92\x02\0\0\x0b\x80\0\0\x20\x04\0\0\x54\x02\0\0\xbc\x02\0\0\x09\
\x84\0\0\x28\x04\0\0\x54\x02\0\0\xc9\x02\0\0\x05\x48\0\0\x30\x04\0\0\x54\x02\0\
\0\xef\x02\0\0\x20\x4c\0\0\x40\x04\0\0\x54\x02\0\0\xef\x02\0\0\x0a\x4c\0\0\x50\
\x04\0\0\x54\x02\0\0\x20\x03\0\0\x0e\x50\0\0\x68\x04\0\0\x54\x02\0\0\0\0\0\0\0\
\0\0\0\x80\x04\0\0\x54\x02\0\0\x36\x03\0\0\x09\x90\0\0\xa0\x04\0\0\x66\x01\0\0\
\x71\x03\0\0\x01\xa8\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\x03\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x1f\x01\0\0\0\0\x03\0\
\x50\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x3d\x01\0\0\0\0\x03\0\x10\x01\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x05\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x5c\x01\0\
\0\0\0\x05\0\xa0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x54\x01\0\0\0\0\x05\0\x80\x01\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x36\x01\0\0\0\0\x05\0\xc8\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\x10\x01\0\0\0\0\x05\0\xf0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\x01\0\0\0\0\
\x05\0\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x6c\x01\0\0\0\0\x05\0\x38\x01\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x64\x01\0\0\0\0\x05\0\x58\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\x44\x01\0\0\0\0\x05\0\xb0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x2e\x01\0\0\0\0\
\x05\0\xd8\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\x01\0\0\0\0\x05\0\0\x02\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\xf9\0\0\0\0\0\x05\0\x20\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x4c\x01\0\0\0\0\x05\0\x80\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x26\x01\0\0\0\0\x05\
\0\x60\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x17\x01\0\0\0\0\x05\0\xb0\x03\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\xf1\0\0\0\0\0\x05\0\x60\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x53\
\0\0\0\x12\0\x03\0\0\0\0\0\0\0\0\0\x60\x01\0\0\0\0\0\0\x14\0\0\0\x11\0\x07\0\0\
\0\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\x2b\0\0\0\x11\0\x07\0\x20\0\0\0\0\0\0\0\x20\0\
\0\0\0\0\0\0\x8e\0\0\0\x12\0\x05\0\0\0\0\0\0\0\0\0\xb0\x04\0\0\0\0\0\0\x35\0\0\
\0\x11\0\x07\0\x40\0\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\xcf\0\0\0\x11\0\x08\0\0\0\0\
\0\0\0\0\0\x04\0\0\0\0\0\0\0\x68\0\0\0\0\0\0\0\x01\0\0\0\x15\0\0\0\xb8\0\0\0\0\
\0\0\0\x01\0\0\0\x16\0\0\0\x30\x01\0\0\0\0\0\0\x01\0\0\0\x16\0\0\0\x48\0\0\0\0\
\0\0\0\x01\0\0\0\x15\0\0\0\0\x03\0\0\0\0\0\0\x01\0\0\0\x18\0\0\0\x90\x03\0\0\0\
\0\0\0\x01\0\0\0\x18\0\0\0\xc0\x03\0\0\0\0\0\0\x01\0\0\0\x15\0\0\0\x08\x04\0\0\
\0\0\0\0\x01\0\0\0\x16\0\0\0\x80\x04\0\0\0\0\0\0\x01\0\0\0\x16\0\0\0\x70\x04\0\
\0\0\0\0\0\x04\0\0\0\x15\0\0\0\x7c\x04\0\0\0\0\0\0\x04\0\0\0\x16\0\0\0\x88\x04\
\0\0\0\0\0\0\x04\0\0\0\x18\0\0\0\xa0\x04\0\0\0\0\0\0\x04\0\0\0\x19\0\0\0\x2c\0\
\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x3c\0\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x50\0\0\
\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x60\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x70\0\0\0\
\0\0\0\0\x04\0\0\0\x01\0\0\0\x80\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x90\0\0\0\0\
\0\0\0\x04\0\0\0\x01\0\0\0\xa0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xb0\0\0\0\0\0\
\0\0\x04\0\0\0\x01\0\0\0\xc0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xd0\0\0\0\0\0\0\
\0\x04\0\0\0\x01\0\0\0\xe0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xf0\0\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\0\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x10\x01\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\x20\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x30\x01\0\0\0\0\0\
\0\x04\0\0\0\x01\0\0\0\x40\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x50\x01\0\0\0\0\
\0\0\x04\0\0\0\x01\0\0\0\x60\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x70\x01\0\0\0\
\0\0\0\x04\0\0\0\x01\0\0\0\x80\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x98\x01\0\0\
\0\0\0\0\x04\0\0\0\x04\0\0\0\xa8\x01\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xb8\x01\0\
\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xc8\x01\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xd8\x01\
\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xe8\x01\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xf8\
\x01\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x08\x02\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\
\x18\x02\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x28\x02\0\0\0\0\0\0\x04\0\0\0\x04\0\0\
\0\x38\x02\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x48\x02\0\0\0\0\0\0\x04\0\0\0\x04\0\
\0\0\x58\x02\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x68\x02\0\0\0\0\0\0\x04\0\0\0\x04\
\0\0\0\x78\x02\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x88\x02\0\0\0\0\0\0\x04\0\0\0\
\x04\0\0\0\x98\x02\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xa8\x02\0\0\0\0\0\0\x04\0\0\
\0\x04\0\0\0\xb8\x02\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xc8\x02\0\0\0\0\0\0\x04\0\
\0\0\x04\0\0\0\xd8\x02\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xe8\x02\0\0\0\0\0\0\x04\
\0\0\0\x04\0\0\0\xf8\x02\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x08\x03\0\0\0\0\0\0\
\x04\0\0\0\x04\0\0\0\x18\x03\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x28\x03\0\0\0\0\0\
\0\x04\0\0\0\x04\0\0\0\x38\x03\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x48\x03\0\0\0\0\
\0\0\x04\0\0\0\x04\0\0\0\x58\x03\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x68\x03\0\0\0\
\0\0\0\x04\0\0\0\x04\0\0\0\x78\x03\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x88\x03\0\0\
\0\0\0\0\x04\0\0\0\x04\0\0\0\x98\x03\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xa8\x03\0\
\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xb8\x03\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xc8\x03\
\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xd8\x03\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xe8\
\x03\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xf8\x03\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\
\x08\x04\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x18\x04\0\0\0\0\0\0\x04\0\0\0\x04\0\0\
\0\x28\x04\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x38\x04\0\0\0\0\0\0\x04\0\0\0\x04\0\
\0\0\x48\x04\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x58\x04\0\0\0\0\0\0\x04\0\0\0\x04\
\0\0\0\x68\x04\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x78\x04\0\0\0\0\0\0\x04\0\0\0\
\x04\0\0\0\x88\x04\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x98\x04\0\0\0\0\0\0\x04\0\0\
\0\x04\0\0\0\xa8\x04\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xb8\x04\0\0\0\0\0\0\x04\0\
\0\0\x04\0\0\0\xc8\x04\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xd8\x04\0\0\0\0\0\0\x04\
\0\0\0\x04\0\0\0\xe8\x04\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xf8\x04\0\0\0\0\0\0\
\x04\0\0\0\x04\0\0\0\x08\x05\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x18\x05\0\0\0\0\0\
\0\x04\0\0\0\x04\0\0\0\x28\x05\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x38\x05\0\0\0\0\
\0\0\x04\0\0\0\x04\0\0\0\x48\x05\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x58\x05\0\0\0\
\0\0\0\x04\0\0\0\x04\0\0\0\x68\x05\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x78\x05\0\0\
\0\0\0\0\x04\0\0\0\x04\0\0\0\x88\x05\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x98\x05\0\
\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xa8\x05\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xb8\x05\
\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x1e\x21\x1f\x20\x22\x23\0\x2e\x74\x65\x78\x74\
\0\x2e\x72\x65\x6c\x2e\x42\x54\x46\x2e\x65\x78\x74\0\x74\x6d\x70\x5f\x64\x69\
\x73\x6b\x5f\x74\x70\x5f\x73\x74\x61\x74\0\x2e\x6d\x61\x70\x73\0\x64\x69\x73\
\x6b\x5f\x63\x74\x72\x6c\0\x74\x62\x6c\x5f\x64\x69\x73\x6b\x5f\x69\x6f\x63\x61\
\x6c\x6c\0\x2e\x6c\x6c\x76\x6d\x5f\x61\x64\x64\x72\x73\x69\x67\0\x6e\x65\x74\
\x64\x61\x74\x61\x5f\x62\x6c\x6f\x63\x6b\x5f\x72\x71\x5f\x69\x73\x73\x75\x65\0\
\x2e\x72\x65\x6c\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x2f\x62\x6c\x6f\x63\
\x6b\x2f\x62\x6c\x6f\x63\x6b\x5f\x72\x71\x5f\x69\x73\x73\x75\x65\0\x6e\x65\x74\
\x64\x61\x74\x61\x5f\x62\x6c\x6f\x63\x6b\x5f\x72\x71\x5f\x63\x6f\x6d\x70\x6c\
\x65\x74\x65\0\x2e\x72\x65\x6c\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x2f\x62\
\x6c\x6f\x63\x6b\x2f\x62\x6c\x6f\x63\x6b\x5f\x72\x71\x5f\x63\x6f\x6d\x70\x6c\
\x65\x74\x65\0\x5f\x6c\x69\x63\x65\x6e\x73\x65\0\x2e\x73\x74\x72\x74\x61\x62\0\
\x2e\x73\x79\x6d\x74\x61\x62\0\x2e\x72\x65\x6c\x2e\x42\x54\x46\0\x4c\x42\x42\
\x31\x5f\x32\x39\0\x4c\x42\x42\x31\x5f\x31\x39\0\x4c\x42\x42\x31\x5f\x38\0\x4c\
\x42\x42\x31\x5f\x31\x37\0\x4c\x42\x42\x31\x5f\x36\0\x4c\x42\x42\x31\x5f\x32\
\x36\0\x4c\x42\x42\x30\x5f\x35\0\x4c\x42\x42\x31\x5f\x32\x35\0\x4c\x42\x42\x31\
\x5f\x31\x35\0\x4c\x42\x42\x31\x5f\x34\0\x4c\x42\x42\x30\x5f\x34\0\x4c\x42\x42\
\x31\x5f\x31\x33\0\x4c\x42\x42\x31\x5f\x32\x32\0\x4c\x42\x42\x31\x5f\x31\x31\0\
\x4c\x42\x42\x31\x5f\x33\x30\0\x4c\x42\x42\x31\x5f\x32\x30\0\x4c\x42\x42\x31\
\x5f\x31\x30\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\xd8\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xce\x21\0\0\0\0\0\0\x74\
\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\
\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x6e\0\0\0\x01\0\0\0\x06\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\x60\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x6a\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\x68\x1b\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\x0e\0\0\0\x03\0\0\0\x08\0\0\
\0\0\0\0\0\x10\0\0\0\0\0\0\0\xac\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\xa0\x01\0\0\0\0\0\0\xb0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\xa8\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x98\x1b\
\0\0\0\0\0\0\x60\0\0\0\0\0\0\0\x0e\0\0\0\x05\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\
\0\0\0\0\x25\0\0\0\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x50\x06\0\0\0\0\
\0\0\x60\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xd0\0\
\0\0\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb0\x06\0\0\0\0\0\0\x04\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xec\0\0\0\x01\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb4\x06\0\0\0\0\0\0\x75\x0c\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xe8\0\0\0\x09\0\0\0\x40\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\xf8\x1b\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\x0e\0\0\0\x09\0\0\0\
\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x0b\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x2c\x13\0\0\0\0\0\0\xc8\x05\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x07\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x38\x1c\0\0\0\0\0\0\x90\x05\0\0\0\0\0\0\x0e\0\0\0\x0b\0\0\0\x08\0\0\0\0\0\0\0\
\x10\0\0\0\0\0\0\0\x45\0\0\0\x03\x4c\xff\x6f\0\0\0\x80\0\0\0\0\0\0\0\0\0\0\0\0\
\xc8\x21\0\0\0\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\xe0\0\0\0\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xf8\x18\0\0\0\0\
\0\0\x70\x02\0\0\0\0\0\0\x01\0\0\0\x14\0\0\0\x08\0\0\0\0\0\0\0\x18\0\0\0\0\0\0\
\0";

	*sz = sizeof(data) - 1;
	return (const void *)data;
}

#ifdef __cplusplus
struct disk_bpf *disk_bpf::open(const struct bpf_object_open_opts *opts) { return disk_bpf__open_opts(opts); }
struct disk_bpf *disk_bpf::open_and_load() { return disk_bpf__open_and_load(); }
int disk_bpf::load(struct disk_bpf *skel) { return disk_bpf__load(skel); }
int disk_bpf::attach(struct disk_bpf *skel) { return disk_bpf__attach(skel); }
void disk_bpf::detach(struct disk_bpf *skel) { disk_bpf__detach(skel); }
void disk_bpf::destroy(struct disk_bpf *skel) { disk_bpf__destroy(skel); }
const void *disk_bpf::elf_bytes(size_t *sz) { return disk_bpf__elf_bytes(sz); }
#endif /* __cplusplus */

__attribute__((unused)) static void
disk_bpf__assert(struct disk_bpf *s __attribute__((unused)))
{
#ifdef __cplusplus
#define _Static_assert static_assert
#endif
#ifdef __cplusplus
#undef _Static_assert
#endif
}

#endif /* __DISK_BPF_SKEL_H__ */
