// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef node_inspector_protocol_NodeTracing_h
#define node_inspector_protocol_NodeTracing_h

#include "src/node/inspector/protocol/Protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace node {
namespace inspector {
namespace protocol {
namespace NodeTracing {
class TraceConfig;

// ------------- Forward and enum declarations.

// ------------- Type and builder declarations.

class  TraceConfig : public ::crdtp::ProtocolObject<TraceConfig> {
public:
    ~TraceConfig() override { }

    struct  RecordModeEnum {
        static const char* RecordUntilFull;
        static const char* RecordContinuously;
        static const char* RecordAsMuchAsPossible;
    }; // RecordModeEnum

    bool hasRecordMode() { return !!m_recordMode; }
    String getRecordMode(const String& defaultValue) const {
       return m_recordMode.value_or(defaultValue);
    }
    const std::optional<String>& getRecordMode() const {
       return m_recordMode;
    }
    void setRecordMode(const String& value) { m_recordMode = value; }

    protocol::Array<String>* getIncludedCategories() { return m_includedCategories.get(); }
    void setIncludedCategories(std::unique_ptr<protocol::Array<String>> value) { m_includedCategories = std::move(value); }

    template<int STATE>
    class TraceConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            IncludedCategoriesSet = 1 << 1,
            AllFieldsSet = (IncludedCategoriesSet | 0)};


        TraceConfigBuilder<STATE>& setRecordMode(const String& value)
        {
            m_result->setRecordMode(value);
            return *this;
        }

        TraceConfigBuilder<STATE | IncludedCategoriesSet>& setIncludedCategories(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & IncludedCategoriesSet), "property includedCategories should not be set yet");
            m_result->setIncludedCategories(std::move(value));
            return castState<IncludedCategoriesSet>();
        }

        std::unique_ptr<TraceConfig> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class TraceConfig;
        TraceConfigBuilder() : m_result(new TraceConfig()) { }

        template<int STEP> TraceConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<TraceConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::NodeTracing::TraceConfig> m_result;
    };

    static TraceConfigBuilder<0> create()
    {
        return TraceConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    TraceConfig()
    {
    }

    std::optional<String> m_recordMode;
    std::unique_ptr<protocol::Array<String>> m_includedCategories;
};


// ------------- Backend interface.

class  Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse getCategories(std::unique_ptr<protocol::Array<String>>* out_categories) = 0;
    virtual DispatchResponse start(std::unique_ptr<protocol::NodeTracing::TraceConfig> in_traceConfig) = 0;
    virtual DispatchResponse stop() = 0;

    virtual DispatchResponse disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class  Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void dataCollected(std::unique_ptr<protocol::Array<protocol::DictionaryValue>> value);
    void tracingComplete();

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class  Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class  Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace NodeTracing
} // namespace node
} // namespace inspector
} // namespace protocol

#endif // !defined(node_inspector_protocol_NodeTracing_h)
