// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

#include "contrib_ops/rocm/conv_transpose_with_dynamic_pads.h"

namespace onnxruntime {
namespace contrib {
namespace rocm {
ONNX_OPERATOR_TYPED_KERNEL_EX(
    ConvTransposeWithDynamicPads,
    kMSDomain,
    1,
    float,
    kRocmExecutionProvider,
    (*KernelDefBuilder::Create())
        .TypeConstraint("T", DataTypeImpl::GetTensorType<float>())
        .InputMemoryType(OrtMemTypeCPUInput, 2),
    ConvTransposeWithDynamicPads<float>);
}  // namespace rocm
}  // namespace contrib
}  // namespace onnxruntime
