// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

#pragma once

#include <vector>

namespace onnxruntime {
namespace rocm {

template <typename T>
void BatchScaleImpl(hipStream_t stream,
                    int64_t input_element_count,
                    const T* input_data,
                    const std::vector<float>& scales,
                    const std::vector<T*>& outputs);

}  // namespace rocm
}  // namespace onnxruntime
