// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
#pragma once

#include "core/common/common.h"

namespace onnxruntime {
namespace rocm {

template <typename T>
Status LaunchGeluKernel(hipStream_t stream, const T* input, T* output, size_t count);

template <typename T>
Status LaunchFastGeluKernel(const hipDeviceProp_t& prop, hipStream_t stream, int input_length, int bias_length,
                            const T* input, const T* bias, T* output, bool use_half2);

}  // namespace rocm
}  // namespace onnxruntime
