/* DirectPhotoPage.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DirectPhotoPage.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*               2018 elementary LLC. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <gio/gio.h>
#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>
#include <granite.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_DIRECT_VIEW_COLLECTION (direct_view_collection_get_type ())
#define DIRECT_VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIRECT_VIEW_COLLECTION, DirectViewCollection))
#define DIRECT_VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIRECT_VIEW_COLLECTION, DirectViewCollectionClass))
#define IS_DIRECT_VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIRECT_VIEW_COLLECTION))
#define IS_DIRECT_VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIRECT_VIEW_COLLECTION))
#define DIRECT_VIEW_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIRECT_VIEW_COLLECTION, DirectViewCollectionClass))

typedef struct _DirectViewCollection DirectViewCollection;
typedef struct _DirectViewCollectionClass DirectViewCollectionClass;
enum  {
	DIRECT_PHOTO_PAGE_0_PROPERTY,
	DIRECT_PHOTO_PAGE_NUM_PROPERTIES
};
static GParamSpec* direct_photo_page_properties[DIRECT_PHOTO_PAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _command_manager_unref0(var) ((var == NULL) ? NULL : (var = (command_manager_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _photo_file_format_properties_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_properties_unref (var), NULL)))
#define _print_manager_unref0(var) ((var == NULL) ? NULL : (var = (print_manager_unref (var), NULL)))

struct _DirectPhotoPagePrivate {
	GFile* initial_file;
	DirectViewCollection* view_controller;
	GFile* current_save_dir;
	gboolean drop_if_dirty;
	GtkMenu* contractor_menu;
	GtkMenu* context_menu;
	gboolean fullscreen;
};

struct _Block9Data {
	int _ref_count_;
	DirectPhotoPage* self;
	GtkAction* revert_action;
	GtkAction* adjust_datetime_action;
};

struct _Block10Data {
	int _ref_count_;
	Block9Data * _data9_;
	GtkAction* copy_image_action;
	GtkAction* copy_metadata_action;
	GtkAction* print_action;
};

static gint DirectPhotoPage_private_offset;
static gpointer direct_photo_page_parent_class = NULL;

VALA_EXTERN GType direct_view_collection_get_type (void) G_GNUC_CONST ;
static void direct_photo_page_on_photos_altered (DirectPhotoPage* self,
                                          GeeMap* map);
static void _direct_photo_page_on_photos_altered_data_collection_items_altered (DataCollection* _sender,
                                                                         GeeMap* items,
                                                                         gpointer self);
static gboolean direct_photo_page_check_editable_file (GFile* file);
VALA_EXTERN DirectViewCollection* direct_view_collection_new (void);
VALA_EXTERN DirectViewCollection* direct_view_collection_construct (GType object_type);
static void direct_photo_page_on_selection_group_altered (DirectPhotoPage* self);
static void _direct_photo_page_on_selection_group_altered_view_collection_selection_group_altered (ViewCollection* _sender,
                                                                                            gpointer self);
static GtkActionEntry* direct_photo_page_real_init_collect_action_entries (Page* base,
                                                                    gint* result_length1);
static void direct_photo_page_on_save (DirectPhotoPage* self);
static void _direct_photo_page_on_save_gcallback (GtkAction* action,
                                           gpointer self);
static void direct_photo_page_on_save_as (DirectPhotoPage* self);
static void _direct_photo_page_on_save_as_gcallback (GtkAction* action,
                                              gpointer self);
static void direct_photo_page_on_print (DirectPhotoPage* self);
static void _direct_photo_page_on_print_gcallback (GtkAction* action,
                                            gpointer self);
static void _editing_host_page_on_rotate_clockwise_gcallback (GtkAction* action,
                                                       gpointer self);
static void _editing_host_page_on_rotate_counterclockwise_gcallback (GtkAction* action,
                                                              gpointer self);
static void _editing_host_page_on_enhance_gcallback (GtkAction* action,
                                              gpointer self);
static void _editing_host_page_toggle_crop_gcallback (GtkAction* action,
                                               gpointer self);
static void _editing_host_page_toggle_straighten_gcallback (GtkAction* action,
                                                     gpointer self);
static void _editing_host_page_toggle_redeye_gcallback (GtkAction* action,
                                                 gpointer self);
static void _editing_host_page_toggle_adjust_gcallback (GtkAction* action,
                                                 gpointer self);
static void _editing_host_page_on_revert_gcallback (GtkAction* action,
                                             gpointer self);
static void _editing_host_page_on_adjust_date_time_gcallback (GtkAction* action,
                                                       gpointer self);
static void _editing_host_page_on_increase_size_gcallback (GtkAction* action,
                                                    gpointer self);
static void _editing_host_page_on_decrease_size_gcallback (GtkAction* action,
                                                    gpointer self);
static void _editing_host_page_snap_zoom_to_min_gcallback (GtkAction* action,
                                                    gpointer self);
static void _editing_host_page_snap_zoom_to_isomorphic_gcallback (GtkAction* action,
                                                           gpointer self);
static void _editing_host_page_snap_zoom_to_max_gcallback (GtkAction* action,
                                                    gpointer self);
static void _editing_host_page_on_copy_image_gcallback (GtkAction* action,
                                                 gpointer self);
static void _editing_host_page_on_copy_metadata_gcallback (GtkAction* action,
                                                    gpointer self);
static void _vala_array_add129 (GtkActionEntry* * array,
                         gint* length,
                         gint* size,
                         const GtkActionEntry* value);
static void _vala_array_add130 (GtkActionEntry* * array,
                         gint* length,
                         gint* size,
                         const GtkActionEntry* value);
static void _vala_array_add131 (GtkActionEntry* * array,
                         gint* length,
                         gint* size,
                         const GtkActionEntry* value);
static void _vala_array_add132 (GtkActionEntry* * array,
                         gint* length,
                         gint* size,
                         const GtkActionEntry* value);
static void _vala_array_add133 (GtkActionEntry* * array,
                         gint* length,
                         gint* size,
                         const GtkActionEntry* value);
static void _vala_array_add134 (GtkActionEntry* * array,
                         gint* length,
                         gint* size,
                         const GtkActionEntry* value);
static void _vala_array_add135 (GtkActionEntry* * array,
                         gint* length,
                         gint* size,
                         const GtkActionEntry* value);
static void _vala_array_add136 (GtkActionEntry* * array,
                         gint* length,
                         gint* size,
                         const GtkActionEntry* value);
static void _vala_array_add137 (GtkActionEntry* * array,
                         gint* length,
                         gint* size,
                         const GtkActionEntry* value);
static void _vala_array_add138 (GtkActionEntry* * array,
                         gint* length,
                         gint* size,
                         const GtkActionEntry* value);
static void _vala_array_add139 (GtkActionEntry* * array,
                         gint* length,
                         gint* size,
                         const GtkActionEntry* value);
static void _vala_array_add140 (GtkActionEntry* * array,
                         gint* length,
                         gint* size,
                         const GtkActionEntry* value);
static void _vala_array_add141 (GtkActionEntry* * array,
                         gint* length,
                         gint* size,
                         const GtkActionEntry* value);
static void _vala_array_add142 (GtkActionEntry* * array,
                         gint* length,
                         gint* size,
                         const GtkActionEntry* value);
static void _vala_array_add143 (GtkActionEntry* * array,
                         gint* length,
                         gint* size,
                         const GtkActionEntry* value);
static void _vala_array_add144 (GtkActionEntry* * array,
                         gint* length,
                         gint* size,
                         const GtkActionEntry* value);
static void _vala_array_add145 (GtkActionEntry* * array,
                         gint* length,
                         gint* size,
                         const GtkActionEntry* value);
static void _vala_array_add146 (GtkActionEntry* * array,
                         gint* length,
                         gint* size,
                         const GtkActionEntry* value);
static void _vala_array_add147 (GtkActionEntry* * array,
                         gint* length,
                         gint* size,
                         const GtkActionEntry* value);
static void direct_photo_page_real_realize (GtkWidget* base);
static void direct_photo_page_real_photo_changing (EditingHostPage* base,
                                            Photo* new_photo);
static gboolean direct_photo_page_real_on_context_buttonpress (Page* base,
                                                        GdkEventButton* event);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void ___lambda42_ (Block9Data* _data9_);
static void ____lambda42__gtk_menu_item_activate (GtkMenuItem* _sender,
                                           gpointer self);
static void ___lambda43_ (Block9Data* _data9_);
static void ____lambda43__gtk_menu_item_activate (GtkMenuItem* _sender,
                                           gpointer self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void ____lambda44_ (Block10Data* _data10_);
static void _____lambda44__gtk_menu_item_activate (GtkMenuItem* _sender,
                                            gpointer self);
static void ____lambda45_ (Block10Data* _data10_);
static void _____lambda45__gtk_menu_item_activate (GtkMenuItem* _sender,
                                            gpointer self);
static void ____lambda46_ (Block10Data* _data10_);
static void _____lambda46__gtk_menu_item_activate (GtkMenuItem* _sender,
                                            gpointer self);
static void direct_photo_page_update_zoom_menu_item_sensitivity (DirectPhotoPage* self);
static void direct_photo_page_real_on_increase_size (EditingHostPage* base);
static void direct_photo_page_real_on_decrease_size (EditingHostPage* base);
static gboolean direct_photo_page_real_on_double_click (EditingHostPage* base,
                                                 GdkEventButton* event);
static void direct_photo_page_real_update_ui (EditingHostPage* base,
                                       gboolean missing);
static void direct_photo_page_real_update_actions (Page* base,
                                            gint selected_count,
                                            gint count);
static gboolean direct_photo_page_check_ok_to_close_photo (DirectPhotoPage* self,
                                                    Photo* photo);
static gboolean direct_photo_page_save (DirectPhotoPage* self,
                                 GFile* dest,
                                 gint scale,
                                 ScaleConstraint constraint,
                                 JpegQuality quality,
                                 PhotoFileFormat format,
                                 gboolean copy_unmodified,
                                 gboolean save_metadata);
static gboolean direct_photo_page_do_save_as (DirectPhotoPage* self);
static gboolean direct_photo_page_real_confirm_replace_photo (EditingHostPage* base,
                                                       Photo* old_photo,
                                                       Photo* new_photo);
static gboolean direct_photo_page_real_on_app_key_pressed (Page* base,
                                                    GdkEventKey* event);
static DataView* direct_photo_page_real_create_photo_view (EditingHostPage* base,
                                                    DataSource* source);
static void direct_photo_page_finalize (GObject * obj);
static GType direct_photo_page_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
direct_photo_page_get_instance_private (DirectPhotoPage* self)
{
	return G_STRUCT_MEMBER_P (self, DirectPhotoPage_private_offset);
}

static void
_direct_photo_page_on_photos_altered_data_collection_items_altered (DataCollection* _sender,
                                                                    GeeMap* items,
                                                                    gpointer self)
{
	direct_photo_page_on_photos_altered ((DirectPhotoPage*) self, items);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_direct_photo_page_on_selection_group_altered_view_collection_selection_group_altered (ViewCollection* _sender,
                                                                                       gpointer self)
{
	direct_photo_page_on_selection_group_altered ((DirectPhotoPage*) self);
}

DirectPhotoPage*
direct_photo_page_construct (GType object_type,
                             GFile* file,
                             gboolean fullscreen)
{
	DirectPhotoPage * self = NULL;
	DirectPhotoSourceCollection* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GFile* _tmp4_;
	DirectViewCollection* _tmp5_;
	GFile* _tmp6_;
	DirectPhotoSourceCollection* _tmp7_;
	ViewCollection* _tmp8_;
	ViewCollection* _tmp9_;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = direct_photo_global;
	_tmp1_ = g_file_get_basename (file);
	_tmp2_ = _tmp1_;
	self = (DirectPhotoPage*) editing_host_page_construct (object_type, (SourceCollection*) _tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
	self->priv->fullscreen = fullscreen;
	if (!direct_photo_page_check_editable_file (file)) {
		GApplication* _tmp3_;
		_tmp3_ = g_application_get_default ();
		photos_application_panic (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, PHOTOS_TYPE_APPLICATION, PhotosApplication));
		return self;
	}
	_tmp4_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->initial_file);
	self->priv->initial_file = _tmp4_;
	_tmp5_ = direct_view_collection_new ();
	_data_collection_unref0 (self->priv->view_controller);
	self->priv->view_controller = _tmp5_;
	_tmp6_ = g_file_get_parent (file);
	_g_object_unref0 (self->priv->current_save_dir);
	self->priv->current_save_dir = _tmp6_;
	_tmp7_ = direct_photo_global;
	g_signal_connect_object ((DataCollection*) _tmp7_, "items-altered", (GCallback) _direct_photo_page_on_photos_altered_data_collection_items_altered, self, 0);
	_tmp8_ = page_get_view ((Page*) self);
	_tmp9_ = _tmp8_;
	g_signal_connect_object (_tmp9_, "selection-group-altered", (GCallback) _direct_photo_page_on_selection_group_altered_view_collection_selection_group_altered, self, 0);
	_data_collection_unref0 (_tmp9_);
	return self;
}

DirectPhotoPage*
direct_photo_page_new (GFile* file,
                       gboolean fullscreen)
{
	return direct_photo_page_construct (TYPE_DIRECT_PHOTO_PAGE, file, fullscreen);
}

static void
_direct_photo_page_on_save_gcallback (GtkAction* action,
                                      gpointer self)
{
	direct_photo_page_on_save ((DirectPhotoPage*) self);
}

static void
_direct_photo_page_on_save_as_gcallback (GtkAction* action,
                                         gpointer self)
{
	direct_photo_page_on_save_as ((DirectPhotoPage*) self);
}

static void
_direct_photo_page_on_print_gcallback (GtkAction* action,
                                       gpointer self)
{
	direct_photo_page_on_print ((DirectPhotoPage*) self);
}

static void
_editing_host_page_on_rotate_clockwise_gcallback (GtkAction* action,
                                                  gpointer self)
{
	editing_host_page_on_rotate_clockwise ((EditingHostPage*) self);
}

static void
_editing_host_page_on_rotate_counterclockwise_gcallback (GtkAction* action,
                                                         gpointer self)
{
	editing_host_page_on_rotate_counterclockwise ((EditingHostPage*) self);
}

static void
_editing_host_page_on_enhance_gcallback (GtkAction* action,
                                         gpointer self)
{
	editing_host_page_on_enhance ((EditingHostPage*) self);
}

static void
_editing_host_page_toggle_crop_gcallback (GtkAction* action,
                                          gpointer self)
{
	editing_host_page_toggle_crop ((EditingHostPage*) self);
}

static void
_editing_host_page_toggle_straighten_gcallback (GtkAction* action,
                                                gpointer self)
{
	editing_host_page_toggle_straighten ((EditingHostPage*) self);
}

static void
_editing_host_page_toggle_redeye_gcallback (GtkAction* action,
                                            gpointer self)
{
	editing_host_page_toggle_redeye ((EditingHostPage*) self);
}

static void
_editing_host_page_toggle_adjust_gcallback (GtkAction* action,
                                            gpointer self)
{
	editing_host_page_toggle_adjust ((EditingHostPage*) self);
}

static void
_editing_host_page_on_revert_gcallback (GtkAction* action,
                                        gpointer self)
{
	editing_host_page_on_revert ((EditingHostPage*) self);
}

static void
_editing_host_page_on_adjust_date_time_gcallback (GtkAction* action,
                                                  gpointer self)
{
	editing_host_page_on_adjust_date_time ((EditingHostPage*) self);
}

static void
_editing_host_page_on_increase_size_gcallback (GtkAction* action,
                                               gpointer self)
{
	editing_host_page_on_increase_size ((EditingHostPage*) self);
}

static void
_editing_host_page_on_decrease_size_gcallback (GtkAction* action,
                                               gpointer self)
{
	editing_host_page_on_decrease_size ((EditingHostPage*) self);
}

static void
_editing_host_page_snap_zoom_to_min_gcallback (GtkAction* action,
                                               gpointer self)
{
	editing_host_page_snap_zoom_to_min ((EditingHostPage*) self);
}

static void
_editing_host_page_snap_zoom_to_isomorphic_gcallback (GtkAction* action,
                                                      gpointer self)
{
	editing_host_page_snap_zoom_to_isomorphic ((EditingHostPage*) self);
}

static void
_editing_host_page_snap_zoom_to_max_gcallback (GtkAction* action,
                                               gpointer self)
{
	editing_host_page_snap_zoom_to_max ((EditingHostPage*) self);
}

static void
_editing_host_page_on_copy_image_gcallback (GtkAction* action,
                                            gpointer self)
{
	editing_host_page_on_copy_image ((EditingHostPage*) self);
}

static void
_editing_host_page_on_copy_metadata_gcallback (GtkAction* action,
                                               gpointer self)
{
	editing_host_page_on_copy_metadata ((EditingHostPage*) self);
}

static void
_vala_array_add129 (GtkActionEntry* * array,
                    gint* length,
                    gint* size,
                    const GtkActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add130 (GtkActionEntry* * array,
                    gint* length,
                    gint* size,
                    const GtkActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add131 (GtkActionEntry* * array,
                    gint* length,
                    gint* size,
                    const GtkActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add132 (GtkActionEntry* * array,
                    gint* length,
                    gint* size,
                    const GtkActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add133 (GtkActionEntry* * array,
                    gint* length,
                    gint* size,
                    const GtkActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add134 (GtkActionEntry* * array,
                    gint* length,
                    gint* size,
                    const GtkActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add135 (GtkActionEntry* * array,
                    gint* length,
                    gint* size,
                    const GtkActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add136 (GtkActionEntry* * array,
                    gint* length,
                    gint* size,
                    const GtkActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add137 (GtkActionEntry* * array,
                    gint* length,
                    gint* size,
                    const GtkActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add138 (GtkActionEntry* * array,
                    gint* length,
                    gint* size,
                    const GtkActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add139 (GtkActionEntry* * array,
                    gint* length,
                    gint* size,
                    const GtkActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add140 (GtkActionEntry* * array,
                    gint* length,
                    gint* size,
                    const GtkActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add141 (GtkActionEntry* * array,
                    gint* length,
                    gint* size,
                    const GtkActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add142 (GtkActionEntry* * array,
                    gint* length,
                    gint* size,
                    const GtkActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add143 (GtkActionEntry* * array,
                    gint* length,
                    gint* size,
                    const GtkActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add144 (GtkActionEntry* * array,
                    gint* length,
                    gint* size,
                    const GtkActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add145 (GtkActionEntry* * array,
                    gint* length,
                    gint* size,
                    const GtkActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add146 (GtkActionEntry* * array,
                    gint* length,
                    gint* size,
                    const GtkActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add147 (GtkActionEntry* * array,
                    gint* length,
                    gint* size,
                    const GtkActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static GtkActionEntry*
direct_photo_page_real_init_collect_action_entries (Page* base,
                                                    gint* result_length1)
{
	DirectPhotoPage * self;
	GtkActionEntry save = {0};
	GtkActionEntry _tmp0_ = {0};
	GtkActionEntry save_as = {0};
	GtkActionEntry _tmp1_ = {0};
	GtkActionEntry print = {0};
	GtkActionEntry _tmp2_ = {0};
	GtkActionEntry rotate_right = {0};
	GtkActionEntry _tmp3_ = {0};
	GtkActionEntry rotate_left = {0};
	GtkActionEntry _tmp4_ = {0};
	GtkActionEntry enhance = {0};
	GtkActionEntry _tmp5_ = {0};
	GtkActionEntry crop = {0};
	GtkActionEntry _tmp6_ = {0};
	GtkActionEntry straighten = {0};
	GtkActionEntry _tmp7_ = {0};
	GtkActionEntry red_eye = {0};
	GtkActionEntry _tmp8_ = {0};
	GtkActionEntry adjust = {0};
	GtkActionEntry _tmp9_ = {0};
	GtkActionEntry revert = {0};
	GtkActionEntry _tmp10_ = {0};
	GtkActionEntry adjust_date_time = {0};
	GtkActionEntry _tmp11_ = {0};
	GtkActionEntry increase_size = {0};
	GtkActionEntry _tmp12_ = {0};
	GtkActionEntry decrease_size = {0};
	GtkActionEntry _tmp13_ = {0};
	GtkActionEntry best_fit = {0};
	GtkActionEntry _tmp14_ = {0};
	GtkActionEntry actual_size = {0};
	GtkActionEntry _tmp15_ = {0};
	GtkActionEntry max_size = {0};
	GtkActionEntry _tmp16_ = {0};
	GtkActionEntry copy_image = {0};
	GtkActionEntry _tmp17_ = {0};
	GtkActionEntry copy_metadata = {0};
	GtkActionEntry _tmp18_ = {0};
	GtkActionEntry* actions = NULL;
	gint _tmp19_ = 0;
	GtkActionEntry* _tmp20_;
	gint actions_length1;
	gint _actions_size_;
	GtkActionEntry _tmp21_;
	GtkActionEntry _tmp22_;
	GtkActionEntry _tmp23_;
	GtkActionEntry _tmp24_;
	GtkActionEntry _tmp25_;
	GtkActionEntry _tmp26_;
	GtkActionEntry _tmp27_;
	GtkActionEntry _tmp28_;
	GtkActionEntry _tmp29_;
	GtkActionEntry _tmp30_;
	GtkActionEntry _tmp31_;
	GtkActionEntry _tmp32_;
	GtkActionEntry _tmp33_;
	GtkActionEntry _tmp34_;
	GtkActionEntry _tmp35_;
	GtkActionEntry _tmp36_;
	GtkActionEntry _tmp37_;
	GtkActionEntry _tmp38_;
	GtkActionEntry _tmp39_;
	GtkActionEntry* _tmp40_;
	gint _tmp40__length1;
	GtkActionEntry* result;
	self = (DirectPhotoPage*) base;
	_tmp0_.name = "Save";
	_tmp0_.stock_id = NULL;
	_tmp0_.label = NULL;
	_tmp0_.accelerator = "<Ctrl>S";
	_tmp0_.tooltip = NULL;
	_tmp0_.callback = (GCallback) _direct_photo_page_on_save_gcallback;
	save = _tmp0_;
	_tmp1_.name = "SaveAs";
	_tmp1_.stock_id = NULL;
	_tmp1_.label = NULL;
	_tmp1_.accelerator = "<Ctrl><Shift>S";
	_tmp1_.tooltip = NULL;
	_tmp1_.callback = (GCallback) _direct_photo_page_on_save_as_gcallback;
	save_as = _tmp1_;
	_tmp2_.name = "Print";
	_tmp2_.stock_id = NULL;
	_tmp2_.label = NULL;
	_tmp2_.accelerator = "<Ctrl>P";
	_tmp2_.tooltip = NULL;
	_tmp2_.callback = (GCallback) _direct_photo_page_on_print_gcallback;
	print = _tmp2_;
	_tmp3_.name = "RotateClockwise";
	_tmp3_.stock_id = NULL;
	_tmp3_.label = NULL;
	_tmp3_.accelerator = "<Ctrl>R";
	_tmp3_.tooltip = NULL;
	_tmp3_.callback = (GCallback) _editing_host_page_on_rotate_clockwise_gcallback;
	rotate_right = _tmp3_;
	_tmp4_.name = "RotateCounterclockwise";
	_tmp4_.stock_id = NULL;
	_tmp4_.label = NULL;
	_tmp4_.accelerator = "<Ctrl><Shift>R";
	_tmp4_.tooltip = NULL;
	_tmp4_.callback = (GCallback) _editing_host_page_on_rotate_counterclockwise_gcallback;
	rotate_left = _tmp4_;
	_tmp5_.name = "Enhance";
	_tmp5_.stock_id = NULL;
	_tmp5_.label = NULL;
	_tmp5_.accelerator = "<Ctrl>E";
	_tmp5_.tooltip = NULL;
	_tmp5_.callback = (GCallback) _editing_host_page_on_enhance_gcallback;
	enhance = _tmp5_;
	_tmp6_.name = "Crop";
	_tmp6_.stock_id = NULL;
	_tmp6_.label = NULL;
	_tmp6_.accelerator = "<Ctrl>O";
	_tmp6_.tooltip = NULL;
	_tmp6_.callback = (GCallback) _editing_host_page_toggle_crop_gcallback;
	crop = _tmp6_;
	_tmp7_.name = "Straighten";
	_tmp7_.stock_id = NULL;
	_tmp7_.label = NULL;
	_tmp7_.accelerator = "<Ctrl>A";
	_tmp7_.tooltip = NULL;
	_tmp7_.callback = (GCallback) _editing_host_page_toggle_straighten_gcallback;
	straighten = _tmp7_;
	_tmp8_.name = "RedEye";
	_tmp8_.stock_id = NULL;
	_tmp8_.label = NULL;
	_tmp8_.accelerator = "<Ctrl>Y";
	_tmp8_.tooltip = NULL;
	_tmp8_.callback = (GCallback) _editing_host_page_toggle_redeye_gcallback;
	red_eye = _tmp8_;
	_tmp9_.name = "Adjust";
	_tmp9_.stock_id = NULL;
	_tmp9_.label = NULL;
	_tmp9_.accelerator = "<Ctrl>D";
	_tmp9_.tooltip = NULL;
	_tmp9_.callback = (GCallback) _editing_host_page_toggle_adjust_gcallback;
	adjust = _tmp9_;
	_tmp10_.name = "Revert";
	_tmp10_.stock_id = NULL;
	_tmp10_.label = NULL;
	_tmp10_.accelerator = NULL;
	_tmp10_.tooltip = NULL;
	_tmp10_.callback = (GCallback) _editing_host_page_on_revert_gcallback;
	revert = _tmp10_;
	_tmp11_.name = "AdjustDateTime";
	_tmp11_.stock_id = NULL;
	_tmp11_.label = NULL;
	_tmp11_.accelerator = NULL;
	_tmp11_.tooltip = NULL;
	_tmp11_.callback = (GCallback) _editing_host_page_on_adjust_date_time_gcallback;
	adjust_date_time = _tmp11_;
	_tmp12_.name = "IncreaseSize";
	_tmp12_.stock_id = NULL;
	_tmp12_.label = NULL;
	_tmp12_.accelerator = "<Ctrl>plus";
	_tmp12_.tooltip = NULL;
	_tmp12_.callback = (GCallback) _editing_host_page_on_increase_size_gcallback;
	increase_size = _tmp12_;
	_tmp13_.name = "DecreaseSize";
	_tmp13_.stock_id = NULL;
	_tmp13_.label = NULL;
	_tmp13_.accelerator = "<Ctrl>minus";
	_tmp13_.tooltip = NULL;
	_tmp13_.callback = (GCallback) _editing_host_page_on_decrease_size_gcallback;
	decrease_size = _tmp13_;
	_tmp14_.name = "ZoomFit";
	_tmp14_.stock_id = NULL;
	_tmp14_.label = NULL;
	_tmp14_.accelerator = "<Ctrl>0";
	_tmp14_.tooltip = NULL;
	_tmp14_.callback = (GCallback) _editing_host_page_snap_zoom_to_min_gcallback;
	best_fit = _tmp14_;
	_tmp15_.name = "Zoom100";
	_tmp15_.stock_id = NULL;
	_tmp15_.label = NULL;
	_tmp15_.accelerator = "<Ctrl>1";
	_tmp15_.tooltip = NULL;
	_tmp15_.callback = (GCallback) _editing_host_page_snap_zoom_to_isomorphic_gcallback;
	actual_size = _tmp15_;
	_tmp16_.name = "Zoom200";
	_tmp16_.stock_id = NULL;
	_tmp16_.label = NULL;
	_tmp16_.accelerator = "<Ctrl>2";
	_tmp16_.tooltip = NULL;
	_tmp16_.callback = (GCallback) _editing_host_page_snap_zoom_to_max_gcallback;
	max_size = _tmp16_;
	_tmp17_.name = "CopyImage";
	_tmp17_.stock_id = NULL;
	_tmp17_.label = NULL;
	_tmp17_.accelerator = "<Ctrl>C";
	_tmp17_.tooltip = NULL;
	_tmp17_.callback = (GCallback) _editing_host_page_on_copy_image_gcallback;
	copy_image = _tmp17_;
	_tmp18_.name = "CopyMetadata";
	_tmp18_.stock_id = NULL;
	_tmp18_.label = NULL;
	_tmp18_.accelerator = "<Ctrl><Shift>C";
	_tmp18_.tooltip = NULL;
	_tmp18_.callback = (GCallback) _editing_host_page_on_copy_metadata_gcallback;
	copy_metadata = _tmp18_;
	_tmp20_ = PAGE_CLASS (direct_photo_page_parent_class)->init_collect_action_entries ((Page*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_EDITING_HOST_PAGE, EditingHostPage), &_tmp19_);
	actions = _tmp20_;
	actions_length1 = _tmp19_;
	_actions_size_ = actions_length1;
	_tmp21_ = save;
	_vala_array_add129 (&actions, &actions_length1, &_actions_size_, &_tmp21_);
	_tmp22_ = save_as;
	_vala_array_add130 (&actions, &actions_length1, &_actions_size_, &_tmp22_);
	_tmp23_ = print;
	_vala_array_add131 (&actions, &actions_length1, &_actions_size_, &_tmp23_);
	_tmp24_ = rotate_right;
	_vala_array_add132 (&actions, &actions_length1, &_actions_size_, &_tmp24_);
	_tmp25_ = rotate_left;
	_vala_array_add133 (&actions, &actions_length1, &_actions_size_, &_tmp25_);
	_tmp26_ = enhance;
	_vala_array_add134 (&actions, &actions_length1, &_actions_size_, &_tmp26_);
	_tmp27_ = crop;
	_vala_array_add135 (&actions, &actions_length1, &_actions_size_, &_tmp27_);
	_tmp28_ = straighten;
	_vala_array_add136 (&actions, &actions_length1, &_actions_size_, &_tmp28_);
	_tmp29_ = red_eye;
	_vala_array_add137 (&actions, &actions_length1, &_actions_size_, &_tmp29_);
	_tmp30_ = adjust;
	_vala_array_add138 (&actions, &actions_length1, &_actions_size_, &_tmp30_);
	_tmp31_ = revert;
	_vala_array_add139 (&actions, &actions_length1, &_actions_size_, &_tmp31_);
	_tmp32_ = adjust_date_time;
	_vala_array_add140 (&actions, &actions_length1, &_actions_size_, &_tmp32_);
	_tmp33_ = increase_size;
	_vala_array_add141 (&actions, &actions_length1, &_actions_size_, &_tmp33_);
	_tmp34_ = decrease_size;
	_vala_array_add142 (&actions, &actions_length1, &_actions_size_, &_tmp34_);
	_tmp35_ = best_fit;
	_vala_array_add143 (&actions, &actions_length1, &_actions_size_, &_tmp35_);
	_tmp36_ = actual_size;
	_vala_array_add144 (&actions, &actions_length1, &_actions_size_, &_tmp36_);
	_tmp37_ = max_size;
	_vala_array_add145 (&actions, &actions_length1, &_actions_size_, &_tmp37_);
	_tmp38_ = copy_image;
	_vala_array_add146 (&actions, &actions_length1, &_actions_size_, &_tmp38_);
	_tmp39_ = copy_metadata;
	_vala_array_add147 (&actions, &actions_length1, &_actions_size_, &_tmp39_);
	_tmp40_ = actions;
	_tmp40__length1 = actions_length1;
	if (result_length1) {
		*result_length1 = _tmp40__length1;
	}
	result = _tmp40_;
	return result;
}

static gboolean
direct_photo_page_check_editable_file (GFile* file)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = g_file_get_path (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = !g_file_test (_tmp1_, G_FILE_TEST_EXISTS);
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp3_ = g_file_get_path (file);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf (_ ("%s does not exist."), _tmp4_);
		_tmp6_ = _tmp5_;
		app_window_error_message (_tmp6_, NULL, NULL);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
	} else {
		gchar* _tmp7_;
		gchar* _tmp8_;
		gboolean _tmp9_;
		_tmp7_ = g_file_get_path (file);
		_tmp8_ = _tmp7_;
		_tmp9_ = !g_file_test (_tmp8_, G_FILE_TEST_IS_REGULAR);
		_g_free0 (_tmp8_);
		if (_tmp9_) {
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp10_ = g_file_get_path (file);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strdup_printf (_ ("%s is not a file."), _tmp11_);
			_tmp13_ = _tmp12_;
			app_window_error_message (_tmp13_, NULL, NULL);
			_g_free0 (_tmp13_);
			_g_free0 (_tmp11_);
		} else {
			if (!photo_file_format_is_file_supported (file)) {
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				_tmp14_ = g_file_get_path (file);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_strdup_printf (_ ("%s does not support the file format of\n%s."), _ (RESOURCES_APP_TITLE), _tmp15_);
				_tmp17_ = _tmp16_;
				app_window_error_message (_tmp17_, NULL, NULL);
				_g_free0 (_tmp17_);
				_g_free0 (_tmp15_);
			} else {
				result = TRUE;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}

static void
direct_photo_page_real_realize (GtkWidget* base)
{
	DirectPhotoPage * self;
	DirectPhoto* photo = NULL;
	DirectPhotoSourceCollection* _tmp0_;
	GFile* _tmp1_;
	DirectPhoto* _tmp2_;
	DirectViewCollection* _tmp3_;
	self = (DirectPhotoPage*) base;
	if (GTK_WIDGET_CLASS (direct_photo_page_parent_class)->realize != NULL) {
		GTK_WIDGET_CLASS (direct_photo_page_parent_class)->realize ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_EDITING_HOST_PAGE, EditingHostPage));
	}
	_tmp0_ = direct_photo_global;
	_tmp1_ = self->priv->initial_file;
	_tmp2_ = direct_photo_source_collection_get_file_source (_tmp0_, _tmp1_);
	photo = _tmp2_;
	_tmp3_ = self->priv->view_controller;
	editing_host_page_display_mirror_of ((EditingHostPage*) self, (ViewCollection*) _tmp3_, (Photo*) photo);
	_g_object_unref0 (self->priv->initial_file);
	self->priv->initial_file = NULL;
	_g_object_unref0 (photo);
}

static void
direct_photo_page_real_photo_changing (EditingHostPage* base,
                                       Photo* new_photo)
{
	DirectPhotoPage * self;
	self = (DirectPhotoPage*) base;
	g_return_if_fail (new_photo != NULL);
	direct_photo_demand_load (G_TYPE_CHECK_INSTANCE_CAST (new_photo, TYPE_DIRECT_PHOTO, DirectPhoto));
}

GFile*
direct_photo_page_get_current_file (DirectPhotoPage* self)
{
	Photo* _tmp0_;
	Photo* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = editing_host_page_get_photo ((EditingHostPage*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = media_source_get_file ((MediaSource*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		DirectPhotoPage* self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->adjust_datetime_action);
		_g_object_unref0 (_data9_->revert_action);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static void
___lambda42_ (Block9Data* _data9_)
{
	DirectPhotoPage* self;
	GtkAction* _tmp0_;
	self = _data9_->self;
	_tmp0_ = _data9_->revert_action;
	gtk_action_activate (_tmp0_);
}

static void
____lambda42__gtk_menu_item_activate (GtkMenuItem* _sender,
                                      gpointer self)
{
	___lambda42_ (self);
}

static void
___lambda43_ (Block9Data* _data9_)
{
	DirectPhotoPage* self;
	GtkAction* _tmp0_;
	self = _data9_->self;
	_tmp0_ = _data9_->adjust_datetime_action;
	gtk_action_activate (_tmp0_);
}

static void
____lambda43__gtk_menu_item_activate (GtkMenuItem* _sender,
                                      gpointer self)
{
	___lambda43_ (self);
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		DirectPhotoPage* self;
		self = _data10_->_data9_->self;
		_g_object_unref0 (_data10_->print_action);
		_g_object_unref0 (_data10_->copy_metadata_action);
		_g_object_unref0 (_data10_->copy_image_action);
		block9_data_unref (_data10_->_data9_);
		_data10_->_data9_ = NULL;
		g_slice_free (Block10Data, _data10_);
	}
}

static void
____lambda44_ (Block10Data* _data10_)
{
	Block9Data* _data9_;
	DirectPhotoPage* self;
	GtkAction* _tmp0_;
	_data9_ = _data10_->_data9_;
	self = _data9_->self;
	_tmp0_ = _data10_->copy_image_action;
	gtk_action_activate (_tmp0_);
}

static void
_____lambda44__gtk_menu_item_activate (GtkMenuItem* _sender,
                                       gpointer self)
{
	____lambda44_ (self);
}

static void
____lambda45_ (Block10Data* _data10_)
{
	Block9Data* _data9_;
	DirectPhotoPage* self;
	GtkAction* _tmp0_;
	_data9_ = _data10_->_data9_;
	self = _data9_->self;
	_tmp0_ = _data10_->copy_metadata_action;
	gtk_action_activate (_tmp0_);
}

static void
_____lambda45__gtk_menu_item_activate (GtkMenuItem* _sender,
                                       gpointer self)
{
	____lambda45_ (self);
}

static void
____lambda46_ (Block10Data* _data10_)
{
	Block9Data* _data9_;
	DirectPhotoPage* self;
	GtkAction* _tmp0_;
	_data9_ = _data10_->_data9_;
	self = _data9_->self;
	_tmp0_ = _data10_->print_action;
	gtk_action_activate (_tmp0_);
}

static void
_____lambda46__gtk_menu_item_activate (GtkMenuItem* _sender,
                                       gpointer self)
{
	____lambda46_ (self);
}

static gboolean
direct_photo_page_real_on_context_buttonpress (Page* base,
                                               GdkEventButton* event)
{
	DirectPhotoPage * self;
	GtkMenu* _tmp0_;
	GtkMenu* _tmp79_;
	GtkMenu* _tmp80_;
	gboolean result;
	self = (DirectPhotoPage*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->context_menu;
	if (_tmp0_ == NULL) {
		Block9Data* _data9_;
		GtkWidget* _tmp1_;
		GtkMenu* _tmp2_ = NULL;
		GtkMenuItem* revert_menu_item = NULL;
		GtkMenuItem* _tmp3_;
		GtkAction* _tmp4_;
		GtkAction* _tmp5_;
		GtkMenuItem* _tmp6_;
		GtkMenuItem* _tmp7_;
		GtkMenuItem* adjust_datetime_menu_item = NULL;
		GtkMenuItem* _tmp8_;
		GtkAction* _tmp9_;
		GtkAction* _tmp10_;
		GtkMenuItem* _tmp11_;
		GtkMenuItem* _tmp12_;
		GtkMenu* _tmp13_;
		GtkMenuItem* _tmp14_;
		GtkMenu* _tmp15_;
		GtkSeparatorMenuItem* _tmp16_;
		GtkSeparatorMenuItem* _tmp17_;
		GtkMenu* _tmp18_;
		GtkMenuItem* _tmp19_;
		GtkMenu* _tmp78_;
		_data9_ = g_slice_new0 (Block9Data);
		_data9_->_ref_count_ = 1;
		_data9_->self = g_object_ref (self);
		_tmp1_ = _g_object_ref0 ((GtkWidget*) self);
		_tmp2_ = (GtkMenu*) gtk_menu_new ();
		g_object_set (_tmp2_, "attach-widget", _tmp1_, NULL);
		_g_object_unref0 (_tmp1_);
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (self->priv->context_menu);
		self->priv->context_menu = _tmp2_;
		_tmp3_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (RESOURCES_REVERT_MENU);
		g_object_ref_sink (_tmp3_);
		revert_menu_item = _tmp3_;
		_tmp4_ = page_get_action ((Page*) self, "Revert");
		_data9_->revert_action = _tmp4_;
		_tmp5_ = _data9_->revert_action;
		_tmp6_ = revert_menu_item;
		g_object_bind_property_with_closures ((GObject*) _tmp5_, "sensitive", (GObject*) _tmp6_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
		_tmp7_ = revert_menu_item;
		g_signal_connect_data (_tmp7_, "activate", (GCallback) ____lambda42__gtk_menu_item_activate, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
		_tmp8_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (RESOURCES_ADJUST_DATE_TIME_MENU);
		g_object_ref_sink (_tmp8_);
		adjust_datetime_menu_item = _tmp8_;
		_tmp9_ = page_get_action ((Page*) self, "AdjustDateTime");
		_data9_->adjust_datetime_action = _tmp9_;
		_tmp10_ = _data9_->adjust_datetime_action;
		_tmp11_ = adjust_datetime_menu_item;
		g_object_bind_property_with_closures ((GObject*) _tmp10_, "sensitive", (GObject*) _tmp11_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
		_tmp12_ = adjust_datetime_menu_item;
		g_signal_connect_data (_tmp12_, "activate", (GCallback) ____lambda43__gtk_menu_item_activate, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
		_tmp13_ = self->priv->context_menu;
		_tmp14_ = revert_menu_item;
		gtk_container_add ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_);
		_tmp15_ = self->priv->context_menu;
		_tmp16_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
		g_object_ref_sink (_tmp16_);
		_tmp17_ = _tmp16_;
		gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp17_);
		_g_object_unref0 (_tmp17_);
		_tmp18_ = self->priv->context_menu;
		_tmp19_ = adjust_datetime_menu_item;
		gtk_container_add ((GtkContainer*) _tmp18_, (GtkWidget*) _tmp19_);
		if (self->priv->fullscreen == FALSE) {
			Block10Data* _data10_;
			GtkMenuItem* copy_image_menu_item = NULL;
			GtkMenuItem* _tmp20_;
			GtkAction* _tmp21_;
			GtkMenuItem* _tmp22_;
			GtkMenuItem* copy_metadata_menu_item = NULL;
			GtkMenuItem* _tmp23_;
			GtkAction* _tmp24_;
			GtkMenuItem* _tmp25_;
			GtkMenuItem* open_menu_item = NULL;
			gchar* _tmp26_;
			GtkMenuItem* _tmp27_ = NULL;
			GtkMenuItem* print_menu_item = NULL;
			GtkMenuItem* _tmp28_;
			GtkAction* _tmp29_;
			GtkAction* _tmp30_;
			GtkMenuItem* _tmp31_;
			GtkMenuItem* _tmp32_;
			GtkMenuItem* wallpaper_menuitem = NULL;
			gchar* _tmp33_;
			GtkMenuItem* _tmp34_ = NULL;
			GtkMenuItem* contractor_menu_item = NULL;
			GtkMenuItem* _tmp35_;
			GtkMenu* _tmp36_;
			GtkMenu* _tmp37_;
			GtkMenuItem* _tmp38_;
			GtkMenu* _tmp39_;
			GtkMenuItem* _tmp40_;
			GtkMenuItem* _tmp41_;
			GtkMenu* _tmp42_;
			GtkMenu* _tmp43_;
			GtkSeparatorMenuItem* _tmp44_;
			GtkSeparatorMenuItem* _tmp45_;
			GtkMenu* _tmp46_;
			GtkMenuItem* _tmp47_;
			GtkMenu* _tmp48_;
			GtkMenuItem* _tmp49_;
			GtkMenu* _tmp50_;
			GtkSeparatorMenuItem* _tmp51_;
			GtkSeparatorMenuItem* _tmp52_;
			GtkMenu* _tmp53_;
			GtkMenuItem* _tmp54_;
			GtkMenu* _tmp55_;
			GtkMenuItem* _tmp56_;
			DataSource* source = NULL;
			ViewCollection* _tmp57_;
			ViewCollection* _tmp58_;
			DataView* _tmp59_;
			DataView* _tmp60_;
			DataSource* _tmp61_;
			DataSource* _tmp62_;
			DataSource* _tmp63_;
			DataSource* _tmp64_;
			gboolean _tmp65_ = FALSE;
			DataSource* _tmp66_;
			_data10_ = g_slice_new0 (Block10Data);
			_data10_->_ref_count_ = 1;
			_data10_->_data9_ = block9_data_ref (_data9_);
			_tmp20_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (RESOURCES_COPY_IMAGE_LABEL);
			g_object_ref_sink (_tmp20_);
			copy_image_menu_item = _tmp20_;
			_tmp21_ = page_get_action ((Page*) self, "CopyImage");
			_data10_->copy_image_action = _tmp21_;
			_tmp22_ = copy_image_menu_item;
			g_signal_connect_data (_tmp22_, "activate", (GCallback) _____lambda44__gtk_menu_item_activate, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
			_tmp23_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (RESOURCES_COPY_METADATA_LABEL);
			g_object_ref_sink (_tmp23_);
			copy_metadata_menu_item = _tmp23_;
			_tmp24_ = page_get_action ((Page*) self, "CopyMetadata");
			_data10_->copy_metadata_action = _tmp24_;
			_tmp25_ = copy_metadata_menu_item;
			g_signal_connect_data (_tmp25_, "activate", (GCallback) _____lambda45__gtk_menu_item_activate, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
			_tmp26_ = g_strdup (APP_WINDOW_ACTION_PREFIX APP_WINDOW_ACTION_JUMP_TO_FILE);
			_tmp27_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Show in Files"));
			gtk_actionable_set_action_name ((GtkActionable*) _tmp27_, _tmp26_);
			_g_free0 (_tmp26_);
			g_object_ref_sink (_tmp27_);
			open_menu_item = _tmp27_;
			_tmp28_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (RESOURCES_PRINT_MENU);
			g_object_ref_sink (_tmp28_);
			print_menu_item = _tmp28_;
			_tmp29_ = page_get_action ((Page*) self, "Print");
			_data10_->print_action = _tmp29_;
			_tmp30_ = _data10_->print_action;
			_tmp31_ = print_menu_item;
			g_object_bind_property_with_closures ((GObject*) _tmp30_, "sensitive", (GObject*) _tmp31_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
			_tmp32_ = print_menu_item;
			g_signal_connect_data (_tmp32_, "activate", (GCallback) _____lambda46__gtk_menu_item_activate, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
			_tmp33_ = g_strdup (APP_WINDOW_ACTION_PREFIX APP_WINDOW_ACTION_SET_WALLPAPER);
			_tmp34_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Set as Wallpaper"));
			gtk_actionable_set_action_name ((GtkActionable*) _tmp34_, _tmp33_);
			_g_free0 (_tmp33_);
			g_object_ref_sink (_tmp34_);
			wallpaper_menuitem = _tmp34_;
			_tmp35_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("Other Actions"));
			g_object_ref_sink (_tmp35_);
			contractor_menu_item = _tmp35_;
			_tmp36_ = (GtkMenu*) gtk_menu_new ();
			g_object_ref_sink (_tmp36_);
			_g_object_unref0 (self->priv->contractor_menu);
			self->priv->contractor_menu = _tmp36_;
			_tmp37_ = self->priv->contractor_menu;
			_tmp38_ = print_menu_item;
			gtk_container_add ((GtkContainer*) _tmp37_, (GtkWidget*) _tmp38_);
			_tmp39_ = self->priv->contractor_menu;
			_tmp40_ = wallpaper_menuitem;
			gtk_container_add ((GtkContainer*) _tmp39_, (GtkWidget*) _tmp40_);
			_tmp41_ = contractor_menu_item;
			_tmp42_ = self->priv->contractor_menu;
			gtk_menu_item_set_submenu (_tmp41_, _tmp42_);
			_tmp43_ = self->priv->context_menu;
			_tmp44_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
			g_object_ref_sink (_tmp44_);
			_tmp45_ = _tmp44_;
			gtk_container_add ((GtkContainer*) _tmp43_, (GtkWidget*) _tmp45_);
			_g_object_unref0 (_tmp45_);
			_tmp46_ = self->priv->context_menu;
			_tmp47_ = copy_image_menu_item;
			gtk_container_add ((GtkContainer*) _tmp46_, (GtkWidget*) _tmp47_);
			_tmp48_ = self->priv->context_menu;
			_tmp49_ = copy_metadata_menu_item;
			gtk_container_add ((GtkContainer*) _tmp48_, (GtkWidget*) _tmp49_);
			_tmp50_ = self->priv->context_menu;
			_tmp51_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
			g_object_ref_sink (_tmp51_);
			_tmp52_ = _tmp51_;
			gtk_container_add ((GtkContainer*) _tmp50_, (GtkWidget*) _tmp52_);
			_g_object_unref0 (_tmp52_);
			_tmp53_ = self->priv->context_menu;
			_tmp54_ = open_menu_item;
			gtk_container_add ((GtkContainer*) _tmp53_, (GtkWidget*) _tmp54_);
			_tmp55_ = self->priv->context_menu;
			_tmp56_ = contractor_menu_item;
			gtk_container_add ((GtkContainer*) _tmp55_, (GtkWidget*) _tmp56_);
			_tmp57_ = page_get_view ((Page*) self);
			_tmp58_ = _tmp57_;
			_tmp59_ = view_collection_get_selected_at (_tmp58_, 0);
			_tmp60_ = _tmp59_;
			_tmp61_ = data_view_get_source (_tmp60_);
			_tmp62_ = _tmp61_;
			_tmp63_ = _g_object_ref0 (_tmp62_);
			_tmp64_ = _tmp63_;
			_g_object_unref0 (_tmp60_);
			_data_collection_unref0 (_tmp58_);
			source = _tmp64_;
			_tmp66_ = source;
			if (_tmp66_ != NULL) {
				DataSource* _tmp67_;
				_tmp67_ = source;
				_tmp65_ = IS_PHOTO (_tmp67_);
			} else {
				_tmp65_ = FALSE;
			}
			if (_tmp65_) {
				GFile* file = NULL;
				Photo* _tmp68_;
				Photo* _tmp69_;
				GFile* _tmp70_;
				GFile* _tmp71_;
				GtkMenuItem* _tmp72_;
				GFile* _tmp73_;
				gchar* _tmp74_;
				gchar* _tmp75_;
				GVariant* _tmp76_;
				GVariant* _tmp77_;
				_tmp68_ = editing_host_page_get_photo ((EditingHostPage*) self);
				_tmp69_ = _tmp68_;
				_tmp70_ = media_source_get_file ((MediaSource*) _tmp69_);
				_tmp71_ = _tmp70_;
				_g_object_unref0 (_tmp69_);
				file = _tmp71_;
				_tmp72_ = wallpaper_menuitem;
				_tmp73_ = file;
				_tmp74_ = g_file_get_uri (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = g_variant_new_string (_tmp75_);
				g_variant_ref_sink (_tmp76_);
				_tmp77_ = _tmp76_;
				g_object_set ((GtkActionable*) _tmp72_, "action-target", _tmp77_, NULL);
				_g_variant_unref0 (_tmp77_);
				_g_free0 (_tmp75_);
				_g_object_unref0 (file);
			}
			_g_object_unref0 (source);
			_g_object_unref0 (contractor_menu_item);
			_g_object_unref0 (wallpaper_menuitem);
			_g_object_unref0 (print_menu_item);
			_g_object_unref0 (open_menu_item);
			_g_object_unref0 (copy_metadata_menu_item);
			_g_object_unref0 (copy_image_menu_item);
			block10_data_unref (_data10_);
			_data10_ = NULL;
		}
		_tmp78_ = self->priv->context_menu;
		gtk_widget_show_all ((GtkWidget*) _tmp78_);
		_g_object_unref0 (adjust_datetime_menu_item);
		_g_object_unref0 (revert_menu_item);
		block9_data_unref (_data9_);
		_data9_ = NULL;
	}
	_tmp79_ = self->priv->contractor_menu;
	page_populate_contractor_menu ((Page*) self, _tmp79_);
	_tmp80_ = self->priv->context_menu;
	page_popup_context_menu ((Page*) self, _tmp80_, event);
	result = TRUE;
	return result;
}

static void
direct_photo_page_update_zoom_menu_item_sensitivity (DirectPhotoPage* self)
{
	gboolean _tmp0_ = FALSE;
	ZoomState _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	ZoomState _tmp3_ = {0};
	g_return_if_fail (self != NULL);
	single_photo_page_get_zoom_state ((SinglePhotoPage*) self, &_tmp1_);
	if (!zoom_state_is_max (&_tmp1_)) {
		_tmp0_ = !editing_host_page_get_photo_missing ((EditingHostPage*) self);
	} else {
		_tmp0_ = FALSE;
	}
	page_set_action_sensitive ((Page*) self, "IncreaseSize", _tmp0_);
	single_photo_page_get_zoom_state ((SinglePhotoPage*) self, &_tmp3_);
	if (!zoom_state_is_default (&_tmp3_)) {
		_tmp2_ = !editing_host_page_get_photo_missing ((EditingHostPage*) self);
	} else {
		_tmp2_ = FALSE;
	}
	page_set_action_sensitive ((Page*) self, "DecreaseSize", _tmp2_);
}

static void
direct_photo_page_real_on_increase_size (EditingHostPage* base)
{
	DirectPhotoPage * self;
	self = (DirectPhotoPage*) base;
	EDITING_HOST_PAGE_CLASS (direct_photo_page_parent_class)->on_increase_size (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_EDITING_HOST_PAGE, EditingHostPage));
	direct_photo_page_update_zoom_menu_item_sensitivity (self);
}

static void
direct_photo_page_real_on_decrease_size (EditingHostPage* base)
{
	DirectPhotoPage * self;
	self = (DirectPhotoPage*) base;
	EDITING_HOST_PAGE_CLASS (direct_photo_page_parent_class)->on_decrease_size (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_EDITING_HOST_PAGE, EditingHostPage));
	direct_photo_page_update_zoom_menu_item_sensitivity (self);
}

static void
direct_photo_page_on_photos_altered (DirectPhotoPage* self,
                                     GeeMap* map)
{
	gboolean contains = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean sensitive = FALSE;
	gboolean _tmp12_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (map != NULL);
	contains = FALSE;
	if (editing_host_page_has_photo ((EditingHostPage*) self)) {
		Photo* photo = NULL;
		Photo* _tmp0_;
		_tmp0_ = editing_host_page_get_photo ((EditingHostPage*) self);
		photo = _tmp0_;
		{
			GeeIterator* _object_it = NULL;
			GeeSet* _tmp1_;
			GeeSet* _tmp2_;
			GeeSet* _tmp3_;
			GeeIterator* _tmp4_;
			GeeIterator* _tmp5_;
			_tmp1_ = gee_map_get_keys (map);
			_tmp2_ = _tmp1_;
			_tmp3_ = _tmp2_;
			_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
			_tmp5_ = _tmp4_;
			_g_object_unref0 (_tmp3_);
			_object_it = _tmp5_;
			while (TRUE) {
				GeeIterator* _tmp6_;
				DataObject* object = NULL;
				GeeIterator* _tmp7_;
				gpointer _tmp8_;
				DataObject* _tmp9_;
				Photo* _tmp10_;
				_tmp6_ = _object_it;
				if (!gee_iterator_next (_tmp6_)) {
					break;
				}
				_tmp7_ = _object_it;
				_tmp8_ = gee_iterator_get (_tmp7_);
				object = (DataObject*) _tmp8_;
				_tmp9_ = object;
				_tmp10_ = photo;
				if (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_PHOTO, Photo) == _tmp10_) {
					contains = TRUE;
					_g_object_unref0 (object);
					break;
				}
				_g_object_unref0 (object);
			}
			_g_object_unref0 (_object_it);
		}
		_g_object_unref0 (photo);
	}
	if (editing_host_page_has_photo ((EditingHostPage*) self)) {
		_tmp11_ = !editing_host_page_get_photo_missing ((EditingHostPage*) self);
	} else {
		_tmp11_ = FALSE;
	}
	sensitive = _tmp11_;
	if (sensitive) {
		sensitive = contains;
	}
	if (sensitive) {
		Photo* _tmp13_;
		Photo* _tmp14_;
		_tmp13_ = editing_host_page_get_photo ((EditingHostPage*) self);
		_tmp14_ = _tmp13_;
		_tmp12_ = photo_file_format_can_write (photo_get_file_format (_tmp14_));
		_g_object_unref0 (_tmp14_);
	} else {
		_tmp12_ = FALSE;
	}
	page_set_action_sensitive ((Page*) self, "Save", _tmp12_);
	page_set_action_sensitive ((Page*) self, "Revert", sensitive);
}

static void
direct_photo_page_on_selection_group_altered (DirectPhotoPage* self)
{
	CommandManager* _tmp0_;
	CommandManager* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = page_get_command_manager ((Page*) self);
	_tmp1_ = _tmp0_;
	command_manager_reset (_tmp1_);
	_command_manager_unref0 (_tmp1_);
}

static gboolean
direct_photo_page_real_on_double_click (EditingHostPage* base,
                                        GdkEventButton* event)
{
	DirectPhotoPage * self;
	FullscreenWindow* _tmp0_;
	FullscreenWindow* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	self = (DirectPhotoPage*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = app_window_get_fullscreen ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		AppWindow* _tmp3_;
		AppWindow* _tmp4_;
		_tmp3_ = app_window_get_instance ();
		_tmp4_ = _tmp3_;
		app_window_end_fullscreen (_tmp4_);
		_g_object_unref0 (_tmp4_);
	} else {
		GFile* file = NULL;
		GFile* _tmp5_;
		AppWindow* _tmp6_;
		AppWindow* _tmp7_;
		GFile* _tmp8_;
		DirectPhotoPage* _tmp9_;
		DirectPhotoPage* _tmp10_;
		_tmp5_ = direct_photo_page_get_current_file (self);
		file = _tmp5_;
		_tmp6_ = app_window_get_instance ();
		_tmp7_ = _tmp6_;
		_tmp8_ = file;
		_tmp9_ = direct_photo_page_new (_tmp8_, TRUE);
		g_object_ref_sink (_tmp9_);
		_tmp10_ = _tmp9_;
		app_window_go_fullscreen (_tmp7_, (Page*) _tmp10_);
		_g_object_unref0 (_tmp10_);
		_g_object_unref0 (_tmp7_);
		_g_object_unref0 (file);
	}
	result = TRUE;
	return result;
}

static void
direct_photo_page_real_update_ui (EditingHostPage* base,
                                  gboolean missing)
{
	DirectPhotoPage * self;
	gboolean sensitivity = FALSE;
	AppWindow* _tmp0_;
	AppWindow* _tmp1_;
	GAction* _tmp2_;
	AppWindow* _tmp3_;
	AppWindow* _tmp4_;
	GAction* _tmp5_;
	AppWindow* _tmp6_;
	AppWindow* _tmp7_;
	GAction* _tmp8_;
	self = (DirectPhotoPage*) base;
	sensitivity = !missing;
	page_set_action_sensitive ((Page*) self, "Save", sensitivity);
	page_set_action_sensitive ((Page*) self, "SaveAs", sensitivity);
	page_set_action_sensitive ((Page*) self, "Print", sensitivity);
	_tmp0_ = app_window_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) _tmp1_, APP_WINDOW_ACTION_JUMP_TO_FILE);
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_simple_action_get_type (), GSimpleAction), sensitivity);
	_g_object_unref0 (_tmp1_);
	_tmp3_ = app_window_get_instance ();
	_tmp4_ = _tmp3_;
	_tmp5_ = g_action_map_lookup_action ((GActionMap*) _tmp4_, APP_WINDOW_ACTION_UNDO);
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_simple_action_get_type (), GSimpleAction), sensitivity);
	_g_object_unref0 (_tmp4_);
	_tmp6_ = app_window_get_instance ();
	_tmp7_ = _tmp6_;
	_tmp8_ = g_action_map_lookup_action ((GActionMap*) _tmp7_, APP_WINDOW_ACTION_REDO);
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, g_simple_action_get_type (), GSimpleAction), sensitivity);
	_g_object_unref0 (_tmp7_);
	page_set_action_sensitive ((Page*) self, "IncreaseSize", sensitivity);
	page_set_action_sensitive ((Page*) self, "DecreaseSize", sensitivity);
	page_set_action_sensitive ((Page*) self, "ZoomFit", sensitivity);
	page_set_action_sensitive ((Page*) self, "Zoom100", sensitivity);
	page_set_action_sensitive ((Page*) self, "Zoom200", sensitivity);
	page_set_action_sensitive ((Page*) self, "RotateClockwise", sensitivity);
	page_set_action_sensitive ((Page*) self, "RotateCounterclockwise", sensitivity);
	page_set_action_sensitive ((Page*) self, "FlipHorizontally", sensitivity);
	page_set_action_sensitive ((Page*) self, "FlipVertically", sensitivity);
	page_set_action_sensitive ((Page*) self, "Enhance", sensitivity);
	page_set_action_sensitive ((Page*) self, "Crop", sensitivity);
	page_set_action_sensitive ((Page*) self, "Straighten", sensitivity);
	page_set_action_sensitive ((Page*) self, "RedEye", sensitivity);
	page_set_action_sensitive ((Page*) self, "Adjust", sensitivity);
	page_set_action_sensitive ((Page*) self, "Revert", sensitivity);
	page_set_action_sensitive ((Page*) self, "AdjustDateTime", sensitivity);
	page_set_action_sensitive ((Page*) self, "Fullscreen", sensitivity);
	EDITING_HOST_PAGE_CLASS (direct_photo_page_parent_class)->update_ui (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_EDITING_HOST_PAGE, EditingHostPage), missing);
}

static void
direct_photo_page_real_update_actions (Page* base,
                                       gint selected_count,
                                       gint count)
{
	DirectPhotoPage * self;
	gboolean multiple = FALSE;
	ViewCollection* _tmp0_;
	ViewCollection* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean revert_possible = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean rotate_possible = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean enhance_possible = FALSE;
	Photo* _tmp20_;
	Photo* _tmp21_;
	gboolean _tmp22_;
	GtkButton* _tmp25_;
	self = (DirectPhotoPage*) base;
	_tmp0_ = page_get_view ((Page*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = data_collection_get_count ((DataCollection*) _tmp1_) > 1;
	_data_collection_unref0 (_tmp1_);
	multiple = _tmp2_;
	if (editing_host_page_has_photo ((EditingHostPage*) self)) {
		gboolean _tmp4_ = FALSE;
		Photo* _tmp5_;
		Photo* _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = editing_host_page_get_photo ((EditingHostPage*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = photo_has_transformations (_tmp6_);
		_g_object_unref0 (_tmp6_);
		if (_tmp7_) {
			_tmp4_ = !editing_host_page_get_photo_missing ((EditingHostPage*) self);
		} else {
			_tmp4_ = FALSE;
		}
		_tmp3_ = _tmp4_;
	} else {
		_tmp3_ = FALSE;
	}
	revert_possible = _tmp3_;
	if (editing_host_page_has_photo ((EditingHostPage*) self)) {
		Photo* _tmp9_;
		Photo* _tmp10_;
		_tmp9_ = editing_host_page_get_photo ((EditingHostPage*) self);
		_tmp10_ = _tmp9_;
		_tmp8_ = editing_host_page_is_rotate_available ((EditingHostPage*) self, _tmp10_);
		_g_object_unref0 (_tmp10_);
	} else {
		_tmp8_ = FALSE;
	}
	rotate_possible = _tmp8_;
	if (editing_host_page_has_photo ((EditingHostPage*) self)) {
		Photo* _tmp12_;
		Photo* _tmp13_;
		_tmp12_ = editing_host_page_get_photo ((EditingHostPage*) self);
		_tmp13_ = _tmp12_;
		_tmp11_ = editing_host_page_is_enhance_available ((EditingHostPage*) self, _tmp13_);
		_g_object_unref0 (_tmp13_);
	} else {
		_tmp11_ = FALSE;
	}
	enhance_possible = _tmp11_;
	page_set_action_sensitive ((Page*) self, "PrevPhoto", multiple);
	page_set_action_sensitive ((Page*) self, "NextPhoto", multiple);
	page_set_action_sensitive ((Page*) self, "RotateClockwise", rotate_possible);
	page_set_action_sensitive ((Page*) self, "RotateCounterclockwise", rotate_possible);
	page_set_action_sensitive ((Page*) self, "FlipHorizontally", rotate_possible);
	page_set_action_sensitive ((Page*) self, "FlipVertically", rotate_possible);
	page_set_action_sensitive ((Page*) self, "Revert", revert_possible);
	page_set_action_sensitive ((Page*) self, "Enhance", enhance_possible);
	page_set_action_sensitive ((Page*) self, "SetBackground", editing_host_page_has_photo ((EditingHostPage*) self));
	if (editing_host_page_has_photo ((EditingHostPage*) self)) {
		Photo* _tmp14_;
		Photo* _tmp15_;
		Scaling _tmp16_ = {0};
		Photo* _tmp17_;
		Photo* _tmp18_;
		Scaling _tmp19_ = {0};
		_tmp14_ = editing_host_page_get_photo ((EditingHostPage*) self);
		_tmp15_ = _tmp14_;
		scaling_for_original (&_tmp16_);
		page_set_action_sensitive ((Page*) self, "Crop", editing_tools_crop_tool_is_available (_tmp15_, &_tmp16_));
		_g_object_unref0 (_tmp15_);
		_tmp17_ = editing_host_page_get_photo ((EditingHostPage*) self);
		_tmp18_ = _tmp17_;
		scaling_for_original (&_tmp19_);
		page_set_action_sensitive ((Page*) self, "RedEye", editing_tools_redeye_tool_is_available (_tmp18_, &_tmp19_));
		_g_object_unref0 (_tmp18_);
	}
	_tmp20_ = editing_host_page_get_photo ((EditingHostPage*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = _tmp21_ != NULL;
	_g_object_unref0 (_tmp21_);
	if (_tmp22_) {
		Photo* _tmp23_;
		Photo* _tmp24_;
		_tmp23_ = editing_host_page_get_photo ((EditingHostPage*) self);
		_tmp24_ = _tmp23_;
		page_set_action_sensitive ((Page*) self, "AdjustDateTime", photo_get_file_format (_tmp24_) != PHOTO_FILE_FORMAT_RAW);
		_g_object_unref0 (_tmp24_);
	} else {
		page_set_action_sensitive ((Page*) self, "AdjustDateTime", FALSE);
	}
	PAGE_CLASS (direct_photo_page_parent_class)->update_actions ((Page*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_EDITING_HOST_PAGE, EditingHostPage), selected_count, count);
	_tmp25_ = ((EditingHostPage*) self)->rotate_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp25_, rotate_possible);
}

static gboolean
direct_photo_page_check_ok_to_close_photo (DirectPhotoPage* self,
                                           Photo* photo)
{
	gboolean _tmp0_ = FALSE;
	Photo* _tmp1_;
	Photo* _tmp2_;
	gboolean _tmp3_;
	gboolean is_writeable = FALSE;
	const gchar* _tmp6_ = NULL;
	gchar* save_option = NULL;
	gchar* _tmp7_;
	GraniteMessageDialog* dialog = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GraniteMessageDialog* _tmp12_;
	GraniteMessageDialog* _tmp13_;
	GraniteMessageDialog* _tmp14_;
	AppWindow* _tmp15_;
	AppWindow* _tmp16_;
	GtkButton* no_save_button = NULL;
	GraniteMessageDialog* _tmp17_;
	GtkWidget* _tmp18_;
	GtkButton* _tmp19_;
	GtkButton* _tmp20_;
	GtkStyleContext* _tmp21_;
	GraniteMessageDialog* _tmp22_;
	const gchar* _tmp23_;
	gint response = 0;
	GraniteMessageDialog* _tmp24_;
	GraniteMessageDialog* _tmp25_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (photo != NULL, FALSE);
	if (!photo_has_alterations (photo)) {
		result = TRUE;
		return result;
	}
	if (self->priv->drop_if_dirty) {
		photo_remove_all_transformations (photo);
		result = TRUE;
		return result;
	}
	_tmp1_ = editing_host_page_get_photo ((EditingHostPage*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = photo_can_write_file (_tmp2_);
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		Photo* _tmp4_;
		Photo* _tmp5_;
		_tmp4_ = editing_host_page_get_photo ((EditingHostPage*) self);
		_tmp5_ = _tmp4_;
		_tmp0_ = photo_file_format_can_write (photo_get_file_format (_tmp5_));
		_g_object_unref0 (_tmp5_);
	} else {
		_tmp0_ = FALSE;
	}
	is_writeable = _tmp0_;
	if (is_writeable) {
		_tmp6_ = _ ("_Save");
	} else {
		_tmp6_ = _ ("_Save a Copy");
	}
	_tmp7_ = g_strdup (_tmp6_);
	save_option = _tmp7_;
	_tmp8_ = media_source_get_basename ((MediaSource*) photo);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup_printf (_ ("Lose changes to %s?"), _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = granite_message_dialog_new_with_image_from_icon_name (_tmp11_, "", "dialog-question", GTK_BUTTONS_NONE);
	g_object_ref_sink (_tmp12_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	dialog = _tmp13_;
	_tmp14_ = dialog;
	_tmp15_ = app_window_get_instance ();
	_tmp16_ = _tmp15_;
	gtk_window_set_transient_for ((GtkWindow*) _tmp14_, (GtkWindow*) _tmp16_);
	_g_object_unref0 (_tmp16_);
	_tmp17_ = dialog;
	_tmp18_ = gtk_dialog_add_button ((GtkDialog*) _tmp17_, _ ("Close _without Saving"), (gint) GTK_RESPONSE_YES);
	_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_button_get_type (), GtkButton));
	no_save_button = _tmp19_;
	_tmp20_ = no_save_button;
	_tmp21_ = gtk_widget_get_style_context ((GtkWidget*) _tmp20_);
	gtk_style_context_add_class (_tmp21_, GTK_STYLE_CLASS_DESTRUCTIVE_ACTION);
	_tmp22_ = dialog;
	_tmp23_ = save_option;
	gtk_dialog_add_buttons ((GtkDialog*) _tmp22_, _ ("_Cancel"), GTK_RESPONSE_CANCEL, _tmp23_, GTK_RESPONSE_NO, NULL);
	_tmp24_ = dialog;
	response = gtk_dialog_run ((GtkDialog*) _tmp24_);
	_tmp25_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp25_);
	if (response == ((gint) GTK_RESPONSE_YES)) {
		photo_remove_all_transformations (photo);
	} else {
		if (response == ((gint) GTK_RESPONSE_NO)) {
			if (is_writeable) {
				GFile* _tmp26_;
				GFile* _tmp27_;
				Photo* _tmp28_;
				Photo* _tmp29_;
				gboolean _tmp30_;
				_tmp26_ = media_source_get_file ((MediaSource*) photo);
				_tmp27_ = _tmp26_;
				_tmp28_ = editing_host_page_get_photo ((EditingHostPage*) self);
				_tmp29_ = _tmp28_;
				_tmp30_ = direct_photo_page_save (self, _tmp27_, 0, SCALE_CONSTRAINT_ORIGINAL, JPEG_QUALITY_HIGH, photo_get_file_format (_tmp29_), FALSE, TRUE);
				_g_object_unref0 (_tmp29_);
				_g_object_unref0 (_tmp27_);
				result = _tmp30_;
				_g_object_unref0 (no_save_button);
				_g_object_unref0 (dialog);
				_g_free0 (save_option);
				return result;
			} else {
				result = direct_photo_page_do_save_as (self);
				_g_object_unref0 (no_save_button);
				_g_object_unref0 (dialog);
				_g_free0 (save_option);
				return result;
			}
		} else {
			gboolean _tmp31_ = FALSE;
			gboolean _tmp32_ = FALSE;
			if (response == ((gint) GTK_RESPONSE_CANCEL)) {
				_tmp32_ = TRUE;
			} else {
				_tmp32_ = response == ((gint) GTK_RESPONSE_DELETE_EVENT);
			}
			if (_tmp32_) {
				_tmp31_ = TRUE;
			} else {
				_tmp31_ = response == ((gint) GTK_RESPONSE_CLOSE);
			}
			if (_tmp31_) {
				result = FALSE;
				_g_object_unref0 (no_save_button);
				_g_object_unref0 (dialog);
				_g_free0 (save_option);
				return result;
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (no_save_button);
	_g_object_unref0 (dialog);
	_g_free0 (save_option);
	return result;
}

gboolean
direct_photo_page_check_quit (DirectPhotoPage* self)
{
	Photo* _tmp0_;
	Photo* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = editing_host_page_get_photo ((EditingHostPage*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = direct_photo_page_check_ok_to_close_photo (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static gboolean
direct_photo_page_real_confirm_replace_photo (EditingHostPage* base,
                                              Photo* old_photo,
                                              Photo* new_photo)
{
	DirectPhotoPage * self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = (DirectPhotoPage*) base;
	g_return_val_if_fail (new_photo != NULL, FALSE);
	if (old_photo != NULL) {
		_tmp0_ = direct_photo_page_check_ok_to_close_photo (self, old_photo);
	} else {
		_tmp0_ = TRUE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
direct_photo_page_save (DirectPhotoPage* self,
                        GFile* dest,
                        gint scale,
                        ScaleConstraint constraint,
                        JpegQuality quality,
                        PhotoFileFormat format,
                        gboolean copy_unmodified,
                        gboolean save_metadata)
{
	Scaling scaling = {0};
	Scaling _tmp0_ = {0};
	DirectPhoto* photo = NULL;
	DirectPhotoSourceCollection* _tmp11_;
	DirectPhoto* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* _tmp14_;
	DirectView* tmp_view = NULL;
	DirectPhoto* _tmp15_;
	DirectView* _tmp16_;
	DirectViewCollection* _tmp17_;
	DirectView* _tmp18_;
	DirectPhotoSourceCollection* _tmp19_;
	DirectPhoto* _tmp20_;
	DirectViewCollection* _tmp21_;
	DirectPhoto* _tmp22_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dest != NULL, FALSE);
	scaling_for_constraint (constraint, scale, FALSE, &_tmp0_);
	scaling = _tmp0_;
	{
		Photo* _tmp1_;
		Photo* _tmp2_;
		Scaling _tmp3_;
		_tmp1_ = editing_host_page_get_photo ((EditingHostPage*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = scaling;
		photo_export (_tmp2_, dest, &_tmp3_, quality, format, copy_unmodified, save_metadata, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = g_file_get_path (dest);
		_tmp5_ = _tmp4_;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		_tmp8_ = g_strdup_printf (_ ("Error while saving to %s: %s"), _tmp5_, _tmp7_);
		_tmp9_ = _tmp8_;
		app_window_error_message (_tmp9_, NULL, NULL);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp5_);
		result = FALSE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp10_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
	_tmp11_ = direct_photo_global;
	_tmp13_ = direct_photo_source_collection_fetch (_tmp11_, dest, &_tmp12_, TRUE);
	_g_object_unref0 (photo);
	photo = _tmp12_;
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp14_);
	_tmp15_ = photo;
	_tmp16_ = direct_view_new (_tmp15_);
	tmp_view = _tmp16_;
	_tmp17_ = self->priv->view_controller;
	_tmp18_ = tmp_view;
	data_collection_add ((DataCollection*) _tmp17_, (DataObject*) _tmp18_);
	_tmp19_ = direct_photo_global;
	_tmp20_ = photo;
	direct_photo_source_collection_reimport_photo (_tmp19_, _tmp20_);
	_tmp21_ = self->priv->view_controller;
	_tmp22_ = photo;
	editing_host_page_display_mirror_of ((EditingHostPage*) self, (ViewCollection*) _tmp21_, (Photo*) _tmp22_);
	result = TRUE;
	_g_object_unref0 (tmp_view);
	_g_object_unref0 (photo);
	return result;
}

static void
direct_photo_page_on_save (DirectPhotoPage* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Photo* _tmp2_;
	Photo* _tmp3_;
	gboolean _tmp4_;
	Photo* _tmp7_;
	Photo* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	Photo* _tmp11_;
	Photo* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp2_ = editing_host_page_get_photo ((EditingHostPage*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = !photo_has_alterations (_tmp3_);
	_g_object_unref0 (_tmp3_);
	if (_tmp4_) {
		_tmp1_ = TRUE;
	} else {
		Photo* _tmp5_;
		Photo* _tmp6_;
		_tmp5_ = editing_host_page_get_photo ((EditingHostPage*) self);
		_tmp6_ = _tmp5_;
		_tmp1_ = !photo_file_format_can_write (photo_get_file_format (_tmp6_));
		_g_object_unref0 (_tmp6_);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = editing_host_page_get_photo_missing ((EditingHostPage*) self);
	}
	if (_tmp0_) {
		return;
	}
	_tmp7_ = editing_host_page_get_photo ((EditingHostPage*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = media_source_get_file ((MediaSource*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = editing_host_page_get_photo ((EditingHostPage*) self);
	_tmp12_ = _tmp11_;
	direct_photo_page_save (self, _tmp10_, 0, SCALE_CONSTRAINT_ORIGINAL, JPEG_QUALITY_HIGH, photo_get_file_format (_tmp12_), FALSE, TRUE);
	_g_object_unref0 (_tmp12_);
	_g_object_unref0 (_tmp10_);
	_g_object_unref0 (_tmp8_);
}

static gboolean
direct_photo_page_do_save_as (DirectPhotoPage* self)
{
	ExportDialog* export_dialog = NULL;
	ExportDialog* _tmp0_;
	gint scale = 0;
	ScaleConstraint constraint = 0;
	ExportFormatParameters export_params = {0};
	ExportFormatParameters _tmp1_ = {0};
	ExportDialog* _tmp2_;
	gint _tmp3_ = 0;
	ScaleConstraint _tmp4_ = 0;
	gboolean _tmp5_;
	gchar* filename = NULL;
	Photo* _tmp6_;
	Photo* _tmp7_;
	ExportFormatParameters _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	PhotoFileFormat effective_export_format = 0;
	Photo* _tmp11_;
	Photo* _tmp12_;
	ExportFormatParameters _tmp13_;
	PhotoFileFormat _tmp14_;
	gchar** output_format_extensions = NULL;
	PhotoFileFormatProperties* _tmp15_;
	PhotoFileFormatProperties* _tmp16_;
	gint _tmp17_ = 0;
	gchar** _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	gint output_format_extensions_length1;
	gint _output_format_extensions_size_;
	GtkFileFilter* output_format_filter = NULL;
	GtkFileFilter* _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	GtkFileChooserNative* save_as_dialog = NULL;
	AppWindow* _tmp33_;
	AppWindow* _tmp34_;
	GtkFileChooserNative* _tmp35_;
	GtkFileChooserNative* _tmp36_;
	GtkFileChooserNative* _tmp37_;
	GtkFileChooserNative* _tmp38_;
	const gchar* _tmp39_;
	GtkFileChooserNative* _tmp40_;
	GFile* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	GtkFileChooserNative* _tmp44_;
	GtkFileFilter* _tmp45_;
	GtkFileFilter* _tmp46_;
	GtkFileChooserNative* _tmp47_;
	GtkFileChooserNative* _tmp48_;
	gint response = 0;
	GtkFileChooserNative* _tmp49_;
	gboolean save_successful = FALSE;
	GtkFileChooserNative* _tmp62_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = export_dialog_new (_ ("Save As"));
	g_object_ref_sink (_tmp0_);
	export_dialog = _tmp0_;
	export_format_parameters_last (&_tmp1_);
	export_params = _tmp1_;
	_tmp2_ = export_dialog;
	_tmp5_ = export_dialog_execute (_tmp2_, &_tmp3_, &_tmp4_, &export_params);
	scale = _tmp3_;
	constraint = _tmp4_;
	if (!_tmp5_) {
		result = FALSE;
		_g_object_unref0 (export_dialog);
		return result;
	}
	_tmp6_ = editing_host_page_get_photo ((EditingHostPage*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = export_params;
	_tmp9_ = photo_get_export_basename_for_parameters (_tmp7_, &_tmp8_);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp7_);
	filename = _tmp10_;
	_tmp11_ = editing_host_page_get_photo ((EditingHostPage*) self);
	_tmp12_ = _tmp11_;
	_tmp13_ = export_params;
	_tmp14_ = photo_get_export_format_for_parameters (_tmp12_, &_tmp13_);
	_g_object_unref0 (_tmp12_);
	effective_export_format = _tmp14_;
	_tmp15_ = photo_file_format_get_properties (effective_export_format);
	_tmp16_ = _tmp15_;
	_tmp18_ = photo_file_format_properties_get_known_extensions (_tmp16_, &_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp19__length1 = _tmp17_;
	_photo_file_format_properties_unref0 (_tmp16_);
	output_format_extensions = _tmp19_;
	output_format_extensions_length1 = _tmp19__length1;
	_output_format_extensions_size_ = output_format_extensions_length1;
	_tmp20_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp20_);
	output_format_filter = _tmp20_;
	_tmp21_ = output_format_extensions;
	_tmp21__length1 = output_format_extensions_length1;
	{
		gchar** extension_collection = NULL;
		gint extension_collection_length1 = 0;
		gint _extension_collection_size_ = 0;
		gint extension_it = 0;
		extension_collection = _tmp21_;
		extension_collection_length1 = _tmp21__length1;
		for (extension_it = 0; extension_it < extension_collection_length1; extension_it = extension_it + 1) {
			gchar* _tmp22_;
			gchar* extension = NULL;
			_tmp22_ = g_strdup (extension_collection[extension_it]);
			extension = _tmp22_;
			{
				gchar* uppercase_extension = NULL;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				GtkFileFilter* _tmp25_;
				const gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				GtkFileFilter* _tmp29_;
				const gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				_tmp23_ = extension;
				_tmp24_ = g_utf8_strup (_tmp23_, (gssize) -1);
				uppercase_extension = _tmp24_;
				_tmp25_ = output_format_filter;
				_tmp26_ = extension;
				_tmp27_ = g_strconcat ("*.", _tmp26_, NULL);
				_tmp28_ = _tmp27_;
				gtk_file_filter_add_pattern (_tmp25_, _tmp28_);
				_g_free0 (_tmp28_);
				_tmp29_ = output_format_filter;
				_tmp30_ = uppercase_extension;
				_tmp31_ = g_strconcat ("*.", _tmp30_, NULL);
				_tmp32_ = _tmp31_;
				gtk_file_filter_add_pattern (_tmp29_, _tmp32_);
				_g_free0 (_tmp32_);
				_g_free0 (uppercase_extension);
				_g_free0 (extension);
			}
		}
	}
	_tmp33_ = app_window_get_instance ();
	_tmp34_ = _tmp33_;
	_tmp35_ = gtk_file_chooser_native_new (_ ("Save As"), (GtkWindow*) _tmp34_, GTK_FILE_CHOOSER_ACTION_SAVE, _ ("Save"), _ ("Cancel"));
	_tmp36_ = _tmp35_;
	_g_object_unref0 (_tmp34_);
	save_as_dialog = _tmp36_;
	_tmp37_ = save_as_dialog;
	gtk_file_chooser_set_select_multiple ((GtkFileChooser*) _tmp37_, FALSE);
	_tmp38_ = save_as_dialog;
	_tmp39_ = filename;
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp38_, _tmp39_);
	_tmp40_ = save_as_dialog;
	_tmp41_ = self->priv->current_save_dir;
	_tmp42_ = g_file_get_path (_tmp41_);
	_tmp43_ = _tmp42_;
	gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp40_, _tmp43_);
	_g_free0 (_tmp43_);
	_tmp44_ = save_as_dialog;
	_tmp45_ = output_format_filter;
	_tmp46_ = _g_object_ref0 (_tmp45_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp44_, _tmp46_);
	_tmp47_ = save_as_dialog;
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp47_, TRUE);
	_tmp48_ = save_as_dialog;
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp48_, FALSE);
	_tmp49_ = save_as_dialog;
	response = gtk_native_dialog_run ((GtkNativeDialog*) _tmp49_);
	save_successful = FALSE;
	if (response == ((gint) GTK_RESPONSE_ACCEPT)) {
		GtkFileChooserNative* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		GFile* _tmp53_;
		GFile* _tmp54_;
		ExportFormatParameters _tmp55_;
		ExportFormatParameters _tmp56_;
		ExportFormatParameters _tmp57_;
		GtkFileChooserNative* _tmp58_;
		gchar* _tmp59_;
		gchar* _tmp60_;
		GFile* _tmp61_;
		self->priv->drop_if_dirty = TRUE;
		_tmp50_ = save_as_dialog;
		_tmp51_ = gtk_file_chooser_get_uri ((GtkFileChooser*) _tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = g_file_new_for_uri (_tmp52_);
		_tmp54_ = _tmp53_;
		_tmp55_ = export_params;
		_tmp56_ = export_params;
		_tmp57_ = export_params;
		save_successful = direct_photo_page_save (self, _tmp54_, scale, constraint, _tmp55_.quality, effective_export_format, _tmp56_.mode == EXPORT_FORMAT_MODE_UNMODIFIED, _tmp57_.export_metadata);
		_g_object_unref0 (_tmp54_);
		_g_free0 (_tmp52_);
		self->priv->drop_if_dirty = FALSE;
		_tmp58_ = save_as_dialog;
		_tmp59_ = gtk_file_chooser_get_current_folder ((GtkFileChooser*) _tmp58_);
		_tmp60_ = _tmp59_;
		_tmp61_ = g_file_new_for_path (_tmp60_);
		_g_object_unref0 (self->priv->current_save_dir);
		self->priv->current_save_dir = _tmp61_;
		_g_free0 (_tmp60_);
	}
	_tmp62_ = save_as_dialog;
	gtk_native_dialog_destroy ((GtkNativeDialog*) _tmp62_);
	result = save_successful;
	_g_object_unref0 (save_as_dialog);
	_g_object_unref0 (output_format_filter);
	output_format_extensions = (_vala_array_free (output_format_extensions, output_format_extensions_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (filename);
	_g_object_unref0 (export_dialog);
	return result;
}

static void
direct_photo_page_on_save_as (DirectPhotoPage* self)
{
	g_return_if_fail (self != NULL);
	direct_photo_page_do_save_as (self);
}

static gboolean
direct_photo_page_real_on_app_key_pressed (Page* base,
                                           GdkEventKey* event)
{
	DirectPhotoPage * self;
	guint keycode = 0U;
	gboolean result;
	self = (DirectPhotoPage*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	keycode = (guint) event->hardware_keycode;
	if (page_match_keycode ((Page*) self, GDK_KEY_s, keycode)) {
		if ((event->state & GDK_CONTROL_MASK) != 0) {
			if ((event->state & GDK_SHIFT_MASK) != 0) {
				direct_photo_page_on_save_as (self);
			} else {
				direct_photo_page_on_save (self);
			}
			result = TRUE;
			return result;
		}
	}
	if (page_match_keycode ((Page*) self, GDK_KEY_c, keycode)) {
		if ((event->state & GDK_CONTROL_MASK) != 0) {
			if ((event->state & GDK_SHIFT_MASK) != 0) {
				page_activate_action ((Page*) self, "CopyMetadata");
			} else {
				page_activate_action ((Page*) self, "CopyImage");
			}
			result = TRUE;
			return result;
		}
	}
	if (page_match_keycode ((Page*) self, GDK_KEY_bracketright, keycode)) {
		page_activate_action ((Page*) self, "RotateClockwise");
		result = TRUE;
		return result;
	}
	if (page_match_keycode ((Page*) self, GDK_KEY_bracketleft, keycode)) {
		page_activate_action ((Page*) self, "RotateCounterclockwise");
		result = TRUE;
		return result;
	}
	result = PAGE_CLASS (direct_photo_page_parent_class)->on_app_key_pressed ((Page*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_EDITING_HOST_PAGE, EditingHostPage), event);
	return result;
}

static void
direct_photo_page_on_print (DirectPhotoPage* self)
{
	ViewCollection* _tmp0_;
	ViewCollection* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = page_get_view ((Page*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = view_collection_get_selected_count (_tmp1_) > 0;
	_data_collection_unref0 (_tmp1_);
	if (_tmp2_) {
		PrintManager* _tmp3_;
		PrintManager* _tmp4_;
		ViewCollection* _tmp5_;
		ViewCollection* _tmp6_;
		GeeList* _tmp7_;
		GeeCollection* _tmp8_;
		_tmp3_ = print_manager_get_instance ();
		_tmp4_ = _tmp3_;
		_tmp5_ = page_get_view ((Page*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = view_collection_get_selected_sources_of_type (_tmp6_, TYPE_PHOTO);
		_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection);
		print_manager_spool_photo (_tmp4_, _tmp8_);
		_g_object_unref0 (_tmp8_);
		_data_collection_unref0 (_tmp6_);
		_print_manager_unref0 (_tmp4_);
	}
}

static DataView*
direct_photo_page_real_create_photo_view (EditingHostPage* base,
                                          DataSource* source)
{
	DirectPhotoPage * self;
	DirectView* _tmp0_;
	DataView* result;
	self = (DirectPhotoPage*) base;
	g_return_val_if_fail (source != NULL, NULL);
	_tmp0_ = direct_view_new (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DIRECT_PHOTO, DirectPhoto));
	result = (DataView*) _tmp0_;
	return result;
}

static void
direct_photo_page_class_init (DirectPhotoPageClass * klass,
                              gpointer klass_data)
{
	direct_photo_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DirectPhotoPage_private_offset);
	((PageClass *) klass)->init_collect_action_entries = (GtkActionEntry* (*) (Page*, gint*)) direct_photo_page_real_init_collect_action_entries;
	((GtkWidgetClass *) klass)->realize = (void (*) (GtkWidget*)) direct_photo_page_real_realize;
	((EditingHostPageClass *) klass)->photo_changing = (void (*) (EditingHostPage*, Photo*)) direct_photo_page_real_photo_changing;
	((PageClass *) klass)->on_context_buttonpress = (gboolean (*) (Page*, GdkEventButton*)) direct_photo_page_real_on_context_buttonpress;
	((EditingHostPageClass *) klass)->on_increase_size = (void (*) (EditingHostPage*)) direct_photo_page_real_on_increase_size;
	((EditingHostPageClass *) klass)->on_decrease_size = (void (*) (EditingHostPage*)) direct_photo_page_real_on_decrease_size;
	((EditingHostPageClass *) klass)->on_double_click = (gboolean (*) (EditingHostPage*, GdkEventButton*)) direct_photo_page_real_on_double_click;
	((EditingHostPageClass *) klass)->update_ui = (void (*) (EditingHostPage*, gboolean)) direct_photo_page_real_update_ui;
	((PageClass *) klass)->update_actions = (void (*) (Page*, gint, gint)) direct_photo_page_real_update_actions;
	((EditingHostPageClass *) klass)->confirm_replace_photo = (gboolean (*) (EditingHostPage*, Photo*, Photo*)) direct_photo_page_real_confirm_replace_photo;
	((PageClass *) klass)->on_app_key_pressed = (gboolean (*) (Page*, GdkEventKey*)) direct_photo_page_real_on_app_key_pressed;
	((EditingHostPageClass *) klass)->create_photo_view = (DataView* (*) (EditingHostPage*, DataSource*)) direct_photo_page_real_create_photo_view;
	G_OBJECT_CLASS (klass)->finalize = direct_photo_page_finalize;
}

static void
direct_photo_page_instance_init (DirectPhotoPage * self,
                                 gpointer klass)
{
	self->priv = direct_photo_page_get_instance_private (self);
	self->priv->view_controller = NULL;
	self->priv->drop_if_dirty = FALSE;
}

static void
direct_photo_page_finalize (GObject * obj)
{
	DirectPhotoPage * self;
	DirectPhotoSourceCollection* _tmp0_;
	guint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DIRECT_PHOTO_PAGE, DirectPhotoPage);
	_tmp0_ = direct_photo_global;
	g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((DataCollection*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _direct_photo_page_on_photos_altered_data_collection_items_altered, self);
	_g_object_unref0 (self->priv->initial_file);
	_data_collection_unref0 (self->priv->view_controller);
	_g_object_unref0 (self->priv->current_save_dir);
	_g_object_unref0 (self->priv->contractor_menu);
	_g_object_unref0 (self->priv->context_menu);
	G_OBJECT_CLASS (direct_photo_page_parent_class)->finalize (obj);
}

static GType
direct_photo_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DirectPhotoPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) direct_photo_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DirectPhotoPage), 0, (GInstanceInitFunc) direct_photo_page_instance_init, NULL };
	GType direct_photo_page_type_id;
	direct_photo_page_type_id = g_type_register_static (TYPE_EDITING_HOST_PAGE, "DirectPhotoPage", &g_define_type_info, 0);
	DirectPhotoPage_private_offset = g_type_add_instance_private (direct_photo_page_type_id, sizeof (DirectPhotoPagePrivate));
	return direct_photo_page_type_id;
}

GType
direct_photo_page_get_type (void)
{
	static volatile gsize direct_photo_page_type_id__once = 0;
	if (g_once_init_enter (&direct_photo_page_type_id__once)) {
		GType direct_photo_page_type_id;
		direct_photo_page_type_id = direct_photo_page_get_type_once ();
		g_once_init_leave (&direct_photo_page_type_id__once, direct_photo_page_type_id);
	}
	return direct_photo_page_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

