/* util.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from util.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/
/* SingletonCollection is a read-only collection designed to hold exactly one item in it.  This*/
/* is far more efficient than creating a dummy collection (such as ArrayList) merely to pass around*/
/* a single item, particularly for signals which require Iterables and Collections.*/
/**/
/* This collection cannot be used to store null.*/

#include "io.elementary.photos.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <gobject/gvaluecollector.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SINGLETON_COLLECTION_0_PROPERTY,
	SINGLETON_COLLECTION_G_TYPE,
	SINGLETON_COLLECTION_G_DUP_FUNC,
	SINGLETON_COLLECTION_G_DESTROY_FUNC,
	SINGLETON_COLLECTION_READ_ONLY_PROPERTY,
	SINGLETON_COLLECTION_SIZE_PROPERTY,
	SINGLETON_COLLECTION_NUM_PROPERTIES
};
static GParamSpec* singleton_collection_properties[SINGLETON_COLLECTION_NUM_PROPERTIES];

#define SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR (singleton_collection_singleton_iterator_get_type ())
#define SINGLETON_COLLECTION_SINGLETON_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIterator))
#define SINGLETON_COLLECTION_SINGLETON_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIteratorClass))
#define SINGLETON_COLLECTION_IS_SINGLETON_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR))
#define SINGLETON_COLLECTION_IS_SINGLETON_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR))
#define SINGLETON_COLLECTION_SINGLETON_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIteratorClass))

typedef struct _SingletonCollectionSingletonIterator SingletonCollectionSingletonIterator;
typedef struct _SingletonCollectionSingletonIteratorClass SingletonCollectionSingletonIteratorClass;
typedef struct _SingletonCollectionSingletonIteratorPrivate SingletonCollectionSingletonIteratorPrivate;
enum  {
	SINGLETON_COLLECTION_SINGLETON_ITERATOR_0_PROPERTY,
	SINGLETON_COLLECTION_SINGLETON_ITERATOR_G_TYPE,
	SINGLETON_COLLECTION_SINGLETON_ITERATOR_G_DUP_FUNC,
	SINGLETON_COLLECTION_SINGLETON_ITERATOR_G_DESTROY_FUNC,
	SINGLETON_COLLECTION_SINGLETON_ITERATOR_READ_ONLY_PROPERTY,
	SINGLETON_COLLECTION_SINGLETON_ITERATOR_VALID_PROPERTY,
	SINGLETON_COLLECTION_SINGLETON_ITERATOR_NUM_PROPERTIES
};
static GParamSpec* singleton_collection_singleton_iterator_properties[SINGLETON_COLLECTION_SINGLETON_ITERATOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecUnknownTotalMonitor ParamSpecUnknownTotalMonitor;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecAggregateProgressMonitor ParamSpecAggregateProgressMonitor;

struct _SingletonCollectionPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	gpointer object;
};

struct _SingletonCollectionSingletonIterator {
	GObject parent_instance;
	SingletonCollectionSingletonIteratorPrivate * priv;
};

struct _SingletonCollectionSingletonIteratorClass {
	GObjectClass parent_class;
};

struct _SingletonCollectionSingletonIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	SingletonCollection* c;
	gboolean done;
	gpointer current;
};

struct _UnknownTotalMonitorPrivate {
	guint64 total;
	ProgressMonitor wrapped_monitor;
	gpointer wrapped_monitor_target;
};

struct _ParamSpecUnknownTotalMonitor {
	GParamSpec parent_instance;
};

struct _AggregateProgressMonitorPrivate {
	guint64 grand_total;
	ProgressMonitor wrapped_monitor;
	gpointer wrapped_monitor_target;
	guint64 aggregate_count;
	guint64 last_count;
};

struct _ParamSpecAggregateProgressMonitor {
	GParamSpec parent_instance;
};

static gint SingletonCollection_private_offset;
static gpointer singleton_collection_parent_class = NULL;
static gint SingletonCollectionSingletonIterator_private_offset;
static gpointer singleton_collection_singleton_iterator_parent_class = NULL;
static GeeTraversableIface * singleton_collection_singleton_iterator_gee_traversable_parent_iface = NULL;
static GeeIteratorIface * singleton_collection_singleton_iterator_gee_iterator_parent_iface = NULL;
static gint UnknownTotalMonitor_private_offset;
static gpointer unknown_total_monitor_parent_class = NULL;
static gint AggregateProgressMonitor_private_offset;
static gpointer aggregate_progress_monitor_parent_class = NULL;

static gboolean singleton_collection_real_add (GeeAbstractCollection* base,
                                        gconstpointer object);
static void singleton_collection_real_clear (GeeAbstractCollection* base);
static gboolean singleton_collection_real_contains (GeeAbstractCollection* base,
                                             gconstpointer object);
static GeeIterator* singleton_collection_real_iterator (GeeAbstractCollection* base);
static SingletonCollectionSingletonIterator* singleton_collection_singleton_iterator_new (GType g_type,
                                                                                   GBoxedCopyFunc g_dup_func,
                                                                                   GDestroyNotify g_destroy_func,
                                                                                   SingletonCollection* c);
static SingletonCollectionSingletonIterator* singleton_collection_singleton_iterator_construct (GType object_type,
                                                                                         GType g_type,
                                                                                         GBoxedCopyFunc g_dup_func,
                                                                                         GDestroyNotify g_destroy_func,
                                                                                         SingletonCollection* c);
static GType singleton_collection_singleton_iterator_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gboolean singleton_collection_real_remove (GeeAbstractCollection* base,
                                           gconstpointer item);
static gboolean singleton_collection_singleton_iterator_real_foreach (GeeTraversable* base,
                                                               GeeForallFunc f,
                                                               gpointer f_target);
static gpointer singleton_collection_singleton_iterator_real_get (GeeIterator* base);
static gboolean singleton_collection_singleton_iterator_real_has_next (GeeIterator* base);
static gboolean singleton_collection_singleton_iterator_real_next (GeeIterator* base);
static void singleton_collection_singleton_iterator_real_remove (GeeIterator* base);
static void singleton_collection_singleton_iterator_finalize (GObject * obj);
static GType singleton_collection_singleton_iterator_get_type_once (void);
static void _vala_singleton_collection_singleton_iterator_get_property (GObject * object,
                                                                 guint property_id,
                                                                 GValue * value,
                                                                 GParamSpec * pspec);
static void _vala_singleton_collection_singleton_iterator_set_property (GObject * object,
                                                                 guint property_id,
                                                                 const GValue * value,
                                                                 GParamSpec * pspec);
static void singleton_collection_finalize (GObject * obj);
static GType singleton_collection_get_type_once (void);
static void _vala_singleton_collection_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_singleton_collection_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static GType marker_get_type_once (void);
static void unknown_total_monitor_finalize (UnknownTotalMonitor * obj);
static GType unknown_total_monitor_get_type_once (void);
static void aggregate_progress_monitor_finalize (AggregateProgressMonitor * obj);
static GType aggregate_progress_monitor_get_type_once (void);
VALA_EXTERN gdouble degrees_to_radians (gdouble theta);

static inline gpointer
singleton_collection_get_instance_private (SingletonCollection* self)
{
	return G_STRUCT_MEMBER_P (self, SingletonCollection_private_offset);
}

SingletonCollection*
singleton_collection_construct (GType object_type,
                                GType g_type,
                                GBoxedCopyFunc g_dup_func,
                                GDestroyNotify g_destroy_func,
                                gconstpointer object)
{
	SingletonCollection * self = NULL;
	gpointer _tmp0_;
	self = (SingletonCollection*) gee_abstract_collection_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = ((object != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) object) : ((gpointer) object);
	((self->priv->object == NULL) || (g_destroy_func == NULL)) ? NULL : (self->priv->object = (g_destroy_func (self->priv->object), NULL));
	self->priv->object = _tmp0_;
	return self;
}

SingletonCollection*
singleton_collection_new (GType g_type,
                          GBoxedCopyFunc g_dup_func,
                          GDestroyNotify g_destroy_func,
                          gconstpointer object)
{
	return singleton_collection_construct (TYPE_SINGLETON_COLLECTION, g_type, g_dup_func, g_destroy_func, object);
}

static gboolean
singleton_collection_real_add (GeeAbstractCollection* base,
                               gconstpointer object)
{
	SingletonCollection * self;
	gboolean result;
	self = (SingletonCollection*) base;
	g_warning ("util.vala:93: Cannot add to SingletonCollection");
	result = FALSE;
	return result;
}

static void
singleton_collection_real_clear (GeeAbstractCollection* base)
{
	SingletonCollection * self;
	self = (SingletonCollection*) base;
	((self->priv->object == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->object = (self->priv->g_destroy_func (self->priv->object), NULL));
	self->priv->object = NULL;
}

static gboolean
singleton_collection_real_contains (GeeAbstractCollection* base,
                                    gconstpointer object)
{
	SingletonCollection * self;
	gconstpointer _tmp0_;
	gboolean result;
	self = (SingletonCollection*) base;
	_tmp0_ = self->priv->object;
	result = _tmp0_ == object;
	return result;
}

static GeeIterator*
singleton_collection_real_iterator (GeeAbstractCollection* base)
{
	SingletonCollection * self;
	SingletonCollectionSingletonIterator* _tmp0_;
	GeeIterator* result;
	self = (SingletonCollection*) base;
	_tmp0_ = singleton_collection_singleton_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, self);
	result = (GeeIterator*) _tmp0_;
	return result;
}

static gboolean
singleton_collection_real_remove (GeeAbstractCollection* base,
                                  gconstpointer item)
{
	SingletonCollection * self;
	gconstpointer _tmp0_;
	gboolean result;
	self = (SingletonCollection*) base;
	_tmp0_ = self->priv->object;
	if (item == _tmp0_) {
		((self->priv->object == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->object = (self->priv->g_destroy_func (self->priv->object), NULL));
		self->priv->object = NULL;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
singleton_collection_real_get_read_only (GeeAbstractCollection* base)
{
	gboolean result;
	SingletonCollection* self;
	self = (SingletonCollection*) base;
	result = FALSE;
	return result;
}

static gint
singleton_collection_real_get_size (GeeAbstractCollection* base)
{
	gint result;
	SingletonCollection* self;
	gint _tmp0_ = 0;
	gconstpointer _tmp1_;
	self = (SingletonCollection*) base;
	_tmp1_ = self->priv->object;
	if (_tmp1_ != NULL) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	result = _tmp0_;
	return result;
}

static inline gpointer
singleton_collection_singleton_iterator_get_instance_private (SingletonCollectionSingletonIterator* self)
{
	return G_STRUCT_MEMBER_P (self, SingletonCollectionSingletonIterator_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static SingletonCollectionSingletonIterator*
singleton_collection_singleton_iterator_construct (GType object_type,
                                                   GType g_type,
                                                   GBoxedCopyFunc g_dup_func,
                                                   GDestroyNotify g_destroy_func,
                                                   SingletonCollection* c)
{
	SingletonCollectionSingletonIterator * self = NULL;
	SingletonCollection* _tmp0_;
	g_return_val_if_fail (c != NULL, NULL);
	self = (SingletonCollectionSingletonIterator*) g_object_new (object_type, "g-type", g_type, "g-dup-func", g_dup_func, "g-destroy-func", g_destroy_func, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = _g_object_ref0 (c);
	_g_object_unref0 (self->priv->c);
	self->priv->c = _tmp0_;
	return self;
}

static SingletonCollectionSingletonIterator*
singleton_collection_singleton_iterator_new (GType g_type,
                                             GBoxedCopyFunc g_dup_func,
                                             GDestroyNotify g_destroy_func,
                                             SingletonCollection* c)
{
	return singleton_collection_singleton_iterator_construct (SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, g_type, g_dup_func, g_destroy_func, c);
}

static gboolean
singleton_collection_singleton_iterator_real_foreach (GeeTraversable* base,
                                                      GeeForallFunc f,
                                                      gpointer f_target)
{
	SingletonCollectionSingletonIterator * self;
	SingletonCollection* _tmp0_;
	gconstpointer _tmp1_;
	gpointer _tmp2_;
	gboolean result;
	self = (SingletonCollectionSingletonIterator*) base;
	_tmp0_ = self->priv->c;
	_tmp1_ = _tmp0_->priv->object;
	_tmp2_ = ((_tmp1_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp1_) : ((gpointer) _tmp1_);
	result = f (_tmp2_, f_target);
	return result;
}

static gpointer
singleton_collection_singleton_iterator_real_get (GeeIterator* base)
{
	SingletonCollectionSingletonIterator * self;
	gconstpointer _tmp0_;
	gpointer _tmp1_;
	gpointer result;
	self = (SingletonCollectionSingletonIterator*) base;
	_tmp0_ = self->priv->current;
	_tmp1_ = ((_tmp0_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp0_) : ((gpointer) _tmp0_);
	result = _tmp1_;
	return result;
}

static gboolean
singleton_collection_singleton_iterator_real_has_next (GeeIterator* base)
{
	SingletonCollectionSingletonIterator * self;
	gboolean result;
	self = (SingletonCollectionSingletonIterator*) base;
	result = FALSE;
	return result;
}

static gboolean
singleton_collection_singleton_iterator_real_next (GeeIterator* base)
{
	SingletonCollectionSingletonIterator * self;
	SingletonCollection* _tmp0_;
	gconstpointer _tmp1_;
	gpointer _tmp2_;
	gboolean result;
	self = (SingletonCollectionSingletonIterator*) base;
	if (self->priv->done) {
		result = FALSE;
		return result;
	}
	self->priv->done = TRUE;
	_tmp0_ = self->priv->c;
	_tmp1_ = _tmp0_->priv->object;
	_tmp2_ = ((_tmp1_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp1_) : ((gpointer) _tmp1_);
	((self->priv->current == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->current = (self->priv->g_destroy_func (self->priv->current), NULL));
	self->priv->current = _tmp2_;
	result = TRUE;
	return result;
}

static void
singleton_collection_singleton_iterator_real_remove (GeeIterator* base)
{
	SingletonCollectionSingletonIterator * self;
	self = (SingletonCollectionSingletonIterator*) base;
	if (!self->priv->done) {
		SingletonCollection* _tmp0_;
		_tmp0_ = self->priv->c;
		((_tmp0_->priv->object == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp0_->priv->object = (self->priv->g_destroy_func (_tmp0_->priv->object), NULL));
		_tmp0_->priv->object = NULL;
		((self->priv->current == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->current = (self->priv->g_destroy_func (self->priv->current), NULL));
		self->priv->current = NULL;
	}
	self->priv->done = TRUE;
}

static gboolean
singleton_collection_singleton_iterator_real_get_read_only (GeeIterator* base)
{
	gboolean result;
	SingletonCollectionSingletonIterator* self;
	self = (SingletonCollectionSingletonIterator*) base;
	result = self->priv->done;
	return result;
}

static gboolean
singleton_collection_singleton_iterator_real_get_valid (GeeIterator* base)
{
	gboolean result;
	SingletonCollectionSingletonIterator* self;
	self = (SingletonCollectionSingletonIterator*) base;
	result = self->priv->done;
	return result;
}

static void
singleton_collection_singleton_iterator_class_init (SingletonCollectionSingletonIteratorClass * klass,
                                                    gpointer klass_data)
{
	singleton_collection_singleton_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SingletonCollectionSingletonIterator_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_singleton_collection_singleton_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_singleton_collection_singleton_iterator_set_property;
	G_OBJECT_CLASS (klass)->finalize = singleton_collection_singleton_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SINGLETON_COLLECTION_SINGLETON_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SINGLETON_COLLECTION_SINGLETON_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SINGLETON_COLLECTION_SINGLETON_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SINGLETON_COLLECTION_SINGLETON_ITERATOR_READ_ONLY_PROPERTY, singleton_collection_singleton_iterator_properties[SINGLETON_COLLECTION_SINGLETON_ITERATOR_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SINGLETON_COLLECTION_SINGLETON_ITERATOR_VALID_PROPERTY, singleton_collection_singleton_iterator_properties[SINGLETON_COLLECTION_SINGLETON_ITERATOR_VALID_PROPERTY] = g_param_spec_boolean ("valid", "valid", "valid", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static GType
singleton_collection_singleton_iterator_gee_traversable_get_g_type (SingletonCollectionSingletonIterator* self)
{
	return (GType) self->priv->g_type;
}

static GBoxedCopyFunc
singleton_collection_singleton_iterator_gee_traversable_get_g_dup_func (SingletonCollectionSingletonIterator* self)
{
	return (GBoxedCopyFunc) self->priv->g_dup_func;
}

static GDestroyNotify
singleton_collection_singleton_iterator_gee_traversable_get_g_destroy_func (SingletonCollectionSingletonIterator* self)
{
	return (GDestroyNotify) self->priv->g_destroy_func;
}

static void
singleton_collection_singleton_iterator_gee_traversable_interface_init (GeeTraversableIface * iface,
                                                                        gpointer iface_data)
{
	singleton_collection_singleton_iterator_gee_traversable_parent_iface = g_type_interface_peek_parent (iface);
	iface->foreach = (gboolean (*) (GeeTraversable*, GeeForallFunc, gpointer)) singleton_collection_singleton_iterator_real_foreach;
	iface->get_g_type = (GType (*) (GeeTraversable *)) singleton_collection_singleton_iterator_gee_traversable_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeTraversable *)) singleton_collection_singleton_iterator_gee_traversable_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeTraversable *)) singleton_collection_singleton_iterator_gee_traversable_get_g_destroy_func;
}

static void
singleton_collection_singleton_iterator_gee_iterator_interface_init (GeeIteratorIface * iface,
                                                                     gpointer iface_data)
{
	singleton_collection_singleton_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->get = (gpointer (*) (GeeIterator*)) singleton_collection_singleton_iterator_real_get;
	iface->has_next = (gboolean (*) (GeeIterator*)) singleton_collection_singleton_iterator_real_has_next;
	iface->next = (gboolean (*) (GeeIterator*)) singleton_collection_singleton_iterator_real_next;
	iface->remove = (void (*) (GeeIterator*)) singleton_collection_singleton_iterator_real_remove;
	iface->get_read_only = singleton_collection_singleton_iterator_real_get_read_only;
	iface->get_valid = singleton_collection_singleton_iterator_real_get_valid;
}

static void
singleton_collection_singleton_iterator_instance_init (SingletonCollectionSingletonIterator * self,
                                                       gpointer klass)
{
	self->priv = singleton_collection_singleton_iterator_get_instance_private (self);
	self->priv->done = FALSE;
	self->priv->current = NULL;
}

static void
singleton_collection_singleton_iterator_finalize (GObject * obj)
{
	SingletonCollectionSingletonIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIterator);
	_g_object_unref0 (self->priv->c);
	((self->priv->current == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->current = (self->priv->g_destroy_func (self->priv->current), NULL));
	G_OBJECT_CLASS (singleton_collection_singleton_iterator_parent_class)->finalize (obj);
}

static GType
singleton_collection_singleton_iterator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SingletonCollectionSingletonIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) singleton_collection_singleton_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SingletonCollectionSingletonIterator), 0, (GInstanceInitFunc) singleton_collection_singleton_iterator_instance_init, NULL };
	static const GInterfaceInfo gee_traversable_info = { (GInterfaceInitFunc) singleton_collection_singleton_iterator_gee_traversable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) singleton_collection_singleton_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType singleton_collection_singleton_iterator_type_id;
	singleton_collection_singleton_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "SingletonCollectionSingletonIterator", &g_define_type_info, 0);
	g_type_add_interface_static (singleton_collection_singleton_iterator_type_id, GEE_TYPE_TRAVERSABLE, &gee_traversable_info);
	g_type_add_interface_static (singleton_collection_singleton_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
	SingletonCollectionSingletonIterator_private_offset = g_type_add_instance_private (singleton_collection_singleton_iterator_type_id, sizeof (SingletonCollectionSingletonIteratorPrivate));
	return singleton_collection_singleton_iterator_type_id;
}

static GType
singleton_collection_singleton_iterator_get_type (void)
{
	static volatile gsize singleton_collection_singleton_iterator_type_id__once = 0;
	if (g_once_init_enter (&singleton_collection_singleton_iterator_type_id__once)) {
		GType singleton_collection_singleton_iterator_type_id;
		singleton_collection_singleton_iterator_type_id = singleton_collection_singleton_iterator_get_type_once ();
		g_once_init_leave (&singleton_collection_singleton_iterator_type_id__once, singleton_collection_singleton_iterator_type_id);
	}
	return singleton_collection_singleton_iterator_type_id__once;
}

static void
_vala_singleton_collection_singleton_iterator_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec)
{
	SingletonCollectionSingletonIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIterator);
	switch (property_id) {
		case SINGLETON_COLLECTION_SINGLETON_ITERATOR_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, gee_iterator_get_read_only ((GeeIterator*) self));
		break;
		case SINGLETON_COLLECTION_SINGLETON_ITERATOR_VALID_PROPERTY:
		g_value_set_boolean (value, gee_iterator_get_valid ((GeeIterator*) self));
		break;
		case SINGLETON_COLLECTION_SINGLETON_ITERATOR_G_TYPE:
		g_value_set_gtype (value, self->priv->g_type);
		break;
		case SINGLETON_COLLECTION_SINGLETON_ITERATOR_G_DUP_FUNC:
		g_value_set_pointer (value, self->priv->g_dup_func);
		break;
		case SINGLETON_COLLECTION_SINGLETON_ITERATOR_G_DESTROY_FUNC:
		g_value_set_pointer (value, self->priv->g_destroy_func);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_singleton_collection_singleton_iterator_set_property (GObject * object,
                                                            guint property_id,
                                                            const GValue * value,
                                                            GParamSpec * pspec)
{
	SingletonCollectionSingletonIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIterator);
	switch (property_id) {
		case SINGLETON_COLLECTION_SINGLETON_ITERATOR_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case SINGLETON_COLLECTION_SINGLETON_ITERATOR_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case SINGLETON_COLLECTION_SINGLETON_ITERATOR_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
singleton_collection_class_init (SingletonCollectionClass * klass,
                                 gpointer klass_data)
{
	singleton_collection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SingletonCollection_private_offset);
	((GeeAbstractCollectionClass *) klass)->add = (gboolean (*) (GeeAbstractCollection*, gconstpointer)) singleton_collection_real_add;
	((GeeAbstractCollectionClass *) klass)->clear = (void (*) (GeeAbstractCollection*)) singleton_collection_real_clear;
	((GeeAbstractCollectionClass *) klass)->contains = (gboolean (*) (GeeAbstractCollection*, gconstpointer)) singleton_collection_real_contains;
	((GeeAbstractCollectionClass *) klass)->iterator = (GeeIterator* (*) (GeeAbstractCollection*)) singleton_collection_real_iterator;
	((GeeAbstractCollectionClass *) klass)->remove = (gboolean (*) (GeeAbstractCollection*, gconstpointer)) singleton_collection_real_remove;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_read_only = (gboolean (*) (GeeAbstractCollection*)) singleton_collection_real_get_read_only;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = (gint (*) (GeeAbstractCollection*)) singleton_collection_real_get_size;
	G_OBJECT_CLASS (klass)->get_property = _vala_singleton_collection_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_singleton_collection_set_property;
	G_OBJECT_CLASS (klass)->finalize = singleton_collection_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SINGLETON_COLLECTION_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SINGLETON_COLLECTION_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SINGLETON_COLLECTION_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SINGLETON_COLLECTION_READ_ONLY_PROPERTY, singleton_collection_properties[SINGLETON_COLLECTION_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SINGLETON_COLLECTION_SIZE_PROPERTY, singleton_collection_properties[SINGLETON_COLLECTION_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
singleton_collection_instance_init (SingletonCollection * self,
                                    gpointer klass)
{
	self->priv = singleton_collection_get_instance_private (self);
}

static void
singleton_collection_finalize (GObject * obj)
{
	SingletonCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SINGLETON_COLLECTION, SingletonCollection);
	((self->priv->object == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->object = (self->priv->g_destroy_func (self->priv->object), NULL));
	G_OBJECT_CLASS (singleton_collection_parent_class)->finalize (obj);
}

static GType
singleton_collection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SingletonCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) singleton_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SingletonCollection), 0, (GInstanceInitFunc) singleton_collection_instance_init, NULL };
	GType singleton_collection_type_id;
	singleton_collection_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_COLLECTION, "SingletonCollection", &g_define_type_info, 0);
	SingletonCollection_private_offset = g_type_add_instance_private (singleton_collection_type_id, sizeof (SingletonCollectionPrivate));
	return singleton_collection_type_id;
}

GType
singleton_collection_get_type (void)
{
	static volatile gsize singleton_collection_type_id__once = 0;
	if (g_once_init_enter (&singleton_collection_type_id__once)) {
		GType singleton_collection_type_id;
		singleton_collection_type_id = singleton_collection_get_type_once ();
		g_once_init_leave (&singleton_collection_type_id__once, singleton_collection_type_id);
	}
	return singleton_collection_type_id__once;
}

static void
_vala_singleton_collection_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	SingletonCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SINGLETON_COLLECTION, SingletonCollection);
	switch (property_id) {
		case SINGLETON_COLLECTION_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, gee_abstract_collection_get_read_only ((GeeAbstractCollection*) self));
		break;
		case SINGLETON_COLLECTION_SIZE_PROPERTY:
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
		break;
		case SINGLETON_COLLECTION_G_TYPE:
		g_value_set_gtype (value, self->priv->g_type);
		break;
		case SINGLETON_COLLECTION_G_DUP_FUNC:
		g_value_set_pointer (value, self->priv->g_dup_func);
		break;
		case SINGLETON_COLLECTION_G_DESTROY_FUNC:
		g_value_set_pointer (value, self->priv->g_destroy_func);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_singleton_collection_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	SingletonCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SINGLETON_COLLECTION, SingletonCollection);
	switch (property_id) {
		case SINGLETON_COLLECTION_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case SINGLETON_COLLECTION_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case SINGLETON_COLLECTION_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

void
marker_mark (Marker* self,
             DataObject* object)
{
	MarkerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = MARKER_GET_INTERFACE (self);
	if (_iface_->mark) {
		_iface_->mark (self, object);
	}
}

void
marker_unmark (Marker* self,
               DataObject* object)
{
	MarkerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = MARKER_GET_INTERFACE (self);
	if (_iface_->unmark) {
		_iface_->unmark (self, object);
	}
}

gboolean
marker_toggle (Marker* self,
               DataObject* object)
{
	MarkerIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = MARKER_GET_INTERFACE (self);
	if (_iface_->toggle) {
		return _iface_->toggle (self, object);
	}
	return FALSE;
}

void
marker_mark_many (Marker* self,
                  GeeCollection* list)
{
	MarkerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = MARKER_GET_INTERFACE (self);
	if (_iface_->mark_many) {
		_iface_->mark_many (self, list);
	}
}

void
marker_unmark_many (Marker* self,
                    GeeCollection* list)
{
	MarkerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = MARKER_GET_INTERFACE (self);
	if (_iface_->unmark_many) {
		_iface_->unmark_many (self, list);
	}
}

void
marker_mark_all (Marker* self)
{
	MarkerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = MARKER_GET_INTERFACE (self);
	if (_iface_->mark_all) {
		_iface_->mark_all (self);
	}
}

gint
marker_get_count (Marker* self)
{
	MarkerIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = MARKER_GET_INTERFACE (self);
	if (_iface_->get_count) {
		return _iface_->get_count (self);
	}
	return -1;
}

GeeCollection*
marker_get_all (Marker* self)
{
	MarkerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = MARKER_GET_INTERFACE (self);
	if (_iface_->get_all) {
		return _iface_->get_all (self);
	}
	return NULL;
}

static void
marker_default_init (MarkerIface * iface,
                     gpointer iface_data)
{
}

static GType
marker_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MarkerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) marker_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType marker_type_id;
	marker_type_id = g_type_register_static (G_TYPE_INTERFACE, "Marker", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (marker_type_id, G_TYPE_OBJECT);
	return marker_type_id;
}

GType
marker_get_type (void)
{
	static volatile gsize marker_type_id__once = 0;
	if (g_once_init_enter (&marker_type_id__once)) {
		GType marker_type_id;
		marker_type_id = marker_get_type_once ();
		g_once_init_leave (&marker_type_id__once, marker_type_id);
	}
	return marker_type_id__once;
}

static inline gpointer
unknown_total_monitor_get_instance_private (UnknownTotalMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, UnknownTotalMonitor_private_offset);
}

UnknownTotalMonitor*
unknown_total_monitor_construct (GType object_type,
                                 guint64 total,
                                 ProgressMonitor wrapped_monitor,
                                 gpointer wrapped_monitor_target)
{
	UnknownTotalMonitor* self = NULL;
	self = (UnknownTotalMonitor*) g_type_create_instance (object_type);
	self->priv->total = total;
	self->priv->wrapped_monitor = wrapped_monitor;
	self->priv->wrapped_monitor_target = wrapped_monitor_target;
	return self;
}

UnknownTotalMonitor*
unknown_total_monitor_new (guint64 total,
                           ProgressMonitor wrapped_monitor,
                           gpointer wrapped_monitor_target)
{
	return unknown_total_monitor_construct (TYPE_UNKNOWN_TOTAL_MONITOR, total, wrapped_monitor, wrapped_monitor_target);
}

gboolean
unknown_total_monitor_monitor (UnknownTotalMonitor* self,
                               guint64 count,
                               guint64 total)
{
	ProgressMonitor _tmp0_;
	gpointer _tmp0__target;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->wrapped_monitor;
	_tmp0__target = self->priv->wrapped_monitor_target;
	result = _tmp0_ (count, self->priv->total, TRUE, _tmp0__target);
	return result;
}

static void
value_unknown_total_monitor_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_unknown_total_monitor_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		unknown_total_monitor_unref (value->data[0].v_pointer);
	}
}

static void
value_unknown_total_monitor_copy_value (const GValue* src_value,
                                        GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = unknown_total_monitor_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_unknown_total_monitor_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_unknown_total_monitor_collect_value (GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		UnknownTotalMonitor * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = unknown_total_monitor_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_unknown_total_monitor_lcopy_value (const GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	UnknownTotalMonitor ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = unknown_total_monitor_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_unknown_total_monitor (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags)
{
	ParamSpecUnknownTotalMonitor* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_UNKNOWN_TOTAL_MONITOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_unknown_total_monitor (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UNKNOWN_TOTAL_MONITOR), NULL);
	return value->data[0].v_pointer;
}

void
value_set_unknown_total_monitor (GValue* value,
                                 gpointer v_object)
{
	UnknownTotalMonitor * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UNKNOWN_TOTAL_MONITOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_UNKNOWN_TOTAL_MONITOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		unknown_total_monitor_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unknown_total_monitor_unref (old);
	}
}

void
value_take_unknown_total_monitor (GValue* value,
                                  gpointer v_object)
{
	UnknownTotalMonitor * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UNKNOWN_TOTAL_MONITOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_UNKNOWN_TOTAL_MONITOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unknown_total_monitor_unref (old);
	}
}

static void
unknown_total_monitor_class_init (UnknownTotalMonitorClass * klass,
                                  gpointer klass_data)
{
	unknown_total_monitor_parent_class = g_type_class_peek_parent (klass);
	((UnknownTotalMonitorClass *) klass)->finalize = unknown_total_monitor_finalize;
	g_type_class_adjust_private_offset (klass, &UnknownTotalMonitor_private_offset);
}

static void
unknown_total_monitor_instance_init (UnknownTotalMonitor * self,
                                     gpointer klass)
{
	self->priv = unknown_total_monitor_get_instance_private (self);
	self->ref_count = 1;
}

static void
unknown_total_monitor_finalize (UnknownTotalMonitor * obj)
{
	UnknownTotalMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UNKNOWN_TOTAL_MONITOR, UnknownTotalMonitor);
	g_signal_handlers_destroy (self);
}

static GType
unknown_total_monitor_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_unknown_total_monitor_init, value_unknown_total_monitor_free_value, value_unknown_total_monitor_copy_value, value_unknown_total_monitor_peek_pointer, "p", value_unknown_total_monitor_collect_value, "p", value_unknown_total_monitor_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (UnknownTotalMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unknown_total_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnknownTotalMonitor), 0, (GInstanceInitFunc) unknown_total_monitor_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType unknown_total_monitor_type_id;
	unknown_total_monitor_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UnknownTotalMonitor", &g_define_type_info, &g_define_type_fundamental_info, 0);
	UnknownTotalMonitor_private_offset = g_type_add_instance_private (unknown_total_monitor_type_id, sizeof (UnknownTotalMonitorPrivate));
	return unknown_total_monitor_type_id;
}

GType
unknown_total_monitor_get_type (void)
{
	static volatile gsize unknown_total_monitor_type_id__once = 0;
	if (g_once_init_enter (&unknown_total_monitor_type_id__once)) {
		GType unknown_total_monitor_type_id;
		unknown_total_monitor_type_id = unknown_total_monitor_get_type_once ();
		g_once_init_leave (&unknown_total_monitor_type_id__once, unknown_total_monitor_type_id);
	}
	return unknown_total_monitor_type_id__once;
}

gpointer
unknown_total_monitor_ref (gpointer instance)
{
	UnknownTotalMonitor * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
unknown_total_monitor_unref (gpointer instance)
{
	UnknownTotalMonitor * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UNKNOWN_TOTAL_MONITOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
aggregate_progress_monitor_get_instance_private (AggregateProgressMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, AggregateProgressMonitor_private_offset);
}

AggregateProgressMonitor*
aggregate_progress_monitor_construct (GType object_type,
                                      guint64 grand_total,
                                      ProgressMonitor wrapped_monitor,
                                      gpointer wrapped_monitor_target)
{
	AggregateProgressMonitor* self = NULL;
	self = (AggregateProgressMonitor*) g_type_create_instance (object_type);
	self->priv->grand_total = grand_total;
	self->priv->wrapped_monitor = wrapped_monitor;
	self->priv->wrapped_monitor_target = wrapped_monitor_target;
	return self;
}

AggregateProgressMonitor*
aggregate_progress_monitor_new (guint64 grand_total,
                                ProgressMonitor wrapped_monitor,
                                gpointer wrapped_monitor_target)
{
	return aggregate_progress_monitor_construct (TYPE_AGGREGATE_PROGRESS_MONITOR, grand_total, wrapped_monitor, wrapped_monitor_target);
}

void
aggregate_progress_monitor_next_step (AggregateProgressMonitor* self,
                                      const gchar* name)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = g_strdup_printf ("%" G_GUINT64_FORMAT, self->priv->aggregate_count);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%" G_GUINT64_FORMAT, self->priv->grand_total);
	_tmp3_ = _tmp2_;
	g_debug ("util.vala:190: next step: %s (%s/%s)", name, _tmp1_, _tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	self->priv->last_count = G_MAXUINT64;
}

gboolean
aggregate_progress_monitor_monitor (AggregateProgressMonitor* self,
                                    guint64 count,
                                    guint64 total)
{
	guint64 _tmp0_ = 0ULL;
	ProgressMonitor _tmp1_;
	gpointer _tmp1__target;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->last_count != G_MAXUINT64) {
		_tmp0_ = count - self->priv->last_count;
	} else {
		_tmp0_ = count;
	}
	self->priv->aggregate_count = self->priv->aggregate_count + _tmp0_;
	if (self->priv->aggregate_count > self->priv->grand_total) {
		self->priv->aggregate_count = self->priv->grand_total;
	}
	self->priv->last_count = count;
	_tmp1_ = self->priv->wrapped_monitor;
	_tmp1__target = self->priv->wrapped_monitor_target;
	result = _tmp1_ (self->priv->aggregate_count, self->priv->grand_total, TRUE, _tmp1__target);
	return result;
}

static void
value_aggregate_progress_monitor_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_aggregate_progress_monitor_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		aggregate_progress_monitor_unref (value->data[0].v_pointer);
	}
}

static void
value_aggregate_progress_monitor_copy_value (const GValue* src_value,
                                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = aggregate_progress_monitor_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_aggregate_progress_monitor_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_aggregate_progress_monitor_collect_value (GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		AggregateProgressMonitor * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = aggregate_progress_monitor_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_aggregate_progress_monitor_lcopy_value (const GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	AggregateProgressMonitor ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = aggregate_progress_monitor_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_aggregate_progress_monitor (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags)
{
	ParamSpecAggregateProgressMonitor* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_AGGREGATE_PROGRESS_MONITOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_aggregate_progress_monitor (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AGGREGATE_PROGRESS_MONITOR), NULL);
	return value->data[0].v_pointer;
}

void
value_set_aggregate_progress_monitor (GValue* value,
                                      gpointer v_object)
{
	AggregateProgressMonitor * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AGGREGATE_PROGRESS_MONITOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AGGREGATE_PROGRESS_MONITOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		aggregate_progress_monitor_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		aggregate_progress_monitor_unref (old);
	}
}

void
value_take_aggregate_progress_monitor (GValue* value,
                                       gpointer v_object)
{
	AggregateProgressMonitor * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AGGREGATE_PROGRESS_MONITOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AGGREGATE_PROGRESS_MONITOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		aggregate_progress_monitor_unref (old);
	}
}

static void
aggregate_progress_monitor_class_init (AggregateProgressMonitorClass * klass,
                                       gpointer klass_data)
{
	aggregate_progress_monitor_parent_class = g_type_class_peek_parent (klass);
	((AggregateProgressMonitorClass *) klass)->finalize = aggregate_progress_monitor_finalize;
	g_type_class_adjust_private_offset (klass, &AggregateProgressMonitor_private_offset);
}

static void
aggregate_progress_monitor_instance_init (AggregateProgressMonitor * self,
                                          gpointer klass)
{
	self->priv = aggregate_progress_monitor_get_instance_private (self);
	self->priv->aggregate_count = (guint64) 0;
	self->priv->last_count = G_MAXUINT64;
	self->ref_count = 1;
}

static void
aggregate_progress_monitor_finalize (AggregateProgressMonitor * obj)
{
	AggregateProgressMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AGGREGATE_PROGRESS_MONITOR, AggregateProgressMonitor);
	g_signal_handlers_destroy (self);
}

static GType
aggregate_progress_monitor_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_aggregate_progress_monitor_init, value_aggregate_progress_monitor_free_value, value_aggregate_progress_monitor_copy_value, value_aggregate_progress_monitor_peek_pointer, "p", value_aggregate_progress_monitor_collect_value, "p", value_aggregate_progress_monitor_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (AggregateProgressMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) aggregate_progress_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AggregateProgressMonitor), 0, (GInstanceInitFunc) aggregate_progress_monitor_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType aggregate_progress_monitor_type_id;
	aggregate_progress_monitor_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AggregateProgressMonitor", &g_define_type_info, &g_define_type_fundamental_info, 0);
	AggregateProgressMonitor_private_offset = g_type_add_instance_private (aggregate_progress_monitor_type_id, sizeof (AggregateProgressMonitorPrivate));
	return aggregate_progress_monitor_type_id;
}

GType
aggregate_progress_monitor_get_type (void)
{
	static volatile gsize aggregate_progress_monitor_type_id__once = 0;
	if (g_once_init_enter (&aggregate_progress_monitor_type_id__once)) {
		GType aggregate_progress_monitor_type_id;
		aggregate_progress_monitor_type_id = aggregate_progress_monitor_get_type_once ();
		g_once_init_leave (&aggregate_progress_monitor_type_id__once, aggregate_progress_monitor_type_id);
	}
	return aggregate_progress_monitor_type_id__once;
}

gpointer
aggregate_progress_monitor_ref (gpointer instance)
{
	AggregateProgressMonitor * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
aggregate_progress_monitor_unref (gpointer instance)
{
	AggregateProgressMonitor * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		AGGREGATE_PROGRESS_MONITOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

gboolean
null_progress_monitor (guint64 count,
                       guint64 total)
{
	gboolean result;
	result = TRUE;
	return result;
}

gdouble
degrees_to_radians (gdouble theta)
{
	gdouble result;
	result = theta * (G_PI / 180.0);
	return result;
}

