/* TodayTaskMonitor.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from TodayTaskMonitor.vala, do not modify */

/*
* Copyright 2021 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include <glib-object.h>
#include <glib.h>
#include <libedataserver/libedataserver.h>
#include <libecal/libecal.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libical-glib/libical-glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TASKS_TYPE_TODAY_TASK_MONITOR (tasks_today_task_monitor_get_type ())
#define TASKS_TODAY_TASK_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_TYPE_TODAY_TASK_MONITOR, TasksTodayTaskMonitor))
#define TASKS_TODAY_TASK_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_TYPE_TODAY_TASK_MONITOR, TasksTodayTaskMonitorClass))
#define TASKS_IS_TODAY_TASK_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_TYPE_TODAY_TASK_MONITOR))
#define TASKS_IS_TODAY_TASK_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_TYPE_TODAY_TASK_MONITOR))
#define TASKS_TODAY_TASK_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_TYPE_TODAY_TASK_MONITOR, TasksTodayTaskMonitorClass))

typedef struct _TasksTodayTaskMonitor TasksTodayTaskMonitor;
typedef struct _TasksTodayTaskMonitorClass TasksTodayTaskMonitorClass;
typedef struct _TasksTodayTaskMonitorPrivate TasksTodayTaskMonitorPrivate;

#define TASKS_TYPE_TASK_MODEL (tasks_task_model_get_type ())
#define TASKS_TASK_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_TYPE_TASK_MODEL, TasksTaskModel))
#define TASKS_TASK_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_TYPE_TASK_MODEL, TasksTaskModelClass))
#define TASKS_IS_TASK_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_TYPE_TASK_MODEL))
#define TASKS_IS_TASK_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_TYPE_TASK_MODEL))
#define TASKS_TASK_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_TYPE_TASK_MODEL, TasksTaskModelClass))

typedef struct _TasksTaskModel TasksTaskModel;
typedef struct _TasksTaskModelClass TasksTaskModelClass;
enum  {
	TASKS_TODAY_TASK_MONITOR_0_PROPERTY,
	TASKS_TODAY_TASK_MONITOR_NUM_PROPERTIES
};
static GParamSpec* tasks_today_task_monitor_properties[TASKS_TODAY_TASK_MONITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _TasksTodayTaskMonitorStartData TasksTodayTaskMonitorStartData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef void (*TasksTaskModelTasksAddedFunc) (GeeCollection* tasks, ESource* task_list, gpointer user_data);
typedef void (*TasksTaskModelTasksModifiedFunc) (GeeCollection* tasks, gpointer user_data);
typedef void (*TasksTaskModelTasksRemovedFunc) (GSList* cids, gpointer user_data);
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block20Data Block20Data;
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define __vala_ECalComponentId_free0(var) ((var == NULL) ? NULL : (var = (_vala_ECalComponentId_free (var), NULL)))

struct _TasksTodayTaskMonitor {
	GObject parent_instance;
	TasksTodayTaskMonitorPrivate * priv;
};

struct _TasksTodayTaskMonitorClass {
	GObjectClass parent_class;
};

struct _TasksTodayTaskMonitorPrivate {
	TasksTaskModel* model;
	GHashTable* task_list_view;
	GRecMutex __lock_task_list_view;
	GHashTable* scheduled_task_notifications;
	GRecMutex __lock_scheduled_task_notifications;
	GHashTable* sent_task_notifications;
	GRecMutex __lock_sent_task_notifications;
};

struct _TasksTodayTaskMonitorStartData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TasksTodayTaskMonitor* self;
	TasksTaskModel* _tmp0_;
	TasksTaskModel* _tmp1_;
	TasksTaskModel* _tmp2_;
	TasksTaskModel* _tmp3_;
	TasksTaskModel* _tmp4_;
};

struct _Block20Data {
	int _ref_count_;
	TasksTodayTaskMonitor* self;
	ECalComponent* task;
};

static gint TasksTodayTaskMonitor_private_offset;
static gpointer tasks_today_task_monitor_parent_class = NULL;

VALA_EXTERN GType tasks_today_task_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksTodayTaskMonitor, g_object_unref)
VALA_EXTERN GType tasks_task_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksTaskModel, g_object_unref)
static void tasks_today_task_monitor_start_data_free (gpointer _data);
VALA_EXTERN void tasks_today_task_monitor_start (TasksTodayTaskMonitor* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
VALA_EXTERN void tasks_today_task_monitor_start_finish (TasksTodayTaskMonitor* self,
                                            GAsyncResult* _res_,
                                            GError** error);
static gboolean tasks_today_task_monitor_start_co (TasksTodayTaskMonitorStartData* _data_);
VALA_EXTERN TasksTaskModel* tasks_task_model_new (void);
VALA_EXTERN TasksTaskModel* tasks_task_model_construct (GType object_type);
static void tasks_today_task_monitor_add_task_list (TasksTodayTaskMonitor* self,
                                             ESource* task_list);
static void _tasks_today_task_monitor_add_task_list_tasks_task_model_task_list_added (TasksTaskModel* _sender,
                                                                               ESource* task_list,
                                                                               gpointer self);
static void tasks_today_task_monitor_modify_task_list (TasksTodayTaskMonitor* self,
                                                ESource* task_list);
static void _tasks_today_task_monitor_modify_task_list_tasks_task_model_task_list_modified (TasksTaskModel* _sender,
                                                                                     ESource* task_list,
                                                                                     gpointer self);
static void tasks_today_task_monitor_remove_task_list (TasksTodayTaskMonitor* self,
                                                ESource* task_list);
static void _tasks_today_task_monitor_remove_task_list_tasks_task_model_task_list_removed (TasksTaskModel* _sender,
                                                                                    ESource* task_list,
                                                                                    gpointer self);
VALA_EXTERN void tasks_task_model_start (TasksTaskModel* self,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_);
VALA_EXTERN void tasks_task_model_start_finish (TasksTaskModel* self,
                                    GAsyncResult* _res_);
static void tasks_today_task_monitor_start_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
VALA_EXTERN gboolean tasks_today_task_monitor_refresh_task_list_queries (TasksTodayTaskMonitor* self);
static gboolean _tasks_today_task_monitor_refresh_task_list_queries_gsource_func (gpointer self);
VALA_EXTERN ECalClientView* tasks_task_model_create_task_list_view (TasksTaskModel* self,
                                                        ESource* task_list,
                                                        const gchar* query,
                                                        TasksTaskModelTasksAddedFunc on_tasks_added,
                                                        gpointer on_tasks_added_target,
                                                        TasksTaskModelTasksModifiedFunc on_tasks_modified,
                                                        gpointer on_tasks_modified_target,
                                                        TasksTaskModelTasksRemovedFunc on_tasks_removed,
                                                        gpointer on_tasks_removed_target,
                                                        GError** error);
static void ___lambda24_ (TasksTodayTaskMonitor* self,
                   GeeCollection* tasks,
                   ESource* task_list);
static void tasks_today_task_monitor_add_tasks (TasksTodayTaskMonitor* self,
                                         GeeCollection* tasks);
static void ____lambda24__tasks_task_model_tasks_added_func (GeeCollection* tasks,
                                                      ESource* task_list,
                                                      gpointer self);
static void tasks_today_task_monitor_modify_tasks (TasksTodayTaskMonitor* self,
                                            GeeCollection* tasks);
static void _tasks_today_task_monitor_modify_tasks_tasks_task_model_tasks_modified_func (GeeCollection* tasks,
                                                                                  gpointer self);
static void tasks_today_task_monitor_remove_tasks (TasksTodayTaskMonitor* self,
                                            GSList* cids);
static void _tasks_today_task_monitor_remove_tasks_tasks_task_model_tasks_removed_func (GSList* cids,
                                                                                 gpointer self);
VALA_EXTERN void tasks_task_model_destroy_task_list_view (TasksTaskModel* self,
                                              ECalClientView* view);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
VALA_EXTERN GDateTime* tasks_util_ical_to_date_time_local (ICalTime* date);
static void _vala_ECalComponentId_free (ECalComponentId* self);
static gchar* tasks_today_task_monitor_format_ecal_component_id (TasksTodayTaskMonitor* self,
                                                          ECalComponentId* cid);
static gboolean ____lambda25_ (Block20Data* _data20_);
static void tasks_today_task_monitor_send_notification (TasksTodayTaskMonitor* self,
                                                 ECalComponentId* cid);
static gboolean _____lambda25__gsource_func (gpointer self);
static void __vala_ECalComponentId_free0_ (gpointer var);
static inline void _g_slist_free___vala_ECalComponentId_free0_ (GSList* self);
static ECalComponentId* _vala_ECalComponentId_copy (ECalComponentId* self);
VALA_EXTERN TasksTodayTaskMonitor* tasks_today_task_monitor_new (void);
VALA_EXTERN TasksTodayTaskMonitor* tasks_today_task_monitor_construct (GType object_type);
static GObject * tasks_today_task_monitor_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static guint _e_source_hash_ghash_func (gconstpointer key);
static gboolean _e_source_equal_gequal_func (gconstpointer a,
                                      gconstpointer b);
static void _g_object_unref0_ (gpointer var);
static guint _e_cal_component_id_hash_ghash_func (gconstpointer key);
static gboolean _e_cal_component_id_equal_gequal_func (gconstpointer a,
                                                gconstpointer b);
static void tasks_today_task_monitor_finalize (GObject * obj);
static GType tasks_today_task_monitor_get_type_once (void);

static inline gpointer
tasks_today_task_monitor_get_instance_private (TasksTodayTaskMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, TasksTodayTaskMonitor_private_offset);
}

static void
tasks_today_task_monitor_start_data_free (gpointer _data)
{
	TasksTodayTaskMonitorStartData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TasksTodayTaskMonitorStartData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
tasks_today_task_monitor_start (TasksTodayTaskMonitor* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	TasksTodayTaskMonitorStartData* _data_;
	TasksTodayTaskMonitor* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (TasksTodayTaskMonitorStartData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tasks_today_task_monitor_start_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	tasks_today_task_monitor_start_co (_data_);
}

void
tasks_today_task_monitor_start_finish (TasksTodayTaskMonitor* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	TasksTodayTaskMonitorStartData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
_tasks_today_task_monitor_add_task_list_tasks_task_model_task_list_added (TasksTaskModel* _sender,
                                                                          ESource* task_list,
                                                                          gpointer self)
{
	tasks_today_task_monitor_add_task_list ((TasksTodayTaskMonitor*) self, task_list);
}

static void
_tasks_today_task_monitor_modify_task_list_tasks_task_model_task_list_modified (TasksTaskModel* _sender,
                                                                                ESource* task_list,
                                                                                gpointer self)
{
	tasks_today_task_monitor_modify_task_list ((TasksTodayTaskMonitor*) self, task_list);
}

static void
_tasks_today_task_monitor_remove_task_list_tasks_task_model_task_list_removed (TasksTaskModel* _sender,
                                                                               ESource* task_list,
                                                                               gpointer self)
{
	tasks_today_task_monitor_remove_task_list ((TasksTodayTaskMonitor*) self, task_list);
}

static void
tasks_today_task_monitor_start_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	TasksTodayTaskMonitorStartData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tasks_today_task_monitor_start_co (_data_);
}

static gboolean
_tasks_today_task_monitor_refresh_task_list_queries_gsource_func (gpointer self)
{
	gboolean result;
	result = tasks_today_task_monitor_refresh_task_list_queries ((TasksTodayTaskMonitor*) self);
	return result;
}

static gboolean
tasks_today_task_monitor_start_co (TasksTodayTaskMonitorStartData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = tasks_task_model_new ();
	_g_object_unref0 (_data_->self->priv->model);
	_data_->self->priv->model = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->priv->model;
	g_signal_connect_object (_data_->_tmp1_, "task-list-added", (GCallback) _tasks_today_task_monitor_add_task_list_tasks_task_model_task_list_added, _data_->self, 0);
	_data_->_tmp2_ = _data_->self->priv->model;
	g_signal_connect_object (_data_->_tmp2_, "task-list-modified", (GCallback) _tasks_today_task_monitor_modify_task_list_tasks_task_model_task_list_modified, _data_->self, 0);
	_data_->_tmp3_ = _data_->self->priv->model;
	g_signal_connect_object (_data_->_tmp3_, "task-list-removed", (GCallback) _tasks_today_task_monitor_remove_task_list_tasks_task_model_task_list_removed, _data_->self, 0);
	_data_->_tmp4_ = _data_->self->priv->model;
	_data_->_state_ = 1;
	tasks_task_model_start (_data_->_tmp4_, tasks_today_task_monitor_start_ready, _data_);
	return FALSE;
	_state_1:
	tasks_task_model_start_finish (_data_->_tmp4_, _data_->_res_);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 36000, _tasks_today_task_monitor_refresh_task_list_queries_gsource_func, g_object_ref (_data_->self), g_object_unref);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gboolean
tasks_today_task_monitor_refresh_task_list_queries (TasksTodayTaskMonitor* self)
{
	GList* task_lists = NULL;
	GHashTable* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->task_list_view;
	_tmp1_ = g_hash_table_get_keys (_tmp0_);
	task_lists = _tmp1_;
	_tmp2_ = task_lists;
	{
		GList* task_list_collection = NULL;
		GList* task_list_it = NULL;
		task_list_collection = _tmp2_;
		for (task_list_it = task_list_collection; task_list_it != NULL; task_list_it = task_list_it->next) {
			ESource* task_list = NULL;
			task_list = (ESource*) task_list_it->data;
			{
				ESource* _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				ESource* _tmp6_;
				_tmp3_ = task_list;
				_tmp4_ = e_source_get_display_name (_tmp3_);
				_tmp5_ = _tmp4_;
				g_debug ("TodayTaskMonitor.vala:50: [%s] Refreshing task list query…", _tmp5_);
				_tmp6_ = task_list;
				tasks_today_task_monitor_modify_task_list (self, _tmp6_);
			}
		}
	}
	result = G_SOURCE_CONTINUE;
	(task_lists == NULL) ? NULL : (task_lists = (g_list_free (task_lists), NULL));
	return result;
}

static void
___lambda24_ (TasksTodayTaskMonitor* self,
              GeeCollection* tasks,
              ESource* task_list)
{
	g_return_if_fail (tasks != NULL);
	g_return_if_fail (task_list != NULL);
	tasks_today_task_monitor_add_tasks (self, tasks);
}

static void
____lambda24__tasks_task_model_tasks_added_func (GeeCollection* tasks,
                                                 ESource* task_list,
                                                 gpointer self)
{
	___lambda24_ ((TasksTodayTaskMonitor*) self, tasks, task_list);
}

static void
_tasks_today_task_monitor_modify_tasks_tasks_task_model_tasks_modified_func (GeeCollection* tasks,
                                                                             gpointer self)
{
	tasks_today_task_monitor_modify_tasks ((TasksTodayTaskMonitor*) self, tasks);
}

static void
_tasks_today_task_monitor_remove_tasks_tasks_task_model_tasks_removed_func (GSList* cids,
                                                                            gpointer self)
{
	tasks_today_task_monitor_remove_tasks ((TasksTodayTaskMonitor*) self, cids);
}

static void
tasks_today_task_monitor_add_task_list (TasksTodayTaskMonitor* self,
                                        ESource* task_list)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GDateTime* now_datetime = NULL;
	GDateTime* _tmp2_;
	GDateTime* range_start = NULL;
	GDateTime* _tmp3_;
	GDateTime* range_end = NULL;
	GDateTime* _tmp4_;
	gchar* iso8601_date_format = NULL;
	gchar* _tmp5_;
	gchar* iso8601_time_format = NULL;
	gchar* _tmp6_;
	gchar* task_list_query = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (task_list != NULL);
	_tmp0_ = e_source_get_display_name (task_list);
	_tmp1_ = _tmp0_;
	g_debug ("TodayTaskMonitor.vala:58: [%s] Adding task list…", _tmp1_);
	_tmp2_ = g_date_time_new_now_local ();
	now_datetime = _tmp2_;
	_tmp3_ = g_date_time_add_hours (now_datetime, -12);
	range_start = _tmp3_;
	_tmp4_ = g_date_time_add_hours (now_datetime, 12);
	range_end = _tmp4_;
	_tmp5_ = g_strdup ("%Y%m%d");
	iso8601_date_format = _tmp5_;
	_tmp6_ = g_strdup ("%H%M%S");
	iso8601_time_format = _tmp6_;
	_tmp7_ = g_date_time_format (range_start, iso8601_date_format);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_date_time_format (range_start, iso8601_time_format);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_date_time_format (range_end, iso8601_date_format);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_date_time_format (range_end, iso8601_time_format);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strdup_printf ("(AND (NOT is-completed?) (due-in-time-range? (make-time \"%sT%sZ\") (m" \
"ake-time \"%sT%sZ\"))))", _tmp8_, _tmp10_, _tmp12_, _tmp14_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	task_list_query = _tmp16_;
	_tmp17_ = e_source_get_display_name (task_list);
	_tmp18_ = _tmp17_;
	g_debug ("TodayTaskMonitor.vala:75: [%s] Creating task list view with query: %s", _tmp18_, task_list_query);
	{
		TasksTaskModel* _tmp19_;
		ECalClientView* _tmp20_;
		ECalClientView* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		_tmp19_ = self->priv->model;
		_tmp20_ = tasks_task_model_create_task_list_view (_tmp19_, task_list, task_list_query, ____lambda24__tasks_task_model_tasks_added_func, self, _tasks_today_task_monitor_modify_tasks_tasks_task_model_tasks_modified_func, self, _tasks_today_task_monitor_remove_tasks_tasks_task_model_tasks_removed_func, self, &_inner_error0_);
		_tmp21_ = _tmp20_;
		_g_object_unref0 (_tmp21_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp22_ = e_source_get_display_name (task_list);
		_tmp23_ = _tmp22_;
		g_debug ("TodayTaskMonitor.vala:85: [%s] Task list view created.", _tmp23_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		GError* _tmp26_;
		const gchar* _tmp27_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp24_ = e_source_get_display_name (task_list);
		_tmp25_ = _tmp24_;
		_tmp26_ = e;
		_tmp27_ = _tmp26_->message;
		g_warning ("TodayTaskMonitor.vala:88: Error creating view for '%s': %s", _tmp25_, _tmp27_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (task_list_query);
		_g_free0 (iso8601_time_format);
		_g_free0 (iso8601_date_format);
		_g_date_time_unref0 (range_end);
		_g_date_time_unref0 (range_start);
		_g_date_time_unref0 (now_datetime);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (task_list_query);
	_g_free0 (iso8601_time_format);
	_g_free0 (iso8601_date_format);
	_g_date_time_unref0 (range_end);
	_g_date_time_unref0 (range_start);
	_g_date_time_unref0 (now_datetime);
}

static void
tasks_today_task_monitor_modify_task_list (TasksTodayTaskMonitor* self,
                                           ESource* task_list)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (task_list != NULL);
	tasks_today_task_monitor_remove_task_list (self, task_list);
	tasks_today_task_monitor_add_task_list (self, task_list);
}

static gpointer
_vala_g_hash_table_take (GHashTable* self,
                         gconstpointer key,
                         gboolean* exists)
{
	gboolean _vala_exists = FALSE;
	GHashTable* ht = NULL;
	void** htp = NULL;
	gconstpointer _tmp0_;
	gpointer result;
	g_return_val_if_fail (self != NULL, NULL);
	ht = NULL;
	htp = &ht;
	_tmp0_ = g_hash_table_lookup (self, key);
	*htp = _tmp0_;
	_vala_exists = g_hash_table_steal (self, key);
	result = ht;
	if (exists) {
		*exists = _vala_exists;
	}
	return result;
}

static void
tasks_today_task_monitor_remove_task_list (TasksTodayTaskMonitor* self,
                                           ESource* task_list)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (task_list != NULL);
	_tmp0_ = e_source_get_display_name (task_list);
	_tmp1_ = _tmp0_;
	g_debug ("TodayTaskMonitor.vala:98: [%s] Removing task list…", _tmp1_);
	{
		GHashTable* _tmp2_;
		_tmp2_ = self->priv->task_list_view;
		g_rec_mutex_lock (&self->priv->__lock_task_list_view);
		{
			gboolean exists = FALSE;
			ECalClientView* view = NULL;
			GHashTable* _tmp3_;
			gboolean _tmp4_ = FALSE;
			gpointer _tmp5_;
			_tmp3_ = self->priv->task_list_view;
			_tmp5_ = _vala_g_hash_table_take (_tmp3_, task_list, &_tmp4_);
			exists = _tmp4_;
			view = (ECalClientView*) _tmp5_;
			if (exists) {
				TasksTaskModel* _tmp6_;
				ECalClientView* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				_tmp6_ = self->priv->model;
				_tmp7_ = view;
				tasks_task_model_destroy_task_list_view (_tmp6_, _tmp7_);
				_tmp8_ = e_source_get_display_name (task_list);
				_tmp9_ = _tmp8_;
				g_debug ("TodayTaskMonitor.vala:106: [%s] Task list view destroyed.", _tmp9_);
			}
			_g_object_unref0 (view);
		}
		__finally0:
		{
			GHashTable* _tmp10_;
			_tmp10_ = self->priv->task_list_view;
			g_rec_mutex_unlock (&self->priv->__lock_task_list_view);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static Block20Data*
block20_data_ref (Block20Data* _data20_)
{
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}

static void
block20_data_unref (void * _userdata_)
{
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		TasksTodayTaskMonitor* self;
		self = _data20_->self;
		_g_object_unref0 (_data20_->task);
		_g_object_unref0 (self);
		g_slice_free (Block20Data, _data20_);
	}
}

static void
_vala_ECalComponentId_free (ECalComponentId* self)
{
	g_boxed_free (e_cal_component_id_get_type (), self);
}

static gboolean
____lambda25_ (Block20Data* _data20_)
{
	TasksTodayTaskMonitor* self;
	ECalComponent* _tmp0_;
	ECalComponentId* _tmp1_;
	ECalComponentId* _tmp2_;
	gboolean result;
	self = _data20_->self;
	_tmp0_ = _data20_->task;
	_tmp1_ = e_cal_component_get_id (_tmp0_);
	_tmp2_ = _tmp1_;
	tasks_today_task_monitor_send_notification (self, _tmp2_);
	__vala_ECalComponentId_free0 (_tmp2_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
_____lambda25__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda25_ (self);
	return result;
}

static void
tasks_today_task_monitor_add_tasks (TasksTodayTaskMonitor* self,
                                    GeeCollection* tasks)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tasks != NULL);
	{
		GeeIterator* _task_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) tasks);
		_task_it = _tmp0_;
		while (TRUE) {
			Block20Data* _data20_;
			GeeIterator* _tmp1_;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			ICalComponent* ical_component = NULL;
			ECalComponent* _tmp4_;
			ICalComponent* _tmp5_;
			ICalTime* due_icaltime = NULL;
			ICalComponent* _tmp6_;
			ICalTime* _tmp7_;
			gboolean _tmp8_ = FALSE;
			ICalTime* _tmp9_;
			GNotification* notification = NULL;
			ICalComponent* _tmp11_;
			const gchar* _tmp12_;
			GNotification* _tmp13_;
			ICalComponent* _tmp14_;
			const gchar* _tmp15_;
			GDateTime* now_datetime = NULL;
			GTimeZone* _tmp19_;
			GTimeZone* _tmp20_;
			GDateTime* _tmp21_;
			GDateTime* _tmp22_;
			GDateTime* due_datetime = NULL;
			ICalTime* _tmp23_;
			GDateTime* _tmp24_;
			GTimeSpan timespan = 0LL;
			GDateTime* _tmp25_;
			GDateTime* _tmp26_;
			guint timeout_in_seconds = 0U;
			gboolean _tmp27_ = FALSE;
			ECalComponent* _tmp41_;
			ECalComponentId* _tmp42_;
			ECalComponentId* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			ICalComponent* _tmp46_;
			const gchar* _tmp47_;
			_data20_ = g_slice_new0 (Block20Data);
			_data20_->_ref_count_ = 1;
			_data20_->self = g_object_ref (self);
			_tmp1_ = _task_it;
			if (!gee_iterator_next (_tmp1_)) {
				block20_data_unref (_data20_);
				_data20_ = NULL;
				break;
			}
			_tmp2_ = _task_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			_data20_->task = (ECalComponent*) _tmp3_;
			_tmp4_ = _data20_->task;
			_tmp5_ = e_cal_component_get_icalcomponent (_tmp4_);
			ical_component = _tmp5_;
			_tmp6_ = ical_component;
			_tmp7_ = i_cal_component_get_due (_tmp6_);
			due_icaltime = _tmp7_;
			_tmp9_ = due_icaltime;
			if (i_cal_time_is_null_time (_tmp9_)) {
				_tmp8_ = TRUE;
			} else {
				ICalTime* _tmp10_;
				_tmp10_ = due_icaltime;
				_tmp8_ = !i_cal_time_is_valid_time (_tmp10_);
			}
			if (_tmp8_) {
				_g_object_unref0 (due_icaltime);
				block20_data_unref (_data20_);
				_data20_ = NULL;
				continue;
			}
			_tmp11_ = ical_component;
			_tmp12_ = i_cal_component_get_summary (_tmp11_);
			_tmp13_ = g_notification_new (_tmp12_);
			notification = _tmp13_;
			_tmp14_ = ical_component;
			_tmp15_ = i_cal_component_get_description (_tmp14_);
			if (_tmp15_ != NULL) {
				GNotification* _tmp16_;
				ICalComponent* _tmp17_;
				const gchar* _tmp18_;
				_tmp16_ = notification;
				_tmp17_ = ical_component;
				_tmp18_ = i_cal_component_get_description (_tmp17_);
				g_notification_set_body (_tmp16_, _tmp18_);
			}
			_tmp19_ = g_time_zone_new_local ();
			_tmp20_ = _tmp19_;
			_tmp21_ = g_date_time_new_now (_tmp20_);
			_tmp22_ = _tmp21_;
			_g_time_zone_unref0 (_tmp20_);
			now_datetime = _tmp22_;
			_tmp23_ = due_icaltime;
			_tmp24_ = tasks_util_ical_to_date_time_local (_tmp23_);
			due_datetime = _tmp24_;
			_tmp25_ = due_datetime;
			_tmp26_ = now_datetime;
			timespan = g_date_time_difference (_tmp25_, _tmp26_) / 1000000;
			if (timespan < ((GTimeSpan) 0)) {
				timespan = (GTimeSpan) 0;
			}
			timeout_in_seconds = (guint) timespan;
			if (timeout_in_seconds == ((guint) 0)) {
				GHashTable* _tmp28_;
				ECalComponent* _tmp29_;
				ECalComponentId* _tmp30_;
				ECalComponentId* _tmp31_;
				_tmp28_ = self->priv->sent_task_notifications;
				_tmp29_ = _data20_->task;
				_tmp30_ = e_cal_component_get_id (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp27_ = g_hash_table_contains (_tmp28_, _tmp31_);
				__vala_ECalComponentId_free0 (_tmp31_);
			} else {
				_tmp27_ = FALSE;
			}
			if (_tmp27_) {
				_g_date_time_unref0 (due_datetime);
				_g_date_time_unref0 (now_datetime);
				_g_object_unref0 (notification);
				_g_object_unref0 (due_icaltime);
				block20_data_unref (_data20_);
				_data20_ = NULL;
				continue;
			}
			{
				GHashTable* _tmp32_;
				_tmp32_ = self->priv->scheduled_task_notifications;
				g_rec_mutex_lock (&self->priv->__lock_scheduled_task_notifications);
				{
					GHashTable* _tmp33_;
					ECalComponent* _tmp34_;
					ECalComponentId* _tmp35_;
					ECalComponentId* _tmp36_;
					ECalComponentId* _tmp37_;
					GNotification* _tmp38_;
					GNotification* _tmp39_;
					_tmp33_ = self->priv->scheduled_task_notifications;
					_tmp34_ = _data20_->task;
					_tmp35_ = e_cal_component_get_id (_tmp34_);
					_tmp36_ = _tmp35_;
					_tmp37_ = e_cal_component_id_copy (_tmp36_);
					_tmp38_ = notification;
					_tmp39_ = _g_object_ref0 (_tmp38_);
					g_hash_table_insert (_tmp33_, _tmp37_, _tmp39_);
					__vala_ECalComponentId_free0 (_tmp36_);
				}
				__finally0:
				{
					GHashTable* _tmp40_;
					_tmp40_ = self->priv->scheduled_task_notifications;
					g_rec_mutex_unlock (&self->priv->__lock_scheduled_task_notifications);
				}
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_date_time_unref0 (due_datetime);
					_g_date_time_unref0 (now_datetime);
					_g_object_unref0 (notification);
					_g_object_unref0 (due_icaltime);
					block20_data_unref (_data20_);
					_data20_ = NULL;
					_g_object_unref0 (_task_it);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_tmp41_ = _data20_->task;
			_tmp42_ = e_cal_component_get_id (_tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = tasks_today_task_monitor_format_ecal_component_id (self, _tmp43_);
			_tmp45_ = _tmp44_;
			_tmp46_ = ical_component;
			_tmp47_ = i_cal_component_get_summary (_tmp46_);
			g_debug ("TodayTaskMonitor.vala:144: [%s] Creating notification for task '%s' to" \
" be sent in %u seconds…", _tmp45_, _tmp47_, timeout_in_seconds);
			_g_free0 (_tmp45_);
			__vala_ECalComponentId_free0 (_tmp43_);
			g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, timeout_in_seconds, _____lambda25__gsource_func, block20_data_ref (_data20_), block20_data_unref);
			_g_date_time_unref0 (due_datetime);
			_g_date_time_unref0 (now_datetime);
			_g_object_unref0 (notification);
			_g_object_unref0 (due_icaltime);
			block20_data_unref (_data20_);
			_data20_ = NULL;
		}
		_g_object_unref0 (_task_it);
	}
}

static void
__vala_ECalComponentId_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_ECalComponentId_free (var), NULL));
}

static inline void
_g_slist_free___vala_ECalComponentId_free0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) __vala_ECalComponentId_free0_);
}

static void
tasks_today_task_monitor_modify_tasks (TasksTodayTaskMonitor* self,
                                       GeeCollection* tasks)
{
	GSList* cids = NULL;
	GSList* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tasks != NULL);
	cids = NULL;
	{
		GeeIterator* _task_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) tasks);
		_task_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			ECalComponent* task = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			ECalComponent* _tmp4_;
			ECalComponentId* _tmp5_;
			_tmp1_ = _task_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _task_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			task = (ECalComponent*) _tmp3_;
			_tmp4_ = task;
			_tmp5_ = e_cal_component_get_id (_tmp4_);
			cids = g_slist_append (cids, _tmp5_);
			_g_object_unref0 (task);
		}
		_g_object_unref0 (_task_it);
	}
	_tmp6_ = cids;
	tasks_today_task_monitor_remove_tasks (self, _tmp6_);
	tasks_today_task_monitor_add_tasks (self, tasks);
	(cids == NULL) ? NULL : (cids = (_g_slist_free___vala_ECalComponentId_free0_ (cids), NULL));
}

static ECalComponentId*
_vala_ECalComponentId_copy (ECalComponentId* self)
{
	return g_boxed_copy (e_cal_component_id_get_type (), self);
}

static gpointer
__vala_ECalComponentId_copy0 (gpointer self)
{
	return self ? _vala_ECalComponentId_copy (self) : NULL;
}

static void
tasks_today_task_monitor_remove_tasks (TasksTodayTaskMonitor* self,
                                       GSList* cids)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GHashTable* _tmp0_;
		_tmp0_ = self->priv->scheduled_task_notifications;
		g_rec_mutex_lock (&self->priv->__lock_scheduled_task_notifications);
		{
			{
				GSList* cid_collection = NULL;
				GSList* cid_it = NULL;
				cid_collection = cids;
				for (cid_it = cid_collection; cid_it != NULL; cid_it = cid_it->next) {
					ECalComponentId* _tmp1_;
					ECalComponentId* cid = NULL;
					_tmp1_ = __vala_ECalComponentId_copy0 ((ECalComponentId*) cid_it->data);
					cid = _tmp1_;
					{
						GHashTable* _tmp2_;
						ECalComponentId* _tmp3_;
						ECalComponentId* _tmp4_;
						gchar* _tmp5_;
						gchar* _tmp6_;
						_tmp2_ = self->priv->scheduled_task_notifications;
						_tmp3_ = cid;
						g_hash_table_remove (_tmp2_, _tmp3_);
						_tmp4_ = cid;
						_tmp5_ = tasks_today_task_monitor_format_ecal_component_id (self, _tmp4_);
						_tmp6_ = _tmp5_;
						g_debug ("TodayTaskMonitor.vala:170: [%s] Removed scheduled notification for tas" \
"k.", _tmp6_);
						_g_free0 (_tmp6_);
						__vala_ECalComponentId_free0 (cid);
					}
				}
			}
		}
		__finally0:
		{
			GHashTable* _tmp7_;
			_tmp7_ = self->priv->scheduled_task_notifications;
			g_rec_mutex_unlock (&self->priv->__lock_scheduled_task_notifications);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	{
		GHashTable* _tmp8_;
		_tmp8_ = self->priv->sent_task_notifications;
		g_rec_mutex_lock (&self->priv->__lock_sent_task_notifications);
		{
			{
				GSList* cid_collection = NULL;
				GSList* cid_it = NULL;
				cid_collection = cids;
				for (cid_it = cid_collection; cid_it != NULL; cid_it = cid_it->next) {
					ECalComponentId* _tmp9_;
					ECalComponentId* cid = NULL;
					_tmp9_ = __vala_ECalComponentId_copy0 ((ECalComponentId*) cid_it->data);
					cid = _tmp9_;
					{
						GHashTable* _tmp10_;
						ECalComponentId* _tmp11_;
						ECalComponentId* _tmp12_;
						gchar* _tmp13_;
						gchar* _tmp14_;
						_tmp10_ = self->priv->sent_task_notifications;
						_tmp11_ = cid;
						g_hash_table_remove (_tmp10_, _tmp11_);
						_tmp12_ = cid;
						_tmp13_ = tasks_today_task_monitor_format_ecal_component_id (self, _tmp12_);
						_tmp14_ = _tmp13_;
						g_debug ("TodayTaskMonitor.vala:177: [%s] Removed sent notification for task.", _tmp14_);
						_g_free0 (_tmp14_);
						__vala_ECalComponentId_free0 (cid);
					}
				}
			}
		}
		__finally1:
		{
			GHashTable* _tmp15_;
			_tmp15_ = self->priv->sent_task_notifications;
			g_rec_mutex_unlock (&self->priv->__lock_sent_task_notifications);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
tasks_today_task_monitor_send_notification (TasksTodayTaskMonitor* self,
                                            ECalComponentId* cid)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cid != NULL);
	{
		GHashTable* _tmp0_;
		_tmp0_ = self->priv->scheduled_task_notifications;
		g_rec_mutex_lock (&self->priv->__lock_scheduled_task_notifications);
		{
			gboolean exists = FALSE;
			GNotification* notification = NULL;
			GHashTable* _tmp1_;
			gboolean _tmp2_ = FALSE;
			gpointer _tmp3_;
			_tmp1_ = self->priv->scheduled_task_notifications;
			_tmp3_ = _vala_g_hash_table_take (_tmp1_, cid, &_tmp2_);
			exists = _tmp2_;
			notification = (GNotification*) _tmp3_;
			if (exists) {
				GApplication* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				GNotification* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp4_ = g_application_get_default ();
				_tmp5_ = tasks_today_task_monitor_format_ecal_component_id (self, cid);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_strdup_printf ("%s-%u", _tmp6_, (guint) g_random_int ());
				_tmp8_ = _tmp7_;
				_tmp9_ = notification;
				g_application_send_notification (_tmp4_, _tmp8_, _tmp9_);
				_g_free0 (_tmp8_);
				_g_free0 (_tmp6_);
				_tmp10_ = tasks_today_task_monitor_format_ecal_component_id (self, cid);
				_tmp11_ = _tmp10_;
				g_debug ("TodayTaskMonitor.vala:191: [%s] Sent notification for task.", _tmp11_);
				_g_free0 (_tmp11_);
				{
					GHashTable* _tmp12_;
					_tmp12_ = self->priv->sent_task_notifications;
					g_rec_mutex_lock (&self->priv->__lock_sent_task_notifications);
					{
						GHashTable* _tmp13_;
						ECalComponentId* _tmp14_;
						GNotification* _tmp15_;
						GNotification* _tmp16_;
						_tmp13_ = self->priv->sent_task_notifications;
						_tmp14_ = __vala_ECalComponentId_copy0 (cid);
						_tmp15_ = notification;
						_tmp16_ = _g_object_ref0 (_tmp15_);
						g_hash_table_insert (_tmp13_, _tmp14_, _tmp16_);
					}
					__finally1:
					{
						GHashTable* _tmp17_;
						_tmp17_ = self->priv->sent_task_notifications;
						g_rec_mutex_unlock (&self->priv->__lock_sent_task_notifications);
					}
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (notification);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
			}
			_g_object_unref0 (notification);
		}
		__finally0:
		{
			GHashTable* _tmp18_;
			_tmp18_ = self->priv->scheduled_task_notifications;
			g_rec_mutex_unlock (&self->priv->__lock_scheduled_task_notifications);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static gchar*
tasks_today_task_monitor_format_ecal_component_id (TasksTodayTaskMonitor* self,
                                                   ECalComponentId* cid)
{
	const gchar* _tmp0_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cid != NULL, NULL);
	_tmp0_ = e_cal_component_id_get_rid (cid);
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = e_cal_component_id_get_uid (cid);
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = e_cal_component_id_get_uid (cid);
	_tmp4_ = e_cal_component_id_get_rid (cid);
	_tmp5_ = g_strdup_printf ("%s-%s", _tmp3_, _tmp4_);
	result = _tmp5_;
	return result;
}

TasksTodayTaskMonitor*
tasks_today_task_monitor_construct (GType object_type)
{
	TasksTodayTaskMonitor * self = NULL;
	self = (TasksTodayTaskMonitor*) g_object_new (object_type, NULL);
	return self;
}

TasksTodayTaskMonitor*
tasks_today_task_monitor_new (void)
{
	return tasks_today_task_monitor_construct (TASKS_TYPE_TODAY_TASK_MONITOR);
}

static guint
_e_source_hash_ghash_func (gconstpointer key)
{
	guint result;
	result = e_source_hash (key);
	return result;
}

static gboolean
_e_source_equal_gequal_func (gconstpointer a,
                             gconstpointer b)
{
	gboolean result;
	result = e_source_equal (a, (ESource*) b);
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static guint
_e_cal_component_id_hash_ghash_func (gconstpointer key)
{
	guint result;
	result = e_cal_component_id_hash (key);
	return result;
}

static gboolean
_e_cal_component_id_equal_gequal_func (gconstpointer a,
                                       gconstpointer b)
{
	gboolean result;
	result = e_cal_component_id_equal (a, (ECalComponentId*) b);
	return result;
}

static GObject *
tasks_today_task_monitor_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TasksTodayTaskMonitor * self;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	parent_class = G_OBJECT_CLASS (tasks_today_task_monitor_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TASKS_TYPE_TODAY_TASK_MONITOR, TasksTodayTaskMonitor);
	_tmp0_ = g_hash_table_new_full (_e_source_hash_ghash_func, _e_source_equal_gequal_func, _g_object_unref0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->task_list_view);
	self->priv->task_list_view = _tmp0_;
	_tmp1_ = g_hash_table_new_full (_e_cal_component_id_hash_ghash_func, _e_cal_component_id_equal_gequal_func, __vala_ECalComponentId_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->scheduled_task_notifications);
	self->priv->scheduled_task_notifications = _tmp1_;
	_tmp2_ = g_hash_table_new_full (_e_cal_component_id_hash_ghash_func, _e_cal_component_id_equal_gequal_func, __vala_ECalComponentId_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->sent_task_notifications);
	self->priv->sent_task_notifications = _tmp2_;
	return obj;
}

static void
tasks_today_task_monitor_class_init (TasksTodayTaskMonitorClass * klass,
                                     gpointer klass_data)
{
	tasks_today_task_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TasksTodayTaskMonitor_private_offset);
	G_OBJECT_CLASS (klass)->constructor = tasks_today_task_monitor_constructor;
	G_OBJECT_CLASS (klass)->finalize = tasks_today_task_monitor_finalize;
}

static void
tasks_today_task_monitor_instance_init (TasksTodayTaskMonitor * self,
                                        gpointer klass)
{
	self->priv = tasks_today_task_monitor_get_instance_private (self);
	g_rec_mutex_init (&self->priv->__lock_task_list_view);
	g_rec_mutex_init (&self->priv->__lock_scheduled_task_notifications);
	g_rec_mutex_init (&self->priv->__lock_sent_task_notifications);
}

static void
tasks_today_task_monitor_finalize (GObject * obj)
{
	TasksTodayTaskMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TASKS_TYPE_TODAY_TASK_MONITOR, TasksTodayTaskMonitor);
	_g_object_unref0 (self->priv->model);
	g_rec_mutex_clear (&self->priv->__lock_task_list_view);
	_g_hash_table_unref0 (self->priv->task_list_view);
	g_rec_mutex_clear (&self->priv->__lock_scheduled_task_notifications);
	_g_hash_table_unref0 (self->priv->scheduled_task_notifications);
	g_rec_mutex_clear (&self->priv->__lock_sent_task_notifications);
	_g_hash_table_unref0 (self->priv->sent_task_notifications);
	G_OBJECT_CLASS (tasks_today_task_monitor_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
tasks_today_task_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TasksTodayTaskMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tasks_today_task_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TasksTodayTaskMonitor), 0, (GInstanceInitFunc) tasks_today_task_monitor_instance_init, NULL };
	GType tasks_today_task_monitor_type_id;
	tasks_today_task_monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "TasksTodayTaskMonitor", &g_define_type_info, 0);
	TasksTodayTaskMonitor_private_offset = g_type_add_instance_private (tasks_today_task_monitor_type_id, sizeof (TasksTodayTaskMonitorPrivate));
	return tasks_today_task_monitor_type_id;
}

GType
tasks_today_task_monitor_get_type (void)
{
	static gsize tasks_today_task_monitor_type_id__once = 0;
	if (g_once_init_enter (&tasks_today_task_monitor_type_id__once)) {
		GType tasks_today_task_monitor_type_id;
		tasks_today_task_monitor_type_id = tasks_today_task_monitor_get_type_once ();
		g_once_init_leave (&tasks_today_task_monitor_type_id__once, tasks_today_task_monitor_type_id);
	}
	return tasks_today_task_monitor_type_id__once;
}

