#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtk3DS_Init(vtkClientServerInterpreter*); }
extern "C" { void vtk3DSImporter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGLTFImporter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImporter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkVRMLImporter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOBJImporter_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkIOImportCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtk3DS_Init(csi);
  vtk3DSImporter_Init(csi);
  vtkGLTFImporter_Init(csi);
  vtkImporter_Init(csi);
  vtkVRMLImporter_Init(csi);
  vtkOBJImporter_Init(csi);
}
