// python wrapper for vtkPVGeometryFilter
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVGeometryFilter.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVGeometryFilter(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVGeometryFilter_ClassNew(); }


static PyObject *
PyvtkPVGeometryFilter_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVGeometryFilter::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVGeometryFilter::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVGeometryFilter *tempr = vtkPVGeometryFilter::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVGeometryFilter *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVGeometryFilter::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVGeometryFilter::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVGeometryFilter::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_GetOutlineFlag(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutlineFlag");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetOutlineFlag() :
      op->vtkPVGeometryFilter::GetOutlineFlag());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_SetUseOutline(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseOutline");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseOutline(temp0);
    }
    else
    {
      op->vtkPVGeometryFilter::SetUseOutline(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_GetUseOutline(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseOutline");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetUseOutline() :
      op->vtkPVGeometryFilter::GetUseOutline());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_SetGenerateFeatureEdges(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGenerateFeatureEdges");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGenerateFeatureEdges(temp0);
    }
    else
    {
      op->vtkPVGeometryFilter::SetGenerateFeatureEdges(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_GetGenerateFeatureEdges(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGenerateFeatureEdges");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetGenerateFeatureEdges() :
      op->vtkPVGeometryFilter::GetGenerateFeatureEdges());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_SetBlockColorsDistinctValues(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBlockColorsDistinctValues");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBlockColorsDistinctValues(temp0);
    }
    else
    {
      op->vtkPVGeometryFilter::SetBlockColorsDistinctValues(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_GetBlockColorsDistinctValues(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBlockColorsDistinctValues");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetBlockColorsDistinctValues() :
      op->vtkPVGeometryFilter::GetBlockColorsDistinctValues());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_SetGenerateCellNormals(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGenerateCellNormals");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGenerateCellNormals(temp0);
    }
    else
    {
      op->vtkPVGeometryFilter::SetGenerateCellNormals(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_GetGenerateCellNormals(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGenerateCellNormals");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetGenerateCellNormals() :
      op->vtkPVGeometryFilter::GetGenerateCellNormals());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_GenerateCellNormalsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenerateCellNormalsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenerateCellNormalsOn();
    }
    else
    {
      op->vtkPVGeometryFilter::GenerateCellNormalsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_GenerateCellNormalsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenerateCellNormalsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenerateCellNormalsOff();
    }
    else
    {
      op->vtkPVGeometryFilter::GenerateCellNormalsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_SetGeneratePointNormals(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGeneratePointNormals");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGeneratePointNormals(temp0);
    }
    else
    {
      op->vtkPVGeometryFilter::SetGeneratePointNormals(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_GetGeneratePointNormals(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGeneratePointNormals");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetGeneratePointNormals() :
      op->vtkPVGeometryFilter::GetGeneratePointNormals());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_GeneratePointNormalsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GeneratePointNormalsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GeneratePointNormalsOn();
    }
    else
    {
      op->vtkPVGeometryFilter::GeneratePointNormalsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_GeneratePointNormalsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GeneratePointNormalsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GeneratePointNormalsOff();
    }
    else
    {
      op->vtkPVGeometryFilter::GeneratePointNormalsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_SetFeatureAngle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFeatureAngle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFeatureAngle(temp0);
    }
    else
    {
      op->vtkPVGeometryFilter::SetFeatureAngle(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_GetFeatureAngle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFeatureAngle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetFeatureAngle() :
      op->vtkPVGeometryFilter::GetFeatureAngle());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_SetSplitting(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSplitting");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSplitting(temp0);
    }
    else
    {
      op->vtkPVGeometryFilter::SetSplitting(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_SplittingOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SplittingOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SplittingOn();
    }
    else
    {
      op->vtkPVGeometryFilter::SplittingOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_SplittingOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SplittingOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SplittingOff();
    }
    else
    {
      op->vtkPVGeometryFilter::SplittingOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_SetTriangulate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTriangulate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTriangulate(temp0);
    }
    else
    {
      op->vtkPVGeometryFilter::SetTriangulate(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_GetTriangulate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTriangulate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTriangulate() :
      op->vtkPVGeometryFilter::GetTriangulate());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_TriangulateOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "TriangulateOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->TriangulateOn();
    }
    else
    {
      op->vtkPVGeometryFilter::TriangulateOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_TriangulateOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "TriangulateOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->TriangulateOff();
    }
    else
    {
      op->vtkPVGeometryFilter::TriangulateOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_SetNonlinearSubdivisionLevel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNonlinearSubdivisionLevel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNonlinearSubdivisionLevel(temp0);
    }
    else
    {
      op->vtkPVGeometryFilter::SetNonlinearSubdivisionLevel(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_GetNonlinearSubdivisionLevel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNonlinearSubdivisionLevel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNonlinearSubdivisionLevel() :
      op->vtkPVGeometryFilter::GetNonlinearSubdivisionLevel());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_SetMatchBoundariesIgnoringCellOrder(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMatchBoundariesIgnoringCellOrder");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMatchBoundariesIgnoringCellOrder(temp0);
    }
    else
    {
      op->vtkPVGeometryFilter::SetMatchBoundariesIgnoringCellOrder(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_GetMatchBoundariesIgnoringCellOrder(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMatchBoundariesIgnoringCellOrder");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMatchBoundariesIgnoringCellOrder() :
      op->vtkPVGeometryFilter::GetMatchBoundariesIgnoringCellOrder());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_SetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  vtkMultiProcessController *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMultiProcessController"))
  {
    if (ap.IsBound())
    {
      op->SetController(temp0);
    }
    else
    {
      op->vtkPVGeometryFilter::SetController(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_GetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkMultiProcessController *tempr = (ap.IsBound() ?
      op->GetController() :
      op->vtkPVGeometryFilter::GetController());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_SetPassThroughCellIds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPassThroughCellIds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPassThroughCellIds(temp0);
    }
    else
    {
      op->vtkPVGeometryFilter::SetPassThroughCellIds(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_GetPassThroughCellIds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPassThroughCellIds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPassThroughCellIds() :
      op->vtkPVGeometryFilter::GetPassThroughCellIds());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_PassThroughCellIdsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PassThroughCellIdsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->PassThroughCellIdsOn();
    }
    else
    {
      op->vtkPVGeometryFilter::PassThroughCellIdsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_PassThroughCellIdsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PassThroughCellIdsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->PassThroughCellIdsOff();
    }
    else
    {
      op->vtkPVGeometryFilter::PassThroughCellIdsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_SetPassThroughPointIds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPassThroughPointIds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPassThroughPointIds(temp0);
    }
    else
    {
      op->vtkPVGeometryFilter::SetPassThroughPointIds(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_GetPassThroughPointIds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPassThroughPointIds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPassThroughPointIds() :
      op->vtkPVGeometryFilter::GetPassThroughPointIds());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_PassThroughPointIdsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PassThroughPointIdsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->PassThroughPointIdsOn();
    }
    else
    {
      op->vtkPVGeometryFilter::PassThroughPointIdsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_PassThroughPointIdsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PassThroughPointIdsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->PassThroughPointIdsOff();
    }
    else
    {
      op->vtkPVGeometryFilter::PassThroughPointIdsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_SetGenerateProcessIds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGenerateProcessIds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGenerateProcessIds(temp0);
    }
    else
    {
      op->vtkPVGeometryFilter::SetGenerateProcessIds(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_GetGenerateProcessIds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGenerateProcessIds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetGenerateProcessIds() :
      op->vtkPVGeometryFilter::GetGenerateProcessIds());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_GenerateProcessIdsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenerateProcessIdsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenerateProcessIdsOn();
    }
    else
    {
      op->vtkPVGeometryFilter::GenerateProcessIdsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_GenerateProcessIdsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenerateProcessIdsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenerateProcessIdsOff();
    }
    else
    {
      op->vtkPVGeometryFilter::GenerateProcessIdsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_SetHideInternalAMRFaces(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHideInternalAMRFaces");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetHideInternalAMRFaces(temp0);
    }
    else
    {
      op->vtkPVGeometryFilter::SetHideInternalAMRFaces(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_GetHideInternalAMRFaces(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetHideInternalAMRFaces");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetHideInternalAMRFaces() :
      op->vtkPVGeometryFilter::GetHideInternalAMRFaces());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_HideInternalAMRFacesOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HideInternalAMRFacesOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->HideInternalAMRFacesOn();
    }
    else
    {
      op->vtkPVGeometryFilter::HideInternalAMRFacesOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_HideInternalAMRFacesOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HideInternalAMRFacesOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->HideInternalAMRFacesOff();
    }
    else
    {
      op->vtkPVGeometryFilter::HideInternalAMRFacesOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_SetUseNonOverlappingAMRMetaDataForOutlines(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseNonOverlappingAMRMetaDataForOutlines");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseNonOverlappingAMRMetaDataForOutlines(temp0);
    }
    else
    {
      op->vtkPVGeometryFilter::SetUseNonOverlappingAMRMetaDataForOutlines(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_GetUseNonOverlappingAMRMetaDataForOutlines(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseNonOverlappingAMRMetaDataForOutlines");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseNonOverlappingAMRMetaDataForOutlines() :
      op->vtkPVGeometryFilter::GetUseNonOverlappingAMRMetaDataForOutlines());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_UseNonOverlappingAMRMetaDataForOutlinesOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseNonOverlappingAMRMetaDataForOutlinesOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseNonOverlappingAMRMetaDataForOutlinesOn();
    }
    else
    {
      op->vtkPVGeometryFilter::UseNonOverlappingAMRMetaDataForOutlinesOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_UseNonOverlappingAMRMetaDataForOutlinesOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseNonOverlappingAMRMetaDataForOutlinesOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeometryFilter *op = static_cast<vtkPVGeometryFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseNonOverlappingAMRMetaDataForOutlinesOff();
    }
    else
    {
      op->vtkPVGeometryFilter::UseNonOverlappingAMRMetaDataForOutlinesOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_POINT_OFFSETS(PyObject * /*unused*/, PyObject *args)
{
  PyErr_WarnEx(PyExc_DeprecationWarning,
    "Call to deprecated staticmethod POINT_OFFSETS."
    " (" "They are not used anymore." ")"
    " -- Deprecated since version " "5.13.0" ".", 1);

  vtkPythonArgs ap(args, "POINT_OFFSETS");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationIntegerVectorKey *tempr = vtkPVGeometryFilter::POINT_OFFSETS();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_VERTS_OFFSETS(PyObject * /*unused*/, PyObject *args)
{
  PyErr_WarnEx(PyExc_DeprecationWarning,
    "Call to deprecated staticmethod VERTS_OFFSETS."
    " (" "They are not used anymore." ")"
    " -- Deprecated since version " "5.13.0" ".", 1);

  vtkPythonArgs ap(args, "VERTS_OFFSETS");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationIntegerVectorKey *tempr = vtkPVGeometryFilter::VERTS_OFFSETS();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_LINES_OFFSETS(PyObject * /*unused*/, PyObject *args)
{
  PyErr_WarnEx(PyExc_DeprecationWarning,
    "Call to deprecated staticmethod LINES_OFFSETS."
    " (" "They are not used anymore." ")"
    " -- Deprecated since version " "5.13.0" ".", 1);

  vtkPythonArgs ap(args, "LINES_OFFSETS");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationIntegerVectorKey *tempr = vtkPVGeometryFilter::LINES_OFFSETS();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_POLYS_OFFSETS(PyObject * /*unused*/, PyObject *args)
{
  PyErr_WarnEx(PyExc_DeprecationWarning,
    "Call to deprecated staticmethod POLYS_OFFSETS."
    " (" "They are not used anymore." ")"
    " -- Deprecated since version " "5.13.0" ".", 1);

  vtkPythonArgs ap(args, "POLYS_OFFSETS");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationIntegerVectorKey *tempr = vtkPVGeometryFilter::POLYS_OFFSETS();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeometryFilter_STRIPS_OFFSETS(PyObject * /*unused*/, PyObject *args)
{
  PyErr_WarnEx(PyExc_DeprecationWarning,
    "Call to deprecated staticmethod STRIPS_OFFSETS."
    " (" "They are not used anymore." ")"
    " -- Deprecated since version " "5.13.0" ".", 1);

  vtkPythonArgs ap(args, "STRIPS_OFFSETS");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationIntegerVectorKey *tempr = vtkPVGeometryFilter::STRIPS_OFFSETS();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVGeometryFilter_Methods[] = {
  {"IsTypeOf", PyvtkPVGeometryFilter_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVGeometryFilter_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVGeometryFilter_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVGeometryFilter\nC++: static vtkPVGeometryFilter *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVGeometryFilter_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVGeometryFilter\nC++: vtkPVGeometryFilter *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVGeometryFilter_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVGeometryFilter_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetOutlineFlag", PyvtkPVGeometryFilter_GetOutlineFlag, METH_VARARGS,
   "GetOutlineFlag(self) -> int\nC++: virtual int GetOutlineFlag()\n\nThis flag is set during the execute method.  It indicates that\nthe input was 3d and an outline representation was used.\n"},
  {"SetUseOutline", PyvtkPVGeometryFilter_SetUseOutline, METH_VARARGS,
   "SetUseOutline(self, _arg:int) -> None\nC++: virtual void SetUseOutline(int _arg)\n\nSet/get whether to produce outline (vs. surface).\n"},
  {"GetUseOutline", PyvtkPVGeometryFilter_GetUseOutline, METH_VARARGS,
   "GetUseOutline(self) -> int\nC++: virtual int GetUseOutline()\n\n"},
  {"SetGenerateFeatureEdges", PyvtkPVGeometryFilter_SetGenerateFeatureEdges, METH_VARARGS,
   "SetGenerateFeatureEdges(self, __a:bool) -> None\nC++: void SetGenerateFeatureEdges(bool)\n\nSet/get whether to produce feature edges (vs. surface). If both\nthis and UseOutline are true, then an outline will be produced.\n"},
  {"GetGenerateFeatureEdges", PyvtkPVGeometryFilter_GetGenerateFeatureEdges, METH_VARARGS,
   "GetGenerateFeatureEdges(self) -> bool\nC++: virtual bool GetGenerateFeatureEdges()\n\n"},
  {"SetBlockColorsDistinctValues", PyvtkPVGeometryFilter_SetBlockColorsDistinctValues, METH_VARARGS,
   "SetBlockColorsDistinctValues(self, _arg:int) -> None\nC++: virtual void SetBlockColorsDistinctValues(int _arg)\n\nDetermines the number of distinct values in vtkBlockColors\n"},
  {"GetBlockColorsDistinctValues", PyvtkPVGeometryFilter_GetBlockColorsDistinctValues, METH_VARARGS,
   "GetBlockColorsDistinctValues(self) -> int\nC++: virtual int GetBlockColorsDistinctValues()\n\n"},
  {"SetGenerateCellNormals", PyvtkPVGeometryFilter_SetGenerateCellNormals, METH_VARARGS,
   "SetGenerateCellNormals(self, __a:int) -> None\nC++: void SetGenerateCellNormals(int)\n\nWhether to generate cell normals.\n\nThe default value is false.\n"},
  {"GetGenerateCellNormals", PyvtkPVGeometryFilter_GetGenerateCellNormals, METH_VARARGS,
   "GetGenerateCellNormals(self) -> int\nC++: virtual int GetGenerateCellNormals()\n\n"},
  {"GenerateCellNormalsOn", PyvtkPVGeometryFilter_GenerateCellNormalsOn, METH_VARARGS,
   "GenerateCellNormalsOn(self) -> None\nC++: virtual void GenerateCellNormalsOn()\n\n"},
  {"GenerateCellNormalsOff", PyvtkPVGeometryFilter_GenerateCellNormalsOff, METH_VARARGS,
   "GenerateCellNormalsOff(self) -> None\nC++: virtual void GenerateCellNormalsOff()\n\n"},
  {"SetGeneratePointNormals", PyvtkPVGeometryFilter_SetGeneratePointNormals, METH_VARARGS,
   "SetGeneratePointNormals(self, __a:bool) -> None\nC++: void SetGeneratePointNormals(bool)\n\nWhether to generate point normals.\n\nThe default value is false.\n"},
  {"GetGeneratePointNormals", PyvtkPVGeometryFilter_GetGeneratePointNormals, METH_VARARGS,
   "GetGeneratePointNormals(self) -> bool\nC++: virtual bool GetGeneratePointNormals()\n\n"},
  {"GeneratePointNormalsOn", PyvtkPVGeometryFilter_GeneratePointNormalsOn, METH_VARARGS,
   "GeneratePointNormalsOn(self) -> None\nC++: virtual void GeneratePointNormalsOn()\n\n"},
  {"GeneratePointNormalsOff", PyvtkPVGeometryFilter_GeneratePointNormalsOff, METH_VARARGS,
   "GeneratePointNormalsOff(self) -> None\nC++: virtual void GeneratePointNormalsOff()\n\n"},
  {"SetFeatureAngle", PyvtkPVGeometryFilter_SetFeatureAngle, METH_VARARGS,
   "SetFeatureAngle(self, __a:float) -> None\nC++: void SetFeatureAngle(double)\n\nSpecify the angle that defines a sharp edge. If the difference in\nangle across neighboring polygons is greater than this value, the\nshared edge is considered \"sharp\".\n\nThe default value is 30 degrees.\n"},
  {"GetFeatureAngle", PyvtkPVGeometryFilter_GetFeatureAngle, METH_VARARGS,
   "GetFeatureAngle(self) -> float\nC++: virtual double GetFeatureAngle()\n\n"},
  {"SetSplitting", PyvtkPVGeometryFilter_SetSplitting, METH_VARARGS,
   "SetSplitting(self, __a:bool) -> None\nC++: void SetSplitting(bool)\n\nTurn on/off the splitting of sharp edges.\n\nThe default value is true.\n"},
  {"SplittingOn", PyvtkPVGeometryFilter_SplittingOn, METH_VARARGS,
   "SplittingOn(self) -> None\nC++: virtual void SplittingOn()\n\n"},
  {"SplittingOff", PyvtkPVGeometryFilter_SplittingOff, METH_VARARGS,
   "SplittingOff(self) -> None\nC++: virtual void SplittingOff()\n\n"},
  {"SetTriangulate", PyvtkPVGeometryFilter_SetTriangulate, METH_VARARGS,
   "SetTriangulate(self, _arg:int) -> None\nC++: virtual void SetTriangulate(int _arg)\n\nWhether to triangulate mesh for rendering. This parameter avoid\nrendering issues of non-convex polygons. This option has no\neffect when using OpenGL2 rendering backend. OpenGL2 rendering\nalways triangulates polygonal meshes.\n"},
  {"GetTriangulate", PyvtkPVGeometryFilter_GetTriangulate, METH_VARARGS,
   "GetTriangulate(self) -> int\nC++: virtual int GetTriangulate()\n\n"},
  {"TriangulateOn", PyvtkPVGeometryFilter_TriangulateOn, METH_VARARGS,
   "TriangulateOn(self) -> None\nC++: virtual void TriangulateOn()\n\n"},
  {"TriangulateOff", PyvtkPVGeometryFilter_TriangulateOff, METH_VARARGS,
   "TriangulateOff(self) -> None\nC++: virtual void TriangulateOff()\n\n"},
  {"SetNonlinearSubdivisionLevel", PyvtkPVGeometryFilter_SetNonlinearSubdivisionLevel, METH_VARARGS,
   "SetNonlinearSubdivisionLevel(self, __a:int) -> None\nC++: virtual void SetNonlinearSubdivisionLevel(int)\n\nNonlinear faces are approximated with flat polygons.  This\nparameter controls how many times to subdivide nonlinear surface\ncells.  Higher subdivisions generate closer approximations but\ntake more memory and rendering time.  Subdivision is recursive,\nso the number of output polygons can grow exponentially with this\nparameter.\n"},
  {"GetNonlinearSubdivisionLevel", PyvtkPVGeometryFilter_GetNonlinearSubdivisionLevel, METH_VARARGS,
   "GetNonlinearSubdivisionLevel(self) -> int\nC++: virtual int GetNonlinearSubdivisionLevel()\n\n"},
  {"SetMatchBoundariesIgnoringCellOrder", PyvtkPVGeometryFilter_SetMatchBoundariesIgnoringCellOrder, METH_VARARGS,
   "SetMatchBoundariesIgnoringCellOrder(self, __a:int) -> None\nC++: virtual void SetMatchBoundariesIgnoringCellOrder(int)\n\nWhen two volumetric cells of different order are connected by\ntheir corners (for instance, a quadratic hexahedron next to a\nlinear hexahedron ), the internal face is rendered and is not\nconsidered as a ghost cell. To remove these faces, switch\nMatchBoundariesIgnoringCellOrder to 1 (default is 0).\n"},
  {"GetMatchBoundariesIgnoringCellOrder", PyvtkPVGeometryFilter_GetMatchBoundariesIgnoringCellOrder, METH_VARARGS,
   "GetMatchBoundariesIgnoringCellOrder(self) -> int\nC++: virtual int GetMatchBoundariesIgnoringCellOrder()\n\n"},
  {"SetController", PyvtkPVGeometryFilter_SetController, METH_VARARGS,
   "SetController(self, __a:vtkMultiProcessController) -> None\nC++: virtual void SetController(vtkMultiProcessController *)\n\nSet and get the controller.\n"},
  {"GetController", PyvtkPVGeometryFilter_GetController, METH_VARARGS,
   "GetController(self) -> vtkMultiProcessController\nC++: virtual vtkMultiProcessController *GetController()\n\n"},
  {"SetPassThroughCellIds", PyvtkPVGeometryFilter_SetPassThroughCellIds, METH_VARARGS,
   "SetPassThroughCellIds(self, __a:int) -> None\nC++: void SetPassThroughCellIds(int)\n\nIf on, the output polygonal dataset will have a celldata array\nthat holds the cell index of the original 3D cell that produced\neach output cell. This is useful for picking but it takes memory.\nThe default is on.\n"},
  {"GetPassThroughCellIds", PyvtkPVGeometryFilter_GetPassThroughCellIds, METH_VARARGS,
   "GetPassThroughCellIds(self) -> int\nC++: virtual int GetPassThroughCellIds()\n\n"},
  {"PassThroughCellIdsOn", PyvtkPVGeometryFilter_PassThroughCellIdsOn, METH_VARARGS,
   "PassThroughCellIdsOn(self) -> None\nC++: virtual void PassThroughCellIdsOn()\n\n"},
  {"PassThroughCellIdsOff", PyvtkPVGeometryFilter_PassThroughCellIdsOff, METH_VARARGS,
   "PassThroughCellIdsOff(self) -> None\nC++: virtual void PassThroughCellIdsOff()\n\n"},
  {"SetPassThroughPointIds", PyvtkPVGeometryFilter_SetPassThroughPointIds, METH_VARARGS,
   "SetPassThroughPointIds(self, __a:int) -> None\nC++: void SetPassThroughPointIds(int)\n\nIf on, the output polygonal dataset will have a pointdata array\nthat holds the point index of the original vertex that produced\neach output vertex. This is useful for picking but it takes\nmemory. The default is on.\n"},
  {"GetPassThroughPointIds", PyvtkPVGeometryFilter_GetPassThroughPointIds, METH_VARARGS,
   "GetPassThroughPointIds(self) -> int\nC++: virtual int GetPassThroughPointIds()\n\n"},
  {"PassThroughPointIdsOn", PyvtkPVGeometryFilter_PassThroughPointIdsOn, METH_VARARGS,
   "PassThroughPointIdsOn(self) -> None\nC++: virtual void PassThroughPointIdsOn()\n\n"},
  {"PassThroughPointIdsOff", PyvtkPVGeometryFilter_PassThroughPointIdsOff, METH_VARARGS,
   "PassThroughPointIdsOff(self) -> None\nC++: virtual void PassThroughPointIdsOff()\n\n"},
  {"SetGenerateProcessIds", PyvtkPVGeometryFilter_SetGenerateProcessIds, METH_VARARGS,
   "SetGenerateProcessIds(self, _arg:bool) -> None\nC++: virtual void SetGenerateProcessIds(bool _arg)\n\nIf on, point arrays named vtkProcessId is added.\n"},
  {"GetGenerateProcessIds", PyvtkPVGeometryFilter_GetGenerateProcessIds, METH_VARARGS,
   "GetGenerateProcessIds(self) -> bool\nC++: virtual bool GetGenerateProcessIds()\n\n"},
  {"GenerateProcessIdsOn", PyvtkPVGeometryFilter_GenerateProcessIdsOn, METH_VARARGS,
   "GenerateProcessIdsOn(self) -> None\nC++: virtual void GenerateProcessIdsOn()\n\n"},
  {"GenerateProcessIdsOff", PyvtkPVGeometryFilter_GenerateProcessIdsOff, METH_VARARGS,
   "GenerateProcessIdsOff(self) -> None\nC++: virtual void GenerateProcessIdsOff()\n\n"},
  {"SetHideInternalAMRFaces", PyvtkPVGeometryFilter_SetHideInternalAMRFaces, METH_VARARGS,
   "SetHideInternalAMRFaces(self, _arg:bool) -> None\nC++: virtual void SetHideInternalAMRFaces(bool _arg)\n\nThis property affects the way AMR outlines and faces are\ngenerated. When set to true (default), internal data-set\nfaces/outlines for datasets within the AMR grids are hidden. Set\nit to false to see boxes for all the datasets in the AMR,\ninternal or otherwise.\n"},
  {"GetHideInternalAMRFaces", PyvtkPVGeometryFilter_GetHideInternalAMRFaces, METH_VARARGS,
   "GetHideInternalAMRFaces(self) -> bool\nC++: virtual bool GetHideInternalAMRFaces()\n\n"},
  {"HideInternalAMRFacesOn", PyvtkPVGeometryFilter_HideInternalAMRFacesOn, METH_VARARGS,
   "HideInternalAMRFacesOn(self) -> None\nC++: virtual void HideInternalAMRFacesOn()\n\n"},
  {"HideInternalAMRFacesOff", PyvtkPVGeometryFilter_HideInternalAMRFacesOff, METH_VARARGS,
   "HideInternalAMRFacesOff(self) -> None\nC++: virtual void HideInternalAMRFacesOff()\n\n"},
  {"SetUseNonOverlappingAMRMetaDataForOutlines", PyvtkPVGeometryFilter_SetUseNonOverlappingAMRMetaDataForOutlines, METH_VARARGS,
   "SetUseNonOverlappingAMRMetaDataForOutlines(self, _arg:bool)\n    -> None\nC++: virtual void SetUseNonOverlappingAMRMetaDataForOutlines(\n    bool _arg)\n\nFor overlapping AMR, this property controls affects the way AMR\noutlines are generated. When set to true (default), it uses the\noverlapping AMR meta-data to identify the blocks present in the\nAMR. Which implies that even if the input did not fill in the\nuniform grids for all datasets in the AMR, this filter can\ngenerate outlines using the metadata alone. When set to false,\nthe filter will only generate outlines for datasets that are\nactually present. Note, this only affects overlapping AMR.\n"},
  {"GetUseNonOverlappingAMRMetaDataForOutlines", PyvtkPVGeometryFilter_GetUseNonOverlappingAMRMetaDataForOutlines, METH_VARARGS,
   "GetUseNonOverlappingAMRMetaDataForOutlines(self) -> bool\nC++: virtual bool GetUseNonOverlappingAMRMetaDataForOutlines()\n\n"},
  {"UseNonOverlappingAMRMetaDataForOutlinesOn", PyvtkPVGeometryFilter_UseNonOverlappingAMRMetaDataForOutlinesOn, METH_VARARGS,
   "UseNonOverlappingAMRMetaDataForOutlinesOn(self) -> None\nC++: virtual void UseNonOverlappingAMRMetaDataForOutlinesOn()\n\n"},
  {"UseNonOverlappingAMRMetaDataForOutlinesOff", PyvtkPVGeometryFilter_UseNonOverlappingAMRMetaDataForOutlinesOff, METH_VARARGS,
   "UseNonOverlappingAMRMetaDataForOutlinesOff(self) -> None\nC++: virtual void UseNonOverlappingAMRMetaDataForOutlinesOff()\n\n"},
  {"POINT_OFFSETS", PyvtkPVGeometryFilter_POINT_OFFSETS, METH_VARARGS,
   "POINT_OFFSETS() -> vtkInformationIntegerVectorKey\nC++: static vtkInformationIntegerVectorKey *POINT_OFFSETS()\n\n"},
  {"VERTS_OFFSETS", PyvtkPVGeometryFilter_VERTS_OFFSETS, METH_VARARGS,
   "VERTS_OFFSETS() -> vtkInformationIntegerVectorKey\nC++: static vtkInformationIntegerVectorKey *VERTS_OFFSETS()\n\n"},
  {"LINES_OFFSETS", PyvtkPVGeometryFilter_LINES_OFFSETS, METH_VARARGS,
   "LINES_OFFSETS() -> vtkInformationIntegerVectorKey\nC++: static vtkInformationIntegerVectorKey *LINES_OFFSETS()\n\n"},
  {"POLYS_OFFSETS", PyvtkPVGeometryFilter_POLYS_OFFSETS, METH_VARARGS,
   "POLYS_OFFSETS() -> vtkInformationIntegerVectorKey\nC++: static vtkInformationIntegerVectorKey *POLYS_OFFSETS()\n\n"},
  {"STRIPS_OFFSETS", PyvtkPVGeometryFilter_STRIPS_OFFSETS, METH_VARARGS,
   "STRIPS_OFFSETS() -> vtkInformationIntegerVectorKey\nC++: static vtkInformationIntegerVectorKey *STRIPS_OFFSETS()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVGeometryFilter_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("use_outline"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeometryFilter_GetUseOutline(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeometryFilter_SetUseOutline(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeometryFilter_SetUseOutline(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseOutline/SetUseOutline\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("generate_feature_edges"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeometryFilter_GetGenerateFeatureEdges(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeometryFilter_SetGenerateFeatureEdges(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeometryFilter_SetGenerateFeatureEdges(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGenerateFeatureEdges/SetGenerateFeatureEdges\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("block_colors_distinct_values"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeometryFilter_GetBlockColorsDistinctValues(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeometryFilter_SetBlockColorsDistinctValues(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeometryFilter_SetBlockColorsDistinctValues(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBlockColorsDistinctValues/SetBlockColorsDistinctValues\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("generate_cell_normals"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeometryFilter_GetGenerateCellNormals(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeometryFilter_SetGenerateCellNormals(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeometryFilter_SetGenerateCellNormals(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGenerateCellNormals/SetGenerateCellNormals\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("generate_point_normals"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeometryFilter_GetGeneratePointNormals(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeometryFilter_SetGeneratePointNormals(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeometryFilter_SetGeneratePointNormals(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGeneratePointNormals/SetGeneratePointNormals\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("feature_angle"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeometryFilter_GetFeatureAngle(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeometryFilter_SetFeatureAngle(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeometryFilter_SetFeatureAngle(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFeatureAngle/SetFeatureAngle\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("splitting"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeometryFilter_SetSplitting(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeometryFilter_SetSplitting(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSplitting\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("triangulate"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeometryFilter_GetTriangulate(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeometryFilter_SetTriangulate(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeometryFilter_SetTriangulate(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTriangulate/SetTriangulate\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("nonlinear_subdivision_level"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeometryFilter_GetNonlinearSubdivisionLevel(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeometryFilter_SetNonlinearSubdivisionLevel(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeometryFilter_SetNonlinearSubdivisionLevel(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNonlinearSubdivisionLevel/SetNonlinearSubdivisionLevel\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("match_boundaries_ignoring_cell_order"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeometryFilter_GetMatchBoundariesIgnoringCellOrder(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeometryFilter_SetMatchBoundariesIgnoringCellOrder(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeometryFilter_SetMatchBoundariesIgnoringCellOrder(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMatchBoundariesIgnoringCellOrder/SetMatchBoundariesIgnoringCellOrder\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("controller"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeometryFilter_GetController(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeometryFilter_SetController(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeometryFilter_SetController(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetController/SetController\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("pass_through_cell_ids"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeometryFilter_GetPassThroughCellIds(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeometryFilter_SetPassThroughCellIds(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeometryFilter_SetPassThroughCellIds(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPassThroughCellIds/SetPassThroughCellIds\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("pass_through_point_ids"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeometryFilter_GetPassThroughPointIds(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeometryFilter_SetPassThroughPointIds(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeometryFilter_SetPassThroughPointIds(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPassThroughPointIds/SetPassThroughPointIds\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("generate_process_ids"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeometryFilter_GetGenerateProcessIds(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeometryFilter_SetGenerateProcessIds(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeometryFilter_SetGenerateProcessIds(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGenerateProcessIds/SetGenerateProcessIds\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("hide_internal_amr_faces"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeometryFilter_GetHideInternalAMRFaces(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeometryFilter_SetHideInternalAMRFaces(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeometryFilter_SetHideInternalAMRFaces(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetHideInternalAMRFaces/SetHideInternalAMRFaces\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_non_overlapping_amr_meta_data_for_outlines"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeometryFilter_GetUseNonOverlappingAMRMetaDataForOutlines(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeometryFilter_SetUseNonOverlappingAMRMetaDataForOutlines(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeometryFilter_SetUseNonOverlappingAMRMetaDataForOutlines(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseNonOverlappingAMRMetaDataForOutlines/SetUseNonOverlappingAMRMetaDataForOutlines\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("outline_flag"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeometryFilter_GetOutlineFlag(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetOutlineFlag\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVGeometryFilter_Doc =
  "vtkPVGeometryFilter - Geometry filter that does outlines for volumes.\n\n"
  "Superclass: vtkDataObjectAlgorithm\n\n"
  "This filter defaults to using the outline filter unless the input is\n"
  "a structured volume.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVGeometryFilter_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersRendering.vtkPVGeometryFilter", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVGeometryFilter_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVGeometryFilter_StaticNew()
{
  return vtkPVGeometryFilter::New();
}

PyObject *PyvtkPVGeometryFilter_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVGeometryFilter_Type, PyvtkPVGeometryFilter_Methods,
    "vtkPVGeometryFilter",
 &PyvtkPVGeometryFilter_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkDataObjectAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVGeometryFilter_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVGeometryFilter(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVGeometryFilter_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVGeometryFilter", o) != 0)
  {
    Py_DECREF(o);
  }

}

