// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "XArrayCFReader_EULA.h"

const char *XArrayCFReader_EULA =
"XArrayCFReader Plugin\n"
"\n"
"This plugin needs the xarray python module which is not shipped with the ParaView binary.\n"
"\n"
"If you are building ParaView yourself, please ensure it is installed in the python you are building against.\n"
"\n"
"If not, a solution is to create a python environment in a directory DIR using:\n"
"\n"
"cd DIR\n"
"uv venv --python VERSION\n"
"\n"
"where VERSION is the version of Python used by ParaView (please see Help / About for the current version) and then install xarray in that environment\n"
"making sure you match the version of all relevant python packages included with the ParaView binary (run bin/pvpython -m paraview.apps.packages to see\n"
"those versions).\n"
"\n"
"source .venv/bin/activate\n"
"uv pip install xarray cftime cfgrib zarr h5netcdf \"numpy==1.26.4\" \"pandas==2.0.3\" \"netcdf4==1.6.5\"\n"
"deactivate\n"
"\n"
"After that, you can start ParaView using:\n"
"\n"
"paraview --venv DIR/.venv\n"
"\n"
"See 'Bridging Data and Visualization: Interactive Scientific Exploration with VTK-Xarray Interoperability' blog post for more information about this plugin.\n"
"https://www.kitware.com/bridging-data-and-visualization-interactive-scientific-exploration-with-vtk-xarray-interoperability/\n"
"\n"
"\n"
"Another solution (which directly uses the ParaView's python binary) is to install the xarray python module using your system pip, as described here:\n"
"\n"
"https://discourse.paraview.org/t/install-any-python-package-for-the-paraview-binary-release-using-pip/14437\n"
"";
