// python wrapper for vtkSMTooltipSelectionPipeline
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMTooltipSelectionPipeline.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMTooltipSelectionPipeline(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMTooltipSelectionPipeline_ClassNew(); }

#ifndef DECLARED_PyvtkSMPreselectionPipeline_ClassNew
extern "C" { PyObject *PyvtkSMPreselectionPipeline_ClassNew(); }
#define DECLARED_PyvtkSMPreselectionPipeline_ClassNew
#endif

static PyObject *
PyvtkSMTooltipSelectionPipeline_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMTooltipSelectionPipeline::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTooltipSelectionPipeline_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTooltipSelectionPipeline *op = static_cast<vtkSMTooltipSelectionPipeline *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMTooltipSelectionPipeline::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTooltipSelectionPipeline_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMTooltipSelectionPipeline *tempr = vtkSMTooltipSelectionPipeline::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTooltipSelectionPipeline_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTooltipSelectionPipeline *op = static_cast<vtkSMTooltipSelectionPipeline *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMTooltipSelectionPipeline *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMTooltipSelectionPipeline::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTooltipSelectionPipeline_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMTooltipSelectionPipeline::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTooltipSelectionPipeline_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTooltipSelectionPipeline *op = static_cast<vtkSMTooltipSelectionPipeline *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMTooltipSelectionPipeline::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTooltipSelectionPipeline_GetInstance(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetInstance");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkSMTooltipSelectionPipeline *tempr = vtkSMTooltipSelectionPipeline::GetInstance();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTooltipSelectionPipeline_Hide(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Hide");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTooltipSelectionPipeline *op = static_cast<vtkSMTooltipSelectionPipeline *>(vp);

  vtkSMRenderViewProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMRenderViewProxy"))
  {
    if (ap.IsBound())
    {
      op->Hide(temp0);
    }
    else
    {
      op->vtkSMTooltipSelectionPipeline::Hide(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMTooltipSelectionPipeline_Show(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Show");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTooltipSelectionPipeline *op = static_cast<vtkSMTooltipSelectionPipeline *>(vp);

  vtkSMSourceProxy *temp0 = nullptr;
  vtkSMSourceProxy *temp1 = nullptr;
  vtkSMRenderViewProxy *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMSourceProxy") &&
      ap.GetVTKObject(temp1, "vtkSMSourceProxy") &&
      ap.GetVTKObject(temp2, "vtkSMRenderViewProxy"))
  {
    if (ap.IsBound())
    {
      op->Show(temp0, temp1, temp2);
    }
    else
    {
      op->vtkSMTooltipSelectionPipeline::Show(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMTooltipSelectionPipeline_CanDisplayTooltip(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CanDisplayTooltip");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTooltipSelectionPipeline *op = static_cast<vtkSMTooltipSelectionPipeline *>(vp);

  bool temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->CanDisplayTooltip(temp0) :
      op->vtkSMTooltipSelectionPipeline::CanDisplayTooltip(temp0));

    if (!ap.ErrorOccurred())
    {
      ap.SetArgValue(0, temp0);
    }
    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTooltipSelectionPipeline_GetTooltipInfo_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTooltipInfo");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTooltipSelectionPipeline *op = static_cast<vtkSMTooltipSelectionPipeline *>(vp);

  int temp0;
  std::string temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    bool tempr = (ap.IsBound() ?
      op->GetTooltipInfo(temp0, temp1) :
      op->vtkSMTooltipSelectionPipeline::GetTooltipInfo(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      ap.SetArgValue(1, temp1);
    }
    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMTooltipSelectionPipeline_GetTooltipInfo_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTooltipInfo");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTooltipSelectionPipeline *op = static_cast<vtkSMTooltipSelectionPipeline *>(vp);

  int temp0;
  std::string temp1;
  std::string temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    bool tempr = (ap.IsBound() ?
      op->GetTooltipInfo(temp0, temp1, temp2) :
      op->vtkSMTooltipSelectionPipeline::GetTooltipInfo(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      ap.SetArgValue(1, temp1);
    }
    if (!ap.ErrorOccurred())
    {
      ap.SetArgValue(2, temp2);
    }
    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMTooltipSelectionPipeline_GetTooltipInfo(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkSMTooltipSelectionPipeline_GetTooltipInfo_s1(self, args);
    case 3:
      return PyvtkSMTooltipSelectionPipeline_GetTooltipInfo_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetTooltipInfo");
  return nullptr;
}

static PyMethodDef PyvtkSMTooltipSelectionPipeline_Methods[] = {
  {"IsTypeOf", PyvtkSMTooltipSelectionPipeline_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMTooltipSelectionPipeline_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMTooltipSelectionPipeline_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMTooltipSelectionPipeline\nC++: static vtkSMTooltipSelectionPipeline *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMTooltipSelectionPipeline_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMTooltipSelectionPipeline\nC++: vtkSMTooltipSelectionPipeline *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMTooltipSelectionPipeline_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMTooltipSelectionPipeline_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetInstance", PyvtkSMTooltipSelectionPipeline_GetInstance, METH_VARARGS,
   "GetInstance() -> vtkSMTooltipSelectionPipeline\nC++: static vtkSMTooltipSelectionPipeline *GetInstance()\n\n"},
  {"Hide", PyvtkSMTooltipSelectionPipeline_Hide, METH_VARARGS,
   "Hide(self, view:vtkSMRenderViewProxy) -> None\nC++: void Hide(vtkSMRenderViewProxy *view) override;\n\nRe-implemented from vtkSMPreselectionPipeline\n"},
  {"Show", PyvtkSMTooltipSelectionPipeline_Show, METH_VARARGS,
   "Show(self, sourceRepresentation:vtkSMSourceProxy,\n    selection:vtkSMSourceProxy, view:vtkSMRenderViewProxy) -> None\nC++: void Show(vtkSMSourceProxy *sourceRepresentation,\n    vtkSMSourceProxy *selection, vtkSMRenderViewProxy *view)\n    override;\n\nShows the interactive selection for 'selection' and\n'sourceRepresentation'. If either sourceRepresentation or\nselection are null it hides the interactive selection.\n"},
  {"CanDisplayTooltip", PyvtkSMTooltipSelectionPipeline_CanDisplayTooltip, METH_VARARGS,
   "CanDisplayTooltip(self, showTooltip:bool) -> bool\nC++: bool CanDisplayTooltip(bool &showTooltip)\n\nReturn true if a tooltip can be displayed according to the\ncontext, otherwise return false. The argument showTooltip is true\nif the tooltip must be shown, false if the tooltip must be\nhidden.\n"},
  {"GetTooltipInfo", PyvtkSMTooltipSelectionPipeline_GetTooltipInfo, METH_VARARGS,
   "GetTooltipInfo(self, association:int, tooltipText:str) -> bool\nC++: bool GetTooltipInfo(int association,\n    std::string &tooltipText)\nGetTooltipInfo(self, association:int, tooltipText:str,\n    plainTooltipText:str) -> bool\nC++: bool GetTooltipInfo(int association,\n    std::string &tooltipText, std::string &plainTooltipText)\n\nGet information about the tooltip to be displayed in a HTML\nformated string. tooltipText received a HTML formatted string,\nwhile plainTooltipText receive a plain text version. Return false\nif the method failed computing information.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMTooltipSelectionPipeline_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("instance"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMTooltipSelectionPipeline_GetInstance(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetInstance\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMTooltipSelectionPipeline_Doc =
  "vtkSMTooltipSelectionPipeline - Point tooltip mode enables the user\nto inspect points (coordinates, data array values) by hovering the\nmouse cursor over a point.\n\n"
  "Superclass: vtkSMPreselectionPipeline\n\n"
  "This is a global object that holds the pipeline for showing the point\n"
  "tooltip mode.\n\n"
  "@sa\n"
  "vtkSMPreselectionPipeline vtkSMInteractiveSelectionPipeline\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMTooltipSelectionPipeline_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingMisc.vtkSMTooltipSelectionPipeline", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMTooltipSelectionPipeline_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMTooltipSelectionPipeline_StaticNew()
{
  return vtkSMTooltipSelectionPipeline::New();
}

PyObject *PyvtkSMTooltipSelectionPipeline_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMTooltipSelectionPipeline_Type, PyvtkSMTooltipSelectionPipeline_Methods,
    "vtkSMTooltipSelectionPipeline",
 &PyvtkSMTooltipSelectionPipeline_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkSMPreselectionPipeline_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMTooltipSelectionPipeline_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMTooltipSelectionPipeline(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMTooltipSelectionPipeline_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMTooltipSelectionPipeline", o) != 0)
  {
    Py_DECREF(o);
  }

}

