// python wrapper for vtkPVHardwareSelector
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVHardwareSelector.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVHardwareSelector(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVHardwareSelector_ClassNew(); }


static PyObject *
PyvtkPVHardwareSelector_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVHardwareSelector::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVHardwareSelector_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHardwareSelector *op = static_cast<vtkPVHardwareSelector *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVHardwareSelector::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVHardwareSelector_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVHardwareSelector *tempr = vtkPVHardwareSelector::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVHardwareSelector_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHardwareSelector *op = static_cast<vtkPVHardwareSelector *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVHardwareSelector *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVHardwareSelector::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVHardwareSelector_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVHardwareSelector::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVHardwareSelector_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHardwareSelector *op = static_cast<vtkPVHardwareSelector *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVHardwareSelector::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVHardwareSelector_SetView(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetView");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHardwareSelector *op = static_cast<vtkPVHardwareSelector *>(vp);

  vtkPVRenderView *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVRenderView"))
  {
    if (ap.IsBound())
    {
      op->SetView(temp0);
    }
    else
    {
      op->vtkPVHardwareSelector::SetView(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVHardwareSelector_Select(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Select");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHardwareSelector *op = static_cast<vtkPVHardwareSelector *>(vp);

  const size_t size0 = 4;
  int temp0[4];
  int save0[4];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    vtkSelection *tempr = (ap.IsBound() ?
      op->Select(temp0) :
      op->vtkPVHardwareSelector::Select(temp0));

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVHardwareSelector_PolygonSelect(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PolygonSelect");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHardwareSelector *op = static_cast<vtkPVHardwareSelector *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<int> store0(2*size0);
  int *temp0 = store0.Data();
  int *save0 = (size0 == 0 ? nullptr : temp0 + size0);
  long long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    vtkSelection *tempr = (ap.IsBound() ?
      op->PolygonSelect(temp0, temp1) :
      op->vtkPVHardwareSelector::PolygonSelect(temp0, temp1));

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVHardwareSelector_NeedToRenderForSelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NeedToRenderForSelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHardwareSelector *op = static_cast<vtkPVHardwareSelector *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->NeedToRenderForSelection() :
      op->vtkPVHardwareSelector::NeedToRenderForSelection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVHardwareSelector_InvalidateCachedSelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InvalidateCachedSelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHardwareSelector *op = static_cast<vtkPVHardwareSelector *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->InvalidateCachedSelection();
    }
    else
    {
      op->vtkPVHardwareSelector::InvalidateCachedSelection();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVHardwareSelector_AssignUniqueId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AssignUniqueId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHardwareSelector *op = static_cast<vtkPVHardwareSelector *>(vp);

  vtkProp *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkProp"))
  {
    int tempr = (ap.IsBound() ?
      op->AssignUniqueId(temp0) :
      op->vtkPVHardwareSelector::AssignUniqueId(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVHardwareSelector_BeginRenderProp_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "BeginRenderProp");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHardwareSelector *op = static_cast<vtkPVHardwareSelector *>(vp);

  vtkRenderWindow *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderWindow"))
  {
    if (ap.IsBound())
    {
      op->BeginRenderProp(temp0);
    }
    else
    {
      op->vtkPVHardwareSelector::BeginRenderProp(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVHardwareSelector_BeginRenderProp_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "BeginRenderProp");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVHardwareSelector *op = static_cast<vtkPVHardwareSelector *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->BeginRenderProp();
    }
    else
    {
      op->vtkPVHardwareSelector::BeginRenderProp();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVHardwareSelector_BeginRenderProp(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkPVHardwareSelector_BeginRenderProp_s1(self, args);
    case 0:
      return PyvtkPVHardwareSelector_BeginRenderProp_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "BeginRenderProp");
  return nullptr;
}

static PyMethodDef PyvtkPVHardwareSelector_Methods[] = {
  {"IsTypeOf", PyvtkPVHardwareSelector_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVHardwareSelector_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVHardwareSelector_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVHardwareSelector\nC++: static vtkPVHardwareSelector *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVHardwareSelector_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVHardwareSelector\nC++: vtkPVHardwareSelector *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVHardwareSelector_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVHardwareSelector_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetView", PyvtkPVHardwareSelector_SetView, METH_VARARGS,
   "SetView(self, view:vtkPVRenderView) -> None\nC++: void SetView(vtkPVRenderView *view)\n\nSet the view that will be used to exchange messages between all\nprocesses involved. Note this does not affect the reference count\nof the view.\n"},
  {"Select", PyvtkPVHardwareSelector_Select, METH_VARARGS,
   "Select(self, region:[int, int, int, int]) -> vtkSelection\nC++: virtual vtkSelection *Select(int region[4])\n\nPerform the selection over the specified region. Avoid clearing\nof captured buffers.\n"},
  {"PolygonSelect", PyvtkPVHardwareSelector_PolygonSelect, METH_VARARGS,
   "PolygonSelect(self, polygonPoints:[int, ...], count:int)\n    -> vtkSelection\nC++: vtkSelection *PolygonSelect(int *polygonPoints,\n    vtkIdType count)\n\nSame as Select() above, except this one use a polygon, instead of\na rectangle region, and select elements inside the polygon\n"},
  {"NeedToRenderForSelection", PyvtkPVHardwareSelector_NeedToRenderForSelection, METH_VARARGS,
   "NeedToRenderForSelection(self) -> bool\nC++: virtual bool NeedToRenderForSelection()\n\nReturns true when the next call to Select() will result in\nrenders to capture the selection-buffers.\n"},
  {"InvalidateCachedSelection", PyvtkPVHardwareSelector_InvalidateCachedSelection, METH_VARARGS,
   "InvalidateCachedSelection(self) -> None\nC++: void InvalidateCachedSelection()\n\nCalled to invalidate the cache.\n"},
  {"AssignUniqueId", PyvtkPVHardwareSelector_AssignUniqueId, METH_VARARGS,
   "AssignUniqueId(self, __a:vtkProp) -> int\nC++: int AssignUniqueId(vtkProp *)\n\n"},
  {"BeginRenderProp", PyvtkPVHardwareSelector_BeginRenderProp, METH_VARARGS,
   "BeginRenderProp(self, __a:vtkRenderWindow) -> None\nC++: void BeginRenderProp(vtkRenderWindow *) override;\nBeginRenderProp(self) -> None\nC++: void BeginRenderProp() override;\n\nSet the local ProcessId.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVHardwareSelector_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("view"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVHardwareSelector_SetView(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVHardwareSelector_SetView(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetView\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVHardwareSelector_Doc =
  "vtkPVHardwareSelector - vtkHardwareSelector subclass with paraview\nspecific logic to avoid recapturing buffers unless needed.\n\n"
  "Superclass: vtkOpenGLHardwareSelector\n\n"
  "vtkHardwareSelector is subclass of vtkHardwareSelector that adds\n"
  "logic to reuse the captured buffers as much as possible. Thus\n"
  "avoiding repeated selection-rendering of repeated selections or\n"
  "picking. This class does not know, however, when the cached buffers\n"
  "are invalid. External logic must explicitly calls\n"
  "InvalidateCachedSelection() to ensure that the cache is not reused.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVHardwareSelector_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPVHardwareSelector", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVHardwareSelector_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVHardwareSelector_StaticNew()
{
  return vtkPVHardwareSelector::New();
}

PyObject *PyvtkPVHardwareSelector_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVHardwareSelector_Type, PyvtkPVHardwareSelector_Methods,
    "vtkPVHardwareSelector",
 &PyvtkPVHardwareSelector_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkOpenGLHardwareSelector");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVHardwareSelector_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVHardwareSelector(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVHardwareSelector_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVHardwareSelector", o) != 0)
  {
    Py_DECREF(o);
  }

}

