// python wrapper for vtkMaterialInterfacePieceTransaction
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkMaterialInterfacePieceTransaction.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkMaterialInterfacePieceTransaction(PyObject *dict); }

static PyObject *
PyvtkMaterialInterfacePieceTransaction_Initialize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfacePieceTransaction *op = static_cast<vtkMaterialInterfacePieceTransaction *>(vp);

  char temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    op->Initialize(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfacePieceTransaction_Empty(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Empty");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfacePieceTransaction *op = static_cast<vtkMaterialInterfacePieceTransaction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = op->Empty();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfacePieceTransaction_Clear(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Clear");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfacePieceTransaction *op = static_cast<vtkMaterialInterfacePieceTransaction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    op->Clear();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfacePieceTransaction_Pack(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Pack");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfacePieceTransaction *op = static_cast<vtkMaterialInterfacePieceTransaction *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<int> store0(2*size0);
  int *temp0 = store0.Data();
  int *save0 = (size0 == 0 ? nullptr : temp0 + size0);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    op->Pack(temp0);

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfacePieceTransaction_UnPack(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UnPack");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfacePieceTransaction *op = static_cast<vtkMaterialInterfacePieceTransaction *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<int> store0(2*size0);
  int *temp0 = store0.Data();
  int *save0 = (size0 == 0 ? nullptr : temp0 + size0);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    op->UnPack(temp0);

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfacePieceTransaction_GetType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetType");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfacePieceTransaction *op = static_cast<vtkMaterialInterfacePieceTransaction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char tempr = op->GetType();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfacePieceTransaction_GetRemoteProc(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRemoteProc");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfacePieceTransaction *op = static_cast<vtkMaterialInterfacePieceTransaction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = op->GetRemoteProc();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfacePieceTransaction_GetFlatSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFlatSize");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfacePieceTransaction *op = static_cast<vtkMaterialInterfacePieceTransaction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = op->GetFlatSize();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkMaterialInterfacePieceTransaction_Methods[] = {
  {"Initialize", PyvtkMaterialInterfacePieceTransaction_Initialize, METH_VARARGS,
   "Initialize(self, type:str, remoteProc:int) -> None\nC++: void Initialize(char type, int remoteProc)\n\n"},
  {"Empty", PyvtkMaterialInterfacePieceTransaction_Empty, METH_VARARGS,
   "Empty(self) -> bool\nC++: bool Empty()\n\n"},
  {"Clear", PyvtkMaterialInterfacePieceTransaction_Clear, METH_VARARGS,
   "Clear(self) -> None\nC++: void Clear()\n\n"},
  {"Pack", PyvtkMaterialInterfacePieceTransaction_Pack, METH_VARARGS,
   "Pack(self, buf:[int, ...]) -> None\nC++: void Pack(int *buf)\n\n"},
  {"UnPack", PyvtkMaterialInterfacePieceTransaction_UnPack, METH_VARARGS,
   "UnPack(self, buf:[int, ...]) -> None\nC++: void UnPack(int *buf)\n\n"},
  {"GetType", PyvtkMaterialInterfacePieceTransaction_GetType, METH_VARARGS,
   "GetType(self) -> str\nC++: char GetType()\n\n"},
  {"GetRemoteProc", PyvtkMaterialInterfacePieceTransaction_GetRemoteProc, METH_VARARGS,
   "GetRemoteProc(self) -> int\nC++: int GetRemoteProc()\n\n"},
  {"GetFlatSize", PyvtkMaterialInterfacePieceTransaction_GetFlatSize, METH_VARARGS,
   "GetFlatSize(self) -> int\nC++: int GetFlatSize()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkMaterialInterfacePieceTransaction_GetSets[] = {
  {
    /*name=*/pystr("type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMaterialInterfacePieceTransaction_GetType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("remote_proc"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMaterialInterfacePieceTransaction_GetRemoteProc(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetRemoteProc\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("flat_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMaterialInterfacePieceTransaction_GetFlatSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetFlatSize\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};

static PyObject *
PyvtkMaterialInterfacePieceTransaction_vtkMaterialInterfacePieceTransaction_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkMaterialInterfacePieceTransaction");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkMaterialInterfacePieceTransaction *op = new vtkMaterialInterfacePieceTransaction();

    result = PyVTKSpecialObject_New("vtkMaterialInterfacePieceTransaction", op);
  }

  return result;
}

static PyObject *
PyvtkMaterialInterfacePieceTransaction_vtkMaterialInterfacePieceTransaction_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkMaterialInterfacePieceTransaction");

  char temp0;
  int temp1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    vtkMaterialInterfacePieceTransaction *op = new vtkMaterialInterfacePieceTransaction(temp0, temp1);

    result = PyVTKSpecialObject_New("vtkMaterialInterfacePieceTransaction", op);
  }

  return result;
}

static PyObject *
PyvtkMaterialInterfacePieceTransaction_vtkMaterialInterfacePieceTransaction_s3(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkMaterialInterfacePieceTransaction");

  vtkMaterialInterfacePieceTransaction *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkMaterialInterfacePieceTransaction"))
  {
    vtkMaterialInterfacePieceTransaction *op = new vtkMaterialInterfacePieceTransaction(*temp0);

    result = PyVTKSpecialObject_New("vtkMaterialInterfacePieceTransaction", op);
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyMethodDef PyvtkMaterialInterfacePieceTransaction_vtkMaterialInterfacePieceTransaction_Methods[] = {
  {"vtkMaterialInterfacePieceTransaction", PyvtkMaterialInterfacePieceTransaction_vtkMaterialInterfacePieceTransaction_s3, METH_VARARGS,
   "@W vtkMaterialInterfacePieceTransaction"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkMaterialInterfacePieceTransaction_vtkMaterialInterfacePieceTransaction(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 0:
      return PyvtkMaterialInterfacePieceTransaction_vtkMaterialInterfacePieceTransaction_s1(self, args);
    case 2:
      return PyvtkMaterialInterfacePieceTransaction_vtkMaterialInterfacePieceTransaction_s2(self, args);
    case 1:
      return PyvtkMaterialInterfacePieceTransaction_vtkMaterialInterfacePieceTransaction_s3(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "vtkMaterialInterfacePieceTransaction");
  return nullptr;
}


static const char *PyvtkMaterialInterfacePieceTransaction_Doc =

  "vtkMaterialInterfacePieceTransaction()\n    -> vtkMaterialInterfacePieceTransaction\nC++: vtkMaterialInterfacePieceTransaction()\nvtkMaterialInterfacePieceTransaction(type:str, remoteProc:int)\n    -> vtkMaterialInterfacePieceTransaction\nC++: vtkMaterialInterfacePieceTransaction(char type, int remoteProc)\nvtkMaterialInterfacePieceTransaction(\n    __a:vtkMaterialInterfacePieceTransaction)\n    -> vtkMaterialInterfacePieceTransaction\nC++: vtkMaterialInterfacePieceTransaction(\n    const &vtkMaterialInterfacePieceTransaction)\n""\n"
  "vtkMaterialInterfacePieceTransaction - Helper to the transaction\nmatrix.\n\n"
  "Data structure that describes a single transaction that needs to be\n"
  "executed in the process of moving a fragment piece around.\n\n"
  "The fragment to be transacted and the executing process are\n"
  "determined implicitly by where the transaction is stored.\n\n";

static PyObject *
PyvtkMaterialInterfacePieceTransaction_New(PyTypeObject *, PyObject *args, PyObject *kwds)
{
  if (kwds && PyDict_Size(kwds))
  {
    PyErr_SetString(PyExc_TypeError,
                    "this function takes no keyword arguments");
    return nullptr;
  }

  return PyvtkMaterialInterfacePieceTransaction_vtkMaterialInterfacePieceTransaction(nullptr, args);
}

static void PyvtkMaterialInterfacePieceTransaction_Delete(PyObject *self)
{
  PyVTKSpecialObject *obj = (PyVTKSpecialObject *)self;
  delete static_cast<vtkMaterialInterfacePieceTransaction *>(obj->vtk_ptr);
  PyObject_Del(self);
}

static PyObject *PyvtkMaterialInterfacePieceTransaction_String(PyObject *self)
{
  PyVTKSpecialObject *obj = (PyVTKSpecialObject *)self;
  std::ostringstream os;
  if (obj->vtk_ptr)
  {
    os << *static_cast<const vtkMaterialInterfacePieceTransaction *>(obj->vtk_ptr);
  }
  const std::string &s = os.str();
  return PyUnicode_FromStringAndSize(s.data(), s.size());
}

static Py_hash_t PyvtkMaterialInterfacePieceTransaction_Hash(PyObject *self)
{
  return PyObject_HashNotImplemented(self);
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkMaterialInterfacePieceTransaction_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersMaterialInterface.vtkMaterialInterfacePieceTransaction", // tp_name
  sizeof(PyVTKSpecialObject), // tp_basicsize
  0, // tp_itemsize
  PyvtkMaterialInterfacePieceTransaction_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKSpecialObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  PyvtkMaterialInterfacePieceTransaction_Hash, // tp_hash
  nullptr, // tp_call
  PyvtkMaterialInterfacePieceTransaction_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT, // tp_flags
  PyvtkMaterialInterfacePieceTransaction_Doc, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  PyvtkMaterialInterfacePieceTransaction_New, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static void *PyvtkMaterialInterfacePieceTransaction_CCopy(const void *obj)
{
  if (obj)
  {
    return new vtkMaterialInterfacePieceTransaction(*static_cast<const vtkMaterialInterfacePieceTransaction*>(obj));
  }
  return nullptr;
}

#ifndef DECLARED_PyvtkMaterialInterfacePieceTransaction_TypeNew
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkMaterialInterfacePieceTransaction_TypeNew(); }
#define DECLARED_PyvtkMaterialInterfacePieceTransaction_TypeNew
#endif

PyObject *PyvtkMaterialInterfacePieceTransaction_TypeNew()
{
  PyTypeObject *pytype = PyVTKSpecialType_Add(
    &PyvtkMaterialInterfacePieceTransaction_Type,
    PyvtkMaterialInterfacePieceTransaction_Methods,
    PyvtkMaterialInterfacePieceTransaction_GetSets,
    PyvtkMaterialInterfacePieceTransaction_vtkMaterialInterfacePieceTransaction_Methods,
    &PyvtkMaterialInterfacePieceTransaction_CCopy);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  for (int c = 0; c < 3; c++)
  {
    static const struct { const char *name; int value; }
      constants[3] = {
        { "TYPE", vtkMaterialInterfacePieceTransaction::TYPE },
        { "REMOTE_PROC", vtkMaterialInterfacePieceTransaction::REMOTE_PROC },
        { "SIZE", vtkMaterialInterfacePieceTransaction::SIZE },
      };

    o = PyLong_FromLong(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkMaterialInterfacePieceTransaction(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkMaterialInterfacePieceTransaction_TypeNew();

  if (o && PyDict_SetItemString(dict, "vtkMaterialInterfacePieceTransaction", o) != 0)
  {
    Py_DECREF(o);
  }

}

