// python wrapper for vtkPVPluginTracker
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVPluginTracker.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVPluginTracker(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVPluginTracker_ClassNew(); }


static PyObject *
PyvtkPVPluginTracker_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVPluginTracker::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginTracker_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginTracker *op = static_cast<vtkPVPluginTracker *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVPluginTracker::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginTracker_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVPluginTracker *tempr = vtkPVPluginTracker::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginTracker_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginTracker *op = static_cast<vtkPVPluginTracker *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVPluginTracker *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVPluginTracker::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginTracker_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVPluginTracker::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginTracker_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginTracker *op = static_cast<vtkPVPluginTracker *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVPluginTracker::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginTracker_GetInstance(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetInstance");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkPVPluginTracker *tempr = vtkPVPluginTracker::GetInstance();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginTracker_RegisterAvailablePlugin(PyObject *self, PyObject *args)
{
  PyErr_WarnEx(PyExc_DeprecationWarning,
    "Call to deprecated method RegisterAvailablePlugin."
    " (" "Use LoadPluginConfigurationXML instead." ")"
    " -- Deprecated since version " "6.0.0" ".", 1);

  vtkPythonArgs ap(self, args, "RegisterAvailablePlugin");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginTracker *op = static_cast<vtkPVPluginTracker *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->RegisterAvailablePlugin(temp0) :
      op->vtkPVPluginTracker::RegisterAvailablePlugin(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginTracker_LoadPluginConfigurationXMLs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadPluginConfigurationXMLs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginTracker *op = static_cast<vtkPVPluginTracker *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->LoadPluginConfigurationXMLs(temp0);
    }
    else
    {
      op->vtkPVPluginTracker::LoadPluginConfigurationXMLs(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginTracker_LoadPluginConfigurationXML_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadPluginConfigurationXML");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginTracker *op = static_cast<vtkPVPluginTracker *>(vp);

  const char *temp0 = nullptr;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetValue(temp0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    if (ap.IsBound())
    {
      op->LoadPluginConfigurationXML(temp0, temp1);
    }
    else
    {
      op->vtkPVPluginTracker::LoadPluginConfigurationXML(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVPluginTracker_LoadPluginConfigurationXML_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadPluginConfigurationXML");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginTracker *op = static_cast<vtkPVPluginTracker *>(vp);

  vtkPVXMLElement *temp0 = nullptr;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetVTKObject(temp0, "vtkPVXMLElement") &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    if (ap.IsBound())
    {
      op->LoadPluginConfigurationXML(temp0, temp1);
    }
    else
    {
      op->vtkPVPluginTracker::LoadPluginConfigurationXML(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVPluginTracker_LoadPluginConfigurationXML_Methods[] = {
  {"LoadPluginConfigurationXML", PyvtkPVPluginTracker_LoadPluginConfigurationXML_s1, METH_VARARGS,
   "@z|q"},
  {"LoadPluginConfigurationXML", PyvtkPVPluginTracker_LoadPluginConfigurationXML_s2, METH_VARARGS,
   "@V|q *vtkPVXMLElement"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkPVPluginTracker_LoadPluginConfigurationXML(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkPVPluginTracker_LoadPluginConfigurationXML_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
    case 2:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "LoadPluginConfigurationXML");
  return nullptr;
}


static PyObject *
PyvtkPVPluginTracker_LoadPluginConfigurationXMLFromString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadPluginConfigurationXMLFromString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginTracker *op = static_cast<vtkPVPluginTracker *>(vp);

  const char *temp0 = nullptr;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetValue(temp0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    if (ap.IsBound())
    {
      op->LoadPluginConfigurationXMLFromString(temp0, temp1);
    }
    else
    {
      op->vtkPVPluginTracker::LoadPluginConfigurationXMLFromString(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginTracker_GetNumberOfPlugins(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfPlugins");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginTracker *op = static_cast<vtkPVPluginTracker *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetNumberOfPlugins() :
      op->vtkPVPluginTracker::GetNumberOfPlugins());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginTracker_GetPluginName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPluginName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginTracker *op = static_cast<vtkPVPluginTracker *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetPluginName(temp0) :
      op->vtkPVPluginTracker::GetPluginName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginTracker_GetPluginFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPluginFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginTracker *op = static_cast<vtkPVPluginTracker *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetPluginFileName(temp0) :
      op->vtkPVPluginTracker::GetPluginFileName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginTracker_GetPluginLoaded(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPluginLoaded");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginTracker *op = static_cast<vtkPVPluginTracker *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetPluginLoaded(temp0) :
      op->vtkPVPluginTracker::GetPluginLoaded(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginTracker_GetPluginAutoLoad(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPluginAutoLoad");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginTracker *op = static_cast<vtkPVPluginTracker *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetPluginAutoLoad(temp0) :
      op->vtkPVPluginTracker::GetPluginAutoLoad(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginTracker_GetPluginDelayedLoad(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPluginDelayedLoad");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginTracker *op = static_cast<vtkPVPluginTracker *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetPluginDelayedLoad(temp0) :
      op->vtkPVPluginTracker::GetPluginDelayedLoad(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginTracker_GetPluginXMLs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPluginXMLs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginTracker *op = static_cast<vtkPVPluginTracker *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    std::vector<std::string> tempr = (ap.IsBound() ?
      op->GetPluginXMLs(temp0) :
      op->vtkPVPluginTracker::GetPluginXMLs(temp0));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginTracker_GetPluginVersion(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPluginVersion");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginTracker *op = static_cast<vtkPVPluginTracker *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetPluginVersion(temp0) :
      op->vtkPVPluginTracker::GetPluginVersion(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginTracker_GetPluginDescription(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPluginDescription");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginTracker *op = static_cast<vtkPVPluginTracker *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetPluginDescription(temp0) :
      op->vtkPVPluginTracker::GetPluginDescription(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVPluginTracker_Methods[] = {
  {"IsTypeOf", PyvtkPVPluginTracker_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVPluginTracker_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVPluginTracker_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVPluginTracker\nC++: static vtkPVPluginTracker *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVPluginTracker_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVPluginTracker\nC++: vtkPVPluginTracker *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVPluginTracker_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVPluginTracker_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetInstance", PyvtkPVPluginTracker_GetInstance, METH_VARARGS,
   "GetInstance() -> vtkPVPluginTracker\nC++: static vtkPVPluginTracker *GetInstance()\n\nProvides access to the singleton. This will create the\nvtkPVPluginTracker singleton the first time this method is\ncalled.\n"},
  {"RegisterAvailablePlugin", PyvtkPVPluginTracker_RegisterAvailablePlugin, METH_VARARGS,
   "RegisterAvailablePlugin(self, filename:str) -> int\nC++: unsigned int RegisterAvailablePlugin(const char *filename)\n\nThis API is used to register available plugins without actually\nloading them.\n\nThis fires `vtkPVPluginTracker::RegisterAvailablePluginEvent` to\nnotify a new plugin has been made available.\n"},
  {"LoadPluginConfigurationXMLs", PyvtkPVPluginTracker_LoadPluginConfigurationXMLs, METH_VARARGS,
   "LoadPluginConfigurationXMLs(self, appname:str) -> None\nC++: void LoadPluginConfigurationXMLs(const char *appname)\n\nCalled to load application-specific configuration xml. The xml is\nof the form:<Plugins>\n<Plugin name=\"[plugin name]\" filename=\"[optional file name]\"\nauto_load=\"[bool]\" />\n...\n\nThis method will process the XML, locate the plugin shared\nlibrary, register it with all its properties and then load it or\nnot based on the status of the auto_load flag. auto_load flag is\noptional and is 0 by default. filename is also optional, if not\nprovided this method will look in different place to find the\nplugin, eg. paraview lib dir. It will NOT look in PV_PLUGIN_PATH.\n"},
  {"LoadPluginConfigurationXML", PyvtkPVPluginTracker_LoadPluginConfigurationXML, METH_VARARGS,
   "LoadPluginConfigurationXML(self, filename:str,\n    forceLoad:bool=False) -> None\nC++: void LoadPluginConfigurationXML(const char *filename,\n    bool forceLoad=false)\nLoadPluginConfigurationXML(self, __a:vtkPVXMLElement,\n    forceLoad:bool=False) -> None\nC++: void LoadPluginConfigurationXML(vtkPVXMLElement *,\n    bool forceLoad=false)\n\n"},
  {"LoadPluginConfigurationXMLFromString", PyvtkPVPluginTracker_LoadPluginConfigurationXMLFromString, METH_VARARGS,
   "LoadPluginConfigurationXMLFromString(self, xmlcontents:str,\n    forceLoad:bool=False) -> None\nC++: void LoadPluginConfigurationXMLFromString(\n    const char *xmlcontents, bool forceLoad=false)\n\n"},
  {"GetNumberOfPlugins", PyvtkPVPluginTracker_GetNumberOfPlugins, METH_VARARGS,
   "GetNumberOfPlugins(self) -> int\nC++: unsigned int GetNumberOfPlugins()\n\nMethods to iterate over registered plugins.\n"},
  {"GetPluginName", PyvtkPVPluginTracker_GetPluginName, METH_VARARGS,
   "GetPluginName(self, index:int) -> str\nC++: const char *GetPluginName(unsigned int index)\n\nThis is provided for wrapped languages since they can't directly\naccess the vtkPVPlugin instance. This is also used by\nvtkPluginsInformation to copy plugins information.\n"},
  {"GetPluginFileName", PyvtkPVPluginTracker_GetPluginFileName, METH_VARARGS,
   "GetPluginFileName(self, index:int) -> str\nC++: const char *GetPluginFileName(unsigned int index)\n\n"},
  {"GetPluginLoaded", PyvtkPVPluginTracker_GetPluginLoaded, METH_VARARGS,
   "GetPluginLoaded(self, index:int) -> bool\nC++: bool GetPluginLoaded(unsigned int index)\n\n"},
  {"GetPluginAutoLoad", PyvtkPVPluginTracker_GetPluginAutoLoad, METH_VARARGS,
   "GetPluginAutoLoad(self, index:int) -> bool\nC++: bool GetPluginAutoLoad(unsigned int index)\n\n"},
  {"GetPluginDelayedLoad", PyvtkPVPluginTracker_GetPluginDelayedLoad, METH_VARARGS,
   "GetPluginDelayedLoad(self, index:int) -> bool\nC++: bool GetPluginDelayedLoad(unsigned int index)\n\n"},
  {"GetPluginXMLs", PyvtkPVPluginTracker_GetPluginXMLs, METH_VARARGS,
   "GetPluginXMLs(self, index:int) -> (str, ...)\nC++: std::vector<std::string> GetPluginXMLs(unsigned int index)\n\n"},
  {"GetPluginVersion", PyvtkPVPluginTracker_GetPluginVersion, METH_VARARGS,
   "GetPluginVersion(self, index:int) -> str\nC++: std::string GetPluginVersion(unsigned int index)\n\n"},
  {"GetPluginDescription", PyvtkPVPluginTracker_GetPluginDescription, METH_VARARGS,
   "GetPluginDescription(self, index:int) -> str\nC++: std::string GetPluginDescription(unsigned int index)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVPluginTracker_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("instance"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPluginTracker_GetInstance(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetInstance\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_plugins"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPluginTracker_GetNumberOfPlugins(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfPlugins\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVPluginTracker_Doc =
  "vtkPVPluginTracker - a global manager for each processes to keep\ntrack of plugins loaded on that process.\n\n"
  "Superclass: vtkObject\n\n"
  "vtkPVPluginTracker is a singleton that's present on each process to\n"
  "keep track of plugins loaded on that process. Whenever is plugin is\n"
  "loaded (either statically using PV_PLUGIN_IMPORT() or dynamically, it\n"
  "gets registered with the  on every process that it is loaded.\n"
  "Whenever a plugin is registered, this class fires a\n"
  "vtkCommand::RegisterEvent that handlers can listen to, to process the\n"
  "plugin.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVPluginTracker_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkPVPluginTracker", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVPluginTracker_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVPluginTracker_StaticNew()
{
  return vtkPVPluginTracker::New();
}

PyObject *PyvtkPVPluginTracker_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVPluginTracker_Type, PyvtkPVPluginTracker_Methods,
    "vtkPVPluginTracker",
 &PyvtkPVPluginTracker_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  o = PyLong_FromLong(vtkPVPluginTracker::RegisterAvailablePluginEvent);
  if (o)
  {
    PyDict_SetItemString(d, "RegisterAvailablePluginEvent", o);
    Py_DECREF(o);
  }
  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVPluginTracker_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVPluginTracker(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVPluginTracker_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVPluginTracker", o) != 0)
  {
    Py_DECREF(o);
  }

}

