// python wrapper for vtkPVPythonModule
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVPythonModule.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVPythonModule(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVPythonModule_ClassNew(); }


static PyObject *
PyvtkPVPythonModule_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVPythonModule::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonModule_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonModule *op = static_cast<vtkPVPythonModule *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVPythonModule::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonModule_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVPythonModule *tempr = vtkPVPythonModule::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonModule_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonModule *op = static_cast<vtkPVPythonModule *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVPythonModule *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVPythonModule::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonModule_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVPythonModule::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonModule_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonModule *op = static_cast<vtkPVPythonModule *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVPythonModule::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonModule_GetSource(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSource");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonModule *op = static_cast<vtkPVPythonModule *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetSource() :
      op->vtkPVPythonModule::GetSource());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonModule_SetSource(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSource");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonModule *op = static_cast<vtkPVPythonModule *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSource(temp0);
    }
    else
    {
      op->vtkPVPythonModule::SetSource(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonModule_GetFullName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFullName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonModule *op = static_cast<vtkPVPythonModule *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetFullName() :
      op->vtkPVPythonModule::GetFullName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonModule_SetFullName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFullName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonModule *op = static_cast<vtkPVPythonModule *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFullName(temp0);
    }
    else
    {
      op->vtkPVPythonModule::SetFullName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonModule_GetIsPackage(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIsPackage");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonModule *op = static_cast<vtkPVPythonModule *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetIsPackage() :
      op->vtkPVPythonModule::GetIsPackage());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonModule_SetIsPackage(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetIsPackage");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonModule *op = static_cast<vtkPVPythonModule *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetIsPackage(temp0);
    }
    else
    {
      op->vtkPVPythonModule::SetIsPackage(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonModule_IsPackageOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsPackageOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonModule *op = static_cast<vtkPVPythonModule *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->IsPackageOn();
    }
    else
    {
      op->vtkPVPythonModule::IsPackageOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonModule_IsPackageOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsPackageOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonModule *op = static_cast<vtkPVPythonModule *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->IsPackageOff();
    }
    else
    {
      op->vtkPVPythonModule::IsPackageOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonModule_RegisterModule(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RegisterModule");

  vtkPVPythonModule *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVPythonModule"))
  {
    vtkPVPythonModule::RegisterModule(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonModule_GetModule(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetModule");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkPVPythonModule *tempr = vtkPVPythonModule::GetModule(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonModule_HasModule(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "HasModule");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVPythonModule::HasModule(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVPythonModule_Methods[] = {
  {"IsTypeOf", PyvtkPVPythonModule_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVPythonModule_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVPythonModule_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVPythonModule\nC++: static vtkPVPythonModule *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVPythonModule_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVPythonModule\nC++: vtkPVPythonModule *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVPythonModule_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVPythonModule_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetSource", PyvtkPVPythonModule_GetSource, METH_VARARGS,
   "GetSource(self) -> str\nC++: virtual char *GetSource()\n\nSet/get the full Python source for this module.\n"},
  {"SetSource", PyvtkPVPythonModule_SetSource, METH_VARARGS,
   "SetSource(self, _arg:str) -> None\nC++: virtual void SetSource(const char *_arg)\n\n"},
  {"GetFullName", PyvtkPVPythonModule_GetFullName, METH_VARARGS,
   "GetFullName(self) -> str\nC++: virtual char *GetFullName()\n\nSet/get the full name for this module (e.g.\npackage.subpackage.module).\n"},
  {"SetFullName", PyvtkPVPythonModule_SetFullName, METH_VARARGS,
   "SetFullName(self, _arg:str) -> None\nC++: virtual void SetFullName(const char *_arg)\n\n"},
  {"GetIsPackage", PyvtkPVPythonModule_GetIsPackage, METH_VARARGS,
   "GetIsPackage(self) -> int\nC++: virtual int GetIsPackage()\n\nSet/get a flag indicating whether this module is actually a\npackage (which can have submodules).\n"},
  {"SetIsPackage", PyvtkPVPythonModule_SetIsPackage, METH_VARARGS,
   "SetIsPackage(self, _arg:int) -> None\nC++: virtual void SetIsPackage(int _arg)\n\n"},
  {"IsPackageOn", PyvtkPVPythonModule_IsPackageOn, METH_VARARGS,
   "IsPackageOn(self) -> None\nC++: virtual void IsPackageOn()\n\n"},
  {"IsPackageOff", PyvtkPVPythonModule_IsPackageOff, METH_VARARGS,
   "IsPackageOff(self) -> None\nC++: virtual void IsPackageOff()\n\n"},
  {"RegisterModule", PyvtkPVPythonModule_RegisterModule, METH_VARARGS,
   "RegisterModule(module:vtkPVPythonModule) -> None\nC++: static void RegisterModule(vtkPVPythonModule *module)\n\nRegister the Python module.  Once registered, the module can be\nretrieved with GetModule and HaveModule.  Python interpreters can\nquery these global methods in a custom import mechanism.\n"},
  {"GetModule", PyvtkPVPythonModule_GetModule, METH_VARARGS,
   "GetModule(fullname:str) -> vtkPVPythonModule\nC++: static vtkPVPythonModule *GetModule(const char *fullname)\n\nReturn the registered Python module with the given full module\nname.  If no such module has been registered, this returns\nnullptr.\n"},
  {"HasModule", PyvtkPVPythonModule_HasModule, METH_VARARGS,
   "HasModule(fullname:str) -> int\nC++: static int HasModule(const char *fullname)\n\nReturns 1 if a Python module with the given full name has been\nregistered, 0 otherwise.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVPythonModule_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("source"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPythonModule_GetSource(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPythonModule_SetSource(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPythonModule_SetSource(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSource/SetSource\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("full_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPythonModule_GetFullName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPythonModule_SetFullName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPythonModule_SetFullName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFullName/SetFullName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("is_package"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPythonModule_GetIsPackage(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPythonModule_SetIsPackage(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPythonModule_SetIsPackage(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetIsPackage/SetIsPackage\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVPythonModule_Doc =
  "vtkPVPythonModule - Stores code and option for python modules\n\n"
  "Superclass: vtkObject\n\n"
  "vtkPVPythonModule is a simple class that stores some Python source\n"
  "code that makes up a Python module as well as some state variables\n"
  "about the module (such as its name).\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVPythonModule_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkPVPythonModule", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVPythonModule_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVPythonModule_StaticNew()
{
  return vtkPVPythonModule::New();
}

PyObject *PyvtkPVPythonModule_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVPythonModule_Type, PyvtkPVPythonModule_Methods,
    "vtkPVPythonModule",
 &PyvtkPVPythonModule_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVPythonModule_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVPythonModule(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVPythonModule_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVPythonModule", o) != 0)
  {
    Py_DECREF(o);
  }

}

