/* Generated by wayland-scanner 1.24.0 */

#ifndef PHOC_DEVICE_STATE_UNSTABLE_V1_SERVER_PROTOCOL_H
#define PHOC_DEVICE_STATE_UNSTABLE_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_phoc_device_state_unstable_v1 The phoc_device_state_unstable_v1 protocol
 * @section page_ifaces_phoc_device_state_unstable_v1 Interfaces
 * - @subpage page_iface_zphoc_device_state_v1 - Device state information
 * - @subpage page_iface_zphoc_tablet_mode_switch_v1 - A tablet mode switch
 * - @subpage page_iface_zphoc_lid_switch_v1 - A tablet mode switch
 * @section page_copyright_phoc_device_state_unstable_v1 Copyright
 * <pre>
 *
 * Copyright © 2023 Guido Günther
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct zphoc_device_state_v1;
struct zphoc_lid_switch_v1;
struct zphoc_tablet_mode_switch_v1;

#ifndef ZPHOC_DEVICE_STATE_V1_INTERFACE
#define ZPHOC_DEVICE_STATE_V1_INTERFACE
/**
 * @page page_iface_zphoc_device_state_v1 zphoc_device_state_v1
 * @section page_iface_zphoc_device_state_v1_desc Description
 *
 * Phones, tablets, convertibles, laptops can have additional hardware attached or switch
 * their operation mode from e.g. tablet to laptop. This protocol is meant to provide information
 * about these changes to interested clients.
 *
 * Warning! The protocol described in this file is experimental and
 * backward incompatible changes may be made. Backward compatible changes
 * may be added together with the corresponding interface version bump.
 * Backward incompatible changes are done by bumping the version number in
 * the protocol and interface names and resetting the interface version.
 * Once the protocol is to be declared stable, the 'z' prefix and the
 * version number in the protocol and interface names are removed and the
 * interface version number is reset.
 *
 * This protocol is meant to collect necessary bits before we propose an
 * upstream solution.
 * @section page_iface_zphoc_device_state_v1_api API
 * See @ref iface_zphoc_device_state_v1.
 */
/**
 * @defgroup iface_zphoc_device_state_v1 The zphoc_device_state_v1 interface
 *
 * Phones, tablets, convertibles, laptops can have additional hardware attached or switch
 * their operation mode from e.g. tablet to laptop. This protocol is meant to provide information
 * about these changes to interested clients.
 *
 * Warning! The protocol described in this file is experimental and
 * backward incompatible changes may be made. Backward compatible changes
 * may be added together with the corresponding interface version bump.
 * Backward incompatible changes are done by bumping the version number in
 * the protocol and interface names and resetting the interface version.
 * Once the protocol is to be declared stable, the 'z' prefix and the
 * version number in the protocol and interface names are removed and the
 * interface version number is reset.
 *
 * This protocol is meant to collect necessary bits before we propose an
 * upstream solution.
 */
extern const struct wl_interface zphoc_device_state_v1_interface;
#endif
#ifndef ZPHOC_TABLET_MODE_SWITCH_V1_INTERFACE
#define ZPHOC_TABLET_MODE_SWITCH_V1_INTERFACE
/**
 * @page page_iface_zphoc_tablet_mode_switch_v1 zphoc_tablet_mode_switch_v1
 * @section page_iface_zphoc_tablet_mode_switch_v1_desc Description
 *
 * The tablet_mode_switch interface represents a tablet mode switch.
 * It can have two possible values:
 *
 * The wl_pointer interface generates enabled and disabled events to indicate
 * switch state changes
 * @section page_iface_zphoc_tablet_mode_switch_v1_api API
 * See @ref iface_zphoc_tablet_mode_switch_v1.
 */
/**
 * @defgroup iface_zphoc_tablet_mode_switch_v1 The zphoc_tablet_mode_switch_v1 interface
 *
 * The tablet_mode_switch interface represents a tablet mode switch.
 * It can have two possible values:
 *
 * The wl_pointer interface generates enabled and disabled events to indicate
 * switch state changes
 */
extern const struct wl_interface zphoc_tablet_mode_switch_v1_interface;
#endif
#ifndef ZPHOC_LID_SWITCH_V1_INTERFACE
#define ZPHOC_LID_SWITCH_V1_INTERFACE
/**
 * @page page_iface_zphoc_lid_switch_v1 zphoc_lid_switch_v1
 * @section page_iface_zphoc_lid_switch_v1_desc Description
 *
 * The lid_switch interface represents a tablet mode switch.
 * It can have two possible values:
 *
 * The wl_pointer interface generates enabled and disabled events to indicate
 * switch state changes
 * @section page_iface_zphoc_lid_switch_v1_api API
 * See @ref iface_zphoc_lid_switch_v1.
 */
/**
 * @defgroup iface_zphoc_lid_switch_v1 The zphoc_lid_switch_v1 interface
 *
 * The lid_switch interface represents a tablet mode switch.
 * It can have two possible values:
 *
 * The wl_pointer interface generates enabled and disabled events to indicate
 * switch state changes
 */
extern const struct wl_interface zphoc_lid_switch_v1_interface;
#endif

#ifndef ZPHOC_DEVICE_STATE_V1_CAPABILITY_ENUM
#define ZPHOC_DEVICE_STATE_V1_CAPABILITY_ENUM
/**
 * @ingroup iface_zphoc_device_state_v1
 * Device capability bitmask
 *
 * This is a bitmask of capabilities this devices has; if a member is
 * set, then the hardware is present.
 */
enum zphoc_device_state_v1_capability {
	/**
	 * The device has a tablet mode switch
	 */
	ZPHOC_DEVICE_STATE_V1_CAPABILITY_TABLET_MODE_SWITCH = 1,
	/**
	 * The device has a lid switch
	 */
	ZPHOC_DEVICE_STATE_V1_CAPABILITY_LID_SWITCH = 2,
	/**
	 * The device has a hardware keyboard attached
	 * @since 2
	 */
	ZPHOC_DEVICE_STATE_V1_CAPABILITY_KEYBOARD = 4,
};
/**
 * @ingroup iface_zphoc_device_state_v1
 */
#define ZPHOC_DEVICE_STATE_V1_CAPABILITY_KEYBOARD_SINCE_VERSION 2
#endif /* ZPHOC_DEVICE_STATE_V1_CAPABILITY_ENUM */

#ifndef ZPHOC_DEVICE_STATE_V1_CAPABILITY_ENUM_IS_VALID
#define ZPHOC_DEVICE_STATE_V1_CAPABILITY_ENUM_IS_VALID
/**
 * @ingroup iface_zphoc_device_state_v1
 * Validate a zphoc_device_state_v1 capability value.
 *
 * @return true on success, false on error.
 * @ref zphoc_device_state_v1_capability
 */
static inline bool
zphoc_device_state_v1_capability_is_valid(uint32_t value, uint32_t version) {
	uint32_t valid = 0;
	if (version >= 1)
		valid |= ZPHOC_DEVICE_STATE_V1_CAPABILITY_TABLET_MODE_SWITCH;
	if (version >= 1)
		valid |= ZPHOC_DEVICE_STATE_V1_CAPABILITY_LID_SWITCH;
	if (version >= 2)
		valid |= ZPHOC_DEVICE_STATE_V1_CAPABILITY_KEYBOARD;
	return (value & ~valid) == 0;
}
#endif /* ZPHOC_DEVICE_STATE_V1_CAPABILITY_ENUM_IS_VALID */

#ifndef ZPHOC_DEVICE_STATE_V1_ERROR_ENUM
#define ZPHOC_DEVICE_STATE_V1_ERROR_ENUM
/**
 * @ingroup iface_zphoc_device_state_v1
 * zphoc_device_state_v1 error values
 *
 * These errors can be emitted in response to zphoc_device_state_v1 requests.
 */
enum zphoc_device_state_v1_error {
	/**
	 * get_tablet_mode_switch called on device without the matching capability
	 */
	ZPHOC_DEVICE_STATE_V1_ERROR_MISSING_CAPABILITY = 0,
};
#endif /* ZPHOC_DEVICE_STATE_V1_ERROR_ENUM */

#ifndef ZPHOC_DEVICE_STATE_V1_ERROR_ENUM_IS_VALID
#define ZPHOC_DEVICE_STATE_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_zphoc_device_state_v1
 * Validate a zphoc_device_state_v1 error value.
 *
 * @return true on success, false on error.
 * @ref zphoc_device_state_v1_error
 */
static inline bool
zphoc_device_state_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case ZPHOC_DEVICE_STATE_V1_ERROR_MISSING_CAPABILITY:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* ZPHOC_DEVICE_STATE_V1_ERROR_ENUM_IS_VALID */

/**
 * @ingroup iface_zphoc_device_state_v1
 * @struct zphoc_device_state_v1_interface
 */
struct zphoc_device_state_v1_interface {
	/**
	 * return tablet-mode-switch object
	 *
	 * The ID provided will be initialized to the
	 * phoc_tablet_mode_switch interface for this device
	 *
	 * This request only takes effect if the seat has the
	 * tablet-mode-switch capability, or has had the tablet-mode-switch
	 * capability in the past. It is a protocol violation to issue this
	 * request on a seat that has never had the tablet-mode-switch
	 * capability. The missing_capability error will be sent in this
	 * case.
	 * @param id tablet mode switch
	 */
	void (*get_tablet_mode_switch)(struct wl_client *client,
				       struct wl_resource *resource,
				       uint32_t id);
	/**
	 * return tablet-mode-switch object
	 *
	 * The ID provided will be initialized to the phoc_lid_switch
	 * interface for this device
	 *
	 * This request only takes effect if the seat has the lid-switch
	 * capability, or has had the lid-switch capability in the past. It
	 * is a protocol violation to issue this request on a seat that has
	 * never had the tablet-mode-switch capability. The
	 * missing_capability error will be sent in this case.
	 * @param id lid switch
	 */
	void (*get_lid_switch)(struct wl_client *client,
			       struct wl_resource *resource,
			       uint32_t id);
};

#define ZPHOC_DEVICE_STATE_V1_CAPABILITIES 0

/**
 * @ingroup iface_zphoc_device_state_v1
 */
#define ZPHOC_DEVICE_STATE_V1_CAPABILITIES_SINCE_VERSION 1

/**
 * @ingroup iface_zphoc_device_state_v1
 */
#define ZPHOC_DEVICE_STATE_V1_GET_TABLET_MODE_SWITCH_SINCE_VERSION 1
/**
 * @ingroup iface_zphoc_device_state_v1
 */
#define ZPHOC_DEVICE_STATE_V1_GET_LID_SWITCH_SINCE_VERSION 1

/**
 * @ingroup iface_zphoc_device_state_v1
 * Sends an capabilities event to the client owning the resource.
 * @param resource_ The client's resource
 * @param capabilities Hardware capabilities of the device
 */
static inline void
zphoc_device_state_v1_send_capabilities(struct wl_resource *resource_, uint32_t capabilities)
{
	wl_resource_post_event(resource_, ZPHOC_DEVICE_STATE_V1_CAPABILITIES, capabilities);
}

/**
 * @ingroup iface_zphoc_tablet_mode_switch_v1
 * @struct zphoc_tablet_mode_switch_v1_interface
 */
struct zphoc_tablet_mode_switch_v1_interface {
	/**
	 * release the switch object
	 *
	 * Using this request a client can tell the server that it is not
	 * going to use the switch object anymore.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define ZPHOC_TABLET_MODE_SWITCH_V1_DISABLED 0
#define ZPHOC_TABLET_MODE_SWITCH_V1_ENABLED 1

/**
 * @ingroup iface_zphoc_tablet_mode_switch_v1
 */
#define ZPHOC_TABLET_MODE_SWITCH_V1_DISABLED_SINCE_VERSION 1
/**
 * @ingroup iface_zphoc_tablet_mode_switch_v1
 */
#define ZPHOC_TABLET_MODE_SWITCH_V1_ENABLED_SINCE_VERSION 1

/**
 * @ingroup iface_zphoc_tablet_mode_switch_v1
 */
#define ZPHOC_TABLET_MODE_SWITCH_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_zphoc_tablet_mode_switch_v1
 * Sends an disabled event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zphoc_tablet_mode_switch_v1_send_disabled(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZPHOC_TABLET_MODE_SWITCH_V1_DISABLED);
}

/**
 * @ingroup iface_zphoc_tablet_mode_switch_v1
 * Sends an enabled event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zphoc_tablet_mode_switch_v1_send_enabled(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZPHOC_TABLET_MODE_SWITCH_V1_ENABLED);
}

/**
 * @ingroup iface_zphoc_lid_switch_v1
 * @struct zphoc_lid_switch_v1_interface
 */
struct zphoc_lid_switch_v1_interface {
	/**
	 * release the switch object
	 *
	 * Using this request a client can tell the server that it is not
	 * going to use the switch object anymore.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define ZPHOC_LID_SWITCH_V1_OPENED 0
#define ZPHOC_LID_SWITCH_V1_CLOSED 1

/**
 * @ingroup iface_zphoc_lid_switch_v1
 */
#define ZPHOC_LID_SWITCH_V1_OPENED_SINCE_VERSION 1
/**
 * @ingroup iface_zphoc_lid_switch_v1
 */
#define ZPHOC_LID_SWITCH_V1_CLOSED_SINCE_VERSION 1

/**
 * @ingroup iface_zphoc_lid_switch_v1
 */
#define ZPHOC_LID_SWITCH_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_zphoc_lid_switch_v1
 * Sends an opened event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zphoc_lid_switch_v1_send_opened(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZPHOC_LID_SWITCH_V1_OPENED);
}

/**
 * @ingroup iface_zphoc_lid_switch_v1
 * Sends an closed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zphoc_lid_switch_v1_send_closed(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZPHOC_LID_SWITCH_V1_CLOSED);
}

#ifdef  __cplusplus
}
#endif

#endif
