/* Generated by wayland-scanner 1.24.0 */

#ifndef PHOC_LAYER_SURFACE_EFFECTS_UNSTABLE_V1_CLIENT_PROTOCOL_H
#define PHOC_LAYER_SURFACE_EFFECTS_UNSTABLE_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_phoc_layer_surface_effects_unstable_v1 The phoc_layer_surface_effects_unstable_v1 protocol
 * @section page_ifaces_phoc_layer_surface_effects_unstable_v1 Interfaces
 * - @subpage page_iface_zphoc_layer_shell_effects_v1 - Adjust properties of layer surfaces
 * - @subpage page_iface_zphoc_draggable_layer_surface_v1 - Draggable layer surface interface
 * - @subpage page_iface_zphoc_alpha_layer_surface_v1 - 
 * - @subpage page_iface_zphoc_stacked_layer_surface_v1 - 
 * @section page_copyright_phoc_layer_surface_effects_unstable_v1 Copyright
 * <pre>
 *
 * Copyright © 2022-2024 Guido Günther
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct zphoc_alpha_layer_surface_v1;
struct zphoc_draggable_layer_surface_v1;
struct zphoc_layer_shell_effects_v1;
struct zphoc_stacked_layer_surface_v1;
struct zwlr_layer_surface_v1;

#ifndef ZPHOC_LAYER_SHELL_EFFECTS_V1_INTERFACE
#define ZPHOC_LAYER_SHELL_EFFECTS_V1_INTERFACE
/**
 * @page page_iface_zphoc_layer_shell_effects_v1 zphoc_layer_shell_effects_v1
 * @section page_iface_zphoc_layer_shell_effects_v1_desc Description
 *
 * Assigns additional features to layer surfaces such as opacity or gestures interaction.
 *
 * Warning! The protocol described in this file is experimental and
 * backward incompatible changes may be made. Backward compatible changes
 * may be added together with the corresponding interface version bump.
 * Backward incompatible changes are done by bumping the version number in
 * the protocol and interface names and resetting the interface version.
 * Once the protocol is to be declared stable, the 'z' prefix and the
 * version number in the protocol and interface names are removed and the
 * interface version number is reset.
 *
 * This protocol is meant to collect necessary bits before we propose an
 * upstream solution.
 * @section page_iface_zphoc_layer_shell_effects_v1_api API
 * See @ref iface_zphoc_layer_shell_effects_v1.
 */
/**
 * @defgroup iface_zphoc_layer_shell_effects_v1 The zphoc_layer_shell_effects_v1 interface
 *
 * Assigns additional features to layer surfaces such as opacity or gestures interaction.
 *
 * Warning! The protocol described in this file is experimental and
 * backward incompatible changes may be made. Backward compatible changes
 * may be added together with the corresponding interface version bump.
 * Backward incompatible changes are done by bumping the version number in
 * the protocol and interface names and resetting the interface version.
 * Once the protocol is to be declared stable, the 'z' prefix and the
 * version number in the protocol and interface names are removed and the
 * interface version number is reset.
 *
 * This protocol is meant to collect necessary bits before we propose an
 * upstream solution.
 */
extern const struct wl_interface zphoc_layer_shell_effects_v1_interface;
#endif
#ifndef ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_INTERFACE
#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_INTERFACE
/**
 * @page page_iface_zphoc_draggable_layer_surface_v1 zphoc_draggable_layer_surface_v1
 * @section page_iface_zphoc_draggable_layer_surface_v1_desc Description
 *
 * An interface that may be implemented by a layer_surface, for surfaces that
 * are designed to become draggable when anchored at three edges.
 * @section page_iface_zphoc_draggable_layer_surface_v1_api API
 * See @ref iface_zphoc_draggable_layer_surface_v1.
 */
/**
 * @defgroup iface_zphoc_draggable_layer_surface_v1 The zphoc_draggable_layer_surface_v1 interface
 *
 * An interface that may be implemented by a layer_surface, for surfaces that
 * are designed to become draggable when anchored at three edges.
 */
extern const struct wl_interface zphoc_draggable_layer_surface_v1_interface;
#endif
#ifndef ZPHOC_ALPHA_LAYER_SURFACE_V1_INTERFACE
#define ZPHOC_ALPHA_LAYER_SURFACE_V1_INTERFACE
/**
 * @page page_iface_zphoc_alpha_layer_surface_v1 zphoc_alpha_layer_surface_v1
 * @section page_iface_zphoc_alpha_layer_surface_v1_api API
 * See @ref iface_zphoc_alpha_layer_surface_v1.
 */
/**
 * @defgroup iface_zphoc_alpha_layer_surface_v1 The zphoc_alpha_layer_surface_v1 interface
 */
extern const struct wl_interface zphoc_alpha_layer_surface_v1_interface;
#endif
#ifndef ZPHOC_STACKED_LAYER_SURFACE_V1_INTERFACE
#define ZPHOC_STACKED_LAYER_SURFACE_V1_INTERFACE
/**
 * @page page_iface_zphoc_stacked_layer_surface_v1 zphoc_stacked_layer_surface_v1
 * @section page_iface_zphoc_stacked_layer_surface_v1_api API
 * See @ref iface_zphoc_stacked_layer_surface_v1.
 */
/**
 * @defgroup iface_zphoc_stacked_layer_surface_v1 The zphoc_stacked_layer_surface_v1 interface
 */
extern const struct wl_interface zphoc_stacked_layer_surface_v1_interface;
#endif

#ifndef ZPHOC_LAYER_SHELL_EFFECTS_V1_ERROR_ENUM
#define ZPHOC_LAYER_SHELL_EFFECTS_V1_ERROR_ENUM
enum zphoc_layer_shell_effects_v1_error {
	/**
	 * layer surface is not committed
	 */
	ZPHOC_LAYER_SHELL_EFFECTS_V1_ERROR_BAD_SURFACE = 0,
	/**
	 * layer surface is not anchored to 3 edges
	 */
	ZPHOC_LAYER_SHELL_EFFECTS_V1_ERROR_BAD_ANCHORS = 1,
	/**
	 * layer surface has no margin to use
	 */
	ZPHOC_LAYER_SHELL_EFFECTS_V1_ERROR_BAD_MARGIN = 2,
};
#endif /* ZPHOC_LAYER_SHELL_EFFECTS_V1_ERROR_ENUM */

#ifndef ZPHOC_LAYER_SHELL_EFFECTS_V1_STACK_ERROR_ENUM
#define ZPHOC_LAYER_SHELL_EFFECTS_V1_STACK_ERROR_ENUM
enum zphoc_layer_shell_effects_v1_stack_error {
	/**
	 * layer surfaces not in same layer
	 */
	ZPHOC_LAYER_SHELL_EFFECTS_V1_STACK_ERROR_INVALID_LAYER = 0,
	/**
	 * layer surfaces invalid
	 */
	ZPHOC_LAYER_SHELL_EFFECTS_V1_STACK_ERROR_INVALID_SURFACE = 1,
};
#endif /* ZPHOC_LAYER_SHELL_EFFECTS_V1_STACK_ERROR_ENUM */

#define ZPHOC_LAYER_SHELL_EFFECTS_V1_GET_DRAGGABLE_LAYER_SURFACE 0
#define ZPHOC_LAYER_SHELL_EFFECTS_V1_DESTROY 1
#define ZPHOC_LAYER_SHELL_EFFECTS_V1_GET_ALPHA_LAYER_SURFACE 2
#define ZPHOC_LAYER_SHELL_EFFECTS_V1_GET_STACKED_LAYER_SURFACE 3


/**
 * @ingroup iface_zphoc_layer_shell_effects_v1
 */
#define ZPHOC_LAYER_SHELL_EFFECTS_V1_GET_DRAGGABLE_LAYER_SURFACE_SINCE_VERSION 1
/**
 * @ingroup iface_zphoc_layer_shell_effects_v1
 */
#define ZPHOC_LAYER_SHELL_EFFECTS_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_zphoc_layer_shell_effects_v1
 */
#define ZPHOC_LAYER_SHELL_EFFECTS_V1_GET_ALPHA_LAYER_SURFACE_SINCE_VERSION 2
/**
 * @ingroup iface_zphoc_layer_shell_effects_v1
 */
#define ZPHOC_LAYER_SHELL_EFFECTS_V1_GET_STACKED_LAYER_SURFACE_SINCE_VERSION 3

/** @ingroup iface_zphoc_layer_shell_effects_v1 */
static inline void
zphoc_layer_shell_effects_v1_set_user_data(struct zphoc_layer_shell_effects_v1 *zphoc_layer_shell_effects_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zphoc_layer_shell_effects_v1, user_data);
}

/** @ingroup iface_zphoc_layer_shell_effects_v1 */
static inline void *
zphoc_layer_shell_effects_v1_get_user_data(struct zphoc_layer_shell_effects_v1 *zphoc_layer_shell_effects_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zphoc_layer_shell_effects_v1);
}

static inline uint32_t
zphoc_layer_shell_effects_v1_get_version(struct zphoc_layer_shell_effects_v1 *zphoc_layer_shell_effects_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zphoc_layer_shell_effects_v1);
}

/**
 * @ingroup iface_zphoc_layer_shell_effects_v1
 *
 * This marks a layer surface as draggable via one finger drag on touch or click and
 * drag when using a mouse. E.g. a surface that is anchored to the left, right and
 * top can be dragged to the bottom exposing more of it's surface.
 *
 * The state with the minimal amount of surface visible is called
 * folded state, the state with the maximum amount of surface visible is
 * called unfolded state. These two states are defined by the layer
 * surfaces margin in those states. During drag the layer surfaces margin
 * is adjusted to move the surface invalidating the margin set on the
 * zwlr_layer_surface_v1 interface. The default folded and unfolded
 * margins are 0.
 *
 * The threshold ([0.0, 1.0]) specifies how far the user needs to
 * pull out the surface to not slide back into the folded state but
 * rather slide into the unfolded state. The default is 1.0.
 *
 * The client is responsible for adjusting it's margins when it's
 * size changes to e.g. make sure only the wanted parts of the surface
 * are visible in folded state.
 *
 * Note that you shouldn't modify exclusive_zone or margins via
 * zwlr_layer_surface_v1 interface directly when using this one.
 *
 * Margins, threshold and exclusive zone are double buffered and will
 * be applied on the next surface commit.
 */
static inline struct zphoc_draggable_layer_surface_v1 *
zphoc_layer_shell_effects_v1_get_draggable_layer_surface(struct zphoc_layer_shell_effects_v1 *zphoc_layer_shell_effects_v1, struct zwlr_layer_surface_v1 *layer_surface)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) zphoc_layer_shell_effects_v1,
			 ZPHOC_LAYER_SHELL_EFFECTS_V1_GET_DRAGGABLE_LAYER_SURFACE, &zphoc_draggable_layer_surface_v1_interface, wl_proxy_get_version((struct wl_proxy *) zphoc_layer_shell_effects_v1), 0, NULL, layer_surface);

	return (struct zphoc_draggable_layer_surface_v1 *) id;
}

/**
 * @ingroup iface_zphoc_layer_shell_effects_v1
 *
 * This request indicates that the client will not use the layer_shell
 * effects object any more. Objects that have been created through this instance
 * are not affected.
 */
static inline void
zphoc_layer_shell_effects_v1_destroy(struct zphoc_layer_shell_effects_v1 *zphoc_layer_shell_effects_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zphoc_layer_shell_effects_v1,
			 ZPHOC_LAYER_SHELL_EFFECTS_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zphoc_layer_shell_effects_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_zphoc_layer_shell_effects_v1
 */
static inline struct zphoc_alpha_layer_surface_v1 *
zphoc_layer_shell_effects_v1_get_alpha_layer_surface(struct zphoc_layer_shell_effects_v1 *zphoc_layer_shell_effects_v1, struct zwlr_layer_surface_v1 *layer_surface)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) zphoc_layer_shell_effects_v1,
			 ZPHOC_LAYER_SHELL_EFFECTS_V1_GET_ALPHA_LAYER_SURFACE, &zphoc_alpha_layer_surface_v1_interface, wl_proxy_get_version((struct wl_proxy *) zphoc_layer_shell_effects_v1), 0, NULL, layer_surface);

	return (struct zphoc_alpha_layer_surface_v1 *) id;
}

/**
 * @ingroup iface_zphoc_layer_shell_effects_v1
 *
 * Making a layer surface stacked allows to fixate it's position in
 * the layer surface stack.
 */
static inline struct zphoc_stacked_layer_surface_v1 *
zphoc_layer_shell_effects_v1_get_stacked_layer_surface(struct zphoc_layer_shell_effects_v1 *zphoc_layer_shell_effects_v1, struct zwlr_layer_surface_v1 *surface)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) zphoc_layer_shell_effects_v1,
			 ZPHOC_LAYER_SHELL_EFFECTS_V1_GET_STACKED_LAYER_SURFACE, &zphoc_stacked_layer_surface_v1_interface, wl_proxy_get_version((struct wl_proxy *) zphoc_layer_shell_effects_v1), 0, NULL, surface);

	return (struct zphoc_stacked_layer_surface_v1 *) id;
}

#ifndef ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAG_END_STATE_ENUM
#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAG_END_STATE_ENUM
enum zphoc_draggable_layer_surface_v1_drag_end_state {
	/**
	 * The surface is folded
	 */
	ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAG_END_STATE_FOLDED = 0,
	/**
	 * The surface is unfolded
	 */
	ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAG_END_STATE_UNFOLDED = 1,
};
#endif /* ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAG_END_STATE_ENUM */

#ifndef ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAG_MODE_ENUM
#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAG_MODE_ENUM
enum zphoc_draggable_layer_surface_v1_drag_mode {
	/**
	 * The whole surface is draggable
	 */
	ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAG_MODE_FULL = 0,
	/**
	 * Only the handle is draggable
	 */
	ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAG_MODE_HANDLE = 1,
	/**
	 * Surface not draggable
	 */
	ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAG_MODE_NONE = 2,
};
#endif /* ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAG_MODE_ENUM */

/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 * @struct zphoc_draggable_layer_surface_v1_listener
 */
struct zphoc_draggable_layer_surface_v1_listener {
	/**
	 * A drag is ongoing
	 *
	 * The is draging the surface.
	 *
	 * TODO: indicate drag (by user) vs slide (by compositor)
	 * @param margin The current margin
	 */
	void (*dragged)(void *data,
			struct zphoc_draggable_layer_surface_v1 *zphoc_draggable_layer_surface_v1,
			int32_t margin);
	/**
	 * A drag ended
	 *
	 * The user ended dragging the surface and it entered either
	 * folded or unfolded state.
	 * @param state The state
	 */
	void (*drag_end)(void *data,
			 struct zphoc_draggable_layer_surface_v1 *zphoc_draggable_layer_surface_v1,
			 uint32_t state);
};

/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 */
static inline int
zphoc_draggable_layer_surface_v1_add_listener(struct zphoc_draggable_layer_surface_v1 *zphoc_draggable_layer_surface_v1,
					      const struct zphoc_draggable_layer_surface_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zphoc_draggable_layer_surface_v1,
				     (void (**)(void)) listener, data);
}

#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_SET_MARGINS 0
#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_SET_THRESHOLD 1
#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_SET_EXCLUSIVE 2
#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_SET_DRAG_MODE 3
#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_SET_DRAG_HANDLE 4
#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_SET_STATE 5
#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DESTROY 6

/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 */
#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAGGED_SINCE_VERSION 1
/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 */
#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAG_END_SINCE_VERSION 1

/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 */
#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_SET_MARGINS_SINCE_VERSION 1
/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 */
#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_SET_THRESHOLD_SINCE_VERSION 1
/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 */
#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_SET_EXCLUSIVE_SINCE_VERSION 1
/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 */
#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_SET_DRAG_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 */
#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_SET_DRAG_HANDLE_SINCE_VERSION 1
/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 */
#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_SET_STATE_SINCE_VERSION 1
/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 */
#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_zphoc_draggable_layer_surface_v1 */
static inline void
zphoc_draggable_layer_surface_v1_set_user_data(struct zphoc_draggable_layer_surface_v1 *zphoc_draggable_layer_surface_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zphoc_draggable_layer_surface_v1, user_data);
}

/** @ingroup iface_zphoc_draggable_layer_surface_v1 */
static inline void *
zphoc_draggable_layer_surface_v1_get_user_data(struct zphoc_draggable_layer_surface_v1 *zphoc_draggable_layer_surface_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zphoc_draggable_layer_surface_v1);
}

static inline uint32_t
zphoc_draggable_layer_surface_v1_get_version(struct zphoc_draggable_layer_surface_v1 *zphoc_draggable_layer_surface_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zphoc_draggable_layer_surface_v1);
}

/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 *
 * Sets the folded and unfolded margins. For how they are defined
 * refer to margins in the layer-surface protocol.
 *
 * Margins are double-buffered, see wl_surface.commit.
 */
static inline void
zphoc_draggable_layer_surface_v1_set_margins(struct zphoc_draggable_layer_surface_v1 *zphoc_draggable_layer_surface_v1, int32_t margin_folded, int32_t margin_unfolded)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zphoc_draggable_layer_surface_v1,
			 ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_SET_MARGINS, NULL, wl_proxy_get_version((struct wl_proxy *) zphoc_draggable_layer_surface_v1), 0, margin_folded, margin_unfolded);
}

/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 *
 * How far the surface needs to be pulled to go from folded to unfolded state
 * and vice versa. Ranges  0.0 to 1.0 as fraction of the total margin
 * between folded and unfolded state.
 *
 * Threshold is double-buffered, see wl_surface.commit.
 */
static inline void
zphoc_draggable_layer_surface_v1_set_threshold(struct zphoc_draggable_layer_surface_v1 *zphoc_draggable_layer_surface_v1, wl_fixed_t threshold)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zphoc_draggable_layer_surface_v1,
			 ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_SET_THRESHOLD, NULL, wl_proxy_get_version((struct wl_proxy *) zphoc_draggable_layer_surface_v1), 0, threshold);
}

/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 *
 * Sets the exclusive zone. This is the amount of pixels from the screen
 * edge that shouldn't be occluded by other surfaces.
 *
 * Exclusive zone is double-buffered, see wl_surface.commit.
 */
static inline void
zphoc_draggable_layer_surface_v1_set_exclusive(struct zphoc_draggable_layer_surface_v1 *zphoc_draggable_layer_surface_v1, uint32_t exclusive)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zphoc_draggable_layer_surface_v1,
			 ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_SET_EXCLUSIVE, NULL, wl_proxy_get_version((struct wl_proxy *) zphoc_draggable_layer_surface_v1), 0, exclusive);
}

/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 *
 * Specify how the surface can be dragged. The default is
 * "full".
 *
 * Drag-mode is double-buffered, see wl_surface.commit.
 */
static inline void
zphoc_draggable_layer_surface_v1_set_drag_mode(struct zphoc_draggable_layer_surface_v1 *zphoc_draggable_layer_surface_v1, uint32_t mode)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zphoc_draggable_layer_surface_v1,
			 ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_SET_DRAG_MODE, NULL, wl_proxy_get_version((struct wl_proxy *) zphoc_draggable_layer_surface_v1), 0, mode);
}

/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 *
 * Specify the position of the drag handle and thus the area that responds
 * to drag gestures.
 *
 * If the surface's non anchored edge is at the left or right it specifies
 * the x, otherwise the y coordinate of the drag handle in surface local
 * coordinates. The area between the non anchored surface edge and the
 * drag handle responds to drag gestures.
 *
 * 0  +-----------------+
 * 1  |                 |
 * 2  |        A        |
 * 3  |                 |
 * 4  +++++++++++++++++++  -- drag handle
 * 5  |                 |
 * 6  |                 |
 * 7  |        B        |
 * 8  |                 |
 * 9  +-----------------+
 *
 * If the above surface's non anchored edge is at the bottom then a drag handle
 * of 4 will make area B respond to touch events. If the non anchored edge is at
 * the top the same value makes area A respond to touch events.
 *
 * A special value of 0 indicates that the whole surface should be draggable.
 *
 * The default is 0.
 *
 * Drag-handle is double-buffered, see wl_surface.commit.
 */
static inline void
zphoc_draggable_layer_surface_v1_set_drag_handle(struct zphoc_draggable_layer_surface_v1 *zphoc_draggable_layer_surface_v1, uint32_t handle)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zphoc_draggable_layer_surface_v1,
			 ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_SET_DRAG_HANDLE, NULL, wl_proxy_get_version((struct wl_proxy *) zphoc_draggable_layer_surface_v1), 0, handle);
}

/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 *
 * Set state to folded or unfolded. This is applied immediately.
 */
static inline void
zphoc_draggable_layer_surface_v1_set_state(struct zphoc_draggable_layer_surface_v1 *zphoc_draggable_layer_surface_v1, uint32_t state)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zphoc_draggable_layer_surface_v1,
			 ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_SET_STATE, NULL, wl_proxy_get_version((struct wl_proxy *) zphoc_draggable_layer_surface_v1), 0, state);
}

/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 *
 * This request destroys the draggable layer surface.
 *
 * It's a protocol error if the client destroys the layer-surface before
 * the draggable layer-surface.
 */
static inline void
zphoc_draggable_layer_surface_v1_destroy(struct zphoc_draggable_layer_surface_v1 *zphoc_draggable_layer_surface_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zphoc_draggable_layer_surface_v1,
			 ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zphoc_draggable_layer_surface_v1), WL_MARSHAL_FLAG_DESTROY);
}

#define ZPHOC_ALPHA_LAYER_SURFACE_V1_SET_ALPHA 0
#define ZPHOC_ALPHA_LAYER_SURFACE_V1_DESTROY 1


/**
 * @ingroup iface_zphoc_alpha_layer_surface_v1
 */
#define ZPHOC_ALPHA_LAYER_SURFACE_V1_SET_ALPHA_SINCE_VERSION 1
/**
 * @ingroup iface_zphoc_alpha_layer_surface_v1
 */
#define ZPHOC_ALPHA_LAYER_SURFACE_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_zphoc_alpha_layer_surface_v1 */
static inline void
zphoc_alpha_layer_surface_v1_set_user_data(struct zphoc_alpha_layer_surface_v1 *zphoc_alpha_layer_surface_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zphoc_alpha_layer_surface_v1, user_data);
}

/** @ingroup iface_zphoc_alpha_layer_surface_v1 */
static inline void *
zphoc_alpha_layer_surface_v1_get_user_data(struct zphoc_alpha_layer_surface_v1 *zphoc_alpha_layer_surface_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zphoc_alpha_layer_surface_v1);
}

static inline uint32_t
zphoc_alpha_layer_surface_v1_get_version(struct zphoc_alpha_layer_surface_v1 *zphoc_alpha_layer_surface_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zphoc_alpha_layer_surface_v1);
}

/**
 * @ingroup iface_zphoc_alpha_layer_surface_v1
 *
 * Set the surface's transparency. Valid values are between 0.0
 * (fully transparent) and 1.0 (fully opaque). The set value
 * also affects subsurfaces and popups.
 *
 * Alpha is double-buffered, see wl_surface.commit.
 */
static inline void
zphoc_alpha_layer_surface_v1_set_alpha(struct zphoc_alpha_layer_surface_v1 *zphoc_alpha_layer_surface_v1, wl_fixed_t alpha)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zphoc_alpha_layer_surface_v1,
			 ZPHOC_ALPHA_LAYER_SURFACE_V1_SET_ALPHA, NULL, wl_proxy_get_version((struct wl_proxy *) zphoc_alpha_layer_surface_v1), 0, alpha);
}

/**
 * @ingroup iface_zphoc_alpha_layer_surface_v1
 *
 * This request destroys the alpha layer surface.
 */
static inline void
zphoc_alpha_layer_surface_v1_destroy(struct zphoc_alpha_layer_surface_v1 *zphoc_alpha_layer_surface_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zphoc_alpha_layer_surface_v1,
			 ZPHOC_ALPHA_LAYER_SURFACE_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zphoc_alpha_layer_surface_v1), WL_MARSHAL_FLAG_DESTROY);
}

#define ZPHOC_STACKED_LAYER_SURFACE_V1_STACK_BELOW 0
#define ZPHOC_STACKED_LAYER_SURFACE_V1_STACK_ABOVE 1
#define ZPHOC_STACKED_LAYER_SURFACE_V1_DESTROY 2


/**
 * @ingroup iface_zphoc_stacked_layer_surface_v1
 */
#define ZPHOC_STACKED_LAYER_SURFACE_V1_STACK_BELOW_SINCE_VERSION 1
/**
 * @ingroup iface_zphoc_stacked_layer_surface_v1
 */
#define ZPHOC_STACKED_LAYER_SURFACE_V1_STACK_ABOVE_SINCE_VERSION 1
/**
 * @ingroup iface_zphoc_stacked_layer_surface_v1
 */
#define ZPHOC_STACKED_LAYER_SURFACE_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_zphoc_stacked_layer_surface_v1 */
static inline void
zphoc_stacked_layer_surface_v1_set_user_data(struct zphoc_stacked_layer_surface_v1 *zphoc_stacked_layer_surface_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zphoc_stacked_layer_surface_v1, user_data);
}

/** @ingroup iface_zphoc_stacked_layer_surface_v1 */
static inline void *
zphoc_stacked_layer_surface_v1_get_user_data(struct zphoc_stacked_layer_surface_v1 *zphoc_stacked_layer_surface_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zphoc_stacked_layer_surface_v1);
}

static inline uint32_t
zphoc_stacked_layer_surface_v1_get_version(struct zphoc_stacked_layer_surface_v1 *zphoc_stacked_layer_surface_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zphoc_stacked_layer_surface_v1);
}

/**
 * @ingroup iface_zphoc_stacked_layer_surface_v1
 *
 * Attaches the stacked layer surface below the layer surface given
 * in this request.
 */
static inline void
zphoc_stacked_layer_surface_v1_stack_below(struct zphoc_stacked_layer_surface_v1 *zphoc_stacked_layer_surface_v1, struct zwlr_layer_surface_v1 *surface)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zphoc_stacked_layer_surface_v1,
			 ZPHOC_STACKED_LAYER_SURFACE_V1_STACK_BELOW, NULL, wl_proxy_get_version((struct wl_proxy *) zphoc_stacked_layer_surface_v1), 0, surface);
}

/**
 * @ingroup iface_zphoc_stacked_layer_surface_v1
 *
 * Attaches the stacked layer surface above the layer surface given
 * in this request.
 */
static inline void
zphoc_stacked_layer_surface_v1_stack_above(struct zphoc_stacked_layer_surface_v1 *zphoc_stacked_layer_surface_v1, struct zwlr_layer_surface_v1 *surface)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zphoc_stacked_layer_surface_v1,
			 ZPHOC_STACKED_LAYER_SURFACE_V1_STACK_ABOVE, NULL, wl_proxy_get_version((struct wl_proxy *) zphoc_stacked_layer_surface_v1), 0, surface);
}

/**
 * @ingroup iface_zphoc_stacked_layer_surface_v1
 *
 * This request destroys the layer surface binder.
 */
static inline void
zphoc_stacked_layer_surface_v1_destroy(struct zphoc_stacked_layer_surface_v1 *zphoc_stacked_layer_surface_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zphoc_stacked_layer_surface_v1,
			 ZPHOC_STACKED_LAYER_SURFACE_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zphoc_stacked_layer_surface_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
