// Copyright (c) 2022 Proton Technologies AG
//
// This file is part of ProtonMail Bridge.
//
// ProtonMail Bridge is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// ProtonMail Bridge is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with ProtonMail Bridge.  If not, see <https://www.gnu.org/licenses/>.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v5.29.5
// source: bridge.proto

package grpc

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// **********************************************************
// Log related message
// **********************************************************
// Note: the enum values are prefixed with 'LOG_' to avoid a clash in C++ on Windows with the ERROR macro defined in wingdi.h
type LogLevel int32

const (
	LogLevel_LOG_PANIC LogLevel = 0
	LogLevel_LOG_FATAL LogLevel = 1
	LogLevel_LOG_ERROR LogLevel = 2
	LogLevel_LOG_WARN  LogLevel = 3
	LogLevel_LOG_INFO  LogLevel = 4
	LogLevel_LOG_DEBUG LogLevel = 5
	LogLevel_LOG_TRACE LogLevel = 6
)

// Enum value maps for LogLevel.
var (
	LogLevel_name = map[int32]string{
		0: "LOG_PANIC",
		1: "LOG_FATAL",
		2: "LOG_ERROR",
		3: "LOG_WARN",
		4: "LOG_INFO",
		5: "LOG_DEBUG",
		6: "LOG_TRACE",
	}
	LogLevel_value = map[string]int32{
		"LOG_PANIC": 0,
		"LOG_FATAL": 1,
		"LOG_ERROR": 2,
		"LOG_WARN":  3,
		"LOG_INFO":  4,
		"LOG_DEBUG": 5,
		"LOG_TRACE": 6,
	}
)

func (x LogLevel) Enum() *LogLevel {
	p := new(LogLevel)
	*p = x
	return p
}

func (x LogLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LogLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_bridge_proto_enumTypes[0].Descriptor()
}

func (LogLevel) Type() protoreflect.EnumType {
	return &file_bridge_proto_enumTypes[0]
}

func (x LogLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LogLevel.Descriptor instead.
func (LogLevel) EnumDescriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{0}
}

// **********************************************************
// user related messages
// **********************************************************
type UserState int32

const (
	UserState_SIGNED_OUT UserState = 0
	UserState_LOCKED     UserState = 1
	UserState_CONNECTED  UserState = 2
)

// Enum value maps for UserState.
var (
	UserState_name = map[int32]string{
		0: "SIGNED_OUT",
		1: "LOCKED",
		2: "CONNECTED",
	}
	UserState_value = map[string]int32{
		"SIGNED_OUT": 0,
		"LOCKED":     1,
		"CONNECTED":  2,
	}
)

func (x UserState) Enum() *UserState {
	p := new(UserState)
	*p = x
	return p
}

func (x UserState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UserState) Descriptor() protoreflect.EnumDescriptor {
	return file_bridge_proto_enumTypes[1].Descriptor()
}

func (UserState) Type() protoreflect.EnumType {
	return &file_bridge_proto_enumTypes[1]
}

func (x UserState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UserState.Descriptor instead.
func (UserState) EnumDescriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{1}
}

type LoginErrorType int32

const (
	LoginErrorType_USERNAME_PASSWORD_ERROR LoginErrorType = 0
	LoginErrorType_FREE_USER               LoginErrorType = 1
	LoginErrorType_CONNECTION_ERROR        LoginErrorType = 2
	LoginErrorType_TFA_ERROR               LoginErrorType = 3
	LoginErrorType_TFA_ABORT               LoginErrorType = 4
	LoginErrorType_TWO_PASSWORDS_ERROR     LoginErrorType = 5
	LoginErrorType_TWO_PASSWORDS_ABORT     LoginErrorType = 6
	LoginErrorType_HV_ERROR                LoginErrorType = 7
	LoginErrorType_FIDO_PIN_INVALID        LoginErrorType = 8
	LoginErrorType_FIDO_PIN_BLOCKED        LoginErrorType = 9
	LoginErrorType_FIDO_ERROR              LoginErrorType = 10
)

// Enum value maps for LoginErrorType.
var (
	LoginErrorType_name = map[int32]string{
		0:  "USERNAME_PASSWORD_ERROR",
		1:  "FREE_USER",
		2:  "CONNECTION_ERROR",
		3:  "TFA_ERROR",
		4:  "TFA_ABORT",
		5:  "TWO_PASSWORDS_ERROR",
		6:  "TWO_PASSWORDS_ABORT",
		7:  "HV_ERROR",
		8:  "FIDO_PIN_INVALID",
		9:  "FIDO_PIN_BLOCKED",
		10: "FIDO_ERROR",
	}
	LoginErrorType_value = map[string]int32{
		"USERNAME_PASSWORD_ERROR": 0,
		"FREE_USER":               1,
		"CONNECTION_ERROR":        2,
		"TFA_ERROR":               3,
		"TFA_ABORT":               4,
		"TWO_PASSWORDS_ERROR":     5,
		"TWO_PASSWORDS_ABORT":     6,
		"HV_ERROR":                7,
		"FIDO_PIN_INVALID":        8,
		"FIDO_PIN_BLOCKED":        9,
		"FIDO_ERROR":              10,
	}
)

func (x LoginErrorType) Enum() *LoginErrorType {
	p := new(LoginErrorType)
	*p = x
	return p
}

func (x LoginErrorType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoginErrorType) Descriptor() protoreflect.EnumDescriptor {
	return file_bridge_proto_enumTypes[2].Descriptor()
}

func (LoginErrorType) Type() protoreflect.EnumType {
	return &file_bridge_proto_enumTypes[2]
}

func (x LoginErrorType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoginErrorType.Descriptor instead.
func (LoginErrorType) EnumDescriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{2}
}

type UpdateErrorType int32

const (
	UpdateErrorType_UPDATE_MANUAL_ERROR UpdateErrorType = 0
	UpdateErrorType_UPDATE_FORCE_ERROR  UpdateErrorType = 1
	UpdateErrorType_UPDATE_SILENT_ERROR UpdateErrorType = 2
)

// Enum value maps for UpdateErrorType.
var (
	UpdateErrorType_name = map[int32]string{
		0: "UPDATE_MANUAL_ERROR",
		1: "UPDATE_FORCE_ERROR",
		2: "UPDATE_SILENT_ERROR",
	}
	UpdateErrorType_value = map[string]int32{
		"UPDATE_MANUAL_ERROR": 0,
		"UPDATE_FORCE_ERROR":  1,
		"UPDATE_SILENT_ERROR": 2,
	}
)

func (x UpdateErrorType) Enum() *UpdateErrorType {
	p := new(UpdateErrorType)
	*p = x
	return p
}

func (x UpdateErrorType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UpdateErrorType) Descriptor() protoreflect.EnumDescriptor {
	return file_bridge_proto_enumTypes[3].Descriptor()
}

func (UpdateErrorType) Type() protoreflect.EnumType {
	return &file_bridge_proto_enumTypes[3]
}

func (x UpdateErrorType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UpdateErrorType.Descriptor instead.
func (UpdateErrorType) EnumDescriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{3}
}

type DiskCacheErrorType int32

const (
	DiskCacheErrorType_CANT_MOVE_DISK_CACHE_ERROR DiskCacheErrorType = 0
)

// Enum value maps for DiskCacheErrorType.
var (
	DiskCacheErrorType_name = map[int32]string{
		0: "CANT_MOVE_DISK_CACHE_ERROR",
	}
	DiskCacheErrorType_value = map[string]int32{
		"CANT_MOVE_DISK_CACHE_ERROR": 0,
	}
)

func (x DiskCacheErrorType) Enum() *DiskCacheErrorType {
	p := new(DiskCacheErrorType)
	*p = x
	return p
}

func (x DiskCacheErrorType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DiskCacheErrorType) Descriptor() protoreflect.EnumDescriptor {
	return file_bridge_proto_enumTypes[4].Descriptor()
}

func (DiskCacheErrorType) Type() protoreflect.EnumType {
	return &file_bridge_proto_enumTypes[4]
}

func (x DiskCacheErrorType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DiskCacheErrorType.Descriptor instead.
func (DiskCacheErrorType) EnumDescriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{4}
}

type MailServerSettingsErrorType int32

const (
	MailServerSettingsErrorType_IMAP_PORT_STARTUP_ERROR           MailServerSettingsErrorType = 0
	MailServerSettingsErrorType_SMTP_PORT_STARTUP_ERROR           MailServerSettingsErrorType = 1
	MailServerSettingsErrorType_IMAP_PORT_CHANGE_ERROR            MailServerSettingsErrorType = 2
	MailServerSettingsErrorType_SMTP_PORT_CHANGE_ERROR            MailServerSettingsErrorType = 3
	MailServerSettingsErrorType_IMAP_CONNECTION_MODE_CHANGE_ERROR MailServerSettingsErrorType = 4
	MailServerSettingsErrorType_SMTP_CONNECTION_MODE_CHANGE_ERROR MailServerSettingsErrorType = 5
)

// Enum value maps for MailServerSettingsErrorType.
var (
	MailServerSettingsErrorType_name = map[int32]string{
		0: "IMAP_PORT_STARTUP_ERROR",
		1: "SMTP_PORT_STARTUP_ERROR",
		2: "IMAP_PORT_CHANGE_ERROR",
		3: "SMTP_PORT_CHANGE_ERROR",
		4: "IMAP_CONNECTION_MODE_CHANGE_ERROR",
		5: "SMTP_CONNECTION_MODE_CHANGE_ERROR",
	}
	MailServerSettingsErrorType_value = map[string]int32{
		"IMAP_PORT_STARTUP_ERROR":           0,
		"SMTP_PORT_STARTUP_ERROR":           1,
		"IMAP_PORT_CHANGE_ERROR":            2,
		"SMTP_PORT_CHANGE_ERROR":            3,
		"IMAP_CONNECTION_MODE_CHANGE_ERROR": 4,
		"SMTP_CONNECTION_MODE_CHANGE_ERROR": 5,
	}
)

func (x MailServerSettingsErrorType) Enum() *MailServerSettingsErrorType {
	p := new(MailServerSettingsErrorType)
	*p = x
	return p
}

func (x MailServerSettingsErrorType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MailServerSettingsErrorType) Descriptor() protoreflect.EnumDescriptor {
	return file_bridge_proto_enumTypes[5].Descriptor()
}

func (MailServerSettingsErrorType) Type() protoreflect.EnumType {
	return &file_bridge_proto_enumTypes[5]
}

func (x MailServerSettingsErrorType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MailServerSettingsErrorType.Descriptor instead.
func (MailServerSettingsErrorType) EnumDescriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{5}
}

// **********************************************************
// Generic errors
// **********************************************************
type ErrorCode int32

const (
	ErrorCode_UNKNOWN_ERROR         ErrorCode = 0
	ErrorCode_TLS_CERT_EXPORT_ERROR ErrorCode = 1
	ErrorCode_TLS_KEY_EXPORT_ERROR  ErrorCode = 2
)

// Enum value maps for ErrorCode.
var (
	ErrorCode_name = map[int32]string{
		0: "UNKNOWN_ERROR",
		1: "TLS_CERT_EXPORT_ERROR",
		2: "TLS_KEY_EXPORT_ERROR",
	}
	ErrorCode_value = map[string]int32{
		"UNKNOWN_ERROR":         0,
		"TLS_CERT_EXPORT_ERROR": 1,
		"TLS_KEY_EXPORT_ERROR":  2,
	}
)

func (x ErrorCode) Enum() *ErrorCode {
	p := new(ErrorCode)
	*p = x
	return p
}

func (x ErrorCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ErrorCode) Descriptor() protoreflect.EnumDescriptor {
	return file_bridge_proto_enumTypes[6].Descriptor()
}

func (ErrorCode) Type() protoreflect.EnumType {
	return &file_bridge_proto_enumTypes[6]
}

func (x ErrorCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ErrorCode.Descriptor instead.
func (ErrorCode) EnumDescriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{6}
}

type AddLogEntryRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Level         LogLevel               `protobuf:"varint,1,opt,name=level,proto3,enum=grpc.LogLevel" json:"level,omitempty"`
	Package       string                 `protobuf:"bytes,2,opt,name=package,proto3" json:"package,omitempty"` // package is Go lingo but it identifies the component responsible for the log entry
	Message       string                 `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AddLogEntryRequest) Reset() {
	*x = AddLogEntryRequest{}
	mi := &file_bridge_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddLogEntryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddLogEntryRequest) ProtoMessage() {}

func (x *AddLogEntryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddLogEntryRequest.ProtoReflect.Descriptor instead.
func (*AddLogEntryRequest) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{0}
}

func (x *AddLogEntryRequest) GetLevel() LogLevel {
	if x != nil {
		return x.Level
	}
	return LogLevel_LOG_PANIC
}

func (x *AddLogEntryRequest) GetPackage() string {
	if x != nil {
		return x.Package
	}
	return ""
}

func (x *AddLogEntryRequest) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

// **********************************************************
//
//	GuiReady
//
// **********************************************************
type GuiReadyResponse struct {
	state            protoimpl.MessageState `protogen:"open.v1"`
	ShowSplashScreen bool                   `protobuf:"varint,1,opt,name=showSplashScreen,proto3" json:"showSplashScreen,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *GuiReadyResponse) Reset() {
	*x = GuiReadyResponse{}
	mi := &file_bridge_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GuiReadyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GuiReadyResponse) ProtoMessage() {}

func (x *GuiReadyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GuiReadyResponse.ProtoReflect.Descriptor instead.
func (*GuiReadyResponse) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{1}
}

func (x *GuiReadyResponse) GetShowSplashScreen() bool {
	if x != nil {
		return x.ShowSplashScreen
	}
	return false
}

// **********************************************************
//
//	Bug reporting related messages.
//
// **********************************************************
type ReportBugRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	OsType        string                 `protobuf:"bytes,1,opt,name=osType,proto3" json:"osType,omitempty"`
	OsVersion     string                 `protobuf:"bytes,2,opt,name=osVersion,proto3" json:"osVersion,omitempty"`
	Title         string                 `protobuf:"bytes,3,opt,name=title,proto3" json:"title,omitempty"`
	Description   string                 `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	Address       string                 `protobuf:"bytes,5,opt,name=address,proto3" json:"address,omitempty"`
	EmailClient   string                 `protobuf:"bytes,6,opt,name=emailClient,proto3" json:"emailClient,omitempty"`
	IncludeLogs   bool                   `protobuf:"varint,7,opt,name=includeLogs,proto3" json:"includeLogs,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReportBugRequest) Reset() {
	*x = ReportBugRequest{}
	mi := &file_bridge_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReportBugRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportBugRequest) ProtoMessage() {}

func (x *ReportBugRequest) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportBugRequest.ProtoReflect.Descriptor instead.
func (*ReportBugRequest) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{2}
}

func (x *ReportBugRequest) GetOsType() string {
	if x != nil {
		return x.OsType
	}
	return ""
}

func (x *ReportBugRequest) GetOsVersion() string {
	if x != nil {
		return x.OsVersion
	}
	return ""
}

func (x *ReportBugRequest) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *ReportBugRequest) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ReportBugRequest) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *ReportBugRequest) GetEmailClient() string {
	if x != nil {
		return x.EmailClient
	}
	return ""
}

func (x *ReportBugRequest) GetIncludeLogs() bool {
	if x != nil {
		return x.IncludeLogs
	}
	return false
}

type LoginRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Username      string                 `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	Password      []byte                 `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
	UseHvDetails  *bool                  `protobuf:"varint,3,opt,name=useHvDetails,proto3,oneof" json:"useHvDetails,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LoginRequest) Reset() {
	*x = LoginRequest{}
	mi := &file_bridge_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoginRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoginRequest) ProtoMessage() {}

func (x *LoginRequest) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoginRequest.ProtoReflect.Descriptor instead.
func (*LoginRequest) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{3}
}

func (x *LoginRequest) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *LoginRequest) GetPassword() []byte {
	if x != nil {
		return x.Password
	}
	return nil
}

func (x *LoginRequest) GetUseHvDetails() bool {
	if x != nil && x.UseHvDetails != nil {
		return *x.UseHvDetails
	}
	return false
}

type LoginAbortRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Username      string                 `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LoginAbortRequest) Reset() {
	*x = LoginAbortRequest{}
	mi := &file_bridge_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoginAbortRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoginAbortRequest) ProtoMessage() {}

func (x *LoginAbortRequest) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoginAbortRequest.ProtoReflect.Descriptor instead.
func (*LoginAbortRequest) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{4}
}

func (x *LoginAbortRequest) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

// **********************************************************
// IMAP/SMTP Mail Server settings
// **********************************************************
type ImapSmtpSettings struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	ImapPort      int32                  `protobuf:"varint,1,opt,name=imapPort,proto3" json:"imapPort,omitempty"`
	SmtpPort      int32                  `protobuf:"varint,2,opt,name=smtpPort,proto3" json:"smtpPort,omitempty"`
	UseSSLForImap bool                   `protobuf:"varint,3,opt,name=useSSLForImap,proto3" json:"useSSLForImap,omitempty"`
	UseSSLForSmtp bool                   `protobuf:"varint,4,opt,name=useSSLForSmtp,proto3" json:"useSSLForSmtp,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ImapSmtpSettings) Reset() {
	*x = ImapSmtpSettings{}
	mi := &file_bridge_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImapSmtpSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImapSmtpSettings) ProtoMessage() {}

func (x *ImapSmtpSettings) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImapSmtpSettings.ProtoReflect.Descriptor instead.
func (*ImapSmtpSettings) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{5}
}

func (x *ImapSmtpSettings) GetImapPort() int32 {
	if x != nil {
		return x.ImapPort
	}
	return 0
}

func (x *ImapSmtpSettings) GetSmtpPort() int32 {
	if x != nil {
		return x.SmtpPort
	}
	return 0
}

func (x *ImapSmtpSettings) GetUseSSLForImap() bool {
	if x != nil {
		return x.UseSSLForImap
	}
	return false
}

func (x *ImapSmtpSettings) GetUseSSLForSmtp() bool {
	if x != nil {
		return x.UseSSLForSmtp
	}
	return false
}

// **********************************************************
// Keychain related message
// **********************************************************
type AvailableKeychainsResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Keychains     []string               `protobuf:"bytes,1,rep,name=keychains,proto3" json:"keychains,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AvailableKeychainsResponse) Reset() {
	*x = AvailableKeychainsResponse{}
	mi := &file_bridge_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AvailableKeychainsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AvailableKeychainsResponse) ProtoMessage() {}

func (x *AvailableKeychainsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AvailableKeychainsResponse.ProtoReflect.Descriptor instead.
func (*AvailableKeychainsResponse) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{6}
}

func (x *AvailableKeychainsResponse) GetKeychains() []string {
	if x != nil {
		return x.Keychains
	}
	return nil
}

type User struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Id            string                 `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Username      string                 `protobuf:"bytes,2,opt,name=username,proto3" json:"username,omitempty"`
	AvatarText    string                 `protobuf:"bytes,3,opt,name=avatarText,proto3" json:"avatarText,omitempty"`
	State         UserState              `protobuf:"varint,4,opt,name=state,proto3,enum=grpc.UserState" json:"state,omitempty"`
	SplitMode     bool                   `protobuf:"varint,5,opt,name=splitMode,proto3" json:"splitMode,omitempty"`
	UsedBytes     int64                  `protobuf:"varint,6,opt,name=usedBytes,proto3" json:"usedBytes,omitempty"`
	TotalBytes    int64                  `protobuf:"varint,7,opt,name=totalBytes,proto3" json:"totalBytes,omitempty"`
	Password      []byte                 `protobuf:"bytes,8,opt,name=password,proto3" json:"password,omitempty"`
	Addresses     []string               `protobuf:"bytes,9,rep,name=addresses,proto3" json:"addresses,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *User) Reset() {
	*x = User{}
	mi := &file_bridge_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *User) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*User) ProtoMessage() {}

func (x *User) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use User.ProtoReflect.Descriptor instead.
func (*User) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{7}
}

func (x *User) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *User) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *User) GetAvatarText() string {
	if x != nil {
		return x.AvatarText
	}
	return ""
}

func (x *User) GetState() UserState {
	if x != nil {
		return x.State
	}
	return UserState_SIGNED_OUT
}

func (x *User) GetSplitMode() bool {
	if x != nil {
		return x.SplitMode
	}
	return false
}

func (x *User) GetUsedBytes() int64 {
	if x != nil {
		return x.UsedBytes
	}
	return 0
}

func (x *User) GetTotalBytes() int64 {
	if x != nil {
		return x.TotalBytes
	}
	return 0
}

func (x *User) GetPassword() []byte {
	if x != nil {
		return x.Password
	}
	return nil
}

func (x *User) GetAddresses() []string {
	if x != nil {
		return x.Addresses
	}
	return nil
}

type UserSplitModeRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UserID        string                 `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID,omitempty"`
	Active        bool                   `protobuf:"varint,2,opt,name=active,proto3" json:"active,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UserSplitModeRequest) Reset() {
	*x = UserSplitModeRequest{}
	mi := &file_bridge_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserSplitModeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserSplitModeRequest) ProtoMessage() {}

func (x *UserSplitModeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserSplitModeRequest.ProtoReflect.Descriptor instead.
func (*UserSplitModeRequest) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{8}
}

func (x *UserSplitModeRequest) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *UserSplitModeRequest) GetActive() bool {
	if x != nil {
		return x.Active
	}
	return false
}

type UserBadEventFeedbackRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UserID        string                 `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID,omitempty"`
	DoResync      bool                   `protobuf:"varint,2,opt,name=doResync,proto3" json:"doResync,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UserBadEventFeedbackRequest) Reset() {
	*x = UserBadEventFeedbackRequest{}
	mi := &file_bridge_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserBadEventFeedbackRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserBadEventFeedbackRequest) ProtoMessage() {}

func (x *UserBadEventFeedbackRequest) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserBadEventFeedbackRequest.ProtoReflect.Descriptor instead.
func (*UserBadEventFeedbackRequest) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{9}
}

func (x *UserBadEventFeedbackRequest) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *UserBadEventFeedbackRequest) GetDoResync() bool {
	if x != nil {
		return x.DoResync
	}
	return false
}

type UserListResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Users         []*User                `protobuf:"bytes,1,rep,name=users,proto3" json:"users,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UserListResponse) Reset() {
	*x = UserListResponse{}
	mi := &file_bridge_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserListResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserListResponse) ProtoMessage() {}

func (x *UserListResponse) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserListResponse.ProtoReflect.Descriptor instead.
func (*UserListResponse) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{10}
}

func (x *UserListResponse) GetUsers() []*User {
	if x != nil {
		return x.Users
	}
	return nil
}

type ConfigureAppleMailRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UserID        string                 `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID,omitempty"`
	Address       string                 `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ConfigureAppleMailRequest) Reset() {
	*x = ConfigureAppleMailRequest{}
	mi := &file_bridge_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConfigureAppleMailRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigureAppleMailRequest) ProtoMessage() {}

func (x *ConfigureAppleMailRequest) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigureAppleMailRequest.ProtoReflect.Descriptor instead.
func (*ConfigureAppleMailRequest) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{11}
}

func (x *ConfigureAppleMailRequest) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *ConfigureAppleMailRequest) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

type EventStreamRequest struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	ClientPlatform string                 `protobuf:"bytes,1,opt,name=ClientPlatform,proto3" json:"ClientPlatform,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *EventStreamRequest) Reset() {
	*x = EventStreamRequest{}
	mi := &file_bridge_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EventStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventStreamRequest) ProtoMessage() {}

func (x *EventStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventStreamRequest.ProtoReflect.Descriptor instead.
func (*EventStreamRequest) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{12}
}

func (x *EventStreamRequest) GetClientPlatform() string {
	if x != nil {
		return x.ClientPlatform
	}
	return ""
}

type StreamEvent struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Event:
	//
	//	*StreamEvent_App
	//	*StreamEvent_Login
	//	*StreamEvent_Update
	//	*StreamEvent_Cache
	//	*StreamEvent_MailServerSettings
	//	*StreamEvent_Keychain
	//	*StreamEvent_Mail
	//	*StreamEvent_User
	//	*StreamEvent_GenericError
	Event         isStreamEvent_Event `protobuf_oneof:"event"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StreamEvent) Reset() {
	*x = StreamEvent{}
	mi := &file_bridge_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamEvent) ProtoMessage() {}

func (x *StreamEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamEvent.ProtoReflect.Descriptor instead.
func (*StreamEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{13}
}

func (x *StreamEvent) GetEvent() isStreamEvent_Event {
	if x != nil {
		return x.Event
	}
	return nil
}

func (x *StreamEvent) GetApp() *AppEvent {
	if x != nil {
		if x, ok := x.Event.(*StreamEvent_App); ok {
			return x.App
		}
	}
	return nil
}

func (x *StreamEvent) GetLogin() *LoginEvent {
	if x != nil {
		if x, ok := x.Event.(*StreamEvent_Login); ok {
			return x.Login
		}
	}
	return nil
}

func (x *StreamEvent) GetUpdate() *UpdateEvent {
	if x != nil {
		if x, ok := x.Event.(*StreamEvent_Update); ok {
			return x.Update
		}
	}
	return nil
}

func (x *StreamEvent) GetCache() *DiskCacheEvent {
	if x != nil {
		if x, ok := x.Event.(*StreamEvent_Cache); ok {
			return x.Cache
		}
	}
	return nil
}

func (x *StreamEvent) GetMailServerSettings() *MailServerSettingsEvent {
	if x != nil {
		if x, ok := x.Event.(*StreamEvent_MailServerSettings); ok {
			return x.MailServerSettings
		}
	}
	return nil
}

func (x *StreamEvent) GetKeychain() *KeychainEvent {
	if x != nil {
		if x, ok := x.Event.(*StreamEvent_Keychain); ok {
			return x.Keychain
		}
	}
	return nil
}

func (x *StreamEvent) GetMail() *MailEvent {
	if x != nil {
		if x, ok := x.Event.(*StreamEvent_Mail); ok {
			return x.Mail
		}
	}
	return nil
}

func (x *StreamEvent) GetUser() *UserEvent {
	if x != nil {
		if x, ok := x.Event.(*StreamEvent_User); ok {
			return x.User
		}
	}
	return nil
}

func (x *StreamEvent) GetGenericError() *GenericErrorEvent {
	if x != nil {
		if x, ok := x.Event.(*StreamEvent_GenericError); ok {
			return x.GenericError
		}
	}
	return nil
}

type isStreamEvent_Event interface {
	isStreamEvent_Event()
}

type StreamEvent_App struct {
	App *AppEvent `protobuf:"bytes,1,opt,name=app,proto3,oneof"`
}

type StreamEvent_Login struct {
	Login *LoginEvent `protobuf:"bytes,2,opt,name=login,proto3,oneof"`
}

type StreamEvent_Update struct {
	Update *UpdateEvent `protobuf:"bytes,3,opt,name=update,proto3,oneof"`
}

type StreamEvent_Cache struct {
	Cache *DiskCacheEvent `protobuf:"bytes,4,opt,name=cache,proto3,oneof"`
}

type StreamEvent_MailServerSettings struct {
	MailServerSettings *MailServerSettingsEvent `protobuf:"bytes,5,opt,name=mailServerSettings,proto3,oneof"`
}

type StreamEvent_Keychain struct {
	Keychain *KeychainEvent `protobuf:"bytes,6,opt,name=keychain,proto3,oneof"`
}

type StreamEvent_Mail struct {
	Mail *MailEvent `protobuf:"bytes,7,opt,name=mail,proto3,oneof"`
}

type StreamEvent_User struct {
	User *UserEvent `protobuf:"bytes,8,opt,name=user,proto3,oneof"`
}

type StreamEvent_GenericError struct {
	GenericError *GenericErrorEvent `protobuf:"bytes,9,opt,name=genericError,proto3,oneof"`
}

func (*StreamEvent_App) isStreamEvent_Event() {}

func (*StreamEvent_Login) isStreamEvent_Event() {}

func (*StreamEvent_Update) isStreamEvent_Event() {}

func (*StreamEvent_Cache) isStreamEvent_Event() {}

func (*StreamEvent_MailServerSettings) isStreamEvent_Event() {}

func (*StreamEvent_Keychain) isStreamEvent_Event() {}

func (*StreamEvent_Mail) isStreamEvent_Event() {}

func (*StreamEvent_User) isStreamEvent_Event() {}

func (*StreamEvent_GenericError) isStreamEvent_Event() {}

// **********************************************************
// App related events
// **********************************************************
type AppEvent struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Event:
	//
	//	*AppEvent_InternetStatus
	//	*AppEvent_ToggleAutostartFinished
	//	*AppEvent_ResetFinished
	//	*AppEvent_ReportBugFinished
	//	*AppEvent_ReportBugSuccess
	//	*AppEvent_ReportBugError
	//	*AppEvent_ShowMainWindow
	//	*AppEvent_ReportBugFallback
	//	*AppEvent_CertificateInstallSuccess
	//	*AppEvent_CertificateInstallCanceled
	//	*AppEvent_CertificateInstallFailed
	//	*AppEvent_KnowledgeBaseSuggestions
	//	*AppEvent_RepairStarted
	//	*AppEvent_AllUsersLoaded
	//	*AppEvent_UserNotification
	Event         isAppEvent_Event `protobuf_oneof:"event"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AppEvent) Reset() {
	*x = AppEvent{}
	mi := &file_bridge_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AppEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppEvent) ProtoMessage() {}

func (x *AppEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppEvent.ProtoReflect.Descriptor instead.
func (*AppEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{14}
}

func (x *AppEvent) GetEvent() isAppEvent_Event {
	if x != nil {
		return x.Event
	}
	return nil
}

func (x *AppEvent) GetInternetStatus() *InternetStatusEvent {
	if x != nil {
		if x, ok := x.Event.(*AppEvent_InternetStatus); ok {
			return x.InternetStatus
		}
	}
	return nil
}

func (x *AppEvent) GetToggleAutostartFinished() *ToggleAutostartFinishedEvent {
	if x != nil {
		if x, ok := x.Event.(*AppEvent_ToggleAutostartFinished); ok {
			return x.ToggleAutostartFinished
		}
	}
	return nil
}

func (x *AppEvent) GetResetFinished() *ResetFinishedEvent {
	if x != nil {
		if x, ok := x.Event.(*AppEvent_ResetFinished); ok {
			return x.ResetFinished
		}
	}
	return nil
}

func (x *AppEvent) GetReportBugFinished() *ReportBugFinishedEvent {
	if x != nil {
		if x, ok := x.Event.(*AppEvent_ReportBugFinished); ok {
			return x.ReportBugFinished
		}
	}
	return nil
}

func (x *AppEvent) GetReportBugSuccess() *ReportBugSuccessEvent {
	if x != nil {
		if x, ok := x.Event.(*AppEvent_ReportBugSuccess); ok {
			return x.ReportBugSuccess
		}
	}
	return nil
}

func (x *AppEvent) GetReportBugError() *ReportBugErrorEvent {
	if x != nil {
		if x, ok := x.Event.(*AppEvent_ReportBugError); ok {
			return x.ReportBugError
		}
	}
	return nil
}

func (x *AppEvent) GetShowMainWindow() *ShowMainWindowEvent {
	if x != nil {
		if x, ok := x.Event.(*AppEvent_ShowMainWindow); ok {
			return x.ShowMainWindow
		}
	}
	return nil
}

func (x *AppEvent) GetReportBugFallback() *ReportBugFallbackEvent {
	if x != nil {
		if x, ok := x.Event.(*AppEvent_ReportBugFallback); ok {
			return x.ReportBugFallback
		}
	}
	return nil
}

func (x *AppEvent) GetCertificateInstallSuccess() *CertificateInstallSuccessEvent {
	if x != nil {
		if x, ok := x.Event.(*AppEvent_CertificateInstallSuccess); ok {
			return x.CertificateInstallSuccess
		}
	}
	return nil
}

func (x *AppEvent) GetCertificateInstallCanceled() *CertificateInstallCanceledEvent {
	if x != nil {
		if x, ok := x.Event.(*AppEvent_CertificateInstallCanceled); ok {
			return x.CertificateInstallCanceled
		}
	}
	return nil
}

func (x *AppEvent) GetCertificateInstallFailed() *CertificateInstallFailedEvent {
	if x != nil {
		if x, ok := x.Event.(*AppEvent_CertificateInstallFailed); ok {
			return x.CertificateInstallFailed
		}
	}
	return nil
}

func (x *AppEvent) GetKnowledgeBaseSuggestions() *KnowledgeBaseSuggestionsEvent {
	if x != nil {
		if x, ok := x.Event.(*AppEvent_KnowledgeBaseSuggestions); ok {
			return x.KnowledgeBaseSuggestions
		}
	}
	return nil
}

func (x *AppEvent) GetRepairStarted() *RepairStartedEvent {
	if x != nil {
		if x, ok := x.Event.(*AppEvent_RepairStarted); ok {
			return x.RepairStarted
		}
	}
	return nil
}

func (x *AppEvent) GetAllUsersLoaded() *AllUsersLoadedEvent {
	if x != nil {
		if x, ok := x.Event.(*AppEvent_AllUsersLoaded); ok {
			return x.AllUsersLoaded
		}
	}
	return nil
}

func (x *AppEvent) GetUserNotification() *UserNotificationEvent {
	if x != nil {
		if x, ok := x.Event.(*AppEvent_UserNotification); ok {
			return x.UserNotification
		}
	}
	return nil
}

type isAppEvent_Event interface {
	isAppEvent_Event()
}

type AppEvent_InternetStatus struct {
	InternetStatus *InternetStatusEvent `protobuf:"bytes,1,opt,name=internetStatus,proto3,oneof"`
}

type AppEvent_ToggleAutostartFinished struct {
	ToggleAutostartFinished *ToggleAutostartFinishedEvent `protobuf:"bytes,2,opt,name=toggleAutostartFinished,proto3,oneof"`
}

type AppEvent_ResetFinished struct {
	ResetFinished *ResetFinishedEvent `protobuf:"bytes,3,opt,name=resetFinished,proto3,oneof"`
}

type AppEvent_ReportBugFinished struct {
	ReportBugFinished *ReportBugFinishedEvent `protobuf:"bytes,4,opt,name=reportBugFinished,proto3,oneof"`
}

type AppEvent_ReportBugSuccess struct {
	ReportBugSuccess *ReportBugSuccessEvent `protobuf:"bytes,5,opt,name=reportBugSuccess,proto3,oneof"`
}

type AppEvent_ReportBugError struct {
	ReportBugError *ReportBugErrorEvent `protobuf:"bytes,6,opt,name=reportBugError,proto3,oneof"`
}

type AppEvent_ShowMainWindow struct {
	ShowMainWindow *ShowMainWindowEvent `protobuf:"bytes,7,opt,name=showMainWindow,proto3,oneof"`
}

type AppEvent_ReportBugFallback struct {
	ReportBugFallback *ReportBugFallbackEvent `protobuf:"bytes,8,opt,name=reportBugFallback,proto3,oneof"`
}

type AppEvent_CertificateInstallSuccess struct {
	CertificateInstallSuccess *CertificateInstallSuccessEvent `protobuf:"bytes,9,opt,name=certificateInstallSuccess,proto3,oneof"`
}

type AppEvent_CertificateInstallCanceled struct {
	CertificateInstallCanceled *CertificateInstallCanceledEvent `protobuf:"bytes,10,opt,name=certificateInstallCanceled,proto3,oneof"`
}

type AppEvent_CertificateInstallFailed struct {
	CertificateInstallFailed *CertificateInstallFailedEvent `protobuf:"bytes,11,opt,name=certificateInstallFailed,proto3,oneof"`
}

type AppEvent_KnowledgeBaseSuggestions struct {
	KnowledgeBaseSuggestions *KnowledgeBaseSuggestionsEvent `protobuf:"bytes,12,opt,name=knowledgeBaseSuggestions,proto3,oneof"`
}

type AppEvent_RepairStarted struct {
	RepairStarted *RepairStartedEvent `protobuf:"bytes,13,opt,name=repairStarted,proto3,oneof"`
}

type AppEvent_AllUsersLoaded struct {
	AllUsersLoaded *AllUsersLoadedEvent `protobuf:"bytes,14,opt,name=allUsersLoaded,proto3,oneof"`
}

type AppEvent_UserNotification struct {
	UserNotification *UserNotificationEvent `protobuf:"bytes,15,opt,name=userNotification,proto3,oneof"`
}

func (*AppEvent_InternetStatus) isAppEvent_Event() {}

func (*AppEvent_ToggleAutostartFinished) isAppEvent_Event() {}

func (*AppEvent_ResetFinished) isAppEvent_Event() {}

func (*AppEvent_ReportBugFinished) isAppEvent_Event() {}

func (*AppEvent_ReportBugSuccess) isAppEvent_Event() {}

func (*AppEvent_ReportBugError) isAppEvent_Event() {}

func (*AppEvent_ShowMainWindow) isAppEvent_Event() {}

func (*AppEvent_ReportBugFallback) isAppEvent_Event() {}

func (*AppEvent_CertificateInstallSuccess) isAppEvent_Event() {}

func (*AppEvent_CertificateInstallCanceled) isAppEvent_Event() {}

func (*AppEvent_CertificateInstallFailed) isAppEvent_Event() {}

func (*AppEvent_KnowledgeBaseSuggestions) isAppEvent_Event() {}

func (*AppEvent_RepairStarted) isAppEvent_Event() {}

func (*AppEvent_AllUsersLoaded) isAppEvent_Event() {}

func (*AppEvent_UserNotification) isAppEvent_Event() {}

type InternetStatusEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Connected     bool                   `protobuf:"varint,1,opt,name=connected,proto3" json:"connected,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *InternetStatusEvent) Reset() {
	*x = InternetStatusEvent{}
	mi := &file_bridge_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InternetStatusEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InternetStatusEvent) ProtoMessage() {}

func (x *InternetStatusEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InternetStatusEvent.ProtoReflect.Descriptor instead.
func (*InternetStatusEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{15}
}

func (x *InternetStatusEvent) GetConnected() bool {
	if x != nil {
		return x.Connected
	}
	return false
}

type ToggleAutostartFinishedEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ToggleAutostartFinishedEvent) Reset() {
	*x = ToggleAutostartFinishedEvent{}
	mi := &file_bridge_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToggleAutostartFinishedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToggleAutostartFinishedEvent) ProtoMessage() {}

func (x *ToggleAutostartFinishedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToggleAutostartFinishedEvent.ProtoReflect.Descriptor instead.
func (*ToggleAutostartFinishedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{16}
}

type ResetFinishedEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResetFinishedEvent) Reset() {
	*x = ResetFinishedEvent{}
	mi := &file_bridge_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResetFinishedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResetFinishedEvent) ProtoMessage() {}

func (x *ResetFinishedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResetFinishedEvent.ProtoReflect.Descriptor instead.
func (*ResetFinishedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{17}
}

type ReportBugFinishedEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReportBugFinishedEvent) Reset() {
	*x = ReportBugFinishedEvent{}
	mi := &file_bridge_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReportBugFinishedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportBugFinishedEvent) ProtoMessage() {}

func (x *ReportBugFinishedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportBugFinishedEvent.ProtoReflect.Descriptor instead.
func (*ReportBugFinishedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{18}
}

type ReportBugSuccessEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReportBugSuccessEvent) Reset() {
	*x = ReportBugSuccessEvent{}
	mi := &file_bridge_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReportBugSuccessEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportBugSuccessEvent) ProtoMessage() {}

func (x *ReportBugSuccessEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportBugSuccessEvent.ProtoReflect.Descriptor instead.
func (*ReportBugSuccessEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{19}
}

type ReportBugErrorEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReportBugErrorEvent) Reset() {
	*x = ReportBugErrorEvent{}
	mi := &file_bridge_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReportBugErrorEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportBugErrorEvent) ProtoMessage() {}

func (x *ReportBugErrorEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportBugErrorEvent.ProtoReflect.Descriptor instead.
func (*ReportBugErrorEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{20}
}

type ShowMainWindowEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ShowMainWindowEvent) Reset() {
	*x = ShowMainWindowEvent{}
	mi := &file_bridge_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ShowMainWindowEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShowMainWindowEvent) ProtoMessage() {}

func (x *ShowMainWindowEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShowMainWindowEvent.ProtoReflect.Descriptor instead.
func (*ShowMainWindowEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{21}
}

type ReportBugFallbackEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReportBugFallbackEvent) Reset() {
	*x = ReportBugFallbackEvent{}
	mi := &file_bridge_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReportBugFallbackEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportBugFallbackEvent) ProtoMessage() {}

func (x *ReportBugFallbackEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportBugFallbackEvent.ProtoReflect.Descriptor instead.
func (*ReportBugFallbackEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{22}
}

type CertificateInstallSuccessEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CertificateInstallSuccessEvent) Reset() {
	*x = CertificateInstallSuccessEvent{}
	mi := &file_bridge_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CertificateInstallSuccessEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateInstallSuccessEvent) ProtoMessage() {}

func (x *CertificateInstallSuccessEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateInstallSuccessEvent.ProtoReflect.Descriptor instead.
func (*CertificateInstallSuccessEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{23}
}

type CertificateInstallCanceledEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CertificateInstallCanceledEvent) Reset() {
	*x = CertificateInstallCanceledEvent{}
	mi := &file_bridge_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CertificateInstallCanceledEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateInstallCanceledEvent) ProtoMessage() {}

func (x *CertificateInstallCanceledEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateInstallCanceledEvent.ProtoReflect.Descriptor instead.
func (*CertificateInstallCanceledEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{24}
}

type CertificateInstallFailedEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CertificateInstallFailedEvent) Reset() {
	*x = CertificateInstallFailedEvent{}
	mi := &file_bridge_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CertificateInstallFailedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateInstallFailedEvent) ProtoMessage() {}

func (x *CertificateInstallFailedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateInstallFailedEvent.ProtoReflect.Descriptor instead.
func (*CertificateInstallFailedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{25}
}

type RepairStartedEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RepairStartedEvent) Reset() {
	*x = RepairStartedEvent{}
	mi := &file_bridge_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RepairStartedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepairStartedEvent) ProtoMessage() {}

func (x *RepairStartedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RepairStartedEvent.ProtoReflect.Descriptor instead.
func (*RepairStartedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{26}
}

type AllUsersLoadedEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AllUsersLoadedEvent) Reset() {
	*x = AllUsersLoadedEvent{}
	mi := &file_bridge_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AllUsersLoadedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllUsersLoadedEvent) ProtoMessage() {}

func (x *AllUsersLoadedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllUsersLoadedEvent.ProtoReflect.Descriptor instead.
func (*AllUsersLoadedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{27}
}

type KnowledgeBaseSuggestion struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Url           string                 `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	Title         string                 `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *KnowledgeBaseSuggestion) Reset() {
	*x = KnowledgeBaseSuggestion{}
	mi := &file_bridge_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KnowledgeBaseSuggestion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KnowledgeBaseSuggestion) ProtoMessage() {}

func (x *KnowledgeBaseSuggestion) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KnowledgeBaseSuggestion.ProtoReflect.Descriptor instead.
func (*KnowledgeBaseSuggestion) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{28}
}

func (x *KnowledgeBaseSuggestion) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *KnowledgeBaseSuggestion) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

type KnowledgeBaseSuggestionsEvent struct {
	state         protoimpl.MessageState     `protogen:"open.v1"`
	Suggestions   []*KnowledgeBaseSuggestion `protobuf:"bytes,1,rep,name=suggestions,proto3" json:"suggestions,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *KnowledgeBaseSuggestionsEvent) Reset() {
	*x = KnowledgeBaseSuggestionsEvent{}
	mi := &file_bridge_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KnowledgeBaseSuggestionsEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KnowledgeBaseSuggestionsEvent) ProtoMessage() {}

func (x *KnowledgeBaseSuggestionsEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KnowledgeBaseSuggestionsEvent.ProtoReflect.Descriptor instead.
func (*KnowledgeBaseSuggestionsEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{29}
}

func (x *KnowledgeBaseSuggestionsEvent) GetSuggestions() []*KnowledgeBaseSuggestion {
	if x != nil {
		return x.Suggestions
	}
	return nil
}

// **********************************************************
// Login related events
// **********************************************************
type LoginEvent struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Event:
	//
	//	*LoginEvent_Error
	//	*LoginEvent_TfaRequested
	//	*LoginEvent_TwoPasswordRequested
	//	*LoginEvent_Finished
	//	*LoginEvent_AlreadyLoggedIn
	//	*LoginEvent_HvRequested
	//	*LoginEvent_FidoRequested
	//	*LoginEvent_TfaOrFidoRequested
	//	*LoginEvent_LoginFidoTouchRequested
	//	*LoginEvent_LoginFidoTouchCompleted
	//	*LoginEvent_LoginFidoPinRequired
	Event         isLoginEvent_Event `protobuf_oneof:"event"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LoginEvent) Reset() {
	*x = LoginEvent{}
	mi := &file_bridge_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoginEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoginEvent) ProtoMessage() {}

func (x *LoginEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoginEvent.ProtoReflect.Descriptor instead.
func (*LoginEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{30}
}

func (x *LoginEvent) GetEvent() isLoginEvent_Event {
	if x != nil {
		return x.Event
	}
	return nil
}

func (x *LoginEvent) GetError() *LoginErrorEvent {
	if x != nil {
		if x, ok := x.Event.(*LoginEvent_Error); ok {
			return x.Error
		}
	}
	return nil
}

func (x *LoginEvent) GetTfaRequested() *LoginTfaRequestedEvent {
	if x != nil {
		if x, ok := x.Event.(*LoginEvent_TfaRequested); ok {
			return x.TfaRequested
		}
	}
	return nil
}

func (x *LoginEvent) GetTwoPasswordRequested() *LoginTwoPasswordsRequestedEvent {
	if x != nil {
		if x, ok := x.Event.(*LoginEvent_TwoPasswordRequested); ok {
			return x.TwoPasswordRequested
		}
	}
	return nil
}

func (x *LoginEvent) GetFinished() *LoginFinishedEvent {
	if x != nil {
		if x, ok := x.Event.(*LoginEvent_Finished); ok {
			return x.Finished
		}
	}
	return nil
}

func (x *LoginEvent) GetAlreadyLoggedIn() *LoginFinishedEvent {
	if x != nil {
		if x, ok := x.Event.(*LoginEvent_AlreadyLoggedIn); ok {
			return x.AlreadyLoggedIn
		}
	}
	return nil
}

func (x *LoginEvent) GetHvRequested() *LoginHvRequestedEvent {
	if x != nil {
		if x, ok := x.Event.(*LoginEvent_HvRequested); ok {
			return x.HvRequested
		}
	}
	return nil
}

func (x *LoginEvent) GetFidoRequested() *LoginFidoRequestedEvent {
	if x != nil {
		if x, ok := x.Event.(*LoginEvent_FidoRequested); ok {
			return x.FidoRequested
		}
	}
	return nil
}

func (x *LoginEvent) GetTfaOrFidoRequested() *LoginTfaOrFidoRequestedEvent {
	if x != nil {
		if x, ok := x.Event.(*LoginEvent_TfaOrFidoRequested); ok {
			return x.TfaOrFidoRequested
		}
	}
	return nil
}

func (x *LoginEvent) GetLoginFidoTouchRequested() *LoginFidoTouchEvent {
	if x != nil {
		if x, ok := x.Event.(*LoginEvent_LoginFidoTouchRequested); ok {
			return x.LoginFidoTouchRequested
		}
	}
	return nil
}

func (x *LoginEvent) GetLoginFidoTouchCompleted() *LoginFidoTouchEvent {
	if x != nil {
		if x, ok := x.Event.(*LoginEvent_LoginFidoTouchCompleted); ok {
			return x.LoginFidoTouchCompleted
		}
	}
	return nil
}

func (x *LoginEvent) GetLoginFidoPinRequired() *LoginFidoPinRequired {
	if x != nil {
		if x, ok := x.Event.(*LoginEvent_LoginFidoPinRequired); ok {
			return x.LoginFidoPinRequired
		}
	}
	return nil
}

type isLoginEvent_Event interface {
	isLoginEvent_Event()
}

type LoginEvent_Error struct {
	Error *LoginErrorEvent `protobuf:"bytes,1,opt,name=error,proto3,oneof"`
}

type LoginEvent_TfaRequested struct {
	TfaRequested *LoginTfaRequestedEvent `protobuf:"bytes,2,opt,name=tfaRequested,proto3,oneof"`
}

type LoginEvent_TwoPasswordRequested struct {
	TwoPasswordRequested *LoginTwoPasswordsRequestedEvent `protobuf:"bytes,3,opt,name=twoPasswordRequested,proto3,oneof"`
}

type LoginEvent_Finished struct {
	Finished *LoginFinishedEvent `protobuf:"bytes,4,opt,name=finished,proto3,oneof"`
}

type LoginEvent_AlreadyLoggedIn struct {
	AlreadyLoggedIn *LoginFinishedEvent `protobuf:"bytes,5,opt,name=alreadyLoggedIn,proto3,oneof"`
}

type LoginEvent_HvRequested struct {
	HvRequested *LoginHvRequestedEvent `protobuf:"bytes,6,opt,name=hvRequested,proto3,oneof"`
}

type LoginEvent_FidoRequested struct {
	FidoRequested *LoginFidoRequestedEvent `protobuf:"bytes,7,opt,name=fidoRequested,proto3,oneof"`
}

type LoginEvent_TfaOrFidoRequested struct {
	TfaOrFidoRequested *LoginTfaOrFidoRequestedEvent `protobuf:"bytes,8,opt,name=tfaOrFidoRequested,proto3,oneof"`
}

type LoginEvent_LoginFidoTouchRequested struct {
	LoginFidoTouchRequested *LoginFidoTouchEvent `protobuf:"bytes,9,opt,name=loginFidoTouchRequested,proto3,oneof"`
}

type LoginEvent_LoginFidoTouchCompleted struct {
	LoginFidoTouchCompleted *LoginFidoTouchEvent `protobuf:"bytes,10,opt,name=loginFidoTouchCompleted,proto3,oneof"`
}

type LoginEvent_LoginFidoPinRequired struct {
	LoginFidoPinRequired *LoginFidoPinRequired `protobuf:"bytes,11,opt,name=loginFidoPinRequired,proto3,oneof"`
}

func (*LoginEvent_Error) isLoginEvent_Event() {}

func (*LoginEvent_TfaRequested) isLoginEvent_Event() {}

func (*LoginEvent_TwoPasswordRequested) isLoginEvent_Event() {}

func (*LoginEvent_Finished) isLoginEvent_Event() {}

func (*LoginEvent_AlreadyLoggedIn) isLoginEvent_Event() {}

func (*LoginEvent_HvRequested) isLoginEvent_Event() {}

func (*LoginEvent_FidoRequested) isLoginEvent_Event() {}

func (*LoginEvent_TfaOrFidoRequested) isLoginEvent_Event() {}

func (*LoginEvent_LoginFidoTouchRequested) isLoginEvent_Event() {}

func (*LoginEvent_LoginFidoTouchCompleted) isLoginEvent_Event() {}

func (*LoginEvent_LoginFidoPinRequired) isLoginEvent_Event() {}

type LoginErrorEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Type          LoginErrorType         `protobuf:"varint,1,opt,name=type,proto3,enum=grpc.LoginErrorType" json:"type,omitempty"`
	Message       string                 `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LoginErrorEvent) Reset() {
	*x = LoginErrorEvent{}
	mi := &file_bridge_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoginErrorEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoginErrorEvent) ProtoMessage() {}

func (x *LoginErrorEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoginErrorEvent.ProtoReflect.Descriptor instead.
func (*LoginErrorEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{31}
}

func (x *LoginErrorEvent) GetType() LoginErrorType {
	if x != nil {
		return x.Type
	}
	return LoginErrorType_USERNAME_PASSWORD_ERROR
}

func (x *LoginErrorEvent) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

type LoginTfaRequestedEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Username      string                 `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LoginTfaRequestedEvent) Reset() {
	*x = LoginTfaRequestedEvent{}
	mi := &file_bridge_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoginTfaRequestedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoginTfaRequestedEvent) ProtoMessage() {}

func (x *LoginTfaRequestedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoginTfaRequestedEvent.ProtoReflect.Descriptor instead.
func (*LoginTfaRequestedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{32}
}

func (x *LoginTfaRequestedEvent) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

type LoginFidoRequestedEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Username      string                 `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LoginFidoRequestedEvent) Reset() {
	*x = LoginFidoRequestedEvent{}
	mi := &file_bridge_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoginFidoRequestedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoginFidoRequestedEvent) ProtoMessage() {}

func (x *LoginFidoRequestedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoginFidoRequestedEvent.ProtoReflect.Descriptor instead.
func (*LoginFidoRequestedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{33}
}

func (x *LoginFidoRequestedEvent) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

type LoginTfaOrFidoRequestedEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Username      string                 `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LoginTfaOrFidoRequestedEvent) Reset() {
	*x = LoginTfaOrFidoRequestedEvent{}
	mi := &file_bridge_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoginTfaOrFidoRequestedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoginTfaOrFidoRequestedEvent) ProtoMessage() {}

func (x *LoginTfaOrFidoRequestedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoginTfaOrFidoRequestedEvent.ProtoReflect.Descriptor instead.
func (*LoginTfaOrFidoRequestedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{34}
}

func (x *LoginTfaOrFidoRequestedEvent) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

type LoginFidoTouchEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Username      string                 `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LoginFidoTouchEvent) Reset() {
	*x = LoginFidoTouchEvent{}
	mi := &file_bridge_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoginFidoTouchEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoginFidoTouchEvent) ProtoMessage() {}

func (x *LoginFidoTouchEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoginFidoTouchEvent.ProtoReflect.Descriptor instead.
func (*LoginFidoTouchEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{35}
}

func (x *LoginFidoTouchEvent) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

type LoginFidoPinRequired struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Username      string                 `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LoginFidoPinRequired) Reset() {
	*x = LoginFidoPinRequired{}
	mi := &file_bridge_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoginFidoPinRequired) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoginFidoPinRequired) ProtoMessage() {}

func (x *LoginFidoPinRequired) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoginFidoPinRequired.ProtoReflect.Descriptor instead.
func (*LoginFidoPinRequired) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{36}
}

func (x *LoginFidoPinRequired) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

type LoginTwoPasswordsRequestedEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Username      string                 `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LoginTwoPasswordsRequestedEvent) Reset() {
	*x = LoginTwoPasswordsRequestedEvent{}
	mi := &file_bridge_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoginTwoPasswordsRequestedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoginTwoPasswordsRequestedEvent) ProtoMessage() {}

func (x *LoginTwoPasswordsRequestedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoginTwoPasswordsRequestedEvent.ProtoReflect.Descriptor instead.
func (*LoginTwoPasswordsRequestedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{37}
}

func (x *LoginTwoPasswordsRequestedEvent) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

type LoginFinishedEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UserID        string                 `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID,omitempty"`
	WasSignedOut  bool                   `protobuf:"varint,2,opt,name=wasSignedOut,proto3" json:"wasSignedOut,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LoginFinishedEvent) Reset() {
	*x = LoginFinishedEvent{}
	mi := &file_bridge_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoginFinishedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoginFinishedEvent) ProtoMessage() {}

func (x *LoginFinishedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoginFinishedEvent.ProtoReflect.Descriptor instead.
func (*LoginFinishedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{38}
}

func (x *LoginFinishedEvent) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *LoginFinishedEvent) GetWasSignedOut() bool {
	if x != nil {
		return x.WasSignedOut
	}
	return false
}

type LoginHvRequestedEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	HvUrl         string                 `protobuf:"bytes,1,opt,name=hvUrl,proto3" json:"hvUrl,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LoginHvRequestedEvent) Reset() {
	*x = LoginHvRequestedEvent{}
	mi := &file_bridge_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoginHvRequestedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoginHvRequestedEvent) ProtoMessage() {}

func (x *LoginHvRequestedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoginHvRequestedEvent.ProtoReflect.Descriptor instead.
func (*LoginHvRequestedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{39}
}

func (x *LoginHvRequestedEvent) GetHvUrl() string {
	if x != nil {
		return x.HvUrl
	}
	return ""
}

// **********************************************************
// Update related events
// **********************************************************
type UpdateEvent struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Event:
	//
	//	*UpdateEvent_Error
	//	*UpdateEvent_ManualReady
	//	*UpdateEvent_ManualRestartNeeded
	//	*UpdateEvent_Force
	//	*UpdateEvent_SilentRestartNeeded
	//	*UpdateEvent_IsLatestVersion
	//	*UpdateEvent_CheckFinished
	//	*UpdateEvent_VersionChanged
	Event         isUpdateEvent_Event `protobuf_oneof:"event"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateEvent) Reset() {
	*x = UpdateEvent{}
	mi := &file_bridge_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateEvent) ProtoMessage() {}

func (x *UpdateEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateEvent.ProtoReflect.Descriptor instead.
func (*UpdateEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{40}
}

func (x *UpdateEvent) GetEvent() isUpdateEvent_Event {
	if x != nil {
		return x.Event
	}
	return nil
}

func (x *UpdateEvent) GetError() *UpdateErrorEvent {
	if x != nil {
		if x, ok := x.Event.(*UpdateEvent_Error); ok {
			return x.Error
		}
	}
	return nil
}

func (x *UpdateEvent) GetManualReady() *UpdateManualReadyEvent {
	if x != nil {
		if x, ok := x.Event.(*UpdateEvent_ManualReady); ok {
			return x.ManualReady
		}
	}
	return nil
}

func (x *UpdateEvent) GetManualRestartNeeded() *UpdateManualRestartNeededEvent {
	if x != nil {
		if x, ok := x.Event.(*UpdateEvent_ManualRestartNeeded); ok {
			return x.ManualRestartNeeded
		}
	}
	return nil
}

func (x *UpdateEvent) GetForce() *UpdateForceEvent {
	if x != nil {
		if x, ok := x.Event.(*UpdateEvent_Force); ok {
			return x.Force
		}
	}
	return nil
}

func (x *UpdateEvent) GetSilentRestartNeeded() *UpdateSilentRestartNeeded {
	if x != nil {
		if x, ok := x.Event.(*UpdateEvent_SilentRestartNeeded); ok {
			return x.SilentRestartNeeded
		}
	}
	return nil
}

func (x *UpdateEvent) GetIsLatestVersion() *UpdateIsLatestVersion {
	if x != nil {
		if x, ok := x.Event.(*UpdateEvent_IsLatestVersion); ok {
			return x.IsLatestVersion
		}
	}
	return nil
}

func (x *UpdateEvent) GetCheckFinished() *UpdateCheckFinished {
	if x != nil {
		if x, ok := x.Event.(*UpdateEvent_CheckFinished); ok {
			return x.CheckFinished
		}
	}
	return nil
}

func (x *UpdateEvent) GetVersionChanged() *UpdateVersionChanged {
	if x != nil {
		if x, ok := x.Event.(*UpdateEvent_VersionChanged); ok {
			return x.VersionChanged
		}
	}
	return nil
}

type isUpdateEvent_Event interface {
	isUpdateEvent_Event()
}

type UpdateEvent_Error struct {
	Error *UpdateErrorEvent `protobuf:"bytes,1,opt,name=error,proto3,oneof"`
}

type UpdateEvent_ManualReady struct {
	ManualReady *UpdateManualReadyEvent `protobuf:"bytes,2,opt,name=manualReady,proto3,oneof"`
}

type UpdateEvent_ManualRestartNeeded struct {
	ManualRestartNeeded *UpdateManualRestartNeededEvent `protobuf:"bytes,3,opt,name=manualRestartNeeded,proto3,oneof"`
}

type UpdateEvent_Force struct {
	Force *UpdateForceEvent `protobuf:"bytes,4,opt,name=force,proto3,oneof"`
}

type UpdateEvent_SilentRestartNeeded struct {
	SilentRestartNeeded *UpdateSilentRestartNeeded `protobuf:"bytes,5,opt,name=silentRestartNeeded,proto3,oneof"`
}

type UpdateEvent_IsLatestVersion struct {
	IsLatestVersion *UpdateIsLatestVersion `protobuf:"bytes,6,opt,name=isLatestVersion,proto3,oneof"`
}

type UpdateEvent_CheckFinished struct {
	CheckFinished *UpdateCheckFinished `protobuf:"bytes,7,opt,name=checkFinished,proto3,oneof"`
}

type UpdateEvent_VersionChanged struct {
	VersionChanged *UpdateVersionChanged `protobuf:"bytes,8,opt,name=versionChanged,proto3,oneof"`
}

func (*UpdateEvent_Error) isUpdateEvent_Event() {}

func (*UpdateEvent_ManualReady) isUpdateEvent_Event() {}

func (*UpdateEvent_ManualRestartNeeded) isUpdateEvent_Event() {}

func (*UpdateEvent_Force) isUpdateEvent_Event() {}

func (*UpdateEvent_SilentRestartNeeded) isUpdateEvent_Event() {}

func (*UpdateEvent_IsLatestVersion) isUpdateEvent_Event() {}

func (*UpdateEvent_CheckFinished) isUpdateEvent_Event() {}

func (*UpdateEvent_VersionChanged) isUpdateEvent_Event() {}

type UpdateErrorEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Type          UpdateErrorType        `protobuf:"varint,1,opt,name=type,proto3,enum=grpc.UpdateErrorType" json:"type,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateErrorEvent) Reset() {
	*x = UpdateErrorEvent{}
	mi := &file_bridge_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateErrorEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateErrorEvent) ProtoMessage() {}

func (x *UpdateErrorEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateErrorEvent.ProtoReflect.Descriptor instead.
func (*UpdateErrorEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{41}
}

func (x *UpdateErrorEvent) GetType() UpdateErrorType {
	if x != nil {
		return x.Type
	}
	return UpdateErrorType_UPDATE_MANUAL_ERROR
}

type UpdateManualReadyEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Version       string                 `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateManualReadyEvent) Reset() {
	*x = UpdateManualReadyEvent{}
	mi := &file_bridge_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateManualReadyEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateManualReadyEvent) ProtoMessage() {}

func (x *UpdateManualReadyEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateManualReadyEvent.ProtoReflect.Descriptor instead.
func (*UpdateManualReadyEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{42}
}

func (x *UpdateManualReadyEvent) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type UpdateManualRestartNeededEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateManualRestartNeededEvent) Reset() {
	*x = UpdateManualRestartNeededEvent{}
	mi := &file_bridge_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateManualRestartNeededEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateManualRestartNeededEvent) ProtoMessage() {}

func (x *UpdateManualRestartNeededEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateManualRestartNeededEvent.ProtoReflect.Descriptor instead.
func (*UpdateManualRestartNeededEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{43}
}

type UpdateForceEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Version       string                 `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateForceEvent) Reset() {
	*x = UpdateForceEvent{}
	mi := &file_bridge_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateForceEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateForceEvent) ProtoMessage() {}

func (x *UpdateForceEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateForceEvent.ProtoReflect.Descriptor instead.
func (*UpdateForceEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{44}
}

func (x *UpdateForceEvent) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type UpdateSilentRestartNeeded struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateSilentRestartNeeded) Reset() {
	*x = UpdateSilentRestartNeeded{}
	mi := &file_bridge_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateSilentRestartNeeded) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSilentRestartNeeded) ProtoMessage() {}

func (x *UpdateSilentRestartNeeded) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSilentRestartNeeded.ProtoReflect.Descriptor instead.
func (*UpdateSilentRestartNeeded) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{45}
}

type UpdateIsLatestVersion struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateIsLatestVersion) Reset() {
	*x = UpdateIsLatestVersion{}
	mi := &file_bridge_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateIsLatestVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateIsLatestVersion) ProtoMessage() {}

func (x *UpdateIsLatestVersion) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateIsLatestVersion.ProtoReflect.Descriptor instead.
func (*UpdateIsLatestVersion) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{46}
}

type UpdateCheckFinished struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateCheckFinished) Reset() {
	*x = UpdateCheckFinished{}
	mi := &file_bridge_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateCheckFinished) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCheckFinished) ProtoMessage() {}

func (x *UpdateCheckFinished) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCheckFinished.ProtoReflect.Descriptor instead.
func (*UpdateCheckFinished) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{47}
}

type UpdateVersionChanged struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateVersionChanged) Reset() {
	*x = UpdateVersionChanged{}
	mi := &file_bridge_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateVersionChanged) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateVersionChanged) ProtoMessage() {}

func (x *UpdateVersionChanged) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateVersionChanged.ProtoReflect.Descriptor instead.
func (*UpdateVersionChanged) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{48}
}

// **********************************************************
// Cache on disk related events
// **********************************************************
type DiskCacheEvent struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Event:
	//
	//	*DiskCacheEvent_Error
	//	*DiskCacheEvent_PathChanged
	//	*DiskCacheEvent_PathChangeFinished
	Event         isDiskCacheEvent_Event `protobuf_oneof:"event"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DiskCacheEvent) Reset() {
	*x = DiskCacheEvent{}
	mi := &file_bridge_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DiskCacheEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskCacheEvent) ProtoMessage() {}

func (x *DiskCacheEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskCacheEvent.ProtoReflect.Descriptor instead.
func (*DiskCacheEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{49}
}

func (x *DiskCacheEvent) GetEvent() isDiskCacheEvent_Event {
	if x != nil {
		return x.Event
	}
	return nil
}

func (x *DiskCacheEvent) GetError() *DiskCacheErrorEvent {
	if x != nil {
		if x, ok := x.Event.(*DiskCacheEvent_Error); ok {
			return x.Error
		}
	}
	return nil
}

func (x *DiskCacheEvent) GetPathChanged() *DiskCachePathChangedEvent {
	if x != nil {
		if x, ok := x.Event.(*DiskCacheEvent_PathChanged); ok {
			return x.PathChanged
		}
	}
	return nil
}

func (x *DiskCacheEvent) GetPathChangeFinished() *DiskCachePathChangeFinishedEvent {
	if x != nil {
		if x, ok := x.Event.(*DiskCacheEvent_PathChangeFinished); ok {
			return x.PathChangeFinished
		}
	}
	return nil
}

type isDiskCacheEvent_Event interface {
	isDiskCacheEvent_Event()
}

type DiskCacheEvent_Error struct {
	Error *DiskCacheErrorEvent `protobuf:"bytes,1,opt,name=error,proto3,oneof"`
}

type DiskCacheEvent_PathChanged struct {
	PathChanged *DiskCachePathChangedEvent `protobuf:"bytes,2,opt,name=pathChanged,proto3,oneof"`
}

type DiskCacheEvent_PathChangeFinished struct {
	PathChangeFinished *DiskCachePathChangeFinishedEvent `protobuf:"bytes,3,opt,name=pathChangeFinished,proto3,oneof"`
}

func (*DiskCacheEvent_Error) isDiskCacheEvent_Event() {}

func (*DiskCacheEvent_PathChanged) isDiskCacheEvent_Event() {}

func (*DiskCacheEvent_PathChangeFinished) isDiskCacheEvent_Event() {}

type DiskCacheErrorEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Type          DiskCacheErrorType     `protobuf:"varint,1,opt,name=type,proto3,enum=grpc.DiskCacheErrorType" json:"type,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DiskCacheErrorEvent) Reset() {
	*x = DiskCacheErrorEvent{}
	mi := &file_bridge_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DiskCacheErrorEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskCacheErrorEvent) ProtoMessage() {}

func (x *DiskCacheErrorEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskCacheErrorEvent.ProtoReflect.Descriptor instead.
func (*DiskCacheErrorEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{50}
}

func (x *DiskCacheErrorEvent) GetType() DiskCacheErrorType {
	if x != nil {
		return x.Type
	}
	return DiskCacheErrorType_CANT_MOVE_DISK_CACHE_ERROR
}

type DiskCachePathChangedEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Path          string                 `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DiskCachePathChangedEvent) Reset() {
	*x = DiskCachePathChangedEvent{}
	mi := &file_bridge_proto_msgTypes[51]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DiskCachePathChangedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskCachePathChangedEvent) ProtoMessage() {}

func (x *DiskCachePathChangedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[51]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskCachePathChangedEvent.ProtoReflect.Descriptor instead.
func (*DiskCachePathChangedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{51}
}

func (x *DiskCachePathChangedEvent) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

type DiskCachePathChangeFinishedEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DiskCachePathChangeFinishedEvent) Reset() {
	*x = DiskCachePathChangeFinishedEvent{}
	mi := &file_bridge_proto_msgTypes[52]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DiskCachePathChangeFinishedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskCachePathChangeFinishedEvent) ProtoMessage() {}

func (x *DiskCachePathChangeFinishedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[52]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskCachePathChangeFinishedEvent.ProtoReflect.Descriptor instead.
func (*DiskCachePathChangeFinishedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{52}
}

// **********************************************************
// Mail server settings related events
// **********************************************************
type MailServerSettingsEvent struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Event:
	//
	//	*MailServerSettingsEvent_Error
	//	*MailServerSettingsEvent_MailServerSettingsChanged
	//	*MailServerSettingsEvent_ChangeMailServerSettingsFinished
	Event         isMailServerSettingsEvent_Event `protobuf_oneof:"event"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MailServerSettingsEvent) Reset() {
	*x = MailServerSettingsEvent{}
	mi := &file_bridge_proto_msgTypes[53]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MailServerSettingsEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MailServerSettingsEvent) ProtoMessage() {}

func (x *MailServerSettingsEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[53]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MailServerSettingsEvent.ProtoReflect.Descriptor instead.
func (*MailServerSettingsEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{53}
}

func (x *MailServerSettingsEvent) GetEvent() isMailServerSettingsEvent_Event {
	if x != nil {
		return x.Event
	}
	return nil
}

func (x *MailServerSettingsEvent) GetError() *MailServerSettingsErrorEvent {
	if x != nil {
		if x, ok := x.Event.(*MailServerSettingsEvent_Error); ok {
			return x.Error
		}
	}
	return nil
}

func (x *MailServerSettingsEvent) GetMailServerSettingsChanged() *MailServerSettingsChangedEvent {
	if x != nil {
		if x, ok := x.Event.(*MailServerSettingsEvent_MailServerSettingsChanged); ok {
			return x.MailServerSettingsChanged
		}
	}
	return nil
}

func (x *MailServerSettingsEvent) GetChangeMailServerSettingsFinished() *ChangeMailServerSettingsFinishedEvent {
	if x != nil {
		if x, ok := x.Event.(*MailServerSettingsEvent_ChangeMailServerSettingsFinished); ok {
			return x.ChangeMailServerSettingsFinished
		}
	}
	return nil
}

type isMailServerSettingsEvent_Event interface {
	isMailServerSettingsEvent_Event()
}

type MailServerSettingsEvent_Error struct {
	Error *MailServerSettingsErrorEvent `protobuf:"bytes,1,opt,name=error,proto3,oneof"`
}

type MailServerSettingsEvent_MailServerSettingsChanged struct {
	MailServerSettingsChanged *MailServerSettingsChangedEvent `protobuf:"bytes,2,opt,name=mailServerSettingsChanged,proto3,oneof"`
}

type MailServerSettingsEvent_ChangeMailServerSettingsFinished struct {
	ChangeMailServerSettingsFinished *ChangeMailServerSettingsFinishedEvent `protobuf:"bytes,3,opt,name=changeMailServerSettingsFinished,proto3,oneof"`
}

func (*MailServerSettingsEvent_Error) isMailServerSettingsEvent_Event() {}

func (*MailServerSettingsEvent_MailServerSettingsChanged) isMailServerSettingsEvent_Event() {}

func (*MailServerSettingsEvent_ChangeMailServerSettingsFinished) isMailServerSettingsEvent_Event() {}

type MailServerSettingsErrorEvent struct {
	state         protoimpl.MessageState      `protogen:"open.v1"`
	Type          MailServerSettingsErrorType `protobuf:"varint,1,opt,name=type,proto3,enum=grpc.MailServerSettingsErrorType" json:"type,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MailServerSettingsErrorEvent) Reset() {
	*x = MailServerSettingsErrorEvent{}
	mi := &file_bridge_proto_msgTypes[54]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MailServerSettingsErrorEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MailServerSettingsErrorEvent) ProtoMessage() {}

func (x *MailServerSettingsErrorEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[54]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MailServerSettingsErrorEvent.ProtoReflect.Descriptor instead.
func (*MailServerSettingsErrorEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{54}
}

func (x *MailServerSettingsErrorEvent) GetType() MailServerSettingsErrorType {
	if x != nil {
		return x.Type
	}
	return MailServerSettingsErrorType_IMAP_PORT_STARTUP_ERROR
}

type MailServerSettingsChangedEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Settings      *ImapSmtpSettings      `protobuf:"bytes,1,opt,name=settings,proto3" json:"settings,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MailServerSettingsChangedEvent) Reset() {
	*x = MailServerSettingsChangedEvent{}
	mi := &file_bridge_proto_msgTypes[55]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MailServerSettingsChangedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MailServerSettingsChangedEvent) ProtoMessage() {}

func (x *MailServerSettingsChangedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[55]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MailServerSettingsChangedEvent.ProtoReflect.Descriptor instead.
func (*MailServerSettingsChangedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{55}
}

func (x *MailServerSettingsChangedEvent) GetSettings() *ImapSmtpSettings {
	if x != nil {
		return x.Settings
	}
	return nil
}

type ChangeMailServerSettingsFinishedEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ChangeMailServerSettingsFinishedEvent) Reset() {
	*x = ChangeMailServerSettingsFinishedEvent{}
	mi := &file_bridge_proto_msgTypes[56]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ChangeMailServerSettingsFinishedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeMailServerSettingsFinishedEvent) ProtoMessage() {}

func (x *ChangeMailServerSettingsFinishedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[56]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeMailServerSettingsFinishedEvent.ProtoReflect.Descriptor instead.
func (*ChangeMailServerSettingsFinishedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{56}
}

// **********************************************************
// keychain related events
// **********************************************************
type KeychainEvent struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Event:
	//
	//	*KeychainEvent_ChangeKeychainFinished
	//	*KeychainEvent_HasNoKeychain
	//	*KeychainEvent_RebuildKeychain
	Event         isKeychainEvent_Event `protobuf_oneof:"event"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *KeychainEvent) Reset() {
	*x = KeychainEvent{}
	mi := &file_bridge_proto_msgTypes[57]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KeychainEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeychainEvent) ProtoMessage() {}

func (x *KeychainEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[57]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeychainEvent.ProtoReflect.Descriptor instead.
func (*KeychainEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{57}
}

func (x *KeychainEvent) GetEvent() isKeychainEvent_Event {
	if x != nil {
		return x.Event
	}
	return nil
}

func (x *KeychainEvent) GetChangeKeychainFinished() *ChangeKeychainFinishedEvent {
	if x != nil {
		if x, ok := x.Event.(*KeychainEvent_ChangeKeychainFinished); ok {
			return x.ChangeKeychainFinished
		}
	}
	return nil
}

func (x *KeychainEvent) GetHasNoKeychain() *HasNoKeychainEvent {
	if x != nil {
		if x, ok := x.Event.(*KeychainEvent_HasNoKeychain); ok {
			return x.HasNoKeychain
		}
	}
	return nil
}

func (x *KeychainEvent) GetRebuildKeychain() *RebuildKeychainEvent {
	if x != nil {
		if x, ok := x.Event.(*KeychainEvent_RebuildKeychain); ok {
			return x.RebuildKeychain
		}
	}
	return nil
}

type isKeychainEvent_Event interface {
	isKeychainEvent_Event()
}

type KeychainEvent_ChangeKeychainFinished struct {
	ChangeKeychainFinished *ChangeKeychainFinishedEvent `protobuf:"bytes,1,opt,name=changeKeychainFinished,proto3,oneof"`
}

type KeychainEvent_HasNoKeychain struct {
	HasNoKeychain *HasNoKeychainEvent `protobuf:"bytes,2,opt,name=hasNoKeychain,proto3,oneof"`
}

type KeychainEvent_RebuildKeychain struct {
	RebuildKeychain *RebuildKeychainEvent `protobuf:"bytes,3,opt,name=rebuildKeychain,proto3,oneof"`
}

func (*KeychainEvent_ChangeKeychainFinished) isKeychainEvent_Event() {}

func (*KeychainEvent_HasNoKeychain) isKeychainEvent_Event() {}

func (*KeychainEvent_RebuildKeychain) isKeychainEvent_Event() {}

type ChangeKeychainFinishedEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ChangeKeychainFinishedEvent) Reset() {
	*x = ChangeKeychainFinishedEvent{}
	mi := &file_bridge_proto_msgTypes[58]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ChangeKeychainFinishedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeKeychainFinishedEvent) ProtoMessage() {}

func (x *ChangeKeychainFinishedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[58]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeKeychainFinishedEvent.ProtoReflect.Descriptor instead.
func (*ChangeKeychainFinishedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{58}
}

type HasNoKeychainEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HasNoKeychainEvent) Reset() {
	*x = HasNoKeychainEvent{}
	mi := &file_bridge_proto_msgTypes[59]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HasNoKeychainEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HasNoKeychainEvent) ProtoMessage() {}

func (x *HasNoKeychainEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[59]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HasNoKeychainEvent.ProtoReflect.Descriptor instead.
func (*HasNoKeychainEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{59}
}

type RebuildKeychainEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RebuildKeychainEvent) Reset() {
	*x = RebuildKeychainEvent{}
	mi := &file_bridge_proto_msgTypes[60]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RebuildKeychainEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RebuildKeychainEvent) ProtoMessage() {}

func (x *RebuildKeychainEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[60]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RebuildKeychainEvent.ProtoReflect.Descriptor instead.
func (*RebuildKeychainEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{60}
}

// **********************************************************
// Mail related events
// **********************************************************
type MailEvent struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Event:
	//
	//	*MailEvent_AddressChanged
	//	*MailEvent_AddressChangedLogout
	//	*MailEvent_ApiCertIssue
	Event         isMailEvent_Event `protobuf_oneof:"event"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MailEvent) Reset() {
	*x = MailEvent{}
	mi := &file_bridge_proto_msgTypes[61]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MailEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MailEvent) ProtoMessage() {}

func (x *MailEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[61]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MailEvent.ProtoReflect.Descriptor instead.
func (*MailEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{61}
}

func (x *MailEvent) GetEvent() isMailEvent_Event {
	if x != nil {
		return x.Event
	}
	return nil
}

func (x *MailEvent) GetAddressChanged() *AddressChangedEvent {
	if x != nil {
		if x, ok := x.Event.(*MailEvent_AddressChanged); ok {
			return x.AddressChanged
		}
	}
	return nil
}

func (x *MailEvent) GetAddressChangedLogout() *AddressChangedLogoutEvent {
	if x != nil {
		if x, ok := x.Event.(*MailEvent_AddressChangedLogout); ok {
			return x.AddressChangedLogout
		}
	}
	return nil
}

func (x *MailEvent) GetApiCertIssue() *ApiCertIssueEvent {
	if x != nil {
		if x, ok := x.Event.(*MailEvent_ApiCertIssue); ok {
			return x.ApiCertIssue
		}
	}
	return nil
}

type isMailEvent_Event interface {
	isMailEvent_Event()
}

type MailEvent_AddressChanged struct {
	AddressChanged *AddressChangedEvent `protobuf:"bytes,1,opt,name=addressChanged,proto3,oneof"`
}

type MailEvent_AddressChangedLogout struct {
	AddressChangedLogout *AddressChangedLogoutEvent `protobuf:"bytes,2,opt,name=addressChangedLogout,proto3,oneof"`
}

type MailEvent_ApiCertIssue struct {
	ApiCertIssue *ApiCertIssueEvent `protobuf:"bytes,3,opt,name=apiCertIssue,proto3,oneof"`
}

func (*MailEvent_AddressChanged) isMailEvent_Event() {}

func (*MailEvent_AddressChangedLogout) isMailEvent_Event() {}

func (*MailEvent_ApiCertIssue) isMailEvent_Event() {}

type AddressChangedEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Address       string                 `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AddressChangedEvent) Reset() {
	*x = AddressChangedEvent{}
	mi := &file_bridge_proto_msgTypes[62]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddressChangedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddressChangedEvent) ProtoMessage() {}

func (x *AddressChangedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[62]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddressChangedEvent.ProtoReflect.Descriptor instead.
func (*AddressChangedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{62}
}

func (x *AddressChangedEvent) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

type AddressChangedLogoutEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Address       string                 `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AddressChangedLogoutEvent) Reset() {
	*x = AddressChangedLogoutEvent{}
	mi := &file_bridge_proto_msgTypes[63]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddressChangedLogoutEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddressChangedLogoutEvent) ProtoMessage() {}

func (x *AddressChangedLogoutEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[63]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddressChangedLogoutEvent.ProtoReflect.Descriptor instead.
func (*AddressChangedLogoutEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{63}
}

func (x *AddressChangedLogoutEvent) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

type ApiCertIssueEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ApiCertIssueEvent) Reset() {
	*x = ApiCertIssueEvent{}
	mi := &file_bridge_proto_msgTypes[64]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApiCertIssueEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApiCertIssueEvent) ProtoMessage() {}

func (x *ApiCertIssueEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[64]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApiCertIssueEvent.ProtoReflect.Descriptor instead.
func (*ApiCertIssueEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{64}
}

type UserEvent struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Event:
	//
	//	*UserEvent_ToggleSplitModeFinished
	//	*UserEvent_UserDisconnected
	//	*UserEvent_UserChanged
	//	*UserEvent_UserBadEvent
	//	*UserEvent_UsedBytesChangedEvent
	//	*UserEvent_ImapLoginFailedEvent
	//	*UserEvent_SyncStartedEvent
	//	*UserEvent_SyncFinishedEvent
	//	*UserEvent_SyncProgressEvent
	Event         isUserEvent_Event `protobuf_oneof:"event"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UserEvent) Reset() {
	*x = UserEvent{}
	mi := &file_bridge_proto_msgTypes[65]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserEvent) ProtoMessage() {}

func (x *UserEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[65]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserEvent.ProtoReflect.Descriptor instead.
func (*UserEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{65}
}

func (x *UserEvent) GetEvent() isUserEvent_Event {
	if x != nil {
		return x.Event
	}
	return nil
}

func (x *UserEvent) GetToggleSplitModeFinished() *ToggleSplitModeFinishedEvent {
	if x != nil {
		if x, ok := x.Event.(*UserEvent_ToggleSplitModeFinished); ok {
			return x.ToggleSplitModeFinished
		}
	}
	return nil
}

func (x *UserEvent) GetUserDisconnected() *UserDisconnectedEvent {
	if x != nil {
		if x, ok := x.Event.(*UserEvent_UserDisconnected); ok {
			return x.UserDisconnected
		}
	}
	return nil
}

func (x *UserEvent) GetUserChanged() *UserChangedEvent {
	if x != nil {
		if x, ok := x.Event.(*UserEvent_UserChanged); ok {
			return x.UserChanged
		}
	}
	return nil
}

func (x *UserEvent) GetUserBadEvent() *UserBadEvent {
	if x != nil {
		if x, ok := x.Event.(*UserEvent_UserBadEvent); ok {
			return x.UserBadEvent
		}
	}
	return nil
}

func (x *UserEvent) GetUsedBytesChangedEvent() *UsedBytesChangedEvent {
	if x != nil {
		if x, ok := x.Event.(*UserEvent_UsedBytesChangedEvent); ok {
			return x.UsedBytesChangedEvent
		}
	}
	return nil
}

func (x *UserEvent) GetImapLoginFailedEvent() *ImapLoginFailedEvent {
	if x != nil {
		if x, ok := x.Event.(*UserEvent_ImapLoginFailedEvent); ok {
			return x.ImapLoginFailedEvent
		}
	}
	return nil
}

func (x *UserEvent) GetSyncStartedEvent() *SyncStartedEvent {
	if x != nil {
		if x, ok := x.Event.(*UserEvent_SyncStartedEvent); ok {
			return x.SyncStartedEvent
		}
	}
	return nil
}

func (x *UserEvent) GetSyncFinishedEvent() *SyncFinishedEvent {
	if x != nil {
		if x, ok := x.Event.(*UserEvent_SyncFinishedEvent); ok {
			return x.SyncFinishedEvent
		}
	}
	return nil
}

func (x *UserEvent) GetSyncProgressEvent() *SyncProgressEvent {
	if x != nil {
		if x, ok := x.Event.(*UserEvent_SyncProgressEvent); ok {
			return x.SyncProgressEvent
		}
	}
	return nil
}

type isUserEvent_Event interface {
	isUserEvent_Event()
}

type UserEvent_ToggleSplitModeFinished struct {
	ToggleSplitModeFinished *ToggleSplitModeFinishedEvent `protobuf:"bytes,1,opt,name=toggleSplitModeFinished,proto3,oneof"`
}

type UserEvent_UserDisconnected struct {
	UserDisconnected *UserDisconnectedEvent `protobuf:"bytes,2,opt,name=userDisconnected,proto3,oneof"`
}

type UserEvent_UserChanged struct {
	UserChanged *UserChangedEvent `protobuf:"bytes,3,opt,name=userChanged,proto3,oneof"`
}

type UserEvent_UserBadEvent struct {
	UserBadEvent *UserBadEvent `protobuf:"bytes,4,opt,name=userBadEvent,proto3,oneof"`
}

type UserEvent_UsedBytesChangedEvent struct {
	UsedBytesChangedEvent *UsedBytesChangedEvent `protobuf:"bytes,5,opt,name=usedBytesChangedEvent,proto3,oneof"`
}

type UserEvent_ImapLoginFailedEvent struct {
	ImapLoginFailedEvent *ImapLoginFailedEvent `protobuf:"bytes,6,opt,name=imapLoginFailedEvent,proto3,oneof"`
}

type UserEvent_SyncStartedEvent struct {
	SyncStartedEvent *SyncStartedEvent `protobuf:"bytes,7,opt,name=syncStartedEvent,proto3,oneof"`
}

type UserEvent_SyncFinishedEvent struct {
	SyncFinishedEvent *SyncFinishedEvent `protobuf:"bytes,8,opt,name=syncFinishedEvent,proto3,oneof"`
}

type UserEvent_SyncProgressEvent struct {
	SyncProgressEvent *SyncProgressEvent `protobuf:"bytes,9,opt,name=syncProgressEvent,proto3,oneof"`
}

func (*UserEvent_ToggleSplitModeFinished) isUserEvent_Event() {}

func (*UserEvent_UserDisconnected) isUserEvent_Event() {}

func (*UserEvent_UserChanged) isUserEvent_Event() {}

func (*UserEvent_UserBadEvent) isUserEvent_Event() {}

func (*UserEvent_UsedBytesChangedEvent) isUserEvent_Event() {}

func (*UserEvent_ImapLoginFailedEvent) isUserEvent_Event() {}

func (*UserEvent_SyncStartedEvent) isUserEvent_Event() {}

func (*UserEvent_SyncFinishedEvent) isUserEvent_Event() {}

func (*UserEvent_SyncProgressEvent) isUserEvent_Event() {}

type ToggleSplitModeFinishedEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UserID        string                 `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ToggleSplitModeFinishedEvent) Reset() {
	*x = ToggleSplitModeFinishedEvent{}
	mi := &file_bridge_proto_msgTypes[66]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToggleSplitModeFinishedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToggleSplitModeFinishedEvent) ProtoMessage() {}

func (x *ToggleSplitModeFinishedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[66]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToggleSplitModeFinishedEvent.ProtoReflect.Descriptor instead.
func (*ToggleSplitModeFinishedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{66}
}

func (x *ToggleSplitModeFinishedEvent) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

type UserDisconnectedEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Username      string                 `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UserDisconnectedEvent) Reset() {
	*x = UserDisconnectedEvent{}
	mi := &file_bridge_proto_msgTypes[67]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserDisconnectedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserDisconnectedEvent) ProtoMessage() {}

func (x *UserDisconnectedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[67]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserDisconnectedEvent.ProtoReflect.Descriptor instead.
func (*UserDisconnectedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{67}
}

func (x *UserDisconnectedEvent) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

type UserChangedEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UserID        string                 `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UserChangedEvent) Reset() {
	*x = UserChangedEvent{}
	mi := &file_bridge_proto_msgTypes[68]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserChangedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserChangedEvent) ProtoMessage() {}

func (x *UserChangedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[68]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserChangedEvent.ProtoReflect.Descriptor instead.
func (*UserChangedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{68}
}

func (x *UserChangedEvent) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

type UserBadEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UserID        string                 `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID,omitempty"`
	ErrorMessage  string                 `protobuf:"bytes,2,opt,name=errorMessage,proto3" json:"errorMessage,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UserBadEvent) Reset() {
	*x = UserBadEvent{}
	mi := &file_bridge_proto_msgTypes[69]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserBadEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserBadEvent) ProtoMessage() {}

func (x *UserBadEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[69]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserBadEvent.ProtoReflect.Descriptor instead.
func (*UserBadEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{69}
}

func (x *UserBadEvent) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *UserBadEvent) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

type UsedBytesChangedEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UserID        string                 `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID,omitempty"`
	UsedBytes     int64                  `protobuf:"varint,2,opt,name=usedBytes,proto3" json:"usedBytes,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UsedBytesChangedEvent) Reset() {
	*x = UsedBytesChangedEvent{}
	mi := &file_bridge_proto_msgTypes[70]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UsedBytesChangedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UsedBytesChangedEvent) ProtoMessage() {}

func (x *UsedBytesChangedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[70]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UsedBytesChangedEvent.ProtoReflect.Descriptor instead.
func (*UsedBytesChangedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{70}
}

func (x *UsedBytesChangedEvent) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *UsedBytesChangedEvent) GetUsedBytes() int64 {
	if x != nil {
		return x.UsedBytes
	}
	return 0
}

type ImapLoginFailedEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Username      string                 `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ImapLoginFailedEvent) Reset() {
	*x = ImapLoginFailedEvent{}
	mi := &file_bridge_proto_msgTypes[71]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImapLoginFailedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImapLoginFailedEvent) ProtoMessage() {}

func (x *ImapLoginFailedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[71]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImapLoginFailedEvent.ProtoReflect.Descriptor instead.
func (*ImapLoginFailedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{71}
}

func (x *ImapLoginFailedEvent) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

type SyncStartedEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UserID        string                 `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SyncStartedEvent) Reset() {
	*x = SyncStartedEvent{}
	mi := &file_bridge_proto_msgTypes[72]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncStartedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncStartedEvent) ProtoMessage() {}

func (x *SyncStartedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[72]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncStartedEvent.ProtoReflect.Descriptor instead.
func (*SyncStartedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{72}
}

func (x *SyncStartedEvent) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

type SyncFinishedEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UserID        string                 `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SyncFinishedEvent) Reset() {
	*x = SyncFinishedEvent{}
	mi := &file_bridge_proto_msgTypes[73]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncFinishedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncFinishedEvent) ProtoMessage() {}

func (x *SyncFinishedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[73]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncFinishedEvent.ProtoReflect.Descriptor instead.
func (*SyncFinishedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{73}
}

func (x *SyncFinishedEvent) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

type SyncProgressEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UserID        string                 `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID,omitempty"`
	Progress      float64                `protobuf:"fixed64,2,opt,name=progress,proto3" json:"progress,omitempty"`
	ElapsedMs     int64                  `protobuf:"varint,3,opt,name=elapsedMs,proto3" json:"elapsedMs,omitempty"`
	RemainingMs   int64                  `protobuf:"varint,4,opt,name=remainingMs,proto3" json:"remainingMs,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SyncProgressEvent) Reset() {
	*x = SyncProgressEvent{}
	mi := &file_bridge_proto_msgTypes[74]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncProgressEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncProgressEvent) ProtoMessage() {}

func (x *SyncProgressEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[74]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncProgressEvent.ProtoReflect.Descriptor instead.
func (*SyncProgressEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{74}
}

func (x *SyncProgressEvent) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *SyncProgressEvent) GetProgress() float64 {
	if x != nil {
		return x.Progress
	}
	return 0
}

func (x *SyncProgressEvent) GetElapsedMs() int64 {
	if x != nil {
		return x.ElapsedMs
	}
	return 0
}

func (x *SyncProgressEvent) GetRemainingMs() int64 {
	if x != nil {
		return x.RemainingMs
	}
	return 0
}

type UserNotificationEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Title         string                 `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	Subtitle      string                 `protobuf:"bytes,2,opt,name=subtitle,proto3" json:"subtitle,omitempty"`
	Body          string                 `protobuf:"bytes,3,opt,name=body,proto3" json:"body,omitempty"`
	UserID        string                 `protobuf:"bytes,4,opt,name=userID,proto3" json:"userID,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UserNotificationEvent) Reset() {
	*x = UserNotificationEvent{}
	mi := &file_bridge_proto_msgTypes[75]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserNotificationEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserNotificationEvent) ProtoMessage() {}

func (x *UserNotificationEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[75]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserNotificationEvent.ProtoReflect.Descriptor instead.
func (*UserNotificationEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{75}
}

func (x *UserNotificationEvent) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *UserNotificationEvent) GetSubtitle() string {
	if x != nil {
		return x.Subtitle
	}
	return ""
}

func (x *UserNotificationEvent) GetBody() string {
	if x != nil {
		return x.Body
	}
	return ""
}

func (x *UserNotificationEvent) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

type GenericErrorEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Code          ErrorCode              `protobuf:"varint,1,opt,name=code,proto3,enum=grpc.ErrorCode" json:"code,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GenericErrorEvent) Reset() {
	*x = GenericErrorEvent{}
	mi := &file_bridge_proto_msgTypes[76]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenericErrorEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenericErrorEvent) ProtoMessage() {}

func (x *GenericErrorEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[76]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenericErrorEvent.ProtoReflect.Descriptor instead.
func (*GenericErrorEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{76}
}

func (x *GenericErrorEvent) GetCode() ErrorCode {
	if x != nil {
		return x.Code
	}
	return ErrorCode_UNKNOWN_ERROR
}

var File_bridge_proto protoreflect.FileDescriptor

const file_bridge_proto_rawDesc = "" +
	"\n" +
	"\fbridge.proto\x12\x04grpc\x1a\x1bgoogle/protobuf/empty.proto\x1a\x1egoogle/protobuf/wrappers.proto\"n\n" +
	"\x12AddLogEntryRequest\x12$\n" +
	"\x05level\x18\x01 \x01(\x0e2\x0e.grpc.LogLevelR\x05level\x12\x18\n" +
	"\apackage\x18\x02 \x01(\tR\apackage\x12\x18\n" +
	"\amessage\x18\x03 \x01(\tR\amessage\">\n" +
	"\x10GuiReadyResponse\x12*\n" +
	"\x10showSplashScreen\x18\x01 \x01(\bR\x10showSplashScreen\"\xde\x01\n" +
	"\x10ReportBugRequest\x12\x16\n" +
	"\x06osType\x18\x01 \x01(\tR\x06osType\x12\x1c\n" +
	"\tosVersion\x18\x02 \x01(\tR\tosVersion\x12\x14\n" +
	"\x05title\x18\x03 \x01(\tR\x05title\x12 \n" +
	"\vdescription\x18\x04 \x01(\tR\vdescription\x12\x18\n" +
	"\aaddress\x18\x05 \x01(\tR\aaddress\x12 \n" +
	"\vemailClient\x18\x06 \x01(\tR\vemailClient\x12 \n" +
	"\vincludeLogs\x18\a \x01(\bR\vincludeLogs\"\x80\x01\n" +
	"\fLoginRequest\x12\x1a\n" +
	"\busername\x18\x01 \x01(\tR\busername\x12\x1a\n" +
	"\bpassword\x18\x02 \x01(\fR\bpassword\x12'\n" +
	"\fuseHvDetails\x18\x03 \x01(\bH\x00R\fuseHvDetails\x88\x01\x01B\x0f\n" +
	"\r_useHvDetails\"/\n" +
	"\x11LoginAbortRequest\x12\x1a\n" +
	"\busername\x18\x01 \x01(\tR\busername\"\x96\x01\n" +
	"\x10ImapSmtpSettings\x12\x1a\n" +
	"\bimapPort\x18\x01 \x01(\x05R\bimapPort\x12\x1a\n" +
	"\bsmtpPort\x18\x02 \x01(\x05R\bsmtpPort\x12$\n" +
	"\ruseSSLForImap\x18\x03 \x01(\bR\ruseSSLForImap\x12$\n" +
	"\ruseSSLForSmtp\x18\x04 \x01(\bR\ruseSSLForSmtp\":\n" +
	"\x1aAvailableKeychainsResponse\x12\x1c\n" +
	"\tkeychains\x18\x01 \x03(\tR\tkeychains\"\x8f\x02\n" +
	"\x04User\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x1a\n" +
	"\busername\x18\x02 \x01(\tR\busername\x12\x1e\n" +
	"\n" +
	"avatarText\x18\x03 \x01(\tR\n" +
	"avatarText\x12%\n" +
	"\x05state\x18\x04 \x01(\x0e2\x0f.grpc.UserStateR\x05state\x12\x1c\n" +
	"\tsplitMode\x18\x05 \x01(\bR\tsplitMode\x12\x1c\n" +
	"\tusedBytes\x18\x06 \x01(\x03R\tusedBytes\x12\x1e\n" +
	"\n" +
	"totalBytes\x18\a \x01(\x03R\n" +
	"totalBytes\x12\x1a\n" +
	"\bpassword\x18\b \x01(\fR\bpassword\x12\x1c\n" +
	"\taddresses\x18\t \x03(\tR\taddresses\"F\n" +
	"\x14UserSplitModeRequest\x12\x16\n" +
	"\x06userID\x18\x01 \x01(\tR\x06userID\x12\x16\n" +
	"\x06active\x18\x02 \x01(\bR\x06active\"Q\n" +
	"\x1bUserBadEventFeedbackRequest\x12\x16\n" +
	"\x06userID\x18\x01 \x01(\tR\x06userID\x12\x1a\n" +
	"\bdoResync\x18\x02 \x01(\bR\bdoResync\"4\n" +
	"\x10UserListResponse\x12 \n" +
	"\x05users\x18\x01 \x03(\v2\n" +
	".grpc.UserR\x05users\"M\n" +
	"\x19ConfigureAppleMailRequest\x12\x16\n" +
	"\x06userID\x18\x01 \x01(\tR\x06userID\x12\x18\n" +
	"\aaddress\x18\x02 \x01(\tR\aaddress\"<\n" +
	"\x12EventStreamRequest\x12&\n" +
	"\x0eClientPlatform\x18\x01 \x01(\tR\x0eClientPlatform\"\xd0\x03\n" +
	"\vStreamEvent\x12\"\n" +
	"\x03app\x18\x01 \x01(\v2\x0e.grpc.AppEventH\x00R\x03app\x12(\n" +
	"\x05login\x18\x02 \x01(\v2\x10.grpc.LoginEventH\x00R\x05login\x12+\n" +
	"\x06update\x18\x03 \x01(\v2\x11.grpc.UpdateEventH\x00R\x06update\x12,\n" +
	"\x05cache\x18\x04 \x01(\v2\x14.grpc.DiskCacheEventH\x00R\x05cache\x12O\n" +
	"\x12mailServerSettings\x18\x05 \x01(\v2\x1d.grpc.MailServerSettingsEventH\x00R\x12mailServerSettings\x121\n" +
	"\bkeychain\x18\x06 \x01(\v2\x13.grpc.KeychainEventH\x00R\bkeychain\x12%\n" +
	"\x04mail\x18\a \x01(\v2\x0f.grpc.MailEventH\x00R\x04mail\x12%\n" +
	"\x04user\x18\b \x01(\v2\x0f.grpc.UserEventH\x00R\x04user\x12=\n" +
	"\fgenericError\x18\t \x01(\v2\x17.grpc.GenericErrorEventH\x00R\fgenericErrorB\a\n" +
	"\x05event\"\xd2\t\n" +
	"\bAppEvent\x12C\n" +
	"\x0einternetStatus\x18\x01 \x01(\v2\x19.grpc.InternetStatusEventH\x00R\x0einternetStatus\x12^\n" +
	"\x17toggleAutostartFinished\x18\x02 \x01(\v2\".grpc.ToggleAutostartFinishedEventH\x00R\x17toggleAutostartFinished\x12@\n" +
	"\rresetFinished\x18\x03 \x01(\v2\x18.grpc.ResetFinishedEventH\x00R\rresetFinished\x12L\n" +
	"\x11reportBugFinished\x18\x04 \x01(\v2\x1c.grpc.ReportBugFinishedEventH\x00R\x11reportBugFinished\x12I\n" +
	"\x10reportBugSuccess\x18\x05 \x01(\v2\x1b.grpc.ReportBugSuccessEventH\x00R\x10reportBugSuccess\x12C\n" +
	"\x0ereportBugError\x18\x06 \x01(\v2\x19.grpc.ReportBugErrorEventH\x00R\x0ereportBugError\x12C\n" +
	"\x0eshowMainWindow\x18\a \x01(\v2\x19.grpc.ShowMainWindowEventH\x00R\x0eshowMainWindow\x12L\n" +
	"\x11reportBugFallback\x18\b \x01(\v2\x1c.grpc.ReportBugFallbackEventH\x00R\x11reportBugFallback\x12d\n" +
	"\x19certificateInstallSuccess\x18\t \x01(\v2$.grpc.CertificateInstallSuccessEventH\x00R\x19certificateInstallSuccess\x12g\n" +
	"\x1acertificateInstallCanceled\x18\n" +
	" \x01(\v2%.grpc.CertificateInstallCanceledEventH\x00R\x1acertificateInstallCanceled\x12a\n" +
	"\x18certificateInstallFailed\x18\v \x01(\v2#.grpc.CertificateInstallFailedEventH\x00R\x18certificateInstallFailed\x12a\n" +
	"\x18knowledgeBaseSuggestions\x18\f \x01(\v2#.grpc.KnowledgeBaseSuggestionsEventH\x00R\x18knowledgeBaseSuggestions\x12@\n" +
	"\rrepairStarted\x18\r \x01(\v2\x18.grpc.RepairStartedEventH\x00R\rrepairStarted\x12C\n" +
	"\x0eallUsersLoaded\x18\x0e \x01(\v2\x19.grpc.AllUsersLoadedEventH\x00R\x0eallUsersLoaded\x12I\n" +
	"\x10userNotification\x18\x0f \x01(\v2\x1b.grpc.UserNotificationEventH\x00R\x10userNotificationB\a\n" +
	"\x05event\"3\n" +
	"\x13InternetStatusEvent\x12\x1c\n" +
	"\tconnected\x18\x01 \x01(\bR\tconnected\"\x1e\n" +
	"\x1cToggleAutostartFinishedEvent\"\x14\n" +
	"\x12ResetFinishedEvent\"\x18\n" +
	"\x16ReportBugFinishedEvent\"\x17\n" +
	"\x15ReportBugSuccessEvent\"\x15\n" +
	"\x13ReportBugErrorEvent\"\x15\n" +
	"\x13ShowMainWindowEvent\"\x18\n" +
	"\x16ReportBugFallbackEvent\" \n" +
	"\x1eCertificateInstallSuccessEvent\"!\n" +
	"\x1fCertificateInstallCanceledEvent\"\x1f\n" +
	"\x1dCertificateInstallFailedEvent\"\x14\n" +
	"\x12RepairStartedEvent\"\x15\n" +
	"\x13AllUsersLoadedEvent\"A\n" +
	"\x17KnowledgeBaseSuggestion\x12\x10\n" +
	"\x03url\x18\x01 \x01(\tR\x03url\x12\x14\n" +
	"\x05title\x18\x02 \x01(\tR\x05title\"`\n" +
	"\x1dKnowledgeBaseSuggestionsEvent\x12?\n" +
	"\vsuggestions\x18\x01 \x03(\v2\x1d.grpc.KnowledgeBaseSuggestionR\vsuggestions\"\xc1\x06\n" +
	"\n" +
	"LoginEvent\x12-\n" +
	"\x05error\x18\x01 \x01(\v2\x15.grpc.LoginErrorEventH\x00R\x05error\x12B\n" +
	"\ftfaRequested\x18\x02 \x01(\v2\x1c.grpc.LoginTfaRequestedEventH\x00R\ftfaRequested\x12[\n" +
	"\x14twoPasswordRequested\x18\x03 \x01(\v2%.grpc.LoginTwoPasswordsRequestedEventH\x00R\x14twoPasswordRequested\x126\n" +
	"\bfinished\x18\x04 \x01(\v2\x18.grpc.LoginFinishedEventH\x00R\bfinished\x12D\n" +
	"\x0falreadyLoggedIn\x18\x05 \x01(\v2\x18.grpc.LoginFinishedEventH\x00R\x0falreadyLoggedIn\x12?\n" +
	"\vhvRequested\x18\x06 \x01(\v2\x1b.grpc.LoginHvRequestedEventH\x00R\vhvRequested\x12E\n" +
	"\rfidoRequested\x18\a \x01(\v2\x1d.grpc.LoginFidoRequestedEventH\x00R\rfidoRequested\x12T\n" +
	"\x12tfaOrFidoRequested\x18\b \x01(\v2\".grpc.LoginTfaOrFidoRequestedEventH\x00R\x12tfaOrFidoRequested\x12U\n" +
	"\x17loginFidoTouchRequested\x18\t \x01(\v2\x19.grpc.LoginFidoTouchEventH\x00R\x17loginFidoTouchRequested\x12U\n" +
	"\x17loginFidoTouchCompleted\x18\n" +
	" \x01(\v2\x19.grpc.LoginFidoTouchEventH\x00R\x17loginFidoTouchCompleted\x12P\n" +
	"\x14loginFidoPinRequired\x18\v \x01(\v2\x1a.grpc.LoginFidoPinRequiredH\x00R\x14loginFidoPinRequiredB\a\n" +
	"\x05event\"U\n" +
	"\x0fLoginErrorEvent\x12(\n" +
	"\x04type\x18\x01 \x01(\x0e2\x14.grpc.LoginErrorTypeR\x04type\x12\x18\n" +
	"\amessage\x18\x02 \x01(\tR\amessage\"4\n" +
	"\x16LoginTfaRequestedEvent\x12\x1a\n" +
	"\busername\x18\x01 \x01(\tR\busername\"5\n" +
	"\x17LoginFidoRequestedEvent\x12\x1a\n" +
	"\busername\x18\x01 \x01(\tR\busername\":\n" +
	"\x1cLoginTfaOrFidoRequestedEvent\x12\x1a\n" +
	"\busername\x18\x01 \x01(\tR\busername\"1\n" +
	"\x13LoginFidoTouchEvent\x12\x1a\n" +
	"\busername\x18\x01 \x01(\tR\busername\"2\n" +
	"\x14LoginFidoPinRequired\x12\x1a\n" +
	"\busername\x18\x01 \x01(\tR\busername\"=\n" +
	"\x1fLoginTwoPasswordsRequestedEvent\x12\x1a\n" +
	"\busername\x18\x01 \x01(\tR\busername\"P\n" +
	"\x12LoginFinishedEvent\x12\x16\n" +
	"\x06userID\x18\x01 \x01(\tR\x06userID\x12\"\n" +
	"\fwasSignedOut\x18\x02 \x01(\bR\fwasSignedOut\"-\n" +
	"\x15LoginHvRequestedEvent\x12\x14\n" +
	"\x05hvUrl\x18\x01 \x01(\tR\x05hvUrl\"\xb9\x04\n" +
	"\vUpdateEvent\x12.\n" +
	"\x05error\x18\x01 \x01(\v2\x16.grpc.UpdateErrorEventH\x00R\x05error\x12@\n" +
	"\vmanualReady\x18\x02 \x01(\v2\x1c.grpc.UpdateManualReadyEventH\x00R\vmanualReady\x12X\n" +
	"\x13manualRestartNeeded\x18\x03 \x01(\v2$.grpc.UpdateManualRestartNeededEventH\x00R\x13manualRestartNeeded\x12.\n" +
	"\x05force\x18\x04 \x01(\v2\x16.grpc.UpdateForceEventH\x00R\x05force\x12S\n" +
	"\x13silentRestartNeeded\x18\x05 \x01(\v2\x1f.grpc.UpdateSilentRestartNeededH\x00R\x13silentRestartNeeded\x12G\n" +
	"\x0fisLatestVersion\x18\x06 \x01(\v2\x1b.grpc.UpdateIsLatestVersionH\x00R\x0fisLatestVersion\x12A\n" +
	"\rcheckFinished\x18\a \x01(\v2\x19.grpc.UpdateCheckFinishedH\x00R\rcheckFinished\x12D\n" +
	"\x0eversionChanged\x18\b \x01(\v2\x1a.grpc.UpdateVersionChangedH\x00R\x0eversionChangedB\a\n" +
	"\x05event\"=\n" +
	"\x10UpdateErrorEvent\x12)\n" +
	"\x04type\x18\x01 \x01(\x0e2\x15.grpc.UpdateErrorTypeR\x04type\"2\n" +
	"\x16UpdateManualReadyEvent\x12\x18\n" +
	"\aversion\x18\x01 \x01(\tR\aversion\" \n" +
	"\x1eUpdateManualRestartNeededEvent\",\n" +
	"\x10UpdateForceEvent\x12\x18\n" +
	"\aversion\x18\x01 \x01(\tR\aversion\"\x1b\n" +
	"\x19UpdateSilentRestartNeeded\"\x17\n" +
	"\x15UpdateIsLatestVersion\"\x15\n" +
	"\x13UpdateCheckFinished\"\x16\n" +
	"\x14UpdateVersionChanged\"\xeb\x01\n" +
	"\x0eDiskCacheEvent\x121\n" +
	"\x05error\x18\x01 \x01(\v2\x19.grpc.DiskCacheErrorEventH\x00R\x05error\x12C\n" +
	"\vpathChanged\x18\x02 \x01(\v2\x1f.grpc.DiskCachePathChangedEventH\x00R\vpathChanged\x12X\n" +
	"\x12pathChangeFinished\x18\x03 \x01(\v2&.grpc.DiskCachePathChangeFinishedEventH\x00R\x12pathChangeFinishedB\a\n" +
	"\x05event\"C\n" +
	"\x13DiskCacheErrorEvent\x12,\n" +
	"\x04type\x18\x01 \x01(\x0e2\x18.grpc.DiskCacheErrorTypeR\x04type\"/\n" +
	"\x19DiskCachePathChangedEvent\x12\x12\n" +
	"\x04path\x18\x01 \x01(\tR\x04path\"\"\n" +
	" DiskCachePathChangeFinishedEvent\"\xbf\x02\n" +
	"\x17MailServerSettingsEvent\x12:\n" +
	"\x05error\x18\x01 \x01(\v2\".grpc.MailServerSettingsErrorEventH\x00R\x05error\x12d\n" +
	"\x19mailServerSettingsChanged\x18\x02 \x01(\v2$.grpc.MailServerSettingsChangedEventH\x00R\x19mailServerSettingsChanged\x12y\n" +
	" changeMailServerSettingsFinished\x18\x03 \x01(\v2+.grpc.ChangeMailServerSettingsFinishedEventH\x00R changeMailServerSettingsFinishedB\a\n" +
	"\x05event\"U\n" +
	"\x1cMailServerSettingsErrorEvent\x125\n" +
	"\x04type\x18\x01 \x01(\x0e2!.grpc.MailServerSettingsErrorTypeR\x04type\"T\n" +
	"\x1eMailServerSettingsChangedEvent\x122\n" +
	"\bsettings\x18\x01 \x01(\v2\x16.grpc.ImapSmtpSettingsR\bsettings\"'\n" +
	"%ChangeMailServerSettingsFinishedEvent\"\xff\x01\n" +
	"\rKeychainEvent\x12[\n" +
	"\x16changeKeychainFinished\x18\x01 \x01(\v2!.grpc.ChangeKeychainFinishedEventH\x00R\x16changeKeychainFinished\x12@\n" +
	"\rhasNoKeychain\x18\x02 \x01(\v2\x18.grpc.HasNoKeychainEventH\x00R\rhasNoKeychain\x12F\n" +
	"\x0frebuildKeychain\x18\x03 \x01(\v2\x1a.grpc.RebuildKeychainEventH\x00R\x0frebuildKeychainB\a\n" +
	"\x05event\"\x1d\n" +
	"\x1bChangeKeychainFinishedEvent\"\x14\n" +
	"\x12HasNoKeychainEvent\"\x16\n" +
	"\x14RebuildKeychainEvent\"\xef\x01\n" +
	"\tMailEvent\x12C\n" +
	"\x0eaddressChanged\x18\x01 \x01(\v2\x19.grpc.AddressChangedEventH\x00R\x0eaddressChanged\x12U\n" +
	"\x14addressChangedLogout\x18\x02 \x01(\v2\x1f.grpc.AddressChangedLogoutEventH\x00R\x14addressChangedLogout\x12=\n" +
	"\fapiCertIssue\x18\x03 \x01(\v2\x17.grpc.ApiCertIssueEventH\x00R\fapiCertIssueB\a\n" +
	"\x05event\"/\n" +
	"\x13AddressChangedEvent\x12\x18\n" +
	"\aaddress\x18\x01 \x01(\tR\aaddress\"5\n" +
	"\x19AddressChangedLogoutEvent\x12\x18\n" +
	"\aaddress\x18\x01 \x01(\tR\aaddress\"\x13\n" +
	"\x11ApiCertIssueEvent\"\xb4\x05\n" +
	"\tUserEvent\x12^\n" +
	"\x17toggleSplitModeFinished\x18\x01 \x01(\v2\".grpc.ToggleSplitModeFinishedEventH\x00R\x17toggleSplitModeFinished\x12I\n" +
	"\x10userDisconnected\x18\x02 \x01(\v2\x1b.grpc.UserDisconnectedEventH\x00R\x10userDisconnected\x12:\n" +
	"\vuserChanged\x18\x03 \x01(\v2\x16.grpc.UserChangedEventH\x00R\vuserChanged\x128\n" +
	"\fuserBadEvent\x18\x04 \x01(\v2\x12.grpc.UserBadEventH\x00R\fuserBadEvent\x12S\n" +
	"\x15usedBytesChangedEvent\x18\x05 \x01(\v2\x1b.grpc.UsedBytesChangedEventH\x00R\x15usedBytesChangedEvent\x12P\n" +
	"\x14imapLoginFailedEvent\x18\x06 \x01(\v2\x1a.grpc.ImapLoginFailedEventH\x00R\x14imapLoginFailedEvent\x12D\n" +
	"\x10syncStartedEvent\x18\a \x01(\v2\x16.grpc.SyncStartedEventH\x00R\x10syncStartedEvent\x12G\n" +
	"\x11syncFinishedEvent\x18\b \x01(\v2\x17.grpc.SyncFinishedEventH\x00R\x11syncFinishedEvent\x12G\n" +
	"\x11syncProgressEvent\x18\t \x01(\v2\x17.grpc.SyncProgressEventH\x00R\x11syncProgressEventB\a\n" +
	"\x05event\"6\n" +
	"\x1cToggleSplitModeFinishedEvent\x12\x16\n" +
	"\x06userID\x18\x01 \x01(\tR\x06userID\"3\n" +
	"\x15UserDisconnectedEvent\x12\x1a\n" +
	"\busername\x18\x01 \x01(\tR\busername\"*\n" +
	"\x10UserChangedEvent\x12\x16\n" +
	"\x06userID\x18\x01 \x01(\tR\x06userID\"J\n" +
	"\fUserBadEvent\x12\x16\n" +
	"\x06userID\x18\x01 \x01(\tR\x06userID\x12\"\n" +
	"\ferrorMessage\x18\x02 \x01(\tR\ferrorMessage\"M\n" +
	"\x15UsedBytesChangedEvent\x12\x16\n" +
	"\x06userID\x18\x01 \x01(\tR\x06userID\x12\x1c\n" +
	"\tusedBytes\x18\x02 \x01(\x03R\tusedBytes\"2\n" +
	"\x14ImapLoginFailedEvent\x12\x1a\n" +
	"\busername\x18\x01 \x01(\tR\busername\"*\n" +
	"\x10SyncStartedEvent\x12\x16\n" +
	"\x06userID\x18\x01 \x01(\tR\x06userID\"+\n" +
	"\x11SyncFinishedEvent\x12\x16\n" +
	"\x06userID\x18\x01 \x01(\tR\x06userID\"\x87\x01\n" +
	"\x11SyncProgressEvent\x12\x16\n" +
	"\x06userID\x18\x01 \x01(\tR\x06userID\x12\x1a\n" +
	"\bprogress\x18\x02 \x01(\x01R\bprogress\x12\x1c\n" +
	"\telapsedMs\x18\x03 \x01(\x03R\telapsedMs\x12 \n" +
	"\vremainingMs\x18\x04 \x01(\x03R\vremainingMs\"u\n" +
	"\x15UserNotificationEvent\x12\x14\n" +
	"\x05title\x18\x01 \x01(\tR\x05title\x12\x1a\n" +
	"\bsubtitle\x18\x02 \x01(\tR\bsubtitle\x12\x12\n" +
	"\x04body\x18\x03 \x01(\tR\x04body\x12\x16\n" +
	"\x06userID\x18\x04 \x01(\tR\x06userID\"8\n" +
	"\x11GenericErrorEvent\x12#\n" +
	"\x04code\x18\x01 \x01(\x0e2\x0f.grpc.ErrorCodeR\x04code*q\n" +
	"\bLogLevel\x12\r\n" +
	"\tLOG_PANIC\x10\x00\x12\r\n" +
	"\tLOG_FATAL\x10\x01\x12\r\n" +
	"\tLOG_ERROR\x10\x02\x12\f\n" +
	"\bLOG_WARN\x10\x03\x12\f\n" +
	"\bLOG_INFO\x10\x04\x12\r\n" +
	"\tLOG_DEBUG\x10\x05\x12\r\n" +
	"\tLOG_TRACE\x10\x06*6\n" +
	"\tUserState\x12\x0e\n" +
	"\n" +
	"SIGNED_OUT\x10\x00\x12\n" +
	"\n" +
	"\x06LOCKED\x10\x01\x12\r\n" +
	"\tCONNECTED\x10\x02*\xec\x01\n" +
	"\x0eLoginErrorType\x12\x1b\n" +
	"\x17USERNAME_PASSWORD_ERROR\x10\x00\x12\r\n" +
	"\tFREE_USER\x10\x01\x12\x14\n" +
	"\x10CONNECTION_ERROR\x10\x02\x12\r\n" +
	"\tTFA_ERROR\x10\x03\x12\r\n" +
	"\tTFA_ABORT\x10\x04\x12\x17\n" +
	"\x13TWO_PASSWORDS_ERROR\x10\x05\x12\x17\n" +
	"\x13TWO_PASSWORDS_ABORT\x10\x06\x12\f\n" +
	"\bHV_ERROR\x10\a\x12\x14\n" +
	"\x10FIDO_PIN_INVALID\x10\b\x12\x14\n" +
	"\x10FIDO_PIN_BLOCKED\x10\t\x12\x0e\n" +
	"\n" +
	"FIDO_ERROR\x10\n" +
	"*[\n" +
	"\x0fUpdateErrorType\x12\x17\n" +
	"\x13UPDATE_MANUAL_ERROR\x10\x00\x12\x16\n" +
	"\x12UPDATE_FORCE_ERROR\x10\x01\x12\x17\n" +
	"\x13UPDATE_SILENT_ERROR\x10\x02*4\n" +
	"\x12DiskCacheErrorType\x12\x1e\n" +
	"\x1aCANT_MOVE_DISK_CACHE_ERROR\x10\x00*\xdd\x01\n" +
	"\x1bMailServerSettingsErrorType\x12\x1b\n" +
	"\x17IMAP_PORT_STARTUP_ERROR\x10\x00\x12\x1b\n" +
	"\x17SMTP_PORT_STARTUP_ERROR\x10\x01\x12\x1a\n" +
	"\x16IMAP_PORT_CHANGE_ERROR\x10\x02\x12\x1a\n" +
	"\x16SMTP_PORT_CHANGE_ERROR\x10\x03\x12%\n" +
	"!IMAP_CONNECTION_MODE_CHANGE_ERROR\x10\x04\x12%\n" +
	"!SMTP_CONNECTION_MODE_CHANGE_ERROR\x10\x05*S\n" +
	"\tErrorCode\x12\x11\n" +
	"\rUNKNOWN_ERROR\x10\x00\x12\x19\n" +
	"\x15TLS_CERT_EXPORT_ERROR\x10\x01\x12\x18\n" +
	"\x14TLS_KEY_EXPORT_ERROR\x10\x022\xbd\"\n" +
	"\x06Bridge\x12I\n" +
	"\vCheckTokens\x12\x1c.google.protobuf.StringValue\x1a\x1c.google.protobuf.StringValue\x12?\n" +
	"\vAddLogEntry\x12\x18.grpc.AddLogEntryRequest\x1a\x16.google.protobuf.Empty\x12:\n" +
	"\bGuiReady\x12\x16.google.protobuf.Empty\x1a\x16.grpc.GuiReadyResponse\x126\n" +
	"\x04Quit\x12\x16.google.protobuf.Empty\x1a\x16.google.protobuf.Empty\x129\n" +
	"\aRestart\x12\x16.google.protobuf.Empty\x1a\x16.google.protobuf.Empty\x12C\n" +
	"\rShowOnStartup\x12\x16.google.protobuf.Empty\x1a\x1a.google.protobuf.BoolValue\x12F\n" +
	"\x10SetIsAutostartOn\x12\x1a.google.protobuf.BoolValue\x1a\x16.google.protobuf.Empty\x12C\n" +
	"\rIsAutostartOn\x12\x16.google.protobuf.Empty\x1a\x1a.google.protobuf.BoolValue\x12F\n" +
	"\x10SetIsBetaEnabled\x12\x1a.google.protobuf.BoolValue\x1a\x16.google.protobuf.Empty\x12C\n" +
	"\rIsBetaEnabled\x12\x16.google.protobuf.Empty\x1a\x1a.google.protobuf.BoolValue\x12I\n" +
	"\x13SetIsAllMailVisible\x12\x1a.google.protobuf.BoolValue\x1a\x16.google.protobuf.Empty\x12F\n" +
	"\x10IsAllMailVisible\x12\x16.google.protobuf.Empty\x1a\x1a.google.protobuf.BoolValue\x12L\n" +
	"\x16SetIsTelemetryDisabled\x12\x1a.google.protobuf.BoolValue\x1a\x16.google.protobuf.Empty\x12I\n" +
	"\x13IsTelemetryDisabled\x12\x16.google.protobuf.Empty\x1a\x1a.google.protobuf.BoolValue\x12<\n" +
	"\x04GoOs\x12\x16.google.protobuf.Empty\x1a\x1c.google.protobuf.StringValue\x12>\n" +
	"\fTriggerReset\x12\x16.google.protobuf.Empty\x1a\x16.google.protobuf.Empty\x12?\n" +
	"\aVersion\x12\x16.google.protobuf.Empty\x1a\x1c.google.protobuf.StringValue\x12@\n" +
	"\bLogsPath\x12\x16.google.protobuf.Empty\x1a\x1c.google.protobuf.StringValue\x12C\n" +
	"\vLicensePath\x12\x16.google.protobuf.Empty\x1a\x1c.google.protobuf.StringValue\x12L\n" +
	"\x14ReleaseNotesPageLink\x12\x16.google.protobuf.Empty\x1a\x1c.google.protobuf.StringValue\x12N\n" +
	"\x16DependencyLicensesLink\x12\x16.google.protobuf.Empty\x1a\x1c.google.protobuf.StringValue\x12G\n" +
	"\x0fLandingPageLink\x12\x16.google.protobuf.Empty\x1a\x1c.google.protobuf.StringValue\x12J\n" +
	"\x12SetColorSchemeName\x12\x1c.google.protobuf.StringValue\x1a\x16.google.protobuf.Empty\x12G\n" +
	"\x0fColorSchemeName\x12\x16.google.protobuf.Empty\x1a\x1c.google.protobuf.StringValue\x12J\n" +
	"\x12CurrentEmailClient\x12\x16.google.protobuf.Empty\x1a\x1c.google.protobuf.StringValue\x12;\n" +
	"\tReportBug\x12\x16.grpc.ReportBugRequest\x1a\x16.google.protobuf.Empty\x12E\n" +
	"\rForceLauncher\x12\x1c.google.protobuf.StringValue\x1a\x16.google.protobuf.Empty\x12I\n" +
	"\x11SetMainExecutable\x12\x1c.google.protobuf.StringValue\x1a\x16.google.protobuf.Empty\x12W\n" +
	"\x1fRequestKnowledgeBaseSuggestions\x12\x1c.google.protobuf.StringValue\x1a\x16.google.protobuf.Empty\x123\n" +
	"\x05Login\x12\x12.grpc.LoginRequest\x1a\x16.google.protobuf.Empty\x126\n" +
	"\bLogin2FA\x12\x12.grpc.LoginRequest\x1a\x16.google.protobuf.Empty\x127\n" +
	"\tLoginFido\x12\x12.grpc.LoginRequest\x1a\x16.google.protobuf.Empty\x12=\n" +
	"\x0fLogin2Passwords\x12\x12.grpc.LoginRequest\x1a\x16.google.protobuf.Empty\x12=\n" +
	"\n" +
	"LoginAbort\x12\x17.grpc.LoginAbortRequest\x1a\x16.google.protobuf.Empty\x12E\n" +
	"\x12FidoAssertionAbort\x12\x17.grpc.LoginAbortRequest\x1a\x16.google.protobuf.Empty\x12=\n" +
	"\vCheckUpdate\x12\x16.google.protobuf.Empty\x1a\x16.google.protobuf.Empty\x12?\n" +
	"\rInstallUpdate\x12\x16.google.protobuf.Empty\x1a\x16.google.protobuf.Empty\x12L\n" +
	"\x16SetIsAutomaticUpdateOn\x12\x1a.google.protobuf.BoolValue\x1a\x16.google.protobuf.Empty\x12I\n" +
	"\x13IsAutomaticUpdateOn\x12\x16.google.protobuf.Empty\x1a\x1a.google.protobuf.BoolValue\x12E\n" +
	"\rDiskCachePath\x12\x16.google.protobuf.Empty\x1a\x1c.google.protobuf.StringValue\x12H\n" +
	"\x10SetDiskCachePath\x12\x1c.google.protobuf.StringValue\x1a\x16.google.protobuf.Empty\x12E\n" +
	"\x0fSetIsDoHEnabled\x12\x1a.google.protobuf.BoolValue\x1a\x16.google.protobuf.Empty\x12B\n" +
	"\fIsDoHEnabled\x12\x16.google.protobuf.Empty\x1a\x1a.google.protobuf.BoolValue\x12D\n" +
	"\x12MailServerSettings\x12\x16.google.protobuf.Empty\x1a\x16.grpc.ImapSmtpSettings\x12G\n" +
	"\x15SetMailServerSettings\x12\x16.grpc.ImapSmtpSettings\x1a\x16.google.protobuf.Empty\x12@\n" +
	"\bHostname\x12\x16.google.protobuf.Empty\x1a\x1c.google.protobuf.StringValue\x12E\n" +
	"\n" +
	"IsPortFree\x12\x1b.google.protobuf.Int32Value\x1a\x1a.google.protobuf.BoolValue\x12N\n" +
	"\x12AvailableKeychains\x12\x16.google.protobuf.Empty\x1a .grpc.AvailableKeychainsResponse\x12J\n" +
	"\x12SetCurrentKeychain\x12\x1c.google.protobuf.StringValue\x1a\x16.google.protobuf.Empty\x12G\n" +
	"\x0fCurrentKeychain\x12\x16.google.protobuf.Empty\x1a\x1c.google.protobuf.StringValue\x12=\n" +
	"\vGetUserList\x12\x16.google.protobuf.Empty\x1a\x16.grpc.UserListResponse\x123\n" +
	"\aGetUser\x12\x1c.google.protobuf.StringValue\x1a\n" +
	".grpc.User\x12F\n" +
	"\x10SetUserSplitMode\x12\x1a.grpc.UserSplitModeRequest\x1a\x16.google.protobuf.Empty\x12U\n" +
	"\x18SendBadEventUserFeedback\x12!.grpc.UserBadEventFeedbackRequest\x1a\x16.google.protobuf.Empty\x12B\n" +
	"\n" +
	"LogoutUser\x12\x1c.google.protobuf.StringValue\x1a\x16.google.protobuf.Empty\x12B\n" +
	"\n" +
	"RemoveUser\x12\x1c.google.protobuf.StringValue\x1a\x16.google.protobuf.Empty\x12Q\n" +
	"\x16ConfigureUserAppleMail\x12\x1f.grpc.ConfigureAppleMailRequest\x1a\x16.google.protobuf.Empty\x12O\n" +
	"\x19IsTLSCertificateInstalled\x12\x16.google.protobuf.Empty\x1a\x1a.google.protobuf.BoolValue\x12G\n" +
	"\x15InstallTLSCertificate\x12\x16.google.protobuf.Empty\x1a\x16.google.protobuf.Empty\x12M\n" +
	"\x15ExportTLSCertificates\x12\x1c.google.protobuf.StringValue\x1a\x16.google.protobuf.Empty\x12?\n" +
	"\x0eRunEventStream\x12\x18.grpc.EventStreamRequest\x1a\x11.grpc.StreamEvent0\x01\x12A\n" +
	"\x0fStopEventStream\x12\x16.google.protobuf.Empty\x1a\x16.google.protobuf.Empty\x12?\n" +
	"\rTriggerRepair\x12\x16.google.protobuf.Empty\x1a\x16.google.protobuf.EmptyB6Z4github.com/ProtonMail/proton-bridge/v3/internal/grpcb\x06proto3"

var (
	file_bridge_proto_rawDescOnce sync.Once
	file_bridge_proto_rawDescData []byte
)

func file_bridge_proto_rawDescGZIP() []byte {
	file_bridge_proto_rawDescOnce.Do(func() {
		file_bridge_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_bridge_proto_rawDesc), len(file_bridge_proto_rawDesc)))
	})
	return file_bridge_proto_rawDescData
}

var file_bridge_proto_enumTypes = make([]protoimpl.EnumInfo, 7)
var file_bridge_proto_msgTypes = make([]protoimpl.MessageInfo, 77)
var file_bridge_proto_goTypes = []any{
	(LogLevel)(0),                                 // 0: grpc.LogLevel
	(UserState)(0),                                // 1: grpc.UserState
	(LoginErrorType)(0),                           // 2: grpc.LoginErrorType
	(UpdateErrorType)(0),                          // 3: grpc.UpdateErrorType
	(DiskCacheErrorType)(0),                       // 4: grpc.DiskCacheErrorType
	(MailServerSettingsErrorType)(0),              // 5: grpc.MailServerSettingsErrorType
	(ErrorCode)(0),                                // 6: grpc.ErrorCode
	(*AddLogEntryRequest)(nil),                    // 7: grpc.AddLogEntryRequest
	(*GuiReadyResponse)(nil),                      // 8: grpc.GuiReadyResponse
	(*ReportBugRequest)(nil),                      // 9: grpc.ReportBugRequest
	(*LoginRequest)(nil),                          // 10: grpc.LoginRequest
	(*LoginAbortRequest)(nil),                     // 11: grpc.LoginAbortRequest
	(*ImapSmtpSettings)(nil),                      // 12: grpc.ImapSmtpSettings
	(*AvailableKeychainsResponse)(nil),            // 13: grpc.AvailableKeychainsResponse
	(*User)(nil),                                  // 14: grpc.User
	(*UserSplitModeRequest)(nil),                  // 15: grpc.UserSplitModeRequest
	(*UserBadEventFeedbackRequest)(nil),           // 16: grpc.UserBadEventFeedbackRequest
	(*UserListResponse)(nil),                      // 17: grpc.UserListResponse
	(*ConfigureAppleMailRequest)(nil),             // 18: grpc.ConfigureAppleMailRequest
	(*EventStreamRequest)(nil),                    // 19: grpc.EventStreamRequest
	(*StreamEvent)(nil),                           // 20: grpc.StreamEvent
	(*AppEvent)(nil),                              // 21: grpc.AppEvent
	(*InternetStatusEvent)(nil),                   // 22: grpc.InternetStatusEvent
	(*ToggleAutostartFinishedEvent)(nil),          // 23: grpc.ToggleAutostartFinishedEvent
	(*ResetFinishedEvent)(nil),                    // 24: grpc.ResetFinishedEvent
	(*ReportBugFinishedEvent)(nil),                // 25: grpc.ReportBugFinishedEvent
	(*ReportBugSuccessEvent)(nil),                 // 26: grpc.ReportBugSuccessEvent
	(*ReportBugErrorEvent)(nil),                   // 27: grpc.ReportBugErrorEvent
	(*ShowMainWindowEvent)(nil),                   // 28: grpc.ShowMainWindowEvent
	(*ReportBugFallbackEvent)(nil),                // 29: grpc.ReportBugFallbackEvent
	(*CertificateInstallSuccessEvent)(nil),        // 30: grpc.CertificateInstallSuccessEvent
	(*CertificateInstallCanceledEvent)(nil),       // 31: grpc.CertificateInstallCanceledEvent
	(*CertificateInstallFailedEvent)(nil),         // 32: grpc.CertificateInstallFailedEvent
	(*RepairStartedEvent)(nil),                    // 33: grpc.RepairStartedEvent
	(*AllUsersLoadedEvent)(nil),                   // 34: grpc.AllUsersLoadedEvent
	(*KnowledgeBaseSuggestion)(nil),               // 35: grpc.KnowledgeBaseSuggestion
	(*KnowledgeBaseSuggestionsEvent)(nil),         // 36: grpc.KnowledgeBaseSuggestionsEvent
	(*LoginEvent)(nil),                            // 37: grpc.LoginEvent
	(*LoginErrorEvent)(nil),                       // 38: grpc.LoginErrorEvent
	(*LoginTfaRequestedEvent)(nil),                // 39: grpc.LoginTfaRequestedEvent
	(*LoginFidoRequestedEvent)(nil),               // 40: grpc.LoginFidoRequestedEvent
	(*LoginTfaOrFidoRequestedEvent)(nil),          // 41: grpc.LoginTfaOrFidoRequestedEvent
	(*LoginFidoTouchEvent)(nil),                   // 42: grpc.LoginFidoTouchEvent
	(*LoginFidoPinRequired)(nil),                  // 43: grpc.LoginFidoPinRequired
	(*LoginTwoPasswordsRequestedEvent)(nil),       // 44: grpc.LoginTwoPasswordsRequestedEvent
	(*LoginFinishedEvent)(nil),                    // 45: grpc.LoginFinishedEvent
	(*LoginHvRequestedEvent)(nil),                 // 46: grpc.LoginHvRequestedEvent
	(*UpdateEvent)(nil),                           // 47: grpc.UpdateEvent
	(*UpdateErrorEvent)(nil),                      // 48: grpc.UpdateErrorEvent
	(*UpdateManualReadyEvent)(nil),                // 49: grpc.UpdateManualReadyEvent
	(*UpdateManualRestartNeededEvent)(nil),        // 50: grpc.UpdateManualRestartNeededEvent
	(*UpdateForceEvent)(nil),                      // 51: grpc.UpdateForceEvent
	(*UpdateSilentRestartNeeded)(nil),             // 52: grpc.UpdateSilentRestartNeeded
	(*UpdateIsLatestVersion)(nil),                 // 53: grpc.UpdateIsLatestVersion
	(*UpdateCheckFinished)(nil),                   // 54: grpc.UpdateCheckFinished
	(*UpdateVersionChanged)(nil),                  // 55: grpc.UpdateVersionChanged
	(*DiskCacheEvent)(nil),                        // 56: grpc.DiskCacheEvent
	(*DiskCacheErrorEvent)(nil),                   // 57: grpc.DiskCacheErrorEvent
	(*DiskCachePathChangedEvent)(nil),             // 58: grpc.DiskCachePathChangedEvent
	(*DiskCachePathChangeFinishedEvent)(nil),      // 59: grpc.DiskCachePathChangeFinishedEvent
	(*MailServerSettingsEvent)(nil),               // 60: grpc.MailServerSettingsEvent
	(*MailServerSettingsErrorEvent)(nil),          // 61: grpc.MailServerSettingsErrorEvent
	(*MailServerSettingsChangedEvent)(nil),        // 62: grpc.MailServerSettingsChangedEvent
	(*ChangeMailServerSettingsFinishedEvent)(nil), // 63: grpc.ChangeMailServerSettingsFinishedEvent
	(*KeychainEvent)(nil),                         // 64: grpc.KeychainEvent
	(*ChangeKeychainFinishedEvent)(nil),           // 65: grpc.ChangeKeychainFinishedEvent
	(*HasNoKeychainEvent)(nil),                    // 66: grpc.HasNoKeychainEvent
	(*RebuildKeychainEvent)(nil),                  // 67: grpc.RebuildKeychainEvent
	(*MailEvent)(nil),                             // 68: grpc.MailEvent
	(*AddressChangedEvent)(nil),                   // 69: grpc.AddressChangedEvent
	(*AddressChangedLogoutEvent)(nil),             // 70: grpc.AddressChangedLogoutEvent
	(*ApiCertIssueEvent)(nil),                     // 71: grpc.ApiCertIssueEvent
	(*UserEvent)(nil),                             // 72: grpc.UserEvent
	(*ToggleSplitModeFinishedEvent)(nil),          // 73: grpc.ToggleSplitModeFinishedEvent
	(*UserDisconnectedEvent)(nil),                 // 74: grpc.UserDisconnectedEvent
	(*UserChangedEvent)(nil),                      // 75: grpc.UserChangedEvent
	(*UserBadEvent)(nil),                          // 76: grpc.UserBadEvent
	(*UsedBytesChangedEvent)(nil),                 // 77: grpc.UsedBytesChangedEvent
	(*ImapLoginFailedEvent)(nil),                  // 78: grpc.ImapLoginFailedEvent
	(*SyncStartedEvent)(nil),                      // 79: grpc.SyncStartedEvent
	(*SyncFinishedEvent)(nil),                     // 80: grpc.SyncFinishedEvent
	(*SyncProgressEvent)(nil),                     // 81: grpc.SyncProgressEvent
	(*UserNotificationEvent)(nil),                 // 82: grpc.UserNotificationEvent
	(*GenericErrorEvent)(nil),                     // 83: grpc.GenericErrorEvent
	(*wrapperspb.StringValue)(nil),                // 84: google.protobuf.StringValue
	(*emptypb.Empty)(nil),                         // 85: google.protobuf.Empty
	(*wrapperspb.BoolValue)(nil),                  // 86: google.protobuf.BoolValue
	(*wrapperspb.Int32Value)(nil),                 // 87: google.protobuf.Int32Value
}
var file_bridge_proto_depIdxs = []int32{
	0,   // 0: grpc.AddLogEntryRequest.level:type_name -> grpc.LogLevel
	1,   // 1: grpc.User.state:type_name -> grpc.UserState
	14,  // 2: grpc.UserListResponse.users:type_name -> grpc.User
	21,  // 3: grpc.StreamEvent.app:type_name -> grpc.AppEvent
	37,  // 4: grpc.StreamEvent.login:type_name -> grpc.LoginEvent
	47,  // 5: grpc.StreamEvent.update:type_name -> grpc.UpdateEvent
	56,  // 6: grpc.StreamEvent.cache:type_name -> grpc.DiskCacheEvent
	60,  // 7: grpc.StreamEvent.mailServerSettings:type_name -> grpc.MailServerSettingsEvent
	64,  // 8: grpc.StreamEvent.keychain:type_name -> grpc.KeychainEvent
	68,  // 9: grpc.StreamEvent.mail:type_name -> grpc.MailEvent
	72,  // 10: grpc.StreamEvent.user:type_name -> grpc.UserEvent
	83,  // 11: grpc.StreamEvent.genericError:type_name -> grpc.GenericErrorEvent
	22,  // 12: grpc.AppEvent.internetStatus:type_name -> grpc.InternetStatusEvent
	23,  // 13: grpc.AppEvent.toggleAutostartFinished:type_name -> grpc.ToggleAutostartFinishedEvent
	24,  // 14: grpc.AppEvent.resetFinished:type_name -> grpc.ResetFinishedEvent
	25,  // 15: grpc.AppEvent.reportBugFinished:type_name -> grpc.ReportBugFinishedEvent
	26,  // 16: grpc.AppEvent.reportBugSuccess:type_name -> grpc.ReportBugSuccessEvent
	27,  // 17: grpc.AppEvent.reportBugError:type_name -> grpc.ReportBugErrorEvent
	28,  // 18: grpc.AppEvent.showMainWindow:type_name -> grpc.ShowMainWindowEvent
	29,  // 19: grpc.AppEvent.reportBugFallback:type_name -> grpc.ReportBugFallbackEvent
	30,  // 20: grpc.AppEvent.certificateInstallSuccess:type_name -> grpc.CertificateInstallSuccessEvent
	31,  // 21: grpc.AppEvent.certificateInstallCanceled:type_name -> grpc.CertificateInstallCanceledEvent
	32,  // 22: grpc.AppEvent.certificateInstallFailed:type_name -> grpc.CertificateInstallFailedEvent
	36,  // 23: grpc.AppEvent.knowledgeBaseSuggestions:type_name -> grpc.KnowledgeBaseSuggestionsEvent
	33,  // 24: grpc.AppEvent.repairStarted:type_name -> grpc.RepairStartedEvent
	34,  // 25: grpc.AppEvent.allUsersLoaded:type_name -> grpc.AllUsersLoadedEvent
	82,  // 26: grpc.AppEvent.userNotification:type_name -> grpc.UserNotificationEvent
	35,  // 27: grpc.KnowledgeBaseSuggestionsEvent.suggestions:type_name -> grpc.KnowledgeBaseSuggestion
	38,  // 28: grpc.LoginEvent.error:type_name -> grpc.LoginErrorEvent
	39,  // 29: grpc.LoginEvent.tfaRequested:type_name -> grpc.LoginTfaRequestedEvent
	44,  // 30: grpc.LoginEvent.twoPasswordRequested:type_name -> grpc.LoginTwoPasswordsRequestedEvent
	45,  // 31: grpc.LoginEvent.finished:type_name -> grpc.LoginFinishedEvent
	45,  // 32: grpc.LoginEvent.alreadyLoggedIn:type_name -> grpc.LoginFinishedEvent
	46,  // 33: grpc.LoginEvent.hvRequested:type_name -> grpc.LoginHvRequestedEvent
	40,  // 34: grpc.LoginEvent.fidoRequested:type_name -> grpc.LoginFidoRequestedEvent
	41,  // 35: grpc.LoginEvent.tfaOrFidoRequested:type_name -> grpc.LoginTfaOrFidoRequestedEvent
	42,  // 36: grpc.LoginEvent.loginFidoTouchRequested:type_name -> grpc.LoginFidoTouchEvent
	42,  // 37: grpc.LoginEvent.loginFidoTouchCompleted:type_name -> grpc.LoginFidoTouchEvent
	43,  // 38: grpc.LoginEvent.loginFidoPinRequired:type_name -> grpc.LoginFidoPinRequired
	2,   // 39: grpc.LoginErrorEvent.type:type_name -> grpc.LoginErrorType
	48,  // 40: grpc.UpdateEvent.error:type_name -> grpc.UpdateErrorEvent
	49,  // 41: grpc.UpdateEvent.manualReady:type_name -> grpc.UpdateManualReadyEvent
	50,  // 42: grpc.UpdateEvent.manualRestartNeeded:type_name -> grpc.UpdateManualRestartNeededEvent
	51,  // 43: grpc.UpdateEvent.force:type_name -> grpc.UpdateForceEvent
	52,  // 44: grpc.UpdateEvent.silentRestartNeeded:type_name -> grpc.UpdateSilentRestartNeeded
	53,  // 45: grpc.UpdateEvent.isLatestVersion:type_name -> grpc.UpdateIsLatestVersion
	54,  // 46: grpc.UpdateEvent.checkFinished:type_name -> grpc.UpdateCheckFinished
	55,  // 47: grpc.UpdateEvent.versionChanged:type_name -> grpc.UpdateVersionChanged
	3,   // 48: grpc.UpdateErrorEvent.type:type_name -> grpc.UpdateErrorType
	57,  // 49: grpc.DiskCacheEvent.error:type_name -> grpc.DiskCacheErrorEvent
	58,  // 50: grpc.DiskCacheEvent.pathChanged:type_name -> grpc.DiskCachePathChangedEvent
	59,  // 51: grpc.DiskCacheEvent.pathChangeFinished:type_name -> grpc.DiskCachePathChangeFinishedEvent
	4,   // 52: grpc.DiskCacheErrorEvent.type:type_name -> grpc.DiskCacheErrorType
	61,  // 53: grpc.MailServerSettingsEvent.error:type_name -> grpc.MailServerSettingsErrorEvent
	62,  // 54: grpc.MailServerSettingsEvent.mailServerSettingsChanged:type_name -> grpc.MailServerSettingsChangedEvent
	63,  // 55: grpc.MailServerSettingsEvent.changeMailServerSettingsFinished:type_name -> grpc.ChangeMailServerSettingsFinishedEvent
	5,   // 56: grpc.MailServerSettingsErrorEvent.type:type_name -> grpc.MailServerSettingsErrorType
	12,  // 57: grpc.MailServerSettingsChangedEvent.settings:type_name -> grpc.ImapSmtpSettings
	65,  // 58: grpc.KeychainEvent.changeKeychainFinished:type_name -> grpc.ChangeKeychainFinishedEvent
	66,  // 59: grpc.KeychainEvent.hasNoKeychain:type_name -> grpc.HasNoKeychainEvent
	67,  // 60: grpc.KeychainEvent.rebuildKeychain:type_name -> grpc.RebuildKeychainEvent
	69,  // 61: grpc.MailEvent.addressChanged:type_name -> grpc.AddressChangedEvent
	70,  // 62: grpc.MailEvent.addressChangedLogout:type_name -> grpc.AddressChangedLogoutEvent
	71,  // 63: grpc.MailEvent.apiCertIssue:type_name -> grpc.ApiCertIssueEvent
	73,  // 64: grpc.UserEvent.toggleSplitModeFinished:type_name -> grpc.ToggleSplitModeFinishedEvent
	74,  // 65: grpc.UserEvent.userDisconnected:type_name -> grpc.UserDisconnectedEvent
	75,  // 66: grpc.UserEvent.userChanged:type_name -> grpc.UserChangedEvent
	76,  // 67: grpc.UserEvent.userBadEvent:type_name -> grpc.UserBadEvent
	77,  // 68: grpc.UserEvent.usedBytesChangedEvent:type_name -> grpc.UsedBytesChangedEvent
	78,  // 69: grpc.UserEvent.imapLoginFailedEvent:type_name -> grpc.ImapLoginFailedEvent
	79,  // 70: grpc.UserEvent.syncStartedEvent:type_name -> grpc.SyncStartedEvent
	80,  // 71: grpc.UserEvent.syncFinishedEvent:type_name -> grpc.SyncFinishedEvent
	81,  // 72: grpc.UserEvent.syncProgressEvent:type_name -> grpc.SyncProgressEvent
	6,   // 73: grpc.GenericErrorEvent.code:type_name -> grpc.ErrorCode
	84,  // 74: grpc.Bridge.CheckTokens:input_type -> google.protobuf.StringValue
	7,   // 75: grpc.Bridge.AddLogEntry:input_type -> grpc.AddLogEntryRequest
	85,  // 76: grpc.Bridge.GuiReady:input_type -> google.protobuf.Empty
	85,  // 77: grpc.Bridge.Quit:input_type -> google.protobuf.Empty
	85,  // 78: grpc.Bridge.Restart:input_type -> google.protobuf.Empty
	85,  // 79: grpc.Bridge.ShowOnStartup:input_type -> google.protobuf.Empty
	86,  // 80: grpc.Bridge.SetIsAutostartOn:input_type -> google.protobuf.BoolValue
	85,  // 81: grpc.Bridge.IsAutostartOn:input_type -> google.protobuf.Empty
	86,  // 82: grpc.Bridge.SetIsBetaEnabled:input_type -> google.protobuf.BoolValue
	85,  // 83: grpc.Bridge.IsBetaEnabled:input_type -> google.protobuf.Empty
	86,  // 84: grpc.Bridge.SetIsAllMailVisible:input_type -> google.protobuf.BoolValue
	85,  // 85: grpc.Bridge.IsAllMailVisible:input_type -> google.protobuf.Empty
	86,  // 86: grpc.Bridge.SetIsTelemetryDisabled:input_type -> google.protobuf.BoolValue
	85,  // 87: grpc.Bridge.IsTelemetryDisabled:input_type -> google.protobuf.Empty
	85,  // 88: grpc.Bridge.GoOs:input_type -> google.protobuf.Empty
	85,  // 89: grpc.Bridge.TriggerReset:input_type -> google.protobuf.Empty
	85,  // 90: grpc.Bridge.Version:input_type -> google.protobuf.Empty
	85,  // 91: grpc.Bridge.LogsPath:input_type -> google.protobuf.Empty
	85,  // 92: grpc.Bridge.LicensePath:input_type -> google.protobuf.Empty
	85,  // 93: grpc.Bridge.ReleaseNotesPageLink:input_type -> google.protobuf.Empty
	85,  // 94: grpc.Bridge.DependencyLicensesLink:input_type -> google.protobuf.Empty
	85,  // 95: grpc.Bridge.LandingPageLink:input_type -> google.protobuf.Empty
	84,  // 96: grpc.Bridge.SetColorSchemeName:input_type -> google.protobuf.StringValue
	85,  // 97: grpc.Bridge.ColorSchemeName:input_type -> google.protobuf.Empty
	85,  // 98: grpc.Bridge.CurrentEmailClient:input_type -> google.protobuf.Empty
	9,   // 99: grpc.Bridge.ReportBug:input_type -> grpc.ReportBugRequest
	84,  // 100: grpc.Bridge.ForceLauncher:input_type -> google.protobuf.StringValue
	84,  // 101: grpc.Bridge.SetMainExecutable:input_type -> google.protobuf.StringValue
	84,  // 102: grpc.Bridge.RequestKnowledgeBaseSuggestions:input_type -> google.protobuf.StringValue
	10,  // 103: grpc.Bridge.Login:input_type -> grpc.LoginRequest
	10,  // 104: grpc.Bridge.Login2FA:input_type -> grpc.LoginRequest
	10,  // 105: grpc.Bridge.LoginFido:input_type -> grpc.LoginRequest
	10,  // 106: grpc.Bridge.Login2Passwords:input_type -> grpc.LoginRequest
	11,  // 107: grpc.Bridge.LoginAbort:input_type -> grpc.LoginAbortRequest
	11,  // 108: grpc.Bridge.FidoAssertionAbort:input_type -> grpc.LoginAbortRequest
	85,  // 109: grpc.Bridge.CheckUpdate:input_type -> google.protobuf.Empty
	85,  // 110: grpc.Bridge.InstallUpdate:input_type -> google.protobuf.Empty
	86,  // 111: grpc.Bridge.SetIsAutomaticUpdateOn:input_type -> google.protobuf.BoolValue
	85,  // 112: grpc.Bridge.IsAutomaticUpdateOn:input_type -> google.protobuf.Empty
	85,  // 113: grpc.Bridge.DiskCachePath:input_type -> google.protobuf.Empty
	84,  // 114: grpc.Bridge.SetDiskCachePath:input_type -> google.protobuf.StringValue
	86,  // 115: grpc.Bridge.SetIsDoHEnabled:input_type -> google.protobuf.BoolValue
	85,  // 116: grpc.Bridge.IsDoHEnabled:input_type -> google.protobuf.Empty
	85,  // 117: grpc.Bridge.MailServerSettings:input_type -> google.protobuf.Empty
	12,  // 118: grpc.Bridge.SetMailServerSettings:input_type -> grpc.ImapSmtpSettings
	85,  // 119: grpc.Bridge.Hostname:input_type -> google.protobuf.Empty
	87,  // 120: grpc.Bridge.IsPortFree:input_type -> google.protobuf.Int32Value
	85,  // 121: grpc.Bridge.AvailableKeychains:input_type -> google.protobuf.Empty
	84,  // 122: grpc.Bridge.SetCurrentKeychain:input_type -> google.protobuf.StringValue
	85,  // 123: grpc.Bridge.CurrentKeychain:input_type -> google.protobuf.Empty
	85,  // 124: grpc.Bridge.GetUserList:input_type -> google.protobuf.Empty
	84,  // 125: grpc.Bridge.GetUser:input_type -> google.protobuf.StringValue
	15,  // 126: grpc.Bridge.SetUserSplitMode:input_type -> grpc.UserSplitModeRequest
	16,  // 127: grpc.Bridge.SendBadEventUserFeedback:input_type -> grpc.UserBadEventFeedbackRequest
	84,  // 128: grpc.Bridge.LogoutUser:input_type -> google.protobuf.StringValue
	84,  // 129: grpc.Bridge.RemoveUser:input_type -> google.protobuf.StringValue
	18,  // 130: grpc.Bridge.ConfigureUserAppleMail:input_type -> grpc.ConfigureAppleMailRequest
	85,  // 131: grpc.Bridge.IsTLSCertificateInstalled:input_type -> google.protobuf.Empty
	85,  // 132: grpc.Bridge.InstallTLSCertificate:input_type -> google.protobuf.Empty
	84,  // 133: grpc.Bridge.ExportTLSCertificates:input_type -> google.protobuf.StringValue
	19,  // 134: grpc.Bridge.RunEventStream:input_type -> grpc.EventStreamRequest
	85,  // 135: grpc.Bridge.StopEventStream:input_type -> google.protobuf.Empty
	85,  // 136: grpc.Bridge.TriggerRepair:input_type -> google.protobuf.Empty
	84,  // 137: grpc.Bridge.CheckTokens:output_type -> google.protobuf.StringValue
	85,  // 138: grpc.Bridge.AddLogEntry:output_type -> google.protobuf.Empty
	8,   // 139: grpc.Bridge.GuiReady:output_type -> grpc.GuiReadyResponse
	85,  // 140: grpc.Bridge.Quit:output_type -> google.protobuf.Empty
	85,  // 141: grpc.Bridge.Restart:output_type -> google.protobuf.Empty
	86,  // 142: grpc.Bridge.ShowOnStartup:output_type -> google.protobuf.BoolValue
	85,  // 143: grpc.Bridge.SetIsAutostartOn:output_type -> google.protobuf.Empty
	86,  // 144: grpc.Bridge.IsAutostartOn:output_type -> google.protobuf.BoolValue
	85,  // 145: grpc.Bridge.SetIsBetaEnabled:output_type -> google.protobuf.Empty
	86,  // 146: grpc.Bridge.IsBetaEnabled:output_type -> google.protobuf.BoolValue
	85,  // 147: grpc.Bridge.SetIsAllMailVisible:output_type -> google.protobuf.Empty
	86,  // 148: grpc.Bridge.IsAllMailVisible:output_type -> google.protobuf.BoolValue
	85,  // 149: grpc.Bridge.SetIsTelemetryDisabled:output_type -> google.protobuf.Empty
	86,  // 150: grpc.Bridge.IsTelemetryDisabled:output_type -> google.protobuf.BoolValue
	84,  // 151: grpc.Bridge.GoOs:output_type -> google.protobuf.StringValue
	85,  // 152: grpc.Bridge.TriggerReset:output_type -> google.protobuf.Empty
	84,  // 153: grpc.Bridge.Version:output_type -> google.protobuf.StringValue
	84,  // 154: grpc.Bridge.LogsPath:output_type -> google.protobuf.StringValue
	84,  // 155: grpc.Bridge.LicensePath:output_type -> google.protobuf.StringValue
	84,  // 156: grpc.Bridge.ReleaseNotesPageLink:output_type -> google.protobuf.StringValue
	84,  // 157: grpc.Bridge.DependencyLicensesLink:output_type -> google.protobuf.StringValue
	84,  // 158: grpc.Bridge.LandingPageLink:output_type -> google.protobuf.StringValue
	85,  // 159: grpc.Bridge.SetColorSchemeName:output_type -> google.protobuf.Empty
	84,  // 160: grpc.Bridge.ColorSchemeName:output_type -> google.protobuf.StringValue
	84,  // 161: grpc.Bridge.CurrentEmailClient:output_type -> google.protobuf.StringValue
	85,  // 162: grpc.Bridge.ReportBug:output_type -> google.protobuf.Empty
	85,  // 163: grpc.Bridge.ForceLauncher:output_type -> google.protobuf.Empty
	85,  // 164: grpc.Bridge.SetMainExecutable:output_type -> google.protobuf.Empty
	85,  // 165: grpc.Bridge.RequestKnowledgeBaseSuggestions:output_type -> google.protobuf.Empty
	85,  // 166: grpc.Bridge.Login:output_type -> google.protobuf.Empty
	85,  // 167: grpc.Bridge.Login2FA:output_type -> google.protobuf.Empty
	85,  // 168: grpc.Bridge.LoginFido:output_type -> google.protobuf.Empty
	85,  // 169: grpc.Bridge.Login2Passwords:output_type -> google.protobuf.Empty
	85,  // 170: grpc.Bridge.LoginAbort:output_type -> google.protobuf.Empty
	85,  // 171: grpc.Bridge.FidoAssertionAbort:output_type -> google.protobuf.Empty
	85,  // 172: grpc.Bridge.CheckUpdate:output_type -> google.protobuf.Empty
	85,  // 173: grpc.Bridge.InstallUpdate:output_type -> google.protobuf.Empty
	85,  // 174: grpc.Bridge.SetIsAutomaticUpdateOn:output_type -> google.protobuf.Empty
	86,  // 175: grpc.Bridge.IsAutomaticUpdateOn:output_type -> google.protobuf.BoolValue
	84,  // 176: grpc.Bridge.DiskCachePath:output_type -> google.protobuf.StringValue
	85,  // 177: grpc.Bridge.SetDiskCachePath:output_type -> google.protobuf.Empty
	85,  // 178: grpc.Bridge.SetIsDoHEnabled:output_type -> google.protobuf.Empty
	86,  // 179: grpc.Bridge.IsDoHEnabled:output_type -> google.protobuf.BoolValue
	12,  // 180: grpc.Bridge.MailServerSettings:output_type -> grpc.ImapSmtpSettings
	85,  // 181: grpc.Bridge.SetMailServerSettings:output_type -> google.protobuf.Empty
	84,  // 182: grpc.Bridge.Hostname:output_type -> google.protobuf.StringValue
	86,  // 183: grpc.Bridge.IsPortFree:output_type -> google.protobuf.BoolValue
	13,  // 184: grpc.Bridge.AvailableKeychains:output_type -> grpc.AvailableKeychainsResponse
	85,  // 185: grpc.Bridge.SetCurrentKeychain:output_type -> google.protobuf.Empty
	84,  // 186: grpc.Bridge.CurrentKeychain:output_type -> google.protobuf.StringValue
	17,  // 187: grpc.Bridge.GetUserList:output_type -> grpc.UserListResponse
	14,  // 188: grpc.Bridge.GetUser:output_type -> grpc.User
	85,  // 189: grpc.Bridge.SetUserSplitMode:output_type -> google.protobuf.Empty
	85,  // 190: grpc.Bridge.SendBadEventUserFeedback:output_type -> google.protobuf.Empty
	85,  // 191: grpc.Bridge.LogoutUser:output_type -> google.protobuf.Empty
	85,  // 192: grpc.Bridge.RemoveUser:output_type -> google.protobuf.Empty
	85,  // 193: grpc.Bridge.ConfigureUserAppleMail:output_type -> google.protobuf.Empty
	86,  // 194: grpc.Bridge.IsTLSCertificateInstalled:output_type -> google.protobuf.BoolValue
	85,  // 195: grpc.Bridge.InstallTLSCertificate:output_type -> google.protobuf.Empty
	85,  // 196: grpc.Bridge.ExportTLSCertificates:output_type -> google.protobuf.Empty
	20,  // 197: grpc.Bridge.RunEventStream:output_type -> grpc.StreamEvent
	85,  // 198: grpc.Bridge.StopEventStream:output_type -> google.protobuf.Empty
	85,  // 199: grpc.Bridge.TriggerRepair:output_type -> google.protobuf.Empty
	137, // [137:200] is the sub-list for method output_type
	74,  // [74:137] is the sub-list for method input_type
	74,  // [74:74] is the sub-list for extension type_name
	74,  // [74:74] is the sub-list for extension extendee
	0,   // [0:74] is the sub-list for field type_name
}

func init() { file_bridge_proto_init() }
func file_bridge_proto_init() {
	if File_bridge_proto != nil {
		return
	}
	file_bridge_proto_msgTypes[3].OneofWrappers = []any{}
	file_bridge_proto_msgTypes[13].OneofWrappers = []any{
		(*StreamEvent_App)(nil),
		(*StreamEvent_Login)(nil),
		(*StreamEvent_Update)(nil),
		(*StreamEvent_Cache)(nil),
		(*StreamEvent_MailServerSettings)(nil),
		(*StreamEvent_Keychain)(nil),
		(*StreamEvent_Mail)(nil),
		(*StreamEvent_User)(nil),
		(*StreamEvent_GenericError)(nil),
	}
	file_bridge_proto_msgTypes[14].OneofWrappers = []any{
		(*AppEvent_InternetStatus)(nil),
		(*AppEvent_ToggleAutostartFinished)(nil),
		(*AppEvent_ResetFinished)(nil),
		(*AppEvent_ReportBugFinished)(nil),
		(*AppEvent_ReportBugSuccess)(nil),
		(*AppEvent_ReportBugError)(nil),
		(*AppEvent_ShowMainWindow)(nil),
		(*AppEvent_ReportBugFallback)(nil),
		(*AppEvent_CertificateInstallSuccess)(nil),
		(*AppEvent_CertificateInstallCanceled)(nil),
		(*AppEvent_CertificateInstallFailed)(nil),
		(*AppEvent_KnowledgeBaseSuggestions)(nil),
		(*AppEvent_RepairStarted)(nil),
		(*AppEvent_AllUsersLoaded)(nil),
		(*AppEvent_UserNotification)(nil),
	}
	file_bridge_proto_msgTypes[30].OneofWrappers = []any{
		(*LoginEvent_Error)(nil),
		(*LoginEvent_TfaRequested)(nil),
		(*LoginEvent_TwoPasswordRequested)(nil),
		(*LoginEvent_Finished)(nil),
		(*LoginEvent_AlreadyLoggedIn)(nil),
		(*LoginEvent_HvRequested)(nil),
		(*LoginEvent_FidoRequested)(nil),
		(*LoginEvent_TfaOrFidoRequested)(nil),
		(*LoginEvent_LoginFidoTouchRequested)(nil),
		(*LoginEvent_LoginFidoTouchCompleted)(nil),
		(*LoginEvent_LoginFidoPinRequired)(nil),
	}
	file_bridge_proto_msgTypes[40].OneofWrappers = []any{
		(*UpdateEvent_Error)(nil),
		(*UpdateEvent_ManualReady)(nil),
		(*UpdateEvent_ManualRestartNeeded)(nil),
		(*UpdateEvent_Force)(nil),
		(*UpdateEvent_SilentRestartNeeded)(nil),
		(*UpdateEvent_IsLatestVersion)(nil),
		(*UpdateEvent_CheckFinished)(nil),
		(*UpdateEvent_VersionChanged)(nil),
	}
	file_bridge_proto_msgTypes[49].OneofWrappers = []any{
		(*DiskCacheEvent_Error)(nil),
		(*DiskCacheEvent_PathChanged)(nil),
		(*DiskCacheEvent_PathChangeFinished)(nil),
	}
	file_bridge_proto_msgTypes[53].OneofWrappers = []any{
		(*MailServerSettingsEvent_Error)(nil),
		(*MailServerSettingsEvent_MailServerSettingsChanged)(nil),
		(*MailServerSettingsEvent_ChangeMailServerSettingsFinished)(nil),
	}
	file_bridge_proto_msgTypes[57].OneofWrappers = []any{
		(*KeychainEvent_ChangeKeychainFinished)(nil),
		(*KeychainEvent_HasNoKeychain)(nil),
		(*KeychainEvent_RebuildKeychain)(nil),
	}
	file_bridge_proto_msgTypes[61].OneofWrappers = []any{
		(*MailEvent_AddressChanged)(nil),
		(*MailEvent_AddressChangedLogout)(nil),
		(*MailEvent_ApiCertIssue)(nil),
	}
	file_bridge_proto_msgTypes[65].OneofWrappers = []any{
		(*UserEvent_ToggleSplitModeFinished)(nil),
		(*UserEvent_UserDisconnected)(nil),
		(*UserEvent_UserChanged)(nil),
		(*UserEvent_UserBadEvent)(nil),
		(*UserEvent_UsedBytesChangedEvent)(nil),
		(*UserEvent_ImapLoginFailedEvent)(nil),
		(*UserEvent_SyncStartedEvent)(nil),
		(*UserEvent_SyncFinishedEvent)(nil),
		(*UserEvent_SyncProgressEvent)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_bridge_proto_rawDesc), len(file_bridge_proto_rawDesc)),
			NumEnums:      7,
			NumMessages:   77,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_bridge_proto_goTypes,
		DependencyIndexes: file_bridge_proto_depIdxs,
		EnumInfos:         file_bridge_proto_enumTypes,
		MessageInfos:      file_bridge_proto_msgTypes,
	}.Build()
	File_bridge_proto = out.File
	file_bridge_proto_goTypes = nil
	file_bridge_proto_depIdxs = nil
}
