/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.14.0
 *
 * Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 1505 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#include <QModelRoleData>
#line 30 "/build/pyqt6/src/pyqt6-6.10.0/build/QtCore/sipQtCoreQList0100QModelRoleData.cpp"

#line 325 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtCore/qabstractitemmodel.sip"
#include <qabstractitemmodel.h>
#line 34 "/build/pyqt6/src/pyqt6-6.10.0/build/QtCore/sipQtCoreQList0100QModelRoleData.cpp"


extern "C" {static int convertTo_QList_0100QModelRoleData(PyObject *, void **, int *, PyObject *, void **);}
static int convertTo_QList_0100QModelRoleData(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj, void **)
{
    ::QList< ::QModelRoleData> **sipCppPtr = reinterpret_cast< ::QList< ::QModelRoleData> **>(sipCppPtrV);

#line 1536 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtCore/qpycore_qlist.sip"
    PyObject *iter = PyObject_GetIter(sipPy);

    if (!sipIsErr)
    {
        PyErr_Clear();
        Py_XDECREF(iter);

        return (iter && !PyBytes_Check(sipPy) && !PyUnicode_Check(sipPy));
    }

    if (!iter)
    {
        *sipIsErr = 1;

        return 0;
    }

    QList<QModelRoleData> *ql = new QList<QModelRoleData>;
 
    for (Py_ssize_t i = 0; ; ++i)
    {
        PyErr_Clear();
        PyObject *itm = PyIter_Next(iter);

        if (!itm)
        {
            if (PyErr_Occurred())
            {
                delete ql;
                Py_DECREF(iter);
                *sipIsErr = 1;

                return 0;
            }

            break;
        }

        int state;
        QModelRoleData *t = reinterpret_cast<QModelRoleData *>(
                sipForceConvertToType(itm, sipType_QModelRoleData,
                        sipTransferObj, SIP_NOT_NONE, &state, sipIsErr));

        if (*sipIsErr)
        {
            PyErr_Format(PyExc_TypeError,
                    "index %zd has type '%s' but 'QModelRoleData' is expected",
                    i, sipPyTypeName(Py_TYPE(itm)));

            Py_DECREF(itm);
            delete ql;
            Py_DECREF(iter);

            return 0;
        }

        ql->append(*t);

        sipReleaseType(t, sipType_QModelRoleData, state);
        Py_DECREF(itm);
    }
 
    Py_DECREF(iter);

    *sipCppPtr = ql;
 
    return sipGetState(sipTransferObj);
#line 110 "/build/pyqt6/src/pyqt6-6.10.0/build/QtCore/sipQtCoreQList0100QModelRoleData.cpp"
}


extern "C" {static PyObject *convertFrom_QList_0100QModelRoleData(void *, PyObject *);}
static PyObject *convertFrom_QList_0100QModelRoleData(void *sipCppV, PyObject *sipTransferObj)
{
    ::QList< ::QModelRoleData> *sipCpp = reinterpret_cast< ::QList< ::QModelRoleData> *>(sipCppV);

#line 1510 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtCore/qpycore_qlist.sip"
    PyObject *l = PyList_New(sipCpp->size());

    if (!l)
        return 0;

    for (int i = 0; i < sipCpp->size(); ++i)
    {
        QModelRoleData *t = new QModelRoleData(sipCpp->at(i));
        PyObject *tobj = sipConvertFromNewType(t, sipType_QModelRoleData,
                sipTransferObj);

        if (!tobj)
        {
            delete t;
            Py_DECREF(l);

            return 0;
        }

        PyList_SetItem(l, i, tobj);
    }

    return l;
#line 143 "/build/pyqt6/src/pyqt6-6.10.0/build/QtCore/sipQtCoreQList0100QModelRoleData.cpp"
}


sipMappedTypeDef sipTypeDef_QtCore_QList_0100QModelRoleData = {
    {
        SIP_NULLPTR,
        SIP_TYPE_MAPPED,
        sipNameNr_14201,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        -1,
        {0, 0, 1},
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR}
    },
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    convertTo_QList_0100QModelRoleData,
    convertFrom_QList_0100QModelRoleData
};
