/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.1
 *
 * Copyright (c) 2026 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtNetwork.h"

#line 66 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtNetwork/qnetworkinterface.sip"
#include <qnetworkinterface.h>
#line 29 "/build/pyqt6/src/pyqt6-6.10.2/build/QtNetwork/sipQtNetworkQNetworkInterface.cpp"

#line 24 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 33 "/build/pyqt6/src/pyqt6-6.10.2/build/QtNetwork/sipQtNetworkQNetworkInterface.cpp"
#line 28 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 36 "/build/pyqt6/src/pyqt6-6.10.2/build/QtNetwork/sipQtNetworkQNetworkInterface.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtNetwork/qhostaddress.sip"
#include <qhostaddress.h>
#line 39 "/build/pyqt6/src/pyqt6-6.10.2/build/QtNetwork/sipQtNetworkQNetworkInterface.cpp"
#line 28 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 42 "/build/pyqt6/src/pyqt6-6.10.2/build/QtNetwork/sipQtNetworkQNetworkInterface.cpp"
#line 28 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 45 "/build/pyqt6/src/pyqt6-6.10.2/build/QtNetwork/sipQtNetworkQNetworkInterface.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtNetwork/qnetworkinterface.sip"
#include <qnetworkinterface.h>
#line 48 "/build/pyqt6/src/pyqt6-6.10.2/build/QtNetwork/sipQtNetworkQNetworkInterface.cpp"
#line 25 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtCore/qflags.sip"
#include <qglobal.h>
#line 51 "/build/pyqt6/src/pyqt6-6.10.2/build/QtNetwork/sipQtNetworkQNetworkInterface.cpp"


PyDoc_STRVAR(doc_QNetworkInterface_isValid, "isValid(self) -> bool");

extern "C" {static PyObject *meth_QNetworkInterface_isValid(PyObject *, PyObject *);}
static PyObject *meth_QNetworkInterface_isValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkInterface *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkInterface, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isValid();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkInterface, sipName_isValid, doc_QNetworkInterface_isValid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkInterface_name, "name(self) -> str");

extern "C" {static PyObject *meth_QNetworkInterface_name(PyObject *, PyObject *);}
static PyObject *meth_QNetworkInterface_name(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkInterface *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkInterface, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->name());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkInterface, sipName_name, doc_QNetworkInterface_name);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkInterface_flags, "flags(self) -> QNetworkInterface.InterfaceFlag");

extern "C" {static PyObject *meth_QNetworkInterface_flags(PyObject *, PyObject *);}
static PyObject *meth_QNetworkInterface_flags(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkInterface *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkInterface, &sipCpp))
        {
            ::QNetworkInterface::InterfaceFlags*sipRes;

            sipRes = new ::QNetworkInterface::InterfaceFlags(sipCpp->flags());

            return sipConvertFromNewType(sipRes, sipType_QFlags_0100QNetworkInterface_InterfaceFlag, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkInterface, sipName_flags, doc_QNetworkInterface_flags);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkInterface_hardwareAddress, "hardwareAddress(self) -> str");

extern "C" {static PyObject *meth_QNetworkInterface_hardwareAddress(PyObject *, PyObject *);}
static PyObject *meth_QNetworkInterface_hardwareAddress(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkInterface *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkInterface, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->hardwareAddress());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkInterface, sipName_hardwareAddress, doc_QNetworkInterface_hardwareAddress);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkInterface_addressEntries, "addressEntries(self) -> list[QNetworkAddressEntry]");

extern "C" {static PyObject *meth_QNetworkInterface_addressEntries(PyObject *, PyObject *);}
static PyObject *meth_QNetworkInterface_addressEntries(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkInterface *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkInterface, &sipCpp))
        {
            QList< ::QNetworkAddressEntry>*sipRes;

            sipRes = new QList< ::QNetworkAddressEntry>(sipCpp->addressEntries());

            return sipConvertFromNewType(sipRes, sipType_QList_0100QNetworkAddressEntry, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkInterface, sipName_addressEntries, doc_QNetworkInterface_addressEntries);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkInterface_interfaceFromName, "interfaceFromName(name: str|None) -> QNetworkInterface");

extern "C" {static PyObject *meth_QNetworkInterface_interfaceFromName(PyObject *, PyObject *);}
static PyObject *meth_QNetworkInterface_interfaceFromName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "CJ1", &sipSelf, sipType_QString, &a0, &a0State))
        {
            ::QNetworkInterface*sipRes;

            sipRes = new ::QNetworkInterface(::QNetworkInterface::interfaceFromName(*a0));
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipConvertFromNewType(sipRes, sipType_QNetworkInterface, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkInterface, sipName_interfaceFromName, doc_QNetworkInterface_interfaceFromName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkInterface_interfaceFromIndex, "interfaceFromIndex(index: int) -> QNetworkInterface");

extern "C" {static PyObject *meth_QNetworkInterface_interfaceFromIndex(PyObject *, PyObject *);}
static PyObject *meth_QNetworkInterface_interfaceFromIndex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "Ci", &sipSelf, &a0))
        {
            ::QNetworkInterface*sipRes;

            sipRes = new ::QNetworkInterface(::QNetworkInterface::interfaceFromIndex(a0));

            return sipConvertFromNewType(sipRes, sipType_QNetworkInterface, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkInterface, sipName_interfaceFromIndex, doc_QNetworkInterface_interfaceFromIndex);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkInterface_allInterfaces, "allInterfaces() -> list[QNetworkInterface]");

extern "C" {static PyObject *meth_QNetworkInterface_allInterfaces(PyObject *, PyObject *);}
static PyObject *meth_QNetworkInterface_allInterfaces(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, "C", &sipSelf))
        {
            QList< ::QNetworkInterface>*sipRes;

            sipRes = new QList< ::QNetworkInterface>(::QNetworkInterface::allInterfaces());

            return sipConvertFromNewType(sipRes, sipType_QList_0100QNetworkInterface, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkInterface, sipName_allInterfaces, doc_QNetworkInterface_allInterfaces);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkInterface_allAddresses, "allAddresses() -> list[QHostAddress]");

extern "C" {static PyObject *meth_QNetworkInterface_allAddresses(PyObject *, PyObject *);}
static PyObject *meth_QNetworkInterface_allAddresses(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, "C", &sipSelf))
        {
            QList< ::QHostAddress>*sipRes;

            sipRes = new QList< ::QHostAddress>(::QNetworkInterface::allAddresses());

            return sipConvertFromNewType(sipRes, sipType_QList_0100QHostAddress, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkInterface, sipName_allAddresses, doc_QNetworkInterface_allAddresses);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkInterface_index, "index(self) -> int");

extern "C" {static PyObject *meth_QNetworkInterface_index(PyObject *, PyObject *);}
static PyObject *meth_QNetworkInterface_index(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkInterface *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkInterface, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->index();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkInterface, sipName_index, doc_QNetworkInterface_index);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkInterface_humanReadableName, "humanReadableName(self) -> str");

extern "C" {static PyObject *meth_QNetworkInterface_humanReadableName(PyObject *, PyObject *);}
static PyObject *meth_QNetworkInterface_humanReadableName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkInterface *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkInterface, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->humanReadableName());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkInterface, sipName_humanReadableName, doc_QNetworkInterface_humanReadableName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkInterface_swap, "swap(self, other: QNetworkInterface)");

extern "C" {static PyObject *meth_QNetworkInterface_swap(PyObject *, PyObject *);}
static PyObject *meth_QNetworkInterface_swap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QNetworkInterface* a0;
        ::QNetworkInterface *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QNetworkInterface, &sipCpp, sipType_QNetworkInterface, &a0))
        {
            sipCpp->swap(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkInterface, sipName_swap, doc_QNetworkInterface_swap);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkInterface_interfaceIndexFromName, "interfaceIndexFromName(name: str|None) -> int");

extern "C" {static PyObject *meth_QNetworkInterface_interfaceIndexFromName(PyObject *, PyObject *);}
static PyObject *meth_QNetworkInterface_interfaceIndexFromName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "CJ1", &sipSelf, sipType_QString, &a0, &a0State))
        {
            int sipRes;

            sipRes = ::QNetworkInterface::interfaceIndexFromName(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkInterface, sipName_interfaceIndexFromName, doc_QNetworkInterface_interfaceIndexFromName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkInterface_interfaceNameFromIndex, "interfaceNameFromIndex(index: int) -> str");

extern "C" {static PyObject *meth_QNetworkInterface_interfaceNameFromIndex(PyObject *, PyObject *);}
static PyObject *meth_QNetworkInterface_interfaceNameFromIndex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "Ci", &sipSelf, &a0))
        {
            ::QString*sipRes;

            sipRes = new ::QString(::QNetworkInterface::interfaceNameFromIndex(a0));

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkInterface, sipName_interfaceNameFromIndex, doc_QNetworkInterface_interfaceNameFromIndex);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkInterface_type, "type(self) -> QNetworkInterface.InterfaceType");

extern "C" {static PyObject *meth_QNetworkInterface_type(PyObject *, PyObject *);}
static PyObject *meth_QNetworkInterface_type(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkInterface *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkInterface, &sipCpp))
        {
            ::QNetworkInterface::InterfaceType sipRes;

            sipRes = sipCpp->type();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QNetworkInterface_InterfaceType);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkInterface, sipName_type, doc_QNetworkInterface_type);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkInterface_maximumTransmissionUnit, "maximumTransmissionUnit(self) -> int");

extern "C" {static PyObject *meth_QNetworkInterface_maximumTransmissionUnit(PyObject *, PyObject *);}
static PyObject *meth_QNetworkInterface_maximumTransmissionUnit(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkInterface *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkInterface, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->maximumTransmissionUnit();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkInterface, sipName_maximumTransmissionUnit, doc_QNetworkInterface_maximumTransmissionUnit);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QNetworkInterface(void *, int);}
static void release_QNetworkInterface(void *sipCppV, int)
{
    delete reinterpret_cast< ::QNetworkInterface *>(sipCppV);
}


extern "C" {static void *array_QNetworkInterface(Py_ssize_t);}
static void *array_QNetworkInterface(Py_ssize_t sipNrElem)
{
    return new ::QNetworkInterface[sipNrElem];
}


extern "C" {static void array_delete_QNetworkInterface(void *);}
static void array_delete_QNetworkInterface(void *sipCpp)
{
    delete[] reinterpret_cast< ::QNetworkInterface *>(sipCpp);
}


extern "C" {static void assign_QNetworkInterface(void *, Py_ssize_t, void *);}
static void assign_QNetworkInterface(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QNetworkInterface *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QNetworkInterface *>(sipSrc);
}


extern "C" {static void *copy_QNetworkInterface(const void *, Py_ssize_t);}
static void *copy_QNetworkInterface(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QNetworkInterface(reinterpret_cast<const ::QNetworkInterface *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QNetworkInterface(sipSimpleWrapper *);}
static void dealloc_QNetworkInterface(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QNetworkInterface(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QNetworkInterface(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QNetworkInterface(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QNetworkInterface *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QNetworkInterface();

            return sipCpp;
        }
    }

    {
        const ::QNetworkInterface* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QNetworkInterface, &a0))
        {
            sipCpp = new ::QNetworkInterface(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QNetworkInterface[] = {
    {sipName_addressEntries, meth_QNetworkInterface_addressEntries, METH_VARARGS, doc_QNetworkInterface_addressEntries},
    {sipName_allAddresses, meth_QNetworkInterface_allAddresses, METH_VARARGS, doc_QNetworkInterface_allAddresses},
    {sipName_allInterfaces, meth_QNetworkInterface_allInterfaces, METH_VARARGS, doc_QNetworkInterface_allInterfaces},
    {sipName_flags, meth_QNetworkInterface_flags, METH_VARARGS, doc_QNetworkInterface_flags},
    {sipName_hardwareAddress, meth_QNetworkInterface_hardwareAddress, METH_VARARGS, doc_QNetworkInterface_hardwareAddress},
    {sipName_humanReadableName, meth_QNetworkInterface_humanReadableName, METH_VARARGS, doc_QNetworkInterface_humanReadableName},
    {sipName_index, meth_QNetworkInterface_index, METH_VARARGS, doc_QNetworkInterface_index},
    {sipName_interfaceFromIndex, meth_QNetworkInterface_interfaceFromIndex, METH_VARARGS, doc_QNetworkInterface_interfaceFromIndex},
    {sipName_interfaceFromName, meth_QNetworkInterface_interfaceFromName, METH_VARARGS, doc_QNetworkInterface_interfaceFromName},
    {sipName_interfaceIndexFromName, meth_QNetworkInterface_interfaceIndexFromName, METH_VARARGS, doc_QNetworkInterface_interfaceIndexFromName},
    {sipName_interfaceNameFromIndex, meth_QNetworkInterface_interfaceNameFromIndex, METH_VARARGS, doc_QNetworkInterface_interfaceNameFromIndex},
    {sipName_isValid, meth_QNetworkInterface_isValid, METH_VARARGS, doc_QNetworkInterface_isValid},
    {sipName_maximumTransmissionUnit, meth_QNetworkInterface_maximumTransmissionUnit, METH_VARARGS, doc_QNetworkInterface_maximumTransmissionUnit},
    {sipName_name, meth_QNetworkInterface_name, METH_VARARGS, doc_QNetworkInterface_name},
    {sipName_swap, meth_QNetworkInterface_swap, METH_VARARGS, doc_QNetworkInterface_swap},
    {sipName_type, meth_QNetworkInterface_type, METH_VARARGS, doc_QNetworkInterface_type}
};


/* Define the enum members and ints to be added to this type. */
static sipIntInstanceDef intInstances_QNetworkInterface[] = {
    {sipName_IsUp, static_cast<int>(::QNetworkInterface::IsUp)},
    {sipName_IsRunning, static_cast<int>(::QNetworkInterface::IsRunning)},
    {sipName_CanBroadcast, static_cast<int>(::QNetworkInterface::CanBroadcast)},
    {sipName_IsLoopBack, static_cast<int>(::QNetworkInterface::IsLoopBack)},
    {sipName_IsPointToPoint, static_cast<int>(::QNetworkInterface::IsPointToPoint)},
    {sipName_CanMulticast, static_cast<int>(::QNetworkInterface::CanMulticast)},
    {sipName_Unknown, static_cast<int>(::QNetworkInterface::Unknown)},
    {sipName_Loopback, static_cast<int>(::QNetworkInterface::Loopback)},
    {sipName_Virtual, static_cast<int>(::QNetworkInterface::Virtual)},
    {sipName_Ethernet, static_cast<int>(::QNetworkInterface::Ethernet)},
    {sipName_Slip, static_cast<int>(::QNetworkInterface::Slip)},
    {sipName_CanBus, static_cast<int>(::QNetworkInterface::CanBus)},
    {sipName_Ppp, static_cast<int>(::QNetworkInterface::Ppp)},
    {sipName_Fddi, static_cast<int>(::QNetworkInterface::Fddi)},
    {sipName_Wifi, static_cast<int>(::QNetworkInterface::Wifi)},
    {sipName_Ieee80211, static_cast<int>(::QNetworkInterface::Ieee80211)},
    {sipName_Phonet, static_cast<int>(::QNetworkInterface::Phonet)},
    {sipName_Ieee802154, static_cast<int>(::QNetworkInterface::Ieee802154)},
    {sipName_SixLoWPAN, static_cast<int>(::QNetworkInterface::SixLoWPAN)},
    {sipName_Ieee80216, static_cast<int>(::QNetworkInterface::Ieee80216)},
    {sipName_Ieee1394, static_cast<int>(::QNetworkInterface::Ieee1394)},
    {0, 0}
};

PyDoc_STRVAR(doc_QNetworkInterface, "\1QNetworkInterface()\n"
"QNetworkInterface(other: QNetworkInterface)");


sipClassTypeDef sipTypeDef_QtNetwork_QNetworkInterface = {
    {
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QNetworkInterface,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_QNetworkInterface,
        {0, 0, 1},
        16, methods_QNetworkInterface,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, intInstances_QNetworkInterface, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QNetworkInterface,
    -1,
    sipNameNr_PyQt6_sip_simplewrapper,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QNetworkInterface,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QNetworkInterface,
    assign_QNetworkInterface,
    array_QNetworkInterface,
    copy_QNetworkInterface,
    release_QNetworkInterface,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QNetworkInterface,
    sizeof (::QNetworkInterface),
};
