/* Generated by Lib/test/test_ctypes/test_generated_structs.py */
#define TEST_PATTERN 2926941915
        // Append VALUE to the result.
        #define APPEND(ITEM) {                          \
            PyObject *item = ITEM;                      \
            if (!item) {                                \
                Py_DECREF(result);                      \
                return NULL;                            \
            }                                           \
            int rv = PyList_Append(result, item);       \
            Py_DECREF(item);                            \
            if (rv < 0) {                               \
                Py_DECREF(result);                      \
                return NULL;                            \
            }                                           \
        }

        // Set TARGET, and append a snapshot of `value`'s
        // memory to the result.
        #define SET_AND_APPEND(TYPE, TARGET, VAL) {     \
            TYPE v = VAL;                               \
            TARGET = v;                                 \
            APPEND(PyBytes_FromStringAndSize(           \
                (char*)&value, sizeof(value)));         \
        }

        // Set a field to test values; append a snapshot of the memory
        // after each of the operations.
        #define TEST_FIELD(TYPE, TARGET) {                    \
            SET_AND_APPEND(TYPE, TARGET, -1)                  \
            SET_AND_APPEND(TYPE, TARGET, 1)                   \
            SET_AND_APPEND(TYPE, TARGET, (TYPE)TEST_PATTERN)  \
            SET_AND_APPEND(TYPE, TARGET, 0)                   \
        }

        #if defined(__GNUC__) || defined(__clang__)
        #define GCC_ATTR(X) __attribute__((X))
        #else
        #define GCC_ATTR(X) /* */
        #endif

        static PyObject *
        get_generated_test_data(PyObject *self, PyObject *name)
        {
            if (!PyUnicode_Check(name)) {
                PyErr_SetString(PyExc_TypeError, "need a string");
                return NULL;
            }
            PyObject *result = PyList_New(0);
            if (!result) {
                return NULL;
            }

            if (PyUnicode_CompareWithASCIIString(name, "SingleInt") == 0) {

                struct SingleInt {
                    int a;
                };
                struct SingleInt value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("SingleInt"));
                APPEND(PyLong_FromLong(sizeof(struct SingleInt)));
                APPEND(PyLong_FromLong(_Alignof(struct SingleInt)));
                TEST_FIELD(int, value.a);
                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "SingleInt_Union") == 0) {

                union SingleInt_Union {
                    int a;
                };
                union SingleInt_Union value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("SingleInt_Union"));
                APPEND(PyLong_FromLong(sizeof(union SingleInt_Union)));
                APPEND(PyLong_FromLong(_Alignof(union SingleInt_Union)));
                TEST_FIELD(int, value.a);
                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "SingleU32") == 0) {

                struct SingleU32 {
                    uint32_t a;
                };
                struct SingleU32 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("SingleU32"));
                APPEND(PyLong_FromLong(sizeof(struct SingleU32)));
                APPEND(PyLong_FromLong(_Alignof(struct SingleU32)));
                TEST_FIELD(uint32_t, value.a);
                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "SimpleStruct") == 0) {

                struct SimpleStruct {
                    int32_t x;
                    int8_t y;
                    uint16_t z;
                };
                struct SimpleStruct value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("SimpleStruct"));
                APPEND(PyLong_FromLong(sizeof(struct SimpleStruct)));
                APPEND(PyLong_FromLong(_Alignof(struct SimpleStruct)));
                TEST_FIELD(int32_t, value.x);
                TEST_FIELD(int8_t, value.y);
                TEST_FIELD(uint16_t, value.z);
                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "SimpleUnion") == 0) {

                union SimpleUnion {
                    int32_t x;
                    int8_t y;
                    uint16_t z;
                };
                union SimpleUnion value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("SimpleUnion"));
                APPEND(PyLong_FromLong(sizeof(union SimpleUnion)));
                APPEND(PyLong_FromLong(_Alignof(union SimpleUnion)));
                TEST_FIELD(int32_t, value.x);
                TEST_FIELD(int8_t, value.y);
                TEST_FIELD(uint16_t, value.z);
                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "ManyTypes") == 0) {

                struct ManyTypes {
                    int8_t i8;
                    uint8_t u8;
                    int16_t i16;
                    uint16_t u16;
                    int32_t i32;
                    uint32_t u32;
                    int64_t i64;
                    uint64_t u64;
                };
                struct ManyTypes value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("ManyTypes"));
                APPEND(PyLong_FromLong(sizeof(struct ManyTypes)));
                APPEND(PyLong_FromLong(_Alignof(struct ManyTypes)));
                TEST_FIELD(int8_t, value.i8);
                TEST_FIELD(uint8_t, value.u8);
                TEST_FIELD(int16_t, value.i16);
                TEST_FIELD(uint16_t, value.u16);
                TEST_FIELD(int32_t, value.i32);
                TEST_FIELD(uint32_t, value.u32);
                TEST_FIELD(int64_t, value.i64);
                TEST_FIELD(uint64_t, value.u64);
                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "ManyTypesU") == 0) {

                union ManyTypesU {
                    int8_t i8;
                    uint8_t u8;
                    int16_t i16;
                    uint16_t u16;
                    int32_t i32;
                    uint32_t u32;
                    int64_t i64;
                    uint64_t u64;
                };
                union ManyTypesU value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("ManyTypesU"));
                APPEND(PyLong_FromLong(sizeof(union ManyTypesU)));
                APPEND(PyLong_FromLong(_Alignof(union ManyTypesU)));
                TEST_FIELD(int8_t, value.i8);
                TEST_FIELD(uint8_t, value.u8);
                TEST_FIELD(int16_t, value.i16);
                TEST_FIELD(uint16_t, value.u16);
                TEST_FIELD(int32_t, value.i32);
                TEST_FIELD(uint32_t, value.u32);
                TEST_FIELD(int64_t, value.i64);
                TEST_FIELD(uint64_t, value.u64);
                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Nested") == 0) {

                struct Nested {
                    struct {
                        int32_t x;
                        int8_t y;
                        uint16_t z;
                    } a;
                    union {
                        int32_t x;
                        int8_t y;
                        uint16_t z;
                    } b;
                    struct {
                        int32_t x;
                        int8_t y;
                        uint16_t z;
                    };
                };
                struct Nested value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Nested"));
                APPEND(PyLong_FromLong(sizeof(struct Nested)));
                APPEND(PyLong_FromLong(_Alignof(struct Nested)));
                TEST_FIELD(int32_t, value.a.x);
                TEST_FIELD(int8_t, value.a.y);
                TEST_FIELD(uint16_t, value.a.z);
                TEST_FIELD(int32_t, value.b.x);
                TEST_FIELD(int8_t, value.b.y);
                TEST_FIELD(uint16_t, value.b.z);
                TEST_FIELD(int32_t, value.x);
                TEST_FIELD(int8_t, value.y);
                TEST_FIELD(uint16_t, value.z);
                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Packed1") == 0) {

            #if (defined(MS_WIN32) || ((defined(__x86_64__) || defined(__i386__) || defined(__ppc64__)) && (defined(__GNUC__) || defined(__clang__))))

                #pragma pack(push, 1)
                struct GCC_ATTR(ms_struct) Packed1 {
                    int8_t a;
                    int64_t b;
                };
                #pragma pack(pop)
                struct Packed1 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Packed1"));
                APPEND(PyLong_FromLong(sizeof(struct Packed1)));
                APPEND(PyLong_FromLong(_Alignof(struct Packed1)));
                TEST_FIELD(int8_t, value.a);
                TEST_FIELD(int64_t, value.b);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Packed2") == 0) {

            #if (defined(MS_WIN32) || ((defined(__x86_64__) || defined(__i386__) || defined(__ppc64__)) && (defined(__GNUC__) || defined(__clang__))))

                #pragma pack(push, 2)
                struct GCC_ATTR(ms_struct) Packed2 {
                    int8_t a;
                    int64_t b;
                };
                #pragma pack(pop)
                struct Packed2 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Packed2"));
                APPEND(PyLong_FromLong(sizeof(struct Packed2)));
                APPEND(PyLong_FromLong(_Alignof(struct Packed2)));
                TEST_FIELD(int8_t, value.a);
                TEST_FIELD(int64_t, value.b);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Packed3") == 0) {

            #if (defined(MS_WIN32) || ((defined(__x86_64__) || defined(__i386__) || defined(__ppc64__)) && (defined(__GNUC__) || defined(__clang__))))

                #pragma pack(push, 4)
                struct GCC_ATTR(ms_struct) Packed3 {
                    int8_t a;
                    int64_t b;
                };
                #pragma pack(pop)
                struct Packed3 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Packed3"));
                APPEND(PyLong_FromLong(sizeof(struct Packed3)));
                APPEND(PyLong_FromLong(_Alignof(struct Packed3)));
                TEST_FIELD(int8_t, value.a);
                TEST_FIELD(int64_t, value.b);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Packed4") == 0) {

            #if (defined(MS_WIN32) || ((defined(__x86_64__) || defined(__i386__) || defined(__ppc64__)) && (defined(__GNUC__) || defined(__clang__))))

                #pragma pack(push, 8)
                struct GCC_ATTR(ms_struct) Packed4 {
                    int8_t a;
                    int64_t b;
                };
                #pragma pack(pop)
                struct Packed4 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Packed4"));
                APPEND(PyLong_FromLong(sizeof(struct Packed4)));
                APPEND(PyLong_FromLong(_Alignof(struct Packed4)));
                TEST_FIELD(int8_t, value.a);
                TEST_FIELD(int64_t, value.b);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "X86_32EdgeCase") == 0) {

                struct X86_32EdgeCase {
                    int32_t a;
                    int64_t b;
                    int32_t c;
                };
                struct X86_32EdgeCase value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("X86_32EdgeCase"));
                APPEND(PyLong_FromLong(sizeof(struct X86_32EdgeCase)));
                APPEND(PyLong_FromLong(_Alignof(struct X86_32EdgeCase)));
                TEST_FIELD(int32_t, value.a);
                TEST_FIELD(int64_t, value.b);
                TEST_FIELD(int32_t, value.c);
                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "MSBitFieldExample") == 0) {

                struct MSBitFieldExample {
                    unsigned int a :4;
                    unsigned int b :5;
                    unsigned int c :7;
                };
                struct MSBitFieldExample value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("MSBitFieldExample"));
                APPEND(PyLong_FromLong(sizeof(struct MSBitFieldExample)));
                APPEND(PyLong_FromLong(_Alignof(struct MSBitFieldExample)));
                TEST_FIELD(unsigned int, value.a);
                TEST_FIELD(unsigned int, value.b);
                TEST_FIELD(unsigned int, value.c);
                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "MSStraddlingExample") == 0) {

                struct MSStraddlingExample {
                    unsigned int first :9;
                    unsigned int second :7;
                    unsigned int may_straddle :30;
                    unsigned int last :18;
                };
                struct MSStraddlingExample value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("MSStraddlingExample"));
                APPEND(PyLong_FromLong(sizeof(struct MSStraddlingExample)));
                APPEND(PyLong_FromLong(_Alignof(struct MSStraddlingExample)));
                TEST_FIELD(unsigned int, value.first);
                TEST_FIELD(unsigned int, value.second);
                TEST_FIELD(unsigned int, value.may_straddle);
                TEST_FIELD(unsigned int, value.last);
                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "IntBits") == 0) {

                struct IntBits {
                    int A :1;
                    int B :2;
                    int C :3;
                    int D :4;
                    int E :5;
                    int F :6;
                    int G :7;
                    int H :8;
                    int I :9;
                };
                struct IntBits value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("IntBits"));
                APPEND(PyLong_FromLong(sizeof(struct IntBits)));
                APPEND(PyLong_FromLong(_Alignof(struct IntBits)));
                TEST_FIELD(int, value.A);
                TEST_FIELD(int, value.B);
                TEST_FIELD(int, value.C);
                TEST_FIELD(int, value.D);
                TEST_FIELD(int, value.E);
                TEST_FIELD(int, value.F);
                TEST_FIELD(int, value.G);
                TEST_FIELD(int, value.H);
                TEST_FIELD(int, value.I);
                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Bits") == 0) {

            #if (!defined(__xlc__))

                struct Bits {
                    int A :1;
                    int B :2;
                    int C :3;
                    int D :4;
                    int E :5;
                    int F :6;
                    int G :7;
                    int H :8;
                    int I :9;
                    short M :1;
                    short N :2;
                    short O :3;
                    short P :4;
                    short Q :5;
                    short R :6;
                    short S :7;
                };
                struct Bits value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Bits"));
                APPEND(PyLong_FromLong(sizeof(struct Bits)));
                APPEND(PyLong_FromLong(_Alignof(struct Bits)));
                TEST_FIELD(int, value.A);
                TEST_FIELD(int, value.B);
                TEST_FIELD(int, value.C);
                TEST_FIELD(int, value.D);
                TEST_FIELD(int, value.E);
                TEST_FIELD(int, value.F);
                TEST_FIELD(int, value.G);
                TEST_FIELD(int, value.H);
                TEST_FIELD(int, value.I);
                TEST_FIELD(short, value.M);
                TEST_FIELD(short, value.N);
                TEST_FIELD(short, value.O);
                TEST_FIELD(short, value.P);
                TEST_FIELD(short, value.Q);
                TEST_FIELD(short, value.R);
                TEST_FIELD(short, value.S);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "IntBits_MSVC") == 0) {

            #if (defined(MS_WIN32) || ((defined(__x86_64__) || defined(__i386__) || defined(__ppc64__)) && (defined(__GNUC__) || defined(__clang__))))

                struct GCC_ATTR(ms_struct) IntBits_MSVC {
                    int A :1;
                    int B :2;
                    int C :3;
                    int D :4;
                    int E :5;
                    int F :6;
                    int G :7;
                    int H :8;
                    int I :9;
                };
                struct IntBits_MSVC value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("IntBits_MSVC"));
                APPEND(PyLong_FromLong(sizeof(struct IntBits_MSVC)));
                APPEND(PyLong_FromLong(_Alignof(struct IntBits_MSVC)));
                TEST_FIELD(int, value.A);
                TEST_FIELD(int, value.B);
                TEST_FIELD(int, value.C);
                TEST_FIELD(int, value.D);
                TEST_FIELD(int, value.E);
                TEST_FIELD(int, value.F);
                TEST_FIELD(int, value.G);
                TEST_FIELD(int, value.H);
                TEST_FIELD(int, value.I);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Bits_MSVC") == 0) {

            #if (!defined(__xlc__)) && (defined(MS_WIN32) || ((defined(__x86_64__) || defined(__i386__) || defined(__ppc64__)) && (defined(__GNUC__) || defined(__clang__))))

                struct GCC_ATTR(ms_struct) Bits_MSVC {
                    int A :1;
                    int B :2;
                    int C :3;
                    int D :4;
                    int E :5;
                    int F :6;
                    int G :7;
                    int H :8;
                    int I :9;
                    short M :1;
                    short N :2;
                    short O :3;
                    short P :4;
                    short Q :5;
                    short R :6;
                    short S :7;
                };
                struct Bits_MSVC value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Bits_MSVC"));
                APPEND(PyLong_FromLong(sizeof(struct Bits_MSVC)));
                APPEND(PyLong_FromLong(_Alignof(struct Bits_MSVC)));
                TEST_FIELD(int, value.A);
                TEST_FIELD(int, value.B);
                TEST_FIELD(int, value.C);
                TEST_FIELD(int, value.D);
                TEST_FIELD(int, value.E);
                TEST_FIELD(int, value.F);
                TEST_FIELD(int, value.G);
                TEST_FIELD(int, value.H);
                TEST_FIELD(int, value.I);
                TEST_FIELD(short, value.M);
                TEST_FIELD(short, value.N);
                TEST_FIELD(short, value.O);
                TEST_FIELD(short, value.P);
                TEST_FIELD(short, value.Q);
                TEST_FIELD(short, value.R);
                TEST_FIELD(short, value.S);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "I64Bits") == 0) {

            #if (!defined(__xlc__))

                struct I64Bits {
                    int64_t a :1;
                    int64_t b :62;
                    int64_t c :1;
                };
                struct I64Bits value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("I64Bits"));
                APPEND(PyLong_FromLong(sizeof(struct I64Bits)));
                APPEND(PyLong_FromLong(_Alignof(struct I64Bits)));
                TEST_FIELD(int64_t, value.a);
                TEST_FIELD(int64_t, value.b);
                TEST_FIELD(int64_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "U64Bits") == 0) {

            #if (!defined(__xlc__))

                struct U64Bits {
                    uint64_t a :1;
                    uint64_t b :62;
                    uint64_t c :1;
                };
                struct U64Bits value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("U64Bits"));
                APPEND(PyLong_FromLong(sizeof(struct U64Bits)));
                APPEND(PyLong_FromLong(_Alignof(struct U64Bits)));
                TEST_FIELD(uint64_t, value.a);
                TEST_FIELD(uint64_t, value.b);
                TEST_FIELD(uint64_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct331_8") == 0) {

            #if (!defined(__xlc__))

                struct Struct331_8 {
                    int8_t a :3;
                    int8_t b :3;
                    int8_t c :1;
                };
                struct Struct331_8 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct331_8"));
                APPEND(PyLong_FromLong(sizeof(struct Struct331_8)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct331_8)));
                TEST_FIELD(int8_t, value.a);
                TEST_FIELD(int8_t, value.b);
                TEST_FIELD(int8_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct1x1_8") == 0) {

            #if (!defined(__xlc__))

                struct Struct1x1_8 {
                    int8_t a :1;
                    int8_t b :6;
                    int8_t c :1;
                };
                struct Struct1x1_8 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct1x1_8"));
                APPEND(PyLong_FromLong(sizeof(struct Struct1x1_8)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct1x1_8)));
                TEST_FIELD(int8_t, value.a);
                TEST_FIELD(int8_t, value.b);
                TEST_FIELD(int8_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct1nx1_8") == 0) {

            #if (!defined(__xlc__))

                struct Struct1nx1_8 {
                    int8_t a :1;
                    int8_t full;
                    int8_t b :6;
                    int8_t c :1;
                };
                struct Struct1nx1_8 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct1nx1_8"));
                APPEND(PyLong_FromLong(sizeof(struct Struct1nx1_8)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct1nx1_8)));
                TEST_FIELD(int8_t, value.a);
                TEST_FIELD(int8_t, value.full);
                TEST_FIELD(int8_t, value.b);
                TEST_FIELD(int8_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct3xx_8") == 0) {

            #if (!defined(__xlc__))

                struct Struct3xx_8 {
                    int8_t a :3;
                    int8_t b :6;
                    int8_t c :6;
                };
                struct Struct3xx_8 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct3xx_8"));
                APPEND(PyLong_FromLong(sizeof(struct Struct3xx_8)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct3xx_8)));
                TEST_FIELD(int8_t, value.a);
                TEST_FIELD(int8_t, value.b);
                TEST_FIELD(int8_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct331_u8") == 0) {

            #if (!defined(__xlc__))

                struct Struct331_u8 {
                    uint8_t a :3;
                    uint8_t b :3;
                    uint8_t c :1;
                };
                struct Struct331_u8 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct331_u8"));
                APPEND(PyLong_FromLong(sizeof(struct Struct331_u8)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct331_u8)));
                TEST_FIELD(uint8_t, value.a);
                TEST_FIELD(uint8_t, value.b);
                TEST_FIELD(uint8_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct1x1_u8") == 0) {

            #if (!defined(__xlc__))

                struct Struct1x1_u8 {
                    uint8_t a :1;
                    uint8_t b :6;
                    uint8_t c :1;
                };
                struct Struct1x1_u8 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct1x1_u8"));
                APPEND(PyLong_FromLong(sizeof(struct Struct1x1_u8)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct1x1_u8)));
                TEST_FIELD(uint8_t, value.a);
                TEST_FIELD(uint8_t, value.b);
                TEST_FIELD(uint8_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct1nx1_u8") == 0) {

            #if (!defined(__xlc__))

                struct Struct1nx1_u8 {
                    uint8_t a :1;
                    uint8_t full;
                    uint8_t b :6;
                    uint8_t c :1;
                };
                struct Struct1nx1_u8 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct1nx1_u8"));
                APPEND(PyLong_FromLong(sizeof(struct Struct1nx1_u8)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct1nx1_u8)));
                TEST_FIELD(uint8_t, value.a);
                TEST_FIELD(uint8_t, value.full);
                TEST_FIELD(uint8_t, value.b);
                TEST_FIELD(uint8_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct3xx_u8") == 0) {

            #if (!defined(__xlc__))

                struct Struct3xx_u8 {
                    uint8_t a :3;
                    uint8_t b :6;
                    uint8_t c :6;
                };
                struct Struct3xx_u8 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct3xx_u8"));
                APPEND(PyLong_FromLong(sizeof(struct Struct3xx_u8)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct3xx_u8)));
                TEST_FIELD(uint8_t, value.a);
                TEST_FIELD(uint8_t, value.b);
                TEST_FIELD(uint8_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct331_16") == 0) {

            #if (!defined(__xlc__))

                struct Struct331_16 {
                    int16_t a :3;
                    int16_t b :3;
                    int16_t c :1;
                };
                struct Struct331_16 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct331_16"));
                APPEND(PyLong_FromLong(sizeof(struct Struct331_16)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct331_16)));
                TEST_FIELD(int16_t, value.a);
                TEST_FIELD(int16_t, value.b);
                TEST_FIELD(int16_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct1x1_16") == 0) {

            #if (!defined(__xlc__))

                struct Struct1x1_16 {
                    int16_t a :1;
                    int16_t b :14;
                    int16_t c :1;
                };
                struct Struct1x1_16 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct1x1_16"));
                APPEND(PyLong_FromLong(sizeof(struct Struct1x1_16)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct1x1_16)));
                TEST_FIELD(int16_t, value.a);
                TEST_FIELD(int16_t, value.b);
                TEST_FIELD(int16_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct1nx1_16") == 0) {

            #if (!defined(__xlc__))

                struct Struct1nx1_16 {
                    int16_t a :1;
                    int16_t full;
                    int16_t b :14;
                    int16_t c :1;
                };
                struct Struct1nx1_16 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct1nx1_16"));
                APPEND(PyLong_FromLong(sizeof(struct Struct1nx1_16)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct1nx1_16)));
                TEST_FIELD(int16_t, value.a);
                TEST_FIELD(int16_t, value.full);
                TEST_FIELD(int16_t, value.b);
                TEST_FIELD(int16_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct3xx_16") == 0) {

            #if (!defined(__xlc__))

                struct Struct3xx_16 {
                    int16_t a :3;
                    int16_t b :14;
                    int16_t c :14;
                };
                struct Struct3xx_16 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct3xx_16"));
                APPEND(PyLong_FromLong(sizeof(struct Struct3xx_16)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct3xx_16)));
                TEST_FIELD(int16_t, value.a);
                TEST_FIELD(int16_t, value.b);
                TEST_FIELD(int16_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct331_u16") == 0) {

            #if (!defined(__xlc__))

                struct Struct331_u16 {
                    uint16_t a :3;
                    uint16_t b :3;
                    uint16_t c :1;
                };
                struct Struct331_u16 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct331_u16"));
                APPEND(PyLong_FromLong(sizeof(struct Struct331_u16)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct331_u16)));
                TEST_FIELD(uint16_t, value.a);
                TEST_FIELD(uint16_t, value.b);
                TEST_FIELD(uint16_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct1x1_u16") == 0) {

            #if (!defined(__xlc__))

                struct Struct1x1_u16 {
                    uint16_t a :1;
                    uint16_t b :14;
                    uint16_t c :1;
                };
                struct Struct1x1_u16 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct1x1_u16"));
                APPEND(PyLong_FromLong(sizeof(struct Struct1x1_u16)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct1x1_u16)));
                TEST_FIELD(uint16_t, value.a);
                TEST_FIELD(uint16_t, value.b);
                TEST_FIELD(uint16_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct1nx1_u16") == 0) {

            #if (!defined(__xlc__))

                struct Struct1nx1_u16 {
                    uint16_t a :1;
                    uint16_t full;
                    uint16_t b :14;
                    uint16_t c :1;
                };
                struct Struct1nx1_u16 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct1nx1_u16"));
                APPEND(PyLong_FromLong(sizeof(struct Struct1nx1_u16)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct1nx1_u16)));
                TEST_FIELD(uint16_t, value.a);
                TEST_FIELD(uint16_t, value.full);
                TEST_FIELD(uint16_t, value.b);
                TEST_FIELD(uint16_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct3xx_u16") == 0) {

            #if (!defined(__xlc__))

                struct Struct3xx_u16 {
                    uint16_t a :3;
                    uint16_t b :14;
                    uint16_t c :14;
                };
                struct Struct3xx_u16 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct3xx_u16"));
                APPEND(PyLong_FromLong(sizeof(struct Struct3xx_u16)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct3xx_u16)));
                TEST_FIELD(uint16_t, value.a);
                TEST_FIELD(uint16_t, value.b);
                TEST_FIELD(uint16_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct331_32") == 0) {

            #if (!defined(__xlc__))

                struct Struct331_32 {
                    int32_t a :3;
                    int32_t b :3;
                    int32_t c :1;
                };
                struct Struct331_32 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct331_32"));
                APPEND(PyLong_FromLong(sizeof(struct Struct331_32)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct331_32)));
                TEST_FIELD(int32_t, value.a);
                TEST_FIELD(int32_t, value.b);
                TEST_FIELD(int32_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct1x1_32") == 0) {

            #if (!defined(__xlc__))

                struct Struct1x1_32 {
                    int32_t a :1;
                    int32_t b :30;
                    int32_t c :1;
                };
                struct Struct1x1_32 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct1x1_32"));
                APPEND(PyLong_FromLong(sizeof(struct Struct1x1_32)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct1x1_32)));
                TEST_FIELD(int32_t, value.a);
                TEST_FIELD(int32_t, value.b);
                TEST_FIELD(int32_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct1nx1_32") == 0) {

            #if (!defined(__xlc__))

                struct Struct1nx1_32 {
                    int32_t a :1;
                    int32_t full;
                    int32_t b :30;
                    int32_t c :1;
                };
                struct Struct1nx1_32 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct1nx1_32"));
                APPEND(PyLong_FromLong(sizeof(struct Struct1nx1_32)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct1nx1_32)));
                TEST_FIELD(int32_t, value.a);
                TEST_FIELD(int32_t, value.full);
                TEST_FIELD(int32_t, value.b);
                TEST_FIELD(int32_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct3xx_32") == 0) {

            #if (!defined(__xlc__))

                struct Struct3xx_32 {
                    int32_t a :3;
                    int32_t b :30;
                    int32_t c :30;
                };
                struct Struct3xx_32 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct3xx_32"));
                APPEND(PyLong_FromLong(sizeof(struct Struct3xx_32)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct3xx_32)));
                TEST_FIELD(int32_t, value.a);
                TEST_FIELD(int32_t, value.b);
                TEST_FIELD(int32_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct331_u32") == 0) {

            #if (!defined(__xlc__))

                struct Struct331_u32 {
                    uint32_t a :3;
                    uint32_t b :3;
                    uint32_t c :1;
                };
                struct Struct331_u32 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct331_u32"));
                APPEND(PyLong_FromLong(sizeof(struct Struct331_u32)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct331_u32)));
                TEST_FIELD(uint32_t, value.a);
                TEST_FIELD(uint32_t, value.b);
                TEST_FIELD(uint32_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct1x1_u32") == 0) {

            #if (!defined(__xlc__))

                struct Struct1x1_u32 {
                    uint32_t a :1;
                    uint32_t b :30;
                    uint32_t c :1;
                };
                struct Struct1x1_u32 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct1x1_u32"));
                APPEND(PyLong_FromLong(sizeof(struct Struct1x1_u32)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct1x1_u32)));
                TEST_FIELD(uint32_t, value.a);
                TEST_FIELD(uint32_t, value.b);
                TEST_FIELD(uint32_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct1nx1_u32") == 0) {

            #if (!defined(__xlc__))

                struct Struct1nx1_u32 {
                    uint32_t a :1;
                    uint32_t full;
                    uint32_t b :30;
                    uint32_t c :1;
                };
                struct Struct1nx1_u32 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct1nx1_u32"));
                APPEND(PyLong_FromLong(sizeof(struct Struct1nx1_u32)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct1nx1_u32)));
                TEST_FIELD(uint32_t, value.a);
                TEST_FIELD(uint32_t, value.full);
                TEST_FIELD(uint32_t, value.b);
                TEST_FIELD(uint32_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct3xx_u32") == 0) {

            #if (!defined(__xlc__))

                struct Struct3xx_u32 {
                    uint32_t a :3;
                    uint32_t b :30;
                    uint32_t c :30;
                };
                struct Struct3xx_u32 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct3xx_u32"));
                APPEND(PyLong_FromLong(sizeof(struct Struct3xx_u32)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct3xx_u32)));
                TEST_FIELD(uint32_t, value.a);
                TEST_FIELD(uint32_t, value.b);
                TEST_FIELD(uint32_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct331_64") == 0) {

            #if (!defined(__xlc__))

                struct Struct331_64 {
                    int64_t a :3;
                    int64_t b :3;
                    int64_t c :1;
                };
                struct Struct331_64 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct331_64"));
                APPEND(PyLong_FromLong(sizeof(struct Struct331_64)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct331_64)));
                TEST_FIELD(int64_t, value.a);
                TEST_FIELD(int64_t, value.b);
                TEST_FIELD(int64_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct1x1_64") == 0) {

            #if (!defined(__xlc__))

                struct Struct1x1_64 {
                    int64_t a :1;
                    int64_t b :62;
                    int64_t c :1;
                };
                struct Struct1x1_64 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct1x1_64"));
                APPEND(PyLong_FromLong(sizeof(struct Struct1x1_64)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct1x1_64)));
                TEST_FIELD(int64_t, value.a);
                TEST_FIELD(int64_t, value.b);
                TEST_FIELD(int64_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct1nx1_64") == 0) {

            #if (!defined(__xlc__))

                struct Struct1nx1_64 {
                    int64_t a :1;
                    int64_t full;
                    int64_t b :62;
                    int64_t c :1;
                };
                struct Struct1nx1_64 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct1nx1_64"));
                APPEND(PyLong_FromLong(sizeof(struct Struct1nx1_64)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct1nx1_64)));
                TEST_FIELD(int64_t, value.a);
                TEST_FIELD(int64_t, value.full);
                TEST_FIELD(int64_t, value.b);
                TEST_FIELD(int64_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct3xx_64") == 0) {

            #if (!defined(__xlc__))

                struct Struct3xx_64 {
                    int64_t a :3;
                    int64_t b :62;
                    int64_t c :62;
                };
                struct Struct3xx_64 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct3xx_64"));
                APPEND(PyLong_FromLong(sizeof(struct Struct3xx_64)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct3xx_64)));
                TEST_FIELD(int64_t, value.a);
                TEST_FIELD(int64_t, value.b);
                TEST_FIELD(int64_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct331_u64") == 0) {

            #if (!defined(__xlc__))

                struct Struct331_u64 {
                    uint64_t a :3;
                    uint64_t b :3;
                    uint64_t c :1;
                };
                struct Struct331_u64 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct331_u64"));
                APPEND(PyLong_FromLong(sizeof(struct Struct331_u64)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct331_u64)));
                TEST_FIELD(uint64_t, value.a);
                TEST_FIELD(uint64_t, value.b);
                TEST_FIELD(uint64_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct1x1_u64") == 0) {

            #if (!defined(__xlc__))

                struct Struct1x1_u64 {
                    uint64_t a :1;
                    uint64_t b :62;
                    uint64_t c :1;
                };
                struct Struct1x1_u64 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct1x1_u64"));
                APPEND(PyLong_FromLong(sizeof(struct Struct1x1_u64)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct1x1_u64)));
                TEST_FIELD(uint64_t, value.a);
                TEST_FIELD(uint64_t, value.b);
                TEST_FIELD(uint64_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct1nx1_u64") == 0) {

            #if (!defined(__xlc__))

                struct Struct1nx1_u64 {
                    uint64_t a :1;
                    uint64_t full;
                    uint64_t b :62;
                    uint64_t c :1;
                };
                struct Struct1nx1_u64 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct1nx1_u64"));
                APPEND(PyLong_FromLong(sizeof(struct Struct1nx1_u64)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct1nx1_u64)));
                TEST_FIELD(uint64_t, value.a);
                TEST_FIELD(uint64_t, value.full);
                TEST_FIELD(uint64_t, value.b);
                TEST_FIELD(uint64_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Struct3xx_u64") == 0) {

            #if (!defined(__xlc__))

                struct Struct3xx_u64 {
                    uint64_t a :3;
                    uint64_t b :62;
                    uint64_t c :62;
                };
                struct Struct3xx_u64 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Struct3xx_u64"));
                APPEND(PyLong_FromLong(sizeof(struct Struct3xx_u64)));
                APPEND(PyLong_FromLong(_Alignof(struct Struct3xx_u64)));
                TEST_FIELD(uint64_t, value.a);
                TEST_FIELD(uint64_t, value.b);
                TEST_FIELD(uint64_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Mixed1") == 0) {

            #if (!defined(__xlc__))

                struct Mixed1 {
                    signed char a :4;
                    int b :4;
                };
                struct Mixed1 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Mixed1"));
                APPEND(PyLong_FromLong(sizeof(struct Mixed1)));
                APPEND(PyLong_FromLong(_Alignof(struct Mixed1)));
                TEST_FIELD(signed char, value.a);
                TEST_FIELD(int, value.b);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Mixed2") == 0) {

            #if (!defined(__xlc__))

                struct Mixed2 {
                    signed char a :4;
                    int32_t b :32;
                };
                struct Mixed2 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Mixed2"));
                APPEND(PyLong_FromLong(sizeof(struct Mixed2)));
                APPEND(PyLong_FromLong(_Alignof(struct Mixed2)));
                TEST_FIELD(signed char, value.a);
                TEST_FIELD(int32_t, value.b);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Mixed3") == 0) {

            #if (!defined(__xlc__))

                struct Mixed3 {
                    signed char a :4;
                    unsigned char b :4;
                };
                struct Mixed3 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Mixed3"));
                APPEND(PyLong_FromLong(sizeof(struct Mixed3)));
                APPEND(PyLong_FromLong(_Alignof(struct Mixed3)));
                TEST_FIELD(signed char, value.a);
                TEST_FIELD(unsigned char, value.b);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Mixed4") == 0) {

            #if (!defined(__xlc__))

                struct Mixed4 {
                    short a :4;
                    short b :4;
                    int c :24;
                    short d :4;
                    short e :4;
                    int f :24;
                };
                struct Mixed4 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Mixed4"));
                APPEND(PyLong_FromLong(sizeof(struct Mixed4)));
                APPEND(PyLong_FromLong(_Alignof(struct Mixed4)));
                TEST_FIELD(short, value.a);
                TEST_FIELD(short, value.b);
                TEST_FIELD(int, value.c);
                TEST_FIELD(short, value.d);
                TEST_FIELD(short, value.e);
                TEST_FIELD(int, value.f);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Mixed5") == 0) {

            #if (!defined(__xlc__))

                struct Mixed5 {
                    unsigned int A :1;
                    unsigned short B :16;
                };
                struct Mixed5 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Mixed5"));
                APPEND(PyLong_FromLong(sizeof(struct Mixed5)));
                APPEND(PyLong_FromLong(_Alignof(struct Mixed5)));
                TEST_FIELD(unsigned int, value.A);
                TEST_FIELD(unsigned short, value.B);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Mixed6") == 0) {

            #if (!defined(__xlc__))

                struct Mixed6 {
                    unsigned long long A :1;
                    unsigned int B :32;
                };
                struct Mixed6 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Mixed6"));
                APPEND(PyLong_FromLong(sizeof(struct Mixed6)));
                APPEND(PyLong_FromLong(_Alignof(struct Mixed6)));
                TEST_FIELD(unsigned long long, value.A);
                TEST_FIELD(unsigned int, value.B);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Mixed7") == 0) {

            #if (!defined(__xlc__))

                struct Mixed7 {
                    uint32_t A;
                    uint32_t B :20;
                    uint64_t C :24;
                };
                struct Mixed7 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Mixed7"));
                APPEND(PyLong_FromLong(sizeof(struct Mixed7)));
                APPEND(PyLong_FromLong(_Alignof(struct Mixed7)));
                TEST_FIELD(uint32_t, value.A);
                TEST_FIELD(uint32_t, value.B);
                TEST_FIELD(uint64_t, value.C);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Mixed8_a") == 0) {

            #if (!defined(__xlc__))

                struct Mixed8_a {
                    uint32_t A;
                    uint32_t B :32;
                    unsigned long long C :1;
                };
                struct Mixed8_a value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Mixed8_a"));
                APPEND(PyLong_FromLong(sizeof(struct Mixed8_a)));
                APPEND(PyLong_FromLong(_Alignof(struct Mixed8_a)));
                TEST_FIELD(uint32_t, value.A);
                TEST_FIELD(uint32_t, value.B);
                TEST_FIELD(unsigned long long, value.C);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Mixed8_b") == 0) {

            #if (!defined(__xlc__))

                struct Mixed8_b {
                    uint32_t A;
                    uint32_t B;
                    unsigned long long C :1;
                };
                struct Mixed8_b value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Mixed8_b"));
                APPEND(PyLong_FromLong(sizeof(struct Mixed8_b)));
                APPEND(PyLong_FromLong(_Alignof(struct Mixed8_b)));
                TEST_FIELD(uint32_t, value.A);
                TEST_FIELD(uint32_t, value.B);
                TEST_FIELD(unsigned long long, value.C);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Mixed9") == 0) {

            #if (!defined(__xlc__))

                struct Mixed9 {
                    uint8_t A;
                    uint32_t B :1;
                };
                struct Mixed9 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Mixed9"));
                APPEND(PyLong_FromLong(sizeof(struct Mixed9)));
                APPEND(PyLong_FromLong(_Alignof(struct Mixed9)));
                TEST_FIELD(uint8_t, value.A);
                TEST_FIELD(uint32_t, value.B);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Mixed10") == 0) {

            #if (!defined(__xlc__))

                struct Mixed10 {
                    uint32_t A :1;
                    uint64_t B :1;
                };
                struct Mixed10 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Mixed10"));
                APPEND(PyLong_FromLong(sizeof(struct Mixed10)));
                APPEND(PyLong_FromLong(_Alignof(struct Mixed10)));
                TEST_FIELD(uint32_t, value.A);
                TEST_FIELD(uint64_t, value.B);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Example_gh_95496") == 0) {

            #if (!defined(__xlc__))

                struct Example_gh_95496 {
                    uint32_t A :1;
                    uint64_t B :1;
                };
                struct Example_gh_95496 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Example_gh_95496"));
                APPEND(PyLong_FromLong(sizeof(struct Example_gh_95496)));
                APPEND(PyLong_FromLong(_Alignof(struct Example_gh_95496)));
                TEST_FIELD(uint32_t, value.A);
                TEST_FIELD(uint64_t, value.B);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Example_gh_84039_bad") == 0) {

            #if (!defined(__xlc__)) && (defined(MS_WIN32) || ((defined(__x86_64__) || defined(__i386__) || defined(__ppc64__)) && (defined(__GNUC__) || defined(__clang__))))

                #pragma pack(push, 1)
                struct GCC_ATTR(ms_struct) Example_gh_84039_bad {
                    uint8_t a0 :1;
                    uint8_t a1 :1;
                    uint8_t a2 :1;
                    uint8_t a3 :1;
                    uint8_t a4 :1;
                    uint8_t a5 :1;
                    uint8_t a6 :1;
                    uint8_t a7 :1;
                    uint16_t b0 :4;
                    uint16_t b1 :12;
                };
                #pragma pack(pop)
                struct Example_gh_84039_bad value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Example_gh_84039_bad"));
                APPEND(PyLong_FromLong(sizeof(struct Example_gh_84039_bad)));
                APPEND(PyLong_FromLong(_Alignof(struct Example_gh_84039_bad)));
                TEST_FIELD(uint8_t, value.a0);
                TEST_FIELD(uint8_t, value.a1);
                TEST_FIELD(uint8_t, value.a2);
                TEST_FIELD(uint8_t, value.a3);
                TEST_FIELD(uint8_t, value.a4);
                TEST_FIELD(uint8_t, value.a5);
                TEST_FIELD(uint8_t, value.a6);
                TEST_FIELD(uint8_t, value.a7);
                TEST_FIELD(uint16_t, value.b0);
                TEST_FIELD(uint16_t, value.b1);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Example_gh_84039_good_a") == 0) {

            #if (!defined(__xlc__)) && (defined(MS_WIN32) || ((defined(__x86_64__) || defined(__i386__) || defined(__ppc64__)) && (defined(__GNUC__) || defined(__clang__))))

                #pragma pack(push, 1)
                struct GCC_ATTR(ms_struct) Example_gh_84039_good_a {
                    uint8_t a0 :1;
                    uint8_t a1 :1;
                    uint8_t a2 :1;
                    uint8_t a3 :1;
                    uint8_t a4 :1;
                    uint8_t a5 :1;
                    uint8_t a6 :1;
                    uint8_t a7 :1;
                };
                #pragma pack(pop)
                struct Example_gh_84039_good_a value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Example_gh_84039_good_a"));
                APPEND(PyLong_FromLong(sizeof(struct Example_gh_84039_good_a)));
                APPEND(PyLong_FromLong(_Alignof(struct Example_gh_84039_good_a)));
                TEST_FIELD(uint8_t, value.a0);
                TEST_FIELD(uint8_t, value.a1);
                TEST_FIELD(uint8_t, value.a2);
                TEST_FIELD(uint8_t, value.a3);
                TEST_FIELD(uint8_t, value.a4);
                TEST_FIELD(uint8_t, value.a5);
                TEST_FIELD(uint8_t, value.a6);
                TEST_FIELD(uint8_t, value.a7);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Example_gh_84039_good") == 0) {

            #if (!defined(__xlc__)) && (defined(MS_WIN32) || ((defined(__x86_64__) || defined(__i386__) || defined(__ppc64__)) && (defined(__GNUC__) || defined(__clang__))))

                #pragma pack(push, 1)
                struct GCC_ATTR(ms_struct) Example_gh_84039_good {
                    #pragma pack(push, 1)
                    struct GCC_ATTR(ms_struct) {
                        uint8_t a0 :1;
                        uint8_t a1 :1;
                        uint8_t a2 :1;
                        uint8_t a3 :1;
                        uint8_t a4 :1;
                        uint8_t a5 :1;
                        uint8_t a6 :1;
                        uint8_t a7 :1;
                    } a;
                    #pragma pack(pop)
                    uint16_t b0 :4;
                    uint16_t b1 :12;
                };
                #pragma pack(pop)
                struct Example_gh_84039_good value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Example_gh_84039_good"));
                APPEND(PyLong_FromLong(sizeof(struct Example_gh_84039_good)));
                APPEND(PyLong_FromLong(_Alignof(struct Example_gh_84039_good)));
                TEST_FIELD(uint8_t, value.a.a0);
                TEST_FIELD(uint8_t, value.a.a1);
                TEST_FIELD(uint8_t, value.a.a2);
                TEST_FIELD(uint8_t, value.a.a3);
                TEST_FIELD(uint8_t, value.a.a4);
                TEST_FIELD(uint8_t, value.a.a5);
                TEST_FIELD(uint8_t, value.a.a6);
                TEST_FIELD(uint8_t, value.a.a7);
                TEST_FIELD(uint16_t, value.b0);
                TEST_FIELD(uint16_t, value.b1);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Example_gh_73939") == 0) {

            #if (!defined(__xlc__)) && (defined(MS_WIN32) || ((defined(__x86_64__) || defined(__i386__) || defined(__ppc64__)) && (defined(__GNUC__) || defined(__clang__))))

                #pragma pack(push, 1)
                struct GCC_ATTR(ms_struct) Example_gh_73939 {
                    uint16_t P;
                    uint16_t L :9;
                    uint16_t Pro :1;
                    uint16_t G :1;
                    uint16_t IB :1;
                    uint16_t IR :1;
                    uint16_t R :3;
                    uint32_t T :10;
                    uint32_t C :20;
                    uint32_t R2 :2;
                };
                #pragma pack(pop)
                struct Example_gh_73939 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Example_gh_73939"));
                APPEND(PyLong_FromLong(sizeof(struct Example_gh_73939)));
                APPEND(PyLong_FromLong(_Alignof(struct Example_gh_73939)));
                TEST_FIELD(uint16_t, value.P);
                TEST_FIELD(uint16_t, value.L);
                TEST_FIELD(uint16_t, value.Pro);
                TEST_FIELD(uint16_t, value.G);
                TEST_FIELD(uint16_t, value.IB);
                TEST_FIELD(uint16_t, value.IR);
                TEST_FIELD(uint16_t, value.R);
                TEST_FIELD(uint32_t, value.T);
                TEST_FIELD(uint32_t, value.C);
                TEST_FIELD(uint32_t, value.R2);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Example_gh_86098") == 0) {

            #if (!defined(__xlc__))

                struct Example_gh_86098 {
                    uint8_t a :8;
                    uint8_t b :8;
                    uint32_t c :16;
                };
                struct Example_gh_86098 value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Example_gh_86098"));
                APPEND(PyLong_FromLong(sizeof(struct Example_gh_86098)));
                APPEND(PyLong_FromLong(_Alignof(struct Example_gh_86098)));
                TEST_FIELD(uint8_t, value.a);
                TEST_FIELD(uint8_t, value.b);
                TEST_FIELD(uint32_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "Example_gh_86098_pack") == 0) {

            #if (!defined(__xlc__)) && (defined(MS_WIN32) || ((defined(__x86_64__) || defined(__i386__) || defined(__ppc64__)) && (defined(__GNUC__) || defined(__clang__))))

                #pragma pack(push, 1)
                struct GCC_ATTR(ms_struct) Example_gh_86098_pack {
                    uint8_t a :8;
                    uint8_t b :8;
                    uint32_t c :16;
                };
                #pragma pack(pop)
                struct Example_gh_86098_pack value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("Example_gh_86098_pack"));
                APPEND(PyLong_FromLong(sizeof(struct Example_gh_86098_pack)));
                APPEND(PyLong_FromLong(_Alignof(struct Example_gh_86098_pack)));
                TEST_FIELD(uint8_t, value.a);
                TEST_FIELD(uint8_t, value.b);
                TEST_FIELD(uint32_t, value.c);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            if (PyUnicode_CompareWithASCIIString(name, "AnonBitfields") == 0) {

            #if (!defined(__xlc__))

                struct AnonBitfields {
                    struct {
                        signed char a :4;
                        unsigned char b :4;
                    };
                    signed char y;
                };
                struct AnonBitfields value;
                memset(&value, 0, sizeof(value));
                APPEND(PyUnicode_FromString("AnonBitfields"));
                APPEND(PyLong_FromLong(sizeof(struct AnonBitfields)));
                APPEND(PyLong_FromLong(_Alignof(struct AnonBitfields)));
                TEST_FIELD(signed char, value.a);
                TEST_FIELD(unsigned char, value.b);
                TEST_FIELD(signed char, value.y);
            #else
                APPEND(Py_NewRef(Py_None));
                APPEND(PyUnicode_FromString("skipped on this compiler"));
            #endif

                return result;
            }

            Py_DECREF(result);
            PyErr_Format(PyExc_ValueError, "unknown testcase %R", name);
            return NULL;
        }

        #undef GCC_ATTR
        #undef TEST_FIELD
        #undef SET_AND_APPEND
        #undef APPEND

