/* This file is autogenerated by tracetool, do not edit. */
/* SPDX-License-Identifier: GPL-2.0-or-later */

#ifndef TRACE_TARGET_S390X_GENERATED_TRACERS_H
#define TRACE_TARGET_S390X_GENERATED_TRACERS_H

#include "trace/control.h"

extern TraceEvent _TRACE_IOINST_EVENT;
extern TraceEvent _TRACE_IOINST_SCH_ID_EVENT;
extern TraceEvent _TRACE_IOINST_CHP_ID_EVENT;
extern TraceEvent _TRACE_IOINST_CHSC_CMD_EVENT;
extern TraceEvent _TRACE_CPU_SET_STATE_EVENT;
extern TraceEvent _TRACE_CPU_HALT_EVENT;
extern TraceEvent _TRACE_CPU_UNHALT_EVENT;
extern TraceEvent _TRACE_SIGP_FINISHED_EVENT;
extern uint16_t _TRACE_IOINST_DSTATE;
extern uint16_t _TRACE_IOINST_SCH_ID_DSTATE;
extern uint16_t _TRACE_IOINST_CHP_ID_DSTATE;
extern uint16_t _TRACE_IOINST_CHSC_CMD_DSTATE;
extern uint16_t _TRACE_CPU_SET_STATE_DSTATE;
extern uint16_t _TRACE_CPU_HALT_DSTATE;
extern uint16_t _TRACE_CPU_UNHALT_DSTATE;
extern uint16_t _TRACE_SIGP_FINISHED_DSTATE;
#define TRACE_IOINST_ENABLED 1
#define TRACE_IOINST_SCH_ID_ENABLED 1
#define TRACE_IOINST_CHP_ID_ENABLED 1
#define TRACE_IOINST_CHSC_CMD_ENABLED 1
#define TRACE_CPU_SET_STATE_ENABLED 1
#define TRACE_CPU_HALT_ENABLED 1
#define TRACE_CPU_UNHALT_ENABLED 1
#define TRACE_SIGP_FINISHED_ENABLED 1
#include "qemu/log-for-trace.h"


#define TRACE_IOINST_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_IOINST) || \
    false)

static inline void trace_ioinst(const char *insn)
{
    if (trace_event_get_state(TRACE_IOINST)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 4 "../qemu-10.2.0/target/s390x/trace-events"
            qemu_log("ioinst " "IOINST: %s" "\n", insn);
#line 47 "trace/trace-target_s390x.h"
        }
    }
}

#define TRACE_IOINST_SCH_ID_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_IOINST_SCH_ID) || \
    false)

static inline void trace_ioinst_sch_id(const char *insn, int cssid, int ssid, int schid)
{
    if (trace_event_get_state(TRACE_IOINST_SCH_ID)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 5 "../qemu-10.2.0/target/s390x/trace-events"
            qemu_log("ioinst_sch_id " "IOINST: %s (%x.%x.%04x)" "\n", insn, cssid, ssid, schid);
#line 62 "trace/trace-target_s390x.h"
        }
    }
}

#define TRACE_IOINST_CHP_ID_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_IOINST_CHP_ID) || \
    false)

static inline void trace_ioinst_chp_id(const char *insn, int cssid, int chpid)
{
    if (trace_event_get_state(TRACE_IOINST_CHP_ID)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 6 "../qemu-10.2.0/target/s390x/trace-events"
            qemu_log("ioinst_chp_id " "IOINST: %s (%x.%02x)" "\n", insn, cssid, chpid);
#line 77 "trace/trace-target_s390x.h"
        }
    }
}

#define TRACE_IOINST_CHSC_CMD_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_IOINST_CHSC_CMD) || \
    false)

static inline void trace_ioinst_chsc_cmd(uint16_t cmd, uint16_t len)
{
    if (trace_event_get_state(TRACE_IOINST_CHSC_CMD)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 7 "../qemu-10.2.0/target/s390x/trace-events"
            qemu_log("ioinst_chsc_cmd " "IOINST: chsc command 0x%04x, len 0x%04x" "\n", cmd, len);
#line 92 "trace/trace-target_s390x.h"
        }
    }
}

#define TRACE_CPU_SET_STATE_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_CPU_SET_STATE) || \
    false)

static inline void trace_cpu_set_state(int cpu_index, uint8_t state)
{
    if (trace_event_get_state(TRACE_CPU_SET_STATE)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 10 "../qemu-10.2.0/target/s390x/trace-events"
            qemu_log("cpu_set_state " "setting cpu %d state to %" PRIu8 "\n", cpu_index, state);
#line 107 "trace/trace-target_s390x.h"
        }
    }
}

#define TRACE_CPU_HALT_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_CPU_HALT) || \
    false)

static inline void trace_cpu_halt(int cpu_index)
{
    if (trace_event_get_state(TRACE_CPU_HALT)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 11 "../qemu-10.2.0/target/s390x/trace-events"
            qemu_log("cpu_halt " "halting cpu %d" "\n", cpu_index);
#line 122 "trace/trace-target_s390x.h"
        }
    }
}

#define TRACE_CPU_UNHALT_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_CPU_UNHALT) || \
    false)

static inline void trace_cpu_unhalt(int cpu_index)
{
    if (trace_event_get_state(TRACE_CPU_UNHALT)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 12 "../qemu-10.2.0/target/s390x/trace-events"
            qemu_log("cpu_unhalt " "unhalting cpu %d" "\n", cpu_index);
#line 137 "trace/trace-target_s390x.h"
        }
    }
}

#define TRACE_SIGP_FINISHED_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_SIGP_FINISHED) || \
    false)

static inline void trace_sigp_finished(uint8_t order, int cpu_index, int dst_index, int cc)
{
    if (trace_event_get_state(TRACE_SIGP_FINISHED)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 15 "../qemu-10.2.0/target/s390x/trace-events"
            qemu_log("sigp_finished " "SIGP: Finished order %u on cpu %d -> cpu %d with cc=%d" "\n", order, cpu_index, dst_index, cc);
#line 152 "trace/trace-target_s390x.h"
        }
    }
}
#endif /* TRACE_TARGET_S390X_GENERATED_TRACERS_H */
