/* This file is autogenerated by tracetool, do not edit. */
/* SPDX-License-Identifier: GPL-2.0-or-later */

#ifndef TRACE_HW_UFS_GENERATED_TRACERS_H
#define TRACE_HW_UFS_GENERATED_TRACERS_H

#include "trace/control.h"

extern TraceEvent _TRACE_UFS_IRQ_RAISE_EVENT;
extern TraceEvent _TRACE_UFS_IRQ_LOWER_EVENT;
extern TraceEvent _TRACE_UFS_MMIO_READ_EVENT;
extern TraceEvent _TRACE_UFS_MMIO_WRITE_EVENT;
extern TraceEvent _TRACE_UFS_PROCESS_DB_EVENT;
extern TraceEvent _TRACE_UFS_PROCESS_REQ_EVENT;
extern TraceEvent _TRACE_UFS_COMPLETE_REQ_EVENT;
extern TraceEvent _TRACE_UFS_SENDBACK_REQ_EVENT;
extern TraceEvent _TRACE_UFS_EXEC_NOP_CMD_EVENT;
extern TraceEvent _TRACE_UFS_EXEC_SCSI_CMD_EVENT;
extern TraceEvent _TRACE_UFS_EXEC_QUERY_CMD_EVENT;
extern TraceEvent _TRACE_UFS_PROCESS_UICCMD_EVENT;
extern TraceEvent _TRACE_UFS_MCQ_COMPLETE_REQ_EVENT;
extern TraceEvent _TRACE_UFS_MCQ_CREATE_SQ_EVENT;
extern TraceEvent _TRACE_UFS_MCQ_CREATE_CQ_EVENT;
extern TraceEvent _TRACE_UFS_ERR_DMA_READ_UTRD_EVENT;
extern TraceEvent _TRACE_UFS_ERR_DMA_READ_REQ_UPIU_EVENT;
extern TraceEvent _TRACE_UFS_ERR_DMA_READ_PRDT_EVENT;
extern TraceEvent _TRACE_UFS_ERR_DMA_READ_SQ_EVENT;
extern TraceEvent _TRACE_UFS_ERR_DMA_WRITE_UTRD_EVENT;
extern TraceEvent _TRACE_UFS_ERR_DMA_WRITE_RSP_UPIU_EVENT;
extern TraceEvent _TRACE_UFS_ERR_DMA_WRITE_CQ_EVENT;
extern TraceEvent _TRACE_UFS_ERR_UTRL_SLOT_ERROR_EVENT;
extern TraceEvent _TRACE_UFS_ERR_UTRL_SLOT_BUSY_EVENT;
extern TraceEvent _TRACE_UFS_ERR_UNSUPPORT_REGISTER_OFFSET_EVENT;
extern TraceEvent _TRACE_UFS_ERR_INVALID_REGISTER_OFFSET_EVENT;
extern TraceEvent _TRACE_UFS_ERR_SCSI_CMD_INVALID_LUN_EVENT;
extern TraceEvent _TRACE_UFS_ERR_QUERY_FLAG_NOT_READABLE_EVENT;
extern TraceEvent _TRACE_UFS_ERR_QUERY_FLAG_NOT_WRITABLE_EVENT;
extern TraceEvent _TRACE_UFS_ERR_QUERY_ATTR_NOT_READABLE_EVENT;
extern TraceEvent _TRACE_UFS_ERR_QUERY_ATTR_NOT_WRITABLE_EVENT;
extern TraceEvent _TRACE_UFS_ERR_QUERY_INVALID_OPCODE_EVENT;
extern TraceEvent _TRACE_UFS_ERR_QUERY_INVALID_IDN_EVENT;
extern TraceEvent _TRACE_UFS_ERR_QUERY_INVALID_INDEX_EVENT;
extern TraceEvent _TRACE_UFS_ERR_INVALID_TRANS_CODE_EVENT;
extern TraceEvent _TRACE_UFS_ERR_MCQ_DB_WR_INVALID_SQID_EVENT;
extern TraceEvent _TRACE_UFS_ERR_MCQ_DB_WR_INVALID_DB_EVENT;
extern TraceEvent _TRACE_UFS_ERR_MCQ_CREATE_SQ_INVALID_SQID_EVENT;
extern TraceEvent _TRACE_UFS_ERR_MCQ_CREATE_SQ_INVALID_CQID_EVENT;
extern TraceEvent _TRACE_UFS_ERR_MCQ_CREATE_SQ_ALREADY_EXISTS_EVENT;
extern TraceEvent _TRACE_UFS_ERR_MCQ_DELETE_SQ_INVALID_SQID_EVENT;
extern TraceEvent _TRACE_UFS_ERR_MCQ_DELETE_SQ_NOT_EXISTS_EVENT;
extern TraceEvent _TRACE_UFS_ERR_MCQ_CREATE_CQ_INVALID_CQID_EVENT;
extern TraceEvent _TRACE_UFS_ERR_MCQ_CREATE_CQ_ALREADY_EXISTS_EVENT;
extern TraceEvent _TRACE_UFS_ERR_MCQ_DELETE_CQ_INVALID_CQID_EVENT;
extern TraceEvent _TRACE_UFS_ERR_MCQ_DELETE_CQ_NOT_EXISTS_EVENT;
extern TraceEvent _TRACE_UFS_ERR_MCQ_DELETE_CQ_SQ_NOT_DELETED_EVENT;
extern uint16_t _TRACE_UFS_IRQ_RAISE_DSTATE;
extern uint16_t _TRACE_UFS_IRQ_LOWER_DSTATE;
extern uint16_t _TRACE_UFS_MMIO_READ_DSTATE;
extern uint16_t _TRACE_UFS_MMIO_WRITE_DSTATE;
extern uint16_t _TRACE_UFS_PROCESS_DB_DSTATE;
extern uint16_t _TRACE_UFS_PROCESS_REQ_DSTATE;
extern uint16_t _TRACE_UFS_COMPLETE_REQ_DSTATE;
extern uint16_t _TRACE_UFS_SENDBACK_REQ_DSTATE;
extern uint16_t _TRACE_UFS_EXEC_NOP_CMD_DSTATE;
extern uint16_t _TRACE_UFS_EXEC_SCSI_CMD_DSTATE;
extern uint16_t _TRACE_UFS_EXEC_QUERY_CMD_DSTATE;
extern uint16_t _TRACE_UFS_PROCESS_UICCMD_DSTATE;
extern uint16_t _TRACE_UFS_MCQ_COMPLETE_REQ_DSTATE;
extern uint16_t _TRACE_UFS_MCQ_CREATE_SQ_DSTATE;
extern uint16_t _TRACE_UFS_MCQ_CREATE_CQ_DSTATE;
extern uint16_t _TRACE_UFS_ERR_DMA_READ_UTRD_DSTATE;
extern uint16_t _TRACE_UFS_ERR_DMA_READ_REQ_UPIU_DSTATE;
extern uint16_t _TRACE_UFS_ERR_DMA_READ_PRDT_DSTATE;
extern uint16_t _TRACE_UFS_ERR_DMA_READ_SQ_DSTATE;
extern uint16_t _TRACE_UFS_ERR_DMA_WRITE_UTRD_DSTATE;
extern uint16_t _TRACE_UFS_ERR_DMA_WRITE_RSP_UPIU_DSTATE;
extern uint16_t _TRACE_UFS_ERR_DMA_WRITE_CQ_DSTATE;
extern uint16_t _TRACE_UFS_ERR_UTRL_SLOT_ERROR_DSTATE;
extern uint16_t _TRACE_UFS_ERR_UTRL_SLOT_BUSY_DSTATE;
extern uint16_t _TRACE_UFS_ERR_UNSUPPORT_REGISTER_OFFSET_DSTATE;
extern uint16_t _TRACE_UFS_ERR_INVALID_REGISTER_OFFSET_DSTATE;
extern uint16_t _TRACE_UFS_ERR_SCSI_CMD_INVALID_LUN_DSTATE;
extern uint16_t _TRACE_UFS_ERR_QUERY_FLAG_NOT_READABLE_DSTATE;
extern uint16_t _TRACE_UFS_ERR_QUERY_FLAG_NOT_WRITABLE_DSTATE;
extern uint16_t _TRACE_UFS_ERR_QUERY_ATTR_NOT_READABLE_DSTATE;
extern uint16_t _TRACE_UFS_ERR_QUERY_ATTR_NOT_WRITABLE_DSTATE;
extern uint16_t _TRACE_UFS_ERR_QUERY_INVALID_OPCODE_DSTATE;
extern uint16_t _TRACE_UFS_ERR_QUERY_INVALID_IDN_DSTATE;
extern uint16_t _TRACE_UFS_ERR_QUERY_INVALID_INDEX_DSTATE;
extern uint16_t _TRACE_UFS_ERR_INVALID_TRANS_CODE_DSTATE;
extern uint16_t _TRACE_UFS_ERR_MCQ_DB_WR_INVALID_SQID_DSTATE;
extern uint16_t _TRACE_UFS_ERR_MCQ_DB_WR_INVALID_DB_DSTATE;
extern uint16_t _TRACE_UFS_ERR_MCQ_CREATE_SQ_INVALID_SQID_DSTATE;
extern uint16_t _TRACE_UFS_ERR_MCQ_CREATE_SQ_INVALID_CQID_DSTATE;
extern uint16_t _TRACE_UFS_ERR_MCQ_CREATE_SQ_ALREADY_EXISTS_DSTATE;
extern uint16_t _TRACE_UFS_ERR_MCQ_DELETE_SQ_INVALID_SQID_DSTATE;
extern uint16_t _TRACE_UFS_ERR_MCQ_DELETE_SQ_NOT_EXISTS_DSTATE;
extern uint16_t _TRACE_UFS_ERR_MCQ_CREATE_CQ_INVALID_CQID_DSTATE;
extern uint16_t _TRACE_UFS_ERR_MCQ_CREATE_CQ_ALREADY_EXISTS_DSTATE;
extern uint16_t _TRACE_UFS_ERR_MCQ_DELETE_CQ_INVALID_CQID_DSTATE;
extern uint16_t _TRACE_UFS_ERR_MCQ_DELETE_CQ_NOT_EXISTS_DSTATE;
extern uint16_t _TRACE_UFS_ERR_MCQ_DELETE_CQ_SQ_NOT_DELETED_DSTATE;
#define TRACE_UFS_IRQ_RAISE_ENABLED 1
#define TRACE_UFS_IRQ_LOWER_ENABLED 1
#define TRACE_UFS_MMIO_READ_ENABLED 1
#define TRACE_UFS_MMIO_WRITE_ENABLED 1
#define TRACE_UFS_PROCESS_DB_ENABLED 1
#define TRACE_UFS_PROCESS_REQ_ENABLED 1
#define TRACE_UFS_COMPLETE_REQ_ENABLED 1
#define TRACE_UFS_SENDBACK_REQ_ENABLED 1
#define TRACE_UFS_EXEC_NOP_CMD_ENABLED 1
#define TRACE_UFS_EXEC_SCSI_CMD_ENABLED 1
#define TRACE_UFS_EXEC_QUERY_CMD_ENABLED 1
#define TRACE_UFS_PROCESS_UICCMD_ENABLED 1
#define TRACE_UFS_MCQ_COMPLETE_REQ_ENABLED 1
#define TRACE_UFS_MCQ_CREATE_SQ_ENABLED 1
#define TRACE_UFS_MCQ_CREATE_CQ_ENABLED 1
#define TRACE_UFS_ERR_DMA_READ_UTRD_ENABLED 1
#define TRACE_UFS_ERR_DMA_READ_REQ_UPIU_ENABLED 1
#define TRACE_UFS_ERR_DMA_READ_PRDT_ENABLED 1
#define TRACE_UFS_ERR_DMA_READ_SQ_ENABLED 1
#define TRACE_UFS_ERR_DMA_WRITE_UTRD_ENABLED 1
#define TRACE_UFS_ERR_DMA_WRITE_RSP_UPIU_ENABLED 1
#define TRACE_UFS_ERR_DMA_WRITE_CQ_ENABLED 1
#define TRACE_UFS_ERR_UTRL_SLOT_ERROR_ENABLED 1
#define TRACE_UFS_ERR_UTRL_SLOT_BUSY_ENABLED 1
#define TRACE_UFS_ERR_UNSUPPORT_REGISTER_OFFSET_ENABLED 1
#define TRACE_UFS_ERR_INVALID_REGISTER_OFFSET_ENABLED 1
#define TRACE_UFS_ERR_SCSI_CMD_INVALID_LUN_ENABLED 1
#define TRACE_UFS_ERR_QUERY_FLAG_NOT_READABLE_ENABLED 1
#define TRACE_UFS_ERR_QUERY_FLAG_NOT_WRITABLE_ENABLED 1
#define TRACE_UFS_ERR_QUERY_ATTR_NOT_READABLE_ENABLED 1
#define TRACE_UFS_ERR_QUERY_ATTR_NOT_WRITABLE_ENABLED 1
#define TRACE_UFS_ERR_QUERY_INVALID_OPCODE_ENABLED 1
#define TRACE_UFS_ERR_QUERY_INVALID_IDN_ENABLED 1
#define TRACE_UFS_ERR_QUERY_INVALID_INDEX_ENABLED 1
#define TRACE_UFS_ERR_INVALID_TRANS_CODE_ENABLED 1
#define TRACE_UFS_ERR_MCQ_DB_WR_INVALID_SQID_ENABLED 1
#define TRACE_UFS_ERR_MCQ_DB_WR_INVALID_DB_ENABLED 1
#define TRACE_UFS_ERR_MCQ_CREATE_SQ_INVALID_SQID_ENABLED 1
#define TRACE_UFS_ERR_MCQ_CREATE_SQ_INVALID_CQID_ENABLED 1
#define TRACE_UFS_ERR_MCQ_CREATE_SQ_ALREADY_EXISTS_ENABLED 1
#define TRACE_UFS_ERR_MCQ_DELETE_SQ_INVALID_SQID_ENABLED 1
#define TRACE_UFS_ERR_MCQ_DELETE_SQ_NOT_EXISTS_ENABLED 1
#define TRACE_UFS_ERR_MCQ_CREATE_CQ_INVALID_CQID_ENABLED 1
#define TRACE_UFS_ERR_MCQ_CREATE_CQ_ALREADY_EXISTS_ENABLED 1
#define TRACE_UFS_ERR_MCQ_DELETE_CQ_INVALID_CQID_ENABLED 1
#define TRACE_UFS_ERR_MCQ_DELETE_CQ_NOT_EXISTS_ENABLED 1
#define TRACE_UFS_ERR_MCQ_DELETE_CQ_SQ_NOT_DELETED_ENABLED 1
#include "qemu/log-for-trace.h"


#define TRACE_UFS_IRQ_RAISE_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_IRQ_RAISE) || \
    false)

static inline void trace_ufs_irq_raise(void)
{
    if (trace_event_get_state(TRACE_UFS_IRQ_RAISE)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 2 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_irq_raise " "INTx" "\n");
#line 164 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_IRQ_LOWER_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_IRQ_LOWER) || \
    false)

static inline void trace_ufs_irq_lower(void)
{
    if (trace_event_get_state(TRACE_UFS_IRQ_LOWER)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 3 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_irq_lower " "INTx" "\n");
#line 179 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_MMIO_READ_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_MMIO_READ) || \
    false)

static inline void trace_ufs_mmio_read(uint64_t addr, uint64_t data, unsigned size)
{
    if (trace_event_get_state(TRACE_UFS_MMIO_READ)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 4 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_mmio_read " "addr 0x%"PRIx64" data 0x%"PRIx64" size %d" "\n", addr, data, size);
#line 194 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_MMIO_WRITE_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_MMIO_WRITE) || \
    false)

static inline void trace_ufs_mmio_write(uint64_t addr, uint64_t data, unsigned size)
{
    if (trace_event_get_state(TRACE_UFS_MMIO_WRITE)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 5 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_mmio_write " "addr 0x%"PRIx64" data 0x%"PRIx64" size %d" "\n", addr, data, size);
#line 209 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_PROCESS_DB_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_PROCESS_DB) || \
    false)

static inline void trace_ufs_process_db(uint32_t slot)
{
    if (trace_event_get_state(TRACE_UFS_PROCESS_DB)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 6 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_process_db " "UTRLDBR slot %"PRIu32"" "\n", slot);
#line 224 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_PROCESS_REQ_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_PROCESS_REQ) || \
    false)

static inline void trace_ufs_process_req(uint32_t slot)
{
    if (trace_event_get_state(TRACE_UFS_PROCESS_REQ)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 7 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_process_req " "UTRLDBR slot %"PRIu32"" "\n", slot);
#line 239 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_COMPLETE_REQ_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_COMPLETE_REQ) || \
    false)

static inline void trace_ufs_complete_req(uint32_t slot)
{
    if (trace_event_get_state(TRACE_UFS_COMPLETE_REQ)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 8 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_complete_req " "UTRLDBR slot %"PRIu32"" "\n", slot);
#line 254 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_SENDBACK_REQ_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_SENDBACK_REQ) || \
    false)

static inline void trace_ufs_sendback_req(uint32_t slot)
{
    if (trace_event_get_state(TRACE_UFS_SENDBACK_REQ)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 9 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_sendback_req " "UTRLDBR slot %"PRIu32"" "\n", slot);
#line 269 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_EXEC_NOP_CMD_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_EXEC_NOP_CMD) || \
    false)

static inline void trace_ufs_exec_nop_cmd(uint32_t slot)
{
    if (trace_event_get_state(TRACE_UFS_EXEC_NOP_CMD)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 10 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_exec_nop_cmd " "UTRLDBR slot %"PRIu32"" "\n", slot);
#line 284 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_EXEC_SCSI_CMD_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_EXEC_SCSI_CMD) || \
    false)

static inline void trace_ufs_exec_scsi_cmd(uint32_t slot, uint8_t lun, uint8_t opcode)
{
    if (trace_event_get_state(TRACE_UFS_EXEC_SCSI_CMD)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 11 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_exec_scsi_cmd " "slot %"PRIu32", lun 0x%"PRIx8", opcode 0x%"PRIx8"" "\n", slot, lun, opcode);
#line 299 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_EXEC_QUERY_CMD_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_EXEC_QUERY_CMD) || \
    false)

static inline void trace_ufs_exec_query_cmd(uint32_t slot, uint8_t opcode)
{
    if (trace_event_get_state(TRACE_UFS_EXEC_QUERY_CMD)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 12 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_exec_query_cmd " "slot %"PRIu32", opcode 0x%"PRIx8"" "\n", slot, opcode);
#line 314 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_PROCESS_UICCMD_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_PROCESS_UICCMD) || \
    false)

static inline void trace_ufs_process_uiccmd(uint32_t uiccmd, uint32_t ucmdarg1, uint32_t ucmdarg2, uint32_t ucmdarg3)
{
    if (trace_event_get_state(TRACE_UFS_PROCESS_UICCMD)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 13 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_process_uiccmd " "uiccmd 0x%"PRIx32", ucmdarg1 0x%"PRIx32", ucmdarg2 0x%"PRIx32", ucmdarg3 0x%"PRIx32"" "\n", uiccmd, ucmdarg1, ucmdarg2, ucmdarg3);
#line 329 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_MCQ_COMPLETE_REQ_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_MCQ_COMPLETE_REQ) || \
    false)

static inline void trace_ufs_mcq_complete_req(uint8_t qid)
{
    if (trace_event_get_state(TRACE_UFS_MCQ_COMPLETE_REQ)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 14 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_mcq_complete_req " "sqid %"PRIu8"" "\n", qid);
#line 344 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_MCQ_CREATE_SQ_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_MCQ_CREATE_SQ) || \
    false)

static inline void trace_ufs_mcq_create_sq(uint8_t sqid, uint8_t cqid, uint64_t addr, uint16_t size)
{
    if (trace_event_get_state(TRACE_UFS_MCQ_CREATE_SQ)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 15 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_mcq_create_sq " "mcq create sq sqid %"PRIu8", cqid %"PRIu8", addr 0x%"PRIx64", size %"PRIu16"" "\n", sqid, cqid, addr, size);
#line 359 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_MCQ_CREATE_CQ_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_MCQ_CREATE_CQ) || \
    false)

static inline void trace_ufs_mcq_create_cq(uint8_t cqid, uint64_t addr, uint16_t size)
{
    if (trace_event_get_state(TRACE_UFS_MCQ_CREATE_CQ)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 16 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_mcq_create_cq " "mcq create cq cqid %"PRIu8", addr 0x%"PRIx64", size %"PRIu16"" "\n", cqid, addr, size);
#line 374 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_DMA_READ_UTRD_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_DMA_READ_UTRD) || \
    false)

static inline void trace_ufs_err_dma_read_utrd(uint32_t slot, uint64_t addr)
{
    if (trace_event_get_state(TRACE_UFS_ERR_DMA_READ_UTRD)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 19 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_dma_read_utrd " "failed to read utrd. UTRLDBR slot %"PRIu32", UTRD dma addr %"PRIu64"" "\n", slot, addr);
#line 389 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_DMA_READ_REQ_UPIU_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_DMA_READ_REQ_UPIU) || \
    false)

static inline void trace_ufs_err_dma_read_req_upiu(uint32_t slot, uint64_t addr)
{
    if (trace_event_get_state(TRACE_UFS_ERR_DMA_READ_REQ_UPIU)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 20 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_dma_read_req_upiu " "failed to read req upiu. UTRLDBR slot %"PRIu32", request upiu addr %"PRIu64"" "\n", slot, addr);
#line 404 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_DMA_READ_PRDT_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_DMA_READ_PRDT) || \
    false)

static inline void trace_ufs_err_dma_read_prdt(uint32_t slot, uint64_t addr)
{
    if (trace_event_get_state(TRACE_UFS_ERR_DMA_READ_PRDT)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 21 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_dma_read_prdt " "failed to read prdt. UTRLDBR slot %"PRIu32", prdt addr %"PRIu64"" "\n", slot, addr);
#line 419 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_DMA_READ_SQ_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_DMA_READ_SQ) || \
    false)

static inline void trace_ufs_err_dma_read_sq(uint8_t sqid, uint64_t addr)
{
    if (trace_event_get_state(TRACE_UFS_ERR_DMA_READ_SQ)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 22 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_dma_read_sq " "failed to read sq entry. sqid %"PRIu8", hwaddr %"PRIu64"" "\n", sqid, addr);
#line 434 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_DMA_WRITE_UTRD_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_DMA_WRITE_UTRD) || \
    false)

static inline void trace_ufs_err_dma_write_utrd(uint32_t slot, uint64_t addr)
{
    if (trace_event_get_state(TRACE_UFS_ERR_DMA_WRITE_UTRD)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 23 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_dma_write_utrd " "failed to write utrd. UTRLDBR slot %"PRIu32", UTRD dma addr %"PRIu64"" "\n", slot, addr);
#line 449 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_DMA_WRITE_RSP_UPIU_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_DMA_WRITE_RSP_UPIU) || \
    false)

static inline void trace_ufs_err_dma_write_rsp_upiu(uint32_t slot, uint64_t addr)
{
    if (trace_event_get_state(TRACE_UFS_ERR_DMA_WRITE_RSP_UPIU)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 24 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_dma_write_rsp_upiu " "failed to write rsp upiu. UTRLDBR slot %"PRIu32", response upiu addr %"PRIu64"" "\n", slot, addr);
#line 464 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_DMA_WRITE_CQ_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_DMA_WRITE_CQ) || \
    false)

static inline void trace_ufs_err_dma_write_cq(uint8_t cqid, uint64_t addr)
{
    if (trace_event_get_state(TRACE_UFS_ERR_DMA_WRITE_CQ)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 25 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_dma_write_cq " "failed to write cq entry. cqid %"PRIu8", hwaddr %"PRIu64"" "\n", cqid, addr);
#line 479 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_UTRL_SLOT_ERROR_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_UTRL_SLOT_ERROR) || \
    false)

static inline void trace_ufs_err_utrl_slot_error(uint32_t slot)
{
    if (trace_event_get_state(TRACE_UFS_ERR_UTRL_SLOT_ERROR)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 26 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_utrl_slot_error " "UTRLDBR slot %"PRIu32" is in error" "\n", slot);
#line 494 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_UTRL_SLOT_BUSY_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_UTRL_SLOT_BUSY) || \
    false)

static inline void trace_ufs_err_utrl_slot_busy(uint32_t slot)
{
    if (trace_event_get_state(TRACE_UFS_ERR_UTRL_SLOT_BUSY)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 27 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_utrl_slot_busy " "UTRLDBR slot %"PRIu32" is busy" "\n", slot);
#line 509 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_UNSUPPORT_REGISTER_OFFSET_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_UNSUPPORT_REGISTER_OFFSET) || \
    false)

static inline void trace_ufs_err_unsupport_register_offset(uint32_t offset)
{
    if (trace_event_get_state(TRACE_UFS_ERR_UNSUPPORT_REGISTER_OFFSET)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 28 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_unsupport_register_offset " "Register offset 0x%"PRIx32" is not yet supported" "\n", offset);
#line 524 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_INVALID_REGISTER_OFFSET_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_INVALID_REGISTER_OFFSET) || \
    false)

static inline void trace_ufs_err_invalid_register_offset(uint32_t offset)
{
    if (trace_event_get_state(TRACE_UFS_ERR_INVALID_REGISTER_OFFSET)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 29 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_invalid_register_offset " "Register offset 0x%"PRIx32" is invalid" "\n", offset);
#line 539 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_SCSI_CMD_INVALID_LUN_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_SCSI_CMD_INVALID_LUN) || \
    false)

static inline void trace_ufs_err_scsi_cmd_invalid_lun(uint8_t lun)
{
    if (trace_event_get_state(TRACE_UFS_ERR_SCSI_CMD_INVALID_LUN)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 30 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_scsi_cmd_invalid_lun " "scsi command has invalid lun: 0x%"PRIx8"" "\n", lun);
#line 554 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_QUERY_FLAG_NOT_READABLE_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_QUERY_FLAG_NOT_READABLE) || \
    false)

static inline void trace_ufs_err_query_flag_not_readable(uint8_t idn)
{
    if (trace_event_get_state(TRACE_UFS_ERR_QUERY_FLAG_NOT_READABLE)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 31 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_query_flag_not_readable " "query flag idn 0x%"PRIx8" is denied to read" "\n", idn);
#line 569 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_QUERY_FLAG_NOT_WRITABLE_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_QUERY_FLAG_NOT_WRITABLE) || \
    false)

static inline void trace_ufs_err_query_flag_not_writable(uint8_t idn)
{
    if (trace_event_get_state(TRACE_UFS_ERR_QUERY_FLAG_NOT_WRITABLE)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 32 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_query_flag_not_writable " "query flag idn 0x%"PRIx8" is denied to write" "\n", idn);
#line 584 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_QUERY_ATTR_NOT_READABLE_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_QUERY_ATTR_NOT_READABLE) || \
    false)

static inline void trace_ufs_err_query_attr_not_readable(uint8_t idn)
{
    if (trace_event_get_state(TRACE_UFS_ERR_QUERY_ATTR_NOT_READABLE)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 33 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_query_attr_not_readable " "query attribute idn 0x%"PRIx8" is denied to read" "\n", idn);
#line 599 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_QUERY_ATTR_NOT_WRITABLE_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_QUERY_ATTR_NOT_WRITABLE) || \
    false)

static inline void trace_ufs_err_query_attr_not_writable(uint8_t idn)
{
    if (trace_event_get_state(TRACE_UFS_ERR_QUERY_ATTR_NOT_WRITABLE)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 34 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_query_attr_not_writable " "query attribute idn 0x%"PRIx8" is denied to write" "\n", idn);
#line 614 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_QUERY_INVALID_OPCODE_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_QUERY_INVALID_OPCODE) || \
    false)

static inline void trace_ufs_err_query_invalid_opcode(uint8_t opcode)
{
    if (trace_event_get_state(TRACE_UFS_ERR_QUERY_INVALID_OPCODE)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 35 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_query_invalid_opcode " "query request has invalid opcode. opcode: 0x%"PRIx8"" "\n", opcode);
#line 629 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_QUERY_INVALID_IDN_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_QUERY_INVALID_IDN) || \
    false)

static inline void trace_ufs_err_query_invalid_idn(uint8_t opcode, uint8_t idn)
{
    if (trace_event_get_state(TRACE_UFS_ERR_QUERY_INVALID_IDN)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 36 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_query_invalid_idn " "query request has invalid idn. opcode: 0x%"PRIx8", idn 0x%"PRIx8"" "\n", opcode, idn);
#line 644 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_QUERY_INVALID_INDEX_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_QUERY_INVALID_INDEX) || \
    false)

static inline void trace_ufs_err_query_invalid_index(uint8_t opcode, uint8_t index)
{
    if (trace_event_get_state(TRACE_UFS_ERR_QUERY_INVALID_INDEX)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 37 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_query_invalid_index " "query request has invalid index. opcode: 0x%"PRIx8", index 0x%"PRIx8"" "\n", opcode, index);
#line 659 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_INVALID_TRANS_CODE_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_INVALID_TRANS_CODE) || \
    false)

static inline void trace_ufs_err_invalid_trans_code(uint32_t slot, uint8_t trans_code)
{
    if (trace_event_get_state(TRACE_UFS_ERR_INVALID_TRANS_CODE)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 38 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_invalid_trans_code " "request upiu has invalid transaction code. slot: %"PRIu32", trans_code: 0x%"PRIx8"" "\n", slot, trans_code);
#line 674 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_MCQ_DB_WR_INVALID_SQID_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_MCQ_DB_WR_INVALID_SQID) || \
    false)

static inline void trace_ufs_err_mcq_db_wr_invalid_sqid(uint8_t qid)
{
    if (trace_event_get_state(TRACE_UFS_ERR_MCQ_DB_WR_INVALID_SQID)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 39 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_mcq_db_wr_invalid_sqid " "invalid mcq sqid %"PRIu8"" "\n", qid);
#line 689 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_MCQ_DB_WR_INVALID_DB_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_MCQ_DB_WR_INVALID_DB) || \
    false)

static inline void trace_ufs_err_mcq_db_wr_invalid_db(uint8_t qid, uint32_t db)
{
    if (trace_event_get_state(TRACE_UFS_ERR_MCQ_DB_WR_INVALID_DB)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 40 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_mcq_db_wr_invalid_db " "invalid mcq doorbell sqid %"PRIu8", db %"PRIu32"" "\n", qid, db);
#line 704 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_MCQ_CREATE_SQ_INVALID_SQID_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_MCQ_CREATE_SQ_INVALID_SQID) || \
    false)

static inline void trace_ufs_err_mcq_create_sq_invalid_sqid(uint8_t qid)
{
    if (trace_event_get_state(TRACE_UFS_ERR_MCQ_CREATE_SQ_INVALID_SQID)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 41 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_mcq_create_sq_invalid_sqid " "invalid mcq sqid %"PRIu8"" "\n", qid);
#line 719 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_MCQ_CREATE_SQ_INVALID_CQID_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_MCQ_CREATE_SQ_INVALID_CQID) || \
    false)

static inline void trace_ufs_err_mcq_create_sq_invalid_cqid(uint8_t qid)
{
    if (trace_event_get_state(TRACE_UFS_ERR_MCQ_CREATE_SQ_INVALID_CQID)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 42 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_mcq_create_sq_invalid_cqid " "invalid mcq cqid %"PRIu8"" "\n", qid);
#line 734 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_MCQ_CREATE_SQ_ALREADY_EXISTS_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_MCQ_CREATE_SQ_ALREADY_EXISTS) || \
    false)

static inline void trace_ufs_err_mcq_create_sq_already_exists(uint8_t qid)
{
    if (trace_event_get_state(TRACE_UFS_ERR_MCQ_CREATE_SQ_ALREADY_EXISTS)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 43 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_mcq_create_sq_already_exists " "mcq sqid %"PRIu8 "already exists" "\n", qid);
#line 749 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_MCQ_DELETE_SQ_INVALID_SQID_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_MCQ_DELETE_SQ_INVALID_SQID) || \
    false)

static inline void trace_ufs_err_mcq_delete_sq_invalid_sqid(uint8_t qid)
{
    if (trace_event_get_state(TRACE_UFS_ERR_MCQ_DELETE_SQ_INVALID_SQID)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 44 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_mcq_delete_sq_invalid_sqid " "invalid mcq sqid %"PRIu8"" "\n", qid);
#line 764 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_MCQ_DELETE_SQ_NOT_EXISTS_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_MCQ_DELETE_SQ_NOT_EXISTS) || \
    false)

static inline void trace_ufs_err_mcq_delete_sq_not_exists(uint8_t qid)
{
    if (trace_event_get_state(TRACE_UFS_ERR_MCQ_DELETE_SQ_NOT_EXISTS)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 45 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_mcq_delete_sq_not_exists " "mcq sqid %"PRIu8 "not exists" "\n", qid);
#line 779 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_MCQ_CREATE_CQ_INVALID_CQID_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_MCQ_CREATE_CQ_INVALID_CQID) || \
    false)

static inline void trace_ufs_err_mcq_create_cq_invalid_cqid(uint8_t qid)
{
    if (trace_event_get_state(TRACE_UFS_ERR_MCQ_CREATE_CQ_INVALID_CQID)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 46 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_mcq_create_cq_invalid_cqid " "invalid mcq cqid %"PRIu8"" "\n", qid);
#line 794 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_MCQ_CREATE_CQ_ALREADY_EXISTS_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_MCQ_CREATE_CQ_ALREADY_EXISTS) || \
    false)

static inline void trace_ufs_err_mcq_create_cq_already_exists(uint8_t qid)
{
    if (trace_event_get_state(TRACE_UFS_ERR_MCQ_CREATE_CQ_ALREADY_EXISTS)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 47 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_mcq_create_cq_already_exists " "mcq cqid %"PRIu8 "already exists" "\n", qid);
#line 809 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_MCQ_DELETE_CQ_INVALID_CQID_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_MCQ_DELETE_CQ_INVALID_CQID) || \
    false)

static inline void trace_ufs_err_mcq_delete_cq_invalid_cqid(uint8_t qid)
{
    if (trace_event_get_state(TRACE_UFS_ERR_MCQ_DELETE_CQ_INVALID_CQID)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 48 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_mcq_delete_cq_invalid_cqid " "invalid mcq cqid %"PRIu8"" "\n", qid);
#line 824 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_MCQ_DELETE_CQ_NOT_EXISTS_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_MCQ_DELETE_CQ_NOT_EXISTS) || \
    false)

static inline void trace_ufs_err_mcq_delete_cq_not_exists(uint8_t qid)
{
    if (trace_event_get_state(TRACE_UFS_ERR_MCQ_DELETE_CQ_NOT_EXISTS)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 49 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_mcq_delete_cq_not_exists " "mcq cqid %"PRIu8 "not exists" "\n", qid);
#line 839 "trace/trace-hw_ufs.h"
        }
    }
}

#define TRACE_UFS_ERR_MCQ_DELETE_CQ_SQ_NOT_DELETED_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_UFS_ERR_MCQ_DELETE_CQ_SQ_NOT_DELETED) || \
    false)

static inline void trace_ufs_err_mcq_delete_cq_sq_not_deleted(uint8_t sqid, uint8_t cqid)
{
    if (trace_event_get_state(TRACE_UFS_ERR_MCQ_DELETE_CQ_SQ_NOT_DELETED)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 50 "../qemu-10.2.0/hw/ufs/trace-events"
            qemu_log("ufs_err_mcq_delete_cq_sq_not_deleted " "mcq sq %"PRIu8" still has cq %"PRIu8"" "\n", sqid, cqid);
#line 854 "trace/trace-hw_ufs.h"
        }
    }
}
#endif /* TRACE_HW_UFS_GENERATED_TRACERS_H */
