// components/web_package/mojom/web_bundle_parser.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_WEB_PACKAGE_MOJOM_WEB_BUNDLE_PARSER_MOJOM_SHARED_H_
#define COMPONENTS_WEB_PACKAGE_MOJOM_WEB_BUNDLE_PARSER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "components/web_package/mojom/web_bundle_parser.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"






namespace web_package {
namespace mojom {
class BundleMetadataParseErrorDataView;

class BundleResponseParseErrorDataView;

class BundleMetadataDataView;

class BundleIndexValueDataView;

class BundleResponseLocationDataView;

class AugmentedCertificateDataView;

class VouchedSubsetDataView;

class SignedSubsetDataView;

class SubsetHashesValueDataView;

class ResourceIntegrityDataView;

class BundleResponseDataView;



}  // namespace mojom
}  // namespace web_package

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::web_package::mojom::BundleMetadataParseErrorDataView> {
  using Data = ::web_package::mojom::internal::BundleMetadataParseError_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::web_package::mojom::BundleResponseParseErrorDataView> {
  using Data = ::web_package::mojom::internal::BundleResponseParseError_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::web_package::mojom::BundleMetadataDataView> {
  using Data = ::web_package::mojom::internal::BundleMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::web_package::mojom::BundleIndexValueDataView> {
  using Data = ::web_package::mojom::internal::BundleIndexValue_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::web_package::mojom::BundleResponseLocationDataView> {
  using Data = ::web_package::mojom::internal::BundleResponseLocation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::web_package::mojom::AugmentedCertificateDataView> {
  using Data = ::web_package::mojom::internal::AugmentedCertificate_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::web_package::mojom::VouchedSubsetDataView> {
  using Data = ::web_package::mojom::internal::VouchedSubset_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::web_package::mojom::SignedSubsetDataView> {
  using Data = ::web_package::mojom::internal::SignedSubset_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::web_package::mojom::SubsetHashesValueDataView> {
  using Data = ::web_package::mojom::internal::SubsetHashesValue_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::web_package::mojom::ResourceIntegrityDataView> {
  using Data = ::web_package::mojom::internal::ResourceIntegrity_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::web_package::mojom::BundleResponseDataView> {
  using Data = ::web_package::mojom::internal::BundleResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace web_package {
namespace mojom {


enum class BundleParseErrorType : int32_t {
  
  kParserInternalError = 0,
  
  kFormatError = 1,
  
  kVersionError = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, BundleParseErrorType value);
inline bool IsKnownEnumValue(BundleParseErrorType value) {
  return internal::BundleParseErrorType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class WebBundleParserFactoryInterfaceBase {};

using WebBundleParserFactoryPtrDataView =
    mojo::InterfacePtrDataView<WebBundleParserFactoryInterfaceBase>;
using WebBundleParserFactoryRequestDataView =
    mojo::InterfaceRequestDataView<WebBundleParserFactoryInterfaceBase>;
using WebBundleParserFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebBundleParserFactoryInterfaceBase>;
using WebBundleParserFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebBundleParserFactoryInterfaceBase>;
class WebBundleParserInterfaceBase {};

using WebBundleParserPtrDataView =
    mojo::InterfacePtrDataView<WebBundleParserInterfaceBase>;
using WebBundleParserRequestDataView =
    mojo::InterfaceRequestDataView<WebBundleParserInterfaceBase>;
using WebBundleParserAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebBundleParserInterfaceBase>;
using WebBundleParserAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebBundleParserInterfaceBase>;
class BundleDataSourceInterfaceBase {};

using BundleDataSourcePtrDataView =
    mojo::InterfacePtrDataView<BundleDataSourceInterfaceBase>;
using BundleDataSourceRequestDataView =
    mojo::InterfaceRequestDataView<BundleDataSourceInterfaceBase>;
using BundleDataSourceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BundleDataSourceInterfaceBase>;
using BundleDataSourceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BundleDataSourceInterfaceBase>;


class BundleMetadataParseErrorDataView {
 public:
  BundleMetadataParseErrorDataView() {}

  BundleMetadataParseErrorDataView(
      internal::BundleMetadataParseError_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::web_package::mojom::BundleParseErrorType>(
        data_value, output);
  }

  BundleParseErrorType type() const {
    return static_cast<BundleParseErrorType>(data_->type);
  }
  inline void GetFallbackUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFallbackUrl(UserType* output) {
    
    auto* pointer = data_->fallback_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::BundleMetadataParseError_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class BundleResponseParseErrorDataView {
 public:
  BundleResponseParseErrorDataView() {}

  BundleResponseParseErrorDataView(
      internal::BundleResponseParseError_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::web_package::mojom::BundleParseErrorType>(
        data_value, output);
  }

  BundleParseErrorType type() const {
    return static_cast<BundleParseErrorType>(data_->type);
  }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::BundleResponseParseError_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class BundleMetadataDataView {
 public:
  BundleMetadataDataView() {}

  BundleMetadataDataView(
      internal::BundleMetadata_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetPrimaryUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPrimaryUrl(UserType* output) {
    
    auto* pointer = data_->primary_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetRequestsDataView(
      mojo::MapDataView<::url::mojom::UrlDataView, BundleIndexValueDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRequests(UserType* output) {
    
    auto* pointer = data_->requests.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::url::mojom::UrlDataView, ::web_package::mojom::BundleIndexValueDataView>>(
        pointer, output, context_);
  }
  inline void GetManifestUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadManifestUrl(UserType* output) {
    
    auto* pointer = data_->manifest_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetAuthoritiesDataView(
      mojo::ArrayDataView<AugmentedCertificateDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAuthorities(UserType* output) {
    
    auto* pointer = data_->authorities.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::web_package::mojom::AugmentedCertificateDataView>>(
        pointer, output, context_);
  }
  inline void GetVouchedSubsetsDataView(
      mojo::ArrayDataView<VouchedSubsetDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadVouchedSubsets(UserType* output) {
    
    auto* pointer = data_->vouched_subsets.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::web_package::mojom::VouchedSubsetDataView>>(
        pointer, output, context_);
  }
 private:
  internal::BundleMetadata_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class BundleIndexValueDataView {
 public:
  BundleIndexValueDataView() {}

  BundleIndexValueDataView(
      internal::BundleIndexValue_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetVariantsValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadVariantsValue(UserType* output) {
    
    auto* pointer = data_->variants_value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetResponseLocationsDataView(
      mojo::ArrayDataView<BundleResponseLocationDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadResponseLocations(UserType* output) {
    
    auto* pointer = data_->response_locations.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::web_package::mojom::BundleResponseLocationDataView>>(
        pointer, output, context_);
  }
 private:
  internal::BundleIndexValue_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class BundleResponseLocationDataView {
 public:
  BundleResponseLocationDataView() {}

  BundleResponseLocationDataView(
      internal::BundleResponseLocation_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t offset() const {
    return data_->offset;
  }
  uint64_t length() const {
    return data_->length;
  }
 private:
  internal::BundleResponseLocation_Data* data_ = nullptr;
};



class AugmentedCertificateDataView {
 public:
  AugmentedCertificateDataView() {}

  AugmentedCertificateDataView(
      internal::AugmentedCertificate_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetCertDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCert(UserType* output) {
    
    auto* pointer = data_->cert.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, context_);
  }
  inline void GetOcspDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOcsp(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `ocsp` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOcsp` instead "
    "of `ReadOcsp if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->ocsp.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, context_);
  }
  inline void GetSctDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSct(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `sct` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSct` instead "
    "of `ReadSct if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->sct.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, context_);
  }
 private:
  internal::AugmentedCertificate_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class VouchedSubsetDataView {
 public:
  VouchedSubsetDataView() {}

  VouchedSubsetDataView(
      internal::VouchedSubset_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  uint64_t authority() const {
    return data_->authority;
  }
  inline void GetSigDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSig(UserType* output) {
    
    auto* pointer = data_->sig.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, context_);
  }
  inline void GetRawSignedDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRawSigned(UserType* output) {
    
    auto* pointer = data_->raw_signed.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, context_);
  }
  inline void GetParsedSignedDataView(
      SignedSubsetDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadParsedSigned(UserType* output) {
    
    auto* pointer = data_->parsed_signed.Get();
    return mojo::internal::Deserialize<::web_package::mojom::SignedSubsetDataView>(
        pointer, output, context_);
  }
 private:
  internal::VouchedSubset_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class SignedSubsetDataView {
 public:
  SignedSubsetDataView() {}

  SignedSubsetDataView(
      internal::SignedSubset_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetValidityUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadValidityUrl(UserType* output) {
    
    auto* pointer = data_->validity_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetAuthSha256DataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAuthSha256(UserType* output) {
    
    auto* pointer = data_->auth_sha256.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, context_);
  }
  uint64_t date() const {
    return data_->date;
  }
  uint64_t expires() const {
    return data_->expires;
  }
  inline void GetSubsetHashesDataView(
      mojo::MapDataView<::url::mojom::UrlDataView, SubsetHashesValueDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSubsetHashes(UserType* output) {
    
    auto* pointer = data_->subset_hashes.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::url::mojom::UrlDataView, ::web_package::mojom::SubsetHashesValueDataView>>(
        pointer, output, context_);
  }
 private:
  internal::SignedSubset_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class SubsetHashesValueDataView {
 public:
  SubsetHashesValueDataView() {}

  SubsetHashesValueDataView(
      internal::SubsetHashesValue_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetVariantsValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadVariantsValue(UserType* output) {
    
    auto* pointer = data_->variants_value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetResourceIntegritiesDataView(
      mojo::ArrayDataView<ResourceIntegrityDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadResourceIntegrities(UserType* output) {
    
    auto* pointer = data_->resource_integrities.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::web_package::mojom::ResourceIntegrityDataView>>(
        pointer, output, context_);
  }
 private:
  internal::SubsetHashesValue_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class ResourceIntegrityDataView {
 public:
  ResourceIntegrityDataView() {}

  ResourceIntegrityDataView(
      internal::ResourceIntegrity_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetHeaderSha256DataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHeaderSha256(UserType* output) {
    
    auto* pointer = data_->header_sha256.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, context_);
  }
  inline void GetPayloadIntegrityHeaderDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPayloadIntegrityHeader(UserType* output) {
    
    auto* pointer = data_->payload_integrity_header.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::ResourceIntegrity_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class BundleResponseDataView {
 public:
  BundleResponseDataView() {}

  BundleResponseDataView(
      internal::BundleResponse_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t response_code() const {
    return data_->response_code;
  }
  inline void GetResponseHeadersDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadResponseHeaders(UserType* output) {
    
    auto* pointer = data_->response_headers.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        pointer, output, context_);
  }
  uint64_t payload_offset() const {
    return data_->payload_offset;
  }
  uint64_t payload_length() const {
    return data_->payload_length;
  }
 private:
  internal::BundleResponse_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace web_package

namespace std {

template <>
struct hash<::web_package::mojom::BundleParseErrorType>
    : public mojo::internal::EnumHashImpl<::web_package::mojom::BundleParseErrorType> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::web_package::mojom::BundleParseErrorType, ::web_package::mojom::BundleParseErrorType> {
  static ::web_package::mojom::BundleParseErrorType ToMojom(::web_package::mojom::BundleParseErrorType input) { return input; }
  static bool FromMojom(::web_package::mojom::BundleParseErrorType input, ::web_package::mojom::BundleParseErrorType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::web_package::mojom::BundleParseErrorType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::web_package::mojom::BundleParseErrorType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::web_package::mojom::BundleParseErrorType>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::web_package::mojom::BundleMetadataParseErrorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::BundleMetadataParseErrorDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::web_package::mojom::internal::BundleMetadataParseError_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::web_package::mojom::BundleParseErrorType>(
        Traits::type(input), &(*output)->type);
    decltype(Traits::fallback_url(input)) in_fallback_url = Traits::fallback_url(input);
    typename decltype((*output)->fallback_url)::BaseType::BufferWriter
        fallback_url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_fallback_url, buffer, &fallback_url_writer, context);
    (*output)->fallback_url.Set(
        fallback_url_writer.is_null() ? nullptr : fallback_url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->fallback_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null fallback_url in BundleMetadataParseError struct");
    decltype(Traits::message(input)) in_message = Traits::message(input);
    typename decltype((*output)->message)::BaseType::BufferWriter
        message_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_message, buffer, &message_writer, context);
    (*output)->message.Set(
        message_writer.is_null() ? nullptr : message_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->message.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null message in BundleMetadataParseError struct");
  }

  static bool Deserialize(::web_package::mojom::internal::BundleMetadataParseError_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::web_package::mojom::BundleMetadataParseErrorDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::web_package::mojom::BundleResponseParseErrorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::BundleResponseParseErrorDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::web_package::mojom::internal::BundleResponseParseError_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::web_package::mojom::BundleParseErrorType>(
        Traits::type(input), &(*output)->type);
    decltype(Traits::message(input)) in_message = Traits::message(input);
    typename decltype((*output)->message)::BaseType::BufferWriter
        message_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_message, buffer, &message_writer, context);
    (*output)->message.Set(
        message_writer.is_null() ? nullptr : message_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->message.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null message in BundleResponseParseError struct");
  }

  static bool Deserialize(::web_package::mojom::internal::BundleResponseParseError_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::web_package::mojom::BundleResponseParseErrorDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::web_package::mojom::BundleMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::BundleMetadataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::web_package::mojom::internal::BundleMetadata_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::primary_url(input)) in_primary_url = Traits::primary_url(input);
    typename decltype((*output)->primary_url)::BaseType::BufferWriter
        primary_url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_primary_url, buffer, &primary_url_writer, context);
    (*output)->primary_url.Set(
        primary_url_writer.is_null() ? nullptr : primary_url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->primary_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null primary_url in BundleMetadata struct");
    decltype(Traits::requests(input)) in_requests = Traits::requests(input);
    typename decltype((*output)->requests)::BaseType::BufferWriter
        requests_writer;
    const mojo::internal::ContainerValidateParams requests_validate_params(
        new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::MapDataView<::url::mojom::UrlDataView, ::web_package::mojom::BundleIndexValueDataView>>(
        in_requests, buffer, &requests_writer, &requests_validate_params,
        context);
    (*output)->requests.Set(
        requests_writer.is_null() ? nullptr : requests_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->requests.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null requests in BundleMetadata struct");
    decltype(Traits::manifest_url(input)) in_manifest_url = Traits::manifest_url(input);
    typename decltype((*output)->manifest_url)::BaseType::BufferWriter
        manifest_url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_manifest_url, buffer, &manifest_url_writer, context);
    (*output)->manifest_url.Set(
        manifest_url_writer.is_null() ? nullptr : manifest_url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->manifest_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null manifest_url in BundleMetadata struct");
    decltype(Traits::authorities(input)) in_authorities = Traits::authorities(input);
    typename decltype((*output)->authorities)::BaseType::BufferWriter
        authorities_writer;
    const mojo::internal::ContainerValidateParams authorities_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::web_package::mojom::AugmentedCertificateDataView>>(
        in_authorities, buffer, &authorities_writer, &authorities_validate_params,
        context);
    (*output)->authorities.Set(
        authorities_writer.is_null() ? nullptr : authorities_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->authorities.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null authorities in BundleMetadata struct");
    decltype(Traits::vouched_subsets(input)) in_vouched_subsets = Traits::vouched_subsets(input);
    typename decltype((*output)->vouched_subsets)::BaseType::BufferWriter
        vouched_subsets_writer;
    const mojo::internal::ContainerValidateParams vouched_subsets_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::web_package::mojom::VouchedSubsetDataView>>(
        in_vouched_subsets, buffer, &vouched_subsets_writer, &vouched_subsets_validate_params,
        context);
    (*output)->vouched_subsets.Set(
        vouched_subsets_writer.is_null() ? nullptr : vouched_subsets_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->vouched_subsets.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null vouched_subsets in BundleMetadata struct");
  }

  static bool Deserialize(::web_package::mojom::internal::BundleMetadata_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::web_package::mojom::BundleMetadataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::web_package::mojom::BundleIndexValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::BundleIndexValueDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::web_package::mojom::internal::BundleIndexValue_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::variants_value(input)) in_variants_value = Traits::variants_value(input);
    typename decltype((*output)->variants_value)::BaseType::BufferWriter
        variants_value_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_variants_value, buffer, &variants_value_writer, context);
    (*output)->variants_value.Set(
        variants_value_writer.is_null() ? nullptr : variants_value_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->variants_value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null variants_value in BundleIndexValue struct");
    decltype(Traits::response_locations(input)) in_response_locations = Traits::response_locations(input);
    typename decltype((*output)->response_locations)::BaseType::BufferWriter
        response_locations_writer;
    const mojo::internal::ContainerValidateParams response_locations_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::web_package::mojom::BundleResponseLocationDataView>>(
        in_response_locations, buffer, &response_locations_writer, &response_locations_validate_params,
        context);
    (*output)->response_locations.Set(
        response_locations_writer.is_null() ? nullptr : response_locations_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->response_locations.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null response_locations in BundleIndexValue struct");
  }

  static bool Deserialize(::web_package::mojom::internal::BundleIndexValue_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::web_package::mojom::BundleIndexValueDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::web_package::mojom::BundleResponseLocationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::BundleResponseLocationDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::web_package::mojom::internal::BundleResponseLocation_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->offset = Traits::offset(input);
    (*output)->length = Traits::length(input);
  }

  static bool Deserialize(::web_package::mojom::internal::BundleResponseLocation_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::web_package::mojom::BundleResponseLocationDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::web_package::mojom::AugmentedCertificateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::AugmentedCertificateDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::web_package::mojom::internal::AugmentedCertificate_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::cert(input)) in_cert = Traits::cert(input);
    typename decltype((*output)->cert)::BaseType::BufferWriter
        cert_writer;
    const mojo::internal::ContainerValidateParams cert_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_cert, buffer, &cert_writer, &cert_validate_params,
        context);
    (*output)->cert.Set(
        cert_writer.is_null() ? nullptr : cert_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->cert.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cert in AugmentedCertificate struct");
    decltype(Traits::ocsp(input)) in_ocsp = Traits::ocsp(input);
    typename decltype((*output)->ocsp)::BaseType::BufferWriter
        ocsp_writer;
    const mojo::internal::ContainerValidateParams ocsp_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_ocsp, buffer, &ocsp_writer, &ocsp_validate_params,
        context);
    (*output)->ocsp.Set(
        ocsp_writer.is_null() ? nullptr : ocsp_writer.data());
    decltype(Traits::sct(input)) in_sct = Traits::sct(input);
    typename decltype((*output)->sct)::BaseType::BufferWriter
        sct_writer;
    const mojo::internal::ContainerValidateParams sct_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_sct, buffer, &sct_writer, &sct_validate_params,
        context);
    (*output)->sct.Set(
        sct_writer.is_null() ? nullptr : sct_writer.data());
  }

  static bool Deserialize(::web_package::mojom::internal::AugmentedCertificate_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::web_package::mojom::AugmentedCertificateDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::web_package::mojom::VouchedSubsetDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::VouchedSubsetDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::web_package::mojom::internal::VouchedSubset_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->authority = Traits::authority(input);
    decltype(Traits::sig(input)) in_sig = Traits::sig(input);
    typename decltype((*output)->sig)::BaseType::BufferWriter
        sig_writer;
    const mojo::internal::ContainerValidateParams sig_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_sig, buffer, &sig_writer, &sig_validate_params,
        context);
    (*output)->sig.Set(
        sig_writer.is_null() ? nullptr : sig_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->sig.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sig in VouchedSubset struct");
    decltype(Traits::raw_signed(input)) in_raw_signed = Traits::raw_signed(input);
    typename decltype((*output)->raw_signed)::BaseType::BufferWriter
        raw_signed_writer;
    const mojo::internal::ContainerValidateParams raw_signed_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_raw_signed, buffer, &raw_signed_writer, &raw_signed_validate_params,
        context);
    (*output)->raw_signed.Set(
        raw_signed_writer.is_null() ? nullptr : raw_signed_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->raw_signed.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null raw_signed in VouchedSubset struct");
    decltype(Traits::parsed_signed(input)) in_parsed_signed = Traits::parsed_signed(input);
    typename decltype((*output)->parsed_signed)::BaseType::BufferWriter
        parsed_signed_writer;
    mojo::internal::Serialize<::web_package::mojom::SignedSubsetDataView>(
        in_parsed_signed, buffer, &parsed_signed_writer, context);
    (*output)->parsed_signed.Set(
        parsed_signed_writer.is_null() ? nullptr : parsed_signed_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->parsed_signed.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null parsed_signed in VouchedSubset struct");
  }

  static bool Deserialize(::web_package::mojom::internal::VouchedSubset_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::web_package::mojom::VouchedSubsetDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::web_package::mojom::SignedSubsetDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::SignedSubsetDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::web_package::mojom::internal::SignedSubset_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::validity_url(input)) in_validity_url = Traits::validity_url(input);
    typename decltype((*output)->validity_url)::BaseType::BufferWriter
        validity_url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_validity_url, buffer, &validity_url_writer, context);
    (*output)->validity_url.Set(
        validity_url_writer.is_null() ? nullptr : validity_url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->validity_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null validity_url in SignedSubset struct");
    decltype(Traits::auth_sha256(input)) in_auth_sha256 = Traits::auth_sha256(input);
    typename decltype((*output)->auth_sha256)::BaseType::BufferWriter
        auth_sha256_writer;
    const mojo::internal::ContainerValidateParams auth_sha256_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_auth_sha256, buffer, &auth_sha256_writer, &auth_sha256_validate_params,
        context);
    (*output)->auth_sha256.Set(
        auth_sha256_writer.is_null() ? nullptr : auth_sha256_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->auth_sha256.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null auth_sha256 in SignedSubset struct");
    (*output)->date = Traits::date(input);
    (*output)->expires = Traits::expires(input);
    decltype(Traits::subset_hashes(input)) in_subset_hashes = Traits::subset_hashes(input);
    typename decltype((*output)->subset_hashes)::BaseType::BufferWriter
        subset_hashes_writer;
    const mojo::internal::ContainerValidateParams subset_hashes_validate_params(
        new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::MapDataView<::url::mojom::UrlDataView, ::web_package::mojom::SubsetHashesValueDataView>>(
        in_subset_hashes, buffer, &subset_hashes_writer, &subset_hashes_validate_params,
        context);
    (*output)->subset_hashes.Set(
        subset_hashes_writer.is_null() ? nullptr : subset_hashes_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->subset_hashes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null subset_hashes in SignedSubset struct");
  }

  static bool Deserialize(::web_package::mojom::internal::SignedSubset_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::web_package::mojom::SignedSubsetDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::web_package::mojom::SubsetHashesValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::SubsetHashesValueDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::web_package::mojom::internal::SubsetHashesValue_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::variants_value(input)) in_variants_value = Traits::variants_value(input);
    typename decltype((*output)->variants_value)::BaseType::BufferWriter
        variants_value_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_variants_value, buffer, &variants_value_writer, context);
    (*output)->variants_value.Set(
        variants_value_writer.is_null() ? nullptr : variants_value_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->variants_value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null variants_value in SubsetHashesValue struct");
    decltype(Traits::resource_integrities(input)) in_resource_integrities = Traits::resource_integrities(input);
    typename decltype((*output)->resource_integrities)::BaseType::BufferWriter
        resource_integrities_writer;
    const mojo::internal::ContainerValidateParams resource_integrities_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::web_package::mojom::ResourceIntegrityDataView>>(
        in_resource_integrities, buffer, &resource_integrities_writer, &resource_integrities_validate_params,
        context);
    (*output)->resource_integrities.Set(
        resource_integrities_writer.is_null() ? nullptr : resource_integrities_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->resource_integrities.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null resource_integrities in SubsetHashesValue struct");
  }

  static bool Deserialize(::web_package::mojom::internal::SubsetHashesValue_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::web_package::mojom::SubsetHashesValueDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::web_package::mojom::ResourceIntegrityDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::ResourceIntegrityDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::web_package::mojom::internal::ResourceIntegrity_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::header_sha256(input)) in_header_sha256 = Traits::header_sha256(input);
    typename decltype((*output)->header_sha256)::BaseType::BufferWriter
        header_sha256_writer;
    const mojo::internal::ContainerValidateParams header_sha256_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_header_sha256, buffer, &header_sha256_writer, &header_sha256_validate_params,
        context);
    (*output)->header_sha256.Set(
        header_sha256_writer.is_null() ? nullptr : header_sha256_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->header_sha256.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null header_sha256 in ResourceIntegrity struct");
    decltype(Traits::payload_integrity_header(input)) in_payload_integrity_header = Traits::payload_integrity_header(input);
    typename decltype((*output)->payload_integrity_header)::BaseType::BufferWriter
        payload_integrity_header_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_payload_integrity_header, buffer, &payload_integrity_header_writer, context);
    (*output)->payload_integrity_header.Set(
        payload_integrity_header_writer.is_null() ? nullptr : payload_integrity_header_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->payload_integrity_header.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null payload_integrity_header in ResourceIntegrity struct");
  }

  static bool Deserialize(::web_package::mojom::internal::ResourceIntegrity_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::web_package::mojom::ResourceIntegrityDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::web_package::mojom::BundleResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::BundleResponseDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::web_package::mojom::internal::BundleResponse_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->response_code = Traits::response_code(input);
    decltype(Traits::response_headers(input)) in_response_headers = Traits::response_headers(input);
    typename decltype((*output)->response_headers)::BaseType::BufferWriter
        response_headers_writer;
    const mojo::internal::ContainerValidateParams response_headers_validate_params(
        new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        in_response_headers, buffer, &response_headers_writer, &response_headers_validate_params,
        context);
    (*output)->response_headers.Set(
        response_headers_writer.is_null() ? nullptr : response_headers_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->response_headers.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null response_headers in BundleResponse struct");
    (*output)->payload_offset = Traits::payload_offset(input);
    (*output)->payload_length = Traits::payload_length(input);
  }

  static bool Deserialize(::web_package::mojom::internal::BundleResponse_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::web_package::mojom::BundleResponseDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace web_package {
namespace mojom {

inline void BundleMetadataParseErrorDataView::GetFallbackUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->fallback_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void BundleMetadataParseErrorDataView::GetMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->message.Get();
  *output = mojo::StringDataView(pointer, context_);
}


inline void BundleResponseParseErrorDataView::GetMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->message.Get();
  *output = mojo::StringDataView(pointer, context_);
}


inline void BundleMetadataDataView::GetPrimaryUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->primary_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void BundleMetadataDataView::GetRequestsDataView(
    mojo::MapDataView<::url::mojom::UrlDataView, BundleIndexValueDataView>* output) {
  auto pointer = data_->requests.Get();
  *output = mojo::MapDataView<::url::mojom::UrlDataView, BundleIndexValueDataView>(pointer, context_);
}
inline void BundleMetadataDataView::GetManifestUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->manifest_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void BundleMetadataDataView::GetAuthoritiesDataView(
    mojo::ArrayDataView<AugmentedCertificateDataView>* output) {
  auto pointer = data_->authorities.Get();
  *output = mojo::ArrayDataView<AugmentedCertificateDataView>(pointer, context_);
}
inline void BundleMetadataDataView::GetVouchedSubsetsDataView(
    mojo::ArrayDataView<VouchedSubsetDataView>* output) {
  auto pointer = data_->vouched_subsets.Get();
  *output = mojo::ArrayDataView<VouchedSubsetDataView>(pointer, context_);
}


inline void BundleIndexValueDataView::GetVariantsValueDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->variants_value.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void BundleIndexValueDataView::GetResponseLocationsDataView(
    mojo::ArrayDataView<BundleResponseLocationDataView>* output) {
  auto pointer = data_->response_locations.Get();
  *output = mojo::ArrayDataView<BundleResponseLocationDataView>(pointer, context_);
}




inline void AugmentedCertificateDataView::GetCertDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->cert.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, context_);
}
inline void AugmentedCertificateDataView::GetOcspDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->ocsp.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, context_);
}
inline void AugmentedCertificateDataView::GetSctDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->sct.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, context_);
}


inline void VouchedSubsetDataView::GetSigDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->sig.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, context_);
}
inline void VouchedSubsetDataView::GetRawSignedDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->raw_signed.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, context_);
}
inline void VouchedSubsetDataView::GetParsedSignedDataView(
    SignedSubsetDataView* output) {
  auto pointer = data_->parsed_signed.Get();
  *output = SignedSubsetDataView(pointer, context_);
}


inline void SignedSubsetDataView::GetValidityUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->validity_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void SignedSubsetDataView::GetAuthSha256DataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->auth_sha256.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, context_);
}
inline void SignedSubsetDataView::GetSubsetHashesDataView(
    mojo::MapDataView<::url::mojom::UrlDataView, SubsetHashesValueDataView>* output) {
  auto pointer = data_->subset_hashes.Get();
  *output = mojo::MapDataView<::url::mojom::UrlDataView, SubsetHashesValueDataView>(pointer, context_);
}


inline void SubsetHashesValueDataView::GetVariantsValueDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->variants_value.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void SubsetHashesValueDataView::GetResourceIntegritiesDataView(
    mojo::ArrayDataView<ResourceIntegrityDataView>* output) {
  auto pointer = data_->resource_integrities.Get();
  *output = mojo::ArrayDataView<ResourceIntegrityDataView>(pointer, context_);
}


inline void ResourceIntegrityDataView::GetHeaderSha256DataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->header_sha256.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, context_);
}
inline void ResourceIntegrityDataView::GetPayloadIntegrityHeaderDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->payload_integrity_header.Get();
  *output = mojo::StringDataView(pointer, context_);
}


inline void BundleResponseDataView::GetResponseHeadersDataView(
    mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output) {
  auto pointer = data_->response_headers.Get();
  *output = mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>(pointer, context_);
}



}  // namespace mojom
}  // namespace web_package

#endif  // COMPONENTS_WEB_PACKAGE_MOJOM_WEB_BUNDLE_PARSER_MOJOM_SHARED_H_