// content/common/frame.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/frame.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "content/common/frame.mojom-params-data.h"
#include "content/common/frame.mojom-shared-message-ids.h"

#include "content/common/frame.mojom-import-headers.h"


#ifndef CONTENT_COMMON_FRAME_MOJOM_JUMBO_H_
#define CONTENT_COMMON_FRAME_MOJOM_JUMBO_H_
#include "content/common/frame_messages.h"
#include "content/common/input_messages.h"
#include "content/common/resource_messages.h"
#include "content/common/view_messages.h"
#include "content/common/widget_messages.h"
#include "content/public/common/common_param_traits.h"
#include "content/public/common/common_param_traits_macros.h"
#include "services/network/public/cpp/p2p_param_traits.h"
#include "third_party/blink/common/feature_policy/feature_policy_mojom_traits.h"
#endif
namespace content {
namespace mojom {
const char kNavigation_FrameSpec[] = "navigation:frame";
CreateNewWindowParams::CreateNewWindowParams()
    : allow_popup(),
      window_container_type(),
      session_storage_namespace_id(),
      clone_from_session_storage_namespace_id(),
      frame_name(),
      opener_suppressed(),
      disposition(),
      target_url(),
      referrer(),
      features() {}

CreateNewWindowParams::CreateNewWindowParams(
    bool allow_popup_in,
    ::content::mojom::WindowContainerType window_container_type_in,
    const std::string& session_storage_namespace_id_in,
    const std::string& clone_from_session_storage_namespace_id_in,
    const std::string& frame_name_in,
    bool opener_suppressed_in,
    ::WindowOpenDisposition disposition_in,
    const ::GURL& target_url_in,
    ::blink::mojom::ReferrerPtr referrer_in,
    ::blink::mojom::WindowFeaturesPtr features_in)
    : allow_popup(std::move(allow_popup_in)),
      window_container_type(std::move(window_container_type_in)),
      session_storage_namespace_id(std::move(session_storage_namespace_id_in)),
      clone_from_session_storage_namespace_id(std::move(clone_from_session_storage_namespace_id_in)),
      frame_name(std::move(frame_name_in)),
      opener_suppressed(std::move(opener_suppressed_in)),
      disposition(std::move(disposition_in)),
      target_url(std::move(target_url_in)),
      referrer(std::move(referrer_in)),
      features(std::move(features_in)) {}

CreateNewWindowParams::~CreateNewWindowParams() = default;

void CreateNewWindowParams::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetBoolean("allow_popup", this->allow_popup);
  value->SetString("window_container_type", base::trace_event::ValueToString(this->window_container_type));
  value->SetString("session_storage_namespace_id", this->session_storage_namespace_id);
  value->SetString("clone_from_session_storage_namespace_id", this->clone_from_session_storage_namespace_id);
  value->SetString("frame_name", this->frame_name);
  value->SetBoolean("opener_suppressed", this->opener_suppressed);
  value->SetInteger("disposition", static_cast<int>(this->disposition));
  value->SetString("target_url", base::trace_event::ValueToString(this->target_url, "<value of type const ::GURL&>"));
  if (this->referrer.is_null()) {
    value->SetString("referrer", "nullptr");
  } else {
    value->BeginDictionary("referrer");
    this->referrer->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->features.is_null()) {
    value->SetString("features", "nullptr");
  } else {
    value->BeginDictionary("features");
    this->features->AsValueInto(value);
    value->EndDictionary();
  }
}

bool CreateNewWindowParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateNewWindowReply::CreateNewWindowReply()
    : route_id(),
      main_frame_route_id(),
      main_frame_frame_token(),
      main_frame_widget_route_id(),
      visual_properties(),
      frame_widget_host(),
      frame_widget(),
      widget_host(),
      widget(),
      page_broadcast(),
      main_frame_interface_bundle(),
      cloned_session_storage_namespace_id(),
      devtools_main_frame_token(),
      wait_for_debugger() {}

CreateNewWindowReply::CreateNewWindowReply(
    int32_t route_id_in,
    int32_t main_frame_route_id_in,
    const ::base::UnguessableToken& main_frame_frame_token_in,
    int32_t main_frame_widget_route_id_in,
    const ::blink::VisualProperties& visual_properties_in,
    ::mojo::PendingAssociatedRemote<::blink::mojom::FrameWidgetHost> frame_widget_host_in,
    ::mojo::PendingAssociatedReceiver<::blink::mojom::FrameWidget> frame_widget_in,
    ::mojo::PendingAssociatedRemote<::blink::mojom::WidgetHost> widget_host_in,
    ::mojo::PendingAssociatedReceiver<::blink::mojom::Widget> widget_in,
    ::mojo::PendingAssociatedReceiver<::blink::mojom::PageBroadcast> page_broadcast_in,
    ::content::mojom::DocumentScopedInterfaceBundlePtr main_frame_interface_bundle_in,
    const std::string& cloned_session_storage_namespace_id_in,
    const ::base::UnguessableToken& devtools_main_frame_token_in,
    bool wait_for_debugger_in)
    : route_id(std::move(route_id_in)),
      main_frame_route_id(std::move(main_frame_route_id_in)),
      main_frame_frame_token(std::move(main_frame_frame_token_in)),
      main_frame_widget_route_id(std::move(main_frame_widget_route_id_in)),
      visual_properties(std::move(visual_properties_in)),
      frame_widget_host(std::move(frame_widget_host_in)),
      frame_widget(std::move(frame_widget_in)),
      widget_host(std::move(widget_host_in)),
      widget(std::move(widget_in)),
      page_broadcast(std::move(page_broadcast_in)),
      main_frame_interface_bundle(std::move(main_frame_interface_bundle_in)),
      cloned_session_storage_namespace_id(std::move(cloned_session_storage_namespace_id_in)),
      devtools_main_frame_token(std::move(devtools_main_frame_token_in)),
      wait_for_debugger(std::move(wait_for_debugger_in)) {}

CreateNewWindowReply::~CreateNewWindowReply() = default;

void CreateNewWindowReply::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetInteger("route_id", this->route_id);
  value->SetInteger("main_frame_route_id", this->main_frame_route_id);
  value->SetString("main_frame_frame_token", base::trace_event::ValueToString(this->main_frame_frame_token, "<value of type const ::base::UnguessableToken&>"));
  value->SetInteger("main_frame_widget_route_id", this->main_frame_widget_route_id);
  value->SetString("visual_properties", base::trace_event::ValueToString(this->visual_properties, "<value of type const ::blink::VisualProperties&>"));
  value->SetBoolean("frame_widget_host", this->frame_widget_host.is_valid());
  value->SetBoolean("frame_widget", this->frame_widget.is_valid());
  value->SetBoolean("widget_host", this->widget_host.is_valid());
  value->SetBoolean("widget", this->widget.is_valid());
  value->SetBoolean("page_broadcast", this->page_broadcast.is_valid());
  if (this->main_frame_interface_bundle.is_null()) {
    value->SetString("main_frame_interface_bundle", "nullptr");
  } else {
    value->BeginDictionary("main_frame_interface_bundle");
    this->main_frame_interface_bundle->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetString("cloned_session_storage_namespace_id", this->cloned_session_storage_namespace_id);
  value->SetString("devtools_main_frame_token", base::trace_event::ValueToString(this->devtools_main_frame_token, "<value of type const ::base::UnguessableToken&>"));
  value->SetBoolean("wait_for_debugger", this->wait_for_debugger);
}

bool CreateNewWindowReply::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
OpenURLParams::OpenURLParams()
    : url(),
      initiator_origin(),
      initiator_routing_id(),
      post_body(),
      extra_headers(),
      referrer(),
      disposition(),
      should_replace_current_entry(),
      user_gesture(),
      triggering_event_info(),
      blob_url_token(),
      href_translate(),
      impression(),
      download_policy() {}

OpenURLParams::OpenURLParams(
    const ::GURL& url_in,
    const ::url::Origin& initiator_origin_in,
    int32_t initiator_routing_id_in,
    ::scoped_refptr<::network::ResourceRequestBody> post_body_in,
    const std::string& extra_headers_in,
    ::blink::mojom::ReferrerPtr referrer_in,
    ::WindowOpenDisposition disposition_in,
    bool should_replace_current_entry_in,
    bool user_gesture_in,
    ::blink::TriggeringEventInfo triggering_event_info_in,
    ::mojo::ScopedMessagePipeHandle blob_url_token_in,
    const std::string& href_translate_in,
    const base::Optional<::content::Impression>& impression_in,
    const ::content::NavigationDownloadPolicy& download_policy_in)
    : url(std::move(url_in)),
      initiator_origin(std::move(initiator_origin_in)),
      initiator_routing_id(std::move(initiator_routing_id_in)),
      post_body(std::move(post_body_in)),
      extra_headers(std::move(extra_headers_in)),
      referrer(std::move(referrer_in)),
      disposition(std::move(disposition_in)),
      should_replace_current_entry(std::move(should_replace_current_entry_in)),
      user_gesture(std::move(user_gesture_in)),
      triggering_event_info(std::move(triggering_event_info_in)),
      blob_url_token(std::move(blob_url_token_in)),
      href_translate(std::move(href_translate_in)),
      impression(std::move(impression_in)),
      download_policy(std::move(download_policy_in)) {}

OpenURLParams::~OpenURLParams() = default;

void OpenURLParams::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("url", base::trace_event::ValueToString(this->url, "<value of type const ::GURL&>"));
  value->SetString("initiator_origin", base::trace_event::ValueToString(this->initiator_origin, "<value of type const ::url::Origin&>"));
  value->SetInteger("initiator_routing_id", this->initiator_routing_id);
  value->SetString("post_body", base::trace_event::ValueToString(this->post_body, "<value of type ::scoped_refptr<::network::ResourceRequestBody>>"));
  value->SetString("extra_headers", this->extra_headers);
  if (this->referrer.is_null()) {
    value->SetString("referrer", "nullptr");
  } else {
    value->BeginDictionary("referrer");
    this->referrer->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetInteger("disposition", static_cast<int>(this->disposition));
  value->SetBoolean("should_replace_current_entry", this->should_replace_current_entry);
  value->SetBoolean("user_gesture", this->user_gesture);
  value->SetInteger("triggering_event_info", static_cast<int>(this->triggering_event_info));
  value->SetBoolean("blob_url_token", this->blob_url_token.is_valid());
  value->SetString("href_translate", this->href_translate);
  value->SetString("impression", base::trace_event::ValueToString(this->impression, "<value of type const base::Optional<::content::Impression>&>"));
  value->SetString("download_policy", base::trace_event::ValueToString(this->download_policy, "<value of type const ::content::NavigationDownloadPolicy&>"));
}

bool OpenURLParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char FrameHTMLSerializerHandler::Name_[] = "content.mojom.FrameHTMLSerializerHandler";

FrameHTMLSerializerHandlerProxy::FrameHTMLSerializerHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameHTMLSerializerHandlerProxy::DidReceiveData(
    const std::string& in_data_buffer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHTMLSerializerHandler::DidReceiveData", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("data_buffer", in_data_buffer);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHTMLSerializerHandler_DidReceiveData_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHTMLSerializerHandler_DidReceiveData_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->data_buffer)::BaseType::BufferWriter
      data_buffer_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_data_buffer, buffer, &data_buffer_writer, &serialization_context);
  params->data_buffer.Set(
      data_buffer_writer.is_null() ? nullptr : data_buffer_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data_buffer.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data_buffer in FrameHTMLSerializerHandler.DidReceiveData request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHTMLSerializerHandler::Name_);
  message.set_method_name("DidReceiveData");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameHTMLSerializerHandlerProxy::Done(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::FrameHTMLSerializerHandler::Done");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHTMLSerializerHandler_Done_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHTMLSerializerHandler_Done_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHTMLSerializerHandler::Name_);
  message.set_method_name("Done");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool FrameHTMLSerializerHandlerStubDispatch::Accept(
    FrameHTMLSerializerHandler* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kFrameHTMLSerializerHandler_DidReceiveData_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHTMLSerializerHandler::DidReceiveData",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHTMLSerializerHandler::DidReceiveData");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHTMLSerializerHandler_DidReceiveData_Params_Data* params =
          reinterpret_cast<internal::FrameHTMLSerializerHandler_DidReceiveData_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_data_buffer{};
      FrameHTMLSerializerHandler_DidReceiveData_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadDataBuffer(&p_data_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHTMLSerializerHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidReceiveData(
std::move(p_data_buffer));
      return true;
    }
    case internal::kFrameHTMLSerializerHandler_Done_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHTMLSerializerHandler::Done",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHTMLSerializerHandler::Done");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHTMLSerializerHandler_Done_Params_Data* params =
          reinterpret_cast<internal::FrameHTMLSerializerHandler_Done_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FrameHTMLSerializerHandler_Done_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHTMLSerializerHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Done();
      return true;
    }
  }
  return false;
}

// static
bool FrameHTMLSerializerHandlerStubDispatch::AcceptWithResponder(
    FrameHTMLSerializerHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFrameHTMLSerializerHandler_DidReceiveData_Name: {
      break;
    }
    case internal::kFrameHTMLSerializerHandler_Done_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameHTMLSerializerHandlerValidationInfo[] = {
    {internal::kFrameHTMLSerializerHandler_DidReceiveData_Name,
     {&internal::FrameHTMLSerializerHandler_DidReceiveData_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameHTMLSerializerHandler_Done_Name,
     {&internal::FrameHTMLSerializerHandler_Done_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FrameHTMLSerializerHandlerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::FrameHTMLSerializerHandler::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFrameHTMLSerializerHandlerValidationInfo);
}

const char Frame::Name_[] = "content.mojom.Frame";

class Frame_GetCanonicalUrlForSharing_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Frame_GetCanonicalUrlForSharing_ForwardToCallback(
      Frame::GetCanonicalUrlForSharingCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Frame::GetCanonicalUrlForSharingCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Frame_GetCanonicalUrlForSharing_ForwardToCallback);
};

class Frame_SnapshotAccessibilityTree_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Frame_SnapshotAccessibilityTree_ForwardToCallback(
      Frame::SnapshotAccessibilityTreeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Frame::SnapshotAccessibilityTreeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Frame_SnapshotAccessibilityTree_ForwardToCallback);
};

FrameProxy::FrameProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameProxy::GetInterfaceProvider(
    ::mojo::PendingReceiver<::service_manager::mojom::InterfaceProvider> in_interfaces) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Frame::GetInterfaceProvider", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("interfaces", in_interfaces.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_GetInterfaceProvider_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::Frame_GetInterfaceProvider_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::service_manager::mojom::InterfaceProviderInterfaceBase>>(
      in_interfaces, &params->interfaces, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->interfaces),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid interfaces in Frame.GetInterfaceProvider request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("GetInterfaceProvider");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameProxy::GetCanonicalUrlForSharing(
    GetCanonicalUrlForSharingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::Frame::GetCanonicalUrlForSharing");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_GetCanonicalUrlForSharing_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::Frame_GetCanonicalUrlForSharing_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("GetCanonicalUrlForSharing");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Frame_GetCanonicalUrlForSharing_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FrameProxy::BlockRequests(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::Frame::BlockRequests");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_BlockRequests_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::Frame_BlockRequests_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("BlockRequests");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameProxy::ResumeBlockedRequests(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::Frame::ResumeBlockedRequests");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_ResumeBlockedRequests_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::Frame_ResumeBlockedRequests_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("ResumeBlockedRequests");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameProxy::CancelBlockedRequests(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::Frame::CancelBlockedRequests");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_CancelBlockedRequests_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::Frame_CancelBlockedRequests_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("CancelBlockedRequests");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameProxy::UpdateBrowserControlsState(
    ::content::BrowserControlsState in_constraints, ::content::BrowserControlsState in_current, bool in_animate) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Frame::UpdateBrowserControlsState", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("constraints", static_cast<int>(in_constraints));
      raw_value->SetInteger("current", static_cast<int>(in_current));
      raw_value->SetBoolean("animate", in_animate);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_UpdateBrowserControlsState_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::Frame_UpdateBrowserControlsState_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::content::mojom::BrowserControlsState>(
      in_constraints, &params->constraints);
  mojo::internal::Serialize<::content::mojom::BrowserControlsState>(
      in_current, &params->current);
  params->animate = in_animate;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("UpdateBrowserControlsState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameProxy::SnapshotAccessibilityTree(
    uint32_t in_ax_mode, SnapshotAccessibilityTreeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Frame::SnapshotAccessibilityTree", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("ax_mode", base::NumberToString(in_ax_mode));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_SnapshotAccessibilityTree_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::Frame_SnapshotAccessibilityTree_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->ax_mode = in_ax_mode;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("SnapshotAccessibilityTree");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Frame_SnapshotAccessibilityTree_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FrameProxy::GetSerializedHtmlWithLocalLinks(
    const base::flat_map<::GURL, ::base::FilePath>& in_url_map, const base::flat_map<::base::UnguessableToken, ::base::FilePath>& in_frame_token_map, bool in_save_with_empty_url, ::mojo::PendingRemote<FrameHTMLSerializerHandler> in_handler_remote) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Frame::GetSerializedHtmlWithLocalLinks", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginDictionary("url_map");
      for (const auto& item0 : in_url_map) {
        raw_value->SetStringWithCopiedName(base::trace_event::ValueToString(item0.first, "<value of type const ::GURL&>"), base::trace_event::ValueToString(item0.second, "<value of type const ::base::FilePath&>"));
      }
      raw_value->EndDictionary();
      raw_value->BeginDictionary("frame_token_map");
      for (const auto& item0 : in_frame_token_map) {
        raw_value->SetStringWithCopiedName(base::trace_event::ValueToString(item0.first, "<value of type const ::base::UnguessableToken&>"), base::trace_event::ValueToString(item0.second, "<value of type const ::base::FilePath&>"));
      }
      raw_value->EndDictionary();
      raw_value->SetBoolean("save_with_empty_url", in_save_with_empty_url);
      raw_value->SetBoolean("handler_remote", in_handler_remote.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_GetSerializedHtmlWithLocalLinks_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::Frame_GetSerializedHtmlWithLocalLinks_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url_map)::BaseType::BufferWriter
      url_map_writer;
  const mojo::internal::ContainerValidateParams url_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::MapDataView<::url::mojom::UrlDataView, ::mojo_base::mojom::FilePathDataView>>(
      in_url_map, buffer, &url_map_writer, &url_map_validate_params,
      &serialization_context);
  params->url_map.Set(
      url_map_writer.is_null() ? nullptr : url_map_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url_map.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url_map in Frame.GetSerializedHtmlWithLocalLinks request");
  typename decltype(params->frame_token_map)::BaseType::BufferWriter
      frame_token_map_writer;
  const mojo::internal::ContainerValidateParams frame_token_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::MapDataView<::mojo_base::mojom::UnguessableTokenDataView, ::mojo_base::mojom::FilePathDataView>>(
      in_frame_token_map, buffer, &frame_token_map_writer, &frame_token_map_validate_params,
      &serialization_context);
  params->frame_token_map.Set(
      frame_token_map_writer.is_null() ? nullptr : frame_token_map_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_token_map.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_token_map in Frame.GetSerializedHtmlWithLocalLinks request");
  params->save_with_empty_url = in_save_with_empty_url;
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::content::mojom::FrameHTMLSerializerHandlerInterfaceBase>>(
      in_handler_remote, &params->handler_remote, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->handler_remote),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid handler_remote in Frame.GetSerializedHtmlWithLocalLinks request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("GetSerializedHtmlWithLocalLinks");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class Frame_GetCanonicalUrlForSharing_ProxyToResponder {
 public:
  static Frame::GetCanonicalUrlForSharingCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Frame_GetCanonicalUrlForSharing_ProxyToResponder> proxy(
        new Frame_GetCanonicalUrlForSharing_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Frame_GetCanonicalUrlForSharing_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Frame_GetCanonicalUrlForSharing_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Frame_GetCanonicalUrlForSharing_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Frame::GetCanonicalUrlForSharingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const base::Optional<::GURL>& in_canonical_url);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Frame_GetCanonicalUrlForSharing_ProxyToResponder);
};

bool Frame_GetCanonicalUrlForSharing_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::Frame::GetCanonicalUrlForSharingCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::Frame_GetCanonicalUrlForSharing_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Frame_GetCanonicalUrlForSharing_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  base::Optional<::GURL> p_canonical_url{};
  Frame_GetCanonicalUrlForSharing_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadCanonicalUrl(&p_canonical_url))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Frame::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_canonical_url));
  return true;
}

void Frame_GetCanonicalUrlForSharing_ProxyToResponder::Run(
    const base::Optional<::GURL>& in_canonical_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::Frame::GetCanonicalUrlForSharingCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("canonical_url", base::trace_event::ValueToString(in_canonical_url, "<value of type const base::Optional<::GURL>&>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_GetCanonicalUrlForSharing_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::Frame_GetCanonicalUrlForSharing_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->canonical_url)::BaseType::BufferWriter
      canonical_url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_canonical_url, buffer, &canonical_url_writer, &serialization_context);
  params->canonical_url.Set(
      canonical_url_writer.is_null() ? nullptr : canonical_url_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::Frame::GetCanonicalUrlForSharingCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("GetCanonicalUrlForSharing");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Frame_SnapshotAccessibilityTree_ProxyToResponder {
 public:
  static Frame::SnapshotAccessibilityTreeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Frame_SnapshotAccessibilityTree_ProxyToResponder> proxy(
        new Frame_SnapshotAccessibilityTree_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Frame_SnapshotAccessibilityTree_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Frame_SnapshotAccessibilityTree_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Frame_SnapshotAccessibilityTree_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Frame::SnapshotAccessibilityTreeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::ui::AXTreeUpdate& in_snapshot);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Frame_SnapshotAccessibilityTree_ProxyToResponder);
};

bool Frame_SnapshotAccessibilityTree_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::Frame::SnapshotAccessibilityTreeCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::Frame_SnapshotAccessibilityTree_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Frame_SnapshotAccessibilityTree_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::ui::AXTreeUpdate p_snapshot{};
  Frame_SnapshotAccessibilityTree_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadSnapshot(&p_snapshot))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Frame::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_snapshot));
  return true;
}

void Frame_SnapshotAccessibilityTree_ProxyToResponder::Run(
    const ::ui::AXTreeUpdate& in_snapshot) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::Frame::SnapshotAccessibilityTreeCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("snapshot", base::trace_event::ValueToString(in_snapshot, "<value of type const ::ui::AXTreeUpdate&>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_SnapshotAccessibilityTree_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::Frame_SnapshotAccessibilityTree_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->snapshot)::BaseType::BufferWriter
      snapshot_writer;
  mojo::internal::Serialize<::ax::mojom::AXTreeUpdateDataView>(
      in_snapshot, buffer, &snapshot_writer, &serialization_context);
  params->snapshot.Set(
      snapshot_writer.is_null() ? nullptr : snapshot_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->snapshot.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null snapshot in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::Frame::SnapshotAccessibilityTreeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("SnapshotAccessibilityTree");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FrameStubDispatch::Accept(
    Frame* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kFrame_GetInterfaceProvider_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Frame::GetInterfaceProvider",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Frame::GetInterfaceProvider");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Frame_GetInterfaceProvider_Params_Data* params =
          reinterpret_cast<internal::Frame_GetInterfaceProvider_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::service_manager::mojom::InterfaceProvider> p_interfaces{};
      Frame_GetInterfaceProvider_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_interfaces =
            input_data_view.TakeInterfaces<decltype(p_interfaces)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetInterfaceProvider(
std::move(p_interfaces));
      return true;
    }
    case internal::kFrame_GetCanonicalUrlForSharing_Name: {
      break;
    }
    case internal::kFrame_BlockRequests_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Frame::BlockRequests",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Frame::BlockRequests");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Frame_BlockRequests_Params_Data* params =
          reinterpret_cast<internal::Frame_BlockRequests_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      Frame_BlockRequests_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BlockRequests();
      return true;
    }
    case internal::kFrame_ResumeBlockedRequests_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Frame::ResumeBlockedRequests",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Frame::ResumeBlockedRequests");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Frame_ResumeBlockedRequests_Params_Data* params =
          reinterpret_cast<internal::Frame_ResumeBlockedRequests_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      Frame_ResumeBlockedRequests_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResumeBlockedRequests();
      return true;
    }
    case internal::kFrame_CancelBlockedRequests_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Frame::CancelBlockedRequests",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Frame::CancelBlockedRequests");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Frame_CancelBlockedRequests_Params_Data* params =
          reinterpret_cast<internal::Frame_CancelBlockedRequests_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      Frame_CancelBlockedRequests_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelBlockedRequests();
      return true;
    }
    case internal::kFrame_UpdateBrowserControlsState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Frame::UpdateBrowserControlsState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Frame::UpdateBrowserControlsState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Frame_UpdateBrowserControlsState_Params_Data* params =
          reinterpret_cast<internal::Frame_UpdateBrowserControlsState_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::content::BrowserControlsState p_constraints{};
      ::content::BrowserControlsState p_current{};
      bool p_animate{};
      Frame_UpdateBrowserControlsState_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadConstraints(&p_constraints))
        success = false;
      if (success && !input_data_view.ReadCurrent(&p_current))
        success = false;
      if (success)
        p_animate = input_data_view.animate();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateBrowserControlsState(
std::move(p_constraints), 
std::move(p_current), 
std::move(p_animate));
      return true;
    }
    case internal::kFrame_SnapshotAccessibilityTree_Name: {
      break;
    }
    case internal::kFrame_GetSerializedHtmlWithLocalLinks_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Frame::GetSerializedHtmlWithLocalLinks",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Frame::GetSerializedHtmlWithLocalLinks");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Frame_GetSerializedHtmlWithLocalLinks_Params_Data* params =
          reinterpret_cast<internal::Frame_GetSerializedHtmlWithLocalLinks_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      base::flat_map<::GURL, ::base::FilePath> p_url_map{};
      base::flat_map<::base::UnguessableToken, ::base::FilePath> p_frame_token_map{};
      bool p_save_with_empty_url{};
      ::mojo::PendingRemote<FrameHTMLSerializerHandler> p_handler_remote{};
      Frame_GetSerializedHtmlWithLocalLinks_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUrlMap(&p_url_map))
        success = false;
      if (success && !input_data_view.ReadFrameTokenMap(&p_frame_token_map))
        success = false;
      if (success)
        p_save_with_empty_url = input_data_view.save_with_empty_url();
      if (success) {
        p_handler_remote =
            input_data_view.TakeHandlerRemote<decltype(p_handler_remote)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSerializedHtmlWithLocalLinks(
std::move(p_url_map), 
std::move(p_frame_token_map), 
std::move(p_save_with_empty_url), 
std::move(p_handler_remote));
      return true;
    }
  }
  return false;
}

// static
bool FrameStubDispatch::AcceptWithResponder(
    Frame* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFrame_GetInterfaceProvider_Name: {
      break;
    }
    case internal::kFrame_GetCanonicalUrlForSharing_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Frame::GetCanonicalUrlForSharing",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Frame::GetCanonicalUrlForSharing");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Frame_GetCanonicalUrlForSharing_Params_Data* params =
          reinterpret_cast<
              internal::Frame_GetCanonicalUrlForSharing_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      Frame_GetCanonicalUrlForSharing_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 1, false);
        return false;
      }
      Frame::GetCanonicalUrlForSharingCallback callback =
          Frame_GetCanonicalUrlForSharing_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCanonicalUrlForSharing(std::move(callback));
      return true;
    }
    case internal::kFrame_BlockRequests_Name: {
      break;
    }
    case internal::kFrame_ResumeBlockedRequests_Name: {
      break;
    }
    case internal::kFrame_CancelBlockedRequests_Name: {
      break;
    }
    case internal::kFrame_UpdateBrowserControlsState_Name: {
      break;
    }
    case internal::kFrame_SnapshotAccessibilityTree_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Frame::SnapshotAccessibilityTree",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Frame::SnapshotAccessibilityTree");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Frame_SnapshotAccessibilityTree_Params_Data* params =
          reinterpret_cast<
              internal::Frame_SnapshotAccessibilityTree_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint32_t p_ax_mode{};
      Frame_SnapshotAccessibilityTree_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_ax_mode = input_data_view.ax_mode();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 6, false);
        return false;
      }
      Frame::SnapshotAccessibilityTreeCallback callback =
          Frame_SnapshotAccessibilityTree_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SnapshotAccessibilityTree(
std::move(p_ax_mode), std::move(callback));
      return true;
    }
    case internal::kFrame_GetSerializedHtmlWithLocalLinks_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameValidationInfo[] = {
    {internal::kFrame_GetInterfaceProvider_Name,
     {&internal::Frame_GetInterfaceProvider_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrame_GetCanonicalUrlForSharing_Name,
     {&internal::Frame_GetCanonicalUrlForSharing_Params_Data::Validate,
      &internal::Frame_GetCanonicalUrlForSharing_ResponseParams_Data::Validate}},
    {internal::kFrame_BlockRequests_Name,
     {&internal::Frame_BlockRequests_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrame_ResumeBlockedRequests_Name,
     {&internal::Frame_ResumeBlockedRequests_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrame_CancelBlockedRequests_Name,
     {&internal::Frame_CancelBlockedRequests_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrame_UpdateBrowserControlsState_Name,
     {&internal::Frame_UpdateBrowserControlsState_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrame_SnapshotAccessibilityTree_Name,
     {&internal::Frame_SnapshotAccessibilityTree_Params_Data::Validate,
      &internal::Frame_SnapshotAccessibilityTree_ResponseParams_Data::Validate}},
    {internal::kFrame_GetSerializedHtmlWithLocalLinks_Name,
     {&internal::Frame_GetSerializedHtmlWithLocalLinks_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FrameRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::Frame::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFrameValidationInfo);
}

bool FrameResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::Frame::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kFrameValidationInfo);

}
const char FrameNavigationControl::Name_[] = "content.mojom.FrameNavigationControl";

class FrameNavigationControl_CommitSameDocumentNavigation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameNavigationControl_CommitSameDocumentNavigation_ForwardToCallback(
      FrameNavigationControl::CommitSameDocumentNavigationCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FrameNavigationControl::CommitSameDocumentNavigationCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FrameNavigationControl_CommitSameDocumentNavigation_ForwardToCallback);
};

class FrameNavigationControl_JavaScriptMethodExecuteRequest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameNavigationControl_JavaScriptMethodExecuteRequest_ForwardToCallback(
      FrameNavigationControl::JavaScriptMethodExecuteRequestCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FrameNavigationControl::JavaScriptMethodExecuteRequestCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FrameNavigationControl_JavaScriptMethodExecuteRequest_ForwardToCallback);
};

class FrameNavigationControl_JavaScriptExecuteRequest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameNavigationControl_JavaScriptExecuteRequest_ForwardToCallback(
      FrameNavigationControl::JavaScriptExecuteRequestCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FrameNavigationControl::JavaScriptExecuteRequestCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FrameNavigationControl_JavaScriptExecuteRequest_ForwardToCallback);
};

class FrameNavigationControl_JavaScriptExecuteRequestForTests_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameNavigationControl_JavaScriptExecuteRequestForTests_ForwardToCallback(
      FrameNavigationControl::JavaScriptExecuteRequestForTestsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FrameNavigationControl::JavaScriptExecuteRequestForTestsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FrameNavigationControl_JavaScriptExecuteRequestForTests_ForwardToCallback);
};

class FrameNavigationControl_JavaScriptExecuteRequestInIsolatedWorld_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameNavigationControl_JavaScriptExecuteRequestInIsolatedWorld_ForwardToCallback(
      FrameNavigationControl::JavaScriptExecuteRequestInIsolatedWorldCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FrameNavigationControl::JavaScriptExecuteRequestInIsolatedWorldCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FrameNavigationControl_JavaScriptExecuteRequestInIsolatedWorld_ForwardToCallback);
};

FrameNavigationControlProxy::FrameNavigationControlProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameNavigationControlProxy::CommitSameDocumentNavigation(
    ::content::mojom::CommonNavigationParamsPtr in_common_params, ::content::mojom::CommitNavigationParamsPtr in_request_params, CommitSameDocumentNavigationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameNavigationControl::CommitSameDocumentNavigation", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_common_params.is_null()) {
        raw_value->SetString("common_params", "nullptr");
      } else {
        raw_value->BeginDictionary("common_params");
        in_common_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      if (in_request_params.is_null()) {
        raw_value->SetString("request_params", "nullptr");
      } else {
        raw_value->BeginDictionary("request_params");
        in_request_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameNavigationControl_CommitSameDocumentNavigation_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameNavigationControl_CommitSameDocumentNavigation_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->common_params)::BaseType::BufferWriter
      common_params_writer;
  mojo::internal::Serialize<::content::mojom::CommonNavigationParamsDataView>(
      in_common_params, buffer, &common_params_writer, &serialization_context);
  params->common_params.Set(
      common_params_writer.is_null() ? nullptr : common_params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->common_params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null common_params in FrameNavigationControl.CommitSameDocumentNavigation request");
  typename decltype(params->request_params)::BaseType::BufferWriter
      request_params_writer;
  mojo::internal::Serialize<::content::mojom::CommitNavigationParamsDataView>(
      in_request_params, buffer, &request_params_writer, &serialization_context);
  params->request_params.Set(
      request_params_writer.is_null() ? nullptr : request_params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->request_params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request_params in FrameNavigationControl.CommitSameDocumentNavigation request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameNavigationControl::Name_);
  message.set_method_name("CommitSameDocumentNavigation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameNavigationControl_CommitSameDocumentNavigation_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FrameNavigationControlProxy::HandleRendererDebugURL(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameNavigationControl::HandleRendererDebugURL", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::GURL&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameNavigationControl_HandleRendererDebugURL_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameNavigationControl_HandleRendererDebugURL_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in FrameNavigationControl.HandleRendererDebugURL request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameNavigationControl::Name_);
  message.set_method_name("HandleRendererDebugURL");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameNavigationControlProxy::UpdateSubresourceLoaderFactories(
    ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> in_subresource_loader_factories) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameNavigationControl::UpdateSubresourceLoaderFactories", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("subresource_loader_factories", base::trace_event::ValueToString(in_subresource_loader_factories, "<value of type ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle>>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameNavigationControl_UpdateSubresourceLoaderFactories_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameNavigationControl_UpdateSubresourceLoaderFactories_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->subresource_loader_factories)::BaseType::BufferWriter
      subresource_loader_factories_writer;
  mojo::internal::Serialize<::blink::mojom::URLLoaderFactoryBundleDataView>(
      in_subresource_loader_factories, buffer, &subresource_loader_factories_writer, &serialization_context);
  params->subresource_loader_factories.Set(
      subresource_loader_factories_writer.is_null() ? nullptr : subresource_loader_factories_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->subresource_loader_factories.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null subresource_loader_factories in FrameNavigationControl.UpdateSubresourceLoaderFactories request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameNavigationControl::Name_);
  message.set_method_name("UpdateSubresourceLoaderFactories");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameNavigationControlProxy::BindDevToolsAgent(
    ::mojo::PendingAssociatedRemote<::blink::mojom::DevToolsAgentHost> in_agent_host, ::mojo::PendingAssociatedReceiver<::blink::mojom::DevToolsAgent> in_agent) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameNavigationControl::BindDevToolsAgent", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("agent_host", in_agent_host.is_valid());
      raw_value->SetBoolean("agent", in_agent.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameNavigationControl_BindDevToolsAgent_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameNavigationControl_BindDevToolsAgent_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::DevToolsAgentHostAssociatedPtrInfoDataView>(
      in_agent_host, &params->agent_host, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->agent_host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid agent_host in FrameNavigationControl.BindDevToolsAgent request");
  mojo::internal::Serialize<::blink::mojom::DevToolsAgentAssociatedRequestDataView>(
      in_agent, &params->agent, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->agent),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid agent in FrameNavigationControl.BindDevToolsAgent request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameNavigationControl::Name_);
  message.set_method_name("BindDevToolsAgent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameNavigationControlProxy::JavaScriptMethodExecuteRequest(
    const ::base::string16& in_object_name, const ::base::string16& in_method_name, ::base::Value in_arguments, bool in_wants_result, JavaScriptMethodExecuteRequestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameNavigationControl::JavaScriptMethodExecuteRequest", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("object_name", base::trace_event::ValueToString(in_object_name, "<value of type const ::base::string16&>"));
      raw_value->SetString("method_name", base::trace_event::ValueToString(in_method_name, "<value of type const ::base::string16&>"));
      raw_value->SetString("arguments", base::trace_event::ValueToString(in_arguments, "<value of type ::base::Value>"));
      raw_value->SetBoolean("wants_result", in_wants_result);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameNavigationControl_JavaScriptMethodExecuteRequest_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameNavigationControl_JavaScriptMethodExecuteRequest_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->object_name)::BaseType::BufferWriter
      object_name_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_object_name, buffer, &object_name_writer, &serialization_context);
  params->object_name.Set(
      object_name_writer.is_null() ? nullptr : object_name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->object_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null object_name in FrameNavigationControl.JavaScriptMethodExecuteRequest request");
  typename decltype(params->method_name)::BaseType::BufferWriter
      method_name_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_method_name, buffer, &method_name_writer, &serialization_context);
  params->method_name.Set(
      method_name_writer.is_null() ? nullptr : method_name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->method_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null method_name in FrameNavigationControl.JavaScriptMethodExecuteRequest request");
  typename decltype(params->arguments)::BaseType::BufferWriter
      arguments_writer;
  mojo::internal::Serialize<::mojo_base::mojom::ListValueDataView>(
      in_arguments, buffer, &arguments_writer, &serialization_context);
  params->arguments.Set(
      arguments_writer.is_null() ? nullptr : arguments_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->arguments.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null arguments in FrameNavigationControl.JavaScriptMethodExecuteRequest request");
  params->wants_result = in_wants_result;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameNavigationControl::Name_);
  message.set_method_name("JavaScriptMethodExecuteRequest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameNavigationControl_JavaScriptMethodExecuteRequest_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FrameNavigationControlProxy::JavaScriptExecuteRequest(
    const ::base::string16& in_javascript, bool in_wants_result, JavaScriptExecuteRequestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameNavigationControl::JavaScriptExecuteRequest", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("javascript", base::trace_event::ValueToString(in_javascript, "<value of type const ::base::string16&>"));
      raw_value->SetBoolean("wants_result", in_wants_result);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameNavigationControl_JavaScriptExecuteRequest_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameNavigationControl_JavaScriptExecuteRequest_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->javascript)::BaseType::BufferWriter
      javascript_writer;
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
      in_javascript, buffer, &javascript_writer, &serialization_context);
  params->javascript.Set(
      javascript_writer.is_null() ? nullptr : javascript_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->javascript.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null javascript in FrameNavigationControl.JavaScriptExecuteRequest request");
  params->wants_result = in_wants_result;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameNavigationControl::Name_);
  message.set_method_name("JavaScriptExecuteRequest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameNavigationControl_JavaScriptExecuteRequest_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FrameNavigationControlProxy::JavaScriptExecuteRequestForTests(
    const ::base::string16& in_javascript, bool in_wants_result, bool in_has_user_gesture, int32_t in_world_id, JavaScriptExecuteRequestForTestsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameNavigationControl::JavaScriptExecuteRequestForTests", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("javascript", base::trace_event::ValueToString(in_javascript, "<value of type const ::base::string16&>"));
      raw_value->SetBoolean("wants_result", in_wants_result);
      raw_value->SetBoolean("has_user_gesture", in_has_user_gesture);
      raw_value->SetInteger("world_id", in_world_id);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameNavigationControl_JavaScriptExecuteRequestForTests_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameNavigationControl_JavaScriptExecuteRequestForTests_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->javascript)::BaseType::BufferWriter
      javascript_writer;
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
      in_javascript, buffer, &javascript_writer, &serialization_context);
  params->javascript.Set(
      javascript_writer.is_null() ? nullptr : javascript_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->javascript.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null javascript in FrameNavigationControl.JavaScriptExecuteRequestForTests request");
  params->wants_result = in_wants_result;
  params->has_user_gesture = in_has_user_gesture;
  params->world_id = in_world_id;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameNavigationControl::Name_);
  message.set_method_name("JavaScriptExecuteRequestForTests");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameNavigationControl_JavaScriptExecuteRequestForTests_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FrameNavigationControlProxy::JavaScriptExecuteRequestInIsolatedWorld(
    const ::base::string16& in_javascript, bool in_wants_result, int32_t in_world_id, JavaScriptExecuteRequestInIsolatedWorldCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameNavigationControl::JavaScriptExecuteRequestInIsolatedWorld", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("javascript", base::trace_event::ValueToString(in_javascript, "<value of type const ::base::string16&>"));
      raw_value->SetBoolean("wants_result", in_wants_result);
      raw_value->SetInteger("world_id", in_world_id);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameNavigationControl_JavaScriptExecuteRequestInIsolatedWorld_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameNavigationControl_JavaScriptExecuteRequestInIsolatedWorld_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->javascript)::BaseType::BufferWriter
      javascript_writer;
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
      in_javascript, buffer, &javascript_writer, &serialization_context);
  params->javascript.Set(
      javascript_writer.is_null() ? nullptr : javascript_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->javascript.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null javascript in FrameNavigationControl.JavaScriptExecuteRequestInIsolatedWorld request");
  params->wants_result = in_wants_result;
  params->world_id = in_world_id;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameNavigationControl::Name_);
  message.set_method_name("JavaScriptExecuteRequestInIsolatedWorld");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameNavigationControl_JavaScriptExecuteRequestInIsolatedWorld_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FrameNavigationControlProxy::SwapIn(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::FrameNavigationControl::SwapIn");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameNavigationControl_SwapIn_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameNavigationControl_SwapIn_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameNavigationControl::Name_);
  message.set_method_name("SwapIn");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class FrameNavigationControl_CommitSameDocumentNavigation_ProxyToResponder {
 public:
  static FrameNavigationControl::CommitSameDocumentNavigationCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FrameNavigationControl_CommitSameDocumentNavigation_ProxyToResponder> proxy(
        new FrameNavigationControl_CommitSameDocumentNavigation_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FrameNavigationControl_CommitSameDocumentNavigation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameNavigationControl_CommitSameDocumentNavigation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FrameNavigationControl_CommitSameDocumentNavigation_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FrameNavigationControl::CommitSameDocumentNavigationCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::CommitResult in_commit_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FrameNavigationControl_CommitSameDocumentNavigation_ProxyToResponder);
};

bool FrameNavigationControl_CommitSameDocumentNavigation_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::FrameNavigationControl::CommitSameDocumentNavigationCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::FrameNavigationControl_CommitSameDocumentNavigation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameNavigationControl_CommitSameDocumentNavigation_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::blink::mojom::CommitResult p_commit_result{};
  FrameNavigationControl_CommitSameDocumentNavigation_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadCommitResult(&p_commit_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameNavigationControl::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_commit_result));
  return true;
}

void FrameNavigationControl_CommitSameDocumentNavigation_ProxyToResponder::Run(
    ::blink::mojom::CommitResult in_commit_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::FrameNavigationControl::CommitSameDocumentNavigationCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("commit_result", base::trace_event::ValueToString(in_commit_result));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameNavigationControl_CommitSameDocumentNavigation_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameNavigationControl_CommitSameDocumentNavigation_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::CommitResult>(
      in_commit_result, &params->commit_result);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::FrameNavigationControl::CommitSameDocumentNavigationCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameNavigationControl::Name_);
  message.set_method_name("CommitSameDocumentNavigation");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FrameNavigationControl_JavaScriptMethodExecuteRequest_ProxyToResponder {
 public:
  static FrameNavigationControl::JavaScriptMethodExecuteRequestCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FrameNavigationControl_JavaScriptMethodExecuteRequest_ProxyToResponder> proxy(
        new FrameNavigationControl_JavaScriptMethodExecuteRequest_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FrameNavigationControl_JavaScriptMethodExecuteRequest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameNavigationControl_JavaScriptMethodExecuteRequest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FrameNavigationControl_JavaScriptMethodExecuteRequest_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FrameNavigationControl::JavaScriptMethodExecuteRequestCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::Value in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FrameNavigationControl_JavaScriptMethodExecuteRequest_ProxyToResponder);
};

bool FrameNavigationControl_JavaScriptMethodExecuteRequest_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::FrameNavigationControl::JavaScriptMethodExecuteRequestCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::FrameNavigationControl_JavaScriptMethodExecuteRequest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameNavigationControl_JavaScriptMethodExecuteRequest_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::base::Value p_result{};
  FrameNavigationControl_JavaScriptMethodExecuteRequest_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameNavigationControl::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void FrameNavigationControl_JavaScriptMethodExecuteRequest_ProxyToResponder::Run(
    ::base::Value in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::FrameNavigationControl::JavaScriptMethodExecuteRequestCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("result", base::trace_event::ValueToString(in_result, "<value of type ::base::Value>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameNavigationControl_JavaScriptMethodExecuteRequest_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameNavigationControl_JavaScriptMethodExecuteRequest_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BufferWriter result_writer;
  result_writer.AllocateInline(buffer, &params->result);
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
      in_result, buffer, &result_writer, true, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::FrameNavigationControl::JavaScriptMethodExecuteRequestCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameNavigationControl::Name_);
  message.set_method_name("JavaScriptMethodExecuteRequest");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FrameNavigationControl_JavaScriptExecuteRequest_ProxyToResponder {
 public:
  static FrameNavigationControl::JavaScriptExecuteRequestCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FrameNavigationControl_JavaScriptExecuteRequest_ProxyToResponder> proxy(
        new FrameNavigationControl_JavaScriptExecuteRequest_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FrameNavigationControl_JavaScriptExecuteRequest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameNavigationControl_JavaScriptExecuteRequest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FrameNavigationControl_JavaScriptExecuteRequest_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FrameNavigationControl::JavaScriptExecuteRequestCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::Value in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FrameNavigationControl_JavaScriptExecuteRequest_ProxyToResponder);
};

bool FrameNavigationControl_JavaScriptExecuteRequest_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::FrameNavigationControl::JavaScriptExecuteRequestCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::FrameNavigationControl_JavaScriptExecuteRequest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameNavigationControl_JavaScriptExecuteRequest_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::base::Value p_result{};
  FrameNavigationControl_JavaScriptExecuteRequest_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameNavigationControl::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void FrameNavigationControl_JavaScriptExecuteRequest_ProxyToResponder::Run(
    ::base::Value in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::FrameNavigationControl::JavaScriptExecuteRequestCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("result", base::trace_event::ValueToString(in_result, "<value of type ::base::Value>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameNavigationControl_JavaScriptExecuteRequest_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameNavigationControl_JavaScriptExecuteRequest_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BufferWriter result_writer;
  result_writer.AllocateInline(buffer, &params->result);
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
      in_result, buffer, &result_writer, true, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::FrameNavigationControl::JavaScriptExecuteRequestCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameNavigationControl::Name_);
  message.set_method_name("JavaScriptExecuteRequest");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FrameNavigationControl_JavaScriptExecuteRequestForTests_ProxyToResponder {
 public:
  static FrameNavigationControl::JavaScriptExecuteRequestForTestsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FrameNavigationControl_JavaScriptExecuteRequestForTests_ProxyToResponder> proxy(
        new FrameNavigationControl_JavaScriptExecuteRequestForTests_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FrameNavigationControl_JavaScriptExecuteRequestForTests_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameNavigationControl_JavaScriptExecuteRequestForTests_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FrameNavigationControl_JavaScriptExecuteRequestForTests_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FrameNavigationControl::JavaScriptExecuteRequestForTestsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::Value in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FrameNavigationControl_JavaScriptExecuteRequestForTests_ProxyToResponder);
};

bool FrameNavigationControl_JavaScriptExecuteRequestForTests_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::FrameNavigationControl::JavaScriptExecuteRequestForTestsCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::FrameNavigationControl_JavaScriptExecuteRequestForTests_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameNavigationControl_JavaScriptExecuteRequestForTests_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::base::Value p_result{};
  FrameNavigationControl_JavaScriptExecuteRequestForTests_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameNavigationControl::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void FrameNavigationControl_JavaScriptExecuteRequestForTests_ProxyToResponder::Run(
    ::base::Value in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::FrameNavigationControl::JavaScriptExecuteRequestForTestsCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("result", base::trace_event::ValueToString(in_result, "<value of type ::base::Value>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameNavigationControl_JavaScriptExecuteRequestForTests_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameNavigationControl_JavaScriptExecuteRequestForTests_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BufferWriter result_writer;
  result_writer.AllocateInline(buffer, &params->result);
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
      in_result, buffer, &result_writer, true, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::FrameNavigationControl::JavaScriptExecuteRequestForTestsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameNavigationControl::Name_);
  message.set_method_name("JavaScriptExecuteRequestForTests");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FrameNavigationControl_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder {
 public:
  static FrameNavigationControl::JavaScriptExecuteRequestInIsolatedWorldCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FrameNavigationControl_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder> proxy(
        new FrameNavigationControl_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FrameNavigationControl_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameNavigationControl_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FrameNavigationControl_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FrameNavigationControl::JavaScriptExecuteRequestInIsolatedWorldCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::Value in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FrameNavigationControl_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder);
};

bool FrameNavigationControl_JavaScriptExecuteRequestInIsolatedWorld_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::FrameNavigationControl::JavaScriptExecuteRequestInIsolatedWorldCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::FrameNavigationControl_JavaScriptExecuteRequestInIsolatedWorld_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameNavigationControl_JavaScriptExecuteRequestInIsolatedWorld_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::base::Value p_result{};
  FrameNavigationControl_JavaScriptExecuteRequestInIsolatedWorld_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameNavigationControl::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void FrameNavigationControl_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder::Run(
    ::base::Value in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::FrameNavigationControl::JavaScriptExecuteRequestInIsolatedWorldCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("result", base::trace_event::ValueToString(in_result, "<value of type ::base::Value>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameNavigationControl_JavaScriptExecuteRequestInIsolatedWorld_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameNavigationControl_JavaScriptExecuteRequestInIsolatedWorld_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BufferWriter result_writer;
  result_writer.AllocateInline(buffer, &params->result);
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
      in_result, buffer, &result_writer, true, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::FrameNavigationControl::JavaScriptExecuteRequestInIsolatedWorldCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameNavigationControl::Name_);
  message.set_method_name("JavaScriptExecuteRequestInIsolatedWorld");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FrameNavigationControlStubDispatch::Accept(
    FrameNavigationControl* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kFrameNavigationControl_CommitSameDocumentNavigation_Name: {
      break;
    }
    case internal::kFrameNavigationControl_HandleRendererDebugURL_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameNavigationControl::HandleRendererDebugURL",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameNavigationControl::HandleRendererDebugURL");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameNavigationControl_HandleRendererDebugURL_Params_Data* params =
          reinterpret_cast<internal::FrameNavigationControl_HandleRendererDebugURL_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      FrameNavigationControl_HandleRendererDebugURL_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameNavigationControl::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HandleRendererDebugURL(
std::move(p_url));
      return true;
    }
    case internal::kFrameNavigationControl_UpdateSubresourceLoaderFactories_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameNavigationControl::UpdateSubresourceLoaderFactories",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameNavigationControl::UpdateSubresourceLoaderFactories");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameNavigationControl_UpdateSubresourceLoaderFactories_Params_Data* params =
          reinterpret_cast<internal::FrameNavigationControl_UpdateSubresourceLoaderFactories_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> p_subresource_loader_factories{};
      FrameNavigationControl_UpdateSubresourceLoaderFactories_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSubresourceLoaderFactories(&p_subresource_loader_factories))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameNavigationControl::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateSubresourceLoaderFactories(
std::move(p_subresource_loader_factories));
      return true;
    }
    case internal::kFrameNavigationControl_BindDevToolsAgent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameNavigationControl::BindDevToolsAgent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameNavigationControl::BindDevToolsAgent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameNavigationControl_BindDevToolsAgent_Params_Data* params =
          reinterpret_cast<internal::FrameNavigationControl_BindDevToolsAgent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedRemote<::blink::mojom::DevToolsAgentHost> p_agent_host{};
      ::mojo::PendingAssociatedReceiver<::blink::mojom::DevToolsAgent> p_agent{};
      FrameNavigationControl_BindDevToolsAgent_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_agent_host =
            input_data_view.TakeAgentHost<decltype(p_agent_host)>();
      }
      if (success) {
        p_agent =
            input_data_view.TakeAgent<decltype(p_agent)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameNavigationControl::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindDevToolsAgent(
std::move(p_agent_host), 
std::move(p_agent));
      return true;
    }
    case internal::kFrameNavigationControl_JavaScriptMethodExecuteRequest_Name: {
      break;
    }
    case internal::kFrameNavigationControl_JavaScriptExecuteRequest_Name: {
      break;
    }
    case internal::kFrameNavigationControl_JavaScriptExecuteRequestForTests_Name: {
      break;
    }
    case internal::kFrameNavigationControl_JavaScriptExecuteRequestInIsolatedWorld_Name: {
      break;
    }
    case internal::kFrameNavigationControl_SwapIn_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameNavigationControl::SwapIn",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameNavigationControl::SwapIn");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameNavigationControl_SwapIn_Params_Data* params =
          reinterpret_cast<internal::FrameNavigationControl_SwapIn_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FrameNavigationControl_SwapIn_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameNavigationControl::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SwapIn();
      return true;
    }
  }
  return false;
}

// static
bool FrameNavigationControlStubDispatch::AcceptWithResponder(
    FrameNavigationControl* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFrameNavigationControl_CommitSameDocumentNavigation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameNavigationControl::CommitSameDocumentNavigation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameNavigationControl::CommitSameDocumentNavigation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FrameNavigationControl_CommitSameDocumentNavigation_Params_Data* params =
          reinterpret_cast<
              internal::FrameNavigationControl_CommitSameDocumentNavigation_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::content::mojom::CommonNavigationParamsPtr p_common_params{};
      ::content::mojom::CommitNavigationParamsPtr p_request_params{};
      FrameNavigationControl_CommitSameDocumentNavigation_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadCommonParams(&p_common_params))
        success = false;
      if (success && !input_data_view.ReadRequestParams(&p_request_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameNavigationControl::Name_, 0, false);
        return false;
      }
      FrameNavigationControl::CommitSameDocumentNavigationCallback callback =
          FrameNavigationControl_CommitSameDocumentNavigation_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CommitSameDocumentNavigation(
std::move(p_common_params), 
std::move(p_request_params), std::move(callback));
      return true;
    }
    case internal::kFrameNavigationControl_HandleRendererDebugURL_Name: {
      break;
    }
    case internal::kFrameNavigationControl_UpdateSubresourceLoaderFactories_Name: {
      break;
    }
    case internal::kFrameNavigationControl_BindDevToolsAgent_Name: {
      break;
    }
    case internal::kFrameNavigationControl_JavaScriptMethodExecuteRequest_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameNavigationControl::JavaScriptMethodExecuteRequest",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameNavigationControl::JavaScriptMethodExecuteRequest");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FrameNavigationControl_JavaScriptMethodExecuteRequest_Params_Data* params =
          reinterpret_cast<
              internal::FrameNavigationControl_JavaScriptMethodExecuteRequest_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::string16 p_object_name{};
      ::base::string16 p_method_name{};
      ::base::Value p_arguments{};
      bool p_wants_result{};
      FrameNavigationControl_JavaScriptMethodExecuteRequest_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadObjectName(&p_object_name))
        success = false;
      if (success && !input_data_view.ReadMethodName(&p_method_name))
        success = false;
      if (success && !input_data_view.ReadArguments(&p_arguments))
        success = false;
      if (success)
        p_wants_result = input_data_view.wants_result();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameNavigationControl::Name_, 4, false);
        return false;
      }
      FrameNavigationControl::JavaScriptMethodExecuteRequestCallback callback =
          FrameNavigationControl_JavaScriptMethodExecuteRequest_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->JavaScriptMethodExecuteRequest(
std::move(p_object_name), 
std::move(p_method_name), 
std::move(p_arguments), 
std::move(p_wants_result), std::move(callback));
      return true;
    }
    case internal::kFrameNavigationControl_JavaScriptExecuteRequest_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameNavigationControl::JavaScriptExecuteRequest",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameNavigationControl::JavaScriptExecuteRequest");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FrameNavigationControl_JavaScriptExecuteRequest_Params_Data* params =
          reinterpret_cast<
              internal::FrameNavigationControl_JavaScriptExecuteRequest_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::string16 p_javascript{};
      bool p_wants_result{};
      FrameNavigationControl_JavaScriptExecuteRequest_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadJavascript(&p_javascript))
        success = false;
      if (success)
        p_wants_result = input_data_view.wants_result();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameNavigationControl::Name_, 5, false);
        return false;
      }
      FrameNavigationControl::JavaScriptExecuteRequestCallback callback =
          FrameNavigationControl_JavaScriptExecuteRequest_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->JavaScriptExecuteRequest(
std::move(p_javascript), 
std::move(p_wants_result), std::move(callback));
      return true;
    }
    case internal::kFrameNavigationControl_JavaScriptExecuteRequestForTests_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameNavigationControl::JavaScriptExecuteRequestForTests",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameNavigationControl::JavaScriptExecuteRequestForTests");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FrameNavigationControl_JavaScriptExecuteRequestForTests_Params_Data* params =
          reinterpret_cast<
              internal::FrameNavigationControl_JavaScriptExecuteRequestForTests_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::string16 p_javascript{};
      bool p_wants_result{};
      bool p_has_user_gesture{};
      int32_t p_world_id{};
      FrameNavigationControl_JavaScriptExecuteRequestForTests_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadJavascript(&p_javascript))
        success = false;
      if (success)
        p_wants_result = input_data_view.wants_result();
      if (success)
        p_has_user_gesture = input_data_view.has_user_gesture();
      if (success)
        p_world_id = input_data_view.world_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameNavigationControl::Name_, 6, false);
        return false;
      }
      FrameNavigationControl::JavaScriptExecuteRequestForTestsCallback callback =
          FrameNavigationControl_JavaScriptExecuteRequestForTests_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->JavaScriptExecuteRequestForTests(
std::move(p_javascript), 
std::move(p_wants_result), 
std::move(p_has_user_gesture), 
std::move(p_world_id), std::move(callback));
      return true;
    }
    case internal::kFrameNavigationControl_JavaScriptExecuteRequestInIsolatedWorld_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameNavigationControl::JavaScriptExecuteRequestInIsolatedWorld",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameNavigationControl::JavaScriptExecuteRequestInIsolatedWorld");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FrameNavigationControl_JavaScriptExecuteRequestInIsolatedWorld_Params_Data* params =
          reinterpret_cast<
              internal::FrameNavigationControl_JavaScriptExecuteRequestInIsolatedWorld_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::string16 p_javascript{};
      bool p_wants_result{};
      int32_t p_world_id{};
      FrameNavigationControl_JavaScriptExecuteRequestInIsolatedWorld_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadJavascript(&p_javascript))
        success = false;
      if (success)
        p_wants_result = input_data_view.wants_result();
      if (success)
        p_world_id = input_data_view.world_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameNavigationControl::Name_, 7, false);
        return false;
      }
      FrameNavigationControl::JavaScriptExecuteRequestInIsolatedWorldCallback callback =
          FrameNavigationControl_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->JavaScriptExecuteRequestInIsolatedWorld(
std::move(p_javascript), 
std::move(p_wants_result), 
std::move(p_world_id), std::move(callback));
      return true;
    }
    case internal::kFrameNavigationControl_SwapIn_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameNavigationControlValidationInfo[] = {
    {internal::kFrameNavigationControl_CommitSameDocumentNavigation_Name,
     {&internal::FrameNavigationControl_CommitSameDocumentNavigation_Params_Data::Validate,
      &internal::FrameNavigationControl_CommitSameDocumentNavigation_ResponseParams_Data::Validate}},
    {internal::kFrameNavigationControl_HandleRendererDebugURL_Name,
     {&internal::FrameNavigationControl_HandleRendererDebugURL_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameNavigationControl_UpdateSubresourceLoaderFactories_Name,
     {&internal::FrameNavigationControl_UpdateSubresourceLoaderFactories_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameNavigationControl_BindDevToolsAgent_Name,
     {&internal::FrameNavigationControl_BindDevToolsAgent_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameNavigationControl_JavaScriptMethodExecuteRequest_Name,
     {&internal::FrameNavigationControl_JavaScriptMethodExecuteRequest_Params_Data::Validate,
      &internal::FrameNavigationControl_JavaScriptMethodExecuteRequest_ResponseParams_Data::Validate}},
    {internal::kFrameNavigationControl_JavaScriptExecuteRequest_Name,
     {&internal::FrameNavigationControl_JavaScriptExecuteRequest_Params_Data::Validate,
      &internal::FrameNavigationControl_JavaScriptExecuteRequest_ResponseParams_Data::Validate}},
    {internal::kFrameNavigationControl_JavaScriptExecuteRequestForTests_Name,
     {&internal::FrameNavigationControl_JavaScriptExecuteRequestForTests_Params_Data::Validate,
      &internal::FrameNavigationControl_JavaScriptExecuteRequestForTests_ResponseParams_Data::Validate}},
    {internal::kFrameNavigationControl_JavaScriptExecuteRequestInIsolatedWorld_Name,
     {&internal::FrameNavigationControl_JavaScriptExecuteRequestInIsolatedWorld_Params_Data::Validate,
      &internal::FrameNavigationControl_JavaScriptExecuteRequestInIsolatedWorld_ResponseParams_Data::Validate}},
    {internal::kFrameNavigationControl_SwapIn_Name,
     {&internal::FrameNavigationControl_SwapIn_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FrameNavigationControlRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::FrameNavigationControl::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFrameNavigationControlValidationInfo);
}

bool FrameNavigationControlResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::FrameNavigationControl::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kFrameNavigationControlValidationInfo);

}
const char FrameBindingsControl::Name_[] = "content.mojom.FrameBindingsControl";

FrameBindingsControlProxy::FrameBindingsControlProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameBindingsControlProxy::AllowBindings(
    int32_t in_enabled_bindings_flags) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameBindingsControl::AllowBindings", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("enabled_bindings_flags", in_enabled_bindings_flags);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameBindingsControl_AllowBindings_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameBindingsControl_AllowBindings_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->enabled_bindings_flags = in_enabled_bindings_flags;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameBindingsControl::Name_);
  message.set_method_name("AllowBindings");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameBindingsControlProxy::EnableMojoJsBindings(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::FrameBindingsControl::EnableMojoJsBindings");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameBindingsControl_EnableMojoJsBindings_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameBindingsControl_EnableMojoJsBindings_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameBindingsControl::Name_);
  message.set_method_name("EnableMojoJsBindings");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameBindingsControlProxy::BindWebUI(
    ::mojo::PendingReceiver<::content::mojom::WebUI> in_receiver, ::mojo::PendingRemote<::content::mojom::WebUIHost> in_remote) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameBindingsControl::BindWebUI", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("receiver", in_receiver.is_valid());
      raw_value->SetBoolean("remote", in_remote.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameBindingsControl_BindWebUI_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameBindingsControl_BindWebUI_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::content::mojom::WebUIInterfaceBase>>(
      in_receiver, &params->receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in FrameBindingsControl.BindWebUI request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::content::mojom::WebUIHostInterfaceBase>>(
      in_remote, &params->remote, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->remote),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid remote in FrameBindingsControl.BindWebUI request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameBindingsControl::Name_);
  message.set_method_name("BindWebUI");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool FrameBindingsControlStubDispatch::Accept(
    FrameBindingsControl* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kFrameBindingsControl_AllowBindings_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameBindingsControl::AllowBindings",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameBindingsControl::AllowBindings");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameBindingsControl_AllowBindings_Params_Data* params =
          reinterpret_cast<internal::FrameBindingsControl_AllowBindings_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_enabled_bindings_flags{};
      FrameBindingsControl_AllowBindings_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_enabled_bindings_flags = input_data_view.enabled_bindings_flags();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameBindingsControl::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AllowBindings(
std::move(p_enabled_bindings_flags));
      return true;
    }
    case internal::kFrameBindingsControl_EnableMojoJsBindings_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameBindingsControl::EnableMojoJsBindings",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameBindingsControl::EnableMojoJsBindings");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameBindingsControl_EnableMojoJsBindings_Params_Data* params =
          reinterpret_cast<internal::FrameBindingsControl_EnableMojoJsBindings_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FrameBindingsControl_EnableMojoJsBindings_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameBindingsControl::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableMojoJsBindings();
      return true;
    }
    case internal::kFrameBindingsControl_BindWebUI_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameBindingsControl::BindWebUI",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameBindingsControl::BindWebUI");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameBindingsControl_BindWebUI_Params_Data* params =
          reinterpret_cast<internal::FrameBindingsControl_BindWebUI_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::content::mojom::WebUI> p_receiver{};
      ::mojo::PendingRemote<::content::mojom::WebUIHost> p_remote{};
      FrameBindingsControl_BindWebUI_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_remote =
            input_data_view.TakeRemote<decltype(p_remote)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameBindingsControl::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindWebUI(
std::move(p_receiver), 
std::move(p_remote));
      return true;
    }
  }
  return false;
}

// static
bool FrameBindingsControlStubDispatch::AcceptWithResponder(
    FrameBindingsControl* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFrameBindingsControl_AllowBindings_Name: {
      break;
    }
    case internal::kFrameBindingsControl_EnableMojoJsBindings_Name: {
      break;
    }
    case internal::kFrameBindingsControl_BindWebUI_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameBindingsControlValidationInfo[] = {
    {internal::kFrameBindingsControl_AllowBindings_Name,
     {&internal::FrameBindingsControl_AllowBindings_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameBindingsControl_EnableMojoJsBindings_Name,
     {&internal::FrameBindingsControl_EnableMojoJsBindings_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameBindingsControl_BindWebUI_Name,
     {&internal::FrameBindingsControl_BindWebUI_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FrameBindingsControlRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::FrameBindingsControl::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFrameBindingsControlValidationInfo);
}

const char FrameFactory::Name_[] = "content.mojom.FrameFactory";

FrameFactoryProxy::FrameFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameFactoryProxy::CreateFrame(
    int32_t in_frame_routing_id, ::mojo::PendingReceiver<Frame> in_frame) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameFactory::CreateFrame", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("frame_routing_id", in_frame_routing_id);
      raw_value->SetBoolean("frame", in_frame.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameFactory_CreateFrame_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameFactory_CreateFrame_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->frame_routing_id = in_frame_routing_id;
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::content::mojom::FrameInterfaceBase>>(
      in_frame, &params->frame, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->frame),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid frame in FrameFactory.CreateFrame request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameFactory::Name_);
  message.set_method_name("CreateFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool FrameFactoryStubDispatch::Accept(
    FrameFactory* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kFrameFactory_CreateFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameFactory::CreateFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameFactory::CreateFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameFactory_CreateFrame_Params_Data* params =
          reinterpret_cast<internal::FrameFactory_CreateFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_frame_routing_id{};
      ::mojo::PendingReceiver<Frame> p_frame{};
      FrameFactory_CreateFrame_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_frame_routing_id = input_data_view.frame_routing_id();
      if (success) {
        p_frame =
            input_data_view.TakeFrame<decltype(p_frame)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateFrame(
std::move(p_frame_routing_id), 
std::move(p_frame));
      return true;
    }
  }
  return false;
}

// static
bool FrameFactoryStubDispatch::AcceptWithResponder(
    FrameFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFrameFactory_CreateFrame_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameFactoryValidationInfo[] = {
    {internal::kFrameFactory_CreateFrame_Name,
     {&internal::FrameFactory_CreateFrame_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FrameFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::FrameFactory::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFrameFactoryValidationInfo);
}

const char KeepAliveHandle::Name_[] = "content.mojom.KeepAliveHandle";

KeepAliveHandleProxy::KeepAliveHandleProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool KeepAliveHandleStubDispatch::Accept(
    KeepAliveHandle* impl,
    mojo::Message* message) {
  return false;
}

// static
bool KeepAliveHandleStubDispatch::AcceptWithResponder(
    KeepAliveHandle* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}



bool KeepAliveHandleRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::KeepAliveHandle::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, {});
}

const char FrameHost::Name_[] = "content.mojom.FrameHost";
bool FrameHost::CreateNewWindow(CreateNewWindowParamsPtr params, CreateNewWindowStatus* out_status, CreateNewWindowReplyPtr* out_reply) {
  NOTREACHED();
  return false;
}
bool FrameHost::CreatePortal(::mojo::PendingAssociatedReceiver<::blink::mojom::Portal> portal, ::mojo::PendingAssociatedRemote<::blink::mojom::PortalClient> client, int32_t* out_proxy_routing_id, ::content::FrameReplicationState* out_initial_replicated_state, ::blink::PortalToken* out_portal_token, ::base::UnguessableToken* out_frame_token, ::base::UnguessableToken* out_devtools_frame_token) {
  NOTREACHED();
  return false;
}
bool FrameHost::AdoptPortal(const ::blink::PortalToken& portal_token, int32_t* out_proxy_routing_id, ::viz::FrameSinkId* out_frame_sink_id, ::content::FrameReplicationState* out_replicated_state, ::base::UnguessableToken* out_frame_token, ::base::UnguessableToken* out_devtools_frame_token) {
  NOTREACHED();
  return false;
}
bool FrameHost::CreateNewWidget(::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost> blink_widget_host, ::mojo::PendingAssociatedRemote<::blink::mojom::Widget> blink_widget, int32_t* out_routing_id) {
  NOTREACHED();
  return false;
}
bool FrameHost::CreateNewFullscreenWidget(::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost> blink_widget_host, ::mojo::PendingAssociatedRemote<::blink::mojom::Widget> blink_widget, int32_t* out_routing_id) {
  NOTREACHED();
  return false;
}
class FrameHost_CreateNewWindow_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FrameHost_CreateNewWindow_HandleSyncResponse(
      bool* result, CreateNewWindowStatus* out_status, CreateNewWindowReplyPtr* out_reply)
      : result_(result), out_status_(out_status), out_reply_(out_reply) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  CreateNewWindowStatus* out_status_;
  CreateNewWindowReplyPtr* out_reply_;DISALLOW_COPY_AND_ASSIGN(FrameHost_CreateNewWindow_HandleSyncResponse);
};

class FrameHost_CreateNewWindow_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameHost_CreateNewWindow_ForwardToCallback(
      FrameHost::CreateNewWindowCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FrameHost::CreateNewWindowCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FrameHost_CreateNewWindow_ForwardToCallback);
};
class FrameHost_CreatePortal_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FrameHost_CreatePortal_HandleSyncResponse(
      bool* result, int32_t* out_proxy_routing_id, ::content::FrameReplicationState* out_initial_replicated_state, ::blink::PortalToken* out_portal_token, ::base::UnguessableToken* out_frame_token, ::base::UnguessableToken* out_devtools_frame_token)
      : result_(result), out_proxy_routing_id_(out_proxy_routing_id), out_initial_replicated_state_(out_initial_replicated_state), out_portal_token_(out_portal_token), out_frame_token_(out_frame_token), out_devtools_frame_token_(out_devtools_frame_token) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  int32_t* out_proxy_routing_id_;
  ::content::FrameReplicationState* out_initial_replicated_state_;
  ::blink::PortalToken* out_portal_token_;
  ::base::UnguessableToken* out_frame_token_;
  ::base::UnguessableToken* out_devtools_frame_token_;DISALLOW_COPY_AND_ASSIGN(FrameHost_CreatePortal_HandleSyncResponse);
};

class FrameHost_CreatePortal_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameHost_CreatePortal_ForwardToCallback(
      FrameHost::CreatePortalCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FrameHost::CreatePortalCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FrameHost_CreatePortal_ForwardToCallback);
};
class FrameHost_AdoptPortal_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FrameHost_AdoptPortal_HandleSyncResponse(
      bool* result, int32_t* out_proxy_routing_id, ::viz::FrameSinkId* out_frame_sink_id, ::content::FrameReplicationState* out_replicated_state, ::base::UnguessableToken* out_frame_token, ::base::UnguessableToken* out_devtools_frame_token)
      : result_(result), out_proxy_routing_id_(out_proxy_routing_id), out_frame_sink_id_(out_frame_sink_id), out_replicated_state_(out_replicated_state), out_frame_token_(out_frame_token), out_devtools_frame_token_(out_devtools_frame_token) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  int32_t* out_proxy_routing_id_;
  ::viz::FrameSinkId* out_frame_sink_id_;
  ::content::FrameReplicationState* out_replicated_state_;
  ::base::UnguessableToken* out_frame_token_;
  ::base::UnguessableToken* out_devtools_frame_token_;DISALLOW_COPY_AND_ASSIGN(FrameHost_AdoptPortal_HandleSyncResponse);
};

class FrameHost_AdoptPortal_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameHost_AdoptPortal_ForwardToCallback(
      FrameHost::AdoptPortalCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FrameHost::AdoptPortalCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FrameHost_AdoptPortal_ForwardToCallback);
};
class FrameHost_CreateNewWidget_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FrameHost_CreateNewWidget_HandleSyncResponse(
      bool* result, int32_t* out_routing_id)
      : result_(result), out_routing_id_(out_routing_id) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  int32_t* out_routing_id_;DISALLOW_COPY_AND_ASSIGN(FrameHost_CreateNewWidget_HandleSyncResponse);
};

class FrameHost_CreateNewWidget_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameHost_CreateNewWidget_ForwardToCallback(
      FrameHost::CreateNewWidgetCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FrameHost::CreateNewWidgetCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FrameHost_CreateNewWidget_ForwardToCallback);
};
class FrameHost_CreateNewFullscreenWidget_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FrameHost_CreateNewFullscreenWidget_HandleSyncResponse(
      bool* result, int32_t* out_routing_id)
      : result_(result), out_routing_id_(out_routing_id) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  int32_t* out_routing_id_;DISALLOW_COPY_AND_ASSIGN(FrameHost_CreateNewFullscreenWidget_HandleSyncResponse);
};

class FrameHost_CreateNewFullscreenWidget_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameHost_CreateNewFullscreenWidget_ForwardToCallback(
      FrameHost::CreateNewFullscreenWidgetCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FrameHost::CreateNewFullscreenWidgetCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FrameHost_CreateNewFullscreenWidget_ForwardToCallback);
};

FrameHostProxy::FrameHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool FrameHostProxy::CreateNewWindow(
    CreateNewWindowParamsPtr param_params, CreateNewWindowStatus* out_param_status, CreateNewWindowReplyPtr* out_param_reply) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "content::mojom::FrameHost::CreateNewWindow", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (param_params.is_null()) {
        raw_value->SetString("params", "nullptr");
      } else {
        raw_value->BeginDictionary("params");
        param_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_CreateNewWindow_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHost_CreateNewWindow_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->params)::BaseType::BufferWriter
      params_writer;
  mojo::internal::Serialize<::content::mojom::CreateNewWindowParamsDataView>(
      param_params, buffer, &params_writer, &serialization_context);
  params->params.Set(
      params_writer.is_null() ? nullptr : params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in FrameHost.CreateNewWindow request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("CreateNewWindow");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameHost_CreateNewWindow_HandleSyncResponse(
          &result, out_param_status, out_param_reply));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "content::mojom::FrameHost::CreateNewWindow", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_status) {
        raw_value->SetString("status", base::trace_event::ValueToString((*out_param_status)));
      } else {
        raw_value->SetString("status", "nullptr");
      }
      if (out_param_reply) {
        if ((*out_param_reply).is_null()) {
          raw_value->SetString("reply", "nullptr");
        } else {
          raw_value->BeginDictionary("reply");
          (*out_param_reply)->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      } else {
        raw_value->SetString("reply", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void FrameHostProxy::CreateNewWindow(
    CreateNewWindowParamsPtr in_params, CreateNewWindowCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::CreateNewWindow", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_params.is_null()) {
        raw_value->SetString("params", "nullptr");
      } else {
        raw_value->BeginDictionary("params");
        in_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_CreateNewWindow_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHost_CreateNewWindow_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->params)::BaseType::BufferWriter
      params_writer;
  mojo::internal::Serialize<::content::mojom::CreateNewWindowParamsDataView>(
      in_params, buffer, &params_writer, &serialization_context);
  params->params.Set(
      params_writer.is_null() ? nullptr : params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in FrameHost.CreateNewWindow request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("CreateNewWindow");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameHost_CreateNewWindow_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool FrameHostProxy::CreatePortal(
    ::mojo::PendingAssociatedReceiver<::blink::mojom::Portal> param_portal, ::mojo::PendingAssociatedRemote<::blink::mojom::PortalClient> param_client, int32_t* out_param_proxy_routing_id, ::content::FrameReplicationState* out_param_initial_replicated_state, ::blink::PortalToken* out_param_portal_token, ::base::UnguessableToken* out_param_frame_token, ::base::UnguessableToken* out_param_devtools_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "content::mojom::FrameHost::CreatePortal", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("portal", param_portal.is_valid());
      raw_value->SetBoolean("client", param_client.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_CreatePortal_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHost_CreatePortal_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::PortalAssociatedRequestDataView>(
      param_portal, &params->portal, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->portal),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid portal in FrameHost.CreatePortal request");
  mojo::internal::Serialize<::blink::mojom::PortalClientAssociatedPtrInfoDataView>(
      param_client, &params->client, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid client in FrameHost.CreatePortal request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("CreatePortal");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameHost_CreatePortal_HandleSyncResponse(
          &result, out_param_proxy_routing_id, out_param_initial_replicated_state, out_param_portal_token, out_param_frame_token, out_param_devtools_frame_token));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "content::mojom::FrameHost::CreatePortal", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_proxy_routing_id) {
        raw_value->SetInteger("proxy_routing_id", (*out_param_proxy_routing_id));
      } else {
        raw_value->SetString("proxy_routing_id", "nullptr");
      }
      if (out_param_initial_replicated_state) {
        raw_value->SetString("initial_replicated_state", base::trace_event::ValueToString((*out_param_initial_replicated_state), "<value of type const ::content::FrameReplicationState&>"));
      } else {
        raw_value->SetString("initial_replicated_state", "nullptr");
      }
      if (out_param_portal_token) {
        raw_value->SetString("portal_token", base::trace_event::ValueToString((*out_param_portal_token), "<value of type const ::blink::PortalToken&>"));
      } else {
        raw_value->SetString("portal_token", "nullptr");
      }
      if (out_param_frame_token) {
        raw_value->SetString("frame_token", base::trace_event::ValueToString((*out_param_frame_token), "<value of type const ::base::UnguessableToken&>"));
      } else {
        raw_value->SetString("frame_token", "nullptr");
      }
      if (out_param_devtools_frame_token) {
        raw_value->SetString("devtools_frame_token", base::trace_event::ValueToString((*out_param_devtools_frame_token), "<value of type const ::base::UnguessableToken&>"));
      } else {
        raw_value->SetString("devtools_frame_token", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void FrameHostProxy::CreatePortal(
    ::mojo::PendingAssociatedReceiver<::blink::mojom::Portal> in_portal, ::mojo::PendingAssociatedRemote<::blink::mojom::PortalClient> in_client, CreatePortalCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::CreatePortal", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("portal", in_portal.is_valid());
      raw_value->SetBoolean("client", in_client.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_CreatePortal_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHost_CreatePortal_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::PortalAssociatedRequestDataView>(
      in_portal, &params->portal, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->portal),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid portal in FrameHost.CreatePortal request");
  mojo::internal::Serialize<::blink::mojom::PortalClientAssociatedPtrInfoDataView>(
      in_client, &params->client, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid client in FrameHost.CreatePortal request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("CreatePortal");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameHost_CreatePortal_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool FrameHostProxy::AdoptPortal(
    const ::blink::PortalToken& param_portal_token, int32_t* out_param_proxy_routing_id, ::viz::FrameSinkId* out_param_frame_sink_id, ::content::FrameReplicationState* out_param_replicated_state, ::base::UnguessableToken* out_param_frame_token, ::base::UnguessableToken* out_param_devtools_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "content::mojom::FrameHost::AdoptPortal", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("portal_token", base::trace_event::ValueToString(param_portal_token, "<value of type const ::blink::PortalToken&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_AdoptPortal_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHost_AdoptPortal_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->portal_token)::BaseType::BufferWriter
      portal_token_writer;
  mojo::internal::Serialize<::blink::mojom::PortalTokenDataView>(
      param_portal_token, buffer, &portal_token_writer, &serialization_context);
  params->portal_token.Set(
      portal_token_writer.is_null() ? nullptr : portal_token_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->portal_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null portal_token in FrameHost.AdoptPortal request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("AdoptPortal");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameHost_AdoptPortal_HandleSyncResponse(
          &result, out_param_proxy_routing_id, out_param_frame_sink_id, out_param_replicated_state, out_param_frame_token, out_param_devtools_frame_token));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "content::mojom::FrameHost::AdoptPortal", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_proxy_routing_id) {
        raw_value->SetInteger("proxy_routing_id", (*out_param_proxy_routing_id));
      } else {
        raw_value->SetString("proxy_routing_id", "nullptr");
      }
      if (out_param_frame_sink_id) {
        raw_value->SetString("frame_sink_id", base::trace_event::ValueToString((*out_param_frame_sink_id), "<value of type const ::viz::FrameSinkId&>"));
      } else {
        raw_value->SetString("frame_sink_id", "nullptr");
      }
      if (out_param_replicated_state) {
        raw_value->SetString("replicated_state", base::trace_event::ValueToString((*out_param_replicated_state), "<value of type const ::content::FrameReplicationState&>"));
      } else {
        raw_value->SetString("replicated_state", "nullptr");
      }
      if (out_param_frame_token) {
        raw_value->SetString("frame_token", base::trace_event::ValueToString((*out_param_frame_token), "<value of type const ::base::UnguessableToken&>"));
      } else {
        raw_value->SetString("frame_token", "nullptr");
      }
      if (out_param_devtools_frame_token) {
        raw_value->SetString("devtools_frame_token", base::trace_event::ValueToString((*out_param_devtools_frame_token), "<value of type const ::base::UnguessableToken&>"));
      } else {
        raw_value->SetString("devtools_frame_token", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void FrameHostProxy::AdoptPortal(
    const ::blink::PortalToken& in_portal_token, AdoptPortalCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::AdoptPortal", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("portal_token", base::trace_event::ValueToString(in_portal_token, "<value of type const ::blink::PortalToken&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_AdoptPortal_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHost_AdoptPortal_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->portal_token)::BaseType::BufferWriter
      portal_token_writer;
  mojo::internal::Serialize<::blink::mojom::PortalTokenDataView>(
      in_portal_token, buffer, &portal_token_writer, &serialization_context);
  params->portal_token.Set(
      portal_token_writer.is_null() ? nullptr : portal_token_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->portal_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null portal_token in FrameHost.AdoptPortal request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("AdoptPortal");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameHost_AdoptPortal_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool FrameHostProxy::CreateNewWidget(
    ::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost> param_blink_widget_host, ::mojo::PendingAssociatedRemote<::blink::mojom::Widget> param_blink_widget, int32_t* out_param_routing_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "content::mojom::FrameHost::CreateNewWidget", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("blink_widget_host", param_blink_widget_host.is_valid());
      raw_value->SetBoolean("blink_widget", param_blink_widget.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_CreateNewWidget_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHost_CreateNewWidget_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::WidgetHostAssociatedRequestDataView>(
      param_blink_widget_host, &params->blink_widget_host, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->blink_widget_host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid blink_widget_host in FrameHost.CreateNewWidget request");
  mojo::internal::Serialize<::blink::mojom::WidgetAssociatedPtrInfoDataView>(
      param_blink_widget, &params->blink_widget, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->blink_widget),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid blink_widget in FrameHost.CreateNewWidget request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("CreateNewWidget");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameHost_CreateNewWidget_HandleSyncResponse(
          &result, out_param_routing_id));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "content::mojom::FrameHost::CreateNewWidget", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_routing_id) {
        raw_value->SetInteger("routing_id", (*out_param_routing_id));
      } else {
        raw_value->SetString("routing_id", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void FrameHostProxy::CreateNewWidget(
    ::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost> in_blink_widget_host, ::mojo::PendingAssociatedRemote<::blink::mojom::Widget> in_blink_widget, CreateNewWidgetCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::CreateNewWidget", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("blink_widget_host", in_blink_widget_host.is_valid());
      raw_value->SetBoolean("blink_widget", in_blink_widget.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_CreateNewWidget_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHost_CreateNewWidget_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::WidgetHostAssociatedRequestDataView>(
      in_blink_widget_host, &params->blink_widget_host, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->blink_widget_host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid blink_widget_host in FrameHost.CreateNewWidget request");
  mojo::internal::Serialize<::blink::mojom::WidgetAssociatedPtrInfoDataView>(
      in_blink_widget, &params->blink_widget, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->blink_widget),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid blink_widget in FrameHost.CreateNewWidget request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("CreateNewWidget");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameHost_CreateNewWidget_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool FrameHostProxy::CreateNewFullscreenWidget(
    ::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost> param_blink_widget_host, ::mojo::PendingAssociatedRemote<::blink::mojom::Widget> param_blink_widget, int32_t* out_param_routing_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "content::mojom::FrameHost::CreateNewFullscreenWidget", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("blink_widget_host", param_blink_widget_host.is_valid());
      raw_value->SetBoolean("blink_widget", param_blink_widget.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_CreateNewFullscreenWidget_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHost_CreateNewFullscreenWidget_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::WidgetHostAssociatedRequestDataView>(
      param_blink_widget_host, &params->blink_widget_host, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->blink_widget_host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid blink_widget_host in FrameHost.CreateNewFullscreenWidget request");
  mojo::internal::Serialize<::blink::mojom::WidgetAssociatedPtrInfoDataView>(
      param_blink_widget, &params->blink_widget, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->blink_widget),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid blink_widget in FrameHost.CreateNewFullscreenWidget request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("CreateNewFullscreenWidget");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameHost_CreateNewFullscreenWidget_HandleSyncResponse(
          &result, out_param_routing_id));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "content::mojom::FrameHost::CreateNewFullscreenWidget", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_routing_id) {
        raw_value->SetInteger("routing_id", (*out_param_routing_id));
      } else {
        raw_value->SetString("routing_id", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void FrameHostProxy::CreateNewFullscreenWidget(
    ::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost> in_blink_widget_host, ::mojo::PendingAssociatedRemote<::blink::mojom::Widget> in_blink_widget, CreateNewFullscreenWidgetCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::CreateNewFullscreenWidget", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("blink_widget_host", in_blink_widget_host.is_valid());
      raw_value->SetBoolean("blink_widget", in_blink_widget.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_CreateNewFullscreenWidget_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHost_CreateNewFullscreenWidget_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::WidgetHostAssociatedRequestDataView>(
      in_blink_widget_host, &params->blink_widget_host, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->blink_widget_host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid blink_widget_host in FrameHost.CreateNewFullscreenWidget request");
  mojo::internal::Serialize<::blink::mojom::WidgetAssociatedPtrInfoDataView>(
      in_blink_widget, &params->blink_widget, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->blink_widget),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid blink_widget in FrameHost.CreateNewFullscreenWidget request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("CreateNewFullscreenWidget");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameHost_CreateNewFullscreenWidget_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FrameHostProxy::IssueKeepAliveHandle(
    ::mojo::PendingReceiver<KeepAliveHandle> in_keep_alive_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::IssueKeepAliveHandle", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("keep_alive_handle", in_keep_alive_handle.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_IssueKeepAliveHandle_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHost_IssueKeepAliveHandle_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::content::mojom::KeepAliveHandleInterfaceBase>>(
      in_keep_alive_handle, &params->keep_alive_handle, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->keep_alive_handle),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid keep_alive_handle in FrameHost.IssueKeepAliveHandle request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("IssueKeepAliveHandle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameHostProxy::DidCommitProvisionalLoad(
    ::std::unique_ptr<::FrameHostMsg_DidCommitProvisionalLoad_Params> in_params, ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr in_interface_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::DidCommitProvisionalLoad", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("params", base::trace_event::ValueToString(in_params, "<value of type ::std::unique_ptr<::FrameHostMsg_DidCommitProvisionalLoad_Params>>"));
      if (in_interface_params.is_null()) {
        raw_value->SetString("interface_params", "nullptr");
      } else {
        raw_value->BeginDictionary("interface_params");
        in_interface_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_DidCommitProvisionalLoad_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHost_DidCommitProvisionalLoad_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->params)::BaseType::BufferWriter
      params_writer;
  mojo::internal::Serialize<::content::mojom::DidCommitProvisionalLoadParamsDataView>(
      in_params, buffer, &params_writer, &serialization_context);
  params->params.Set(
      params_writer.is_null() ? nullptr : params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in FrameHost.DidCommitProvisionalLoad request");
  typename decltype(params->interface_params)::BaseType::BufferWriter
      interface_params_writer;
  mojo::internal::Serialize<::content::mojom::DidCommitProvisionalLoadInterfaceParamsDataView>(
      in_interface_params, buffer, &interface_params_writer, &serialization_context);
  params->interface_params.Set(
      interface_params_writer.is_null() ? nullptr : interface_params_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("DidCommitProvisionalLoad");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameHostProxy::DidCommitSameDocumentNavigation(
    ::std::unique_ptr<::FrameHostMsg_DidCommitProvisionalLoad_Params> in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::DidCommitSameDocumentNavigation", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("params", base::trace_event::ValueToString(in_params, "<value of type ::std::unique_ptr<::FrameHostMsg_DidCommitProvisionalLoad_Params>>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_DidCommitSameDocumentNavigation_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHost_DidCommitSameDocumentNavigation_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->params)::BaseType::BufferWriter
      params_writer;
  mojo::internal::Serialize<::content::mojom::DidCommitProvisionalLoadParamsDataView>(
      in_params, buffer, &params_writer, &serialization_context);
  params->params.Set(
      params_writer.is_null() ? nullptr : params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in FrameHost.DidCommitSameDocumentNavigation request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("DidCommitSameDocumentNavigation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameHostProxy::BeginNavigation(
    ::content::mojom::CommonNavigationParamsPtr in_common_params, ::content::mojom::BeginNavigationParamsPtr in_begin_params, ::mojo::PendingRemote<::blink::mojom::BlobURLToken> in_blob_url_token, ::mojo::PendingAssociatedRemote<::content::mojom::NavigationClient> in_navigation_client, ::mojo::PendingRemote<::blink::mojom::NavigationInitiator> in_navigation_initiator) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::BeginNavigation", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_common_params.is_null()) {
        raw_value->SetString("common_params", "nullptr");
      } else {
        raw_value->BeginDictionary("common_params");
        in_common_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      if (in_begin_params.is_null()) {
        raw_value->SetString("begin_params", "nullptr");
      } else {
        raw_value->BeginDictionary("begin_params");
        in_begin_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetBoolean("blob_url_token", in_blob_url_token.is_valid());
      raw_value->SetBoolean("navigation_client", in_navigation_client.is_valid());
      raw_value->SetBoolean("navigation_initiator", in_navigation_initiator.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_BeginNavigation_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHost_BeginNavigation_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->common_params)::BaseType::BufferWriter
      common_params_writer;
  mojo::internal::Serialize<::content::mojom::CommonNavigationParamsDataView>(
      in_common_params, buffer, &common_params_writer, &serialization_context);
  params->common_params.Set(
      common_params_writer.is_null() ? nullptr : common_params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->common_params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null common_params in FrameHost.BeginNavigation request");
  typename decltype(params->begin_params)::BaseType::BufferWriter
      begin_params_writer;
  mojo::internal::Serialize<::content::mojom::BeginNavigationParamsDataView>(
      in_begin_params, buffer, &begin_params_writer, &serialization_context);
  params->begin_params.Set(
      begin_params_writer.is_null() ? nullptr : begin_params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->begin_params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null begin_params in FrameHost.BeginNavigation request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BlobURLTokenInterfaceBase>>(
      in_blob_url_token, &params->blob_url_token, &serialization_context);
  mojo::internal::Serialize<::content::mojom::NavigationClientAssociatedPtrInfoDataView>(
      in_navigation_client, &params->navigation_client, &serialization_context);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::NavigationInitiatorInterfaceBase>>(
      in_navigation_initiator, &params->navigation_initiator, &serialization_context);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("BeginNavigation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameHostProxy::SubresourceResponseStarted(
    const ::GURL& in_url, uint32_t in_cert_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::SubresourceResponseStarted", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::GURL&>"));
      raw_value->SetString("cert_status", base::NumberToString(in_cert_status));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_SubresourceResponseStarted_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHost_SubresourceResponseStarted_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in FrameHost.SubresourceResponseStarted request");
  params->cert_status = in_cert_status;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("SubresourceResponseStarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameHostProxy::ResourceLoadComplete(
    ::blink::mojom::ResourceLoadInfoPtr in_url_load_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::ResourceLoadComplete", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_url_load_info.is_null()) {
        raw_value->SetString("url_load_info", "nullptr");
      } else {
        raw_value->BeginDictionary("url_load_info");
        in_url_load_info->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_ResourceLoadComplete_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHost_ResourceLoadComplete_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url_load_info)::BaseType::BufferWriter
      url_load_info_writer;
  mojo::internal::Serialize<::blink::mojom::ResourceLoadInfoDataView>(
      in_url_load_info, buffer, &url_load_info_writer, &serialization_context);
  params->url_load_info.Set(
      url_load_info_writer.is_null() ? nullptr : url_load_info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url_load_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url_load_info in FrameHost.ResourceLoadComplete request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("ResourceLoadComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameHostProxy::DidChangeName(
    const std::string& in_name, const std::string& in_unique_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::DidChangeName", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("name", in_name);
      raw_value->SetString("unique_name", in_unique_name);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_DidChangeName_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHost_DidChangeName_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->name)::BaseType::BufferWriter
      name_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_name, buffer, &name_writer, &serialization_context);
  params->name.Set(
      name_writer.is_null() ? nullptr : name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in FrameHost.DidChangeName request");
  typename decltype(params->unique_name)::BaseType::BufferWriter
      unique_name_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_unique_name, buffer, &unique_name_writer, &serialization_context);
  params->unique_name.Set(
      unique_name_writer.is_null() ? nullptr : unique_name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->unique_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null unique_name in FrameHost.DidChangeName request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("DidChangeName");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameHostProxy::DidSetFramePolicyHeaders(
    ::network::mojom::WebSandboxFlags in_sandbox_flags, const std::vector<::blink::ParsedFeaturePolicyDeclaration>& in_feature_policy_header, const base::flat_map<::blink::mojom::DocumentPolicyFeature, ::blink::PolicyValue>& in_document_policy_header) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::DidSetFramePolicyHeaders", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("sandbox_flags", base::trace_event::ValueToString(in_sandbox_flags));
      raw_value->BeginArray("feature_policy_header");
      for (const auto& item0 : in_feature_policy_header) {
        raw_value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::blink::ParsedFeaturePolicyDeclaration&>"));
      }
      raw_value->EndArray();
      raw_value->BeginDictionary("document_policy_header");
      for (const auto& item0 : in_document_policy_header) {
        raw_value->SetStringWithCopiedName(base::trace_event::ValueToString(item0.first, "<value of type ::blink::mojom::DocumentPolicyFeature>"), base::trace_event::ValueToString(item0.second, "<value of type const ::blink::PolicyValue&>"));
      }
      raw_value->EndDictionary();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_DidSetFramePolicyHeaders_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHost_DidSetFramePolicyHeaders_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::network::mojom::WebSandboxFlags>(
      in_sandbox_flags, &params->sandbox_flags);
  typename decltype(params->feature_policy_header)::BaseType::BufferWriter
      feature_policy_header_writer;
  const mojo::internal::ContainerValidateParams feature_policy_header_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ParsedFeaturePolicyDeclarationDataView>>(
      in_feature_policy_header, buffer, &feature_policy_header_writer, &feature_policy_header_validate_params,
      &serialization_context);
  params->feature_policy_header.Set(
      feature_policy_header_writer.is_null() ? nullptr : feature_policy_header_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->feature_policy_header.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null feature_policy_header in FrameHost.DidSetFramePolicyHeaders request");
  typename decltype(params->document_policy_header)::BaseType::BufferWriter
      document_policy_header_writer;
  const mojo::internal::ContainerValidateParams document_policy_header_validate_params(
      new mojo::internal::ContainerValidateParams(0, ::blink::mojom::internal::DocumentPolicyFeature_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::MapDataView<::blink::mojom::DocumentPolicyFeature, ::blink::mojom::PolicyValueDataView>>(
      in_document_policy_header, buffer, &document_policy_header_writer, &document_policy_header_validate_params,
      &serialization_context);
  params->document_policy_header.Set(
      document_policy_header_writer.is_null() ? nullptr : document_policy_header_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->document_policy_header.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null document_policy_header in FrameHost.DidSetFramePolicyHeaders request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("DidSetFramePolicyHeaders");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameHostProxy::CancelInitialHistoryLoad(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::FrameHost::CancelInitialHistoryLoad");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_CancelInitialHistoryLoad_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHost_CancelInitialHistoryLoad_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("CancelInitialHistoryLoad");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameHostProxy::UpdateEncoding(
    const std::string& in_encoding_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::UpdateEncoding", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("encoding_name", in_encoding_name);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_UpdateEncoding_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHost_UpdateEncoding_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->encoding_name)::BaseType::BufferWriter
      encoding_name_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_encoding_name, buffer, &encoding_name_writer, &serialization_context);
  params->encoding_name.Set(
      encoding_name_writer.is_null() ? nullptr : encoding_name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->encoding_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null encoding_name in FrameHost.UpdateEncoding request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("UpdateEncoding");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameHostProxy::FrameSizeChanged(
    const ::gfx::Size& in_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::FrameSizeChanged", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("size", base::trace_event::ValueToString(in_size, "<value of type const ::gfx::Size&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_FrameSizeChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHost_FrameSizeChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->size)::BaseType::BufferWriter
      size_writer;
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_size, buffer, &size_writer, &serialization_context);
  params->size.Set(
      size_writer.is_null() ? nullptr : size_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null size in FrameHost.FrameSizeChanged request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("FrameSizeChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameHostProxy::DidAddMessageToConsole(
    ::blink::mojom::ConsoleMessageLevel in_log_level, const ::base::string16& in_msg, int32_t in_line_number, const ::base::string16& in_source_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::DidAddMessageToConsole", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("log_level", base::trace_event::ValueToString(in_log_level));
      raw_value->SetString("msg", base::trace_event::ValueToString(in_msg, "<value of type const ::base::string16&>"));
      raw_value->SetInteger("line_number", in_line_number);
      raw_value->SetString("source_id", base::trace_event::ValueToString(in_source_id, "<value of type const ::base::string16&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_DidAddMessageToConsole_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHost_DidAddMessageToConsole_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::ConsoleMessageLevel>(
      in_log_level, &params->log_level);
  typename decltype(params->msg)::BaseType::BufferWriter
      msg_writer;
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
      in_msg, buffer, &msg_writer, &serialization_context);
  params->msg.Set(
      msg_writer.is_null() ? nullptr : msg_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->msg.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null msg in FrameHost.DidAddMessageToConsole request");
  params->line_number = in_line_number;
  typename decltype(params->source_id)::BaseType::BufferWriter
      source_id_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_source_id, buffer, &source_id_writer, &serialization_context);
  params->source_id.Set(
      source_id_writer.is_null() ? nullptr : source_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_id in FrameHost.DidAddMessageToConsole request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("DidAddMessageToConsole");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameHostProxy::ShowCreatedWindow(
    int32_t in_pending_widget_routing_id, ::WindowOpenDisposition in_disposition, const ::gfx::Rect& in_rect, bool in_opened_by_user_gesture) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::ShowCreatedWindow", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("pending_widget_routing_id", in_pending_widget_routing_id);
      raw_value->SetInteger("disposition", static_cast<int>(in_disposition));
      raw_value->SetString("rect", base::trace_event::ValueToString(in_rect, "<value of type const ::gfx::Rect&>"));
      raw_value->SetBoolean("opened_by_user_gesture", in_opened_by_user_gesture);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_ShowCreatedWindow_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHost_ShowCreatedWindow_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->pending_widget_routing_id = in_pending_widget_routing_id;
  mojo::internal::Serialize<::ui::mojom::WindowOpenDisposition>(
      in_disposition, &params->disposition);
  typename decltype(params->rect)::BaseType::BufferWriter
      rect_writer;
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_rect, buffer, &rect_writer, &serialization_context);
  params->rect.Set(
      rect_writer.is_null() ? nullptr : rect_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->rect.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rect in FrameHost.ShowCreatedWindow request");
  params->opened_by_user_gesture = in_opened_by_user_gesture;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("ShowCreatedWindow");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameHostProxy::UpdateState(
    const ::content::PageState& in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::UpdateState", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("state", base::trace_event::ValueToString(in_state, "<value of type const ::content::PageState&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_UpdateState_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHost_UpdateState_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->state)::BaseType::BufferWriter
      state_writer;
  mojo::internal::Serialize<::content::mojom::PageStateDataView>(
      in_state, buffer, &state_writer, &serialization_context);
  params->state.Set(
      state_writer.is_null() ? nullptr : state_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->state.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null state in FrameHost.UpdateState request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("UpdateState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameHostProxy::OpenURL(
    OpenURLParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::OpenURL", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_params.is_null()) {
        raw_value->SetString("params", "nullptr");
      } else {
        raw_value->BeginDictionary("params");
        in_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_OpenURL_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHost_OpenURL_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->params)::BaseType::BufferWriter
      params_writer;
  mojo::internal::Serialize<::content::mojom::OpenURLParamsDataView>(
      in_params, buffer, &params_writer, &serialization_context);
  params->params.Set(
      params_writer.is_null() ? nullptr : params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in FrameHost.OpenURL request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("OpenURL");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameHostProxy::DidStopLoading(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::FrameHost::DidStopLoading");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_DidStopLoading_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHost_DidStopLoading_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("DidStopLoading");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class FrameHost_CreateNewWindow_ProxyToResponder {
 public:
  static FrameHost::CreateNewWindowCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FrameHost_CreateNewWindow_ProxyToResponder> proxy(
        new FrameHost_CreateNewWindow_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FrameHost_CreateNewWindow_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameHost_CreateNewWindow_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FrameHost_CreateNewWindow_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FrameHost::CreateNewWindowCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      CreateNewWindowStatus in_status, CreateNewWindowReplyPtr in_reply);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FrameHost_CreateNewWindow_ProxyToResponder);
};

bool FrameHost_CreateNewWindow_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::FrameHost::CreateNewWindowCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::FrameHost_CreateNewWindow_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameHost_CreateNewWindow_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  CreateNewWindowStatus p_status{};
  CreateNewWindowReplyPtr p_reply{};
  FrameHost_CreateNewWindow_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadReply(&p_reply))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_reply));
  return true;
}

void FrameHost_CreateNewWindow_ProxyToResponder::Run(
    CreateNewWindowStatus in_status, CreateNewWindowReplyPtr in_reply) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::FrameHost::CreateNewWindowCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("status", base::trace_event::ValueToString(in_status));
      if (in_reply.is_null()) {
        raw_value->SetString("reply", "nullptr");
      } else {
        raw_value->BeginDictionary("reply");
        in_reply->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_CreateNewWindow_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHost_CreateNewWindow_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::content::mojom::CreateNewWindowStatus>(
      in_status, &params->status);
  typename decltype(params->reply)::BaseType::BufferWriter
      reply_writer;
  mojo::internal::Serialize<::content::mojom::CreateNewWindowReplyDataView>(
      in_reply, buffer, &reply_writer, &serialization_context);
  params->reply.Set(
      reply_writer.is_null() ? nullptr : reply_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::FrameHost::CreateNewWindowCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("CreateNewWindow");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FrameHost_CreateNewWindow_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::FrameHost_CreateNewWindow_ResponseParams_Data* params =
      reinterpret_cast<internal::FrameHost_CreateNewWindow_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  CreateNewWindowStatus p_status{};
  CreateNewWindowReplyPtr p_reply{};
  FrameHost_CreateNewWindow_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadReply(&p_reply))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameHost::Name_, 0, true);
    return false;
  }
  *out_status_ = std::move(p_status);
  *out_reply_ = std::move(p_reply);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class FrameHost_CreatePortal_ProxyToResponder {
 public:
  static FrameHost::CreatePortalCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FrameHost_CreatePortal_ProxyToResponder> proxy(
        new FrameHost_CreatePortal_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FrameHost_CreatePortal_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameHost_CreatePortal_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FrameHost_CreatePortal_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FrameHost::CreatePortalCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_proxy_routing_id, const ::content::FrameReplicationState& in_initial_replicated_state, const ::blink::PortalToken& in_portal_token, const ::base::UnguessableToken& in_frame_token, const ::base::UnguessableToken& in_devtools_frame_token);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FrameHost_CreatePortal_ProxyToResponder);
};

bool FrameHost_CreatePortal_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::FrameHost::CreatePortalCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::FrameHost_CreatePortal_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameHost_CreatePortal_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  int32_t p_proxy_routing_id{};
  ::content::FrameReplicationState p_initial_replicated_state{};
  ::blink::PortalToken p_portal_token{};
  ::base::UnguessableToken p_frame_token{};
  ::base::UnguessableToken p_devtools_frame_token{};
  FrameHost_CreatePortal_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_proxy_routing_id = input_data_view.proxy_routing_id();
  if (success && !input_data_view.ReadInitialReplicatedState(&p_initial_replicated_state))
    success = false;
  if (success && !input_data_view.ReadPortalToken(&p_portal_token))
    success = false;
  if (success && !input_data_view.ReadFrameToken(&p_frame_token))
    success = false;
  if (success && !input_data_view.ReadDevtoolsFrameToken(&p_devtools_frame_token))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_proxy_routing_id), 
std::move(p_initial_replicated_state), 
std::move(p_portal_token), 
std::move(p_frame_token), 
std::move(p_devtools_frame_token));
  return true;
}

void FrameHost_CreatePortal_ProxyToResponder::Run(
    int32_t in_proxy_routing_id, const ::content::FrameReplicationState& in_initial_replicated_state, const ::blink::PortalToken& in_portal_token, const ::base::UnguessableToken& in_frame_token, const ::base::UnguessableToken& in_devtools_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::FrameHost::CreatePortalCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("proxy_routing_id", in_proxy_routing_id);
      raw_value->SetString("initial_replicated_state", base::trace_event::ValueToString(in_initial_replicated_state, "<value of type const ::content::FrameReplicationState&>"));
      raw_value->SetString("portal_token", base::trace_event::ValueToString(in_portal_token, "<value of type const ::blink::PortalToken&>"));
      raw_value->SetString("frame_token", base::trace_event::ValueToString(in_frame_token, "<value of type const ::base::UnguessableToken&>"));
      raw_value->SetString("devtools_frame_token", base::trace_event::ValueToString(in_devtools_frame_token, "<value of type const ::base::UnguessableToken&>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_CreatePortal_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHost_CreatePortal_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->proxy_routing_id = in_proxy_routing_id;
  typename decltype(params->initial_replicated_state)::BaseType::BufferWriter
      initial_replicated_state_writer;
  mojo::internal::Serialize<::content::mojom::FrameReplicationStateDataView>(
      in_initial_replicated_state, buffer, &initial_replicated_state_writer, &serialization_context);
  params->initial_replicated_state.Set(
      initial_replicated_state_writer.is_null() ? nullptr : initial_replicated_state_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->initial_replicated_state.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null initial_replicated_state in ");
  typename decltype(params->portal_token)::BaseType::BufferWriter
      portal_token_writer;
  mojo::internal::Serialize<::blink::mojom::PortalTokenDataView>(
      in_portal_token, buffer, &portal_token_writer, &serialization_context);
  params->portal_token.Set(
      portal_token_writer.is_null() ? nullptr : portal_token_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->portal_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null portal_token in ");
  typename decltype(params->frame_token)::BaseType::BufferWriter
      frame_token_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_frame_token, buffer, &frame_token_writer, &serialization_context);
  params->frame_token.Set(
      frame_token_writer.is_null() ? nullptr : frame_token_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_token in ");
  typename decltype(params->devtools_frame_token)::BaseType::BufferWriter
      devtools_frame_token_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_devtools_frame_token, buffer, &devtools_frame_token_writer, &serialization_context);
  params->devtools_frame_token.Set(
      devtools_frame_token_writer.is_null() ? nullptr : devtools_frame_token_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->devtools_frame_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devtools_frame_token in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::FrameHost::CreatePortalCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("CreatePortal");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FrameHost_CreatePortal_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::FrameHost_CreatePortal_ResponseParams_Data* params =
      reinterpret_cast<internal::FrameHost_CreatePortal_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  int32_t p_proxy_routing_id{};
  ::content::FrameReplicationState p_initial_replicated_state{};
  ::blink::PortalToken p_portal_token{};
  ::base::UnguessableToken p_frame_token{};
  ::base::UnguessableToken p_devtools_frame_token{};
  FrameHost_CreatePortal_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_proxy_routing_id = input_data_view.proxy_routing_id();
  if (success && !input_data_view.ReadInitialReplicatedState(&p_initial_replicated_state))
    success = false;
  if (success && !input_data_view.ReadPortalToken(&p_portal_token))
    success = false;
  if (success && !input_data_view.ReadFrameToken(&p_frame_token))
    success = false;
  if (success && !input_data_view.ReadDevtoolsFrameToken(&p_devtools_frame_token))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameHost::Name_, 1, true);
    return false;
  }
  *out_proxy_routing_id_ = std::move(p_proxy_routing_id);
  *out_initial_replicated_state_ = std::move(p_initial_replicated_state);
  *out_portal_token_ = std::move(p_portal_token);
  *out_frame_token_ = std::move(p_frame_token);
  *out_devtools_frame_token_ = std::move(p_devtools_frame_token);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class FrameHost_AdoptPortal_ProxyToResponder {
 public:
  static FrameHost::AdoptPortalCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FrameHost_AdoptPortal_ProxyToResponder> proxy(
        new FrameHost_AdoptPortal_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FrameHost_AdoptPortal_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameHost_AdoptPortal_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FrameHost_AdoptPortal_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FrameHost::AdoptPortalCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_proxy_routing_id, const ::viz::FrameSinkId& in_frame_sink_id, const ::content::FrameReplicationState& in_replicated_state, const ::base::UnguessableToken& in_frame_token, const ::base::UnguessableToken& in_devtools_frame_token);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FrameHost_AdoptPortal_ProxyToResponder);
};

bool FrameHost_AdoptPortal_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::FrameHost::AdoptPortalCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::FrameHost_AdoptPortal_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameHost_AdoptPortal_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  int32_t p_proxy_routing_id{};
  ::viz::FrameSinkId p_frame_sink_id{};
  ::content::FrameReplicationState p_replicated_state{};
  ::base::UnguessableToken p_frame_token{};
  ::base::UnguessableToken p_devtools_frame_token{};
  FrameHost_AdoptPortal_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_proxy_routing_id = input_data_view.proxy_routing_id();
  if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
    success = false;
  if (success && !input_data_view.ReadReplicatedState(&p_replicated_state))
    success = false;
  if (success && !input_data_view.ReadFrameToken(&p_frame_token))
    success = false;
  if (success && !input_data_view.ReadDevtoolsFrameToken(&p_devtools_frame_token))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_proxy_routing_id), 
std::move(p_frame_sink_id), 
std::move(p_replicated_state), 
std::move(p_frame_token), 
std::move(p_devtools_frame_token));
  return true;
}

void FrameHost_AdoptPortal_ProxyToResponder::Run(
    int32_t in_proxy_routing_id, const ::viz::FrameSinkId& in_frame_sink_id, const ::content::FrameReplicationState& in_replicated_state, const ::base::UnguessableToken& in_frame_token, const ::base::UnguessableToken& in_devtools_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::FrameHost::AdoptPortalCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("proxy_routing_id", in_proxy_routing_id);
      raw_value->SetString("frame_sink_id", base::trace_event::ValueToString(in_frame_sink_id, "<value of type const ::viz::FrameSinkId&>"));
      raw_value->SetString("replicated_state", base::trace_event::ValueToString(in_replicated_state, "<value of type const ::content::FrameReplicationState&>"));
      raw_value->SetString("frame_token", base::trace_event::ValueToString(in_frame_token, "<value of type const ::base::UnguessableToken&>"));
      raw_value->SetString("devtools_frame_token", base::trace_event::ValueToString(in_devtools_frame_token, "<value of type const ::base::UnguessableToken&>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_AdoptPortal_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHost_AdoptPortal_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->proxy_routing_id = in_proxy_routing_id;
  typename decltype(params->frame_sink_id)::BaseType::BufferWriter
      frame_sink_id_writer;
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      in_frame_sink_id, buffer, &frame_sink_id_writer, &serialization_context);
  params->frame_sink_id.Set(
      frame_sink_id_writer.is_null() ? nullptr : frame_sink_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_sink_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_sink_id in ");
  typename decltype(params->replicated_state)::BaseType::BufferWriter
      replicated_state_writer;
  mojo::internal::Serialize<::content::mojom::FrameReplicationStateDataView>(
      in_replicated_state, buffer, &replicated_state_writer, &serialization_context);
  params->replicated_state.Set(
      replicated_state_writer.is_null() ? nullptr : replicated_state_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->replicated_state.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null replicated_state in ");
  typename decltype(params->frame_token)::BaseType::BufferWriter
      frame_token_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_frame_token, buffer, &frame_token_writer, &serialization_context);
  params->frame_token.Set(
      frame_token_writer.is_null() ? nullptr : frame_token_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_token in ");
  typename decltype(params->devtools_frame_token)::BaseType::BufferWriter
      devtools_frame_token_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_devtools_frame_token, buffer, &devtools_frame_token_writer, &serialization_context);
  params->devtools_frame_token.Set(
      devtools_frame_token_writer.is_null() ? nullptr : devtools_frame_token_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->devtools_frame_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devtools_frame_token in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::FrameHost::AdoptPortalCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("AdoptPortal");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FrameHost_AdoptPortal_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::FrameHost_AdoptPortal_ResponseParams_Data* params =
      reinterpret_cast<internal::FrameHost_AdoptPortal_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  int32_t p_proxy_routing_id{};
  ::viz::FrameSinkId p_frame_sink_id{};
  ::content::FrameReplicationState p_replicated_state{};
  ::base::UnguessableToken p_frame_token{};
  ::base::UnguessableToken p_devtools_frame_token{};
  FrameHost_AdoptPortal_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_proxy_routing_id = input_data_view.proxy_routing_id();
  if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
    success = false;
  if (success && !input_data_view.ReadReplicatedState(&p_replicated_state))
    success = false;
  if (success && !input_data_view.ReadFrameToken(&p_frame_token))
    success = false;
  if (success && !input_data_view.ReadDevtoolsFrameToken(&p_devtools_frame_token))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameHost::Name_, 2, true);
    return false;
  }
  *out_proxy_routing_id_ = std::move(p_proxy_routing_id);
  *out_frame_sink_id_ = std::move(p_frame_sink_id);
  *out_replicated_state_ = std::move(p_replicated_state);
  *out_frame_token_ = std::move(p_frame_token);
  *out_devtools_frame_token_ = std::move(p_devtools_frame_token);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class FrameHost_CreateNewWidget_ProxyToResponder {
 public:
  static FrameHost::CreateNewWidgetCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FrameHost_CreateNewWidget_ProxyToResponder> proxy(
        new FrameHost_CreateNewWidget_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FrameHost_CreateNewWidget_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameHost_CreateNewWidget_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FrameHost_CreateNewWidget_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FrameHost::CreateNewWidgetCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_routing_id);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FrameHost_CreateNewWidget_ProxyToResponder);
};

bool FrameHost_CreateNewWidget_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::FrameHost::CreateNewWidgetCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::FrameHost_CreateNewWidget_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameHost_CreateNewWidget_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  int32_t p_routing_id{};
  FrameHost_CreateNewWidget_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_routing_id = input_data_view.routing_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameHost::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_routing_id));
  return true;
}

void FrameHost_CreateNewWidget_ProxyToResponder::Run(
    int32_t in_routing_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::FrameHost::CreateNewWidgetCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("routing_id", in_routing_id);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_CreateNewWidget_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHost_CreateNewWidget_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->routing_id = in_routing_id;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::FrameHost::CreateNewWidgetCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("CreateNewWidget");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FrameHost_CreateNewWidget_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::FrameHost_CreateNewWidget_ResponseParams_Data* params =
      reinterpret_cast<internal::FrameHost_CreateNewWidget_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  int32_t p_routing_id{};
  FrameHost_CreateNewWidget_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_routing_id = input_data_view.routing_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameHost::Name_, 3, true);
    return false;
  }
  *out_routing_id_ = std::move(p_routing_id);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class FrameHost_CreateNewFullscreenWidget_ProxyToResponder {
 public:
  static FrameHost::CreateNewFullscreenWidgetCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FrameHost_CreateNewFullscreenWidget_ProxyToResponder> proxy(
        new FrameHost_CreateNewFullscreenWidget_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FrameHost_CreateNewFullscreenWidget_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameHost_CreateNewFullscreenWidget_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FrameHost_CreateNewFullscreenWidget_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FrameHost::CreateNewFullscreenWidgetCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_routing_id);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FrameHost_CreateNewFullscreenWidget_ProxyToResponder);
};

bool FrameHost_CreateNewFullscreenWidget_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::FrameHost::CreateNewFullscreenWidgetCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::FrameHost_CreateNewFullscreenWidget_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameHost_CreateNewFullscreenWidget_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  int32_t p_routing_id{};
  FrameHost_CreateNewFullscreenWidget_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_routing_id = input_data_view.routing_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameHost::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_routing_id));
  return true;
}

void FrameHost_CreateNewFullscreenWidget_ProxyToResponder::Run(
    int32_t in_routing_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::FrameHost::CreateNewFullscreenWidgetCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("routing_id", in_routing_id);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_CreateNewFullscreenWidget_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameHost_CreateNewFullscreenWidget_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->routing_id = in_routing_id;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::FrameHost::CreateNewFullscreenWidgetCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("CreateNewFullscreenWidget");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FrameHost_CreateNewFullscreenWidget_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::FrameHost_CreateNewFullscreenWidget_ResponseParams_Data* params =
      reinterpret_cast<internal::FrameHost_CreateNewFullscreenWidget_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  int32_t p_routing_id{};
  FrameHost_CreateNewFullscreenWidget_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_routing_id = input_data_view.routing_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameHost::Name_, 4, true);
    return false;
  }
  *out_routing_id_ = std::move(p_routing_id);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}

// static
bool FrameHostStubDispatch::Accept(
    FrameHost* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kFrameHost_CreateNewWindow_Name: {
      break;
    }
    case internal::kFrameHost_CreatePortal_Name: {
      break;
    }
    case internal::kFrameHost_AdoptPortal_Name: {
      break;
    }
    case internal::kFrameHost_CreateNewWidget_Name: {
      break;
    }
    case internal::kFrameHost_CreateNewFullscreenWidget_Name: {
      break;
    }
    case internal::kFrameHost_IssueKeepAliveHandle_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::IssueKeepAliveHandle",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::IssueKeepAliveHandle");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHost_IssueKeepAliveHandle_Params_Data* params =
          reinterpret_cast<internal::FrameHost_IssueKeepAliveHandle_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<KeepAliveHandle> p_keep_alive_handle{};
      FrameHost_IssueKeepAliveHandle_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_keep_alive_handle =
            input_data_view.TakeKeepAliveHandle<decltype(p_keep_alive_handle)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IssueKeepAliveHandle(
std::move(p_keep_alive_handle));
      return true;
    }
    case internal::kFrameHost_DidCommitProvisionalLoad_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::DidCommitProvisionalLoad",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::DidCommitProvisionalLoad");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHost_DidCommitProvisionalLoad_Params_Data* params =
          reinterpret_cast<internal::FrameHost_DidCommitProvisionalLoad_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::std::unique_ptr<::FrameHostMsg_DidCommitProvisionalLoad_Params> p_params{};
      ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr p_interface_params{};
      FrameHost_DidCommitProvisionalLoad_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success && !input_data_view.ReadInterfaceParams(&p_interface_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidCommitProvisionalLoad(
std::move(p_params), 
std::move(p_interface_params));
      return true;
    }
    case internal::kFrameHost_DidCommitSameDocumentNavigation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::DidCommitSameDocumentNavigation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::DidCommitSameDocumentNavigation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHost_DidCommitSameDocumentNavigation_Params_Data* params =
          reinterpret_cast<internal::FrameHost_DidCommitSameDocumentNavigation_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::std::unique_ptr<::FrameHostMsg_DidCommitProvisionalLoad_Params> p_params{};
      FrameHost_DidCommitSameDocumentNavigation_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidCommitSameDocumentNavigation(
std::move(p_params));
      return true;
    }
    case internal::kFrameHost_BeginNavigation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::BeginNavigation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::BeginNavigation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHost_BeginNavigation_Params_Data* params =
          reinterpret_cast<internal::FrameHost_BeginNavigation_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::content::mojom::CommonNavigationParamsPtr p_common_params{};
      ::content::mojom::BeginNavigationParamsPtr p_begin_params{};
      ::mojo::PendingRemote<::blink::mojom::BlobURLToken> p_blob_url_token{};
      ::mojo::PendingAssociatedRemote<::content::mojom::NavigationClient> p_navigation_client{};
      ::mojo::PendingRemote<::blink::mojom::NavigationInitiator> p_navigation_initiator{};
      FrameHost_BeginNavigation_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadCommonParams(&p_common_params))
        success = false;
      if (success && !input_data_view.ReadBeginParams(&p_begin_params))
        success = false;
      if (success) {
        p_blob_url_token =
            input_data_view.TakeBlobUrlToken<decltype(p_blob_url_token)>();
      }
      if (success) {
        p_navigation_client =
            input_data_view.TakeNavigationClient<decltype(p_navigation_client)>();
      }
      if (success) {
        p_navigation_initiator =
            input_data_view.TakeNavigationInitiator<decltype(p_navigation_initiator)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BeginNavigation(
std::move(p_common_params), 
std::move(p_begin_params), 
std::move(p_blob_url_token), 
std::move(p_navigation_client), 
std::move(p_navigation_initiator));
      return true;
    }
    case internal::kFrameHost_SubresourceResponseStarted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::SubresourceResponseStarted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::SubresourceResponseStarted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHost_SubresourceResponseStarted_Params_Data* params =
          reinterpret_cast<internal::FrameHost_SubresourceResponseStarted_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      uint32_t p_cert_status{};
      FrameHost_SubresourceResponseStarted_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_cert_status = input_data_view.cert_status();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubresourceResponseStarted(
std::move(p_url), 
std::move(p_cert_status));
      return true;
    }
    case internal::kFrameHost_ResourceLoadComplete_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::ResourceLoadComplete",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::ResourceLoadComplete");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHost_ResourceLoadComplete_Params_Data* params =
          reinterpret_cast<internal::FrameHost_ResourceLoadComplete_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::ResourceLoadInfoPtr p_url_load_info{};
      FrameHost_ResourceLoadComplete_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUrlLoadInfo(&p_url_load_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResourceLoadComplete(
std::move(p_url_load_info));
      return true;
    }
    case internal::kFrameHost_DidChangeName_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::DidChangeName",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::DidChangeName");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHost_DidChangeName_Params_Data* params =
          reinterpret_cast<internal::FrameHost_DidChangeName_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_name{};
      std::string p_unique_name{};
      FrameHost_DidChangeName_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadUniqueName(&p_unique_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeName(
std::move(p_name), 
std::move(p_unique_name));
      return true;
    }
    case internal::kFrameHost_DidSetFramePolicyHeaders_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::DidSetFramePolicyHeaders",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::DidSetFramePolicyHeaders");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHost_DidSetFramePolicyHeaders_Params_Data* params =
          reinterpret_cast<internal::FrameHost_DidSetFramePolicyHeaders_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::network::mojom::WebSandboxFlags p_sandbox_flags{};
      std::vector<::blink::ParsedFeaturePolicyDeclaration> p_feature_policy_header{};
      base::flat_map<::blink::mojom::DocumentPolicyFeature, ::blink::PolicyValue> p_document_policy_header{};
      FrameHost_DidSetFramePolicyHeaders_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSandboxFlags(&p_sandbox_flags))
        success = false;
      if (success && !input_data_view.ReadFeaturePolicyHeader(&p_feature_policy_header))
        success = false;
      if (success && !input_data_view.ReadDocumentPolicyHeader(&p_document_policy_header))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidSetFramePolicyHeaders(
std::move(p_sandbox_flags), 
std::move(p_feature_policy_header), 
std::move(p_document_policy_header));
      return true;
    }
    case internal::kFrameHost_CancelInitialHistoryLoad_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::CancelInitialHistoryLoad",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::CancelInitialHistoryLoad");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHost_CancelInitialHistoryLoad_Params_Data* params =
          reinterpret_cast<internal::FrameHost_CancelInitialHistoryLoad_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FrameHost_CancelInitialHistoryLoad_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelInitialHistoryLoad();
      return true;
    }
    case internal::kFrameHost_UpdateEncoding_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::UpdateEncoding",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::UpdateEncoding");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHost_UpdateEncoding_Params_Data* params =
          reinterpret_cast<internal::FrameHost_UpdateEncoding_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_encoding_name{};
      FrameHost_UpdateEncoding_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadEncodingName(&p_encoding_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateEncoding(
std::move(p_encoding_name));
      return true;
    }
    case internal::kFrameHost_FrameSizeChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::FrameSizeChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::FrameSizeChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHost_FrameSizeChanged_Params_Data* params =
          reinterpret_cast<internal::FrameHost_FrameSizeChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Size p_size{};
      FrameHost_FrameSizeChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSize(&p_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FrameSizeChanged(
std::move(p_size));
      return true;
    }
    case internal::kFrameHost_DidAddMessageToConsole_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::DidAddMessageToConsole",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::DidAddMessageToConsole");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHost_DidAddMessageToConsole_Params_Data* params =
          reinterpret_cast<internal::FrameHost_DidAddMessageToConsole_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::ConsoleMessageLevel p_log_level{};
      ::base::string16 p_msg{};
      int32_t p_line_number{};
      ::base::string16 p_source_id{};
      FrameHost_DidAddMessageToConsole_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadLogLevel(&p_log_level))
        success = false;
      if (success && !input_data_view.ReadMsg(&p_msg))
        success = false;
      if (success)
        p_line_number = input_data_view.line_number();
      if (success && !input_data_view.ReadSourceId(&p_source_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidAddMessageToConsole(
std::move(p_log_level), 
std::move(p_msg), 
std::move(p_line_number), 
std::move(p_source_id));
      return true;
    }
    case internal::kFrameHost_ShowCreatedWindow_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::ShowCreatedWindow",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::ShowCreatedWindow");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHost_ShowCreatedWindow_Params_Data* params =
          reinterpret_cast<internal::FrameHost_ShowCreatedWindow_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_pending_widget_routing_id{};
      ::WindowOpenDisposition p_disposition{};
      ::gfx::Rect p_rect{};
      bool p_opened_by_user_gesture{};
      FrameHost_ShowCreatedWindow_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_pending_widget_routing_id = input_data_view.pending_widget_routing_id();
      if (success && !input_data_view.ReadDisposition(&p_disposition))
        success = false;
      if (success && !input_data_view.ReadRect(&p_rect))
        success = false;
      if (success)
        p_opened_by_user_gesture = input_data_view.opened_by_user_gesture();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowCreatedWindow(
std::move(p_pending_widget_routing_id), 
std::move(p_disposition), 
std::move(p_rect), 
std::move(p_opened_by_user_gesture));
      return true;
    }
    case internal::kFrameHost_UpdateState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::UpdateState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::UpdateState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHost_UpdateState_Params_Data* params =
          reinterpret_cast<internal::FrameHost_UpdateState_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::content::PageState p_state{};
      FrameHost_UpdateState_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateState(
std::move(p_state));
      return true;
    }
    case internal::kFrameHost_OpenURL_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::OpenURL",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::OpenURL");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHost_OpenURL_Params_Data* params =
          reinterpret_cast<internal::FrameHost_OpenURL_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      OpenURLParamsPtr p_params{};
      FrameHost_OpenURL_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenURL(
std::move(p_params));
      return true;
    }
    case internal::kFrameHost_DidStopLoading_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::DidStopLoading",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::DidStopLoading");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHost_DidStopLoading_Params_Data* params =
          reinterpret_cast<internal::FrameHost_DidStopLoading_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FrameHost_DidStopLoading_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidStopLoading();
      return true;
    }
  }
  return false;
}

// static
bool FrameHostStubDispatch::AcceptWithResponder(
    FrameHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFrameHost_CreateNewWindow_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::CreateNewWindow",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::CreateNewWindow");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FrameHost_CreateNewWindow_Params_Data* params =
          reinterpret_cast<
              internal::FrameHost_CreateNewWindow_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      CreateNewWindowParamsPtr p_params{};
      FrameHost_CreateNewWindow_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 0, false);
        return false;
      }
      FrameHost::CreateNewWindowCallback callback =
          FrameHost_CreateNewWindow_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateNewWindow(
std::move(p_params), std::move(callback));
      return true;
    }
    case internal::kFrameHost_CreatePortal_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::CreatePortal",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::CreatePortal");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FrameHost_CreatePortal_Params_Data* params =
          reinterpret_cast<
              internal::FrameHost_CreatePortal_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedReceiver<::blink::mojom::Portal> p_portal{};
      ::mojo::PendingAssociatedRemote<::blink::mojom::PortalClient> p_client{};
      FrameHost_CreatePortal_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_portal =
            input_data_view.TakePortal<decltype(p_portal)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 1, false);
        return false;
      }
      FrameHost::CreatePortalCallback callback =
          FrameHost_CreatePortal_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePortal(
std::move(p_portal), 
std::move(p_client), std::move(callback));
      return true;
    }
    case internal::kFrameHost_AdoptPortal_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::AdoptPortal",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::AdoptPortal");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FrameHost_AdoptPortal_Params_Data* params =
          reinterpret_cast<
              internal::FrameHost_AdoptPortal_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::PortalToken p_portal_token{};
      FrameHost_AdoptPortal_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadPortalToken(&p_portal_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 2, false);
        return false;
      }
      FrameHost::AdoptPortalCallback callback =
          FrameHost_AdoptPortal_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AdoptPortal(
std::move(p_portal_token), std::move(callback));
      return true;
    }
    case internal::kFrameHost_CreateNewWidget_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::CreateNewWidget",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::CreateNewWidget");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FrameHost_CreateNewWidget_Params_Data* params =
          reinterpret_cast<
              internal::FrameHost_CreateNewWidget_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost> p_blink_widget_host{};
      ::mojo::PendingAssociatedRemote<::blink::mojom::Widget> p_blink_widget{};
      FrameHost_CreateNewWidget_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_blink_widget_host =
            input_data_view.TakeBlinkWidgetHost<decltype(p_blink_widget_host)>();
      }
      if (success) {
        p_blink_widget =
            input_data_view.TakeBlinkWidget<decltype(p_blink_widget)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 3, false);
        return false;
      }
      FrameHost::CreateNewWidgetCallback callback =
          FrameHost_CreateNewWidget_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateNewWidget(
std::move(p_blink_widget_host), 
std::move(p_blink_widget), std::move(callback));
      return true;
    }
    case internal::kFrameHost_CreateNewFullscreenWidget_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::CreateNewFullscreenWidget",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::CreateNewFullscreenWidget");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FrameHost_CreateNewFullscreenWidget_Params_Data* params =
          reinterpret_cast<
              internal::FrameHost_CreateNewFullscreenWidget_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost> p_blink_widget_host{};
      ::mojo::PendingAssociatedRemote<::blink::mojom::Widget> p_blink_widget{};
      FrameHost_CreateNewFullscreenWidget_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_blink_widget_host =
            input_data_view.TakeBlinkWidgetHost<decltype(p_blink_widget_host)>();
      }
      if (success) {
        p_blink_widget =
            input_data_view.TakeBlinkWidget<decltype(p_blink_widget)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 4, false);
        return false;
      }
      FrameHost::CreateNewFullscreenWidgetCallback callback =
          FrameHost_CreateNewFullscreenWidget_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateNewFullscreenWidget(
std::move(p_blink_widget_host), 
std::move(p_blink_widget), std::move(callback));
      return true;
    }
    case internal::kFrameHost_IssueKeepAliveHandle_Name: {
      break;
    }
    case internal::kFrameHost_DidCommitProvisionalLoad_Name: {
      break;
    }
    case internal::kFrameHost_DidCommitSameDocumentNavigation_Name: {
      break;
    }
    case internal::kFrameHost_BeginNavigation_Name: {
      break;
    }
    case internal::kFrameHost_SubresourceResponseStarted_Name: {
      break;
    }
    case internal::kFrameHost_ResourceLoadComplete_Name: {
      break;
    }
    case internal::kFrameHost_DidChangeName_Name: {
      break;
    }
    case internal::kFrameHost_DidSetFramePolicyHeaders_Name: {
      break;
    }
    case internal::kFrameHost_CancelInitialHistoryLoad_Name: {
      break;
    }
    case internal::kFrameHost_UpdateEncoding_Name: {
      break;
    }
    case internal::kFrameHost_FrameSizeChanged_Name: {
      break;
    }
    case internal::kFrameHost_DidAddMessageToConsole_Name: {
      break;
    }
    case internal::kFrameHost_ShowCreatedWindow_Name: {
      break;
    }
    case internal::kFrameHost_UpdateState_Name: {
      break;
    }
    case internal::kFrameHost_OpenURL_Name: {
      break;
    }
    case internal::kFrameHost_DidStopLoading_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameHostValidationInfo[] = {
    {internal::kFrameHost_CreateNewWindow_Name,
     {&internal::FrameHost_CreateNewWindow_Params_Data::Validate,
      &internal::FrameHost_CreateNewWindow_ResponseParams_Data::Validate}},
    {internal::kFrameHost_CreatePortal_Name,
     {&internal::FrameHost_CreatePortal_Params_Data::Validate,
      &internal::FrameHost_CreatePortal_ResponseParams_Data::Validate}},
    {internal::kFrameHost_AdoptPortal_Name,
     {&internal::FrameHost_AdoptPortal_Params_Data::Validate,
      &internal::FrameHost_AdoptPortal_ResponseParams_Data::Validate}},
    {internal::kFrameHost_CreateNewWidget_Name,
     {&internal::FrameHost_CreateNewWidget_Params_Data::Validate,
      &internal::FrameHost_CreateNewWidget_ResponseParams_Data::Validate}},
    {internal::kFrameHost_CreateNewFullscreenWidget_Name,
     {&internal::FrameHost_CreateNewFullscreenWidget_Params_Data::Validate,
      &internal::FrameHost_CreateNewFullscreenWidget_ResponseParams_Data::Validate}},
    {internal::kFrameHost_IssueKeepAliveHandle_Name,
     {&internal::FrameHost_IssueKeepAliveHandle_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameHost_DidCommitProvisionalLoad_Name,
     {&internal::FrameHost_DidCommitProvisionalLoad_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameHost_DidCommitSameDocumentNavigation_Name,
     {&internal::FrameHost_DidCommitSameDocumentNavigation_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameHost_BeginNavigation_Name,
     {&internal::FrameHost_BeginNavigation_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameHost_SubresourceResponseStarted_Name,
     {&internal::FrameHost_SubresourceResponseStarted_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameHost_ResourceLoadComplete_Name,
     {&internal::FrameHost_ResourceLoadComplete_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameHost_DidChangeName_Name,
     {&internal::FrameHost_DidChangeName_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameHost_DidSetFramePolicyHeaders_Name,
     {&internal::FrameHost_DidSetFramePolicyHeaders_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameHost_CancelInitialHistoryLoad_Name,
     {&internal::FrameHost_CancelInitialHistoryLoad_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameHost_UpdateEncoding_Name,
     {&internal::FrameHost_UpdateEncoding_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameHost_FrameSizeChanged_Name,
     {&internal::FrameHost_FrameSizeChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameHost_DidAddMessageToConsole_Name,
     {&internal::FrameHost_DidAddMessageToConsole_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameHost_ShowCreatedWindow_Name,
     {&internal::FrameHost_ShowCreatedWindow_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameHost_UpdateState_Name,
     {&internal::FrameHost_UpdateState_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameHost_OpenURL_Name,
     {&internal::FrameHost_OpenURL_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameHost_DidStopLoading_Name,
     {&internal::FrameHost_DidStopLoading_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FrameHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::FrameHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFrameHostValidationInfo);
}

bool FrameHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::FrameHost::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kFrameHostValidationInfo);

}
}  // namespace mojom
}  // namespace content

namespace mojo {


// static
bool StructTraits<::content::mojom::CreateNewWindowParams::DataView, ::content::mojom::CreateNewWindowParamsPtr>::Read(
    ::content::mojom::CreateNewWindowParams::DataView input,
    ::content::mojom::CreateNewWindowParamsPtr* output) {
  bool success = true;
  ::content::mojom::CreateNewWindowParamsPtr result(::content::mojom::CreateNewWindowParams::New());
  
      if (success)
        result->allow_popup = input.allow_popup();
      if (success && !input.ReadWindowContainerType(&result->window_container_type))
        success = false;
      if (success && !input.ReadSessionStorageNamespaceId(&result->session_storage_namespace_id))
        success = false;
      if (success && !input.ReadCloneFromSessionStorageNamespaceId(&result->clone_from_session_storage_namespace_id))
        success = false;
      if (success && !input.ReadFrameName(&result->frame_name))
        success = false;
      if (success)
        result->opener_suppressed = input.opener_suppressed();
      if (success && !input.ReadDisposition(&result->disposition))
        success = false;
      if (success && !input.ReadTargetUrl(&result->target_url))
        success = false;
      if (success && !input.ReadReferrer(&result->referrer))
        success = false;
      if (success && !input.ReadFeatures(&result->features))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::CreateNewWindowReply::DataView, ::content::mojom::CreateNewWindowReplyPtr>::Read(
    ::content::mojom::CreateNewWindowReply::DataView input,
    ::content::mojom::CreateNewWindowReplyPtr* output) {
  bool success = true;
  ::content::mojom::CreateNewWindowReplyPtr result(::content::mojom::CreateNewWindowReply::New());
  
      if (success)
        result->route_id = input.route_id();
      if (success)
        result->main_frame_route_id = input.main_frame_route_id();
      if (success && !input.ReadMainFrameFrameToken(&result->main_frame_frame_token))
        success = false;
      if (success)
        result->main_frame_widget_route_id = input.main_frame_widget_route_id();
      if (success && !input.ReadVisualProperties(&result->visual_properties))
        success = false;
      if (success) {
        result->frame_widget_host =
            input.TakeFrameWidgetHost<decltype(result->frame_widget_host)>();
      }
      if (success) {
        result->frame_widget =
            input.TakeFrameWidget<decltype(result->frame_widget)>();
      }
      if (success) {
        result->widget_host =
            input.TakeWidgetHost<decltype(result->widget_host)>();
      }
      if (success) {
        result->widget =
            input.TakeWidget<decltype(result->widget)>();
      }
      if (success) {
        result->page_broadcast =
            input.TakePageBroadcast<decltype(result->page_broadcast)>();
      }
      if (success && !input.ReadMainFrameInterfaceBundle(&result->main_frame_interface_bundle))
        success = false;
      if (success && !input.ReadClonedSessionStorageNamespaceId(&result->cloned_session_storage_namespace_id))
        success = false;
      if (success && !input.ReadDevtoolsMainFrameToken(&result->devtools_main_frame_token))
        success = false;
      if (success)
        result->wait_for_debugger = input.wait_for_debugger();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::OpenURLParams::DataView, ::content::mojom::OpenURLParamsPtr>::Read(
    ::content::mojom::OpenURLParams::DataView input,
    ::content::mojom::OpenURLParamsPtr* output) {
  bool success = true;
  ::content::mojom::OpenURLParamsPtr result(::content::mojom::OpenURLParams::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadInitiatorOrigin(&result->initiator_origin))
        success = false;
      if (success)
        result->initiator_routing_id = input.initiator_routing_id();
      if (success && !input.ReadPostBody(&result->post_body))
        success = false;
      if (success && !input.ReadExtraHeaders(&result->extra_headers))
        success = false;
      if (success && !input.ReadReferrer(&result->referrer))
        success = false;
      if (success && !input.ReadDisposition(&result->disposition))
        success = false;
      if (success)
        result->should_replace_current_entry = input.should_replace_current_entry();
      if (success)
        result->user_gesture = input.user_gesture();
      if (success && !input.ReadTriggeringEventInfo(&result->triggering_event_info))
        success = false;
      if (success)
        result->blob_url_token = input.TakeBlobUrlToken();
      if (success && !input.ReadHrefTranslate(&result->href_translate))
        success = false;
      if (success && !input.ReadImpression(&result->impression))
        success = false;
      if (success && !input.ReadDownloadPolicy(&result->download_policy))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif