// services/content/public/mojom/navigable_contents_factory.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/content/public/mojom/navigable_contents_factory.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/content/public/mojom/navigable_contents_factory.mojom-params-data.h"
#include "services/content/public/mojom/navigable_contents_factory.mojom-shared-message-ids.h"

#include "services/content/public/mojom/navigable_contents_factory.mojom-import-headers.h"


#ifndef SERVICES_CONTENT_PUBLIC_MOJOM_NAVIGABLE_CONTENTS_FACTORY_MOJOM_JUMBO_H_
#define SERVICES_CONTENT_PUBLIC_MOJOM_NAVIGABLE_CONTENTS_FACTORY_MOJOM_JUMBO_H_
#endif
namespace content {
namespace mojom {
NavigableContentsParams::NavigableContentsParams()
    : enable_view_auto_resize(false),
      auto_resize_min_size(),
      auto_resize_max_size(),
      suppress_navigations(false),
      override_background_color(false),
      background_color(0xFFFFFFFFU) {}

NavigableContentsParams::NavigableContentsParams(
    bool enable_view_auto_resize_in,
    const base::Optional<::gfx::Size>& auto_resize_min_size_in,
    const base::Optional<::gfx::Size>& auto_resize_max_size_in,
    bool suppress_navigations_in,
    bool override_background_color_in,
    uint32_t background_color_in)
    : enable_view_auto_resize(std::move(enable_view_auto_resize_in)),
      auto_resize_min_size(std::move(auto_resize_min_size_in)),
      auto_resize_max_size(std::move(auto_resize_max_size_in)),
      suppress_navigations(std::move(suppress_navigations_in)),
      override_background_color(std::move(override_background_color_in)),
      background_color(std::move(background_color_in)) {}

NavigableContentsParams::~NavigableContentsParams() = default;

void NavigableContentsParams::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetBoolean("enable_view_auto_resize", this->enable_view_auto_resize);
  value->SetString("auto_resize_min_size", base::trace_event::ValueToString(this->auto_resize_min_size, "<value of type const base::Optional<::gfx::Size>&>"));
  value->SetString("auto_resize_max_size", base::trace_event::ValueToString(this->auto_resize_max_size, "<value of type const base::Optional<::gfx::Size>&>"));
  value->SetBoolean("suppress_navigations", this->suppress_navigations);
  value->SetBoolean("override_background_color", this->override_background_color);
  value->SetString("background_color", base::NumberToString(this->background_color));
}

bool NavigableContentsParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char NavigableContentsFactory::Name_[] = "content.mojom.NavigableContentsFactory";

NavigableContentsFactoryProxy::NavigableContentsFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NavigableContentsFactoryProxy::CreateContents(
    NavigableContentsParamsPtr in_params, ::mojo::PendingReceiver<::content::mojom::NavigableContents> in_receiver, ::mojo::PendingRemote<::content::mojom::NavigableContentsClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::NavigableContentsFactory::CreateContents", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_params.is_null()) {
        raw_value->SetString("params", "nullptr");
      } else {
        raw_value->BeginDictionary("params");
        in_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetBoolean("receiver", in_receiver.is_valid());
      raw_value->SetBoolean("client", in_client.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNavigableContentsFactory_CreateContents_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::NavigableContentsFactory_CreateContents_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->params)::BaseType::BufferWriter
      params_writer;
  mojo::internal::Serialize<::content::mojom::NavigableContentsParamsDataView>(
      in_params, buffer, &params_writer, &serialization_context);
  params->params.Set(
      params_writer.is_null() ? nullptr : params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in NavigableContentsFactory.CreateContents request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::content::mojom::NavigableContentsInterfaceBase>>(
      in_receiver, &params->receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in NavigableContentsFactory.CreateContents request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::content::mojom::NavigableContentsClientInterfaceBase>>(
      in_client, &params->client, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in NavigableContentsFactory.CreateContents request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NavigableContentsFactory::Name_);
  message.set_method_name("CreateContents");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool NavigableContentsFactoryStubDispatch::Accept(
    NavigableContentsFactory* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kNavigableContentsFactory_CreateContents_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::NavigableContentsFactory::CreateContents",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::NavigableContentsFactory::CreateContents");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NavigableContentsFactory_CreateContents_Params_Data* params =
          reinterpret_cast<internal::NavigableContentsFactory_CreateContents_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      NavigableContentsParamsPtr p_params{};
      ::mojo::PendingReceiver<::content::mojom::NavigableContents> p_receiver{};
      ::mojo::PendingRemote<::content::mojom::NavigableContentsClient> p_client{};
      NavigableContentsFactory_CreateContents_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NavigableContentsFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateContents(
std::move(p_params), 
std::move(p_receiver), 
std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool NavigableContentsFactoryStubDispatch::AcceptWithResponder(
    NavigableContentsFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNavigableContentsFactory_CreateContents_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kNavigableContentsFactoryValidationInfo[] = {
    {internal::kNavigableContentsFactory_CreateContents_Name,
     {&internal::NavigableContentsFactory_CreateContents_Params_Data::Validate,
      nullptr /* no response */}},
};

bool NavigableContentsFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::NavigableContentsFactory::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kNavigableContentsFactoryValidationInfo);
}

}  // namespace mojom
}  // namespace content

namespace mojo {


// static
bool StructTraits<::content::mojom::NavigableContentsParams::DataView, ::content::mojom::NavigableContentsParamsPtr>::Read(
    ::content::mojom::NavigableContentsParams::DataView input,
    ::content::mojom::NavigableContentsParamsPtr* output) {
  bool success = true;
  ::content::mojom::NavigableContentsParamsPtr result(::content::mojom::NavigableContentsParams::New());
  
      if (success)
        result->enable_view_auto_resize = input.enable_view_auto_resize();
      if (success && !input.ReadAutoResizeMinSize(&result->auto_resize_min_size))
        success = false;
      if (success && !input.ReadAutoResizeMaxSize(&result->auto_resize_max_size))
        success = false;
      if (success)
        result->suppress_navigations = input.suppress_navigations();
      if (success)
        result->override_background_color = input.override_background_color();
      if (success)
        result->background_color = input.background_color();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif