// services/network/public/mojom/site_for_cookies.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SITE_FOR_COOKIES_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SITE_FOR_COOKIES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "services/network/public/mojom/site_for_cookies.mojom-shared-internal.h"







namespace network {
namespace mojom {
class SiteForCookiesDataView;



}  // namespace mojom
}  // namespace network

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::SiteForCookiesDataView> {
  using Data = ::network::mojom::internal::SiteForCookies_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network {
namespace mojom {


class SiteForCookiesDataView {
 public:
  SiteForCookiesDataView() {}

  SiteForCookiesDataView(
      internal::SiteForCookies_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetSchemeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadScheme(UserType* output) {
    
    auto* pointer = data_->scheme.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetRegistrableDomainDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRegistrableDomain(UserType* output) {
    
    auto* pointer = data_->registrable_domain.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  bool schemefully_same() const {
    return data_->schemefully_same;
  }
  inline void GetFirstPartyUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFirstPartyUrl(UserType* output) {
    
    auto* pointer = data_->first_party_url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::SiteForCookies_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace network

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SiteForCookiesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SiteForCookiesDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::network::mojom::internal::SiteForCookies_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::scheme(input)) in_scheme = Traits::scheme(input);
    typename decltype((*output)->scheme)::BaseType::BufferWriter
        scheme_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_scheme, buffer, &scheme_writer, context);
    (*output)->scheme.Set(
        scheme_writer.is_null() ? nullptr : scheme_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->scheme.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scheme in SiteForCookies struct");
    decltype(Traits::registrable_domain(input)) in_registrable_domain = Traits::registrable_domain(input);
    typename decltype((*output)->registrable_domain)::BaseType::BufferWriter
        registrable_domain_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_registrable_domain, buffer, &registrable_domain_writer, context);
    (*output)->registrable_domain.Set(
        registrable_domain_writer.is_null() ? nullptr : registrable_domain_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->registrable_domain.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null registrable_domain in SiteForCookies struct");
    (*output)->schemefully_same = Traits::schemefully_same(input);
    decltype(Traits::first_party_url(input)) in_first_party_url = Traits::first_party_url(input);
    typename decltype((*output)->first_party_url)::BaseType::BufferWriter
        first_party_url_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_first_party_url, buffer, &first_party_url_writer, context);
    (*output)->first_party_url.Set(
        first_party_url_writer.is_null() ? nullptr : first_party_url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->first_party_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null first_party_url in SiteForCookies struct");
  }

  static bool Deserialize(::network::mojom::internal::SiteForCookies_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SiteForCookiesDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network {
namespace mojom {

inline void SiteForCookiesDataView::GetSchemeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->scheme.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void SiteForCookiesDataView::GetRegistrableDomainDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->registrable_domain.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void SiteForCookiesDataView::GetFirstPartyUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->first_party_url.Get();
  *output = mojo::StringDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace network

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SITE_FOR_COOKIES_MOJOM_SHARED_H_