// third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"

#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-params-data.h"
namespace blink {
namespace mojom {

std::ostream& operator<<(std::ostream& os, ScrollAlignment_Behavior value) {
  switch(value) {
    case ScrollAlignment_Behavior::kNoScroll:
      return os << "ScrollAlignment_Behavior::kNoScroll";
    case ScrollAlignment_Behavior::kCenter:
      return os << "ScrollAlignment_Behavior::kCenter";
    case ScrollAlignment_Behavior::kTop:
      return os << "ScrollAlignment_Behavior::kTop";
    case ScrollAlignment_Behavior::kBottom:
      return os << "ScrollAlignment_Behavior::kBottom";
    case ScrollAlignment_Behavior::kLeft:
      return os << "ScrollAlignment_Behavior::kLeft";
    case ScrollAlignment_Behavior::kRight:
      return os << "ScrollAlignment_Behavior::kRight";
    case ScrollAlignment_Behavior::kClosestEdge:
      return os << "ScrollAlignment_Behavior::kClosestEdge";
    default:
      return os << "Unknown ScrollAlignment_Behavior value: " << static_cast<int32_t>(value);
  }
}

namespace internal {


// static
bool ScrollAlignment_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ScrollAlignment_Data* object = static_cast<const ScrollAlignment_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::blink::mojom::internal::ScrollAlignment_Behavior_Data
        ::Validate(object->rect_visible, validation_context))
    return false;


  if (!::blink::mojom::internal::ScrollAlignment_Behavior_Data
        ::Validate(object->rect_hidden, validation_context))
    return false;


  if (!::blink::mojom::internal::ScrollAlignment_Behavior_Data
        ::Validate(object->rect_partial, validation_context))
    return false;

  return true;
}

ScrollAlignment_Data::ScrollAlignment_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScrollIntoViewParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ScrollIntoViewParams_Data* object = static_cast<const ScrollIntoViewParams_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 56 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->align_x, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->align_x, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->align_y, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->align_y, validation_context))
    return false;


  if (!::blink::mojom::internal::ScrollType_Data
        ::Validate(object->type, validation_context))
    return false;


  if (!::blink::mojom::internal::ScrollBehavior_Data
        ::Validate(object->behavior, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->relative_element_bounds, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->relative_element_bounds, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->relative_caret_bounds, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->relative_caret_bounds, validation_context))
    return false;

  return true;
}

ScrollIntoViewParams_Data::ScrollIntoViewParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink