// components/paint_preview/common/mojom/paint_preview_recorder.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_RECORDER_MOJOM_SHARED_H_
#define COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_RECORDER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/paint_preview/common/mojom/paint_preview_recorder.mojom-shared-internal.h"
#include "components/paint_preview/common/mojom/paint_preview_types.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace paint_preview::mojom {
class PaintPreviewCaptureParamsDataView;

class LinkDataDataView;

class PaintPreviewCaptureResponseDataView;



}  // paint_preview::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::paint_preview::mojom::PaintPreviewCaptureParamsDataView> {
  using Data = ::paint_preview::mojom::internal::PaintPreviewCaptureParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::paint_preview::mojom::LinkDataDataView> {
  using Data = ::paint_preview::mojom::internal::LinkData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::paint_preview::mojom::PaintPreviewCaptureResponseDataView> {
  using Data = ::paint_preview::mojom::internal::PaintPreviewCaptureResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace paint_preview::mojom {


enum class PaintPreviewStatus : int32_t {
  
  kOk = 0,
  
  kAlreadyCapturing = 1,
  
  kCaptureFailed = 2,
  
  kGuidCollision = 3,
  
  kFileCreationError = 4,
  
  kPartialSuccess = 5,
  
  kFailed = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

 std::ostream& operator<<(std::ostream& os, PaintPreviewStatus value);
inline bool IsKnownEnumValue(PaintPreviewStatus value) {
  return internal::PaintPreviewStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PaintPreviewRecorderInterfaceBase {};

using PaintPreviewRecorderPtrDataView =
    mojo::InterfacePtrDataView<PaintPreviewRecorderInterfaceBase>;
using PaintPreviewRecorderRequestDataView =
    mojo::InterfaceRequestDataView<PaintPreviewRecorderInterfaceBase>;
using PaintPreviewRecorderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PaintPreviewRecorderInterfaceBase>;
using PaintPreviewRecorderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PaintPreviewRecorderInterfaceBase>;


class PaintPreviewCaptureParamsDataView {
 public:
  PaintPreviewCaptureParamsDataView() = default;

  PaintPreviewCaptureParamsDataView(
      internal::PaintPreviewCaptureParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadPersistence(UserType* output) const {
    auto data_value = data_->persistence;
    return mojo::internal::Deserialize<::paint_preview::mojom::RecordingPersistence>(
        data_value, output);
  }
  ::paint_preview::mojom::RecordingPersistence persistence() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::paint_preview::mojom::RecordingPersistence>(data_->persistence));
  }
  inline void GetGuidDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGuid(UserType* output) {
    
    auto* pointer = data_->guid.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetClipRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClipRect(UserType* output) {
    
    auto* pointer = data_->clip_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  bool clip_rect_is_hint() const {
    return data_->clip_rect_is_hint;
  }
  bool is_main_frame() const {
    return data_->is_main_frame;
  }
  bool capture_links() const {
    return data_->capture_links;
  }
  inline void GetFileDataView(
      ::mojo_base::mojom::FileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFile(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FileDataView, UserType>(),
    "Attempting to read the optional `file` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFile` instead "
    "of `ReadFile if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->file.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        pointer, output, message_);
  }
  uint64_t max_capture_size() const {
    return data_->max_capture_size;
  }
  uint64_t max_decoded_image_size_bytes() const {
    return data_->max_decoded_image_size_bytes;
  }
  bool skip_accelerated_content() const {
    return data_->skip_accelerated_content;
  }
 private:
  internal::PaintPreviewCaptureParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LinkDataDataView {
 public:
  LinkDataDataView() = default;

  LinkDataDataView(
      internal::LinkData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRect(UserType* output) {
    
    auto* pointer = data_->rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
 private:
  internal::LinkData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PaintPreviewCaptureResponseDataView {
 public:
  PaintPreviewCaptureResponseDataView() = default;

  PaintPreviewCaptureResponseDataView(
      internal::PaintPreviewCaptureResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEmbeddingTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEmbeddingToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `embedding_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadEmbeddingToken` instead "
    "of `ReadEmbeddingToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->embedding_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetContentIdToEmbeddingTokenDataView(
      mojo::MapDataView<uint32_t, ::mojo_base::mojom::UnguessableTokenDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentIdToEmbeddingToken(UserType* output) {
    
    auto* pointer = data_->content_id_to_embedding_token.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<uint32_t, ::mojo_base::mojom::UnguessableTokenDataView>>(
        pointer, output, message_);
  }
  inline void GetLinksDataView(
      mojo::ArrayDataView<LinkDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLinks(UserType* output) {
    
    auto* pointer = data_->links.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::paint_preview::mojom::LinkDataDataView>>(
        pointer, output, message_);
  }
  inline void GetBlinkRecordingTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBlinkRecordingTime(UserType* output) {
    
    auto* pointer = data_->blink_recording_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  uint64_t serialized_size() const {
    return data_->serialized_size;
  }
  inline void GetScrollOffsetsDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollOffsets(UserType* output) {
    
    auto* pointer = data_->scroll_offsets.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, message_);
  }
  inline void GetFrameOffsetsDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameOffsets(UserType* output) {
    
    auto* pointer = data_->frame_offsets.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, message_);
  }
  inline void GetSkpDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSkp(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::BigBufferDataView, UserType>(),
    "Attempting to read the optional `skp` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSkp` instead "
    "of `ReadSkp if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->skp.is_null() ? &data_->skp : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, message_);
  }
 private:
  internal::PaintPreviewCaptureResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // paint_preview::mojom

namespace std {

template <>
struct hash<::paint_preview::mojom::PaintPreviewStatus>
    : public mojo::internal::EnumHashImpl<::paint_preview::mojom::PaintPreviewStatus> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::paint_preview::mojom::PaintPreviewStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::paint_preview::mojom::PaintPreviewStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::paint_preview::mojom::PaintPreviewStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::paint_preview::mojom::PaintPreviewCaptureParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::paint_preview::mojom::PaintPreviewCaptureParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::paint_preview::mojom::internal::PaintPreviewCaptureParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::paint_preview::mojom::RecordingPersistence>(
        Traits::persistence(input), &fragment->persistence);
    decltype(Traits::guid(input)) in_guid = Traits::guid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->guid)::BaseType> guid_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_guid, guid_fragment);
    fragment->guid.Set(
        guid_fragment.is_null() ? nullptr : guid_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->guid.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null guid in PaintPreviewCaptureParams struct");
    decltype(Traits::clip_rect(input)) in_clip_rect = Traits::clip_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->clip_rect)::BaseType> clip_rect_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_clip_rect, clip_rect_fragment);
    fragment->clip_rect.Set(
        clip_rect_fragment.is_null() ? nullptr : clip_rect_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->clip_rect.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null clip_rect in PaintPreviewCaptureParams struct");
    fragment->clip_rect_is_hint = Traits::clip_rect_is_hint(input);
    fragment->is_main_frame = Traits::is_main_frame(input);
    fragment->capture_links = Traits::capture_links(input);
    decltype(Traits::file(input)) in_file = Traits::file(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->file)::BaseType> file_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
        in_file, file_fragment);
    fragment->file.Set(
        file_fragment.is_null() ? nullptr : file_fragment.data());
    fragment->max_capture_size = Traits::max_capture_size(input);
    fragment->max_decoded_image_size_bytes = Traits::max_decoded_image_size_bytes(input);
    fragment->skip_accelerated_content = Traits::skip_accelerated_content(input);
  }

  static bool Deserialize(::paint_preview::mojom::internal::PaintPreviewCaptureParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::paint_preview::mojom::PaintPreviewCaptureParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::paint_preview::mojom::LinkDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::paint_preview::mojom::LinkDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::paint_preview::mojom::internal::LinkData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, url_fragment);
    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in LinkData struct");
    decltype(Traits::rect(input)) in_rect = Traits::rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->rect)::BaseType> rect_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_rect, rect_fragment);
    fragment->rect.Set(
        rect_fragment.is_null() ? nullptr : rect_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->rect.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null rect in LinkData struct");
  }

  static bool Deserialize(::paint_preview::mojom::internal::LinkData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::paint_preview::mojom::LinkDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::paint_preview::mojom::PaintPreviewCaptureResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::paint_preview::mojom::PaintPreviewCaptureResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::paint_preview::mojom::internal::PaintPreviewCaptureResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::embedding_token(input)) in_embedding_token = Traits::embedding_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->embedding_token)::BaseType> embedding_token_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_embedding_token, embedding_token_fragment);
    fragment->embedding_token.Set(
        embedding_token_fragment.is_null() ? nullptr : embedding_token_fragment.data());
    decltype(Traits::content_id_to_embedding_token(input)) in_content_id_to_embedding_token = Traits::content_id_to_embedding_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content_id_to_embedding_token)::BaseType>
        content_id_to_embedding_token_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& content_id_to_embedding_token_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<uint32_t, ::mojo_base::mojom::UnguessableTokenDataView>>(
        in_content_id_to_embedding_token, content_id_to_embedding_token_fragment, &content_id_to_embedding_token_validate_params);
    fragment->content_id_to_embedding_token.Set(
        content_id_to_embedding_token_fragment.is_null() ? nullptr : content_id_to_embedding_token_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->content_id_to_embedding_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content_id_to_embedding_token in PaintPreviewCaptureResponse struct");
    decltype(Traits::links(input)) in_links = Traits::links(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->links)::BaseType>
        links_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& links_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::paint_preview::mojom::LinkDataDataView>>(
        in_links, links_fragment, &links_validate_params);
    fragment->links.Set(
        links_fragment.is_null() ? nullptr : links_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->links.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null links in PaintPreviewCaptureResponse struct");
    decltype(Traits::blink_recording_time(input)) in_blink_recording_time = Traits::blink_recording_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->blink_recording_time)::BaseType> blink_recording_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_blink_recording_time, blink_recording_time_fragment);
    fragment->blink_recording_time.Set(
        blink_recording_time_fragment.is_null() ? nullptr : blink_recording_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->blink_recording_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null blink_recording_time in PaintPreviewCaptureResponse struct");
    fragment->serialized_size = Traits::serialized_size(input);
    decltype(Traits::scroll_offsets(input)) in_scroll_offsets = Traits::scroll_offsets(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scroll_offsets)::BaseType> scroll_offsets_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::PointDataView>(
        in_scroll_offsets, scroll_offsets_fragment);
    fragment->scroll_offsets.Set(
        scroll_offsets_fragment.is_null() ? nullptr : scroll_offsets_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->scroll_offsets.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scroll_offsets in PaintPreviewCaptureResponse struct");
    decltype(Traits::frame_offsets(input)) in_frame_offsets = Traits::frame_offsets(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_offsets)::BaseType> frame_offsets_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::PointDataView>(
        in_frame_offsets, frame_offsets_fragment);
    fragment->frame_offsets.Set(
        frame_offsets_fragment.is_null() ? nullptr : frame_offsets_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->frame_offsets.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_offsets in PaintPreviewCaptureResponse struct");
    decltype(Traits::skp(input)) in_skp = Traits::skp(input);
    mojo::internal::MessageFragment<decltype(fragment->skp)>
        skp_fragment(fragment.message());
    skp_fragment.Claim(&fragment->skp);
    mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
        in_skp, skp_fragment, true);
  }

  static bool Deserialize(::paint_preview::mojom::internal::PaintPreviewCaptureResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::paint_preview::mojom::PaintPreviewCaptureResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace paint_preview::mojom {

inline void PaintPreviewCaptureParamsDataView::GetGuidDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->guid.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void PaintPreviewCaptureParamsDataView::GetClipRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->clip_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void PaintPreviewCaptureParamsDataView::GetFileDataView(
    ::mojo_base::mojom::FileDataView* output) {
  auto pointer = data_->file.Get();
  *output = ::mojo_base::mojom::FileDataView(pointer, message_);
}


inline void LinkDataDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void LinkDataDataView::GetRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}


inline void PaintPreviewCaptureResponseDataView::GetEmbeddingTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->embedding_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void PaintPreviewCaptureResponseDataView::GetContentIdToEmbeddingTokenDataView(
    mojo::MapDataView<uint32_t, ::mojo_base::mojom::UnguessableTokenDataView>* output) {
  auto pointer = data_->content_id_to_embedding_token.Get();
  *output = mojo::MapDataView<uint32_t, ::mojo_base::mojom::UnguessableTokenDataView>(pointer, message_);
}
inline void PaintPreviewCaptureResponseDataView::GetLinksDataView(
    mojo::ArrayDataView<LinkDataDataView>* output) {
  auto pointer = data_->links.Get();
  *output = mojo::ArrayDataView<LinkDataDataView>(pointer, message_);
}
inline void PaintPreviewCaptureResponseDataView::GetBlinkRecordingTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->blink_recording_time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void PaintPreviewCaptureResponseDataView::GetScrollOffsetsDataView(
    ::gfx::mojom::PointDataView* output) {
  auto pointer = data_->scroll_offsets.Get();
  *output = ::gfx::mojom::PointDataView(pointer, message_);
}
inline void PaintPreviewCaptureResponseDataView::GetFrameOffsetsDataView(
    ::gfx::mojom::PointDataView* output) {
  auto pointer = data_->frame_offsets.Get();
  *output = ::gfx::mojom::PointDataView(pointer, message_);
}
inline void PaintPreviewCaptureResponseDataView::GetSkpDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->skp;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, message_);
}



}  // paint_preview::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::paint_preview::mojom::PaintPreviewStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::paint_preview::mojom::PaintPreviewStatus value);
};

} // namespace perfetto

#endif  // COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_RECORDER_MOJOM_SHARED_H_