// components/services/storage/privileged/mojom/indexed_db_internals_types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/services/storage/privileged/mojom/indexed_db_internals_types.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/storage/privileged/mojom/indexed_db_internals_types.mojom-params-data.h"
namespace storage {
namespace mojom {

NOINLINE static const char* IdbTransactionModeToStringHelper(IdbTransactionMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IdbTransactionMode::kReadOnly:
      return "kReadOnly";
    case IdbTransactionMode::kReadWrite:
      return "kReadWrite";
    case IdbTransactionMode::kVersionChange:
      return "kVersionChange";
    default:
      return nullptr;
  }
}

std::string IdbTransactionModeToString(IdbTransactionMode value) {
  const char *str = IdbTransactionModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IdbTransactionMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IdbTransactionMode value) {
  return os << IdbTransactionModeToString(value);
}

NOINLINE static const char* IdbTransactionStateToStringHelper(IdbTransactionState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IdbTransactionState::kBlocked:
      return "kBlocked";
    case IdbTransactionState::kRunning:
      return "kRunning";
    case IdbTransactionState::kStarted:
      return "kStarted";
    case IdbTransactionState::kCommitting:
      return "kCommitting";
    case IdbTransactionState::kFinished:
      return "kFinished";
    default:
      return nullptr;
  }
}

std::string IdbTransactionStateToString(IdbTransactionState value) {
  const char *str = IdbTransactionStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IdbTransactionState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IdbTransactionState value) {
  return os << IdbTransactionStateToString(value);
}

namespace internal {


// static
bool IdbOriginMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IdbOriginMetadata_Data* object =
      static_cast<const IdbOriginMetadata_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->storage_keys, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& storage_keys_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->storage_keys, validation_context,
                                         &storage_keys_validate_params)) {
    return false;
  }

  return true;
}

IdbOriginMetadata_Data::IdbOriginMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IdbStorageKeyMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IdbStorageKeyMetadata_Data* object =
      static_cast<const IdbStorageKeyMetadata_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->top_level_site, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->top_level_site, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->serialized_storage_key, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& serialized_storage_key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->serialized_storage_key, validation_context,
                                         &serialized_storage_key_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->buckets, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& buckets_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->buckets, validation_context,
                                         &buckets_validate_params)) {
    return false;
  }

  return true;
}

IdbStorageKeyMetadata_Data::IdbStorageKeyMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IdbBucketMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IdbBucketMetadata_Data* object =
      static_cast<const IdbBucketMetadata_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bucket_locator, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bucket_locator, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_modified, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->last_modified, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->paths, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& paths_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->paths, validation_context,
                                         &paths_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->databases, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& databases_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->databases, validation_context,
                                         &databases_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->clients, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& clients_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->clients, validation_context,
                                         &clients_validate_params)) {
    return false;
  }

  return true;
}

IdbBucketMetadata_Data::IdbBucketMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IdbDatabaseMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IdbDatabaseMetadata_Data* object =
      static_cast<const IdbDatabaseMetadata_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->transactions, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& transactions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->transactions, validation_context,
                                         &transactions_validate_params)) {
    return false;
  }

  return true;
}

IdbDatabaseMetadata_Data::IdbDatabaseMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IdbTransactionMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 88, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IdbTransactionMetadata_Data* object =
      static_cast<const IdbTransactionMetadata_Data*>(data);


  if (!::storage::mojom::internal::IdbTransactionMode_Data
        ::Validate(object->mode, validation_context))
    return false;


  if (!::storage::mojom::internal::IdbTransactionState_Data
        ::Validate(object->state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->client_token, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& client_token_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->client_token, validation_context,
                                         &client_token_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scope, 10, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& scope_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->scope, validation_context,
                                         &scope_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->state_history, 11, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& state_history_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->state_history, validation_context,
                                         &state_history_validate_params)) {
    return false;
  }

  return true;
}

IdbTransactionMetadata_Data::IdbTransactionMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IdbTransactionMetadataStateHistory_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IdbTransactionMetadataStateHistory_Data* object =
      static_cast<const IdbTransactionMetadataStateHistory_Data*>(data);


  if (!::storage::mojom::internal::IdbTransactionState_Data
        ::Validate(object->state, validation_context))
    return false;

  return true;
}

IdbTransactionMetadataStateHistory_Data::IdbTransactionMetadataStateHistory_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace storage

namespace perfetto {

// static
void TraceFormatTraits<::storage::mojom::IdbTransactionMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::storage::mojom::IdbTransactionMode value) {
  return std::move(context).WriteString(::storage::mojom::IdbTransactionModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::storage::mojom::IdbTransactionState>::WriteIntoTrace(
   perfetto::TracedValue context, ::storage::mojom::IdbTransactionState value) {
  return std::move(context).WriteString(::storage::mojom::IdbTransactionStateToString(value));
}

} // namespace perfetto