// components/spellcheck/common/spellcheck.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/spellcheck/common/spellcheck.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/spellcheck/common/spellcheck.mojom-params-data.h"
#include "components/spellcheck/common/spellcheck.mojom-shared-message-ids.h"

#include "components/spellcheck/common/spellcheck.mojom-import-headers.h"
#include "components/spellcheck/common/spellcheck.mojom-test-utils.h"


namespace spellcheck::mojom {
SpellCheckBDictLanguage::SpellCheckBDictLanguage()
    : file(),
      language() {}

SpellCheckBDictLanguage::SpellCheckBDictLanguage(
    ::base::File file_in,
    const std::string& language_in)
    : file(std::move(file_in)),
      language(std::move(language_in)) {}

SpellCheckBDictLanguage::~SpellCheckBDictLanguage() = default;

void SpellCheckBDictLanguage::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file"), this->file,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::File>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "language"), this->language,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SpellCheckBDictLanguage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SpellCheckResult::SpellCheckResult()
    : decoration(),
      location(),
      length(),
      replacements() {}

SpellCheckResult::SpellCheckResult(
    ::SpellCheckResult::Decoration decoration_in,
    int32_t location_in,
    int32_t length_in,
    std::vector<::std::u16string> replacements_in)
    : decoration(std::move(decoration_in)),
      location(std::move(location_in)),
      length(std::move(length_in)),
      replacements(std::move(replacements_in)) {}

SpellCheckResult::~SpellCheckResult() = default;

void SpellCheckResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "decoration"), this->decoration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SpellCheckResult::Decoration>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "location"), this->location,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "length"), this->length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "replacements"), this->replacements,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SpellCheckResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char SpellChecker::Name_[] = "spellcheck.mojom.SpellChecker";

SpellChecker::IPCStableHashFunction SpellChecker::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SpellChecker>(message.name())) {
    case messages::SpellChecker::kInitialize: {
      return &SpellChecker::Initialize_Sym::IPCStableHash;
    }
    case messages::SpellChecker::kCustomDictionaryChanged: {
      return &SpellChecker::CustomDictionaryChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SpellChecker::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SpellChecker>(message.name())) {
      case messages::SpellChecker::kInitialize:
            return "Receive spellcheck::mojom::SpellChecker::Initialize";
      case messages::SpellChecker::kCustomDictionaryChanged:
            return "Receive spellcheck::mojom::SpellChecker::CustomDictionaryChanged";
    }
  } else {
    switch (static_cast<messages::SpellChecker>(message.name())) {
      case messages::SpellChecker::kInitialize:
            return "Receive reply spellcheck::mojom::SpellChecker::Initialize";
      case messages::SpellChecker::kCustomDictionaryChanged:
            return "Receive reply spellcheck::mojom::SpellChecker::CustomDictionaryChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SpellChecker::Initialize_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)spellcheck::mojom::SpellChecker::Initialize");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpellChecker::CustomDictionaryChanged_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)spellcheck::mojom::SpellChecker::CustomDictionaryChanged");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SpellCheckerProxy::SpellCheckerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpellCheckerProxy::Initialize(
    std::vector<SpellCheckBDictLanguagePtr> in_dictionaries, const std::vector<std::string>& in_custom_words, bool in_enable) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send spellcheck::mojom::SpellChecker::Initialize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dictionaries"), in_dictionaries,
                        "<value of type std::vector<SpellCheckBDictLanguagePtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("custom_words"), in_custom_words,
                        "<value of type const std::vector<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enable"), in_enable,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpellChecker::kInitialize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::spellcheck::mojom::internal::SpellChecker_Initialize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->dictionaries)::BaseType>
      dictionaries_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& dictionaries_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::spellcheck::mojom::SpellCheckBDictLanguageDataView>>(
      in_dictionaries, dictionaries_fragment, &dictionaries_validate_params);
  params->dictionaries.Set(
      dictionaries_fragment.is_null() ? nullptr : dictionaries_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->dictionaries.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null dictionaries in SpellChecker.Initialize request");
  mojo::internal::MessageFragment<
      typename decltype(params->custom_words)::BaseType>
      custom_words_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& custom_words_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_custom_words, custom_words_fragment, &custom_words_validate_params);
  params->custom_words.Set(
      custom_words_fragment.is_null() ? nullptr : custom_words_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->custom_words.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null custom_words in SpellChecker.Initialize request");
  params->enable = in_enable;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpellChecker::Name_);
  message.set_method_name("Initialize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpellCheckerProxy::CustomDictionaryChanged(
    const std::vector<std::string>& in_words_added, const std::vector<std::string>& in_words_removed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send spellcheck::mojom::SpellChecker::CustomDictionaryChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("words_added"), in_words_added,
                        "<value of type const std::vector<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("words_removed"), in_words_removed,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpellChecker::kCustomDictionaryChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::spellcheck::mojom::internal::SpellChecker_CustomDictionaryChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->words_added)::BaseType>
      words_added_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& words_added_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_words_added, words_added_fragment, &words_added_validate_params);
  params->words_added.Set(
      words_added_fragment.is_null() ? nullptr : words_added_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->words_added.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null words_added in SpellChecker.CustomDictionaryChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->words_removed)::BaseType>
      words_removed_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& words_removed_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_words_removed, words_removed_fragment, &words_removed_validate_params);
  params->words_removed.Set(
      words_removed_fragment.is_null() ? nullptr : words_removed_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->words_removed.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null words_removed in SpellChecker.CustomDictionaryChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpellChecker::Name_);
  message.set_method_name("CustomDictionaryChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SpellCheckerStubDispatch::Accept(
    SpellChecker* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SpellChecker>(message->header()->name)) {
    case messages::SpellChecker::kInitialize: {
      DCHECK(message->is_serialized());
      internal::SpellChecker_Initialize_Params_Data* params =
          reinterpret_cast<internal::SpellChecker_Initialize_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for SpellChecker.0
      bool success = true;
      std::vector<SpellCheckBDictLanguagePtr> p_dictionaries{};
      std::vector<std::string> p_custom_words{};
      bool p_enable{};
      SpellChecker_Initialize_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDictionaries(&p_dictionaries))
        success = false;
      if (success && !input_data_view.ReadCustomWords(&p_custom_words))
        success = false;
      if (success)
        p_enable = input_data_view.enable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpellChecker::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Initialize(        
        std::move(p_dictionaries), 
        std::move(p_custom_words), 
        std::move(p_enable));
      return true;
    }
    case messages::SpellChecker::kCustomDictionaryChanged: {
      DCHECK(message->is_serialized());
      internal::SpellChecker_CustomDictionaryChanged_Params_Data* params =
          reinterpret_cast<internal::SpellChecker_CustomDictionaryChanged_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for SpellChecker.1
      bool success = true;
      std::vector<std::string> p_words_added{};
      std::vector<std::string> p_words_removed{};
      SpellChecker_CustomDictionaryChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWordsAdded(&p_words_added))
        success = false;
      if (success && !input_data_view.ReadWordsRemoved(&p_words_removed))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpellChecker::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CustomDictionaryChanged(        
        std::move(p_words_added), 
        std::move(p_words_removed));
      return true;
    }
  }
  return false;
}

// static
bool SpellCheckerStubDispatch::AcceptWithResponder(
    SpellChecker* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SpellChecker>(message->header()->name)) {
    case messages::SpellChecker::kInitialize: {
      break;
    }
    case messages::SpellChecker::kCustomDictionaryChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSpellCheckerValidationInfo[] = {
    {base::to_underlying(messages::SpellChecker::kInitialize),
     { &internal::SpellChecker_Initialize_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::SpellChecker::kCustomDictionaryChanged),
     { &internal::SpellChecker_CustomDictionaryChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SpellCheckerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::spellcheck::mojom::SpellChecker::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSpellCheckerValidationInfo);
}

const char SpellCheckInitializationHost::Name_[] = "spellcheck.mojom.SpellCheckInitializationHost";

SpellCheckInitializationHost::IPCStableHashFunction SpellCheckInitializationHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SpellCheckInitializationHost>(message.name())) {
    case messages::SpellCheckInitializationHost::kRequestDictionary: {
      return &SpellCheckInitializationHost::RequestDictionary_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SpellCheckInitializationHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SpellCheckInitializationHost>(message.name())) {
      case messages::SpellCheckInitializationHost::kRequestDictionary:
            return "Receive spellcheck::mojom::SpellCheckInitializationHost::RequestDictionary";
    }
  } else {
    switch (static_cast<messages::SpellCheckInitializationHost>(message.name())) {
      case messages::SpellCheckInitializationHost::kRequestDictionary:
            return "Receive reply spellcheck::mojom::SpellCheckInitializationHost::RequestDictionary";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SpellCheckInitializationHost::RequestDictionary_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)spellcheck::mojom::SpellCheckInitializationHost::RequestDictionary");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SpellCheckInitializationHostProxy::SpellCheckInitializationHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpellCheckInitializationHostProxy::RequestDictionary(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send spellcheck::mojom::SpellCheckInitializationHost::RequestDictionary");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpellCheckInitializationHost::kRequestDictionary), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::spellcheck::mojom::internal::SpellCheckInitializationHost_RequestDictionary_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpellCheckInitializationHost::Name_);
  message.set_method_name("RequestDictionary");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SpellCheckInitializationHostStubDispatch::Accept(
    SpellCheckInitializationHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SpellCheckInitializationHost>(message->header()->name)) {
    case messages::SpellCheckInitializationHost::kRequestDictionary: {
      DCHECK(message->is_serialized());
      internal::SpellCheckInitializationHost_RequestDictionary_Params_Data* params =
          reinterpret_cast<internal::SpellCheckInitializationHost_RequestDictionary_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for SpellCheckInitializationHost.0
      bool success = true;
      SpellCheckInitializationHost_RequestDictionary_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpellCheckInitializationHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestDictionary(        );
      return true;
    }
  }
  return false;
}

// static
bool SpellCheckInitializationHostStubDispatch::AcceptWithResponder(
    SpellCheckInitializationHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SpellCheckInitializationHost>(message->header()->name)) {
    case messages::SpellCheckInitializationHost::kRequestDictionary: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSpellCheckInitializationHostValidationInfo[] = {
    {base::to_underlying(messages::SpellCheckInitializationHost::kRequestDictionary),
     { &internal::SpellCheckInitializationHost_RequestDictionary_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SpellCheckInitializationHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::spellcheck::mojom::SpellCheckInitializationHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSpellCheckInitializationHostValidationInfo);
}

const char SpellCheckHost::Name_[] = "spellcheck.mojom.SpellCheckHost";

SpellCheckHost::IPCStableHashFunction SpellCheckHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SpellCheckHost>(message.name())) {
    case messages::SpellCheckHost::kNotifyChecked: {
      return &SpellCheckHost::NotifyChecked_Sym::IPCStableHash;
    }
    case messages::SpellCheckHost::kCallSpellingService: {
      return &SpellCheckHost::CallSpellingService_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SpellCheckHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SpellCheckHost>(message.name())) {
      case messages::SpellCheckHost::kNotifyChecked:
            return "Receive spellcheck::mojom::SpellCheckHost::NotifyChecked";
      case messages::SpellCheckHost::kCallSpellingService:
            return "Receive spellcheck::mojom::SpellCheckHost::CallSpellingService";
    }
  } else {
    switch (static_cast<messages::SpellCheckHost>(message.name())) {
      case messages::SpellCheckHost::kNotifyChecked:
            return "Receive reply spellcheck::mojom::SpellCheckHost::NotifyChecked";
      case messages::SpellCheckHost::kCallSpellingService:
            return "Receive reply spellcheck::mojom::SpellCheckHost::CallSpellingService";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SpellCheckHost::NotifyChecked_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)spellcheck::mojom::SpellCheckHost::NotifyChecked");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpellCheckHost::CallSpellingService_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)spellcheck::mojom::SpellCheckHost::CallSpellingService");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SpellCheckHost_CallSpellingService_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SpellCheckHost_CallSpellingService_ForwardToCallback(
      SpellCheckHost::CallSpellingServiceCallback callback
      ) : callback_(std::move(callback)) {
  }

  SpellCheckHost_CallSpellingService_ForwardToCallback(const SpellCheckHost_CallSpellingService_ForwardToCallback&) = delete;
  SpellCheckHost_CallSpellingService_ForwardToCallback& operator=(const SpellCheckHost_CallSpellingService_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SpellCheckHost::CallSpellingServiceCallback callback_;
};

SpellCheckHostProxy::SpellCheckHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpellCheckHostProxy::NotifyChecked(
    const ::std::u16string& in_word, bool in_misspelled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send spellcheck::mojom::SpellCheckHost::NotifyChecked", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("word"), in_word,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("misspelled"), in_misspelled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpellCheckHost::kNotifyChecked), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::spellcheck::mojom::internal::SpellCheckHost_NotifyChecked_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->word)::BaseType> word_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_word, word_fragment);
  params->word.Set(
      word_fragment.is_null() ? nullptr : word_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->word.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null word in SpellCheckHost.NotifyChecked request");
  params->misspelled = in_misspelled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpellCheckHost::Name_);
  message.set_method_name("NotifyChecked");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpellCheckHostProxy::CallSpellingService(
    const ::std::u16string& in_text, CallSpellingServiceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send spellcheck::mojom::SpellCheckHost::CallSpellingService", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpellCheckHost::kCallSpellingService), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::spellcheck::mojom::internal::SpellCheckHost_CallSpellingService_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_text, text_fragment);
  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->text.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text in SpellCheckHost.CallSpellingService request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpellCheckHost::Name_);
  message.set_method_name("CallSpellingService");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SpellCheckHost_CallSpellingService_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class SpellCheckHost_CallSpellingService_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SpellCheckHost::CallSpellingServiceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SpellCheckHost_CallSpellingService_ProxyToResponder> proxy(
        new SpellCheckHost_CallSpellingService_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SpellCheckHost_CallSpellingService_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SpellCheckHost_CallSpellingService_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SpellCheckHost_CallSpellingService_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SpellCheckHost::CallSpellingServiceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const std::vector<::SpellCheckResult>& in_results);
};

bool SpellCheckHost_CallSpellingService_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SpellCheckHost_CallSpellingService_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SpellCheckHost_CallSpellingService_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for SpellCheckHost.1
  bool success = true;
  bool p_success{};
  std::vector<::SpellCheckResult> p_results{};
  SpellCheckHost_CallSpellingService_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadResults(&p_results))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SpellCheckHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_results));
  return true;
}

void SpellCheckHost_CallSpellingService_ProxyToResponder::Run(
    bool in_success, const std::vector<::SpellCheckResult>& in_results) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply spellcheck::mojom::SpellCheckHost::CallSpellingService", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("results"), in_results,
                        "<value of type const std::vector<::SpellCheckResult>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpellCheckHost::kCallSpellingService), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::spellcheck::mojom::internal::SpellCheckHost_CallSpellingService_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->results)::BaseType>
      results_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& results_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::spellcheck::mojom::SpellCheckResultDataView>>(
      in_results, results_fragment, &results_validate_params);
  params->results.Set(
      results_fragment.is_null() ? nullptr : results_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->results.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null results in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpellCheckHost::Name_);
  message.set_method_name("CallSpellingService");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SpellCheckHostStubDispatch::Accept(
    SpellCheckHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SpellCheckHost>(message->header()->name)) {
    case messages::SpellCheckHost::kNotifyChecked: {
      DCHECK(message->is_serialized());
      internal::SpellCheckHost_NotifyChecked_Params_Data* params =
          reinterpret_cast<internal::SpellCheckHost_NotifyChecked_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for SpellCheckHost.0
      bool success = true;
      ::std::u16string p_word{};
      bool p_misspelled{};
      SpellCheckHost_NotifyChecked_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWord(&p_word))
        success = false;
      if (success)
        p_misspelled = input_data_view.misspelled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpellCheckHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyChecked(        
        std::move(p_word), 
        std::move(p_misspelled));
      return true;
    }
    case messages::SpellCheckHost::kCallSpellingService: {
      break;
    }
  }
  return false;
}

// static
bool SpellCheckHostStubDispatch::AcceptWithResponder(
    SpellCheckHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SpellCheckHost>(message->header()->name)) {
    case messages::SpellCheckHost::kNotifyChecked: {
      break;
    }
    case messages::SpellCheckHost::kCallSpellingService: {
      internal::SpellCheckHost_CallSpellingService_Params_Data* params =
          reinterpret_cast<
              internal::SpellCheckHost_CallSpellingService_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for SpellCheckHost.1
      bool success = true;
      ::std::u16string p_text{};
      SpellCheckHost_CallSpellingService_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpellCheckHost::Name_, 1, false);
        return false;
      }
      SpellCheckHost::CallSpellingServiceCallback callback =
          SpellCheckHost_CallSpellingService_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CallSpellingService(        
        std::move(p_text), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSpellCheckHostValidationInfo[] = {
    {base::to_underlying(messages::SpellCheckHost::kNotifyChecked),
     { &internal::SpellCheckHost_NotifyChecked_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::SpellCheckHost::kCallSpellingService),
     { &internal::SpellCheckHost_CallSpellingService_Params_Data::Validate,
      &internal::SpellCheckHost_CallSpellingService_ResponseParams_Data::Validate}},
};

bool SpellCheckHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::spellcheck::mojom::SpellCheckHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSpellCheckHostValidationInfo);
}

bool SpellCheckHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::spellcheck::mojom::SpellCheckHost::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kSpellCheckHostValidationInfo);

}


}  // spellcheck::mojom


namespace mojo {


// static
bool StructTraits<::spellcheck::mojom::SpellCheckBDictLanguage::DataView, ::spellcheck::mojom::SpellCheckBDictLanguagePtr>::Read(
    ::spellcheck::mojom::SpellCheckBDictLanguage::DataView input,
    ::spellcheck::mojom::SpellCheckBDictLanguagePtr* output) {
  bool success = true;
  ::spellcheck::mojom::SpellCheckBDictLanguagePtr result(::spellcheck::mojom::SpellCheckBDictLanguage::New());
  
      if (success && !input.ReadFile(&result->file))
        success = false;
      if (success && !input.ReadLanguage(&result->language))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::spellcheck::mojom::SpellCheckResult::DataView, ::spellcheck::mojom::SpellCheckResultPtr>::Read(
    ::spellcheck::mojom::SpellCheckResult::DataView input,
    ::spellcheck::mojom::SpellCheckResultPtr* output) {
  bool success = true;
  ::spellcheck::mojom::SpellCheckResultPtr result(::spellcheck::mojom::SpellCheckResult::New());
  
      if (success && !input.ReadDecoration(&result->decoration))
        success = false;
      if (success)
        result->location = input.location();
      if (success)
        result->length = input.length();
      if (success && !input.ReadReplacements(&result->replacements))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace spellcheck::mojom {


void SpellCheckerInterceptorForTesting::Initialize(std::vector<SpellCheckBDictLanguagePtr> dictionaries, const std::vector<std::string>& custom_words, bool enable) {
  GetForwardingInterface()->Initialize(
    std::move(dictionaries)
    , 
    std::move(custom_words)
    , 
    std::move(enable)
    );
}
void SpellCheckerInterceptorForTesting::CustomDictionaryChanged(const std::vector<std::string>& words_added, const std::vector<std::string>& words_removed) {
  GetForwardingInterface()->CustomDictionaryChanged(
    std::move(words_added)
    , 
    std::move(words_removed)
    );
}
SpellCheckerAsyncWaiter::SpellCheckerAsyncWaiter(
    SpellChecker* proxy) : proxy_(proxy) {}

SpellCheckerAsyncWaiter::~SpellCheckerAsyncWaiter() = default;




void SpellCheckInitializationHostInterceptorForTesting::RequestDictionary() {
  GetForwardingInterface()->RequestDictionary();
}
SpellCheckInitializationHostAsyncWaiter::SpellCheckInitializationHostAsyncWaiter(
    SpellCheckInitializationHost* proxy) : proxy_(proxy) {}

SpellCheckInitializationHostAsyncWaiter::~SpellCheckInitializationHostAsyncWaiter() = default;




void SpellCheckHostInterceptorForTesting::NotifyChecked(const ::std::u16string& word, bool misspelled) {
  GetForwardingInterface()->NotifyChecked(
    std::move(word)
    , 
    std::move(misspelled)
    );
}
void SpellCheckHostInterceptorForTesting::CallSpellingService(const ::std::u16string& text, CallSpellingServiceCallback callback) {
  GetForwardingInterface()->CallSpellingService(
    std::move(text)
    , std::move(callback));
}
SpellCheckHostAsyncWaiter::SpellCheckHostAsyncWaiter(
    SpellCheckHost* proxy) : proxy_(proxy) {}

SpellCheckHostAsyncWaiter::~SpellCheckHostAsyncWaiter() = default;

void SpellCheckHostAsyncWaiter::CallSpellingService(
    const ::std::u16string& text, bool* out_success, std::vector<::SpellCheckResult>* out_results) {
  base::RunLoop loop;
  proxy_->CallSpellingService(
      std::move(text),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             std::vector<::SpellCheckResult>* out_results
,
             bool success,
             const std::vector<::SpellCheckResult>& results) {*out_success = std::move(success);*out_results = std::move(results);
            loop->Quit();
          },
          &loop,
          out_success,
          out_results));
  loop.Run();
}








}  // spellcheck::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif