// content/browser/process_internals/process_internals.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_PROCESS_INTERNALS_PROCESS_INTERNALS_MOJOM_SHARED_INTERNAL_H_
#define CONTENT_BROWSER_PROCESS_INTERNALS_PROCESS_INTERNALS_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "url/mojom/url.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace mojom {
namespace internal {
class ProcessCountInfo_Data;
class SiteInstanceInfo_Data;
class FrameInfo_Data;
class WebContentsInfo_Data;
class IsolatedOriginInfo_Data;

struct FrameInfo_Type_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)
class  ProcessCountInfo_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t renderer_process_limit;
  uint64_t renderer_process_count_total;
  uint64_t renderer_process_count_for_limit;

 private:
  friend class mojo::internal::MessageFragment<ProcessCountInfo_Data>;

  ProcessCountInfo_Data();
  ~ProcessCountInfo_Data() = delete;
};
static_assert(sizeof(ProcessCountInfo_Data) == 32,
              "Bad sizeof(ProcessCountInfo_Data)");
// Used by ProcessCountInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ProcessCountInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ProcessCountInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ProcessCountInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ProcessCountInfo_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ProcessCountInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  SiteInstanceInfo_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t id;
  int32_t site_instance_group_id;
  int32_t browsing_instance_id;
  uint8_t locked : 1;
  uint8_t requires_origin_keyed_process : 1;
  uint8_t is_sandbox_for_iframes : 1;
  uint8_t is_guest : 1;
  uint8_t is_pdf : 1;
  uint8_t pad7_[3];
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> site_url;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> process_lock_url;
  mojo::internal::Pointer<mojo::internal::String_Data> storage_partition;

 private:
  friend class mojo::internal::MessageFragment<SiteInstanceInfo_Data>;

  SiteInstanceInfo_Data();
  ~SiteInstanceInfo_Data() = delete;
};
static_assert(sizeof(SiteInstanceInfo_Data) == 48,
              "Bad sizeof(SiteInstanceInfo_Data)");
// Used by SiteInstanceInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SiteInstanceInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SiteInstanceInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SiteInstanceInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<SiteInstanceInfo_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SiteInstanceInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  FrameInfo_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t routing_id;
  int32_t agent_scheduling_group_id;
  int32_t process_id;
  int32_t type;
  mojo::internal::Pointer<internal::SiteInstanceInfo_Data> site_instance;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> last_committed_url;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::FrameInfo_Data>>> subframes;

 private:
  friend class mojo::internal::MessageFragment<FrameInfo_Data>;

  FrameInfo_Data();
  ~FrameInfo_Data() = delete;
};
static_assert(sizeof(FrameInfo_Data) == 48,
              "Bad sizeof(FrameInfo_Data)");
// Used by FrameInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct FrameInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  FrameInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~FrameInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<FrameInfo_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    FrameInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  WebContentsInfo_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> title;
  mojo::internal::Pointer<internal::FrameInfo_Data> root_frame;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::FrameInfo_Data>>> bfcached_root_frames;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::FrameInfo_Data>>> prerender_root_frames;

 private:
  friend class mojo::internal::MessageFragment<WebContentsInfo_Data>;

  WebContentsInfo_Data();
  ~WebContentsInfo_Data() = delete;
};
static_assert(sizeof(WebContentsInfo_Data) == 40,
              "Bad sizeof(WebContentsInfo_Data)");
// Used by WebContentsInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct WebContentsInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  WebContentsInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~WebContentsInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<WebContentsInfo_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    WebContentsInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  IsolatedOriginInfo_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> origin;
  mojo::internal::Pointer<mojo::internal::String_Data> source;

 private:
  friend class mojo::internal::MessageFragment<IsolatedOriginInfo_Data>;

  IsolatedOriginInfo_Data();
  ~IsolatedOriginInfo_Data() = delete;
};
static_assert(sizeof(IsolatedOriginInfo_Data) == 24,
              "Bad sizeof(IsolatedOriginInfo_Data)");
// Used by IsolatedOriginInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct IsolatedOriginInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  IsolatedOriginInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~IsolatedOriginInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<IsolatedOriginInfo_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    IsolatedOriginInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // mojom

#endif  // CONTENT_BROWSER_PROCESS_INTERNALS_PROCESS_INTERNALS_MOJOM_SHARED_INTERNAL_H_