// content/browser/process_internals/process_internals.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_PROCESS_INTERNALS_PROCESS_INTERNALS_MOJOM_SHARED_H_
#define CONTENT_BROWSER_PROCESS_INTERNALS_PROCESS_INTERNALS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/browser/process_internals/process_internals.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace mojom {
class ProcessCountInfoDataView;

class SiteInstanceInfoDataView;

class FrameInfoDataView;

class WebContentsInfoDataView;

class IsolatedOriginInfoDataView;



}  // mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::mojom::ProcessCountInfoDataView> {
  using Data = ::mojom::internal::ProcessCountInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojom::SiteInstanceInfoDataView> {
  using Data = ::mojom::internal::SiteInstanceInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojom::FrameInfoDataView> {
  using Data = ::mojom::internal::FrameInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojom::WebContentsInfoDataView> {
  using Data = ::mojom::internal::WebContentsInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojom::IsolatedOriginInfoDataView> {
  using Data = ::mojom::internal::IsolatedOriginInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace mojom {


enum class FrameInfo_Type : int32_t {
  
  kActive = 0,
  
  kBackForwardCache = 1,
  
  kPrerender = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, FrameInfo_Type value);
inline bool IsKnownEnumValue(FrameInfo_Type value) {
  return internal::FrameInfo_Type_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ProcessInternalsHandlerInterfaceBase {};

using ProcessInternalsHandlerPtrDataView =
    mojo::InterfacePtrDataView<ProcessInternalsHandlerInterfaceBase>;
using ProcessInternalsHandlerRequestDataView =
    mojo::InterfaceRequestDataView<ProcessInternalsHandlerInterfaceBase>;
using ProcessInternalsHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ProcessInternalsHandlerInterfaceBase>;
using ProcessInternalsHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ProcessInternalsHandlerInterfaceBase>;


class ProcessCountInfoDataView {
 public:
  ProcessCountInfoDataView() = default;

  ProcessCountInfoDataView(
      internal::ProcessCountInfo_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t renderer_process_limit() const {
    return data_->renderer_process_limit;
  }
  uint64_t renderer_process_count_total() const {
    return data_->renderer_process_count_total;
  }
  uint64_t renderer_process_count_for_limit() const {
    return data_->renderer_process_count_for_limit;
  }
 private:
  internal::ProcessCountInfo_Data* data_ = nullptr;
};


class SiteInstanceInfoDataView {
 public:
  SiteInstanceInfoDataView() = default;

  SiteInstanceInfoDataView(
      internal::SiteInstanceInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
  int32_t site_instance_group_id() const {
    return data_->site_instance_group_id;
  }
  int32_t browsing_instance_id() const {
    return data_->browsing_instance_id;
  }
  bool locked() const {
    return data_->locked;
  }
  inline void GetSiteUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSiteUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `site_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSiteUrl` instead "
    "of `ReadSiteUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->site_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetProcessLockUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProcessLockUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `process_lock_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadProcessLockUrl` instead "
    "of `ReadProcessLockUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->process_lock_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool requires_origin_keyed_process() const {
    return data_->requires_origin_keyed_process;
  }
  bool is_sandbox_for_iframes() const {
    return data_->is_sandbox_for_iframes;
  }
  bool is_guest() const {
    return data_->is_guest;
  }
  bool is_pdf() const {
    return data_->is_pdf;
  }
  inline void GetStoragePartitionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStoragePartition(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `storage_partition` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadStoragePartition` instead "
    "of `ReadStoragePartition if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->storage_partition.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::SiteInstanceInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FrameInfoDataView {
 public:
  FrameInfoDataView() = default;

  FrameInfoDataView(
      internal::FrameInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t routing_id() const {
    return data_->routing_id;
  }
  int32_t agent_scheduling_group_id() const {
    return data_->agent_scheduling_group_id;
  }
  int32_t process_id() const {
    return data_->process_id;
  }
  inline void GetSiteInstanceDataView(
      SiteInstanceInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSiteInstance(UserType* output) {
    
    auto* pointer = data_->site_instance.Get();
    return mojo::internal::Deserialize<::mojom::SiteInstanceInfoDataView>(
        pointer, output, message_);
  }
  inline void GetLastCommittedUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastCommittedUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `last_committed_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLastCommittedUrl` instead "
    "of `ReadLastCommittedUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->last_committed_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetSubframesDataView(
      mojo::ArrayDataView<FrameInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubframes(UserType* output) {
    
    auto* pointer = data_->subframes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojom::FrameInfoDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::mojom::FrameInfo_Type>(
        data_value, output);
  }
  FrameInfo_Type type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojom::FrameInfo_Type>(data_->type));
  }
 private:
  internal::FrameInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebContentsInfoDataView {
 public:
  WebContentsInfoDataView() = default;

  WebContentsInfoDataView(
      internal::WebContentsInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetRootFrameDataView(
      FrameInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRootFrame(UserType* output) {
    
    auto* pointer = data_->root_frame.Get();
    return mojo::internal::Deserialize<::mojom::FrameInfoDataView>(
        pointer, output, message_);
  }
  inline void GetBfcachedRootFramesDataView(
      mojo::ArrayDataView<FrameInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBfcachedRootFrames(UserType* output) {
    
    auto* pointer = data_->bfcached_root_frames.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojom::FrameInfoDataView>>(
        pointer, output, message_);
  }
  inline void GetPrerenderRootFramesDataView(
      mojo::ArrayDataView<FrameInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrerenderRootFrames(UserType* output) {
    
    auto* pointer = data_->prerender_root_frames.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojom::FrameInfoDataView>>(
        pointer, output, message_);
  }
 private:
  internal::WebContentsInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class IsolatedOriginInfoDataView {
 public:
  IsolatedOriginInfoDataView() = default;

  IsolatedOriginInfoDataView(
      internal::IsolatedOriginInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSourceDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSource(UserType* output) {
    
    auto* pointer = data_->source.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::IsolatedOriginInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // mojom

namespace std {

template <>
struct hash<::mojom::FrameInfo_Type>
    : public mojo::internal::EnumHashImpl<::mojom::FrameInfo_Type> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojom::FrameInfo_Type, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::mojom::FrameInfo_Type, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::mojom::FrameInfo_Type>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojom::ProcessCountInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::ProcessCountInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojom::internal::ProcessCountInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->renderer_process_limit = Traits::renderer_process_limit(input);
    fragment->renderer_process_count_total = Traits::renderer_process_count_total(input);
    fragment->renderer_process_count_for_limit = Traits::renderer_process_count_for_limit(input);
  }

  static bool Deserialize(::mojom::internal::ProcessCountInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojom::ProcessCountInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojom::SiteInstanceInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::SiteInstanceInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojom::internal::SiteInstanceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->id = Traits::id(input);
    fragment->site_instance_group_id = Traits::site_instance_group_id(input);
    fragment->browsing_instance_id = Traits::browsing_instance_id(input);
    fragment->locked = Traits::locked(input);
    decltype(Traits::site_url(input)) in_site_url = Traits::site_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->site_url)::BaseType> site_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_site_url, site_url_fragment);
    fragment->site_url.Set(
        site_url_fragment.is_null() ? nullptr : site_url_fragment.data());
    decltype(Traits::process_lock_url(input)) in_process_lock_url = Traits::process_lock_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->process_lock_url)::BaseType> process_lock_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_process_lock_url, process_lock_url_fragment);
    fragment->process_lock_url.Set(
        process_lock_url_fragment.is_null() ? nullptr : process_lock_url_fragment.data());
    fragment->requires_origin_keyed_process = Traits::requires_origin_keyed_process(input);
    fragment->is_sandbox_for_iframes = Traits::is_sandbox_for_iframes(input);
    fragment->is_guest = Traits::is_guest(input);
    fragment->is_pdf = Traits::is_pdf(input);
    decltype(Traits::storage_partition(input)) in_storage_partition = Traits::storage_partition(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->storage_partition)::BaseType> storage_partition_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_storage_partition, storage_partition_fragment);
    fragment->storage_partition.Set(
        storage_partition_fragment.is_null() ? nullptr : storage_partition_fragment.data());
  }

  static bool Deserialize(::mojom::internal::SiteInstanceInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojom::SiteInstanceInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojom::FrameInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::FrameInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojom::internal::FrameInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->routing_id = Traits::routing_id(input);
    fragment->agent_scheduling_group_id = Traits::agent_scheduling_group_id(input);
    fragment->process_id = Traits::process_id(input);
    decltype(Traits::site_instance(input)) in_site_instance = Traits::site_instance(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->site_instance)::BaseType> site_instance_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojom::SiteInstanceInfoDataView>(
        in_site_instance, site_instance_fragment);
    fragment->site_instance.Set(
        site_instance_fragment.is_null() ? nullptr : site_instance_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->site_instance.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null site_instance in FrameInfo struct");
    decltype(Traits::last_committed_url(input)) in_last_committed_url = Traits::last_committed_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_committed_url)::BaseType> last_committed_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_last_committed_url, last_committed_url_fragment);
    fragment->last_committed_url.Set(
        last_committed_url_fragment.is_null() ? nullptr : last_committed_url_fragment.data());
    decltype(Traits::subframes(input)) in_subframes = Traits::subframes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->subframes)::BaseType>
        subframes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& subframes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::mojom::FrameInfoDataView>>(
        in_subframes, subframes_fragment, &subframes_validate_params);
    fragment->subframes.Set(
        subframes_fragment.is_null() ? nullptr : subframes_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->subframes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null subframes in FrameInfo struct");
    mojo::internal::Serialize<::mojom::FrameInfo_Type>(
        Traits::type(input), &fragment->type);
  }

  static bool Deserialize(::mojom::internal::FrameInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojom::FrameInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojom::WebContentsInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::WebContentsInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojom::internal::WebContentsInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_title, title_fragment);
    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->title.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in WebContentsInfo struct");
    decltype(Traits::root_frame(input)) in_root_frame = Traits::root_frame(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->root_frame)::BaseType> root_frame_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojom::FrameInfoDataView>(
        in_root_frame, root_frame_fragment);
    fragment->root_frame.Set(
        root_frame_fragment.is_null() ? nullptr : root_frame_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->root_frame.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null root_frame in WebContentsInfo struct");
    decltype(Traits::bfcached_root_frames(input)) in_bfcached_root_frames = Traits::bfcached_root_frames(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bfcached_root_frames)::BaseType>
        bfcached_root_frames_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& bfcached_root_frames_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::mojom::FrameInfoDataView>>(
        in_bfcached_root_frames, bfcached_root_frames_fragment, &bfcached_root_frames_validate_params);
    fragment->bfcached_root_frames.Set(
        bfcached_root_frames_fragment.is_null() ? nullptr : bfcached_root_frames_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->bfcached_root_frames.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bfcached_root_frames in WebContentsInfo struct");
    decltype(Traits::prerender_root_frames(input)) in_prerender_root_frames = Traits::prerender_root_frames(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->prerender_root_frames)::BaseType>
        prerender_root_frames_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& prerender_root_frames_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::mojom::FrameInfoDataView>>(
        in_prerender_root_frames, prerender_root_frames_fragment, &prerender_root_frames_validate_params);
    fragment->prerender_root_frames.Set(
        prerender_root_frames_fragment.is_null() ? nullptr : prerender_root_frames_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->prerender_root_frames.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null prerender_root_frames in WebContentsInfo struct");
  }

  static bool Deserialize(::mojom::internal::WebContentsInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojom::WebContentsInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojom::IsolatedOriginInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::IsolatedOriginInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojom::internal::IsolatedOriginInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin)::BaseType> origin_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_origin, origin_fragment);
    fragment->origin.Set(
        origin_fragment.is_null() ? nullptr : origin_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in IsolatedOriginInfo struct");
    decltype(Traits::source(input)) in_source = Traits::source(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->source)::BaseType> source_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_source, source_fragment);
    fragment->source.Set(
        source_fragment.is_null() ? nullptr : source_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->source.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null source in IsolatedOriginInfo struct");
  }

  static bool Deserialize(::mojom::internal::IsolatedOriginInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojom::IsolatedOriginInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace mojom {



inline void SiteInstanceInfoDataView::GetSiteUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->site_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void SiteInstanceInfoDataView::GetProcessLockUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->process_lock_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void SiteInstanceInfoDataView::GetStoragePartitionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->storage_partition.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void FrameInfoDataView::GetSiteInstanceDataView(
    SiteInstanceInfoDataView* output) {
  auto pointer = data_->site_instance.Get();
  *output = SiteInstanceInfoDataView(pointer, message_);
}
inline void FrameInfoDataView::GetLastCommittedUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->last_committed_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void FrameInfoDataView::GetSubframesDataView(
    mojo::ArrayDataView<FrameInfoDataView>* output) {
  auto pointer = data_->subframes.Get();
  *output = mojo::ArrayDataView<FrameInfoDataView>(pointer, message_);
}


inline void WebContentsInfoDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebContentsInfoDataView::GetRootFrameDataView(
    FrameInfoDataView* output) {
  auto pointer = data_->root_frame.Get();
  *output = FrameInfoDataView(pointer, message_);
}
inline void WebContentsInfoDataView::GetBfcachedRootFramesDataView(
    mojo::ArrayDataView<FrameInfoDataView>* output) {
  auto pointer = data_->bfcached_root_frames.Get();
  *output = mojo::ArrayDataView<FrameInfoDataView>(pointer, message_);
}
inline void WebContentsInfoDataView::GetPrerenderRootFramesDataView(
    mojo::ArrayDataView<FrameInfoDataView>* output) {
  auto pointer = data_->prerender_root_frames.Get();
  *output = mojo::ArrayDataView<FrameInfoDataView>(pointer, message_);
}


inline void IsolatedOriginInfoDataView::GetOriginDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->origin.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void IsolatedOriginInfoDataView::GetSourceDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->source.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::mojom::FrameInfo_Type> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::mojom::FrameInfo_Type value);
};

} // namespace perfetto

#endif  // CONTENT_BROWSER_PROCESS_INTERNALS_PROCESS_INTERNALS_MOJOM_SHARED_H_