// content/common/media/media_log_records.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/media/media_log_records.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/media/media_log_records.mojom-params-data.h"
#include "content/common/media/media_log_records.mojom-shared-message-ids.h"

#include "content/common/media/media_log_records.mojom-import-headers.h"
#include "content/common/media/media_log_records.mojom-test-utils.h"


namespace content::mojom {
const char MediaInternalLogRecords::Name_[] = "content.mojom.MediaInternalLogRecords";

MediaInternalLogRecords::IPCStableHashFunction MediaInternalLogRecords::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaInternalLogRecords>(message.name())) {
    case messages::MediaInternalLogRecords::kLog: {
      return &MediaInternalLogRecords::Log_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaInternalLogRecords::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaInternalLogRecords>(message.name())) {
      case messages::MediaInternalLogRecords::kLog:
            return "Receive content::mojom::MediaInternalLogRecords::Log";
    }
  } else {
    switch (static_cast<messages::MediaInternalLogRecords>(message.name())) {
      case messages::MediaInternalLogRecords::kLog:
            return "Receive reply content::mojom::MediaInternalLogRecords::Log";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaInternalLogRecords::Log_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::MediaInternalLogRecords::Log");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MediaInternalLogRecordsProxy::MediaInternalLogRecordsProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaInternalLogRecordsProxy::Log(
    const std::vector<::media::MediaLogRecord>& in_events) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::MediaInternalLogRecords::Log", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("events"), in_events,
                        "<value of type const std::vector<::media::MediaLogRecord>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaInternalLogRecords::kLog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::MediaInternalLogRecords_Log_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->events)::BaseType>
      events_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& events_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::MediaLogRecordDataView>>(
      in_events, events_fragment, &events_validate_params);
  params->events.Set(
      events_fragment.is_null() ? nullptr : events_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->events.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null events in MediaInternalLogRecords.Log request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaInternalLogRecords::Name_);
  message.set_method_name("Log");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MediaInternalLogRecordsStubDispatch::Accept(
    MediaInternalLogRecords* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaInternalLogRecords>(message->header()->name)) {
    case messages::MediaInternalLogRecords::kLog: {
      DCHECK(message->is_serialized());
      internal::MediaInternalLogRecords_Log_Params_Data* params =
          reinterpret_cast<internal::MediaInternalLogRecords_Log_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for MediaInternalLogRecords.0
      bool success = true;
      std::vector<::media::MediaLogRecord> p_events{};
      MediaInternalLogRecords_Log_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvents(&p_events))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaInternalLogRecords::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Log(        
        std::move(p_events));
      return true;
    }
  }
  return false;
}

// static
bool MediaInternalLogRecordsStubDispatch::AcceptWithResponder(
    MediaInternalLogRecords* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaInternalLogRecords>(message->header()->name)) {
    case messages::MediaInternalLogRecords::kLog: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kMediaInternalLogRecordsValidationInfo[] = {
    {base::to_underlying(messages::MediaInternalLogRecords::kLog),
     { &internal::MediaInternalLogRecords_Log_Params_Data::Validate,
      nullptr /* no response */}},
};

bool MediaInternalLogRecordsRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::MediaInternalLogRecords::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kMediaInternalLogRecordsValidationInfo);
}



}  // content::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace content::mojom {


void MediaInternalLogRecordsInterceptorForTesting::Log(const std::vector<::media::MediaLogRecord>& events) {
  GetForwardingInterface()->Log(
    std::move(events)
    );
}
MediaInternalLogRecordsAsyncWaiter::MediaInternalLogRecordsAsyncWaiter(
    MediaInternalLogRecords* proxy) : proxy_(proxy) {}

MediaInternalLogRecordsAsyncWaiter::~MediaInternalLogRecordsAsyncWaiter() = default;






}  // content::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif