// content/common/renderer.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/renderer.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/renderer.mojom-params-data.h"
#include "content/common/renderer.mojom-shared-message-ids.h"

#include "content/common/renderer.mojom-import-headers.h"
#include "content/common/renderer.mojom-test-utils.h"
#include "content/common/content_param_traits_macros.h"
#include "content/public/common/common_param_traits.h"
#include "services/network/public/cpp/p2p_param_traits.h"


namespace content::mojom {
UpdateScrollbarThemeParams::UpdateScrollbarThemeParams()
    : has_initial_button_delay(),
      initial_button_delay(),
      has_autoscroll_button_delay(),
      autoscroll_button_delay(),
      jump_on_track_click(),
      preferred_scroller_style(),
      redraw(),
      scroll_view_rubber_banding() {}

UpdateScrollbarThemeParams::UpdateScrollbarThemeParams(
    bool has_initial_button_delay_in,
    float initial_button_delay_in,
    bool has_autoscroll_button_delay_in,
    float autoscroll_button_delay_in,
    bool jump_on_track_click_in,
    ::content::mojom::ScrollerStyle preferred_scroller_style_in,
    bool redraw_in,
    bool scroll_view_rubber_banding_in)
    : has_initial_button_delay(std::move(has_initial_button_delay_in)),
      initial_button_delay(std::move(initial_button_delay_in)),
      has_autoscroll_button_delay(std::move(has_autoscroll_button_delay_in)),
      autoscroll_button_delay(std::move(autoscroll_button_delay_in)),
      jump_on_track_click(std::move(jump_on_track_click_in)),
      preferred_scroller_style(std::move(preferred_scroller_style_in)),
      redraw(std::move(redraw_in)),
      scroll_view_rubber_banding(std::move(scroll_view_rubber_banding_in)) {}

UpdateScrollbarThemeParams::~UpdateScrollbarThemeParams() = default;
size_t UpdateScrollbarThemeParams::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->has_initial_button_delay);
  seed = mojo::internal::Hash(seed, this->initial_button_delay);
  seed = mojo::internal::Hash(seed, this->has_autoscroll_button_delay);
  seed = mojo::internal::Hash(seed, this->autoscroll_button_delay);
  seed = mojo::internal::Hash(seed, this->jump_on_track_click);
  seed = mojo::internal::Hash(seed, this->preferred_scroller_style);
  seed = mojo::internal::Hash(seed, this->redraw);
  seed = mojo::internal::Hash(seed, this->scroll_view_rubber_banding);
  return seed;
}

void UpdateScrollbarThemeParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_initial_button_delay"), this->has_initial_button_delay,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initial_button_delay"), this->initial_button_delay,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_autoscroll_button_delay"), this->has_autoscroll_button_delay,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "autoscroll_button_delay"), this->autoscroll_button_delay,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "jump_on_track_click"), this->jump_on_track_click,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "preferred_scroller_style"), this->preferred_scroller_style,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::content::mojom::ScrollerStyle>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "redraw"), this->redraw,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_view_rubber_banding"), this->scroll_view_rubber_banding,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool UpdateScrollbarThemeParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
UpdateSystemColorInfoParams::UpdateSystemColorInfoParams()
    : accent_color() {}

UpdateSystemColorInfoParams::UpdateSystemColorInfoParams(
    std::optional<uint32_t> accent_color_in)
    : accent_color(std::move(accent_color_in)) {}

UpdateSystemColorInfoParams::~UpdateSystemColorInfoParams() = default;

void UpdateSystemColorInfoParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accent_color"), this->accent_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool UpdateSystemColorInfoParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char Renderer::Name_[] = "content.mojom.Renderer";

Renderer::IPCStableHashFunction Renderer::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Renderer>(message.name())) {
    case messages::Renderer::kCreateAgentSchedulingGroup: {
      return &Renderer::CreateAgentSchedulingGroup_Sym::IPCStableHash;
    }
    case messages::Renderer::kCreateAssociatedAgentSchedulingGroup: {
      return &Renderer::CreateAssociatedAgentSchedulingGroup_Sym::IPCStableHash;
    }
    case messages::Renderer::kTransferSharedLastForegroundTime: {
      return &Renderer::TransferSharedLastForegroundTime_Sym::IPCStableHash;
    }
    case messages::Renderer::kOnNetworkConnectionChanged: {
      return &Renderer::OnNetworkConnectionChanged_Sym::IPCStableHash;
    }
    case messages::Renderer::kOnNetworkQualityChanged: {
      return &Renderer::OnNetworkQualityChanged_Sym::IPCStableHash;
    }
    case messages::Renderer::kSetWebKitSharedTimersSuspended: {
      return &Renderer::SetWebKitSharedTimersSuspended_Sym::IPCStableHash;
    }
    case messages::Renderer::kUpdateScrollbarTheme: {
      return &Renderer::UpdateScrollbarTheme_Sym::IPCStableHash;
    }
    case messages::Renderer::kOnSystemColorsChanged: {
      return &Renderer::OnSystemColorsChanged_Sym::IPCStableHash;
    }
    case messages::Renderer::kUpdateSystemColorInfo: {
      return &Renderer::UpdateSystemColorInfo_Sym::IPCStableHash;
    }
    case messages::Renderer::kPurgePluginListCache: {
      return &Renderer::PurgePluginListCache_Sym::IPCStableHash;
    }
    case messages::Renderer::kPurgeResourceCache: {
      return &Renderer::PurgeResourceCache_Sym::IPCStableHash;
    }
    case messages::Renderer::kSetProcessState: {
      return &Renderer::SetProcessState_Sym::IPCStableHash;
    }
    case messages::Renderer::kSetIsLockedToSite: {
      return &Renderer::SetIsLockedToSite_Sym::IPCStableHash;
    }
    case messages::Renderer::kSetIsCrossOriginIsolated: {
      return &Renderer::SetIsCrossOriginIsolated_Sym::IPCStableHash;
    }
    case messages::Renderer::kSetIsWebSecurityDisabled: {
      return &Renderer::SetIsWebSecurityDisabled_Sym::IPCStableHash;
    }
    case messages::Renderer::kSetIsIsolatedContext: {
      return &Renderer::SetIsIsolatedContext_Sym::IPCStableHash;
    }
    case messages::Renderer::kInitializeRenderer: {
      return &Renderer::InitializeRenderer_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Renderer::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Renderer>(message.name())) {
      case messages::Renderer::kCreateAgentSchedulingGroup:
            return "Receive content::mojom::Renderer::CreateAgentSchedulingGroup";
      case messages::Renderer::kCreateAssociatedAgentSchedulingGroup:
            return "Receive content::mojom::Renderer::CreateAssociatedAgentSchedulingGroup";
      case messages::Renderer::kTransferSharedLastForegroundTime:
            return "Receive content::mojom::Renderer::TransferSharedLastForegroundTime";
      case messages::Renderer::kOnNetworkConnectionChanged:
            return "Receive content::mojom::Renderer::OnNetworkConnectionChanged";
      case messages::Renderer::kOnNetworkQualityChanged:
            return "Receive content::mojom::Renderer::OnNetworkQualityChanged";
      case messages::Renderer::kSetWebKitSharedTimersSuspended:
            return "Receive content::mojom::Renderer::SetWebKitSharedTimersSuspended";
      case messages::Renderer::kUpdateScrollbarTheme:
            return "Receive content::mojom::Renderer::UpdateScrollbarTheme";
      case messages::Renderer::kOnSystemColorsChanged:
            return "Receive content::mojom::Renderer::OnSystemColorsChanged";
      case messages::Renderer::kUpdateSystemColorInfo:
            return "Receive content::mojom::Renderer::UpdateSystemColorInfo";
      case messages::Renderer::kPurgePluginListCache:
            return "Receive content::mojom::Renderer::PurgePluginListCache";
      case messages::Renderer::kPurgeResourceCache:
            return "Receive content::mojom::Renderer::PurgeResourceCache";
      case messages::Renderer::kSetProcessState:
            return "Receive content::mojom::Renderer::SetProcessState";
      case messages::Renderer::kSetIsLockedToSite:
            return "Receive content::mojom::Renderer::SetIsLockedToSite";
      case messages::Renderer::kSetIsCrossOriginIsolated:
            return "Receive content::mojom::Renderer::SetIsCrossOriginIsolated";
      case messages::Renderer::kSetIsWebSecurityDisabled:
            return "Receive content::mojom::Renderer::SetIsWebSecurityDisabled";
      case messages::Renderer::kSetIsIsolatedContext:
            return "Receive content::mojom::Renderer::SetIsIsolatedContext";
      case messages::Renderer::kInitializeRenderer:
            return "Receive content::mojom::Renderer::InitializeRenderer";
    }
  } else {
    switch (static_cast<messages::Renderer>(message.name())) {
      case messages::Renderer::kCreateAgentSchedulingGroup:
            return "Receive reply content::mojom::Renderer::CreateAgentSchedulingGroup";
      case messages::Renderer::kCreateAssociatedAgentSchedulingGroup:
            return "Receive reply content::mojom::Renderer::CreateAssociatedAgentSchedulingGroup";
      case messages::Renderer::kTransferSharedLastForegroundTime:
            return "Receive reply content::mojom::Renderer::TransferSharedLastForegroundTime";
      case messages::Renderer::kOnNetworkConnectionChanged:
            return "Receive reply content::mojom::Renderer::OnNetworkConnectionChanged";
      case messages::Renderer::kOnNetworkQualityChanged:
            return "Receive reply content::mojom::Renderer::OnNetworkQualityChanged";
      case messages::Renderer::kSetWebKitSharedTimersSuspended:
            return "Receive reply content::mojom::Renderer::SetWebKitSharedTimersSuspended";
      case messages::Renderer::kUpdateScrollbarTheme:
            return "Receive reply content::mojom::Renderer::UpdateScrollbarTheme";
      case messages::Renderer::kOnSystemColorsChanged:
            return "Receive reply content::mojom::Renderer::OnSystemColorsChanged";
      case messages::Renderer::kUpdateSystemColorInfo:
            return "Receive reply content::mojom::Renderer::UpdateSystemColorInfo";
      case messages::Renderer::kPurgePluginListCache:
            return "Receive reply content::mojom::Renderer::PurgePluginListCache";
      case messages::Renderer::kPurgeResourceCache:
            return "Receive reply content::mojom::Renderer::PurgeResourceCache";
      case messages::Renderer::kSetProcessState:
            return "Receive reply content::mojom::Renderer::SetProcessState";
      case messages::Renderer::kSetIsLockedToSite:
            return "Receive reply content::mojom::Renderer::SetIsLockedToSite";
      case messages::Renderer::kSetIsCrossOriginIsolated:
            return "Receive reply content::mojom::Renderer::SetIsCrossOriginIsolated";
      case messages::Renderer::kSetIsWebSecurityDisabled:
            return "Receive reply content::mojom::Renderer::SetIsWebSecurityDisabled";
      case messages::Renderer::kSetIsIsolatedContext:
            return "Receive reply content::mojom::Renderer::SetIsIsolatedContext";
      case messages::Renderer::kInitializeRenderer:
            return "Receive reply content::mojom::Renderer::InitializeRenderer";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Renderer::CreateAgentSchedulingGroup_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::Renderer::CreateAgentSchedulingGroup");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::CreateAssociatedAgentSchedulingGroup_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::Renderer::CreateAssociatedAgentSchedulingGroup");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::TransferSharedLastForegroundTime_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::Renderer::TransferSharedLastForegroundTime");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::OnNetworkConnectionChanged_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::Renderer::OnNetworkConnectionChanged");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::OnNetworkQualityChanged_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::Renderer::OnNetworkQualityChanged");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::SetWebKitSharedTimersSuspended_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::Renderer::SetWebKitSharedTimersSuspended");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::UpdateScrollbarTheme_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::Renderer::UpdateScrollbarTheme");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::OnSystemColorsChanged_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::Renderer::OnSystemColorsChanged");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::UpdateSystemColorInfo_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::Renderer::UpdateSystemColorInfo");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::PurgePluginListCache_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::Renderer::PurgePluginListCache");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::PurgeResourceCache_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::Renderer::PurgeResourceCache");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::SetProcessState_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::Renderer::SetProcessState");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::SetIsLockedToSite_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::Renderer::SetIsLockedToSite");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::SetIsCrossOriginIsolated_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::Renderer::SetIsCrossOriginIsolated");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::SetIsWebSecurityDisabled_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::Renderer::SetIsWebSecurityDisabled");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::SetIsIsolatedContext_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::Renderer::SetIsIsolatedContext");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::InitializeRenderer_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::Renderer::InitializeRenderer");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class Renderer_PurgeResourceCache_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Renderer_PurgeResourceCache_ForwardToCallback(
      Renderer::PurgeResourceCacheCallback callback
      ) : callback_(std::move(callback)) {
  }

  Renderer_PurgeResourceCache_ForwardToCallback(const Renderer_PurgeResourceCache_ForwardToCallback&) = delete;
  Renderer_PurgeResourceCache_ForwardToCallback& operator=(const Renderer_PurgeResourceCache_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Renderer::PurgeResourceCacheCallback callback_;
};

RendererProxy::RendererProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RendererProxy::CreateAgentSchedulingGroup(
    ::mojo::PendingReceiver<::IPC::mojom::ChannelBootstrap> in_bootstrap) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::Renderer::CreateAgentSchedulingGroup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bootstrap"), in_bootstrap,
                        "<value of type ::mojo::PendingReceiver<::IPC::mojom::ChannelBootstrap>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kCreateAgentSchedulingGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_CreateAgentSchedulingGroup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::IPC::mojom::ChannelBootstrapInterfaceBase>>(
      in_bootstrap, &params->bootstrap, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->bootstrap),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid bootstrap in Renderer.CreateAgentSchedulingGroup request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("CreateAgentSchedulingGroup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::CreateAssociatedAgentSchedulingGroup(
    ::mojo::PendingAssociatedReceiver<::content::mojom::AgentSchedulingGroup> in_agent_scheduling_group) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::Renderer::CreateAssociatedAgentSchedulingGroup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("agent_scheduling_group"), in_agent_scheduling_group,
                        "<value of type ::mojo::PendingAssociatedReceiver<::content::mojom::AgentSchedulingGroup>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kCreateAssociatedAgentSchedulingGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::content::mojom::AgentSchedulingGroupAssociatedRequestDataView>(
      in_agent_scheduling_group, &params->agent_scheduling_group, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->agent_scheduling_group),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid agent_scheduling_group in Renderer.CreateAssociatedAgentSchedulingGroup request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("CreateAssociatedAgentSchedulingGroup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::TransferSharedLastForegroundTime(
    ::base::ReadOnlySharedMemoryRegion in_last_foreground_time_region) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::Renderer::TransferSharedLastForegroundTime", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("last_foreground_time_region"), in_last_foreground_time_region,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kTransferSharedLastForegroundTime), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_TransferSharedLastForegroundTime_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->last_foreground_time_region)::BaseType> last_foreground_time_region_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
      in_last_foreground_time_region, last_foreground_time_region_fragment);
  params->last_foreground_time_region.Set(
      last_foreground_time_region_fragment.is_null() ? nullptr : last_foreground_time_region_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->last_foreground_time_region.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_foreground_time_region in Renderer.TransferSharedLastForegroundTime request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("TransferSharedLastForegroundTime");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::OnNetworkConnectionChanged(
    ::net::NetworkChangeNotifier::ConnectionType in_connection_type, double in_max_bandwidth_mbps) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::Renderer::OnNetworkConnectionChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("connection_type"), in_connection_type,
                        "<value of type ::net::NetworkChangeNotifier::ConnectionType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_bandwidth_mbps"), in_max_bandwidth_mbps,
                        "<value of type double>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kOnNetworkConnectionChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_OnNetworkConnectionChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::content::mojom::NetworkConnectionType>(
      in_connection_type, &params->connection_type);
  params->max_bandwidth_mbps = in_max_bandwidth_mbps;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("OnNetworkConnectionChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::OnNetworkQualityChanged(
    ::net::EffectiveConnectionType in_effective_connection_type, ::base::TimeDelta in_http_rtt, ::base::TimeDelta in_transport_rtt, double in_bandwidth_kbps) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::Renderer::OnNetworkQualityChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("effective_connection_type"), in_effective_connection_type,
                        "<value of type ::net::EffectiveConnectionType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("http_rtt"), in_http_rtt,
                        "<value of type ::base::TimeDelta>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transport_rtt"), in_transport_rtt,
                        "<value of type ::base::TimeDelta>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bandwidth_kbps"), in_bandwidth_kbps,
                        "<value of type double>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kOnNetworkQualityChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_OnNetworkQualityChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::network::mojom::EffectiveConnectionType>(
      in_effective_connection_type, &params->effective_connection_type);
  mojo::internal::MessageFragment<
      typename decltype(params->http_rtt)::BaseType> http_rtt_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_http_rtt, http_rtt_fragment);
  params->http_rtt.Set(
      http_rtt_fragment.is_null() ? nullptr : http_rtt_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->http_rtt.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null http_rtt in Renderer.OnNetworkQualityChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->transport_rtt)::BaseType> transport_rtt_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_transport_rtt, transport_rtt_fragment);
  params->transport_rtt.Set(
      transport_rtt_fragment.is_null() ? nullptr : transport_rtt_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->transport_rtt.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null transport_rtt in Renderer.OnNetworkQualityChanged request");
  params->bandwidth_kbps = in_bandwidth_kbps;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("OnNetworkQualityChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::SetWebKitSharedTimersSuspended(
    bool in_suspend) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::Renderer::SetWebKitSharedTimersSuspended", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("suspend"), in_suspend,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kSetWebKitSharedTimersSuspended), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_SetWebKitSharedTimersSuspended_Params_Data> params(
          message);
  params.Allocate();
  params->suspend = in_suspend;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetWebKitSharedTimersSuspended");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::UpdateScrollbarTheme(
    UpdateScrollbarThemeParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::Renderer::UpdateScrollbarTheme", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type UpdateScrollbarThemeParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kUpdateScrollbarTheme), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_UpdateScrollbarTheme_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::UpdateScrollbarThemeParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in Renderer.UpdateScrollbarTheme request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("UpdateScrollbarTheme");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::OnSystemColorsChanged(
    int32_t in_aqua_color_variant) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::Renderer::OnSystemColorsChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("aqua_color_variant"), in_aqua_color_variant,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kOnSystemColorsChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_OnSystemColorsChanged_Params_Data> params(
          message);
  params.Allocate();
  params->aqua_color_variant = in_aqua_color_variant;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("OnSystemColorsChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::UpdateSystemColorInfo(
    UpdateSystemColorInfoParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::Renderer::UpdateSystemColorInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type UpdateSystemColorInfoParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kUpdateSystemColorInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_UpdateSystemColorInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::UpdateSystemColorInfoParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in Renderer.UpdateSystemColorInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("UpdateSystemColorInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::PurgePluginListCache(
    bool in_reload_pages) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::Renderer::PurgePluginListCache", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reload_pages"), in_reload_pages,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kPurgePluginListCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_PurgePluginListCache_Params_Data> params(
          message);
  params.Allocate();
  params->reload_pages = in_reload_pages;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("PurgePluginListCache");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::PurgeResourceCache(
    PurgeResourceCacheCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send content::mojom::Renderer::PurgeResourceCache");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kPurgeResourceCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_PurgeResourceCache_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("PurgeResourceCache");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Renderer_PurgeResourceCache_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void RendererProxy::SetProcessState(
    ::base::Process::Priority in_process_priority, RenderProcessVisibleState in_visible_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::Renderer::SetProcessState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("process_priority"), in_process_priority,
                        "<value of type ::base::Process::Priority>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible_state"), in_visible_state,
                        "<value of type RenderProcessVisibleState>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kSetProcessState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_SetProcessState_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::mojo_base::mojom::ProcessPriority>(
      in_process_priority, &params->process_priority);
  mojo::internal::Serialize<::content::mojom::RenderProcessVisibleState>(
      in_visible_state, &params->visible_state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetProcessState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::SetIsLockedToSite(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send content::mojom::Renderer::SetIsLockedToSite");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kSetIsLockedToSite), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_SetIsLockedToSite_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetIsLockedToSite");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::SetIsCrossOriginIsolated(
    bool in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::Renderer::SetIsCrossOriginIsolated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kSetIsCrossOriginIsolated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_SetIsCrossOriginIsolated_Params_Data> params(
          message);
  params.Allocate();
  params->value = in_value;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetIsCrossOriginIsolated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::SetIsWebSecurityDisabled(
    bool in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::Renderer::SetIsWebSecurityDisabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kSetIsWebSecurityDisabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_SetIsWebSecurityDisabled_Params_Data> params(
          message);
  params.Allocate();
  params->value = in_value;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetIsWebSecurityDisabled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::SetIsIsolatedContext(
    bool in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::Renderer::SetIsIsolatedContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kSetIsIsolatedContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_SetIsIsolatedContext_Params_Data> params(
          message);
  params.Allocate();
  params->value = in_value;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetIsIsolatedContext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::InitializeRenderer(
    const std::string& in_user_agent, const ::blink::UserAgentMetadata& in_metadata, const std::vector<std::string>& in_cors_exempt_header_list, ::blink::mojom::OriginTrialsSettingsPtr in_origin_trials_settings, uint64_t in_trace_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::Renderer::InitializeRenderer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_agent"), in_user_agent,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata"), in_metadata,
                        "<value of type const ::blink::UserAgentMetadata&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cors_exempt_header_list"), in_cors_exempt_header_list,
                        "<value of type const std::vector<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin_trials_settings"), in_origin_trials_settings,
                        "<value of type ::blink::mojom::OriginTrialsSettingsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trace_id"), in_trace_id,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kInitializeRenderer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_InitializeRenderer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->user_agent)::BaseType> user_agent_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_user_agent, user_agent_fragment);
  params->user_agent.Set(
      user_agent_fragment.is_null() ? nullptr : user_agent_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->user_agent.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null user_agent in Renderer.InitializeRenderer request");
  mojo::internal::MessageFragment<
      typename decltype(params->metadata)::BaseType> metadata_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::UserAgentMetadataDataView>(
      in_metadata, metadata_fragment);
  params->metadata.Set(
      metadata_fragment.is_null() ? nullptr : metadata_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->metadata.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null metadata in Renderer.InitializeRenderer request");
  mojo::internal::MessageFragment<
      typename decltype(params->cors_exempt_header_list)::BaseType>
      cors_exempt_header_list_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& cors_exempt_header_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_cors_exempt_header_list, cors_exempt_header_list_fragment, &cors_exempt_header_list_validate_params);
  params->cors_exempt_header_list.Set(
      cors_exempt_header_list_fragment.is_null() ? nullptr : cors_exempt_header_list_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cors_exempt_header_list.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cors_exempt_header_list in Renderer.InitializeRenderer request");
  mojo::internal::MessageFragment<
      typename decltype(params->origin_trials_settings)::BaseType> origin_trials_settings_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::OriginTrialsSettingsDataView>(
      in_origin_trials_settings, origin_trials_settings_fragment);
  params->origin_trials_settings.Set(
      origin_trials_settings_fragment.is_null() ? nullptr : origin_trials_settings_fragment.data());
  params->trace_id = in_trace_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("InitializeRenderer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class Renderer_PurgeResourceCache_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Renderer::PurgeResourceCacheCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Renderer_PurgeResourceCache_ProxyToResponder> proxy(
        new Renderer_PurgeResourceCache_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Renderer_PurgeResourceCache_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Renderer_PurgeResourceCache_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Renderer_PurgeResourceCache_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Renderer::PurgeResourceCacheCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool Renderer_PurgeResourceCache_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Renderer_PurgeResourceCache_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Renderer_PurgeResourceCache_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for Renderer.10
  bool success = true;
  Renderer_PurgeResourceCache_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Renderer::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void Renderer_PurgeResourceCache_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply content::mojom::Renderer::PurgeResourceCache");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kPurgeResourceCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_PurgeResourceCache_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("PurgeResourceCache");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool RendererStubDispatch::Accept(
    Renderer* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Renderer>(message->header()->name)) {
    case messages::Renderer::kCreateAgentSchedulingGroup: {
      DCHECK(message->is_serialized());
      internal::Renderer_CreateAgentSchedulingGroup_Params_Data* params =
          reinterpret_cast<internal::Renderer_CreateAgentSchedulingGroup_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.0
      bool success = true;
      ::mojo::PendingReceiver<::IPC::mojom::ChannelBootstrap> p_bootstrap{};
      Renderer_CreateAgentSchedulingGroup_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_bootstrap =
            input_data_view.TakeBootstrap<decltype(p_bootstrap)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateAgentSchedulingGroup(        
        std::move(p_bootstrap));
      return true;
    }
    case messages::Renderer::kCreateAssociatedAgentSchedulingGroup: {
      DCHECK(message->is_serialized());
      internal::Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data* params =
          reinterpret_cast<internal::Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.1
      bool success = true;
      ::mojo::PendingAssociatedReceiver<::content::mojom::AgentSchedulingGroup> p_agent_scheduling_group{};
      Renderer_CreateAssociatedAgentSchedulingGroup_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_agent_scheduling_group =
            input_data_view.TakeAgentSchedulingGroup<decltype(p_agent_scheduling_group)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateAssociatedAgentSchedulingGroup(        
        std::move(p_agent_scheduling_group));
      return true;
    }
    case messages::Renderer::kTransferSharedLastForegroundTime: {
      DCHECK(message->is_serialized());
      internal::Renderer_TransferSharedLastForegroundTime_Params_Data* params =
          reinterpret_cast<internal::Renderer_TransferSharedLastForegroundTime_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.2
      bool success = true;
      ::base::ReadOnlySharedMemoryRegion p_last_foreground_time_region{};
      Renderer_TransferSharedLastForegroundTime_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLastForegroundTimeRegion(&p_last_foreground_time_region))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TransferSharedLastForegroundTime(        
        std::move(p_last_foreground_time_region));
      return true;
    }
    case messages::Renderer::kOnNetworkConnectionChanged: {
      DCHECK(message->is_serialized());
      internal::Renderer_OnNetworkConnectionChanged_Params_Data* params =
          reinterpret_cast<internal::Renderer_OnNetworkConnectionChanged_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.3
      bool success = true;
      ::net::NetworkChangeNotifier::ConnectionType p_connection_type{};
      double p_max_bandwidth_mbps{};
      Renderer_OnNetworkConnectionChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConnectionType(&p_connection_type))
        success = false;
      if (success)
        p_max_bandwidth_mbps = input_data_view.max_bandwidth_mbps();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNetworkConnectionChanged(        
        std::move(p_connection_type), 
        std::move(p_max_bandwidth_mbps));
      return true;
    }
    case messages::Renderer::kOnNetworkQualityChanged: {
      DCHECK(message->is_serialized());
      internal::Renderer_OnNetworkQualityChanged_Params_Data* params =
          reinterpret_cast<internal::Renderer_OnNetworkQualityChanged_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.4
      bool success = true;
      ::net::EffectiveConnectionType p_effective_connection_type{};
      ::base::TimeDelta p_http_rtt{};
      ::base::TimeDelta p_transport_rtt{};
      double p_bandwidth_kbps{};
      Renderer_OnNetworkQualityChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEffectiveConnectionType(&p_effective_connection_type))
        success = false;
      if (success && !input_data_view.ReadHttpRtt(&p_http_rtt))
        success = false;
      if (success && !input_data_view.ReadTransportRtt(&p_transport_rtt))
        success = false;
      if (success)
        p_bandwidth_kbps = input_data_view.bandwidth_kbps();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNetworkQualityChanged(        
        std::move(p_effective_connection_type), 
        std::move(p_http_rtt), 
        std::move(p_transport_rtt), 
        std::move(p_bandwidth_kbps));
      return true;
    }
    case messages::Renderer::kSetWebKitSharedTimersSuspended: {
      DCHECK(message->is_serialized());
      internal::Renderer_SetWebKitSharedTimersSuspended_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetWebKitSharedTimersSuspended_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.5
      bool success = true;
      bool p_suspend{};
      Renderer_SetWebKitSharedTimersSuspended_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_suspend = input_data_view.suspend();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetWebKitSharedTimersSuspended(        
        std::move(p_suspend));
      return true;
    }
    case messages::Renderer::kUpdateScrollbarTheme: {
      DCHECK(message->is_serialized());
      internal::Renderer_UpdateScrollbarTheme_Params_Data* params =
          reinterpret_cast<internal::Renderer_UpdateScrollbarTheme_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.6
      bool success = true;
      UpdateScrollbarThemeParamsPtr p_params{};
      Renderer_UpdateScrollbarTheme_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateScrollbarTheme(        
        std::move(p_params));
      return true;
    }
    case messages::Renderer::kOnSystemColorsChanged: {
      DCHECK(message->is_serialized());
      internal::Renderer_OnSystemColorsChanged_Params_Data* params =
          reinterpret_cast<internal::Renderer_OnSystemColorsChanged_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.7
      bool success = true;
      int32_t p_aqua_color_variant{};
      Renderer_OnSystemColorsChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_aqua_color_variant = input_data_view.aqua_color_variant();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSystemColorsChanged(        
        std::move(p_aqua_color_variant));
      return true;
    }
    case messages::Renderer::kUpdateSystemColorInfo: {
      DCHECK(message->is_serialized());
      internal::Renderer_UpdateSystemColorInfo_Params_Data* params =
          reinterpret_cast<internal::Renderer_UpdateSystemColorInfo_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.8
      bool success = true;
      UpdateSystemColorInfoParamsPtr p_params{};
      Renderer_UpdateSystemColorInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateSystemColorInfo(        
        std::move(p_params));
      return true;
    }
    case messages::Renderer::kPurgePluginListCache: {
      DCHECK(message->is_serialized());
      internal::Renderer_PurgePluginListCache_Params_Data* params =
          reinterpret_cast<internal::Renderer_PurgePluginListCache_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.9
      bool success = true;
      bool p_reload_pages{};
      Renderer_PurgePluginListCache_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_reload_pages = input_data_view.reload_pages();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PurgePluginListCache(        
        std::move(p_reload_pages));
      return true;
    }
    case messages::Renderer::kPurgeResourceCache: {
      break;
    }
    case messages::Renderer::kSetProcessState: {
      DCHECK(message->is_serialized());
      internal::Renderer_SetProcessState_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetProcessState_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.11
      bool success = true;
      ::base::Process::Priority p_process_priority{};
      RenderProcessVisibleState p_visible_state{};
      Renderer_SetProcessState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProcessPriority(&p_process_priority))
        success = false;
      if (success && !input_data_view.ReadVisibleState(&p_visible_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetProcessState(        
        std::move(p_process_priority), 
        std::move(p_visible_state));
      return true;
    }
    case messages::Renderer::kSetIsLockedToSite: {
      DCHECK(message->is_serialized());
      internal::Renderer_SetIsLockedToSite_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetIsLockedToSite_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.12
      bool success = true;
      Renderer_SetIsLockedToSite_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIsLockedToSite(        );
      return true;
    }
    case messages::Renderer::kSetIsCrossOriginIsolated: {
      DCHECK(message->is_serialized());
      internal::Renderer_SetIsCrossOriginIsolated_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetIsCrossOriginIsolated_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.13
      bool success = true;
      bool p_value{};
      Renderer_SetIsCrossOriginIsolated_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_value = input_data_view.value();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIsCrossOriginIsolated(        
        std::move(p_value));
      return true;
    }
    case messages::Renderer::kSetIsWebSecurityDisabled: {
      DCHECK(message->is_serialized());
      internal::Renderer_SetIsWebSecurityDisabled_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetIsWebSecurityDisabled_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.14
      bool success = true;
      bool p_value{};
      Renderer_SetIsWebSecurityDisabled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_value = input_data_view.value();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIsWebSecurityDisabled(        
        std::move(p_value));
      return true;
    }
    case messages::Renderer::kSetIsIsolatedContext: {
      DCHECK(message->is_serialized());
      internal::Renderer_SetIsIsolatedContext_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetIsIsolatedContext_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.15
      bool success = true;
      bool p_value{};
      Renderer_SetIsIsolatedContext_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_value = input_data_view.value();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIsIsolatedContext(        
        std::move(p_value));
      return true;
    }
    case messages::Renderer::kInitializeRenderer: {
      DCHECK(message->is_serialized());
      internal::Renderer_InitializeRenderer_Params_Data* params =
          reinterpret_cast<internal::Renderer_InitializeRenderer_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.16
      bool success = true;
      std::string p_user_agent{};
      ::blink::UserAgentMetadata p_metadata{};
      std::vector<std::string> p_cors_exempt_header_list{};
      ::blink::mojom::OriginTrialsSettingsPtr p_origin_trials_settings{};
      uint64_t p_trace_id{};
      Renderer_InitializeRenderer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUserAgent(&p_user_agent))
        success = false;
      if (success && !input_data_view.ReadMetadata(&p_metadata))
        success = false;
      if (success && !input_data_view.ReadCorsExemptHeaderList(&p_cors_exempt_header_list))
        success = false;
      if (success && !input_data_view.ReadOriginTrialsSettings(&p_origin_trials_settings))
        success = false;
      if (success)
        p_trace_id = input_data_view.trace_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InitializeRenderer(        
        std::move(p_user_agent), 
        std::move(p_metadata), 
        std::move(p_cors_exempt_header_list), 
        std::move(p_origin_trials_settings), 
        std::move(p_trace_id));
      return true;
    }
  }
  return false;
}

// static
bool RendererStubDispatch::AcceptWithResponder(
    Renderer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Renderer>(message->header()->name)) {
    case messages::Renderer::kCreateAgentSchedulingGroup: {
      break;
    }
    case messages::Renderer::kCreateAssociatedAgentSchedulingGroup: {
      break;
    }
    case messages::Renderer::kTransferSharedLastForegroundTime: {
      break;
    }
    case messages::Renderer::kOnNetworkConnectionChanged: {
      break;
    }
    case messages::Renderer::kOnNetworkQualityChanged: {
      break;
    }
    case messages::Renderer::kSetWebKitSharedTimersSuspended: {
      break;
    }
    case messages::Renderer::kUpdateScrollbarTheme: {
      break;
    }
    case messages::Renderer::kOnSystemColorsChanged: {
      break;
    }
    case messages::Renderer::kUpdateSystemColorInfo: {
      break;
    }
    case messages::Renderer::kPurgePluginListCache: {
      break;
    }
    case messages::Renderer::kPurgeResourceCache: {
      internal::Renderer_PurgeResourceCache_Params_Data* params =
          reinterpret_cast<
              internal::Renderer_PurgeResourceCache_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for Renderer.10
      bool success = true;
      Renderer_PurgeResourceCache_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 10, false);
        return false;
      }
      Renderer::PurgeResourceCacheCallback callback =
          Renderer_PurgeResourceCache_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PurgeResourceCache(std::move(callback));
      return true;
    }
    case messages::Renderer::kSetProcessState: {
      break;
    }
    case messages::Renderer::kSetIsLockedToSite: {
      break;
    }
    case messages::Renderer::kSetIsCrossOriginIsolated: {
      break;
    }
    case messages::Renderer::kSetIsWebSecurityDisabled: {
      break;
    }
    case messages::Renderer::kSetIsIsolatedContext: {
      break;
    }
    case messages::Renderer::kInitializeRenderer: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRendererValidationInfo[] = {
    {base::to_underlying(messages::Renderer::kCreateAgentSchedulingGroup),
     { &internal::Renderer_CreateAgentSchedulingGroup_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kCreateAssociatedAgentSchedulingGroup),
     { &internal::Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kTransferSharedLastForegroundTime),
     { &internal::Renderer_TransferSharedLastForegroundTime_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kOnNetworkConnectionChanged),
     { &internal::Renderer_OnNetworkConnectionChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kOnNetworkQualityChanged),
     { &internal::Renderer_OnNetworkQualityChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kSetWebKitSharedTimersSuspended),
     { &internal::Renderer_SetWebKitSharedTimersSuspended_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kUpdateScrollbarTheme),
     { &internal::Renderer_UpdateScrollbarTheme_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kOnSystemColorsChanged),
     { &internal::Renderer_OnSystemColorsChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kUpdateSystemColorInfo),
     { &internal::Renderer_UpdateSystemColorInfo_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kPurgePluginListCache),
     { &internal::Renderer_PurgePluginListCache_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kPurgeResourceCache),
     { &internal::Renderer_PurgeResourceCache_Params_Data::Validate,
      &internal::Renderer_PurgeResourceCache_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Renderer::kSetProcessState),
     { &internal::Renderer_SetProcessState_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kSetIsLockedToSite),
     { &internal::Renderer_SetIsLockedToSite_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kSetIsCrossOriginIsolated),
     { &internal::Renderer_SetIsCrossOriginIsolated_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kSetIsWebSecurityDisabled),
     { &internal::Renderer_SetIsWebSecurityDisabled_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kSetIsIsolatedContext),
     { &internal::Renderer_SetIsIsolatedContext_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kInitializeRenderer),
     { &internal::Renderer_InitializeRenderer_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RendererRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::Renderer::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRendererValidationInfo);
}

bool RendererResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::Renderer::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kRendererValidationInfo);

}


}  // content::mojom


namespace mojo {


// static
bool StructTraits<::content::mojom::UpdateScrollbarThemeParams::DataView, ::content::mojom::UpdateScrollbarThemeParamsPtr>::Read(
    ::content::mojom::UpdateScrollbarThemeParams::DataView input,
    ::content::mojom::UpdateScrollbarThemeParamsPtr* output) {
  bool success = true;
  ::content::mojom::UpdateScrollbarThemeParamsPtr result(::content::mojom::UpdateScrollbarThemeParams::New());
  
      if (success)
        result->has_initial_button_delay = input.has_initial_button_delay();
      if (success)
        result->initial_button_delay = input.initial_button_delay();
      if (success)
        result->has_autoscroll_button_delay = input.has_autoscroll_button_delay();
      if (success)
        result->autoscroll_button_delay = input.autoscroll_button_delay();
      if (success)
        result->jump_on_track_click = input.jump_on_track_click();
      if (success && !input.ReadPreferredScrollerStyle(&result->preferred_scroller_style))
        success = false;
      if (success)
        result->redraw = input.redraw();
      if (success)
        result->scroll_view_rubber_banding = input.scroll_view_rubber_banding();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::UpdateSystemColorInfoParams::DataView, ::content::mojom::UpdateSystemColorInfoParamsPtr>::Read(
    ::content::mojom::UpdateSystemColorInfoParams::DataView input,
    ::content::mojom::UpdateSystemColorInfoParamsPtr* output) {
  bool success = true;
  ::content::mojom::UpdateSystemColorInfoParamsPtr result(::content::mojom::UpdateSystemColorInfoParams::New());
  
      if (success) {
        result->accent_color = input.accent_color();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace content::mojom {


void RendererInterceptorForTesting::CreateAgentSchedulingGroup(::mojo::PendingReceiver<::IPC::mojom::ChannelBootstrap> bootstrap) {
  GetForwardingInterface()->CreateAgentSchedulingGroup(
    std::move(bootstrap)
    );
}
void RendererInterceptorForTesting::CreateAssociatedAgentSchedulingGroup(::mojo::PendingAssociatedReceiver<::content::mojom::AgentSchedulingGroup> agent_scheduling_group) {
  GetForwardingInterface()->CreateAssociatedAgentSchedulingGroup(
    std::move(agent_scheduling_group)
    );
}
void RendererInterceptorForTesting::TransferSharedLastForegroundTime(::base::ReadOnlySharedMemoryRegion last_foreground_time_region) {
  GetForwardingInterface()->TransferSharedLastForegroundTime(
    std::move(last_foreground_time_region)
    );
}
void RendererInterceptorForTesting::OnNetworkConnectionChanged(::net::NetworkChangeNotifier::ConnectionType connection_type, double max_bandwidth_mbps) {
  GetForwardingInterface()->OnNetworkConnectionChanged(
    std::move(connection_type)
    , 
    std::move(max_bandwidth_mbps)
    );
}
void RendererInterceptorForTesting::OnNetworkQualityChanged(::net::EffectiveConnectionType effective_connection_type, ::base::TimeDelta http_rtt, ::base::TimeDelta transport_rtt, double bandwidth_kbps) {
  GetForwardingInterface()->OnNetworkQualityChanged(
    std::move(effective_connection_type)
    , 
    std::move(http_rtt)
    , 
    std::move(transport_rtt)
    , 
    std::move(bandwidth_kbps)
    );
}
void RendererInterceptorForTesting::SetWebKitSharedTimersSuspended(bool suspend) {
  GetForwardingInterface()->SetWebKitSharedTimersSuspended(
    std::move(suspend)
    );
}
void RendererInterceptorForTesting::UpdateScrollbarTheme(UpdateScrollbarThemeParamsPtr params) {
  GetForwardingInterface()->UpdateScrollbarTheme(
    std::move(params)
    );
}
void RendererInterceptorForTesting::OnSystemColorsChanged(int32_t aqua_color_variant) {
  GetForwardingInterface()->OnSystemColorsChanged(
    std::move(aqua_color_variant)
    );
}
void RendererInterceptorForTesting::UpdateSystemColorInfo(UpdateSystemColorInfoParamsPtr params) {
  GetForwardingInterface()->UpdateSystemColorInfo(
    std::move(params)
    );
}
void RendererInterceptorForTesting::PurgePluginListCache(bool reload_pages) {
  GetForwardingInterface()->PurgePluginListCache(
    std::move(reload_pages)
    );
}
void RendererInterceptorForTesting::PurgeResourceCache(PurgeResourceCacheCallback callback) {
  GetForwardingInterface()->PurgeResourceCache(std::move(callback));
}
void RendererInterceptorForTesting::SetProcessState(::base::Process::Priority process_priority, RenderProcessVisibleState visible_state) {
  GetForwardingInterface()->SetProcessState(
    std::move(process_priority)
    , 
    std::move(visible_state)
    );
}
void RendererInterceptorForTesting::SetIsLockedToSite() {
  GetForwardingInterface()->SetIsLockedToSite();
}
void RendererInterceptorForTesting::SetIsCrossOriginIsolated(bool value) {
  GetForwardingInterface()->SetIsCrossOriginIsolated(
    std::move(value)
    );
}
void RendererInterceptorForTesting::SetIsWebSecurityDisabled(bool value) {
  GetForwardingInterface()->SetIsWebSecurityDisabled(
    std::move(value)
    );
}
void RendererInterceptorForTesting::SetIsIsolatedContext(bool value) {
  GetForwardingInterface()->SetIsIsolatedContext(
    std::move(value)
    );
}
void RendererInterceptorForTesting::InitializeRenderer(const std::string& user_agent, const ::blink::UserAgentMetadata& metadata, const std::vector<std::string>& cors_exempt_header_list, ::blink::mojom::OriginTrialsSettingsPtr origin_trials_settings, uint64_t trace_id) {
  GetForwardingInterface()->InitializeRenderer(
    std::move(user_agent)
    , 
    std::move(metadata)
    , 
    std::move(cors_exempt_header_list)
    , 
    std::move(origin_trials_settings)
    , 
    std::move(trace_id)
    );
}
RendererAsyncWaiter::RendererAsyncWaiter(
    Renderer* proxy) : proxy_(proxy) {}

RendererAsyncWaiter::~RendererAsyncWaiter() = default;

void RendererAsyncWaiter::PurgeResourceCache(
    ) {
  base::RunLoop loop;
  proxy_->PurgeResourceCache(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // content::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif