// device/vr/public/mojom/vr_service.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_SHARED_H_
#define DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "device/vr/public/mojom/vr_service.mojom-shared-internal.h"
#include "device/gamepad/public/mojom/gamepad.mojom-shared.h"
#include "device/vr/public/mojom/xr_hand_tracking_data.mojom-shared.h"
#include "device/vr/public/mojom/xr_session.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "gpu/ipc/common/exported_shared_image.mojom-shared.h"
#include "gpu/ipc/common/shared_image_metadata.mojom-shared.h"
#include "gpu/ipc/common/mailbox_holder.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "ui/display/mojom/display.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/gpu_fence_handle.mojom-shared.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace device::mojom {
class XRDepthConfigDataView;

class XRSessionDeviceConfigDataView;

class XRSessionDataView;

class XRPresentationConnectionDataView;

class XRInputSourceDescriptionDataView;

class XRInputSourceStateDataView;

class VRFieldOfViewDataView;

class VRPoseDataView;

class PoseDataView;

class XRRayDataView;

class XRHitResultDataView;

class XRViewDataView;

class VRStageParametersDataView;

class XRPresentationTransportOptionsDataView;

class XRInputSourceSpaceInfoDataView;

class XRHandJointSpaceInfoDataView;

class XRPlanePointDataDataView;

class XRPlaneDataDataView;

class XRPlaneDetectionDataDataView;

class XRAnchorDataDataView;

class XRAnchorsDataDataView;

class XRHitTestSubscriptionResultDataDataView;

class XRHitTestTransientInputSubscriptionResultDataDataView;

class XRHitTestSubscriptionResultsDataDataView;

class RgbTupleF32DataView;

class XRSphericalHarmonicsDataView;

class RgbaTupleF16DataView;

class XRCubeMapDataView;

class XRLightProbeDataView;

class XRReflectionProbeDataView;

class XRLightEstimationDataDataView;

class XRDepthDataStillValidDataView;

class XRDepthDataUpdatedDataView;

class XRTrackedImageDataDataView;

class XRTrackedImagesDataDataView;

class XRFrameDataDataView;

class RequestSessionSuccessDataView;

class XRFrameDataRequestOptionsDataView;

class XRNativeOriginInformationDataView;
class XRDepthDataDataView;
class RequestSessionResultDataView;


}  // device::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::device::mojom::XRDepthConfigDataView> {
  using Data = ::device::mojom::internal::XRDepthConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRSessionDeviceConfigDataView> {
  using Data = ::device::mojom::internal::XRSessionDeviceConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRSessionDataView> {
  using Data = ::device::mojom::internal::XRSession_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRPresentationConnectionDataView> {
  using Data = ::device::mojom::internal::XRPresentationConnection_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRInputSourceDescriptionDataView> {
  using Data = ::device::mojom::internal::XRInputSourceDescription_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRInputSourceStateDataView> {
  using Data = ::device::mojom::internal::XRInputSourceState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::VRFieldOfViewDataView> {
  using Data = ::device::mojom::internal::VRFieldOfView_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::VRPoseDataView> {
  using Data = ::device::mojom::internal::VRPose_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::PoseDataView> {
  using Data = ::device::mojom::internal::Pose_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRRayDataView> {
  using Data = ::device::mojom::internal::XRRay_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRHitResultDataView> {
  using Data = ::device::mojom::internal::XRHitResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRViewDataView> {
  using Data = ::device::mojom::internal::XRView_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::VRStageParametersDataView> {
  using Data = ::device::mojom::internal::VRStageParameters_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRPresentationTransportOptionsDataView> {
  using Data = ::device::mojom::internal::XRPresentationTransportOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRInputSourceSpaceInfoDataView> {
  using Data = ::device::mojom::internal::XRInputSourceSpaceInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRHandJointSpaceInfoDataView> {
  using Data = ::device::mojom::internal::XRHandJointSpaceInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRPlanePointDataDataView> {
  using Data = ::device::mojom::internal::XRPlanePointData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRPlaneDataDataView> {
  using Data = ::device::mojom::internal::XRPlaneData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRPlaneDetectionDataDataView> {
  using Data = ::device::mojom::internal::XRPlaneDetectionData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRAnchorDataDataView> {
  using Data = ::device::mojom::internal::XRAnchorData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRAnchorsDataDataView> {
  using Data = ::device::mojom::internal::XRAnchorsData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRHitTestSubscriptionResultDataDataView> {
  using Data = ::device::mojom::internal::XRHitTestSubscriptionResultData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRHitTestTransientInputSubscriptionResultDataDataView> {
  using Data = ::device::mojom::internal::XRHitTestTransientInputSubscriptionResultData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRHitTestSubscriptionResultsDataDataView> {
  using Data = ::device::mojom::internal::XRHitTestSubscriptionResultsData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::RgbTupleF32DataView> {
  using Data = ::device::mojom::internal::RgbTupleF32_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRSphericalHarmonicsDataView> {
  using Data = ::device::mojom::internal::XRSphericalHarmonics_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::RgbaTupleF16DataView> {
  using Data = ::device::mojom::internal::RgbaTupleF16_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRCubeMapDataView> {
  using Data = ::device::mojom::internal::XRCubeMap_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRLightProbeDataView> {
  using Data = ::device::mojom::internal::XRLightProbe_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRReflectionProbeDataView> {
  using Data = ::device::mojom::internal::XRReflectionProbe_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRLightEstimationDataDataView> {
  using Data = ::device::mojom::internal::XRLightEstimationData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRDepthDataStillValidDataView> {
  using Data = ::device::mojom::internal::XRDepthDataStillValid_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRDepthDataUpdatedDataView> {
  using Data = ::device::mojom::internal::XRDepthDataUpdated_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRTrackedImageDataDataView> {
  using Data = ::device::mojom::internal::XRTrackedImageData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRTrackedImagesDataDataView> {
  using Data = ::device::mojom::internal::XRTrackedImagesData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRFrameDataDataView> {
  using Data = ::device::mojom::internal::XRFrameData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::RequestSessionSuccessDataView> {
  using Data = ::device::mojom::internal::RequestSessionSuccess_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRFrameDataRequestOptionsDataView> {
  using Data = ::device::mojom::internal::XRFrameDataRequestOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRNativeOriginInformationDataView> {
  using Data = ::device::mojom::internal::XRNativeOriginInformation_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::device::mojom::XRDepthDataDataView> {
  using Data = ::device::mojom::internal::XRDepthData_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::device::mojom::RequestSessionResultDataView> {
  using Data = ::device::mojom::internal::RequestSessionResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace device::mojom {


enum class XRHandedness : int32_t {
  
  NONE = 0,
  
  LEFT = 1,
  
  RIGHT = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRHandedness value);
inline bool IsKnownEnumValue(XRHandedness value) {
  return internal::XRHandedness_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRTargetRayMode : int32_t {
  
  GAZING = 1,
  
  POINTING = 2,
  
  TAPPING = 3,
  kMinValue = 1,
  kMaxValue = 3,
};

COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRTargetRayMode value);
inline bool IsKnownEnumValue(XRTargetRayMode value) {
  return internal::XRTargetRayMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRSessionFeatureRequestStatus : int32_t {
  
  kNotRequested = 0,
  
  kRequired = 1,
  
  kOptionalAccepted = 2,
  
  kOptionalRejected = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRSessionFeatureRequestStatus value);
inline bool IsKnownEnumValue(XRSessionFeatureRequestStatus value) {
  return internal::XRSessionFeatureRequestStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XREnvironmentBlendMode : int32_t {
  
  kOpaque = 1,
  
  kAlphaBlend = 2,
  
  kAdditive = 3,
  kMinValue = 1,
  kMaxValue = 3,
};

COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XREnvironmentBlendMode value);
inline bool IsKnownEnumValue(XREnvironmentBlendMode value) {
  return internal::XREnvironmentBlendMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRInteractionMode : int32_t {
  
  kScreenSpace = 1,
  
  kWorldSpace = 2,
  kMinValue = 1,
  kMaxValue = 2,
};

COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRInteractionMode value);
inline bool IsKnownEnumValue(XRInteractionMode value) {
  return internal::XRInteractionMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XREye : int32_t {
  
  kNone = 0,
  
  kLeft = 1,
  
  kRight = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XREye value);
inline bool IsKnownEnumValue(XREye value) {
  return internal::XREye_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRPresentationTransportMethod : int32_t {
  
  NONE = 0,
  
  SUBMIT_AS_TEXTURE_HANDLE = 1,
  
  SUBMIT_AS_MAILBOX_HOLDER = 2,
  
  DRAW_INTO_TEXTURE_MAILBOX = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRPresentationTransportMethod value);
inline bool IsKnownEnumValue(XRPresentationTransportMethod value) {
  return internal::XRPresentationTransportMethod_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRReferenceSpaceType : int32_t {
  
  kViewer = 0,
  
  kLocal = 1,
  
  kLocalFloor = 2,
  
  kBoundedFloor = 3,
  
  kUnbounded = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRReferenceSpaceType value);
inline bool IsKnownEnumValue(XRReferenceSpaceType value) {
  return internal::XRReferenceSpaceType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRInputSourceSpaceType : int32_t {
  
  kTargetRay = 0,
  
  kGrip = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRInputSourceSpaceType value);
inline bool IsKnownEnumValue(XRInputSourceSpaceType value) {
  return internal::XRInputSourceSpaceType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRPlaneOrientation : int32_t {
  
  UNKNOWN = 0,
  
  HORIZONTAL = 1,
  
  VERTICAL = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRPlaneOrientation value);
inline bool IsKnownEnumValue(XRPlaneOrientation value) {
  return internal::XRPlaneOrientation_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XrCompatibleResult : int32_t {
  
  kAlreadyCompatible = 0,
  
  kNoDeviceAvailable = 1,
  
  kWebXrFeaturePolicyBlocked = 2,
  
  kCompatibleAfterRestart = 3,
  
  kNotCompatibleAfterRestart = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XrCompatibleResult value);
inline bool IsKnownEnumValue(XrCompatibleResult value) {
  return internal::XrCompatibleResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CreateAnchorResult : int32_t {
  
  SUCCESS = 0,
  
  FAILURE = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, CreateAnchorResult value);
inline bool IsKnownEnumValue(CreateAnchorResult value) {
  return internal::CreateAnchorResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SubscribeToHitTestResult : int32_t {
  
  SUCCESS = 0,
  
  FAILURE_GENERIC = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, SubscribeToHitTestResult value);
inline bool IsKnownEnumValue(SubscribeToHitTestResult value) {
  return internal::SubscribeToHitTestResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class EntityTypeForHitTest : int32_t {
  
  POINT = 1,
  
  PLANE = 2,
  kMinValue = 1,
  kMaxValue = 2,
};

COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, EntityTypeForHitTest value);
inline bool IsKnownEnumValue(EntityTypeForHitTest value) {
  return internal::EntityTypeForHitTest_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRVisibilityState : int32_t {
  
  VISIBLE = 1,
  
  VISIBLE_BLURRED = 2,
  
  HIDDEN = 3,
  kMinValue = 1,
  kMaxValue = 3,
};

COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRVisibilityState value);
inline bool IsKnownEnumValue(XRVisibilityState value) {
  return internal::XRVisibilityState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class VRServiceInterfaceBase {};

using VRServicePtrDataView =
    mojo::InterfacePtrDataView<VRServiceInterfaceBase>;
using VRServiceRequestDataView =
    mojo::InterfaceRequestDataView<VRServiceInterfaceBase>;
using VRServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<VRServiceInterfaceBase>;
using VRServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<VRServiceInterfaceBase>;
class XRSessionMetricsRecorderInterfaceBase {};

using XRSessionMetricsRecorderPtrDataView =
    mojo::InterfacePtrDataView<XRSessionMetricsRecorderInterfaceBase>;
using XRSessionMetricsRecorderRequestDataView =
    mojo::InterfaceRequestDataView<XRSessionMetricsRecorderInterfaceBase>;
using XRSessionMetricsRecorderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XRSessionMetricsRecorderInterfaceBase>;
using XRSessionMetricsRecorderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XRSessionMetricsRecorderInterfaceBase>;
class VRServiceClientInterfaceBase {};

using VRServiceClientPtrDataView =
    mojo::InterfacePtrDataView<VRServiceClientInterfaceBase>;
using VRServiceClientRequestDataView =
    mojo::InterfaceRequestDataView<VRServiceClientInterfaceBase>;
using VRServiceClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<VRServiceClientInterfaceBase>;
using VRServiceClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<VRServiceClientInterfaceBase>;
class XREnvironmentIntegrationProviderInterfaceBase {};

using XREnvironmentIntegrationProviderPtrDataView =
    mojo::InterfacePtrDataView<XREnvironmentIntegrationProviderInterfaceBase>;
using XREnvironmentIntegrationProviderRequestDataView =
    mojo::InterfaceRequestDataView<XREnvironmentIntegrationProviderInterfaceBase>;
using XREnvironmentIntegrationProviderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XREnvironmentIntegrationProviderInterfaceBase>;
using XREnvironmentIntegrationProviderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XREnvironmentIntegrationProviderInterfaceBase>;
class XRFrameDataProviderInterfaceBase {};

using XRFrameDataProviderPtrDataView =
    mojo::InterfacePtrDataView<XRFrameDataProviderInterfaceBase>;
using XRFrameDataProviderRequestDataView =
    mojo::InterfaceRequestDataView<XRFrameDataProviderInterfaceBase>;
using XRFrameDataProviderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XRFrameDataProviderInterfaceBase>;
using XRFrameDataProviderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XRFrameDataProviderInterfaceBase>;
class XRPresentationProviderInterfaceBase {};

using XRPresentationProviderPtrDataView =
    mojo::InterfacePtrDataView<XRPresentationProviderInterfaceBase>;
using XRPresentationProviderRequestDataView =
    mojo::InterfaceRequestDataView<XRPresentationProviderInterfaceBase>;
using XRPresentationProviderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XRPresentationProviderInterfaceBase>;
using XRPresentationProviderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XRPresentationProviderInterfaceBase>;
class XRPresentationClientInterfaceBase {};

using XRPresentationClientPtrDataView =
    mojo::InterfacePtrDataView<XRPresentationClientInterfaceBase>;
using XRPresentationClientRequestDataView =
    mojo::InterfaceRequestDataView<XRPresentationClientInterfaceBase>;
using XRPresentationClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XRPresentationClientInterfaceBase>;
using XRPresentationClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XRPresentationClientInterfaceBase>;
class XRSessionClientInterfaceBase {};

using XRSessionClientPtrDataView =
    mojo::InterfacePtrDataView<XRSessionClientInterfaceBase>;
using XRSessionClientRequestDataView =
    mojo::InterfaceRequestDataView<XRSessionClientInterfaceBase>;
using XRSessionClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XRSessionClientInterfaceBase>;
using XRSessionClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XRSessionClientInterfaceBase>;
class WebXrInternalsRendererListenerInterfaceBase {};

using WebXrInternalsRendererListenerPtrDataView =
    mojo::InterfacePtrDataView<WebXrInternalsRendererListenerInterfaceBase>;
using WebXrInternalsRendererListenerRequestDataView =
    mojo::InterfaceRequestDataView<WebXrInternalsRendererListenerInterfaceBase>;
using WebXrInternalsRendererListenerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebXrInternalsRendererListenerInterfaceBase>;
using WebXrInternalsRendererListenerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebXrInternalsRendererListenerInterfaceBase>;


class XRDepthConfigDataView {
 public:
  XRDepthConfigDataView() = default;

  XRDepthConfigDataView(
      internal::XRDepthConfig_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadDepthUsage(UserType* output) const {
    auto data_value = data_->depth_usage;
    return mojo::internal::Deserialize<::device::mojom::XRDepthUsage>(
        data_value, output);
  }
  ::device::mojom::XRDepthUsage depth_usage() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XRDepthUsage>(data_->depth_usage));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDepthDataFormat(UserType* output) const {
    auto data_value = data_->depth_data_format;
    return mojo::internal::Deserialize<::device::mojom::XRDepthDataFormat>(
        data_value, output);
  }
  ::device::mojom::XRDepthDataFormat depth_data_format() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XRDepthDataFormat>(data_->depth_data_format));
  }
 private:
  internal::XRDepthConfig_Data* data_ = nullptr;
};


class XRSessionDeviceConfigDataView {
 public:
  XRSessionDeviceConfigDataView() = default;

  XRSessionDeviceConfigDataView(
      internal::XRSessionDeviceConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  float default_framebuffer_scale() const {
    return data_->default_framebuffer_scale;
  }
  inline void GetViewsDataView(
      mojo::ArrayDataView<XRViewDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViews(UserType* output) {
    
    auto* pointer = data_->views.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRViewDataView>>(
        pointer, output, message_);
  }
  bool supports_viewport_scaling() const {
    return data_->supports_viewport_scaling;
  }
  bool enable_anti_aliasing() const {
    return data_->enable_anti_aliasing;
  }
  inline void GetDepthConfigurationDataView(
      XRDepthConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDepthConfiguration(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRDepthConfigDataView, UserType>(),
    "Attempting to read the optional `depth_configuration` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDepthConfiguration` instead "
    "of `ReadDepthConfiguration if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->depth_configuration.Get();
    return mojo::internal::Deserialize<::device::mojom::XRDepthConfigDataView>(
        pointer, output, message_);
  }
 private:
  internal::XRSessionDeviceConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRSessionDataView {
 public:
  XRSessionDataView() = default;

  XRSessionDataView(
      internal::XRSession_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeDataProvider() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::device::mojom::XRFrameDataProviderInterfaceBase>>(
            &data_->data_provider, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeClientReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::device::mojom::XRSessionClientInterfaceBase>>(
            &data_->client_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetSubmitFrameSinkDataView(
      XRPresentationConnectionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubmitFrameSink(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRPresentationConnectionDataView, UserType>(),
    "Attempting to read the optional `submit_frame_sink` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSubmitFrameSink` instead "
    "of `ReadSubmitFrameSink if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->submit_frame_sink.Get();
    return mojo::internal::Deserialize<::device::mojom::XRPresentationConnectionDataView>(
        pointer, output, message_);
  }
  inline void GetEnabledFeaturesDataView(
      mojo::ArrayDataView<::device::mojom::XRSessionFeature>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEnabledFeatures(UserType* output) {
    
    auto* pointer = data_->enabled_features.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRSessionFeature>>(
        pointer, output, message_);
  }
  inline void GetDeviceConfigDataView(
      XRSessionDeviceConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceConfig(UserType* output) {
    
    auto* pointer = data_->device_config.Get();
    return mojo::internal::Deserialize<::device::mojom::XRSessionDeviceConfigDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEnviromentBlendMode(UserType* output) const {
    auto data_value = data_->enviroment_blend_mode;
    return mojo::internal::Deserialize<::device::mojom::XREnvironmentBlendMode>(
        data_value, output);
  }
  XREnvironmentBlendMode enviroment_blend_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XREnvironmentBlendMode>(data_->enviroment_blend_mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInteractionMode(UserType* output) const {
    auto data_value = data_->interaction_mode;
    return mojo::internal::Deserialize<::device::mojom::XRInteractionMode>(
        data_value, output);
  }
  XRInteractionMode interaction_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XRInteractionMode>(data_->interaction_mode));
  }
 private:
  internal::XRSession_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRPresentationConnectionDataView {
 public:
  XRPresentationConnectionDataView() = default;

  XRPresentationConnectionDataView(
      internal::XRPresentationConnection_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeProvider() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::device::mojom::XRPresentationProviderInterfaceBase>>(
            &data_->provider, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeClientReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::device::mojom::XRPresentationClientInterfaceBase>>(
            &data_->client_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetTransportOptionsDataView(
      XRPresentationTransportOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransportOptions(UserType* output) {
    
    auto* pointer = data_->transport_options.Get();
    return mojo::internal::Deserialize<::device::mojom::XRPresentationTransportOptionsDataView>(
        pointer, output, message_);
  }
 private:
  internal::XRPresentationConnection_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRInputSourceDescriptionDataView {
 public:
  XRInputSourceDescriptionDataView() = default;

  XRInputSourceDescriptionDataView(
      internal::XRInputSourceDescription_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadTargetRayMode(UserType* output) const {
    auto data_value = data_->target_ray_mode;
    return mojo::internal::Deserialize<::device::mojom::XRTargetRayMode>(
        data_value, output);
  }
  XRTargetRayMode target_ray_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XRTargetRayMode>(data_->target_ray_mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadHandedness(UserType* output) const {
    auto data_value = data_->handedness;
    return mojo::internal::Deserialize<::device::mojom::XRHandedness>(
        data_value, output);
  }
  XRHandedness handedness() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XRHandedness>(data_->handedness));
  }
  inline void GetInputFromPointerDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputFromPointer(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::TransformDataView, UserType>(),
    "Attempting to read the optional `input_from_pointer` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInputFromPointer` instead "
    "of `ReadInputFromPointer if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->input_from_pointer.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, message_);
  }
  inline void GetProfilesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProfiles(UserType* output) {
    
    auto* pointer = data_->profiles.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::XRInputSourceDescription_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRInputSourceStateDataView {
 public:
  XRInputSourceStateDataView() = default;

  XRInputSourceStateDataView(
      internal::XRInputSourceState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t source_id() const {
    return data_->source_id;
  }
  inline void GetDescriptionDataView(
      XRInputSourceDescriptionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescription(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRInputSourceDescriptionDataView, UserType>(),
    "Attempting to read the optional `description` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDescription` instead "
    "of `ReadDescription if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<::device::mojom::XRInputSourceDescriptionDataView>(
        pointer, output, message_);
  }
  inline void GetMojoFromInputDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMojoFromInput(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::TransformDataView, UserType>(),
    "Attempting to read the optional `mojo_from_input` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMojoFromInput` instead "
    "of `ReadMojoFromInput if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mojo_from_input.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, message_);
  }
  bool emulated_position() const {
    return data_->emulated_position;
  }
  bool is_auxiliary() const {
    return data_->is_auxiliary;
  }
  bool primary_input_pressed() const {
    return data_->primary_input_pressed;
  }
  bool primary_input_clicked() const {
    return data_->primary_input_clicked;
  }
  bool primary_squeeze_pressed() const {
    return data_->primary_squeeze_pressed;
  }
  bool primary_squeeze_clicked() const {
    return data_->primary_squeeze_clicked;
  }
  inline void GetGamepadDataView(
      ::device::mojom::GamepadDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGamepad(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::GamepadDataView, UserType>(),
    "Attempting to read the optional `gamepad` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGamepad` instead "
    "of `ReadGamepad if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->gamepad.Get();
    return mojo::internal::Deserialize<::device::mojom::GamepadDataView>(
        pointer, output, message_);
  }
  inline void GetOverlayPointerPositionDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOverlayPointerPosition(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::PointFDataView, UserType>(),
    "Attempting to read the optional `overlay_pointer_position` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOverlayPointerPosition` instead "
    "of `ReadOverlayPointerPosition if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->overlay_pointer_position.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetHandTrackingDataDataView(
      ::device::mojom::XRHandTrackingDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHandTrackingData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRHandTrackingDataDataView, UserType>(),
    "Attempting to read the optional `hand_tracking_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHandTrackingData` instead "
    "of `ReadHandTrackingData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->hand_tracking_data.Get();
    return mojo::internal::Deserialize<::device::mojom::XRHandTrackingDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::XRInputSourceState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VRFieldOfViewDataView {
 public:
  VRFieldOfViewDataView() = default;

  VRFieldOfViewDataView(
      internal::VRFieldOfView_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float up_degrees() const {
    return data_->up_degrees;
  }
  float down_degrees() const {
    return data_->down_degrees;
  }
  float left_degrees() const {
    return data_->left_degrees;
  }
  float right_degrees() const {
    return data_->right_degrees;
  }
 private:
  internal::VRFieldOfView_Data* data_ = nullptr;
};


class VRPoseDataView {
 public:
  VRPoseDataView() = default;

  VRPoseDataView(
      internal::VRPose_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOrientationDataView(
      ::gfx::mojom::QuaternionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrientation(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::QuaternionDataView, UserType>(),
    "Attempting to read the optional `orientation` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOrientation` instead "
    "of `ReadOrientation if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->orientation.Get();
    return mojo::internal::Deserialize<::gfx::mojom::QuaternionDataView>(
        pointer, output, message_);
  }
  inline void GetPositionDataView(
      ::gfx::mojom::Point3FDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPosition(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::Point3FDataView, UserType>(),
    "Attempting to read the optional `position` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPosition` instead "
    "of `ReadPosition if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->position.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Point3FDataView>(
        pointer, output, message_);
  }
  bool emulated_position() const {
    return data_->emulated_position;
  }
 private:
  internal::VRPose_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PoseDataView {
 public:
  PoseDataView() = default;

  PoseDataView(
      internal::Pose_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOrientationDataView(
      ::gfx::mojom::QuaternionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrientation(UserType* output) {
    
    auto* pointer = data_->orientation.Get();
    return mojo::internal::Deserialize<::gfx::mojom::QuaternionDataView>(
        pointer, output, message_);
  }
  inline void GetPositionDataView(
      ::gfx::mojom::Point3FDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPosition(UserType* output) {
    
    auto* pointer = data_->position.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Point3FDataView>(
        pointer, output, message_);
  }
 private:
  internal::Pose_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRRayDataView {
 public:
  XRRayDataView() = default;

  XRRayDataView(
      internal::XRRay_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      ::gfx::mojom::Point3FDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Point3FDataView>(
        pointer, output, message_);
  }
  inline void GetDirectionDataView(
      ::gfx::mojom::Vector3dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDirection(UserType* output) {
    
    auto* pointer = data_->direction.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector3dFDataView>(
        pointer, output, message_);
  }
 private:
  internal::XRRay_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRHitResultDataView {
 public:
  XRHitResultDataView() = default;

  XRHitResultDataView(
      internal::XRHitResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMojoFromResultDataView(
      PoseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMojoFromResult(UserType* output) {
    
    auto* pointer = data_->mojo_from_result.Get();
    return mojo::internal::Deserialize<::device::mojom::PoseDataView>(
        pointer, output, message_);
  }
  uint64_t plane_id() const {
    return data_->plane_id;
  }
 private:
  internal::XRHitResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRViewDataView {
 public:
  XRViewDataView() = default;

  XRViewDataView(
      internal::XRView_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadEye(UserType* output) const {
    auto data_value = data_->eye;
    return mojo::internal::Deserialize<::device::mojom::XREye>(
        data_value, output);
  }
  XREye eye() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XREye>(data_->eye));
  }
  inline void GetFieldOfViewDataView(
      VRFieldOfViewDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFieldOfView(UserType* output) {
    
    auto* pointer = data_->field_of_view.Get();
    return mojo::internal::Deserialize<::device::mojom::VRFieldOfViewDataView>(
        pointer, output, message_);
  }
  inline void GetMojoFromViewDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMojoFromView(UserType* output) {
    
    auto* pointer = data_->mojo_from_view.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, message_);
  }
  inline void GetViewportDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewport(UserType* output) {
    
    auto* pointer = data_->viewport.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetDepthDataDataView(
      XRDepthDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDepthData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRDepthDataDataView, UserType>(),
    "Attempting to read the optional `depth_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDepthData` instead "
    "of `ReadDepthData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->depth_data.is_null() ? &data_->depth_data : nullptr;
    return mojo::internal::Deserialize<::device::mojom::XRDepthDataDataView>(
        pointer, output, message_);
  }
  bool is_first_person_observer() const {
    return data_->is_first_person_observer;
  }
 private:
  internal::XRView_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VRStageParametersDataView {
 public:
  VRStageParametersDataView() = default;

  VRStageParametersDataView(
      internal::VRStageParameters_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMojoFromStageDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMojoFromStage(UserType* output) {
    
    auto* pointer = data_->mojo_from_stage.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, message_);
  }
  inline void GetBoundsDataView(
      mojo::ArrayDataView<::gfx::mojom::Point3FDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBounds(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::gfx::mojom::Point3FDataView>, UserType>(),
    "Attempting to read the optional `bounds` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBounds` instead "
    "of `ReadBounds if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bounds.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::Point3FDataView>>(
        pointer, output, message_);
  }
 private:
  internal::VRStageParameters_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRPresentationTransportOptionsDataView {
 public:
  XRPresentationTransportOptionsDataView() = default;

  XRPresentationTransportOptionsDataView(
      internal::XRPresentationTransportOptions_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadTransportMethod(UserType* output) const {
    auto data_value = data_->transport_method;
    return mojo::internal::Deserialize<::device::mojom::XRPresentationTransportMethod>(
        data_value, output);
  }
  XRPresentationTransportMethod transport_method() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XRPresentationTransportMethod>(data_->transport_method));
  }
  bool wait_for_transfer_notification() const {
    return data_->wait_for_transfer_notification;
  }
  bool wait_for_render_notification() const {
    return data_->wait_for_render_notification;
  }
  bool wait_for_gpu_fence() const {
    return data_->wait_for_gpu_fence;
  }
 private:
  internal::XRPresentationTransportOptions_Data* data_ = nullptr;
};


class XRInputSourceSpaceInfoDataView {
 public:
  XRInputSourceSpaceInfoDataView() = default;

  XRInputSourceSpaceInfoDataView(
      internal::XRInputSourceSpaceInfo_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t input_source_id() const {
    return data_->input_source_id;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInputSourceSpaceType(UserType* output) const {
    auto data_value = data_->input_source_space_type;
    return mojo::internal::Deserialize<::device::mojom::XRInputSourceSpaceType>(
        data_value, output);
  }
  XRInputSourceSpaceType input_source_space_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XRInputSourceSpaceType>(data_->input_source_space_type));
  }
 private:
  internal::XRInputSourceSpaceInfo_Data* data_ = nullptr;
};


class XRHandJointSpaceInfoDataView {
 public:
  XRHandJointSpaceInfoDataView() = default;

  XRHandJointSpaceInfoDataView(
      internal::XRHandJointSpaceInfo_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadHandedness(UserType* output) const {
    auto data_value = data_->handedness;
    return mojo::internal::Deserialize<::device::mojom::XRHandedness>(
        data_value, output);
  }
  XRHandedness handedness() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XRHandedness>(data_->handedness));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadJoint(UserType* output) const {
    auto data_value = data_->joint;
    return mojo::internal::Deserialize<::device::mojom::XRHandJoint>(
        data_value, output);
  }
  ::device::mojom::XRHandJoint joint() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XRHandJoint>(data_->joint));
  }
 private:
  internal::XRHandJointSpaceInfo_Data* data_ = nullptr;
};


class XRPlanePointDataDataView {
 public:
  XRPlanePointDataDataView() = default;

  XRPlanePointDataDataView(
      internal::XRPlanePointData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float x() const {
    return data_->x;
  }
  float z() const {
    return data_->z;
  }
 private:
  internal::XRPlanePointData_Data* data_ = nullptr;
};


class XRPlaneDataDataView {
 public:
  XRPlaneDataDataView() = default;

  XRPlaneDataDataView(
      internal::XRPlaneData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint64_t id() const {
    return data_->id;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadOrientation(UserType* output) const {
    auto data_value = data_->orientation;
    return mojo::internal::Deserialize<::device::mojom::XRPlaneOrientation>(
        data_value, output);
  }
  XRPlaneOrientation orientation() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XRPlaneOrientation>(data_->orientation));
  }
  inline void GetMojoFromPlaneDataView(
      PoseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMojoFromPlane(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::PoseDataView, UserType>(),
    "Attempting to read the optional `mojo_from_plane` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMojoFromPlane` instead "
    "of `ReadMojoFromPlane if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mojo_from_plane.Get();
    return mojo::internal::Deserialize<::device::mojom::PoseDataView>(
        pointer, output, message_);
  }
  inline void GetPolygonDataView(
      mojo::ArrayDataView<XRPlanePointDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPolygon(UserType* output) {
    
    auto* pointer = data_->polygon.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRPlanePointDataDataView>>(
        pointer, output, message_);
  }
 private:
  internal::XRPlaneData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRPlaneDetectionDataDataView {
 public:
  XRPlaneDetectionDataDataView() = default;

  XRPlaneDetectionDataDataView(
      internal::XRPlaneDetectionData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAllPlanesIdsDataView(
      mojo::ArrayDataView<uint64_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllPlanesIds(UserType* output) {
    
    auto* pointer = data_->all_planes_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint64_t>>(
        pointer, output, message_);
  }
  inline void GetUpdatedPlanesDataDataView(
      mojo::ArrayDataView<XRPlaneDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUpdatedPlanesData(UserType* output) {
    
    auto* pointer = data_->updated_planes_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRPlaneDataDataView>>(
        pointer, output, message_);
  }
 private:
  internal::XRPlaneDetectionData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRAnchorDataDataView {
 public:
  XRAnchorDataDataView() = default;

  XRAnchorDataDataView(
      internal::XRAnchorData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint64_t id() const {
    return data_->id;
  }
  inline void GetMojoFromAnchorDataView(
      PoseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMojoFromAnchor(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::PoseDataView, UserType>(),
    "Attempting to read the optional `mojo_from_anchor` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMojoFromAnchor` instead "
    "of `ReadMojoFromAnchor if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mojo_from_anchor.Get();
    return mojo::internal::Deserialize<::device::mojom::PoseDataView>(
        pointer, output, message_);
  }
 private:
  internal::XRAnchorData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRAnchorsDataDataView {
 public:
  XRAnchorsDataDataView() = default;

  XRAnchorsDataDataView(
      internal::XRAnchorsData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAllAnchorsIdsDataView(
      mojo::ArrayDataView<uint64_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllAnchorsIds(UserType* output) {
    
    auto* pointer = data_->all_anchors_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint64_t>>(
        pointer, output, message_);
  }
  inline void GetUpdatedAnchorsDataDataView(
      mojo::ArrayDataView<XRAnchorDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUpdatedAnchorsData(UserType* output) {
    
    auto* pointer = data_->updated_anchors_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRAnchorDataDataView>>(
        pointer, output, message_);
  }
 private:
  internal::XRAnchorsData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRHitTestSubscriptionResultDataDataView {
 public:
  XRHitTestSubscriptionResultDataDataView() = default;

  XRHitTestSubscriptionResultDataDataView(
      internal::XRHitTestSubscriptionResultData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint64_t subscription_id() const {
    return data_->subscription_id;
  }
  inline void GetHitTestResultsDataView(
      mojo::ArrayDataView<XRHitResultDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHitTestResults(UserType* output) {
    
    auto* pointer = data_->hit_test_results.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRHitResultDataView>>(
        pointer, output, message_);
  }
 private:
  internal::XRHitTestSubscriptionResultData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRHitTestTransientInputSubscriptionResultDataDataView {
 public:
  XRHitTestTransientInputSubscriptionResultDataDataView() = default;

  XRHitTestTransientInputSubscriptionResultDataDataView(
      internal::XRHitTestTransientInputSubscriptionResultData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint64_t subscription_id() const {
    return data_->subscription_id;
  }
  inline void GetInputSourceIdToHitTestResultsDataView(
      mojo::MapDataView<uint32_t, mojo::ArrayDataView<XRHitResultDataView>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputSourceIdToHitTestResults(UserType* output) {
    
    auto* pointer = data_->input_source_id_to_hit_test_results.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<uint32_t, mojo::ArrayDataView<::device::mojom::XRHitResultDataView>>>(
        pointer, output, message_);
  }
 private:
  internal::XRHitTestTransientInputSubscriptionResultData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRHitTestSubscriptionResultsDataDataView {
 public:
  XRHitTestSubscriptionResultsDataDataView() = default;

  XRHitTestSubscriptionResultsDataDataView(
      internal::XRHitTestSubscriptionResultsData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResultsDataView(
      mojo::ArrayDataView<XRHitTestSubscriptionResultDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResults(UserType* output) {
    
    auto* pointer = data_->results.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRHitTestSubscriptionResultDataDataView>>(
        pointer, output, message_);
  }
  inline void GetTransientInputResultsDataView(
      mojo::ArrayDataView<XRHitTestTransientInputSubscriptionResultDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransientInputResults(UserType* output) {
    
    auto* pointer = data_->transient_input_results.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRHitTestTransientInputSubscriptionResultDataDataView>>(
        pointer, output, message_);
  }
 private:
  internal::XRHitTestSubscriptionResultsData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RgbTupleF32DataView {
 public:
  RgbTupleF32DataView() = default;

  RgbTupleF32DataView(
      internal::RgbTupleF32_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float red() const {
    return data_->red;
  }
  float green() const {
    return data_->green;
  }
  float blue() const {
    return data_->blue;
  }
 private:
  internal::RgbTupleF32_Data* data_ = nullptr;
};


class XRSphericalHarmonicsDataView {
 public:
  XRSphericalHarmonicsDataView() = default;

  XRSphericalHarmonicsDataView(
      internal::XRSphericalHarmonics_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCoefficientsDataView(
      mojo::ArrayDataView<RgbTupleF32DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCoefficients(UserType* output) {
    
    auto* pointer = data_->coefficients.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::RgbTupleF32DataView>>(
        pointer, output, message_);
  }
 private:
  internal::XRSphericalHarmonics_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RgbaTupleF16DataView {
 public:
  RgbaTupleF16DataView() = default;

  RgbaTupleF16DataView(
      internal::RgbaTupleF16_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint16_t red() const {
    return data_->red;
  }
  uint16_t green() const {
    return data_->green;
  }
  uint16_t blue() const {
    return data_->blue;
  }
  uint16_t alpha() const {
    return data_->alpha;
  }
 private:
  internal::RgbaTupleF16_Data* data_ = nullptr;
};


class XRCubeMapDataView {
 public:
  XRCubeMapDataView() = default;

  XRCubeMapDataView(
      internal::XRCubeMap_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t width_and_height() const {
    return data_->width_and_height;
  }
  inline void GetPositiveXDataView(
      mojo::ArrayDataView<RgbaTupleF16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPositiveX(UserType* output) {
    
    auto* pointer = data_->positive_x.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::RgbaTupleF16DataView>>(
        pointer, output, message_);
  }
  inline void GetNegativeXDataView(
      mojo::ArrayDataView<RgbaTupleF16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNegativeX(UserType* output) {
    
    auto* pointer = data_->negative_x.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::RgbaTupleF16DataView>>(
        pointer, output, message_);
  }
  inline void GetPositiveYDataView(
      mojo::ArrayDataView<RgbaTupleF16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPositiveY(UserType* output) {
    
    auto* pointer = data_->positive_y.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::RgbaTupleF16DataView>>(
        pointer, output, message_);
  }
  inline void GetNegativeYDataView(
      mojo::ArrayDataView<RgbaTupleF16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNegativeY(UserType* output) {
    
    auto* pointer = data_->negative_y.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::RgbaTupleF16DataView>>(
        pointer, output, message_);
  }
  inline void GetPositiveZDataView(
      mojo::ArrayDataView<RgbaTupleF16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPositiveZ(UserType* output) {
    
    auto* pointer = data_->positive_z.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::RgbaTupleF16DataView>>(
        pointer, output, message_);
  }
  inline void GetNegativeZDataView(
      mojo::ArrayDataView<RgbaTupleF16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNegativeZ(UserType* output) {
    
    auto* pointer = data_->negative_z.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::RgbaTupleF16DataView>>(
        pointer, output, message_);
  }
 private:
  internal::XRCubeMap_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRLightProbeDataView {
 public:
  XRLightProbeDataView() = default;

  XRLightProbeDataView(
      internal::XRLightProbe_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSphericalHarmonicsDataView(
      XRSphericalHarmonicsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSphericalHarmonics(UserType* output) {
    
    auto* pointer = data_->spherical_harmonics.Get();
    return mojo::internal::Deserialize<::device::mojom::XRSphericalHarmonicsDataView>(
        pointer, output, message_);
  }
  inline void GetMainLightDirectionDataView(
      ::gfx::mojom::Vector3dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMainLightDirection(UserType* output) {
    
    auto* pointer = data_->main_light_direction.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector3dFDataView>(
        pointer, output, message_);
  }
  inline void GetMainLightIntensityDataView(
      RgbTupleF32DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMainLightIntensity(UserType* output) {
    
    auto* pointer = data_->main_light_intensity.Get();
    return mojo::internal::Deserialize<::device::mojom::RgbTupleF32DataView>(
        pointer, output, message_);
  }
 private:
  internal::XRLightProbe_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRReflectionProbeDataView {
 public:
  XRReflectionProbeDataView() = default;

  XRReflectionProbeDataView(
      internal::XRReflectionProbe_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCubeMapDataView(
      XRCubeMapDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCubeMap(UserType* output) {
    
    auto* pointer = data_->cube_map.Get();
    return mojo::internal::Deserialize<::device::mojom::XRCubeMapDataView>(
        pointer, output, message_);
  }
 private:
  internal::XRReflectionProbe_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRLightEstimationDataDataView {
 public:
  XRLightEstimationDataDataView() = default;

  XRLightEstimationDataDataView(
      internal::XRLightEstimationData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLightProbeDataView(
      XRLightProbeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLightProbe(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRLightProbeDataView, UserType>(),
    "Attempting to read the optional `light_probe` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLightProbe` instead "
    "of `ReadLightProbe if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->light_probe.Get();
    return mojo::internal::Deserialize<::device::mojom::XRLightProbeDataView>(
        pointer, output, message_);
  }
  inline void GetReflectionProbeDataView(
      XRReflectionProbeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReflectionProbe(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRReflectionProbeDataView, UserType>(),
    "Attempting to read the optional `reflection_probe` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReflectionProbe` instead "
    "of `ReadReflectionProbe if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->reflection_probe.Get();
    return mojo::internal::Deserialize<::device::mojom::XRReflectionProbeDataView>(
        pointer, output, message_);
  }
 private:
  internal::XRLightEstimationData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRDepthDataStillValidDataView {
 public:
  XRDepthDataStillValidDataView() = default;

  XRDepthDataStillValidDataView(
      internal::XRDepthDataStillValid_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::XRDepthDataStillValid_Data* data_ = nullptr;
};


class XRDepthDataUpdatedDataView {
 public:
  XRDepthDataUpdatedDataView() = default;

  XRDepthDataUpdatedDataView(
      internal::XRDepthDataUpdated_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPixelDataDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPixelData(UserType* output) {
    
    auto* pointer = !data_->pixel_data.is_null() ? &data_->pixel_data : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, message_);
  }
  inline void GetNormTextureFromNormViewDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNormTextureFromNormView(UserType* output) {
    
    auto* pointer = data_->norm_texture_from_norm_view.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, message_);
  }
  inline void GetSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSize(UserType* output) {
    
    auto* pointer = data_->size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  float raw_value_to_meters() const {
    return data_->raw_value_to_meters;
  }
 private:
  internal::XRDepthDataUpdated_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRTrackedImageDataDataView {
 public:
  XRTrackedImageDataDataView() = default;

  XRTrackedImageDataDataView(
      internal::XRTrackedImageData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t index() const {
    return data_->index;
  }
  inline void GetMojoFromImageDataView(
      PoseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMojoFromImage(UserType* output) {
    
    auto* pointer = data_->mojo_from_image.Get();
    return mojo::internal::Deserialize<::device::mojom::PoseDataView>(
        pointer, output, message_);
  }
  bool actively_tracked() const {
    return data_->actively_tracked;
  }
  float width_in_meters() const {
    return data_->width_in_meters;
  }
 private:
  internal::XRTrackedImageData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRTrackedImagesDataDataView {
 public:
  XRTrackedImagesDataDataView() = default;

  XRTrackedImagesDataDataView(
      internal::XRTrackedImagesData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetImagesDataDataView(
      mojo::ArrayDataView<XRTrackedImageDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImagesData(UserType* output) {
    
    auto* pointer = data_->images_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRTrackedImageDataDataView>>(
        pointer, output, message_);
  }
  inline void GetImageTrackableScoresDataView(
      mojo::ArrayDataView<bool>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageTrackableScores(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<bool>, UserType>(),
    "Attempting to read the optional `image_trackable_scores` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadImageTrackableScores` instead "
    "of `ReadImageTrackableScores if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->image_trackable_scores.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<bool>>(
        pointer, output, message_);
  }
 private:
  internal::XRTrackedImagesData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRFrameDataDataView {
 public:
  XRFrameDataDataView() = default;

  XRFrameDataDataView(
      internal::XRFrameData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMojoFromViewerDataView(
      VRPoseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMojoFromViewer(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::VRPoseDataView, UserType>(),
    "Attempting to read the optional `mojo_from_viewer` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMojoFromViewer` instead "
    "of `ReadMojoFromViewer if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mojo_from_viewer.Get();
    return mojo::internal::Deserialize<::device::mojom::VRPoseDataView>(
        pointer, output, message_);
  }
  inline void GetTimeDeltaDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimeDelta(UserType* output) {
    
    auto* pointer = data_->time_delta.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetBufferSharedImageDataView(
      ::gpu::mojom::ExportedSharedImageDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBufferSharedImage(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gpu::mojom::ExportedSharedImageDataView, UserType>(),
    "Attempting to read the optional `buffer_shared_image` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBufferSharedImage` instead "
    "of `ReadBufferSharedImage if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->buffer_shared_image.Get();
    return mojo::internal::Deserialize<::gpu::mojom::ExportedSharedImageDataView>(
        pointer, output, message_);
  }
  inline void GetBufferSyncTokenDataView(
      ::gpu::mojom::SyncTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBufferSyncToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gpu::mojom::SyncTokenDataView, UserType>(),
    "Attempting to read the optional `buffer_sync_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBufferSyncToken` instead "
    "of `ReadBufferSyncToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->buffer_sync_token.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SyncTokenDataView>(
        pointer, output, message_);
  }
  inline void GetCameraImageBufferSharedImageDataView(
      ::gpu::mojom::ExportedSharedImageDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCameraImageBufferSharedImage(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gpu::mojom::ExportedSharedImageDataView, UserType>(),
    "Attempting to read the optional `camera_image_buffer_shared_image` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCameraImageBufferSharedImage` instead "
    "of `ReadCameraImageBufferSharedImage if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->camera_image_buffer_shared_image.Get();
    return mojo::internal::Deserialize<::gpu::mojom::ExportedSharedImageDataView>(
        pointer, output, message_);
  }
  inline void GetCameraImageBufferSyncTokenDataView(
      ::gpu::mojom::SyncTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCameraImageBufferSyncToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gpu::mojom::SyncTokenDataView, UserType>(),
    "Attempting to read the optional `camera_image_buffer_sync_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCameraImageBufferSyncToken` instead "
    "of `ReadCameraImageBufferSyncToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->camera_image_buffer_sync_token.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SyncTokenDataView>(
        pointer, output, message_);
  }
  inline void GetCameraImageSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCameraImageSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::SizeDataView, UserType>(),
    "Attempting to read the optional `camera_image_size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCameraImageSize` instead "
    "of `ReadCameraImageSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->camera_image_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  bool mojo_space_reset() const {
    return data_->mojo_space_reset;
  }
  inline void GetMojoFromFloorDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMojoFromFloor(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::TransformDataView, UserType>(),
    "Attempting to read the optional `mojo_from_floor` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMojoFromFloor` instead "
    "of `ReadMojoFromFloor if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mojo_from_floor.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, message_);
  }
  int16_t frame_id() const {
    return data_->frame_id;
  }
  inline void GetViewsDataView(
      mojo::ArrayDataView<XRViewDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViews(UserType* output) {
    
    auto* pointer = data_->views.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRViewDataView>>(
        pointer, output, message_);
  }
  inline void GetInputStateDataView(
      mojo::ArrayDataView<XRInputSourceStateDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputState(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::device::mojom::XRInputSourceStateDataView>, UserType>(),
    "Attempting to read the optional `input_state` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInputState` instead "
    "of `ReadInputState if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->input_state.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRInputSourceStateDataView>>(
        pointer, output, message_);
  }
  uint32_t stage_parameters_id() const {
    return data_->stage_parameters_id;
  }
  inline void GetStageParametersDataView(
      VRStageParametersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStageParameters(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::VRStageParametersDataView, UserType>(),
    "Attempting to read the optional `stage_parameters` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadStageParameters` instead "
    "of `ReadStageParameters if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->stage_parameters.Get();
    return mojo::internal::Deserialize<::device::mojom::VRStageParametersDataView>(
        pointer, output, message_);
  }
  inline void GetDetectedPlanesDataDataView(
      XRPlaneDetectionDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDetectedPlanesData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRPlaneDetectionDataDataView, UserType>(),
    "Attempting to read the optional `detected_planes_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDetectedPlanesData` instead "
    "of `ReadDetectedPlanesData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->detected_planes_data.Get();
    return mojo::internal::Deserialize<::device::mojom::XRPlaneDetectionDataDataView>(
        pointer, output, message_);
  }
  inline void GetAnchorsDataDataView(
      XRAnchorsDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAnchorsData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRAnchorsDataDataView, UserType>(),
    "Attempting to read the optional `anchors_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAnchorsData` instead "
    "of `ReadAnchorsData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->anchors_data.Get();
    return mojo::internal::Deserialize<::device::mojom::XRAnchorsDataDataView>(
        pointer, output, message_);
  }
  inline void GetLightEstimationDataDataView(
      XRLightEstimationDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLightEstimationData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRLightEstimationDataDataView, UserType>(),
    "Attempting to read the optional `light_estimation_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLightEstimationData` instead "
    "of `ReadLightEstimationData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->light_estimation_data.Get();
    return mojo::internal::Deserialize<::device::mojom::XRLightEstimationDataDataView>(
        pointer, output, message_);
  }
  inline void GetHitTestSubscriptionResultsDataView(
      XRHitTestSubscriptionResultsDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHitTestSubscriptionResults(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRHitTestSubscriptionResultsDataDataView, UserType>(),
    "Attempting to read the optional `hit_test_subscription_results` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHitTestSubscriptionResults` instead "
    "of `ReadHitTestSubscriptionResults if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->hit_test_subscription_results.Get();
    return mojo::internal::Deserialize<::device::mojom::XRHitTestSubscriptionResultsDataDataView>(
        pointer, output, message_);
  }
  float rendering_time_ratio() const {
    return data_->rendering_time_ratio;
  }
  inline void GetTrackedImagesDataView(
      XRTrackedImagesDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrackedImages(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRTrackedImagesDataDataView, UserType>(),
    "Attempting to read the optional `tracked_images` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTrackedImages` instead "
    "of `ReadTrackedImages if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->tracked_images.Get();
    return mojo::internal::Deserialize<::device::mojom::XRTrackedImagesDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::XRFrameData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RequestSessionSuccessDataView {
 public:
  RequestSessionSuccessDataView() = default;

  RequestSessionSuccessDataView(
      internal::RequestSessionSuccess_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSessionDataView(
      XRSessionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSession(UserType* output) {
    
    auto* pointer = data_->session.Get();
    return mojo::internal::Deserialize<::device::mojom::XRSessionDataView>(
        pointer, output, message_);
  }
  uint64_t trace_id() const {
    return data_->trace_id;
  }
  template <typename UserType>
  UserType TakeMetricsRecorder() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::device::mojom::XRSessionMetricsRecorderInterfaceBase>>(
            &data_->metrics_recorder, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeXrInternalsListener() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::device::mojom::WebXrInternalsRendererListenerInterfaceBase>>(
            &data_->xr_internals_listener, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::RequestSessionSuccess_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRFrameDataRequestOptionsDataView {
 public:
  XRFrameDataRequestOptionsDataView() = default;

  XRFrameDataRequestOptionsDataView(
      internal::XRFrameDataRequestOptions_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool include_lighting_estimation_data() const {
    return data_->include_lighting_estimation_data;
  }
  uint32_t stage_parameters_id() const {
    return data_->stage_parameters_id;
  }
 private:
  internal::XRFrameDataRequestOptions_Data* data_ = nullptr;
};


class XRNativeOriginInformationDataView {
 public:
  using Tag = internal::XRNativeOriginInformation_Data::XRNativeOriginInformation_Tag;

  XRNativeOriginInformationDataView() = default;

  XRNativeOriginInformationDataView(
      internal::XRNativeOriginInformation_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_input_source_space_info() const { return data_->tag == Tag::kInputSourceSpaceInfo; }
  inline void GetInputSourceSpaceInfoDataView(
      XRInputSourceSpaceInfoDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadInputSourceSpaceInfo(UserType* output) const {
    
    CHECK(is_input_source_space_info());
    return mojo::internal::Deserialize<::device::mojom::XRInputSourceSpaceInfoDataView>(
        data_->data.f_input_source_space_info.Get(), output, message_);
  }
  bool is_plane_id() const { return data_->tag == Tag::kPlaneId; }
  uint64_t plane_id() const {
    CHECK(is_plane_id());
    return data_->data.f_plane_id;
  }
  bool is_anchor_id() const { return data_->tag == Tag::kAnchorId; }
  uint64_t anchor_id() const {
    CHECK(is_anchor_id());
    return data_->data.f_anchor_id;
  }
  bool is_reference_space_type() const { return data_->tag == Tag::kReferenceSpaceType; }
  template <typename UserType>
  [[nodiscard]] bool ReadReferenceSpaceType(UserType* output) const {
    CHECK(is_reference_space_type());
    return mojo::internal::Deserialize<::device::mojom::XRReferenceSpaceType>(
        data_->data.f_reference_space_type, output);
  }
  XRReferenceSpaceType reference_space_type() const {
    CHECK(is_reference_space_type());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::XRReferenceSpaceType>(data_->data.f_reference_space_type));
  }
  bool is_hand_joint_space_info() const { return data_->tag == Tag::kHandJointSpaceInfo; }
  inline void GetHandJointSpaceInfoDataView(
      XRHandJointSpaceInfoDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadHandJointSpaceInfo(UserType* output) const {
    
    CHECK(is_hand_joint_space_info());
    return mojo::internal::Deserialize<::device::mojom::XRHandJointSpaceInfoDataView>(
        data_->data.f_hand_joint_space_info.Get(), output, message_);
  }
  bool is_image_index() const { return data_->tag == Tag::kImageIndex; }
  uint32_t image_index() const {
    CHECK(is_image_index());
    return data_->data.f_image_index;
  }

 private:
  internal::XRNativeOriginInformation_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class XRDepthDataDataView {
 public:
  using Tag = internal::XRDepthData_Data::XRDepthData_Tag;

  XRDepthDataDataView() = default;

  XRDepthDataDataView(
      internal::XRDepthData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_data_still_valid() const { return data_->tag == Tag::kDataStillValid; }
  inline void GetDataStillValidDataView(
      XRDepthDataStillValidDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadDataStillValid(UserType* output) const {
    
    CHECK(is_data_still_valid());
    return mojo::internal::Deserialize<::device::mojom::XRDepthDataStillValidDataView>(
        data_->data.f_data_still_valid.Get(), output, message_);
  }
  bool is_updated_depth_data() const { return data_->tag == Tag::kUpdatedDepthData; }
  inline void GetUpdatedDepthDataDataView(
      XRDepthDataUpdatedDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadUpdatedDepthData(UserType* output) const {
    
    CHECK(is_updated_depth_data());
    return mojo::internal::Deserialize<::device::mojom::XRDepthDataUpdatedDataView>(
        data_->data.f_updated_depth_data.Get(), output, message_);
  }

 private:
  internal::XRDepthData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class RequestSessionResultDataView {
 public:
  using Tag = internal::RequestSessionResult_Data::RequestSessionResult_Tag;

  RequestSessionResultDataView() = default;

  RequestSessionResultDataView(
      internal::RequestSessionResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      RequestSessionSuccessDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<::device::mojom::RequestSessionSuccessDataView>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_failure_reason() const { return data_->tag == Tag::kFailureReason; }
  template <typename UserType>
  [[nodiscard]] bool ReadFailureReason(UserType* output) const {
    CHECK(is_failure_reason());
    return mojo::internal::Deserialize<::device::mojom::RequestSessionError>(
        data_->data.f_failure_reason, output);
  }
  ::device::mojom::RequestSessionError failure_reason() const {
    CHECK(is_failure_reason());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::RequestSessionError>(data_->data.f_failure_reason));
  }

 private:
  internal::RequestSessionResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // device::mojom

namespace std {

template <>
struct hash<::device::mojom::XRHandedness>
    : public mojo::internal::EnumHashImpl<::device::mojom::XRHandedness> {};

template <>
struct hash<::device::mojom::XRTargetRayMode>
    : public mojo::internal::EnumHashImpl<::device::mojom::XRTargetRayMode> {};

template <>
struct hash<::device::mojom::XRSessionFeatureRequestStatus>
    : public mojo::internal::EnumHashImpl<::device::mojom::XRSessionFeatureRequestStatus> {};

template <>
struct hash<::device::mojom::XREnvironmentBlendMode>
    : public mojo::internal::EnumHashImpl<::device::mojom::XREnvironmentBlendMode> {};

template <>
struct hash<::device::mojom::XRInteractionMode>
    : public mojo::internal::EnumHashImpl<::device::mojom::XRInteractionMode> {};

template <>
struct hash<::device::mojom::XREye>
    : public mojo::internal::EnumHashImpl<::device::mojom::XREye> {};

template <>
struct hash<::device::mojom::XRPresentationTransportMethod>
    : public mojo::internal::EnumHashImpl<::device::mojom::XRPresentationTransportMethod> {};

template <>
struct hash<::device::mojom::XRReferenceSpaceType>
    : public mojo::internal::EnumHashImpl<::device::mojom::XRReferenceSpaceType> {};

template <>
struct hash<::device::mojom::XRInputSourceSpaceType>
    : public mojo::internal::EnumHashImpl<::device::mojom::XRInputSourceSpaceType> {};

template <>
struct hash<::device::mojom::XRPlaneOrientation>
    : public mojo::internal::EnumHashImpl<::device::mojom::XRPlaneOrientation> {};

template <>
struct hash<::device::mojom::XrCompatibleResult>
    : public mojo::internal::EnumHashImpl<::device::mojom::XrCompatibleResult> {};

template <>
struct hash<::device::mojom::CreateAnchorResult>
    : public mojo::internal::EnumHashImpl<::device::mojom::CreateAnchorResult> {};

template <>
struct hash<::device::mojom::SubscribeToHitTestResult>
    : public mojo::internal::EnumHashImpl<::device::mojom::SubscribeToHitTestResult> {};

template <>
struct hash<::device::mojom::EntityTypeForHitTest>
    : public mojo::internal::EnumHashImpl<::device::mojom::EntityTypeForHitTest> {};

template <>
struct hash<::device::mojom::XRVisibilityState>
    : public mojo::internal::EnumHashImpl<::device::mojom::XRVisibilityState> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRHandedness, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XRHandedness, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::XRHandedness>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRTargetRayMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XRTargetRayMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::XRTargetRayMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRSessionFeatureRequestStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XRSessionFeatureRequestStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::XRSessionFeatureRequestStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XREnvironmentBlendMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XREnvironmentBlendMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::XREnvironmentBlendMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRInteractionMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XRInteractionMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::XRInteractionMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XREye, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XREye, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::XREye>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRPresentationTransportMethod, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XRPresentationTransportMethod, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::XRPresentationTransportMethod>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRReferenceSpaceType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XRReferenceSpaceType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::XRReferenceSpaceType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRInputSourceSpaceType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XRInputSourceSpaceType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::XRInputSourceSpaceType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRPlaneOrientation, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XRPlaneOrientation, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::XRPlaneOrientation>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XrCompatibleResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XrCompatibleResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::XrCompatibleResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::CreateAnchorResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::CreateAnchorResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::CreateAnchorResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SubscribeToHitTestResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::SubscribeToHitTestResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SubscribeToHitTestResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::EntityTypeForHitTest, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::EntityTypeForHitTest, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::EntityTypeForHitTest>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRVisibilityState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XRVisibilityState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::XRVisibilityState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRDepthConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRDepthConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRDepthConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::device::mojom::XRDepthUsage>(
        Traits::depth_usage(input), &fragment->depth_usage);
    mojo::internal::Serialize<::device::mojom::XRDepthDataFormat>(
        Traits::depth_data_format(input), &fragment->depth_data_format);
  }

  static bool Deserialize(::device::mojom::internal::XRDepthConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRDepthConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRSessionDeviceConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRSessionDeviceConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRSessionDeviceConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->default_framebuffer_scale = Traits::default_framebuffer_scale(input);
    decltype(Traits::views(input)) in_views = Traits::views(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->views)::BaseType>
        views_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& views_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRViewDataView>>(
        in_views, views_fragment, &views_validate_params);
    fragment->views.Set(
        views_fragment.is_null() ? nullptr : views_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->views.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null views in XRSessionDeviceConfig struct");
    fragment->supports_viewport_scaling = Traits::supports_viewport_scaling(input);
    fragment->enable_anti_aliasing = Traits::enable_anti_aliasing(input);
    decltype(Traits::depth_configuration(input)) in_depth_configuration = Traits::depth_configuration(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->depth_configuration)::BaseType> depth_configuration_fragment(
            fragment.message());
    mojo::internal::Serialize<::device::mojom::XRDepthConfigDataView>(
        in_depth_configuration, depth_configuration_fragment);
    fragment->depth_configuration.Set(
        depth_configuration_fragment.is_null() ? nullptr : depth_configuration_fragment.data());
  }

  static bool Deserialize(::device::mojom::internal::XRSessionDeviceConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRSessionDeviceConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRSessionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRSessionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRSession_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::data_provider(input)) in_data_provider = Traits::data_provider(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::XRFrameDataProviderInterfaceBase>>(
        in_data_provider, &fragment->data_provider, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->data_provider),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid data_provider in XRSession struct");
    decltype(Traits::client_receiver(input)) in_client_receiver = Traits::client_receiver(input);
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::XRSessionClientInterfaceBase>>(
        in_client_receiver, &fragment->client_receiver, &fragment.message());
    decltype(Traits::submit_frame_sink(input)) in_submit_frame_sink = Traits::submit_frame_sink(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->submit_frame_sink)::BaseType> submit_frame_sink_fragment(
            fragment.message());
    mojo::internal::Serialize<::device::mojom::XRPresentationConnectionDataView>(
        in_submit_frame_sink, submit_frame_sink_fragment);
    fragment->submit_frame_sink.Set(
        submit_frame_sink_fragment.is_null() ? nullptr : submit_frame_sink_fragment.data());
    decltype(Traits::enabled_features(input)) in_enabled_features = Traits::enabled_features(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->enabled_features)::BaseType>
        enabled_features_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& enabled_features_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::XRSessionFeature_Data::Validate>();
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRSessionFeature>>(
        in_enabled_features, enabled_features_fragment, &enabled_features_validate_params);
    fragment->enabled_features.Set(
        enabled_features_fragment.is_null() ? nullptr : enabled_features_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->enabled_features.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null enabled_features in XRSession struct");
    decltype(Traits::device_config(input)) in_device_config = Traits::device_config(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->device_config)::BaseType> device_config_fragment(
            fragment.message());
    mojo::internal::Serialize<::device::mojom::XRSessionDeviceConfigDataView>(
        in_device_config, device_config_fragment);
    fragment->device_config.Set(
        device_config_fragment.is_null() ? nullptr : device_config_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->device_config.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null device_config in XRSession struct");
    mojo::internal::Serialize<::device::mojom::XREnvironmentBlendMode>(
        Traits::enviroment_blend_mode(input), &fragment->enviroment_blend_mode);
    mojo::internal::Serialize<::device::mojom::XRInteractionMode>(
        Traits::interaction_mode(input), &fragment->interaction_mode);
  }

  static bool Deserialize(::device::mojom::internal::XRSession_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRSessionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRPresentationConnectionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRPresentationConnectionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRPresentationConnection_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::provider(input)) in_provider = Traits::provider(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::XRPresentationProviderInterfaceBase>>(
        in_provider, &fragment->provider, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->provider),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid provider in XRPresentationConnection struct");
    decltype(Traits::client_receiver(input)) in_client_receiver = Traits::client_receiver(input);
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::XRPresentationClientInterfaceBase>>(
        in_client_receiver, &fragment->client_receiver, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->client_receiver),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid client_receiver in XRPresentationConnection struct");
    decltype(Traits::transport_options(input)) in_transport_options = Traits::transport_options(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->transport_options)::BaseType> transport_options_fragment(
            fragment.message());
    mojo::internal::Serialize<::device::mojom::XRPresentationTransportOptionsDataView>(
        in_transport_options, transport_options_fragment);
    fragment->transport_options.Set(
        transport_options_fragment.is_null() ? nullptr : transport_options_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->transport_options.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null transport_options in XRPresentationConnection struct");
  }

  static bool Deserialize(::device::mojom::internal::XRPresentationConnection_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRPresentationConnectionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRInputSourceDescriptionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRInputSourceDescriptionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRInputSourceDescription_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::device::mojom::XRTargetRayMode>(
        Traits::target_ray_mode(input), &fragment->target_ray_mode);
    mojo::internal::Serialize<::device::mojom::XRHandedness>(
        Traits::handedness(input), &fragment->handedness);
    decltype(Traits::input_from_pointer(input)) in_input_from_pointer = Traits::input_from_pointer(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_from_pointer)::BaseType> input_from_pointer_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::TransformDataView>(
        in_input_from_pointer, input_from_pointer_fragment);
    fragment->input_from_pointer.Set(
        input_from_pointer_fragment.is_null() ? nullptr : input_from_pointer_fragment.data());
    decltype(Traits::profiles(input)) in_profiles = Traits::profiles(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->profiles)::BaseType>
        profiles_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& profiles_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_profiles, profiles_fragment, &profiles_validate_params);
    fragment->profiles.Set(
        profiles_fragment.is_null() ? nullptr : profiles_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->profiles.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null profiles in XRInputSourceDescription struct");
  }

  static bool Deserialize(::device::mojom::internal::XRInputSourceDescription_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRInputSourceDescriptionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRInputSourceStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRInputSourceStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRInputSourceState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->source_id = Traits::source_id(input);
    decltype(Traits::description(input)) in_description = Traits::description(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->description)::BaseType> description_fragment(
            fragment.message());
    mojo::internal::Serialize<::device::mojom::XRInputSourceDescriptionDataView>(
        in_description, description_fragment);
    fragment->description.Set(
        description_fragment.is_null() ? nullptr : description_fragment.data());
    decltype(Traits::mojo_from_input(input)) in_mojo_from_input = Traits::mojo_from_input(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mojo_from_input)::BaseType> mojo_from_input_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::TransformDataView>(
        in_mojo_from_input, mojo_from_input_fragment);
    fragment->mojo_from_input.Set(
        mojo_from_input_fragment.is_null() ? nullptr : mojo_from_input_fragment.data());
    fragment->emulated_position = Traits::emulated_position(input);
    fragment->is_auxiliary = Traits::is_auxiliary(input);
    fragment->primary_input_pressed = Traits::primary_input_pressed(input);
    fragment->primary_input_clicked = Traits::primary_input_clicked(input);
    fragment->primary_squeeze_pressed = Traits::primary_squeeze_pressed(input);
    fragment->primary_squeeze_clicked = Traits::primary_squeeze_clicked(input);
    decltype(Traits::gamepad(input)) in_gamepad = Traits::gamepad(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->gamepad)::BaseType> gamepad_fragment(
            fragment.message());
    mojo::internal::Serialize<::device::mojom::GamepadDataView>(
        in_gamepad, gamepad_fragment);
    fragment->gamepad.Set(
        gamepad_fragment.is_null() ? nullptr : gamepad_fragment.data());
    decltype(Traits::overlay_pointer_position(input)) in_overlay_pointer_position = Traits::overlay_pointer_position(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->overlay_pointer_position)::BaseType> overlay_pointer_position_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_overlay_pointer_position, overlay_pointer_position_fragment);
    fragment->overlay_pointer_position.Set(
        overlay_pointer_position_fragment.is_null() ? nullptr : overlay_pointer_position_fragment.data());
    decltype(Traits::hand_tracking_data(input)) in_hand_tracking_data = Traits::hand_tracking_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hand_tracking_data)::BaseType> hand_tracking_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::device::mojom::XRHandTrackingDataDataView>(
        in_hand_tracking_data, hand_tracking_data_fragment);
    fragment->hand_tracking_data.Set(
        hand_tracking_data_fragment.is_null() ? nullptr : hand_tracking_data_fragment.data());
  }

  static bool Deserialize(::device::mojom::internal::XRInputSourceState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRInputSourceStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::VRFieldOfViewDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::VRFieldOfViewDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::VRFieldOfView_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->up_degrees = Traits::up_degrees(input);
    fragment->down_degrees = Traits::down_degrees(input);
    fragment->left_degrees = Traits::left_degrees(input);
    fragment->right_degrees = Traits::right_degrees(input);
  }

  static bool Deserialize(::device::mojom::internal::VRFieldOfView_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::VRFieldOfViewDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::VRPoseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::VRPoseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::VRPose_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::orientation(input)) in_orientation = Traits::orientation(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->orientation)::BaseType> orientation_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::QuaternionDataView>(
        in_orientation, orientation_fragment);
    fragment->orientation.Set(
        orientation_fragment.is_null() ? nullptr : orientation_fragment.data());
    decltype(Traits::position(input)) in_position = Traits::position(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->position)::BaseType> position_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::Point3FDataView>(
        in_position, position_fragment);
    fragment->position.Set(
        position_fragment.is_null() ? nullptr : position_fragment.data());
    fragment->emulated_position = Traits::emulated_position(input);
  }

  static bool Deserialize(::device::mojom::internal::VRPose_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::VRPoseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::PoseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::PoseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::Pose_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::orientation(input)) in_orientation = Traits::orientation(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->orientation)::BaseType> orientation_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::QuaternionDataView>(
        in_orientation, orientation_fragment);
    fragment->orientation.Set(
        orientation_fragment.is_null() ? nullptr : orientation_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->orientation.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null orientation in Pose struct");
    decltype(Traits::position(input)) in_position = Traits::position(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->position)::BaseType> position_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::Point3FDataView>(
        in_position, position_fragment);
    fragment->position.Set(
        position_fragment.is_null() ? nullptr : position_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->position.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null position in Pose struct");
  }

  static bool Deserialize(::device::mojom::internal::Pose_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::PoseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRRayDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRRayDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRRay_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin)::BaseType> origin_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::Point3FDataView>(
        in_origin, origin_fragment);
    fragment->origin.Set(
        origin_fragment.is_null() ? nullptr : origin_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in XRRay struct");
    decltype(Traits::direction(input)) in_direction = Traits::direction(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->direction)::BaseType> direction_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::Vector3dFDataView>(
        in_direction, direction_fragment);
    fragment->direction.Set(
        direction_fragment.is_null() ? nullptr : direction_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->direction.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null direction in XRRay struct");
  }

  static bool Deserialize(::device::mojom::internal::XRRay_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRRayDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRHitResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRHitResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRHitResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::mojo_from_result(input)) in_mojo_from_result = Traits::mojo_from_result(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mojo_from_result)::BaseType> mojo_from_result_fragment(
            fragment.message());
    mojo::internal::Serialize<::device::mojom::PoseDataView>(
        in_mojo_from_result, mojo_from_result_fragment);
    fragment->mojo_from_result.Set(
        mojo_from_result_fragment.is_null() ? nullptr : mojo_from_result_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->mojo_from_result.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mojo_from_result in XRHitResult struct");
    fragment->plane_id = Traits::plane_id(input);
  }

  static bool Deserialize(::device::mojom::internal::XRHitResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRHitResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRViewDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRViewDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRView_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::device::mojom::XREye>(
        Traits::eye(input), &fragment->eye);
    decltype(Traits::field_of_view(input)) in_field_of_view = Traits::field_of_view(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->field_of_view)::BaseType> field_of_view_fragment(
            fragment.message());
    mojo::internal::Serialize<::device::mojom::VRFieldOfViewDataView>(
        in_field_of_view, field_of_view_fragment);
    fragment->field_of_view.Set(
        field_of_view_fragment.is_null() ? nullptr : field_of_view_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->field_of_view.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null field_of_view in XRView struct");
    decltype(Traits::mojo_from_view(input)) in_mojo_from_view = Traits::mojo_from_view(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mojo_from_view)::BaseType> mojo_from_view_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::TransformDataView>(
        in_mojo_from_view, mojo_from_view_fragment);
    fragment->mojo_from_view.Set(
        mojo_from_view_fragment.is_null() ? nullptr : mojo_from_view_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->mojo_from_view.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mojo_from_view in XRView struct");
    decltype(Traits::viewport(input)) in_viewport = Traits::viewport(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->viewport)::BaseType> viewport_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_viewport, viewport_fragment);
    fragment->viewport.Set(
        viewport_fragment.is_null() ? nullptr : viewport_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->viewport.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null viewport in XRView struct");
    decltype(Traits::depth_data(input)) in_depth_data = Traits::depth_data(input);
    mojo::internal::MessageFragment<decltype(fragment->depth_data)>
        depth_data_fragment(fragment.message());
    depth_data_fragment.Claim(&fragment->depth_data);
    mojo::internal::Serialize<::device::mojom::XRDepthDataDataView>(
        in_depth_data, depth_data_fragment, true);
    fragment->is_first_person_observer = Traits::is_first_person_observer(input);
  }

  static bool Deserialize(::device::mojom::internal::XRView_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRViewDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::VRStageParametersDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::VRStageParametersDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::VRStageParameters_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::mojo_from_stage(input)) in_mojo_from_stage = Traits::mojo_from_stage(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mojo_from_stage)::BaseType> mojo_from_stage_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::TransformDataView>(
        in_mojo_from_stage, mojo_from_stage_fragment);
    fragment->mojo_from_stage.Set(
        mojo_from_stage_fragment.is_null() ? nullptr : mojo_from_stage_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->mojo_from_stage.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mojo_from_stage in VRStageParameters struct");
    decltype(Traits::bounds(input)) in_bounds = Traits::bounds(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bounds)::BaseType>
        bounds_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& bounds_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::Point3FDataView>>(
        in_bounds, bounds_fragment, &bounds_validate_params);
    fragment->bounds.Set(
        bounds_fragment.is_null() ? nullptr : bounds_fragment.data());
  }

  static bool Deserialize(::device::mojom::internal::VRStageParameters_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::VRStageParametersDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRPresentationTransportOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRPresentationTransportOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRPresentationTransportOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::device::mojom::XRPresentationTransportMethod>(
        Traits::transport_method(input), &fragment->transport_method);
    fragment->wait_for_transfer_notification = Traits::wait_for_transfer_notification(input);
    fragment->wait_for_render_notification = Traits::wait_for_render_notification(input);
    fragment->wait_for_gpu_fence = Traits::wait_for_gpu_fence(input);
  }

  static bool Deserialize(::device::mojom::internal::XRPresentationTransportOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRPresentationTransportOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRInputSourceSpaceInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRInputSourceSpaceInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRInputSourceSpaceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->input_source_id = Traits::input_source_id(input);
    mojo::internal::Serialize<::device::mojom::XRInputSourceSpaceType>(
        Traits::input_source_space_type(input), &fragment->input_source_space_type);
  }

  static bool Deserialize(::device::mojom::internal::XRInputSourceSpaceInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRInputSourceSpaceInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRHandJointSpaceInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRHandJointSpaceInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRHandJointSpaceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::device::mojom::XRHandedness>(
        Traits::handedness(input), &fragment->handedness);
    mojo::internal::Serialize<::device::mojom::XRHandJoint>(
        Traits::joint(input), &fragment->joint);
  }

  static bool Deserialize(::device::mojom::internal::XRHandJointSpaceInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRHandJointSpaceInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRPlanePointDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRPlanePointDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRPlanePointData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->x = Traits::x(input);
    fragment->z = Traits::z(input);
  }

  static bool Deserialize(::device::mojom::internal::XRPlanePointData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRPlanePointDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRPlaneDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRPlaneDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRPlaneData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->id = Traits::id(input);
    mojo::internal::Serialize<::device::mojom::XRPlaneOrientation>(
        Traits::orientation(input), &fragment->orientation);
    decltype(Traits::mojo_from_plane(input)) in_mojo_from_plane = Traits::mojo_from_plane(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mojo_from_plane)::BaseType> mojo_from_plane_fragment(
            fragment.message());
    mojo::internal::Serialize<::device::mojom::PoseDataView>(
        in_mojo_from_plane, mojo_from_plane_fragment);
    fragment->mojo_from_plane.Set(
        mojo_from_plane_fragment.is_null() ? nullptr : mojo_from_plane_fragment.data());
    decltype(Traits::polygon(input)) in_polygon = Traits::polygon(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->polygon)::BaseType>
        polygon_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& polygon_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRPlanePointDataDataView>>(
        in_polygon, polygon_fragment, &polygon_validate_params);
    fragment->polygon.Set(
        polygon_fragment.is_null() ? nullptr : polygon_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->polygon.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null polygon in XRPlaneData struct");
  }

  static bool Deserialize(::device::mojom::internal::XRPlaneData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRPlaneDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRPlaneDetectionDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRPlaneDetectionDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRPlaneDetectionData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::all_planes_ids(input)) in_all_planes_ids = Traits::all_planes_ids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->all_planes_ids)::BaseType>
        all_planes_ids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& all_planes_ids_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint64_t>>(
        in_all_planes_ids, all_planes_ids_fragment, &all_planes_ids_validate_params);
    fragment->all_planes_ids.Set(
        all_planes_ids_fragment.is_null() ? nullptr : all_planes_ids_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->all_planes_ids.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null all_planes_ids in XRPlaneDetectionData struct");
    decltype(Traits::updated_planes_data(input)) in_updated_planes_data = Traits::updated_planes_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->updated_planes_data)::BaseType>
        updated_planes_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& updated_planes_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRPlaneDataDataView>>(
        in_updated_planes_data, updated_planes_data_fragment, &updated_planes_data_validate_params);
    fragment->updated_planes_data.Set(
        updated_planes_data_fragment.is_null() ? nullptr : updated_planes_data_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->updated_planes_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null updated_planes_data in XRPlaneDetectionData struct");
  }

  static bool Deserialize(::device::mojom::internal::XRPlaneDetectionData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRPlaneDetectionDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRAnchorDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRAnchorDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRAnchorData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->id = Traits::id(input);
    decltype(Traits::mojo_from_anchor(input)) in_mojo_from_anchor = Traits::mojo_from_anchor(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mojo_from_anchor)::BaseType> mojo_from_anchor_fragment(
            fragment.message());
    mojo::internal::Serialize<::device::mojom::PoseDataView>(
        in_mojo_from_anchor, mojo_from_anchor_fragment);
    fragment->mojo_from_anchor.Set(
        mojo_from_anchor_fragment.is_null() ? nullptr : mojo_from_anchor_fragment.data());
  }

  static bool Deserialize(::device::mojom::internal::XRAnchorData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRAnchorDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRAnchorsDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRAnchorsDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRAnchorsData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::all_anchors_ids(input)) in_all_anchors_ids = Traits::all_anchors_ids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->all_anchors_ids)::BaseType>
        all_anchors_ids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& all_anchors_ids_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint64_t>>(
        in_all_anchors_ids, all_anchors_ids_fragment, &all_anchors_ids_validate_params);
    fragment->all_anchors_ids.Set(
        all_anchors_ids_fragment.is_null() ? nullptr : all_anchors_ids_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->all_anchors_ids.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null all_anchors_ids in XRAnchorsData struct");
    decltype(Traits::updated_anchors_data(input)) in_updated_anchors_data = Traits::updated_anchors_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->updated_anchors_data)::BaseType>
        updated_anchors_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& updated_anchors_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRAnchorDataDataView>>(
        in_updated_anchors_data, updated_anchors_data_fragment, &updated_anchors_data_validate_params);
    fragment->updated_anchors_data.Set(
        updated_anchors_data_fragment.is_null() ? nullptr : updated_anchors_data_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->updated_anchors_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null updated_anchors_data in XRAnchorsData struct");
  }

  static bool Deserialize(::device::mojom::internal::XRAnchorsData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRAnchorsDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRHitTestSubscriptionResultDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRHitTestSubscriptionResultDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRHitTestSubscriptionResultData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->subscription_id = Traits::subscription_id(input);
    decltype(Traits::hit_test_results(input)) in_hit_test_results = Traits::hit_test_results(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hit_test_results)::BaseType>
        hit_test_results_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& hit_test_results_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRHitResultDataView>>(
        in_hit_test_results, hit_test_results_fragment, &hit_test_results_validate_params);
    fragment->hit_test_results.Set(
        hit_test_results_fragment.is_null() ? nullptr : hit_test_results_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->hit_test_results.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hit_test_results in XRHitTestSubscriptionResultData struct");
  }

  static bool Deserialize(::device::mojom::internal::XRHitTestSubscriptionResultData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRHitTestSubscriptionResultDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRHitTestTransientInputSubscriptionResultDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRHitTestTransientInputSubscriptionResultDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRHitTestTransientInputSubscriptionResultData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->subscription_id = Traits::subscription_id(input);
    decltype(Traits::input_source_id_to_hit_test_results(input)) in_input_source_id_to_hit_test_results = Traits::input_source_id_to_hit_test_results(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_source_id_to_hit_test_results)::BaseType>
        input_source_id_to_hit_test_results_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& input_source_id_to_hit_test_results_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    mojo::internal::Serialize<mojo::MapDataView<uint32_t, mojo::ArrayDataView<::device::mojom::XRHitResultDataView>>>(
        in_input_source_id_to_hit_test_results, input_source_id_to_hit_test_results_fragment, &input_source_id_to_hit_test_results_validate_params);
    fragment->input_source_id_to_hit_test_results.Set(
        input_source_id_to_hit_test_results_fragment.is_null() ? nullptr : input_source_id_to_hit_test_results_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->input_source_id_to_hit_test_results.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null input_source_id_to_hit_test_results in XRHitTestTransientInputSubscriptionResultData struct");
  }

  static bool Deserialize(::device::mojom::internal::XRHitTestTransientInputSubscriptionResultData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRHitTestTransientInputSubscriptionResultDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRHitTestSubscriptionResultsDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRHitTestSubscriptionResultsDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRHitTestSubscriptionResultsData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::results(input)) in_results = Traits::results(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->results)::BaseType>
        results_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& results_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRHitTestSubscriptionResultDataDataView>>(
        in_results, results_fragment, &results_validate_params);
    fragment->results.Set(
        results_fragment.is_null() ? nullptr : results_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->results.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null results in XRHitTestSubscriptionResultsData struct");
    decltype(Traits::transient_input_results(input)) in_transient_input_results = Traits::transient_input_results(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->transient_input_results)::BaseType>
        transient_input_results_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& transient_input_results_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRHitTestTransientInputSubscriptionResultDataDataView>>(
        in_transient_input_results, transient_input_results_fragment, &transient_input_results_validate_params);
    fragment->transient_input_results.Set(
        transient_input_results_fragment.is_null() ? nullptr : transient_input_results_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->transient_input_results.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null transient_input_results in XRHitTestSubscriptionResultsData struct");
  }

  static bool Deserialize(::device::mojom::internal::XRHitTestSubscriptionResultsData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRHitTestSubscriptionResultsDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::RgbTupleF32DataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::RgbTupleF32DataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::RgbTupleF32_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->red = Traits::red(input);
    fragment->green = Traits::green(input);
    fragment->blue = Traits::blue(input);
  }

  static bool Deserialize(::device::mojom::internal::RgbTupleF32_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::RgbTupleF32DataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRSphericalHarmonicsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRSphericalHarmonicsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRSphericalHarmonics_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::coefficients(input)) in_coefficients = Traits::coefficients(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->coefficients)::BaseType>
        coefficients_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& coefficients_validate_params =
        mojo::internal::GetArrayValidator<9, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::RgbTupleF32DataView>>(
        in_coefficients, coefficients_fragment, &coefficients_validate_params);
    fragment->coefficients.Set(
        coefficients_fragment.is_null() ? nullptr : coefficients_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->coefficients.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null coefficients in XRSphericalHarmonics struct");
  }

  static bool Deserialize(::device::mojom::internal::XRSphericalHarmonics_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRSphericalHarmonicsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::RgbaTupleF16DataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::RgbaTupleF16DataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::RgbaTupleF16_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->red = Traits::red(input);
    fragment->green = Traits::green(input);
    fragment->blue = Traits::blue(input);
    fragment->alpha = Traits::alpha(input);
  }

  static bool Deserialize(::device::mojom::internal::RgbaTupleF16_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::RgbaTupleF16DataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRCubeMapDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRCubeMapDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRCubeMap_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->width_and_height = Traits::width_and_height(input);
    decltype(Traits::positive_x(input)) in_positive_x = Traits::positive_x(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->positive_x)::BaseType>
        positive_x_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& positive_x_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::RgbaTupleF16DataView>>(
        in_positive_x, positive_x_fragment, &positive_x_validate_params);
    fragment->positive_x.Set(
        positive_x_fragment.is_null() ? nullptr : positive_x_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->positive_x.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null positive_x in XRCubeMap struct");
    decltype(Traits::negative_x(input)) in_negative_x = Traits::negative_x(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->negative_x)::BaseType>
        negative_x_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& negative_x_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::RgbaTupleF16DataView>>(
        in_negative_x, negative_x_fragment, &negative_x_validate_params);
    fragment->negative_x.Set(
        negative_x_fragment.is_null() ? nullptr : negative_x_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->negative_x.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null negative_x in XRCubeMap struct");
    decltype(Traits::positive_y(input)) in_positive_y = Traits::positive_y(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->positive_y)::BaseType>
        positive_y_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& positive_y_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::RgbaTupleF16DataView>>(
        in_positive_y, positive_y_fragment, &positive_y_validate_params);
    fragment->positive_y.Set(
        positive_y_fragment.is_null() ? nullptr : positive_y_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->positive_y.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null positive_y in XRCubeMap struct");
    decltype(Traits::negative_y(input)) in_negative_y = Traits::negative_y(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->negative_y)::BaseType>
        negative_y_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& negative_y_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::RgbaTupleF16DataView>>(
        in_negative_y, negative_y_fragment, &negative_y_validate_params);
    fragment->negative_y.Set(
        negative_y_fragment.is_null() ? nullptr : negative_y_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->negative_y.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null negative_y in XRCubeMap struct");
    decltype(Traits::positive_z(input)) in_positive_z = Traits::positive_z(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->positive_z)::BaseType>
        positive_z_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& positive_z_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::RgbaTupleF16DataView>>(
        in_positive_z, positive_z_fragment, &positive_z_validate_params);
    fragment->positive_z.Set(
        positive_z_fragment.is_null() ? nullptr : positive_z_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->positive_z.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null positive_z in XRCubeMap struct");
    decltype(Traits::negative_z(input)) in_negative_z = Traits::negative_z(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->negative_z)::BaseType>
        negative_z_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& negative_z_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::RgbaTupleF16DataView>>(
        in_negative_z, negative_z_fragment, &negative_z_validate_params);
    fragment->negative_z.Set(
        negative_z_fragment.is_null() ? nullptr : negative_z_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->negative_z.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null negative_z in XRCubeMap struct");
  }

  static bool Deserialize(::device::mojom::internal::XRCubeMap_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRCubeMapDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRLightProbeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRLightProbeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRLightProbe_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::spherical_harmonics(input)) in_spherical_harmonics = Traits::spherical_harmonics(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->spherical_harmonics)::BaseType> spherical_harmonics_fragment(
            fragment.message());
    mojo::internal::Serialize<::device::mojom::XRSphericalHarmonicsDataView>(
        in_spherical_harmonics, spherical_harmonics_fragment);
    fragment->spherical_harmonics.Set(
        spherical_harmonics_fragment.is_null() ? nullptr : spherical_harmonics_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->spherical_harmonics.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null spherical_harmonics in XRLightProbe struct");
    decltype(Traits::main_light_direction(input)) in_main_light_direction = Traits::main_light_direction(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->main_light_direction)::BaseType> main_light_direction_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::Vector3dFDataView>(
        in_main_light_direction, main_light_direction_fragment);
    fragment->main_light_direction.Set(
        main_light_direction_fragment.is_null() ? nullptr : main_light_direction_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->main_light_direction.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null main_light_direction in XRLightProbe struct");
    decltype(Traits::main_light_intensity(input)) in_main_light_intensity = Traits::main_light_intensity(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->main_light_intensity)::BaseType> main_light_intensity_fragment(
            fragment.message());
    mojo::internal::Serialize<::device::mojom::RgbTupleF32DataView>(
        in_main_light_intensity, main_light_intensity_fragment);
    fragment->main_light_intensity.Set(
        main_light_intensity_fragment.is_null() ? nullptr : main_light_intensity_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->main_light_intensity.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null main_light_intensity in XRLightProbe struct");
  }

  static bool Deserialize(::device::mojom::internal::XRLightProbe_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRLightProbeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRReflectionProbeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRReflectionProbeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRReflectionProbe_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::cube_map(input)) in_cube_map = Traits::cube_map(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cube_map)::BaseType> cube_map_fragment(
            fragment.message());
    mojo::internal::Serialize<::device::mojom::XRCubeMapDataView>(
        in_cube_map, cube_map_fragment);
    fragment->cube_map.Set(
        cube_map_fragment.is_null() ? nullptr : cube_map_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->cube_map.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cube_map in XRReflectionProbe struct");
  }

  static bool Deserialize(::device::mojom::internal::XRReflectionProbe_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRReflectionProbeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRLightEstimationDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRLightEstimationDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRLightEstimationData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::light_probe(input)) in_light_probe = Traits::light_probe(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->light_probe)::BaseType> light_probe_fragment(
            fragment.message());
    mojo::internal::Serialize<::device::mojom::XRLightProbeDataView>(
        in_light_probe, light_probe_fragment);
    fragment->light_probe.Set(
        light_probe_fragment.is_null() ? nullptr : light_probe_fragment.data());
    decltype(Traits::reflection_probe(input)) in_reflection_probe = Traits::reflection_probe(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->reflection_probe)::BaseType> reflection_probe_fragment(
            fragment.message());
    mojo::internal::Serialize<::device::mojom::XRReflectionProbeDataView>(
        in_reflection_probe, reflection_probe_fragment);
    fragment->reflection_probe.Set(
        reflection_probe_fragment.is_null() ? nullptr : reflection_probe_fragment.data());
  }

  static bool Deserialize(::device::mojom::internal::XRLightEstimationData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRLightEstimationDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRDepthDataStillValidDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRDepthDataStillValidDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRDepthDataStillValid_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }

  static bool Deserialize(::device::mojom::internal::XRDepthDataStillValid_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRDepthDataStillValidDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRDepthDataUpdatedDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRDepthDataUpdatedDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRDepthDataUpdated_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::pixel_data(input)) in_pixel_data = Traits::pixel_data(input);
    mojo::internal::MessageFragment<decltype(fragment->pixel_data)>
        pixel_data_fragment(fragment.message());
    pixel_data_fragment.Claim(&fragment->pixel_data);
    mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
        in_pixel_data, pixel_data_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->pixel_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pixel_data in XRDepthDataUpdated struct");
    decltype(Traits::norm_texture_from_norm_view(input)) in_norm_texture_from_norm_view = Traits::norm_texture_from_norm_view(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->norm_texture_from_norm_view)::BaseType> norm_texture_from_norm_view_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::TransformDataView>(
        in_norm_texture_from_norm_view, norm_texture_from_norm_view_fragment);
    fragment->norm_texture_from_norm_view.Set(
        norm_texture_from_norm_view_fragment.is_null() ? nullptr : norm_texture_from_norm_view_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->norm_texture_from_norm_view.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null norm_texture_from_norm_view in XRDepthDataUpdated struct");
    decltype(Traits::size(input)) in_size = Traits::size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->size)::BaseType> size_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_size, size_fragment);
    fragment->size.Set(
        size_fragment.is_null() ? nullptr : size_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null size in XRDepthDataUpdated struct");
    fragment->raw_value_to_meters = Traits::raw_value_to_meters(input);
  }

  static bool Deserialize(::device::mojom::internal::XRDepthDataUpdated_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRDepthDataUpdatedDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRTrackedImageDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRTrackedImageDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRTrackedImageData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->index = Traits::index(input);
    decltype(Traits::mojo_from_image(input)) in_mojo_from_image = Traits::mojo_from_image(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mojo_from_image)::BaseType> mojo_from_image_fragment(
            fragment.message());
    mojo::internal::Serialize<::device::mojom::PoseDataView>(
        in_mojo_from_image, mojo_from_image_fragment);
    fragment->mojo_from_image.Set(
        mojo_from_image_fragment.is_null() ? nullptr : mojo_from_image_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->mojo_from_image.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mojo_from_image in XRTrackedImageData struct");
    fragment->actively_tracked = Traits::actively_tracked(input);
    fragment->width_in_meters = Traits::width_in_meters(input);
  }

  static bool Deserialize(::device::mojom::internal::XRTrackedImageData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRTrackedImageDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRTrackedImagesDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRTrackedImagesDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRTrackedImagesData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::images_data(input)) in_images_data = Traits::images_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->images_data)::BaseType>
        images_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& images_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRTrackedImageDataDataView>>(
        in_images_data, images_data_fragment, &images_data_validate_params);
    fragment->images_data.Set(
        images_data_fragment.is_null() ? nullptr : images_data_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->images_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null images_data in XRTrackedImagesData struct");
    decltype(Traits::image_trackable_scores(input)) in_image_trackable_scores = Traits::image_trackable_scores(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->image_trackable_scores)::BaseType>
        image_trackable_scores_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& image_trackable_scores_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<bool>>(
        in_image_trackable_scores, image_trackable_scores_fragment, &image_trackable_scores_validate_params);
    fragment->image_trackable_scores.Set(
        image_trackable_scores_fragment.is_null() ? nullptr : image_trackable_scores_fragment.data());
  }

  static bool Deserialize(::device::mojom::internal::XRTrackedImagesData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRTrackedImagesDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRFrameDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRFrameDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRFrameData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::mojo_from_viewer(input)) in_mojo_from_viewer = Traits::mojo_from_viewer(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mojo_from_viewer)::BaseType> mojo_from_viewer_fragment(
            fragment.message());
    mojo::internal::Serialize<::device::mojom::VRPoseDataView>(
        in_mojo_from_viewer, mojo_from_viewer_fragment);
    fragment->mojo_from_viewer.Set(
        mojo_from_viewer_fragment.is_null() ? nullptr : mojo_from_viewer_fragment.data());
    decltype(Traits::time_delta(input)) in_time_delta = Traits::time_delta(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->time_delta)::BaseType> time_delta_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_time_delta, time_delta_fragment);
    fragment->time_delta.Set(
        time_delta_fragment.is_null() ? nullptr : time_delta_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->time_delta.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null time_delta in XRFrameData struct");
    decltype(Traits::buffer_shared_image(input)) in_buffer_shared_image = Traits::buffer_shared_image(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->buffer_shared_image)::BaseType> buffer_shared_image_fragment(
            fragment.message());
    mojo::internal::Serialize<::gpu::mojom::ExportedSharedImageDataView>(
        in_buffer_shared_image, buffer_shared_image_fragment);
    fragment->buffer_shared_image.Set(
        buffer_shared_image_fragment.is_null() ? nullptr : buffer_shared_image_fragment.data());
    decltype(Traits::buffer_sync_token(input)) in_buffer_sync_token = Traits::buffer_sync_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->buffer_sync_token)::BaseType> buffer_sync_token_fragment(
            fragment.message());
    mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView>(
        in_buffer_sync_token, buffer_sync_token_fragment);
    fragment->buffer_sync_token.Set(
        buffer_sync_token_fragment.is_null() ? nullptr : buffer_sync_token_fragment.data());
    decltype(Traits::camera_image_buffer_shared_image(input)) in_camera_image_buffer_shared_image = Traits::camera_image_buffer_shared_image(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->camera_image_buffer_shared_image)::BaseType> camera_image_buffer_shared_image_fragment(
            fragment.message());
    mojo::internal::Serialize<::gpu::mojom::ExportedSharedImageDataView>(
        in_camera_image_buffer_shared_image, camera_image_buffer_shared_image_fragment);
    fragment->camera_image_buffer_shared_image.Set(
        camera_image_buffer_shared_image_fragment.is_null() ? nullptr : camera_image_buffer_shared_image_fragment.data());
    decltype(Traits::camera_image_buffer_sync_token(input)) in_camera_image_buffer_sync_token = Traits::camera_image_buffer_sync_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->camera_image_buffer_sync_token)::BaseType> camera_image_buffer_sync_token_fragment(
            fragment.message());
    mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView>(
        in_camera_image_buffer_sync_token, camera_image_buffer_sync_token_fragment);
    fragment->camera_image_buffer_sync_token.Set(
        camera_image_buffer_sync_token_fragment.is_null() ? nullptr : camera_image_buffer_sync_token_fragment.data());
    decltype(Traits::camera_image_size(input)) in_camera_image_size = Traits::camera_image_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->camera_image_size)::BaseType> camera_image_size_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_camera_image_size, camera_image_size_fragment);
    fragment->camera_image_size.Set(
        camera_image_size_fragment.is_null() ? nullptr : camera_image_size_fragment.data());
    fragment->mojo_space_reset = Traits::mojo_space_reset(input);
    decltype(Traits::mojo_from_floor(input)) in_mojo_from_floor = Traits::mojo_from_floor(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mojo_from_floor)::BaseType> mojo_from_floor_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::TransformDataView>(
        in_mojo_from_floor, mojo_from_floor_fragment);
    fragment->mojo_from_floor.Set(
        mojo_from_floor_fragment.is_null() ? nullptr : mojo_from_floor_fragment.data());
    fragment->frame_id = Traits::frame_id(input);
    decltype(Traits::views(input)) in_views = Traits::views(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->views)::BaseType>
        views_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& views_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRViewDataView>>(
        in_views, views_fragment, &views_validate_params);
    fragment->views.Set(
        views_fragment.is_null() ? nullptr : views_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->views.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null views in XRFrameData struct");
    decltype(Traits::input_state(input)) in_input_state = Traits::input_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_state)::BaseType>
        input_state_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& input_state_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRInputSourceStateDataView>>(
        in_input_state, input_state_fragment, &input_state_validate_params);
    fragment->input_state.Set(
        input_state_fragment.is_null() ? nullptr : input_state_fragment.data());
    fragment->stage_parameters_id = Traits::stage_parameters_id(input);
    decltype(Traits::stage_parameters(input)) in_stage_parameters = Traits::stage_parameters(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->stage_parameters)::BaseType> stage_parameters_fragment(
            fragment.message());
    mojo::internal::Serialize<::device::mojom::VRStageParametersDataView>(
        in_stage_parameters, stage_parameters_fragment);
    fragment->stage_parameters.Set(
        stage_parameters_fragment.is_null() ? nullptr : stage_parameters_fragment.data());
    decltype(Traits::detected_planes_data(input)) in_detected_planes_data = Traits::detected_planes_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->detected_planes_data)::BaseType> detected_planes_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::device::mojom::XRPlaneDetectionDataDataView>(
        in_detected_planes_data, detected_planes_data_fragment);
    fragment->detected_planes_data.Set(
        detected_planes_data_fragment.is_null() ? nullptr : detected_planes_data_fragment.data());
    decltype(Traits::anchors_data(input)) in_anchors_data = Traits::anchors_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->anchors_data)::BaseType> anchors_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::device::mojom::XRAnchorsDataDataView>(
        in_anchors_data, anchors_data_fragment);
    fragment->anchors_data.Set(
        anchors_data_fragment.is_null() ? nullptr : anchors_data_fragment.data());
    decltype(Traits::light_estimation_data(input)) in_light_estimation_data = Traits::light_estimation_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->light_estimation_data)::BaseType> light_estimation_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::device::mojom::XRLightEstimationDataDataView>(
        in_light_estimation_data, light_estimation_data_fragment);
    fragment->light_estimation_data.Set(
        light_estimation_data_fragment.is_null() ? nullptr : light_estimation_data_fragment.data());
    decltype(Traits::hit_test_subscription_results(input)) in_hit_test_subscription_results = Traits::hit_test_subscription_results(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hit_test_subscription_results)::BaseType> hit_test_subscription_results_fragment(
            fragment.message());
    mojo::internal::Serialize<::device::mojom::XRHitTestSubscriptionResultsDataDataView>(
        in_hit_test_subscription_results, hit_test_subscription_results_fragment);
    fragment->hit_test_subscription_results.Set(
        hit_test_subscription_results_fragment.is_null() ? nullptr : hit_test_subscription_results_fragment.data());
    fragment->rendering_time_ratio = Traits::rendering_time_ratio(input);
    decltype(Traits::tracked_images(input)) in_tracked_images = Traits::tracked_images(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tracked_images)::BaseType> tracked_images_fragment(
            fragment.message());
    mojo::internal::Serialize<::device::mojom::XRTrackedImagesDataDataView>(
        in_tracked_images, tracked_images_fragment);
    fragment->tracked_images.Set(
        tracked_images_fragment.is_null() ? nullptr : tracked_images_fragment.data());
  }

  static bool Deserialize(::device::mojom::internal::XRFrameData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRFrameDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::RequestSessionSuccessDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::RequestSessionSuccessDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::RequestSessionSuccess_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::session(input)) in_session = Traits::session(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->session)::BaseType> session_fragment(
            fragment.message());
    mojo::internal::Serialize<::device::mojom::XRSessionDataView>(
        in_session, session_fragment);
    fragment->session.Set(
        session_fragment.is_null() ? nullptr : session_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->session.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null session in RequestSessionSuccess struct");
    fragment->trace_id = Traits::trace_id(input);
    decltype(Traits::metrics_recorder(input)) in_metrics_recorder = Traits::metrics_recorder(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::XRSessionMetricsRecorderInterfaceBase>>(
        in_metrics_recorder, &fragment->metrics_recorder, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->metrics_recorder),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid metrics_recorder in RequestSessionSuccess struct");
    decltype(Traits::xr_internals_listener(input)) in_xr_internals_listener = Traits::xr_internals_listener(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::WebXrInternalsRendererListenerInterfaceBase>>(
        in_xr_internals_listener, &fragment->xr_internals_listener, &fragment.message());
  }

  static bool Deserialize(::device::mojom::internal::RequestSessionSuccess_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::RequestSessionSuccessDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRFrameDataRequestOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRFrameDataRequestOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRFrameDataRequestOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->include_lighting_estimation_data = Traits::include_lighting_estimation_data(input);
    fragment->stage_parameters_id = Traits::stage_parameters_id(input);
  }

  static bool Deserialize(::device::mojom::internal::XRFrameDataRequestOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRFrameDataRequestOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRNativeOriginInformationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::XRNativeOriginInformationDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::XRNativeOriginInformation_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::device::mojom::XRNativeOriginInformationDataView::Tag::kInputSourceSpaceInfo: {
        decltype(Traits::input_source_space_info(input))
            in_input_source_space_info = Traits::input_source_space_info(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_input_source_space_info)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::device::mojom::XRInputSourceSpaceInfoDataView>(
            in_input_source_space_info, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null input_source_space_info in XRNativeOriginInformation union");
        fragment->data.f_input_source_space_info.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::device::mojom::XRNativeOriginInformationDataView::Tag::kPlaneId: {
        decltype(Traits::plane_id(input))
            in_plane_id = Traits::plane_id(input);
        fragment->data.f_plane_id = in_plane_id;
        break;
      }
      case ::device::mojom::XRNativeOriginInformationDataView::Tag::kAnchorId: {
        decltype(Traits::anchor_id(input))
            in_anchor_id = Traits::anchor_id(input);
        fragment->data.f_anchor_id = in_anchor_id;
        break;
      }
      case ::device::mojom::XRNativeOriginInformationDataView::Tag::kReferenceSpaceType: {
        decltype(Traits::reference_space_type(input))
            in_reference_space_type = Traits::reference_space_type(input);
        mojo::internal::Serialize<::device::mojom::XRReferenceSpaceType>(
            in_reference_space_type, &fragment->data.f_reference_space_type);
        break;
      }
      case ::device::mojom::XRNativeOriginInformationDataView::Tag::kHandJointSpaceInfo: {
        decltype(Traits::hand_joint_space_info(input))
            in_hand_joint_space_info = Traits::hand_joint_space_info(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_hand_joint_space_info)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::device::mojom::XRHandJointSpaceInfoDataView>(
            in_hand_joint_space_info, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null hand_joint_space_info in XRNativeOriginInformation union");
        fragment->data.f_hand_joint_space_info.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::device::mojom::XRNativeOriginInformationDataView::Tag::kImageIndex: {
        decltype(Traits::image_index(input))
            in_image_index = Traits::image_index(input);
        fragment->data.f_image_index = in_image_index;
        break;
      }
    }
  }

  static bool Deserialize(::device::mojom::internal::XRNativeOriginInformation_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRNativeOriginInformationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRDepthDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::XRDepthDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::XRDepthData_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::device::mojom::XRDepthDataDataView::Tag::kDataStillValid: {
        decltype(Traits::data_still_valid(input))
            in_data_still_valid = Traits::data_still_valid(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_data_still_valid)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::device::mojom::XRDepthDataStillValidDataView>(
            in_data_still_valid, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null data_still_valid in XRDepthData union");
        fragment->data.f_data_still_valid.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::device::mojom::XRDepthDataDataView::Tag::kUpdatedDepthData: {
        decltype(Traits::updated_depth_data(input))
            in_updated_depth_data = Traits::updated_depth_data(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_updated_depth_data)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::device::mojom::XRDepthDataUpdatedDataView>(
            in_updated_depth_data, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null updated_depth_data in XRDepthData union");
        fragment->data.f_updated_depth_data.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::device::mojom::internal::XRDepthData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRDepthDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::RequestSessionResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::RequestSessionResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::RequestSessionResult_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::device::mojom::RequestSessionResultDataView::Tag::kSuccess: {
        decltype(Traits::success(input))
            in_success = Traits::success(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_success)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::device::mojom::RequestSessionSuccessDataView>(
            in_success, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null success in RequestSessionResult union");
        fragment->data.f_success.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::device::mojom::RequestSessionResultDataView::Tag::kFailureReason: {
        decltype(Traits::failure_reason(input))
            in_failure_reason = Traits::failure_reason(input);
        mojo::internal::Serialize<::device::mojom::RequestSessionError>(
            in_failure_reason, &fragment->data.f_failure_reason);
        break;
      }
    }
  }

  static bool Deserialize(::device::mojom::internal::RequestSessionResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::RequestSessionResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace device::mojom {



inline void XRSessionDeviceConfigDataView::GetViewsDataView(
    mojo::ArrayDataView<XRViewDataView>* output) {
  auto pointer = data_->views.Get();
  *output = mojo::ArrayDataView<XRViewDataView>(pointer, message_);
}
inline void XRSessionDeviceConfigDataView::GetDepthConfigurationDataView(
    XRDepthConfigDataView* output) {
  auto pointer = data_->depth_configuration.Get();
  *output = XRDepthConfigDataView(pointer, message_);
}


inline void XRSessionDataView::GetSubmitFrameSinkDataView(
    XRPresentationConnectionDataView* output) {
  auto pointer = data_->submit_frame_sink.Get();
  *output = XRPresentationConnectionDataView(pointer, message_);
}
inline void XRSessionDataView::GetEnabledFeaturesDataView(
    mojo::ArrayDataView<::device::mojom::XRSessionFeature>* output) {
  auto pointer = data_->enabled_features.Get();
  *output = mojo::ArrayDataView<::device::mojom::XRSessionFeature>(pointer, message_);
}
inline void XRSessionDataView::GetDeviceConfigDataView(
    XRSessionDeviceConfigDataView* output) {
  auto pointer = data_->device_config.Get();
  *output = XRSessionDeviceConfigDataView(pointer, message_);
}


inline void XRPresentationConnectionDataView::GetTransportOptionsDataView(
    XRPresentationTransportOptionsDataView* output) {
  auto pointer = data_->transport_options.Get();
  *output = XRPresentationTransportOptionsDataView(pointer, message_);
}


inline void XRInputSourceDescriptionDataView::GetInputFromPointerDataView(
    ::gfx::mojom::TransformDataView* output) {
  auto pointer = data_->input_from_pointer.Get();
  *output = ::gfx::mojom::TransformDataView(pointer, message_);
}
inline void XRInputSourceDescriptionDataView::GetProfilesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->profiles.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}


inline void XRInputSourceStateDataView::GetDescriptionDataView(
    XRInputSourceDescriptionDataView* output) {
  auto pointer = data_->description.Get();
  *output = XRInputSourceDescriptionDataView(pointer, message_);
}
inline void XRInputSourceStateDataView::GetMojoFromInputDataView(
    ::gfx::mojom::TransformDataView* output) {
  auto pointer = data_->mojo_from_input.Get();
  *output = ::gfx::mojom::TransformDataView(pointer, message_);
}
inline void XRInputSourceStateDataView::GetGamepadDataView(
    ::device::mojom::GamepadDataView* output) {
  auto pointer = data_->gamepad.Get();
  *output = ::device::mojom::GamepadDataView(pointer, message_);
}
inline void XRInputSourceStateDataView::GetOverlayPointerPositionDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->overlay_pointer_position.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}
inline void XRInputSourceStateDataView::GetHandTrackingDataDataView(
    ::device::mojom::XRHandTrackingDataDataView* output) {
  auto pointer = data_->hand_tracking_data.Get();
  *output = ::device::mojom::XRHandTrackingDataDataView(pointer, message_);
}




inline void VRPoseDataView::GetOrientationDataView(
    ::gfx::mojom::QuaternionDataView* output) {
  auto pointer = data_->orientation.Get();
  *output = ::gfx::mojom::QuaternionDataView(pointer, message_);
}
inline void VRPoseDataView::GetPositionDataView(
    ::gfx::mojom::Point3FDataView* output) {
  auto pointer = data_->position.Get();
  *output = ::gfx::mojom::Point3FDataView(pointer, message_);
}


inline void PoseDataView::GetOrientationDataView(
    ::gfx::mojom::QuaternionDataView* output) {
  auto pointer = data_->orientation.Get();
  *output = ::gfx::mojom::QuaternionDataView(pointer, message_);
}
inline void PoseDataView::GetPositionDataView(
    ::gfx::mojom::Point3FDataView* output) {
  auto pointer = data_->position.Get();
  *output = ::gfx::mojom::Point3FDataView(pointer, message_);
}


inline void XRRayDataView::GetOriginDataView(
    ::gfx::mojom::Point3FDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::gfx::mojom::Point3FDataView(pointer, message_);
}
inline void XRRayDataView::GetDirectionDataView(
    ::gfx::mojom::Vector3dFDataView* output) {
  auto pointer = data_->direction.Get();
  *output = ::gfx::mojom::Vector3dFDataView(pointer, message_);
}


inline void XRHitResultDataView::GetMojoFromResultDataView(
    PoseDataView* output) {
  auto pointer = data_->mojo_from_result.Get();
  *output = PoseDataView(pointer, message_);
}


inline void XRViewDataView::GetFieldOfViewDataView(
    VRFieldOfViewDataView* output) {
  auto pointer = data_->field_of_view.Get();
  *output = VRFieldOfViewDataView(pointer, message_);
}
inline void XRViewDataView::GetMojoFromViewDataView(
    ::gfx::mojom::TransformDataView* output) {
  auto pointer = data_->mojo_from_view.Get();
  *output = ::gfx::mojom::TransformDataView(pointer, message_);
}
inline void XRViewDataView::GetViewportDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->viewport.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void XRViewDataView::GetDepthDataDataView(
    XRDepthDataDataView* output) {
  auto pointer = &data_->depth_data;
  *output = XRDepthDataDataView(pointer, message_);
}


inline void VRStageParametersDataView::GetMojoFromStageDataView(
    ::gfx::mojom::TransformDataView* output) {
  auto pointer = data_->mojo_from_stage.Get();
  *output = ::gfx::mojom::TransformDataView(pointer, message_);
}
inline void VRStageParametersDataView::GetBoundsDataView(
    mojo::ArrayDataView<::gfx::mojom::Point3FDataView>* output) {
  auto pointer = data_->bounds.Get();
  *output = mojo::ArrayDataView<::gfx::mojom::Point3FDataView>(pointer, message_);
}










inline void XRPlaneDataDataView::GetMojoFromPlaneDataView(
    PoseDataView* output) {
  auto pointer = data_->mojo_from_plane.Get();
  *output = PoseDataView(pointer, message_);
}
inline void XRPlaneDataDataView::GetPolygonDataView(
    mojo::ArrayDataView<XRPlanePointDataDataView>* output) {
  auto pointer = data_->polygon.Get();
  *output = mojo::ArrayDataView<XRPlanePointDataDataView>(pointer, message_);
}


inline void XRPlaneDetectionDataDataView::GetAllPlanesIdsDataView(
    mojo::ArrayDataView<uint64_t>* output) {
  auto pointer = data_->all_planes_ids.Get();
  *output = mojo::ArrayDataView<uint64_t>(pointer, message_);
}
inline void XRPlaneDetectionDataDataView::GetUpdatedPlanesDataDataView(
    mojo::ArrayDataView<XRPlaneDataDataView>* output) {
  auto pointer = data_->updated_planes_data.Get();
  *output = mojo::ArrayDataView<XRPlaneDataDataView>(pointer, message_);
}


inline void XRAnchorDataDataView::GetMojoFromAnchorDataView(
    PoseDataView* output) {
  auto pointer = data_->mojo_from_anchor.Get();
  *output = PoseDataView(pointer, message_);
}


inline void XRAnchorsDataDataView::GetAllAnchorsIdsDataView(
    mojo::ArrayDataView<uint64_t>* output) {
  auto pointer = data_->all_anchors_ids.Get();
  *output = mojo::ArrayDataView<uint64_t>(pointer, message_);
}
inline void XRAnchorsDataDataView::GetUpdatedAnchorsDataDataView(
    mojo::ArrayDataView<XRAnchorDataDataView>* output) {
  auto pointer = data_->updated_anchors_data.Get();
  *output = mojo::ArrayDataView<XRAnchorDataDataView>(pointer, message_);
}


inline void XRHitTestSubscriptionResultDataDataView::GetHitTestResultsDataView(
    mojo::ArrayDataView<XRHitResultDataView>* output) {
  auto pointer = data_->hit_test_results.Get();
  *output = mojo::ArrayDataView<XRHitResultDataView>(pointer, message_);
}


inline void XRHitTestTransientInputSubscriptionResultDataDataView::GetInputSourceIdToHitTestResultsDataView(
    mojo::MapDataView<uint32_t, mojo::ArrayDataView<XRHitResultDataView>>* output) {
  auto pointer = data_->input_source_id_to_hit_test_results.Get();
  *output = mojo::MapDataView<uint32_t, mojo::ArrayDataView<XRHitResultDataView>>(pointer, message_);
}


inline void XRHitTestSubscriptionResultsDataDataView::GetResultsDataView(
    mojo::ArrayDataView<XRHitTestSubscriptionResultDataDataView>* output) {
  auto pointer = data_->results.Get();
  *output = mojo::ArrayDataView<XRHitTestSubscriptionResultDataDataView>(pointer, message_);
}
inline void XRHitTestSubscriptionResultsDataDataView::GetTransientInputResultsDataView(
    mojo::ArrayDataView<XRHitTestTransientInputSubscriptionResultDataDataView>* output) {
  auto pointer = data_->transient_input_results.Get();
  *output = mojo::ArrayDataView<XRHitTestTransientInputSubscriptionResultDataDataView>(pointer, message_);
}




inline void XRSphericalHarmonicsDataView::GetCoefficientsDataView(
    mojo::ArrayDataView<RgbTupleF32DataView>* output) {
  auto pointer = data_->coefficients.Get();
  *output = mojo::ArrayDataView<RgbTupleF32DataView>(pointer, message_);
}




inline void XRCubeMapDataView::GetPositiveXDataView(
    mojo::ArrayDataView<RgbaTupleF16DataView>* output) {
  auto pointer = data_->positive_x.Get();
  *output = mojo::ArrayDataView<RgbaTupleF16DataView>(pointer, message_);
}
inline void XRCubeMapDataView::GetNegativeXDataView(
    mojo::ArrayDataView<RgbaTupleF16DataView>* output) {
  auto pointer = data_->negative_x.Get();
  *output = mojo::ArrayDataView<RgbaTupleF16DataView>(pointer, message_);
}
inline void XRCubeMapDataView::GetPositiveYDataView(
    mojo::ArrayDataView<RgbaTupleF16DataView>* output) {
  auto pointer = data_->positive_y.Get();
  *output = mojo::ArrayDataView<RgbaTupleF16DataView>(pointer, message_);
}
inline void XRCubeMapDataView::GetNegativeYDataView(
    mojo::ArrayDataView<RgbaTupleF16DataView>* output) {
  auto pointer = data_->negative_y.Get();
  *output = mojo::ArrayDataView<RgbaTupleF16DataView>(pointer, message_);
}
inline void XRCubeMapDataView::GetPositiveZDataView(
    mojo::ArrayDataView<RgbaTupleF16DataView>* output) {
  auto pointer = data_->positive_z.Get();
  *output = mojo::ArrayDataView<RgbaTupleF16DataView>(pointer, message_);
}
inline void XRCubeMapDataView::GetNegativeZDataView(
    mojo::ArrayDataView<RgbaTupleF16DataView>* output) {
  auto pointer = data_->negative_z.Get();
  *output = mojo::ArrayDataView<RgbaTupleF16DataView>(pointer, message_);
}


inline void XRLightProbeDataView::GetSphericalHarmonicsDataView(
    XRSphericalHarmonicsDataView* output) {
  auto pointer = data_->spherical_harmonics.Get();
  *output = XRSphericalHarmonicsDataView(pointer, message_);
}
inline void XRLightProbeDataView::GetMainLightDirectionDataView(
    ::gfx::mojom::Vector3dFDataView* output) {
  auto pointer = data_->main_light_direction.Get();
  *output = ::gfx::mojom::Vector3dFDataView(pointer, message_);
}
inline void XRLightProbeDataView::GetMainLightIntensityDataView(
    RgbTupleF32DataView* output) {
  auto pointer = data_->main_light_intensity.Get();
  *output = RgbTupleF32DataView(pointer, message_);
}


inline void XRReflectionProbeDataView::GetCubeMapDataView(
    XRCubeMapDataView* output) {
  auto pointer = data_->cube_map.Get();
  *output = XRCubeMapDataView(pointer, message_);
}


inline void XRLightEstimationDataDataView::GetLightProbeDataView(
    XRLightProbeDataView* output) {
  auto pointer = data_->light_probe.Get();
  *output = XRLightProbeDataView(pointer, message_);
}
inline void XRLightEstimationDataDataView::GetReflectionProbeDataView(
    XRReflectionProbeDataView* output) {
  auto pointer = data_->reflection_probe.Get();
  *output = XRReflectionProbeDataView(pointer, message_);
}




inline void XRDepthDataUpdatedDataView::GetPixelDataDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->pixel_data;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, message_);
}
inline void XRDepthDataUpdatedDataView::GetNormTextureFromNormViewDataView(
    ::gfx::mojom::TransformDataView* output) {
  auto pointer = data_->norm_texture_from_norm_view.Get();
  *output = ::gfx::mojom::TransformDataView(pointer, message_);
}
inline void XRDepthDataUpdatedDataView::GetSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}


inline void XRTrackedImageDataDataView::GetMojoFromImageDataView(
    PoseDataView* output) {
  auto pointer = data_->mojo_from_image.Get();
  *output = PoseDataView(pointer, message_);
}


inline void XRTrackedImagesDataDataView::GetImagesDataDataView(
    mojo::ArrayDataView<XRTrackedImageDataDataView>* output) {
  auto pointer = data_->images_data.Get();
  *output = mojo::ArrayDataView<XRTrackedImageDataDataView>(pointer, message_);
}
inline void XRTrackedImagesDataDataView::GetImageTrackableScoresDataView(
    mojo::ArrayDataView<bool>* output) {
  auto pointer = data_->image_trackable_scores.Get();
  *output = mojo::ArrayDataView<bool>(pointer, message_);
}


inline void XRFrameDataDataView::GetMojoFromViewerDataView(
    VRPoseDataView* output) {
  auto pointer = data_->mojo_from_viewer.Get();
  *output = VRPoseDataView(pointer, message_);
}
inline void XRFrameDataDataView::GetTimeDeltaDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->time_delta.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void XRFrameDataDataView::GetBufferSharedImageDataView(
    ::gpu::mojom::ExportedSharedImageDataView* output) {
  auto pointer = data_->buffer_shared_image.Get();
  *output = ::gpu::mojom::ExportedSharedImageDataView(pointer, message_);
}
inline void XRFrameDataDataView::GetBufferSyncTokenDataView(
    ::gpu::mojom::SyncTokenDataView* output) {
  auto pointer = data_->buffer_sync_token.Get();
  *output = ::gpu::mojom::SyncTokenDataView(pointer, message_);
}
inline void XRFrameDataDataView::GetCameraImageBufferSharedImageDataView(
    ::gpu::mojom::ExportedSharedImageDataView* output) {
  auto pointer = data_->camera_image_buffer_shared_image.Get();
  *output = ::gpu::mojom::ExportedSharedImageDataView(pointer, message_);
}
inline void XRFrameDataDataView::GetCameraImageBufferSyncTokenDataView(
    ::gpu::mojom::SyncTokenDataView* output) {
  auto pointer = data_->camera_image_buffer_sync_token.Get();
  *output = ::gpu::mojom::SyncTokenDataView(pointer, message_);
}
inline void XRFrameDataDataView::GetCameraImageSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->camera_image_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void XRFrameDataDataView::GetMojoFromFloorDataView(
    ::gfx::mojom::TransformDataView* output) {
  auto pointer = data_->mojo_from_floor.Get();
  *output = ::gfx::mojom::TransformDataView(pointer, message_);
}
inline void XRFrameDataDataView::GetViewsDataView(
    mojo::ArrayDataView<XRViewDataView>* output) {
  auto pointer = data_->views.Get();
  *output = mojo::ArrayDataView<XRViewDataView>(pointer, message_);
}
inline void XRFrameDataDataView::GetInputStateDataView(
    mojo::ArrayDataView<XRInputSourceStateDataView>* output) {
  auto pointer = data_->input_state.Get();
  *output = mojo::ArrayDataView<XRInputSourceStateDataView>(pointer, message_);
}
inline void XRFrameDataDataView::GetStageParametersDataView(
    VRStageParametersDataView* output) {
  auto pointer = data_->stage_parameters.Get();
  *output = VRStageParametersDataView(pointer, message_);
}
inline void XRFrameDataDataView::GetDetectedPlanesDataDataView(
    XRPlaneDetectionDataDataView* output) {
  auto pointer = data_->detected_planes_data.Get();
  *output = XRPlaneDetectionDataDataView(pointer, message_);
}
inline void XRFrameDataDataView::GetAnchorsDataDataView(
    XRAnchorsDataDataView* output) {
  auto pointer = data_->anchors_data.Get();
  *output = XRAnchorsDataDataView(pointer, message_);
}
inline void XRFrameDataDataView::GetLightEstimationDataDataView(
    XRLightEstimationDataDataView* output) {
  auto pointer = data_->light_estimation_data.Get();
  *output = XRLightEstimationDataDataView(pointer, message_);
}
inline void XRFrameDataDataView::GetHitTestSubscriptionResultsDataView(
    XRHitTestSubscriptionResultsDataDataView* output) {
  auto pointer = data_->hit_test_subscription_results.Get();
  *output = XRHitTestSubscriptionResultsDataDataView(pointer, message_);
}
inline void XRFrameDataDataView::GetTrackedImagesDataView(
    XRTrackedImagesDataDataView* output) {
  auto pointer = data_->tracked_images.Get();
  *output = XRTrackedImagesDataDataView(pointer, message_);
}


inline void RequestSessionSuccessDataView::GetSessionDataView(
    XRSessionDataView* output) {
  auto pointer = data_->session.Get();
  *output = XRSessionDataView(pointer, message_);
}




inline void XRNativeOriginInformationDataView::GetInputSourceSpaceInfoDataView(
    XRInputSourceSpaceInfoDataView* output) const {
  CHECK(is_input_source_space_info());
  *output = XRInputSourceSpaceInfoDataView(data_->data.f_input_source_space_info.Get(), message_);
}
inline void XRNativeOriginInformationDataView::GetHandJointSpaceInfoDataView(
    XRHandJointSpaceInfoDataView* output) const {
  CHECK(is_hand_joint_space_info());
  *output = XRHandJointSpaceInfoDataView(data_->data.f_hand_joint_space_info.Get(), message_);
}

inline void XRDepthDataDataView::GetDataStillValidDataView(
    XRDepthDataStillValidDataView* output) const {
  CHECK(is_data_still_valid());
  *output = XRDepthDataStillValidDataView(data_->data.f_data_still_valid.Get(), message_);
}
inline void XRDepthDataDataView::GetUpdatedDepthDataDataView(
    XRDepthDataUpdatedDataView* output) const {
  CHECK(is_updated_depth_data());
  *output = XRDepthDataUpdatedDataView(data_->data.f_updated_depth_data.Get(), message_);
}

inline void RequestSessionResultDataView::GetSuccessDataView(
    RequestSessionSuccessDataView* output) const {
  CHECK(is_success());
  *output = RequestSessionSuccessDataView(data_->data.f_success.Get(), message_);
}


}  // device::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) TraceFormatTraits<::device::mojom::XRHandedness> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::XRHandedness value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) TraceFormatTraits<::device::mojom::XRTargetRayMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::XRTargetRayMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) TraceFormatTraits<::device::mojom::XRSessionFeatureRequestStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::XRSessionFeatureRequestStatus value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) TraceFormatTraits<::device::mojom::XREnvironmentBlendMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::XREnvironmentBlendMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) TraceFormatTraits<::device::mojom::XRInteractionMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::XRInteractionMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) TraceFormatTraits<::device::mojom::XREye> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::XREye value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) TraceFormatTraits<::device::mojom::XRPresentationTransportMethod> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::XRPresentationTransportMethod value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) TraceFormatTraits<::device::mojom::XRReferenceSpaceType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::XRReferenceSpaceType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) TraceFormatTraits<::device::mojom::XRInputSourceSpaceType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::XRInputSourceSpaceType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) TraceFormatTraits<::device::mojom::XRPlaneOrientation> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::XRPlaneOrientation value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) TraceFormatTraits<::device::mojom::XrCompatibleResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::XrCompatibleResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) TraceFormatTraits<::device::mojom::CreateAnchorResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::CreateAnchorResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) TraceFormatTraits<::device::mojom::SubscribeToHitTestResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::SubscribeToHitTestResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) TraceFormatTraits<::device::mojom::EntityTypeForHitTest> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::EntityTypeForHitTest value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) TraceFormatTraits<::device::mojom::XRVisibilityState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::XRVisibilityState value);
};

} // namespace perfetto

#endif  // DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_SHARED_H_