// extensions/common/mojom/guest_view.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "extensions/common/mojom/guest_view.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/guest_view.mojom-params-data.h"
#include "extensions/common/mojom/guest_view.mojom-shared-message-ids.h"

#include "extensions/common/mojom/guest_view.mojom-import-headers.h"
#include "extensions/common/mojom/guest_view.mojom-test-utils.h"


namespace extensions::mojom {
const char GuestView::Name_[] = "extensions.mojom.GuestView";

GuestView::IPCStableHashFunction GuestView::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::GuestView>(message.name())) {
    case messages::GuestView::kReadyToCreateMimeHandlerView: {
      return &GuestView::ReadyToCreateMimeHandlerView_Sym::IPCStableHash;
    }
    case messages::GuestView::kCanExecuteContentScript: {
      return &GuestView::CanExecuteContentScript_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* GuestView::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::GuestView>(message.name())) {
      case messages::GuestView::kReadyToCreateMimeHandlerView:
            return "Receive extensions::mojom::GuestView::ReadyToCreateMimeHandlerView";
      case messages::GuestView::kCanExecuteContentScript:
            return "Receive extensions::mojom::GuestView::CanExecuteContentScript";
    }
  } else {
    switch (static_cast<messages::GuestView>(message.name())) {
      case messages::GuestView::kReadyToCreateMimeHandlerView:
            return "Receive reply extensions::mojom::GuestView::ReadyToCreateMimeHandlerView";
      case messages::GuestView::kCanExecuteContentScript:
            return "Receive reply extensions::mojom::GuestView::CanExecuteContentScript";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t GuestView::ReadyToCreateMimeHandlerView_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::GuestView::ReadyToCreateMimeHandlerView");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GuestView::CanExecuteContentScript_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::GuestView::CanExecuteContentScript");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool GuestView::CanExecuteContentScript(const std::string& script_id, bool* out_allowed) {
  NOTREACHED();
}
class GuestView_CanExecuteContentScript_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  GuestView_CanExecuteContentScript_HandleSyncResponse(
      bool* result, bool* out_allowed)
      : result_(result), out_allowed_(out_allowed) {
    DCHECK(!*result_);
  }

  GuestView_CanExecuteContentScript_HandleSyncResponse(const GuestView_CanExecuteContentScript_HandleSyncResponse&) = delete;
  GuestView_CanExecuteContentScript_HandleSyncResponse& operator=(const GuestView_CanExecuteContentScript_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_allowed_;};

class GuestView_CanExecuteContentScript_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GuestView_CanExecuteContentScript_ForwardToCallback(
      GuestView::CanExecuteContentScriptCallback callback
      ) : callback_(std::move(callback)) {
  }

  GuestView_CanExecuteContentScript_ForwardToCallback(const GuestView_CanExecuteContentScript_ForwardToCallback&) = delete;
  GuestView_CanExecuteContentScript_ForwardToCallback& operator=(const GuestView_CanExecuteContentScript_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GuestView::CanExecuteContentScriptCallback callback_;
};

GuestViewProxy::GuestViewProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GuestViewProxy::ReadyToCreateMimeHandlerView(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::GuestView::ReadyToCreateMimeHandlerView", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GuestView::kReadyToCreateMimeHandlerView), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::GuestView_ReadyToCreateMimeHandlerView_Params_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GuestView::Name_);
  message.set_method_name("ReadyToCreateMimeHandlerView");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool GuestViewProxy::CanExecuteContentScript(
    const std::string& param_script_id, bool* out_param_allowed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call extensions::mojom::GuestView::CanExecuteContentScript (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("script_id"), param_script_id,
                        "<value of type const std::string&>");
   });
#else
  TRACE_EVENT0("mojom", "GuestView::CanExecuteContentScript");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GuestView::kCanExecuteContentScript), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::GuestView_CanExecuteContentScript_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->script_id)::BaseType> script_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_script_id, script_id_fragment);
  params->script_id.Set(
      script_id_fragment.is_null() ? nullptr : script_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->script_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null script_id in GuestView.CanExecuteContentScript request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GuestView::Name_);
  message.set_method_name("CanExecuteContentScript");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GuestView_CanExecuteContentScript_HandleSyncResponse(
          &result, out_param_allowed));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "GuestView::CanExecuteContentScript", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allowed"), out_param_allowed,
                        "<value of type bool>");
   });
#endif
  return result;
}

void GuestViewProxy::CanExecuteContentScript(
    const std::string& in_script_id, CanExecuteContentScriptCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::GuestView::CanExecuteContentScript", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("script_id"), in_script_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GuestView::kCanExecuteContentScript), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::GuestView_CanExecuteContentScript_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->script_id)::BaseType> script_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_script_id, script_id_fragment);
  params->script_id.Set(
      script_id_fragment.is_null() ? nullptr : script_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->script_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null script_id in GuestView.CanExecuteContentScript request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GuestView::Name_);
  message.set_method_name("CanExecuteContentScript");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GuestView_CanExecuteContentScript_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class GuestView_CanExecuteContentScript_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GuestView::CanExecuteContentScriptCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GuestView_CanExecuteContentScript_ProxyToResponder> proxy(
        new GuestView_CanExecuteContentScript_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GuestView_CanExecuteContentScript_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GuestView_CanExecuteContentScript_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GuestView_CanExecuteContentScript_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GuestView::CanExecuteContentScriptCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_allowed);
};

bool GuestView_CanExecuteContentScript_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GuestView_CanExecuteContentScript_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GuestView_CanExecuteContentScript_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for GuestView.1
  bool success = true;
  bool p_allowed{};
  GuestView_CanExecuteContentScript_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_allowed = input_data_view.allowed();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GuestView::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_allowed));
  return true;
}

void GuestView_CanExecuteContentScript_ProxyToResponder::Run(
    bool in_allowed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply extensions::mojom::GuestView::CanExecuteContentScript", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allowed"), in_allowed,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GuestView::kCanExecuteContentScript), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::GuestView_CanExecuteContentScript_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->allowed = in_allowed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GuestView::Name_);
  message.set_method_name("CanExecuteContentScript");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool GuestView_CanExecuteContentScript_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GuestView_CanExecuteContentScript_ResponseParams_Data* params =
      reinterpret_cast<internal::GuestView_CanExecuteContentScript_ResponseParams_Data*>(
          message->mutable_payload());
  
  
  // Validation for GuestView.1
  bool success = true;
  bool p_allowed{};
  GuestView_CanExecuteContentScript_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_allowed = input_data_view.allowed();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GuestView::Name_, 1, true);
    return false;
  }
  *out_allowed_ = std::move(p_allowed);
  *result_ = true;
  return true;
}

// static
bool GuestViewStubDispatch::Accept(
    GuestView* impl,
    mojo::Message* message) {
  switch (static_cast<messages::GuestView>(message->header()->name)) {
    case messages::GuestView::kReadyToCreateMimeHandlerView: {
      DCHECK(message->is_serialized());
      internal::GuestView_ReadyToCreateMimeHandlerView_Params_Data* params =
          reinterpret_cast<internal::GuestView_ReadyToCreateMimeHandlerView_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for GuestView.0
      bool success = true;
      bool p_success{};
      GuestView_ReadyToCreateMimeHandlerView_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_success = input_data_view.success();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GuestView::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadyToCreateMimeHandlerView(        
        std::move(p_success));
      return true;
    }
    case messages::GuestView::kCanExecuteContentScript: {
      break;
    }
  }
  return false;
}

// static
bool GuestViewStubDispatch::AcceptWithResponder(
    GuestView* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::GuestView>(message->header()->name)) {
    case messages::GuestView::kReadyToCreateMimeHandlerView: {
      break;
    }
    case messages::GuestView::kCanExecuteContentScript: {
      internal::GuestView_CanExecuteContentScript_Params_Data* params =
          reinterpret_cast<
              internal::GuestView_CanExecuteContentScript_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for GuestView.1
      bool success = true;
      std::string p_script_id{};
      GuestView_CanExecuteContentScript_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadScriptId(&p_script_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GuestView::Name_, 1, false);
        return false;
      }
      GuestView::CanExecuteContentScriptCallback callback =
          GuestView_CanExecuteContentScript_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CanExecuteContentScript(        
        std::move(p_script_id), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGuestViewValidationInfo[] = {
    {base::to_underlying(messages::GuestView::kReadyToCreateMimeHandlerView),
     { &internal::GuestView_ReadyToCreateMimeHandlerView_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::GuestView::kCanExecuteContentScript),
     { &internal::GuestView_CanExecuteContentScript_Params_Data::Validate,
      &internal::GuestView_CanExecuteContentScript_ResponseParams_Data::Validate}},
};

bool GuestViewRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::extensions::mojom::GuestView::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kGuestViewValidationInfo);
}

bool GuestViewResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::extensions::mojom::GuestView::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kGuestViewValidationInfo);

}
const char MimeHandlerViewContainerManager::Name_[] = "extensions.mojom.MimeHandlerViewContainerManager";

MimeHandlerViewContainerManager::IPCStableHashFunction MimeHandlerViewContainerManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MimeHandlerViewContainerManager>(message.name())) {
    case messages::MimeHandlerViewContainerManager::kSetInternalId: {
      return &MimeHandlerViewContainerManager::SetInternalId_Sym::IPCStableHash;
    }
    case messages::MimeHandlerViewContainerManager::kCreateBeforeUnloadControl: {
      return &MimeHandlerViewContainerManager::CreateBeforeUnloadControl_Sym::IPCStableHash;
    }
    case messages::MimeHandlerViewContainerManager::kDestroyFrameContainer: {
      return &MimeHandlerViewContainerManager::DestroyFrameContainer_Sym::IPCStableHash;
    }
    case messages::MimeHandlerViewContainerManager::kDidLoad: {
      return &MimeHandlerViewContainerManager::DidLoad_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MimeHandlerViewContainerManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MimeHandlerViewContainerManager>(message.name())) {
      case messages::MimeHandlerViewContainerManager::kSetInternalId:
            return "Receive extensions::mojom::MimeHandlerViewContainerManager::SetInternalId";
      case messages::MimeHandlerViewContainerManager::kCreateBeforeUnloadControl:
            return "Receive extensions::mojom::MimeHandlerViewContainerManager::CreateBeforeUnloadControl";
      case messages::MimeHandlerViewContainerManager::kDestroyFrameContainer:
            return "Receive extensions::mojom::MimeHandlerViewContainerManager::DestroyFrameContainer";
      case messages::MimeHandlerViewContainerManager::kDidLoad:
            return "Receive extensions::mojom::MimeHandlerViewContainerManager::DidLoad";
    }
  } else {
    switch (static_cast<messages::MimeHandlerViewContainerManager>(message.name())) {
      case messages::MimeHandlerViewContainerManager::kSetInternalId:
            return "Receive reply extensions::mojom::MimeHandlerViewContainerManager::SetInternalId";
      case messages::MimeHandlerViewContainerManager::kCreateBeforeUnloadControl:
            return "Receive reply extensions::mojom::MimeHandlerViewContainerManager::CreateBeforeUnloadControl";
      case messages::MimeHandlerViewContainerManager::kDestroyFrameContainer:
            return "Receive reply extensions::mojom::MimeHandlerViewContainerManager::DestroyFrameContainer";
      case messages::MimeHandlerViewContainerManager::kDidLoad:
            return "Receive reply extensions::mojom::MimeHandlerViewContainerManager::DidLoad";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MimeHandlerViewContainerManager::SetInternalId_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::MimeHandlerViewContainerManager::SetInternalId");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MimeHandlerViewContainerManager::CreateBeforeUnloadControl_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::MimeHandlerViewContainerManager::CreateBeforeUnloadControl");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MimeHandlerViewContainerManager::DestroyFrameContainer_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::MimeHandlerViewContainerManager::DestroyFrameContainer");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MimeHandlerViewContainerManager::DidLoad_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::MimeHandlerViewContainerManager::DidLoad");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ForwardToCallback(
      MimeHandlerViewContainerManager::CreateBeforeUnloadControlCallback callback
      ) : callback_(std::move(callback)) {
  }

  MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ForwardToCallback(const MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ForwardToCallback&) = delete;
  MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ForwardToCallback& operator=(const MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MimeHandlerViewContainerManager::CreateBeforeUnloadControlCallback callback_;
};

MimeHandlerViewContainerManagerProxy::MimeHandlerViewContainerManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MimeHandlerViewContainerManagerProxy::SetInternalId(
    const std::string& in_token_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::MimeHandlerViewContainerManager::SetInternalId", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token_id"), in_token_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MimeHandlerViewContainerManager::kSetInternalId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::MimeHandlerViewContainerManager_SetInternalId_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token_id)::BaseType> token_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_token_id, token_id_fragment);
  params->token_id.Set(
      token_id_fragment.is_null() ? nullptr : token_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->token_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null token_id in MimeHandlerViewContainerManager.SetInternalId request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MimeHandlerViewContainerManager::Name_);
  message.set_method_name("SetInternalId");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MimeHandlerViewContainerManagerProxy::CreateBeforeUnloadControl(
    CreateBeforeUnloadControlCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send extensions::mojom::MimeHandlerViewContainerManager::CreateBeforeUnloadControl");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MimeHandlerViewContainerManager::kCreateBeforeUnloadControl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::MimeHandlerViewContainerManager_CreateBeforeUnloadControl_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MimeHandlerViewContainerManager::Name_);
  message.set_method_name("CreateBeforeUnloadControl");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void MimeHandlerViewContainerManagerProxy::DestroyFrameContainer(
    int32_t in_element_instance_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::MimeHandlerViewContainerManager::DestroyFrameContainer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("element_instance_id"), in_element_instance_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MimeHandlerViewContainerManager::kDestroyFrameContainer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::MimeHandlerViewContainerManager_DestroyFrameContainer_Params_Data> params(
          message);
  params.Allocate();
  params->element_instance_id = in_element_instance_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MimeHandlerViewContainerManager::Name_);
  message.set_method_name("DestroyFrameContainer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MimeHandlerViewContainerManagerProxy::DidLoad(
    int32_t in_mime_handler_view_guest_element_instance_id, const ::GURL& in_resource_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::MimeHandlerViewContainerManager::DidLoad", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mime_handler_view_guest_element_instance_id"), in_mime_handler_view_guest_element_instance_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resource_url"), in_resource_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MimeHandlerViewContainerManager::kDidLoad), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::MimeHandlerViewContainerManager_DidLoad_Params_Data> params(
          message);
  params.Allocate();
  params->mime_handler_view_guest_element_instance_id = in_mime_handler_view_guest_element_instance_id;
  mojo::internal::MessageFragment<
      typename decltype(params->resource_url)::BaseType> resource_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_resource_url, resource_url_fragment);
  params->resource_url.Set(
      resource_url_fragment.is_null() ? nullptr : resource_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->resource_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resource_url in MimeHandlerViewContainerManager.DidLoad request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MimeHandlerViewContainerManager::Name_);
  message.set_method_name("DidLoad");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MimeHandlerViewContainerManager::CreateBeforeUnloadControlCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ProxyToResponder> proxy(
        new MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "MimeHandlerViewContainerManager::CreateBeforeUnloadControlCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<::extensions::mime_handler::BeforeUnloadControl> in_before_unload_control);
};

bool MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for MimeHandlerViewContainerManager.1
  bool success = true;
  ::mojo::PendingRemote<::extensions::mime_handler::BeforeUnloadControl> p_before_unload_control{};
  MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_before_unload_control =
        input_data_view.TakeBeforeUnloadControl<decltype(p_before_unload_control)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MimeHandlerViewContainerManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_before_unload_control));
  return true;
}

void MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ProxyToResponder::Run(
    ::mojo::PendingRemote<::extensions::mime_handler::BeforeUnloadControl> in_before_unload_control) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply extensions::mojom::MimeHandlerViewContainerManager::CreateBeforeUnloadControl", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("before_unload_control"), in_before_unload_control,
                        "<value of type ::mojo::PendingRemote<::extensions::mime_handler::BeforeUnloadControl>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MimeHandlerViewContainerManager::kCreateBeforeUnloadControl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::extensions::mime_handler::BeforeUnloadControlInterfaceBase>>(
      in_before_unload_control, &params->before_unload_control, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->before_unload_control),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid before_unload_control in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MimeHandlerViewContainerManager::Name_);
  message.set_method_name("CreateBeforeUnloadControl");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool MimeHandlerViewContainerManagerStubDispatch::Accept(
    MimeHandlerViewContainerManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MimeHandlerViewContainerManager>(message->header()->name)) {
    case messages::MimeHandlerViewContainerManager::kSetInternalId: {
      DCHECK(message->is_serialized());
      internal::MimeHandlerViewContainerManager_SetInternalId_Params_Data* params =
          reinterpret_cast<internal::MimeHandlerViewContainerManager_SetInternalId_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for MimeHandlerViewContainerManager.0
      bool success = true;
      std::string p_token_id{};
      MimeHandlerViewContainerManager_SetInternalId_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTokenId(&p_token_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MimeHandlerViewContainerManager::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetInternalId(        
        std::move(p_token_id));
      return true;
    }
    case messages::MimeHandlerViewContainerManager::kCreateBeforeUnloadControl: {
      break;
    }
    case messages::MimeHandlerViewContainerManager::kDestroyFrameContainer: {
      DCHECK(message->is_serialized());
      internal::MimeHandlerViewContainerManager_DestroyFrameContainer_Params_Data* params =
          reinterpret_cast<internal::MimeHandlerViewContainerManager_DestroyFrameContainer_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for MimeHandlerViewContainerManager.2
      bool success = true;
      int32_t p_element_instance_id{};
      MimeHandlerViewContainerManager_DestroyFrameContainer_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_element_instance_id = input_data_view.element_instance_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MimeHandlerViewContainerManager::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DestroyFrameContainer(        
        std::move(p_element_instance_id));
      return true;
    }
    case messages::MimeHandlerViewContainerManager::kDidLoad: {
      DCHECK(message->is_serialized());
      internal::MimeHandlerViewContainerManager_DidLoad_Params_Data* params =
          reinterpret_cast<internal::MimeHandlerViewContainerManager_DidLoad_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for MimeHandlerViewContainerManager.3
      bool success = true;
      int32_t p_mime_handler_view_guest_element_instance_id{};
      ::GURL p_resource_url{};
      MimeHandlerViewContainerManager_DidLoad_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_mime_handler_view_guest_element_instance_id = input_data_view.mime_handler_view_guest_element_instance_id();
      if (success && !input_data_view.ReadResourceUrl(&p_resource_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MimeHandlerViewContainerManager::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidLoad(        
        std::move(p_mime_handler_view_guest_element_instance_id), 
        std::move(p_resource_url));
      return true;
    }
  }
  return false;
}

// static
bool MimeHandlerViewContainerManagerStubDispatch::AcceptWithResponder(
    MimeHandlerViewContainerManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MimeHandlerViewContainerManager>(message->header()->name)) {
    case messages::MimeHandlerViewContainerManager::kSetInternalId: {
      break;
    }
    case messages::MimeHandlerViewContainerManager::kCreateBeforeUnloadControl: {
      internal::MimeHandlerViewContainerManager_CreateBeforeUnloadControl_Params_Data* params =
          reinterpret_cast<
              internal::MimeHandlerViewContainerManager_CreateBeforeUnloadControl_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for MimeHandlerViewContainerManager.1
      bool success = true;
      MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MimeHandlerViewContainerManager::Name_, 1, false);
        return false;
      }
      MimeHandlerViewContainerManager::CreateBeforeUnloadControlCallback callback =
          MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateBeforeUnloadControl(std::move(callback));
      return true;
    }
    case messages::MimeHandlerViewContainerManager::kDestroyFrameContainer: {
      break;
    }
    case messages::MimeHandlerViewContainerManager::kDidLoad: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kMimeHandlerViewContainerManagerValidationInfo[] = {
    {base::to_underlying(messages::MimeHandlerViewContainerManager::kSetInternalId),
     { &internal::MimeHandlerViewContainerManager_SetInternalId_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::MimeHandlerViewContainerManager::kCreateBeforeUnloadControl),
     { &internal::MimeHandlerViewContainerManager_CreateBeforeUnloadControl_Params_Data::Validate,
      &internal::MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::MimeHandlerViewContainerManager::kDestroyFrameContainer),
     { &internal::MimeHandlerViewContainerManager_DestroyFrameContainer_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::MimeHandlerViewContainerManager::kDidLoad),
     { &internal::MimeHandlerViewContainerManager_DidLoad_Params_Data::Validate,
      nullptr /* no response */}},
};

bool MimeHandlerViewContainerManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::extensions::mojom::MimeHandlerViewContainerManager::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kMimeHandlerViewContainerManagerValidationInfo);
}

bool MimeHandlerViewContainerManagerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::extensions::mojom::MimeHandlerViewContainerManager::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kMimeHandlerViewContainerManagerValidationInfo);

}


}  // extensions::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace extensions::mojom {


void GuestViewInterceptorForTesting::ReadyToCreateMimeHandlerView(bool success) {
  GetForwardingInterface()->ReadyToCreateMimeHandlerView(
    std::move(success)
    );
}
void GuestViewInterceptorForTesting::CanExecuteContentScript(const std::string& script_id, CanExecuteContentScriptCallback callback) {
  GetForwardingInterface()->CanExecuteContentScript(
    std::move(script_id)
    , std::move(callback));
}
GuestViewAsyncWaiter::GuestViewAsyncWaiter(
    GuestView* proxy) : proxy_(proxy) {}

GuestViewAsyncWaiter::~GuestViewAsyncWaiter() = default;

void GuestViewAsyncWaiter::CanExecuteContentScript(
    const std::string& script_id, bool* out_allowed) {
  base::RunLoop loop;
  proxy_->CanExecuteContentScript(
      std::move(script_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_allowed
,
             bool allowed) {*out_allowed = std::move(allowed);
            loop->Quit();
          },
          &loop,
          out_allowed));
  loop.Run();
}

bool GuestViewAsyncWaiter::CanExecuteContentScript(
    const std::string& script_id) {
  bool async_wait_result;
  CanExecuteContentScript(std::move(script_id),&async_wait_result);
  return async_wait_result;
}




void MimeHandlerViewContainerManagerInterceptorForTesting::SetInternalId(const std::string& token_id) {
  GetForwardingInterface()->SetInternalId(
    std::move(token_id)
    );
}
void MimeHandlerViewContainerManagerInterceptorForTesting::CreateBeforeUnloadControl(CreateBeforeUnloadControlCallback callback) {
  GetForwardingInterface()->CreateBeforeUnloadControl(std::move(callback));
}
void MimeHandlerViewContainerManagerInterceptorForTesting::DestroyFrameContainer(int32_t element_instance_id) {
  GetForwardingInterface()->DestroyFrameContainer(
    std::move(element_instance_id)
    );
}
void MimeHandlerViewContainerManagerInterceptorForTesting::DidLoad(int32_t mime_handler_view_guest_element_instance_id, const ::GURL& resource_url) {
  GetForwardingInterface()->DidLoad(
    std::move(mime_handler_view_guest_element_instance_id)
    , 
    std::move(resource_url)
    );
}
MimeHandlerViewContainerManagerAsyncWaiter::MimeHandlerViewContainerManagerAsyncWaiter(
    MimeHandlerViewContainerManager* proxy) : proxy_(proxy) {}

MimeHandlerViewContainerManagerAsyncWaiter::~MimeHandlerViewContainerManagerAsyncWaiter() = default;

void MimeHandlerViewContainerManagerAsyncWaiter::CreateBeforeUnloadControl(
    ::mojo::PendingRemote<::extensions::mime_handler::BeforeUnloadControl>* out_before_unload_control) {
  base::RunLoop loop;
  proxy_->CreateBeforeUnloadControl(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingRemote<::extensions::mime_handler::BeforeUnloadControl>* out_before_unload_control
,
             ::mojo::PendingRemote<::extensions::mime_handler::BeforeUnloadControl> before_unload_control) {*out_before_unload_control = std::move(before_unload_control);
            loop->Quit();
          },
          &loop,
          out_before_unload_control));
  loop.Run();
}

::mojo::PendingRemote<::extensions::mime_handler::BeforeUnloadControl> MimeHandlerViewContainerManagerAsyncWaiter::CreateBeforeUnloadControl(
    ) {
  ::mojo::PendingRemote<::extensions::mime_handler::BeforeUnloadControl> async_wait_result;
  CreateBeforeUnloadControl(&async_wait_result);
  return async_wait_result;
}






}  // extensions::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif