// gpu/ipc/common/gpu_feature_info.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "gpu/ipc/common/gpu_feature_info.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "gpu/ipc/common/gpu_feature_info.mojom-params-data.h"
namespace gpu {
namespace mojom {

NOINLINE static const char* GpuFeatureStatusToStringHelper(GpuFeatureStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case GpuFeatureStatus::Enabled:
      return "Enabled";
    case GpuFeatureStatus::Blocklisted:
      return "Blocklisted";
    case GpuFeatureStatus::Disabled:
      return "Disabled";
    case GpuFeatureStatus::Software:
      return "Software";
    case GpuFeatureStatus::Undefined:
      return "Undefined";
    case GpuFeatureStatus::Max:
      return "Max";
    default:
      return nullptr;
  }
}

std::string GpuFeatureStatusToString(GpuFeatureStatus value) {
  const char *str = GpuFeatureStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown GpuFeatureStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, GpuFeatureStatus value) {
  return os << GpuFeatureStatusToString(value);
}

namespace internal {


// static
bool GpuFeatureInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuFeatureInfo_Data* object =
      static_cast<const GpuFeatureInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->status_values, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& status_values_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<13, false, ::gpu::mojom::internal::GpuFeatureStatus_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->status_values, validation_context,
                                         &status_values_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->enabled_gpu_driver_bug_workarounds, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& enabled_gpu_driver_bug_workarounds_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->enabled_gpu_driver_bug_workarounds, validation_context,
                                         &enabled_gpu_driver_bug_workarounds_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->disabled_extensions, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& disabled_extensions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->disabled_extensions, validation_context,
                                         &disabled_extensions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->disabled_webgl_extensions, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& disabled_webgl_extensions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->disabled_webgl_extensions, validation_context,
                                         &disabled_webgl_extensions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->applied_gpu_blocklist_entries, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& applied_gpu_blocklist_entries_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->applied_gpu_blocklist_entries, validation_context,
                                         &applied_gpu_blocklist_entries_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->applied_gpu_driver_bug_list_entries, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& applied_gpu_driver_bug_list_entries_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->applied_gpu_driver_bug_list_entries, validation_context,
                                         &applied_gpu_driver_bug_list_entries_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->supported_buffer_formats_for_allocation_and_texturing, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& supported_buffer_formats_for_allocation_and_texturing_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::gfx::mojom::internal::BufferFormat_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->supported_buffer_formats_for_allocation_and_texturing, validation_context,
                                         &supported_buffer_formats_for_allocation_and_texturing_validate_params)) {
    return false;
  }

  return true;
}

GpuFeatureInfo_Data::GpuFeatureInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace gpu

namespace perfetto {

// static
void TraceFormatTraits<::gpu::mojom::GpuFeatureStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::gpu::mojom::GpuFeatureStatus value) {
  return std::move(context).WriteString(::gpu::mojom::GpuFeatureStatusToString(value));
}

} // namespace perfetto