// media/capture/mojom/video_capture_types.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_TYPES_MOJOM_SHARED_H_
#define MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_TYPES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/capture/mojom/video_capture_types.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"







namespace media::mojom {
class VideoCaptureControlSupportDataView;

class VideoCaptureFormatDataView;

class VideoCaptureParamsDataView;

class VideoCaptureFeedbackDataView;

class PlaneStridesDataView;

class VideoCaptureDeviceDescriptorDataView;

class VideoCaptureDeviceInfoDataView;



}  // media::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::VideoCaptureControlSupportDataView> {
  using Data = ::media::mojom::internal::VideoCaptureControlSupport_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::VideoCaptureFormatDataView> {
  using Data = ::media::mojom::internal::VideoCaptureFormat_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::VideoCaptureParamsDataView> {
  using Data = ::media::mojom::internal::VideoCaptureParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::VideoCaptureFeedbackDataView> {
  using Data = ::media::mojom::internal::VideoCaptureFeedback_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::PlaneStridesDataView> {
  using Data = ::media::mojom::internal::PlaneStrides_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::VideoCaptureDeviceDescriptorDataView> {
  using Data = ::media::mojom::internal::VideoCaptureDeviceDescriptor_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::VideoCaptureDeviceInfoDataView> {
  using Data = ::media::mojom::internal::VideoCaptureDeviceInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {


enum class VideoCapturePixelFormat : int32_t {
  
  UNKNOWN = 0,
  
  I420 = 1,
  
  YV12 = 2,
  
  I422 = 3,
  
  I420A = 4,
  
  I444 = 5,
  
  NV12 = 6,
  
  NV21 = 7,
  
  UYVY = 8,
  
  YUY2 = 9,
  
  ARGB = 10,
  
  XRGB = 11,
  
  RGB24 = 12,
  
  MJPEG = 13,
  
  YUV420P9 = 14,
  
  YUV420P10 = 15,
  
  YUV422P9 = 16,
  
  YUV422P10 = 17,
  
  YUV444P9 = 18,
  
  YUV444P10 = 19,
  
  YUV420P12 = 20,
  
  YUV422P12 = 21,
  
  YUV444P12 = 22,
  
  Y16 = 23,
  
  ABGR = 24,
  
  XBGR = 25,
  
  P010LE = 26,
  
  XR30 = 27,
  
  XB30 = 28,
  
  BGRA = 29,
  
  RGBAF16 = 30,
  
  I422A = 31,
  
  I444A = 32,
  
  YUV420AP10 = 33,
  
  YUV422AP10 = 34,
  
  YUV444AP10 = 35,
  
  NV12A = 36,
  
  NV16 = 37,
  
  NV24 = 38,
  
  P210LE = 39,
  
  P410LE = 40,
  kMinValue = 0,
  kMaxValue = 40,
};

 std::ostream& operator<<(std::ostream& os, VideoCapturePixelFormat value);
inline bool IsKnownEnumValue(VideoCapturePixelFormat value) {
  return internal::VideoCapturePixelFormat_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ResolutionChangePolicy : int32_t {
  
  FIXED_RESOLUTION = 0,
  
  FIXED_ASPECT_RATIO = 1,
  
  ANY_WITHIN_LIMIT = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, ResolutionChangePolicy value);
inline bool IsKnownEnumValue(ResolutionChangePolicy value) {
  return internal::ResolutionChangePolicy_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PowerLineFrequency : int32_t {
  
  DEFAULT = 0,
  
  HZ_50 = 1,
  
  HZ_60 = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, PowerLineFrequency value);
inline bool IsKnownEnumValue(PowerLineFrequency value) {
  return internal::PowerLineFrequency_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class VideoFacingMode : int32_t {
  
  NONE = 0,
  
  USER = 1,
  
  ENVIRONMENT = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, VideoFacingMode value);
inline bool IsKnownEnumValue(VideoFacingMode value) {
  return internal::VideoFacingMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CameraAvailability : int32_t {
  
  kAvailable = 0,
  
  kUnavailableExclusivelyUsedByOtherApplication = 1,
  kMinValue = 0,
  kMaxValue = 1,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, CameraAvailability value);
inline bool IsKnownEnumValue(CameraAvailability value) {
  return internal::CameraAvailability_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline CameraAvailability ToKnownEnumValue(CameraAvailability value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return CameraAvailability::kDefaultValue;
}


enum class VideoCaptureApi : int32_t {
  
  LINUX_V4L2_SINGLE_PLANE = 0,
  
  WIN_MEDIA_FOUNDATION = 1,
  
  WIN_MEDIA_FOUNDATION_SENSOR = 2,
  
  WIN_DIRECT_SHOW = 3,
  
  MACOSX_AVFOUNDATION = 4,
  
  MACOSX_DECKLINK = 5,
  
  ANDROID_API1 = 6,
  
  ANDROID_API2_LEGACY = 7,
  
  ANDROID_API2_FULL = 8,
  
  ANDROID_API2_LIMITED = 9,
  
  FUCHSIA_CAMERA3 = 10,
  
  VIRTUAL_DEVICE = 11,
  
  UNKNOWN = 12,
  
  WEBRTC_LINUX_PIPEWIRE_SINGLE_PLANE = 13,
  kMinValue = 0,
  kMaxValue = 13,
};

 std::ostream& operator<<(std::ostream& os, VideoCaptureApi value);
inline bool IsKnownEnumValue(VideoCaptureApi value) {
  return internal::VideoCaptureApi_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class VideoCaptureTransportType : int32_t {
  
  APPLE_USB_OR_BUILT_IN = 0,
  
  OTHER_TRANSPORT = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, VideoCaptureTransportType value);
inline bool IsKnownEnumValue(VideoCaptureTransportType value) {
  return internal::VideoCaptureTransportType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class VideoCaptureBufferType : int32_t {
  
  kSharedMemory = 0,
  
  kSharedMemoryViaRawFileDescriptor_DEPRECATED = 1,
  
  kMailboxHolder = 2,
  
  kGpuMemoryBuffer = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, VideoCaptureBufferType value);
inline bool IsKnownEnumValue(VideoCaptureBufferType value) {
  return internal::VideoCaptureBufferType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class VideoCaptureError : int32_t {
  
  kNone = 0,
  
  kVideoCaptureControllerInvalidOrUnsupportedVideoCaptureParametersRequested = 1,
  
  kVideoCaptureControllerIsAlreadyInErrorState = 2,
  
  kVideoCaptureManagerDeviceConnectionLost = 3,
  
  kFrameSinkVideoCaptureDeviceAlreadyEndedOnFatalError = 4,
  
  kFrameSinkVideoCaptureDeviceEncounteredFatalError = 5,
  
  kV4L2FailedToOpenV4L2DeviceDriverFile = 6,
  
  kV4L2ThisIsNotAV4L2VideoCaptureDevice = 7,
  
  kV4L2FailedToFindASupportedCameraFormat = 8,
  
  kV4L2FailedToSetVideoCaptureFormat = 9,
  
  kV4L2UnsupportedPixelFormat = 10,
  
  kV4L2FailedToSetCameraFramerate = 11,
  
  kV4L2ErrorRequestingMmapBuffers = 12,
  
  kV4L2AllocateBufferFailed = 13,
  
  kV4L2VidiocStreamonFailed = 14,
  
  kV4L2VidiocStreamoffFailed = 15,
  
  kV4L2FailedToVidiocReqbufsWithCount0 = 16,
  
  kV4L2PollFailed = 17,
  
  kV4L2MultipleContinuousTimeoutsWhileReadPolling = 18,
  
  kV4L2FailedToDequeueCaptureBuffer = 19,
  
  kV4L2FailedToEnqueueCaptureBuffer = 20,
  
  kSingleClientVideoCaptureHostLostConnectionToDevice = 21,
  
  kSingleClientVideoCaptureDeviceLaunchAborted = 22,
  
  kDesktopCaptureDeviceWebrtcDesktopCapturerHasFailed = 23,
  
  kFileVideoCaptureDeviceCouldNotOpenVideoFile = 24,
  
  kDeviceCaptureLinuxFailedToCreateVideoCaptureDelegate = 25,
  
  kErrorFakeDeviceIntentionallyEmittingErrorEvent = 26,
  
  kDeviceClientTooManyFramesDroppedY16 = 27,
  
  kDeviceMediaToMojoAdapterEncounteredUnsupportedBufferType = 28,
  
  kVideoCaptureManagerProcessDeviceStartQueueDeviceInfoNotFound = 29,
  
  kInProcessDeviceLauncherFailedToCreateDeviceInstance = 30,
  
  kServiceDeviceLauncherLostConnectionToDeviceFactoryDuringDeviceStart = 31,
  
  kServiceDeviceLauncherServiceRespondedWithDeviceNotFound = 32,
  
  kServiceDeviceLauncherConnectionLostWhileWaitingForCallback = 33,
  
  kIntentionalErrorRaisedByUnitTest = 34,
  
  kCrosHalV3FailedToStartDeviceThread = 35,
  
  kCrosHalV3DeviceDelegateMojoConnectionError = 36,
  
  kCrosHalV3DeviceDelegateFailedToGetCameraInfo = 37,
  
  kCrosHalV3DeviceDelegateMissingSensorOrientationInfo = 38,
  
  kCrosHalV3DeviceDelegateFailedToOpenCameraDevice = 39,
  
  kCrosHalV3DeviceDelegateFailedToInitializeCameraDevice = 40,
  
  kCrosHalV3DeviceDelegateFailedToConfigureStreams = 41,
  
  kCrosHalV3DeviceDelegateWrongNumberOfStreamsConfigured = 42,
  
  kCrosHalV3DeviceDelegateFailedToGetDefaultRequestSettings = 43,
  
  kCrosHalV3BufferManagerHalRequestedTooManyBuffers = 44,
  
  kCrosHalV3BufferManagerFailedToCreateMappableSI = 45,
  
  kCrosHalV3BufferManagerFailedToMapGpuMemoryBuffer = 46,
  
  kCrosHalV3BufferManagerUnsupportedVideoPixelFormat = 47,
  
  kCrosHalV3BufferManagerFailedToDupFd = 48,
  
  kCrosHalV3BufferManagerFailedToWrapGpuMemoryHandle = 49,
  
  kCrosHalV3BufferManagerFailedToRegisterBuffer = 50,
  
  kCrosHalV3BufferManagerProcessCaptureRequestFailed = 51,
  
  kCrosHalV3BufferManagerInvalidPendingResultId = 52,
  
  kCrosHalV3BufferManagerReceivedDuplicatedPartialMetadata = 53,
  
  kCrosHalV3BufferManagerIncorrectNumberOfOutputBuffersReceived = 54,
  
  kCrosHalV3BufferManagerInvalidTypeOfOutputBuffersReceived = 55,
  
  kCrosHalV3BufferManagerReceivedMultipleResultBuffersForFrame = 56,
  
  kCrosHalV3BufferManagerUnknownStreamInCamera3NotifyMsg = 57,
  
  kCrosHalV3BufferManagerReceivedInvalidShutterTime = 58,
  
  kCrosHalV3BufferManagerFatalDeviceError = 59,
  
  kCrosHalV3BufferManagerReceivedFrameIsOutOfOrder = 60,
  
  kCrosHalV3BufferManagerFailedToUnwrapReleaseFenceFd = 61,
  
  kCrosHalV3BufferManagerSyncWaitOnReleaseFenceTimedOut = 62,
  
  kCrosHalV3BufferManagerInvalidJpegBlob = 63,
  
  kAndroidFailedToAllocate = 64,
  
  kAndroidFailedToStartCapture = 65,
  
  kAndroidFailedToStopCapture = 66,
  
  kAndroidApi1CameraErrorCallbackReceived = 67,
  
  kAndroidApi2CameraDeviceErrorReceived = 68,
  
  kAndroidApi2CaptureSessionConfigureFailed = 69,
  
  kAndroidApi2ImageReaderUnexpectedImageFormat = 70,
  
  kAndroidApi2ImageReaderSizeDidNotMatchImageSize = 71,
  
  kAndroidApi2ErrorRestartingPreview = 72,
  
  kAndroidScreenCaptureUnsupportedFormat = 73,
  
  kAndroidScreenCaptureFailedToStartCaptureMachine = 74,
  
  kAndroidScreenCaptureTheUserDeniedScreenCapture = 75,
  
  kAndroidScreenCaptureFailedToStartScreenCapture = 76,
  
  kWinDirectShowCantGetCaptureFormatSettings = 77,
  
  kWinDirectShowFailedToGetNumberOfCapabilities = 78,
  
  kWinDirectShowFailedToGetCaptureDeviceCapabilities = 79,
  
  kWinDirectShowFailedToSetCaptureDeviceOutputFormat = 80,
  
  kWinDirectShowFailedToConnectTheCaptureGraph = 81,
  
  kWinDirectShowFailedToPauseTheCaptureDevice = 82,
  
  kWinDirectShowFailedToStartTheCaptureDevice = 83,
  
  kWinDirectShowFailedToStopTheCaptureGraph = 84,
  
  kWinMediaFoundationEngineIsNull = 85,
  
  kWinMediaFoundationEngineGetSourceFailed = 86,
  
  kWinMediaFoundationFillPhotoCapabilitiesFailed = 87,
  
  kWinMediaFoundationFillVideoCapabilitiesFailed = 88,
  
  kWinMediaFoundationNoVideoCapabilityFound = 89,
  
  kWinMediaFoundationGetAvailableDeviceMediaTypeFailed = 90,
  
  kWinMediaFoundationSetCurrentDeviceMediaTypeFailed = 91,
  
  kWinMediaFoundationEngineGetSinkFailed = 92,
  
  kWinMediaFoundationSinkQueryCapturePreviewInterfaceFailed = 93,
  
  kWinMediaFoundationSinkRemoveAllStreamsFailed = 94,
  
  kWinMediaFoundationCreateSinkVideoMediaTypeFailed = 95,
  
  kWinMediaFoundationConvertToVideoSinkMediaTypeFailed = 96,
  
  kWinMediaFoundationSinkAddStreamFailed = 97,
  
  kWinMediaFoundationSinkSetSampleCallbackFailed = 98,
  
  kWinMediaFoundationEngineStartPreviewFailed = 99,
  
  kWinMediaFoundationGetMediaEventStatusFailed = 100,
  
  kMacSetCaptureDeviceFailed = 101,
  
  kMacCouldNotStartCaptureDevice = 102,
  
  kMacReceivedFrameWithUnexpectedResolution = 103,
  
  kMacUpdateCaptureResolutionFailed = 104,
  
  kMacDeckLinkDeviceIdNotFoundInTheSystem = 105,
  
  kMacDeckLinkErrorQueryingInputInterface = 106,
  
  kMacDeckLinkErrorCreatingDisplayModeIterator = 107,
  
  kMacDeckLinkCouldNotFindADisplayMode = 108,
  
  kMacDeckLinkCouldNotSelectTheVideoFormatWeLike = 109,
  
  kMacDeckLinkCouldNotStartCapturing = 110,
  
  kMacDeckLinkUnsupportedPixelFormat = 111,
  
  kMacAvFoundationReceivedAVCaptureSessionRuntimeErrorNotification = 112,
  
  kAndroidApi2ErrorConfiguringCamera = 113,
  
  kCrosHalV3DeviceDelegateFailedToFlush = 114,
  
  kFuchsiaCameraDeviceDisconnected = 115,
  
  kFuchsiaCameraStreamDisconnected = 116,
  
  kFuchsiaSysmemDidNotSetImageFormat = 117,
  
  kFuchsiaSysmemInvalidBufferIndex = 118,
  
  kFuchsiaSysmemInvalidBufferSize = 119,
  
  kFuchsiaUnsupportedPixelFormat = 120,
  
  kFuchsiaFailedToMapSysmemBuffer = 121,
  
  kCrosHalV3DeviceContextDuplicatedClient = 122,
  
  kDesktopCaptureDeviceMacFailedStreamCreate = 123,
  
  kDesktopCaptureDeviceMacFailedStreamStart = 124,
  
  kCrosHalV3BufferManagerFailedToReserveBuffers = 125,
  
  kWinMediaFoundationSystemPermissionDenied = 126,
  
  kVideoCaptureImplTimedOutOnStart = 127,
  
  kLacrosVideoCaptureDeviceProxyAlreadyEndedOnFatalError = 128,
  
  kLacrosVideoCaptureDeviceProxyEncounteredFatalError = 129,
  
  kScreenCaptureKitFailedGetShareableContent = 130,
  
  kScreenCaptureKitFailedAddStreamOutput = 131,
  
  kScreenCaptureKitFailedStartCapture = 132,
  
  kScreenCaptureKitFailedStopCapture = 133,
  
  kScreenCaptureKitStreamError = 134,
  
  kScreenCaptureKitFailedToFindSCDisplay = 135,
  
  kVideoCaptureControllerInvalid = 136,
  
  kVideoCaptureDeviceFactoryChromeOSCreateDeviceFailed = 137,
  
  kVideoCaptureControllerUnsupportedPixelFormat = 138,
  
  kVideoCaptureDeviceAlreadyReleased = 139,
  
  kVideoCaptureSystemDeviceIdNotFound = 140,
  
  kVideoCaptureDeviceFactoryWinUnknownError = 141,
  
  kWinMediaFoundationDeviceInitializationFailed = 142,
  
  kWinMediaFoundationSourceCreationFailed = 143,
  
  kWinDirectShowDeviceFilterCreationFailed = 144,
  
  kWinDirectShowDeviceInitializationFailed = 145,
  
  kVideoCaptureDeviceFactorySecondCreateDenied = 146,
  
  kScreenCaptureKitResetStreamError = 147,
  
  kWinMediaFoundationCameraBusy = 148,
  
  kWebRtcStartCaptureFailed = 149,
  kMinValue = 0,
  kMaxValue = 149,
};

 std::ostream& operator<<(std::ostream& os, VideoCaptureError value);
inline bool IsKnownEnumValue(VideoCaptureError value) {
  return internal::VideoCaptureError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class VideoCaptureFrameDropReason : int32_t {
  
  kNone = 0,
  
  kDeviceClientFrameHasInvalidFormat = 1,
  
  kDeviceClientLibyuvConvertToI420Failed = 2,
  
  kV4L2BufferErrorFlagWasSet = 3,
  
  kV4L2InvalidNumberOfBytesInBuffer = 4,
  
  kAndroidThrottling = 5,
  
  kAndroidGetByteArrayElementsFailed = 6,
  
  kAndroidApi1UnexpectedDataLength = 7,
  
  kAndroidApi2AcquiredImageIsNull = 8,
  
  kWinDirectShowUnexpectedSampleLength = 9,
  
  kWinDirectShowFailedToGetMemoryPointerFromMediaSample = 10,
  
  kWinMediaFoundationReceivedSampleIsNull = 11,
  
  kWinMediaFoundationLockingBufferDelieveredNullptr = 12,
  
  kWinMediaFoundationGetBufferByIndexReturnedNull = 13,
  
  kBufferPoolMaxBufferCountExceeded = 14,
  
  kBufferPoolBufferAllocationFailed = 15,
  
  kVideoCaptureImplNotInStartedState = 16,
  
  kVideoCaptureImplFailedToWrapDataAsMediaVideoFrame = 17,
  
  kVideoTrackAdapterHasNoResolutionAdapters = 18,
  
  kResolutionAdapterFrameIsNotValid = 19,
  
  kResolutionAdapterWrappingFrameForCroppingFailed = 20,
  
  kResolutionAdapterTimestampTooCloseToPrevious_DEPRECATED = 21,
  
  kResolutionAdapterFrameRateIsHigherThanRequested = 22,
  
  kResolutionAdapterHasNoCallbacks = 23,
  
  kVideoTrackFrameDelivererNotEnabledReplacingWithBlackFrame = 24,
  
  kRendererSinkFrameDelivererIsNotStarted = 25,
  
  kCropVersionNotCurrent_DEPRECATED = 26,
  
  kGpuMemoryBufferMapFailed = 27,
  
  kSubCaptureTargetVersionNotCurrent = 28,
  
  kPostProcessingFailed = 29,
  kMinValue = 0,
  kMaxValue = 29,
};

 std::ostream& operator<<(std::ostream& os, VideoCaptureFrameDropReason value);
inline bool IsKnownEnumValue(VideoCaptureFrameDropReason value) {
  return internal::VideoCaptureFrameDropReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SubCaptureTargetType : int32_t {
  
  kCropTarget = 0,
  
  kRestrictionTarget = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, SubCaptureTargetType value);
inline bool IsKnownEnumValue(SubCaptureTargetType value) {
  return internal::SubCaptureTargetType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ApplySubCaptureTargetResult : int32_t {
  
  kSuccess = 0,
  
  kErrorGeneric = 1,
  
  kUnsupportedCaptureDevice = 2,
  
  kNotImplemented = 3,
  
  kNonIncreasingVersion = 4,
  
  kInvalidTarget = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, ApplySubCaptureTargetResult value);
inline bool IsKnownEnumValue(ApplySubCaptureTargetResult value) {
  return internal::ApplySubCaptureTargetResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DeviceEnumerationResult : int32_t {
  
  kSuccess = 0,
  
  kUnknownError = 1,
  
  kErrorCaptureServiceCrash = 2,
  
  kErrorCaptureServiceDroppedRequest = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, DeviceEnumerationResult value);
inline bool IsKnownEnumValue(DeviceEnumerationResult value) {
  return internal::DeviceEnumerationResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class VideoCaptureControlSupportDataView {
 public:
  VideoCaptureControlSupportDataView() = default;

  VideoCaptureControlSupportDataView(
      internal::VideoCaptureControlSupport_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool pan() const {
    return data_->pan;
  }
  bool tilt() const {
    return data_->tilt;
  }
  bool zoom() const {
    return data_->zoom;
  }
 private:
  internal::VideoCaptureControlSupport_Data* data_ = nullptr;
};


class VideoCaptureFormatDataView {
 public:
  VideoCaptureFormatDataView() = default;

  VideoCaptureFormatDataView(
      internal::VideoCaptureFormat_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameSize(UserType* output) {
    
    auto* pointer = data_->frame_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  float frame_rate() const {
    return data_->frame_rate;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPixelFormat(UserType* output) const {
    auto data_value = data_->pixel_format;
    return mojo::internal::Deserialize<::media::mojom::VideoCapturePixelFormat>(
        data_value, output);
  }
  VideoCapturePixelFormat pixel_format() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoCapturePixelFormat>(data_->pixel_format));
  }
 private:
  internal::VideoCaptureFormat_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoCaptureParamsDataView {
 public:
  VideoCaptureParamsDataView() = default;

  VideoCaptureParamsDataView(
      internal::VideoCaptureParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRequestedFormatDataView(
      VideoCaptureFormatDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestedFormat(UserType* output) {
    
    auto* pointer = data_->requested_format.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoCaptureFormatDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadBufferType(UserType* output) const {
    auto data_value = data_->buffer_type;
    return mojo::internal::Deserialize<::media::mojom::VideoCaptureBufferType>(
        data_value, output);
  }
  VideoCaptureBufferType buffer_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoCaptureBufferType>(data_->buffer_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadResolutionChangePolicy(UserType* output) const {
    auto data_value = data_->resolution_change_policy;
    return mojo::internal::Deserialize<::media::mojom::ResolutionChangePolicy>(
        data_value, output);
  }
  ResolutionChangePolicy resolution_change_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::ResolutionChangePolicy>(data_->resolution_change_policy));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPowerLineFrequency(UserType* output) const {
    auto data_value = data_->power_line_frequency;
    return mojo::internal::Deserialize<::media::mojom::PowerLineFrequency>(
        data_value, output);
  }
  PowerLineFrequency power_line_frequency() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::PowerLineFrequency>(data_->power_line_frequency));
  }
  bool enable_face_detection() const {
    return data_->enable_face_detection;
  }
  bool is_high_dpi_enabled() const {
    if (data_->header_.version < 1)
      return bool{};
    return data_->is_high_dpi_enabled;
  }
 private:
  internal::VideoCaptureParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoCaptureFeedbackDataView {
 public:
  VideoCaptureFeedbackDataView() = default;

  VideoCaptureFeedbackDataView(
      internal::VideoCaptureFeedback_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  double resource_utilization() const {
    return data_->resource_utilization;
  }
  float max_framerate_fps() const {
    return data_->max_framerate_fps;
  }
  int32_t max_pixels() const {
    return data_->max_pixels;
  }
  bool require_mapped_frame() const {
    return data_->require_mapped_frame;
  }
  inline void GetDeprecatedMappedSizesDataView(
      mojo::ArrayDataView<::gfx::mojom::SizeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeprecatedMappedSizes(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::gfx::mojom::SizeDataView>, UserType>(),
    "Attempting to read the optional `DEPRECATED_mapped_sizes` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDeprecatedMappedSizes` instead "
    "of `ReadDeprecatedMappedSizes if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 1
                    ? data_->DEPRECATED_mapped_sizes.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>>(
        pointer, output, message_);
  }
  int32_t frame_id() const {
    if (data_->header_.version < 2)
      return int32_t{};
    return data_->frame_id;
  }
  bool has_frame_id() const {
    if (data_->header_.version < 2)
      return bool{};
    return data_->has_frame_id;
  }
 private:
  internal::VideoCaptureFeedback_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PlaneStridesDataView {
 public:
  PlaneStridesDataView() = default;

  PlaneStridesDataView(
      internal::PlaneStrides_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStrideByPlaneDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStrideByPlane(UserType* output) {
    
    auto* pointer = data_->stride_by_plane.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
 private:
  internal::PlaneStrides_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoCaptureDeviceDescriptorDataView {
 public:
  VideoCaptureDeviceDescriptorDataView() = default;

  VideoCaptureDeviceDescriptorDataView(
      internal::VideoCaptureDeviceDescriptor_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDisplayNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayName(UserType* output) {
    
    auto* pointer = data_->display_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDeviceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceId(UserType* output) {
    
    auto* pointer = data_->device_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetModelIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModelId(UserType* output) {
    
    auto* pointer = data_->model_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFacingMode(UserType* output) const {
    auto data_value = data_->facing_mode;
    return mojo::internal::Deserialize<::media::mojom::VideoFacingMode>(
        data_value, output);
  }
  VideoFacingMode facing_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoFacingMode>(data_->facing_mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCaptureApi(UserType* output) const {
    auto data_value = data_->capture_api;
    return mojo::internal::Deserialize<::media::mojom::VideoCaptureApi>(
        data_value, output);
  }
  VideoCaptureApi capture_api() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoCaptureApi>(data_->capture_api));
  }
  inline void GetControlSupportDataView(
      VideoCaptureControlSupportDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadControlSupport(UserType* output) {
    
    auto* pointer = data_->control_support.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoCaptureControlSupportDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTransportType(UserType* output) const {
    auto data_value = data_->transport_type;
    return mojo::internal::Deserialize<::media::mojom::VideoCaptureTransportType>(
        data_value, output);
  }
  VideoCaptureTransportType transport_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoCaptureTransportType>(data_->transport_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAvailability(UserType* output) const {
    if (data_->header_.version < 1) {
      *output = std::nullopt;
      return true;
    }
    if (!data_->availability_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::media::mojom::CameraAvailability>(
        data_->availability_$value, &output->emplace());
  }
  std::optional<CameraAvailability> availability() const {
    if (data_->header_.version < 1) {
      return std::nullopt;
    }
    if (!data_->availability_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::CameraAvailability>(data_->availability_$value));
  }
 private:
  internal::VideoCaptureDeviceDescriptor_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoCaptureDeviceInfoDataView {
 public:
  VideoCaptureDeviceInfoDataView() = default;

  VideoCaptureDeviceInfoDataView(
      internal::VideoCaptureDeviceInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDescriptorDataView(
      VideoCaptureDeviceDescriptorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescriptor(UserType* output) {
    
    auto* pointer = data_->descriptor.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoCaptureDeviceDescriptorDataView>(
        pointer, output, message_);
  }
  inline void GetSupportedFormatsDataView(
      mojo::ArrayDataView<VideoCaptureFormatDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportedFormats(UserType* output) {
    
    auto* pointer = data_->supported_formats.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::VideoCaptureFormatDataView>>(
        pointer, output, message_);
  }
 private:
  internal::VideoCaptureDeviceInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media::mojom

namespace std {

template <>
struct hash<::media::mojom::VideoCapturePixelFormat>
    : public mojo::internal::EnumHashImpl<::media::mojom::VideoCapturePixelFormat> {};

template <>
struct hash<::media::mojom::ResolutionChangePolicy>
    : public mojo::internal::EnumHashImpl<::media::mojom::ResolutionChangePolicy> {};

template <>
struct hash<::media::mojom::PowerLineFrequency>
    : public mojo::internal::EnumHashImpl<::media::mojom::PowerLineFrequency> {};

template <>
struct hash<::media::mojom::VideoFacingMode>
    : public mojo::internal::EnumHashImpl<::media::mojom::VideoFacingMode> {};

template <>
struct hash<::media::mojom::CameraAvailability>
    : public mojo::internal::EnumHashImpl<::media::mojom::CameraAvailability> {};

template <>
struct hash<::media::mojom::VideoCaptureApi>
    : public mojo::internal::EnumHashImpl<::media::mojom::VideoCaptureApi> {};

template <>
struct hash<::media::mojom::VideoCaptureTransportType>
    : public mojo::internal::EnumHashImpl<::media::mojom::VideoCaptureTransportType> {};

template <>
struct hash<::media::mojom::VideoCaptureBufferType>
    : public mojo::internal::EnumHashImpl<::media::mojom::VideoCaptureBufferType> {};

template <>
struct hash<::media::mojom::VideoCaptureError>
    : public mojo::internal::EnumHashImpl<::media::mojom::VideoCaptureError> {};

template <>
struct hash<::media::mojom::VideoCaptureFrameDropReason>
    : public mojo::internal::EnumHashImpl<::media::mojom::VideoCaptureFrameDropReason> {};

template <>
struct hash<::media::mojom::SubCaptureTargetType>
    : public mojo::internal::EnumHashImpl<::media::mojom::SubCaptureTargetType> {};

template <>
struct hash<::media::mojom::ApplySubCaptureTargetResult>
    : public mojo::internal::EnumHashImpl<::media::mojom::ApplySubCaptureTargetResult> {};

template <>
struct hash<::media::mojom::DeviceEnumerationResult>
    : public mojo::internal::EnumHashImpl<::media::mojom::DeviceEnumerationResult> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoCapturePixelFormat, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::VideoCapturePixelFormat, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::VideoCapturePixelFormat>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::ResolutionChangePolicy, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::ResolutionChangePolicy, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::ResolutionChangePolicy>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::PowerLineFrequency, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::PowerLineFrequency, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::PowerLineFrequency>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoFacingMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::VideoFacingMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::VideoFacingMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::CameraAvailability, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::CameraAvailability, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::CameraAvailability>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoCaptureApi, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::VideoCaptureApi, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::VideoCaptureApi>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoCaptureTransportType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::VideoCaptureTransportType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::VideoCaptureTransportType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoCaptureBufferType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::VideoCaptureBufferType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::VideoCaptureBufferType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoCaptureError, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::VideoCaptureError, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::VideoCaptureError>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoCaptureFrameDropReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::VideoCaptureFrameDropReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::VideoCaptureFrameDropReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::SubCaptureTargetType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::SubCaptureTargetType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::SubCaptureTargetType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::ApplySubCaptureTargetResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::ApplySubCaptureTargetResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::ApplySubCaptureTargetResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::DeviceEnumerationResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::DeviceEnumerationResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::DeviceEnumerationResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoCaptureControlSupportDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoCaptureControlSupportDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoCaptureControlSupport_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->pan = Traits::pan(input);
    fragment->tilt = Traits::tilt(input);
    fragment->zoom = Traits::zoom(input);
  }

  static bool Deserialize(::media::mojom::internal::VideoCaptureControlSupport_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::VideoCaptureControlSupportDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoCaptureFormatDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoCaptureFormatDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoCaptureFormat_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::frame_size(input)) in_frame_size = Traits::frame_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_size)::BaseType> frame_size_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_frame_size, frame_size_fragment);
    fragment->frame_size.Set(
        frame_size_fragment.is_null() ? nullptr : frame_size_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->frame_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_size in VideoCaptureFormat struct");
    fragment->frame_rate = Traits::frame_rate(input);
    mojo::internal::Serialize<::media::mojom::VideoCapturePixelFormat>(
        Traits::pixel_format(input), &fragment->pixel_format);
  }

  static bool Deserialize(::media::mojom::internal::VideoCaptureFormat_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::VideoCaptureFormatDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoCaptureParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoCaptureParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoCaptureParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::requested_format(input)) in_requested_format = Traits::requested_format(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->requested_format)::BaseType> requested_format_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::VideoCaptureFormatDataView>(
        in_requested_format, requested_format_fragment);
    fragment->requested_format.Set(
        requested_format_fragment.is_null() ? nullptr : requested_format_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->requested_format.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null requested_format in VideoCaptureParams struct");
    mojo::internal::Serialize<::media::mojom::VideoCaptureBufferType>(
        Traits::buffer_type(input), &fragment->buffer_type);
    mojo::internal::Serialize<::media::mojom::ResolutionChangePolicy>(
        Traits::resolution_change_policy(input), &fragment->resolution_change_policy);
    mojo::internal::Serialize<::media::mojom::PowerLineFrequency>(
        Traits::power_line_frequency(input), &fragment->power_line_frequency);
    fragment->enable_face_detection = Traits::enable_face_detection(input);
    fragment->is_high_dpi_enabled = Traits::is_high_dpi_enabled(input);
  }

  static bool Deserialize(::media::mojom::internal::VideoCaptureParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::VideoCaptureParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoCaptureFeedbackDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoCaptureFeedbackDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoCaptureFeedback_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->resource_utilization = Traits::resource_utilization(input);
    fragment->max_framerate_fps = Traits::max_framerate_fps(input);
    fragment->max_pixels = Traits::max_pixels(input);
    fragment->require_mapped_frame = Traits::require_mapped_frame(input);
    decltype(Traits::DEPRECATED_mapped_sizes(input)) in_DEPRECATED_mapped_sizes = Traits::DEPRECATED_mapped_sizes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->DEPRECATED_mapped_sizes)::BaseType>
        DEPRECATED_mapped_sizes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& DEPRECATED_mapped_sizes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>>(
        in_DEPRECATED_mapped_sizes, DEPRECATED_mapped_sizes_fragment, &DEPRECATED_mapped_sizes_validate_params);
    fragment->DEPRECATED_mapped_sizes.Set(
        DEPRECATED_mapped_sizes_fragment.is_null() ? nullptr : DEPRECATED_mapped_sizes_fragment.data());
    fragment->frame_id = Traits::frame_id(input);
    fragment->has_frame_id = Traits::has_frame_id(input);
  }

  static bool Deserialize(::media::mojom::internal::VideoCaptureFeedback_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::VideoCaptureFeedbackDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::PlaneStridesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::PlaneStridesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::PlaneStrides_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::stride_by_plane(input)) in_stride_by_plane = Traits::stride_by_plane(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->stride_by_plane)::BaseType>
        stride_by_plane_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& stride_by_plane_validate_params =
        mojo::internal::GetArrayValidator<4, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
        in_stride_by_plane, stride_by_plane_fragment, &stride_by_plane_validate_params);
    fragment->stride_by_plane.Set(
        stride_by_plane_fragment.is_null() ? nullptr : stride_by_plane_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->stride_by_plane.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null stride_by_plane in PlaneStrides struct");
  }

  static bool Deserialize(::media::mojom::internal::PlaneStrides_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::PlaneStridesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoCaptureDeviceDescriptorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoCaptureDeviceDescriptorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoCaptureDeviceDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::display_name(input)) in_display_name = Traits::display_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_name)::BaseType> display_name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_display_name, display_name_fragment);
    fragment->display_name.Set(
        display_name_fragment.is_null() ? nullptr : display_name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->display_name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null display_name in VideoCaptureDeviceDescriptor struct");
    decltype(Traits::device_id(input)) in_device_id = Traits::device_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->device_id)::BaseType> device_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_device_id, device_id_fragment);
    fragment->device_id.Set(
        device_id_fragment.is_null() ? nullptr : device_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->device_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null device_id in VideoCaptureDeviceDescriptor struct");
    decltype(Traits::model_id(input)) in_model_id = Traits::model_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->model_id)::BaseType> model_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_model_id, model_id_fragment);
    fragment->model_id.Set(
        model_id_fragment.is_null() ? nullptr : model_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->model_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null model_id in VideoCaptureDeviceDescriptor struct");
    mojo::internal::Serialize<::media::mojom::VideoFacingMode>(
        Traits::facing_mode(input), &fragment->facing_mode);
    mojo::internal::Serialize<::media::mojom::VideoCaptureApi>(
        Traits::capture_api(input), &fragment->capture_api);
    decltype(Traits::control_support(input)) in_control_support = Traits::control_support(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->control_support)::BaseType> control_support_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::VideoCaptureControlSupportDataView>(
        in_control_support, control_support_fragment);
    fragment->control_support.Set(
        control_support_fragment.is_null() ? nullptr : control_support_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->control_support.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null control_support in VideoCaptureDeviceDescriptor struct");
    mojo::internal::Serialize<::media::mojom::VideoCaptureTransportType>(
        Traits::transport_type(input), &fragment->transport_type);
    fragment->availability_$flag = Traits::availability(input).has_value();
    if (Traits::availability(input).has_value()) {
      mojo::internal::Serialize<::media::mojom::CameraAvailability>(
          Traits::availability(input).value(), &fragment->availability_$value);
    } else {
      fragment->availability_$value =
          static_cast<int32_t>(::media::mojom::CameraAvailability::kMinValue);
    }
  }

  static bool Deserialize(::media::mojom::internal::VideoCaptureDeviceDescriptor_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::VideoCaptureDeviceDescriptorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoCaptureDeviceInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoCaptureDeviceInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoCaptureDeviceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::descriptor(input)) in_descriptor = Traits::descriptor(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->descriptor)::BaseType> descriptor_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::VideoCaptureDeviceDescriptorDataView>(
        in_descriptor, descriptor_fragment);
    fragment->descriptor.Set(
        descriptor_fragment.is_null() ? nullptr : descriptor_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->descriptor.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null descriptor in VideoCaptureDeviceInfo struct");
    decltype(Traits::supported_formats(input)) in_supported_formats = Traits::supported_formats(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->supported_formats)::BaseType>
        supported_formats_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& supported_formats_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::VideoCaptureFormatDataView>>(
        in_supported_formats, supported_formats_fragment, &supported_formats_validate_params);
    fragment->supported_formats.Set(
        supported_formats_fragment.is_null() ? nullptr : supported_formats_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->supported_formats.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null supported_formats in VideoCaptureDeviceInfo struct");
  }

  static bool Deserialize(::media::mojom::internal::VideoCaptureDeviceInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::VideoCaptureDeviceInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media::mojom {



inline void VideoCaptureFormatDataView::GetFrameSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->frame_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}


inline void VideoCaptureParamsDataView::GetRequestedFormatDataView(
    VideoCaptureFormatDataView* output) {
  auto pointer = data_->requested_format.Get();
  *output = VideoCaptureFormatDataView(pointer, message_);
}


inline void VideoCaptureFeedbackDataView::GetDeprecatedMappedSizesDataView(
    mojo::ArrayDataView<::gfx::mojom::SizeDataView>* output) {
  auto pointer = data_->header_.version >= 1
                 ? data_->DEPRECATED_mapped_sizes.Get() : nullptr;
  *output = mojo::ArrayDataView<::gfx::mojom::SizeDataView>(pointer, message_);
}


inline void PlaneStridesDataView::GetStrideByPlaneDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->stride_by_plane.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, message_);
}


inline void VideoCaptureDeviceDescriptorDataView::GetDisplayNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->display_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void VideoCaptureDeviceDescriptorDataView::GetDeviceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->device_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void VideoCaptureDeviceDescriptorDataView::GetModelIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->model_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void VideoCaptureDeviceDescriptorDataView::GetControlSupportDataView(
    VideoCaptureControlSupportDataView* output) {
  auto pointer = data_->control_support.Get();
  *output = VideoCaptureControlSupportDataView(pointer, message_);
}


inline void VideoCaptureDeviceInfoDataView::GetDescriptorDataView(
    VideoCaptureDeviceDescriptorDataView* output) {
  auto pointer = data_->descriptor.Get();
  *output = VideoCaptureDeviceDescriptorDataView(pointer, message_);
}
inline void VideoCaptureDeviceInfoDataView::GetSupportedFormatsDataView(
    mojo::ArrayDataView<VideoCaptureFormatDataView>* output) {
  auto pointer = data_->supported_formats.Get();
  *output = mojo::ArrayDataView<VideoCaptureFormatDataView>(pointer, message_);
}



}  // media::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::VideoCapturePixelFormat> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::VideoCapturePixelFormat value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::ResolutionChangePolicy> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::ResolutionChangePolicy value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::PowerLineFrequency> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::PowerLineFrequency value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::VideoFacingMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::VideoFacingMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::CameraAvailability> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::CameraAvailability value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::VideoCaptureApi> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::VideoCaptureApi value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::VideoCaptureTransportType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::VideoCaptureTransportType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::VideoCaptureBufferType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::VideoCaptureBufferType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::VideoCaptureError> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::VideoCaptureError value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::VideoCaptureFrameDropReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::VideoCaptureFrameDropReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::SubCaptureTargetType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::SubCaptureTargetType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::ApplySubCaptureTargetResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::ApplySubCaptureTargetResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::DeviceEnumerationResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::DeviceEnumerationResult value);
};

} // namespace perfetto

#endif  // MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_TYPES_MOJOM_SHARED_H_