// media/capture/mojom/video_effects_manager.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_CAPTURE_MOJOM_VIDEO_EFFECTS_MANAGER_MOJOM_H_
#define MEDIA_CAPTURE_MOJOM_VIDEO_EFFECTS_MANAGER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/capture/mojom/video_effects_manager.mojom-features.h"  // IWYU pragma: export
#include "media/capture/mojom/video_effects_manager.mojom-shared.h"  // IWYU pragma: export
#include "media/capture/mojom/video_effects_manager.mojom-forward.h"  // IWYU pragma: export
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace media::mojom {

class VideoEffectsConfigurationObserverProxy;

template <typename ImplRefTraits>
class VideoEffectsConfigurationObserverStub;

class VideoEffectsConfigurationObserverRequestValidator;


class VideoEffectsConfigurationObserver
    : public VideoEffectsConfigurationObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = VideoEffectsConfigurationObserverInterfaceBase;
  using Proxy_ = VideoEffectsConfigurationObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = VideoEffectsConfigurationObserverStub<ImplRefTraits>;

  using RequestValidator_ = VideoEffectsConfigurationObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnConfigurationChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnConfigurationChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~VideoEffectsConfigurationObserver() = default;

  
  virtual void OnConfigurationChanged(VideoEffectsConfigurationPtr configuration) = 0;
};

class ReadonlyVideoEffectsManagerProxy;

template <typename ImplRefTraits>
class ReadonlyVideoEffectsManagerStub;

class ReadonlyVideoEffectsManagerRequestValidator;
class ReadonlyVideoEffectsManagerResponseValidator;


class ReadonlyVideoEffectsManager
    : public ReadonlyVideoEffectsManagerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ReadonlyVideoEffectsManagerInterfaceBase;
  using Proxy_ = ReadonlyVideoEffectsManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ReadonlyVideoEffectsManagerStub<ImplRefTraits>;

  using RequestValidator_ = ReadonlyVideoEffectsManagerRequestValidator;
  using ResponseValidator_ = ReadonlyVideoEffectsManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetConfigurationMinVersion = 0,
    kAddObserverMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetConfiguration_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddObserver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ReadonlyVideoEffectsManager() = default;


  using GetConfigurationCallback = base::OnceCallback<void(VideoEffectsConfigurationPtr)>;
  
  virtual void GetConfiguration(GetConfigurationCallback callback) = 0;

  
  virtual void AddObserver(::mojo::PendingRemote<VideoEffectsConfigurationObserver> observer) = 0;
};



class  VideoEffectsConfigurationObserverProxy
    : public VideoEffectsConfigurationObserver {
 public:
  using InterfaceType = VideoEffectsConfigurationObserver;

  explicit VideoEffectsConfigurationObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnConfigurationChanged(VideoEffectsConfigurationPtr configuration) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ReadonlyVideoEffectsManagerProxy
    : public ReadonlyVideoEffectsManager {
 public:
  using InterfaceType = ReadonlyVideoEffectsManager;

  explicit ReadonlyVideoEffectsManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetConfiguration(GetConfigurationCallback callback) final;
  
  void AddObserver(::mojo::PendingRemote<VideoEffectsConfigurationObserver> observer) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  VideoEffectsConfigurationObserverStubDispatch {
 public:
  static bool Accept(VideoEffectsConfigurationObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VideoEffectsConfigurationObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VideoEffectsConfigurationObserver>>
class VideoEffectsConfigurationObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VideoEffectsConfigurationObserverStub() = default;
  ~VideoEffectsConfigurationObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoEffectsConfigurationObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoEffectsConfigurationObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ReadonlyVideoEffectsManagerStubDispatch {
 public:
  static bool Accept(ReadonlyVideoEffectsManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ReadonlyVideoEffectsManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ReadonlyVideoEffectsManager>>
class ReadonlyVideoEffectsManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ReadonlyVideoEffectsManagerStub() = default;
  ~ReadonlyVideoEffectsManagerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ReadonlyVideoEffectsManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ReadonlyVideoEffectsManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  VideoEffectsConfigurationObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ReadonlyVideoEffectsManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ReadonlyVideoEffectsManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  ImageEnhancement {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ImageEnhancement, T>::value>;
  using DataView = ImageEnhancementDataView;
  using Data_ = internal::ImageEnhancement_Data;

  template <typename... Args>
  static ImageEnhancementPtr New(Args&&... args) {
    return ImageEnhancementPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ImageEnhancementPtr From(const U& u) {
    return mojo::TypeConverter<ImageEnhancementPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ImageEnhancement>::Convert(*this);
  }


  ImageEnhancement();

  explicit ImageEnhancement(
      bool lighting);


  ~ImageEnhancement();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ImageEnhancementPtr>
  ImageEnhancementPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ImageEnhancement::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ImageEnhancement::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ImageEnhancement::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ImageEnhancement::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ImageEnhancement::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ImageEnhancement_UnserializedMessageContext<
            UserType, ImageEnhancement::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ImageEnhancement::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ImageEnhancement::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ImageEnhancement_UnserializedMessageContext<
            UserType, ImageEnhancement::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ImageEnhancement::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool lighting;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ImageEnhancement::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ImageEnhancement::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ImageEnhancement::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ImageEnhancement::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Blur {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Blur, T>::value>;
  using DataView = BlurDataView;
  using Data_ = internal::Blur_Data;

  template <typename... Args>
  static BlurPtr New(Args&&... args) {
    return BlurPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BlurPtr From(const U& u) {
    return mojo::TypeConverter<BlurPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Blur>::Convert(*this);
  }


  Blur();


  ~Blur();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BlurPtr>
  BlurPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Blur::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Blur::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Blur::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Blur::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Blur::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Blur_UnserializedMessageContext<
            UserType, Blur::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Blur::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Blur::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Blur_UnserializedMessageContext<
            UserType, Blur::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Blur::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Blur::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Blur::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Blur::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Blur::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}











class  Framing {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Framing, T>::value>;
  using DataView = FramingDataView;
  using Data_ = internal::Framing_Data;

  template <typename... Args>
  static FramingPtr New(Args&&... args) {
    return FramingPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FramingPtr From(const U& u) {
    return mojo::TypeConverter<FramingPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Framing>::Convert(*this);
  }


  Framing();

  explicit Framing(
      const ::gfx::InsetsF& padding_ratios);


  ~Framing();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FramingPtr>
  FramingPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Framing::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Framing::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Framing::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Framing::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Framing::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Framing_UnserializedMessageContext<
            UserType, Framing::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Framing::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Framing::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Framing_UnserializedMessageContext<
            UserType, Framing::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Framing::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::InsetsF padding_ratios;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Framing::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Framing::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Framing::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Framing::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  VideoEffectsConfiguration {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoEffectsConfiguration, T>::value>;
  using DataView = VideoEffectsConfigurationDataView;
  using Data_ = internal::VideoEffectsConfiguration_Data;

  template <typename... Args>
  static VideoEffectsConfigurationPtr New(Args&&... args) {
    return VideoEffectsConfigurationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoEffectsConfigurationPtr From(const U& u) {
    return mojo::TypeConverter<VideoEffectsConfigurationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoEffectsConfiguration>::Convert(*this);
  }


  VideoEffectsConfiguration();

  VideoEffectsConfiguration(
      ImageEnhancementPtr image_enhancement,
      BlurPtr blur,
      FramingPtr framing);

VideoEffectsConfiguration(const VideoEffectsConfiguration&) = delete;
VideoEffectsConfiguration& operator=(const VideoEffectsConfiguration&) = delete;

  ~VideoEffectsConfiguration();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoEffectsConfigurationPtr>
  VideoEffectsConfigurationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoEffectsConfiguration::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoEffectsConfiguration::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoEffectsConfiguration::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoEffectsConfiguration::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoEffectsConfiguration::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoEffectsConfiguration_UnserializedMessageContext<
            UserType, VideoEffectsConfiguration::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoEffectsConfiguration::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoEffectsConfiguration::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoEffectsConfiguration_UnserializedMessageContext<
            UserType, VideoEffectsConfiguration::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoEffectsConfiguration::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ImageEnhancementPtr image_enhancement;
  
  BlurPtr blur;
  
  FramingPtr framing;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoEffectsConfiguration::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoEffectsConfiguration::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoEffectsConfiguration::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoEffectsConfiguration::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ImageEnhancementPtr ImageEnhancement::Clone() const {
  return New(
      mojo::Clone(lighting)
  );
}

template <typename T, ImageEnhancement::EnableIfSame<T>*>
bool ImageEnhancement::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->lighting, other_struct.lighting))
    return false;
  return true;
}

template <typename T, ImageEnhancement::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.lighting < rhs.lighting)
    return true;
  if (rhs.lighting < lhs.lighting)
    return false;
  return false;
}
template <typename StructPtrType>
BlurPtr Blur::Clone() const {
  return New(
  );
}

template <typename T, Blur::EnableIfSame<T>*>
bool Blur::Equals(const T& other_struct) const {
  return true;
}

template <typename T, Blur::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
FramingPtr Framing::Clone() const {
  return New(
      mojo::Clone(padding_ratios)
  );
}

template <typename T, Framing::EnableIfSame<T>*>
bool Framing::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->padding_ratios, other_struct.padding_ratios))
    return false;
  return true;
}

template <typename T, Framing::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.padding_ratios < rhs.padding_ratios)
    return true;
  if (rhs.padding_ratios < lhs.padding_ratios)
    return false;
  return false;
}
template <typename StructPtrType>
VideoEffectsConfigurationPtr VideoEffectsConfiguration::Clone() const {
  return New(
      mojo::Clone(image_enhancement),
      mojo::Clone(blur),
      mojo::Clone(framing)
  );
}

template <typename T, VideoEffectsConfiguration::EnableIfSame<T>*>
bool VideoEffectsConfiguration::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->image_enhancement, other_struct.image_enhancement))
    return false;
  if (!mojo::Equals(this->blur, other_struct.blur))
    return false;
  if (!mojo::Equals(this->framing, other_struct.framing))
    return false;
  return true;
}

template <typename T, VideoEffectsConfiguration::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.image_enhancement < rhs.image_enhancement)
    return true;
  if (rhs.image_enhancement < lhs.image_enhancement)
    return false;
  if (lhs.blur < rhs.blur)
    return true;
  if (rhs.blur < lhs.blur)
    return false;
  if (lhs.framing < rhs.framing)
    return true;
  if (rhs.framing < lhs.framing)
    return false;
  return false;
}


}  // media::mojom

namespace mojo {


template <>
struct  StructTraits<::media::mojom::ImageEnhancement::DataView,
                                         ::media::mojom::ImageEnhancementPtr> {
  static bool IsNull(const ::media::mojom::ImageEnhancementPtr& input) { return !input; }
  static void SetToNull(::media::mojom::ImageEnhancementPtr* output) { output->reset(); }

  static decltype(::media::mojom::ImageEnhancement::lighting) lighting(
      const ::media::mojom::ImageEnhancementPtr& input) {
    return input->lighting;
  }

  static bool Read(::media::mojom::ImageEnhancement::DataView input, ::media::mojom::ImageEnhancementPtr* output);
};


template <>
struct  StructTraits<::media::mojom::Blur::DataView,
                                         ::media::mojom::BlurPtr> {
  static bool IsNull(const ::media::mojom::BlurPtr& input) { return !input; }
  static void SetToNull(::media::mojom::BlurPtr* output) { output->reset(); }

  static bool Read(::media::mojom::Blur::DataView input, ::media::mojom::BlurPtr* output);
};


template <>
struct  StructTraits<::media::mojom::Framing::DataView,
                                         ::media::mojom::FramingPtr> {
  static bool IsNull(const ::media::mojom::FramingPtr& input) { return !input; }
  static void SetToNull(::media::mojom::FramingPtr* output) { output->reset(); }

  static const decltype(::media::mojom::Framing::padding_ratios)& padding_ratios(
      const ::media::mojom::FramingPtr& input) {
    return input->padding_ratios;
  }

  static bool Read(::media::mojom::Framing::DataView input, ::media::mojom::FramingPtr* output);
};


template <>
struct  StructTraits<::media::mojom::VideoEffectsConfiguration::DataView,
                                         ::media::mojom::VideoEffectsConfigurationPtr> {
  static bool IsNull(const ::media::mojom::VideoEffectsConfigurationPtr& input) { return !input; }
  static void SetToNull(::media::mojom::VideoEffectsConfigurationPtr* output) { output->reset(); }

  static const decltype(::media::mojom::VideoEffectsConfiguration::image_enhancement)& image_enhancement(
      const ::media::mojom::VideoEffectsConfigurationPtr& input) {
    return input->image_enhancement;
  }

  static const decltype(::media::mojom::VideoEffectsConfiguration::blur)& blur(
      const ::media::mojom::VideoEffectsConfigurationPtr& input) {
    return input->blur;
  }

  static const decltype(::media::mojom::VideoEffectsConfiguration::framing)& framing(
      const ::media::mojom::VideoEffectsConfigurationPtr& input) {
    return input->framing;
  }

  static bool Read(::media::mojom::VideoEffectsConfiguration::DataView input, ::media::mojom::VideoEffectsConfigurationPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_CAPTURE_MOJOM_VIDEO_EFFECTS_MANAGER_MOJOM_H_