// media/mojo/mojom/audio_data_pipe.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_AUDIO_DATA_PIPE_MOJOM_BLINK_H_
#define MEDIA_MOJO_MOJOM_AUDIO_DATA_PIPE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/audio_data_pipe.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/audio_data_pipe.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/audio_data_pipe.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/shared_memory.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace media::mojom::blink {








class BLINK_PLATFORM_EXPORT ReadWriteAudioDataPipe {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ReadWriteAudioDataPipe, T>::value>;
  using DataView = ReadWriteAudioDataPipeDataView;
  using Data_ = internal::ReadWriteAudioDataPipe_Data;

  template <typename... Args>
  static ReadWriteAudioDataPipePtr New(Args&&... args) {
    return ReadWriteAudioDataPipePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ReadWriteAudioDataPipePtr From(const U& u) {
    return mojo::TypeConverter<ReadWriteAudioDataPipePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ReadWriteAudioDataPipe>::Convert(*this);
  }


  ReadWriteAudioDataPipe();

  ReadWriteAudioDataPipe(
      ::base::UnsafeSharedMemoryRegion shared_memory,
      ::mojo::PlatformHandle socket);

ReadWriteAudioDataPipe(const ReadWriteAudioDataPipe&) = delete;
ReadWriteAudioDataPipe& operator=(const ReadWriteAudioDataPipe&) = delete;

  ~ReadWriteAudioDataPipe();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ReadWriteAudioDataPipePtr>
  ReadWriteAudioDataPipePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ReadWriteAudioDataPipe::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ReadWriteAudioDataPipe::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ReadWriteAudioDataPipe::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ReadWriteAudioDataPipe::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ReadWriteAudioDataPipe_UnserializedMessageContext<
            UserType, ReadWriteAudioDataPipe::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ReadWriteAudioDataPipe::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ReadWriteAudioDataPipe::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ReadWriteAudioDataPipe_UnserializedMessageContext<
            UserType, ReadWriteAudioDataPipe::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ReadWriteAudioDataPipe::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnsafeSharedMemoryRegion shared_memory;
  
  ::mojo::PlatformHandle socket;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ReadWriteAudioDataPipe::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ReadWriteAudioDataPipe::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ReadWriteAudioDataPipe::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ReadWriteAudioDataPipe::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ReadWriteAudioDataPipePtr ReadWriteAudioDataPipe::Clone() const {
  return New(
      mojo::Clone(shared_memory),
      mojo::Clone(socket)
  );
}

template <typename T, ReadWriteAudioDataPipe::EnableIfSame<T>*>
bool ReadWriteAudioDataPipe::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->shared_memory, other_struct.shared_memory))
    return false;
  if (!mojo::Equals(this->socket, other_struct.socket))
    return false;
  return true;
}

template <typename T, ReadWriteAudioDataPipe::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.shared_memory < rhs.shared_memory)
    return true;
  if (rhs.shared_memory < lhs.shared_memory)
    return false;
  if (lhs.socket < rhs.socket)
    return true;
  if (rhs.socket < lhs.socket)
    return false;
  return false;
}


}  // media::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::ReadWriteAudioDataPipe::DataView,
                                         ::media::mojom::blink::ReadWriteAudioDataPipePtr> {
  static bool IsNull(const ::media::mojom::blink::ReadWriteAudioDataPipePtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::ReadWriteAudioDataPipePtr* output) { output->reset(); }

  static  decltype(::media::mojom::blink::ReadWriteAudioDataPipe::shared_memory)& shared_memory(
       ::media::mojom::blink::ReadWriteAudioDataPipePtr& input) {
    return input->shared_memory;
  }

  static  decltype(::media::mojom::blink::ReadWriteAudioDataPipe::socket)& socket(
       ::media::mojom::blink::ReadWriteAudioDataPipePtr& input) {
    return input->socket;
  }

  static bool Read(::media::mojom::blink::ReadWriteAudioDataPipe::DataView input, ::media::mojom::blink::ReadWriteAudioDataPipePtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_AUDIO_DATA_PIPE_MOJOM_BLINK_H_