// media/mojo/mojom/media_types.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_MEDIA_TYPES_MOJOM_BLINK_H_
#define MEDIA_MOJO_MOJOM_MEDIA_TYPES_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/media_types.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/media_types.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/media_types.mojom-blink-forward.h"  // IWYU pragma: export
#include "gpu/ipc/common/exported_shared_image.mojom-blink.h"
#include "gpu/ipc/common/mailbox.mojom-blink-forward.h"
#include "gpu/ipc/common/sync_token.mojom-blink.h"
#include "gpu/ipc/common/vulkan_ycbcr_info.mojom-blink.h"
#include "media/mojo/mojom/audio_data.mojom-blink-forward.h"
#include "media/mojo/mojom/encryption_pattern.mojom-blink.h"
#include "mojo/public/mojom/base/byte_string.mojom-blink.h"
#include "mojo/public/mojom/base/shared_memory.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "mojo/public/mojom/base/values.mojom-blink.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "ui/gfx/mojom/buffer_types.mojom-blink.h"
#include "ui/gfx/mojom/color_space.mojom-blink.h"
#include "ui/gfx/mojom/hdr_metadata.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "media/base/ipc/media_param_traits_macros.h"
#include "media/mojo/mojom/video_frame_metadata_mojom_traits.h"
#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace media::mojom::blink {






class BLINK_PLATFORM_EXPORT VideoTransformation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoTransformation, T>::value>;
  using DataView = VideoTransformationDataView;
  using Data_ = internal::VideoTransformation_Data;

  template <typename... Args>
  static VideoTransformationPtr New(Args&&... args) {
    return VideoTransformationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoTransformationPtr From(const U& u) {
    return mojo::TypeConverter<VideoTransformationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoTransformation>::Convert(*this);
  }


  VideoTransformation();

  VideoTransformation(
      VideoRotation rotation,
      bool mirrored);


  ~VideoTransformation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoTransformationPtr>
  VideoTransformationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoTransformation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoTransformation::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoTransformation::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoTransformation::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoTransformation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoTransformation_UnserializedMessageContext<
            UserType, VideoTransformation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoTransformation::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoTransformation::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoTransformation_UnserializedMessageContext<
            UserType, VideoTransformation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoTransformation::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  VideoRotation rotation;
  
  bool mirrored;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoTransformation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoTransformation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoTransformation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoTransformation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT VideoAspectRatio {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoAspectRatio, T>::value>;
  using DataView = VideoAspectRatioDataView;
  using Data_ = internal::VideoAspectRatio_Data;
  using Type = VideoAspectRatio_Type;

  template <typename... Args>
  static VideoAspectRatioPtr New(Args&&... args) {
    return VideoAspectRatioPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoAspectRatioPtr From(const U& u) {
    return mojo::TypeConverter<VideoAspectRatioPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoAspectRatio>::Convert(*this);
  }


  VideoAspectRatio();

  VideoAspectRatio(
      VideoAspectRatio::Type type,
      double value);


  ~VideoAspectRatio();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoAspectRatioPtr>
  VideoAspectRatioPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoAspectRatio::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoAspectRatio::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoAspectRatio::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoAspectRatio::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoAspectRatio::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoAspectRatio_UnserializedMessageContext<
            UserType, VideoAspectRatio::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoAspectRatio::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoAspectRatio::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoAspectRatio_UnserializedMessageContext<
            UserType, VideoAspectRatio::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoAspectRatio::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  VideoAspectRatio::Type type;
  
  double value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoAspectRatio::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoAspectRatio::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoAspectRatio::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoAspectRatio::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT VideoColorSpace {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoColorSpace, T>::value>;
  using DataView = VideoColorSpaceDataView;
  using Data_ = internal::VideoColorSpace_Data;
  using PrimaryID = VideoColorSpace_PrimaryID;
  using TransferID = VideoColorSpace_TransferID;
  using MatrixID = VideoColorSpace_MatrixID;
  using RangeID = VideoColorSpace_RangeID;

  template <typename... Args>
  static VideoColorSpacePtr New(Args&&... args) {
    return VideoColorSpacePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoColorSpacePtr From(const U& u) {
    return mojo::TypeConverter<VideoColorSpacePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoColorSpace>::Convert(*this);
  }


  VideoColorSpace();

  VideoColorSpace(
      VideoColorSpace::PrimaryID primaries,
      VideoColorSpace::TransferID transfer,
      VideoColorSpace::MatrixID matrix,
      VideoColorSpace::RangeID range);


  ~VideoColorSpace();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoColorSpacePtr>
  VideoColorSpacePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoColorSpace::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoColorSpace::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoColorSpace::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoColorSpace::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoColorSpace::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoColorSpace_UnserializedMessageContext<
            UserType, VideoColorSpace::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoColorSpace::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoColorSpace::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoColorSpace_UnserializedMessageContext<
            UserType, VideoColorSpace::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoColorSpace::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  VideoColorSpace::PrimaryID primaries;
  
  VideoColorSpace::TransferID transfer;
  
  VideoColorSpace::MatrixID matrix;
  
  VideoColorSpace::RangeID range;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoColorSpace::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoColorSpace::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoColorSpace::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoColorSpace::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}















class BLINK_PLATFORM_EXPORT EosVideoFrameData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EosVideoFrameData, T>::value>;
  using DataView = EosVideoFrameDataDataView;
  using Data_ = internal::EosVideoFrameData_Data;

  template <typename... Args>
  static EosVideoFrameDataPtr New(Args&&... args) {
    return EosVideoFrameDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EosVideoFrameDataPtr From(const U& u) {
    return mojo::TypeConverter<EosVideoFrameDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EosVideoFrameData>::Convert(*this);
  }


  EosVideoFrameData();


  ~EosVideoFrameData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EosVideoFrameDataPtr>
  EosVideoFrameDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EosVideoFrameData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EosVideoFrameData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EosVideoFrameData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EosVideoFrameData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EosVideoFrameData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EosVideoFrameData_UnserializedMessageContext<
            UserType, EosVideoFrameData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EosVideoFrameData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EosVideoFrameData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EosVideoFrameData_UnserializedMessageContext<
            UserType, EosVideoFrameData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EosVideoFrameData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EosVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EosVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EosVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EosVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class BLINK_PLATFORM_EXPORT OpaqueVideoFrameData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OpaqueVideoFrameData, T>::value>;
  using DataView = OpaqueVideoFrameDataDataView;
  using Data_ = internal::OpaqueVideoFrameData_Data;

  template <typename... Args>
  static OpaqueVideoFrameDataPtr New(Args&&... args) {
    return OpaqueVideoFrameDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OpaqueVideoFrameDataPtr From(const U& u) {
    return mojo::TypeConverter<OpaqueVideoFrameDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OpaqueVideoFrameData>::Convert(*this);
  }


  OpaqueVideoFrameData();


  ~OpaqueVideoFrameData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OpaqueVideoFrameDataPtr>
  OpaqueVideoFrameDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OpaqueVideoFrameData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OpaqueVideoFrameData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OpaqueVideoFrameData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OpaqueVideoFrameData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OpaqueVideoFrameData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OpaqueVideoFrameData_UnserializedMessageContext<
            UserType, OpaqueVideoFrameData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OpaqueVideoFrameData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OpaqueVideoFrameData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OpaqueVideoFrameData_UnserializedMessageContext<
            UserType, OpaqueVideoFrameData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OpaqueVideoFrameData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OpaqueVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OpaqueVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OpaqueVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OpaqueVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class BLINK_PLATFORM_EXPORT PredictionTargets {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PredictionTargets, T>::value>;
  using DataView = PredictionTargetsDataView;
  using Data_ = internal::PredictionTargets_Data;

  template <typename... Args>
  static PredictionTargetsPtr New(Args&&... args) {
    return PredictionTargetsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PredictionTargetsPtr From(const U& u) {
    return mojo::TypeConverter<PredictionTargetsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PredictionTargets>::Convert(*this);
  }


  PredictionTargets();

  PredictionTargets(
      uint32_t frames_decoded,
      uint32_t frames_dropped,
      uint32_t frames_power_efficient);


  ~PredictionTargets();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PredictionTargetsPtr>
  PredictionTargetsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PredictionTargets::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PredictionTargets::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PredictionTargets::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PredictionTargets::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PredictionTargets::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PredictionTargets_UnserializedMessageContext<
            UserType, PredictionTargets::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PredictionTargets::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PredictionTargets::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PredictionTargets_UnserializedMessageContext<
            UserType, PredictionTargets::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PredictionTargets::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t frames_decoded;
  
  uint32_t frames_dropped;
  
  uint32_t frames_power_efficient;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PredictionTargets::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PredictionTargets::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PredictionTargets::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PredictionTargets::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT AudioPipelineInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AudioPipelineInfo, T>::value>;
  using DataView = AudioPipelineInfoDataView;
  using Data_ = internal::AudioPipelineInfo_Data;

  template <typename... Args>
  static AudioPipelineInfoPtr New(Args&&... args) {
    return AudioPipelineInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AudioPipelineInfoPtr From(const U& u) {
    return mojo::TypeConverter<AudioPipelineInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AudioPipelineInfo>::Convert(*this);
  }


  AudioPipelineInfo();

  AudioPipelineInfo(
      AudioDecoderType decoder_type,
      bool is_platform_decoder,
      bool has_decrypting_demuxer_stream,
      EncryptionType encryption_type);


  ~AudioPipelineInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AudioPipelineInfoPtr>
  AudioPipelineInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AudioPipelineInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AudioPipelineInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AudioPipelineInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AudioPipelineInfo::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AudioPipelineInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AudioPipelineInfo_UnserializedMessageContext<
            UserType, AudioPipelineInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AudioPipelineInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AudioPipelineInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AudioPipelineInfo_UnserializedMessageContext<
            UserType, AudioPipelineInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AudioPipelineInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  AudioDecoderType decoder_type;
  
  bool is_platform_decoder;
  
  bool has_decrypting_demuxer_stream;
  
  EncryptionType encryption_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AudioPipelineInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AudioPipelineInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AudioPipelineInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AudioPipelineInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT VideoPipelineInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoPipelineInfo, T>::value>;
  using DataView = VideoPipelineInfoDataView;
  using Data_ = internal::VideoPipelineInfo_Data;

  template <typename... Args>
  static VideoPipelineInfoPtr New(Args&&... args) {
    return VideoPipelineInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoPipelineInfoPtr From(const U& u) {
    return mojo::TypeConverter<VideoPipelineInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoPipelineInfo>::Convert(*this);
  }


  VideoPipelineInfo();

  VideoPipelineInfo(
      VideoDecoderType decoder_type,
      bool is_platform_decoder,
      bool has_decrypting_demuxer_stream,
      EncryptionType encryption_type);


  ~VideoPipelineInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoPipelineInfoPtr>
  VideoPipelineInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoPipelineInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoPipelineInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoPipelineInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoPipelineInfo::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoPipelineInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoPipelineInfo_UnserializedMessageContext<
            UserType, VideoPipelineInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoPipelineInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoPipelineInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoPipelineInfo_UnserializedMessageContext<
            UserType, VideoPipelineInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoPipelineInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  VideoDecoderType decoder_type;
  
  bool is_platform_decoder;
  
  bool has_decrypting_demuxer_stream;
  
  EncryptionType encryption_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoPipelineInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoPipelineInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoPipelineInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoPipelineInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class BLINK_PLATFORM_EXPORT DecoderBufferSideDataNextConfig {
 public:
  using DataView = DecoderBufferSideDataNextConfigDataView;
  using Data_ = internal::DecoderBufferSideDataNextConfig_Data;
  using Tag = Data_::DecoderBufferSideDataNextConfig_Tag;

  template <typename... Args>
  static DecoderBufferSideDataNextConfigPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }
  // Construct an instance holding |next_audio_config|.
  static DecoderBufferSideDataNextConfigPtr
  NewNextAudioConfig(
      AudioDecoderConfigPtr value) {
    auto result = DecoderBufferSideDataNextConfigPtr(std::in_place);
    result->set_next_audio_config(std::move(value));
    return result;
  }
  // Construct an instance holding |next_video_config|.
  static DecoderBufferSideDataNextConfigPtr
  NewNextVideoConfig(
      VideoDecoderConfigPtr value) {
    auto result = DecoderBufferSideDataNextConfigPtr(std::in_place);
    result->set_next_video_config(std::move(value));
    return result;
  }

  template <typename U>
  static DecoderBufferSideDataNextConfigPtr From(const U& u) {
    return mojo::TypeConverter<DecoderBufferSideDataNextConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DecoderBufferSideDataNextConfig>::Convert(*this);
  }

  DecoderBufferSideDataNextConfig();
  ~DecoderBufferSideDataNextConfig();
  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  DecoderBufferSideDataNextConfig(const DecoderBufferSideDataNextConfig& other) = delete;
  DecoderBufferSideDataNextConfig& operator=(const DecoderBufferSideDataNextConfig& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = DecoderBufferSideDataNextConfigPtr>
  DecoderBufferSideDataNextConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, DecoderBufferSideDataNextConfig>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, DecoderBufferSideDataNextConfig>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }


  
  bool is_next_audio_config() const { return tag_ == Tag::kNextAudioConfig; }

  
  AudioDecoderConfigPtr& get_next_audio_config() const {
    CHECK(tag_ == Tag::kNextAudioConfig);
    return *(data_.next_audio_config);
  }

  
  void set_next_audio_config(
      AudioDecoderConfigPtr next_audio_config);
  
  bool is_next_video_config() const { return tag_ == Tag::kNextVideoConfig; }

  
  VideoDecoderConfigPtr& get_next_video_config() const {
    CHECK(tag_ == Tag::kNextVideoConfig);
    return *(data_.next_video_config);
  }

  
  void set_next_video_config(
      VideoDecoderConfigPtr next_video_config);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DecoderBufferSideDataNextConfig::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<DecoderBufferSideDataNextConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  union Union_ {
    Union_() = default;
    ~Union_() = default;
    AudioDecoderConfigPtr* next_audio_config;
    VideoDecoderConfigPtr* next_video_config;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class BLINK_PLATFORM_EXPORT DecoderBuffer {
 public:
  using DataView = DecoderBufferDataView;
  using Data_ = internal::DecoderBuffer_Data;
  using Tag = Data_::DecoderBuffer_Tag;

  template <typename... Args>
  static DecoderBufferPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }
  // Construct an instance holding |eos|.
  static DecoderBufferPtr
  NewEos(
      EosDecoderBufferPtr value) {
    auto result = DecoderBufferPtr(std::in_place);
    result->set_eos(std::move(value));
    return result;
  }
  // Construct an instance holding |data|.
  static DecoderBufferPtr
  NewData(
      DataDecoderBufferPtr value) {
    auto result = DecoderBufferPtr(std::in_place);
    result->set_data(std::move(value));
    return result;
  }

  template <typename U>
  static DecoderBufferPtr From(const U& u) {
    return mojo::TypeConverter<DecoderBufferPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DecoderBuffer>::Convert(*this);
  }

  DecoderBuffer();
  ~DecoderBuffer();
  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  DecoderBuffer(const DecoderBuffer& other) = delete;
  DecoderBuffer& operator=(const DecoderBuffer& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = DecoderBufferPtr>
  DecoderBufferPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, DecoderBuffer>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, DecoderBuffer>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }


  
  bool is_eos() const { return tag_ == Tag::kEos; }

  
  EosDecoderBufferPtr& get_eos() const {
    CHECK(tag_ == Tag::kEos);
    return *(data_.eos);
  }

  
  void set_eos(
      EosDecoderBufferPtr eos);
  
  bool is_data() const { return tag_ == Tag::kData; }

  
  DataDecoderBufferPtr& get_data() const {
    CHECK(tag_ == Tag::kData);
    return *(data_.data);
  }

  
  void set_data(
      DataDecoderBufferPtr data);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DecoderBuffer::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<DecoderBuffer::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  union Union_ {
    Union_() = default;
    ~Union_() = default;
    EosDecoderBufferPtr* eos;
    DataDecoderBufferPtr* data;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class BLINK_PLATFORM_EXPORT VideoFrameData {
 public:
  using DataView = VideoFrameDataDataView;
  using Data_ = internal::VideoFrameData_Data;
  using Tag = Data_::VideoFrameData_Tag;

  template <typename... Args>
  static VideoFrameDataPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }
  // Construct an instance holding |eos_data|.
  static VideoFrameDataPtr
  NewEosData(
      EosVideoFrameDataPtr value) {
    auto result = VideoFrameDataPtr(std::in_place);
    result->set_eos_data(std::move(value));
    return result;
  }
  // Construct an instance holding |shared_memory_data|.
  static VideoFrameDataPtr
  NewSharedMemoryData(
      SharedMemoryVideoFrameDataPtr value) {
    auto result = VideoFrameDataPtr(std::in_place);
    result->set_shared_memory_data(std::move(value));
    return result;
  }
  // Construct an instance holding |gpu_memory_buffer_shared_image_data|.
  static VideoFrameDataPtr
  NewGpuMemoryBufferSharedImageData(
      GpuMemoryBufferSharedImageVideoFrameDataPtr value) {
    auto result = VideoFrameDataPtr(std::in_place);
    result->set_gpu_memory_buffer_shared_image_data(std::move(value));
    return result;
  }
  // Construct an instance holding |shared_image_data|.
  static VideoFrameDataPtr
  NewSharedImageData(
      SharedImageVideoFrameDataPtr value) {
    auto result = VideoFrameDataPtr(std::in_place);
    result->set_shared_image_data(std::move(value));
    return result;
  }
  // Construct an instance holding |opaque_data|.
  static VideoFrameDataPtr
  NewOpaqueData(
      OpaqueVideoFrameDataPtr value) {
    auto result = VideoFrameDataPtr(std::in_place);
    result->set_opaque_data(std::move(value));
    return result;
  }

  template <typename U>
  static VideoFrameDataPtr From(const U& u) {
    return mojo::TypeConverter<VideoFrameDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoFrameData>::Convert(*this);
  }

  VideoFrameData();
  ~VideoFrameData();
  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  VideoFrameData(const VideoFrameData& other) = delete;
  VideoFrameData& operator=(const VideoFrameData& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = VideoFrameDataPtr>
  VideoFrameDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, VideoFrameData>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, VideoFrameData>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }


  
  bool is_eos_data() const { return tag_ == Tag::kEosData; }

  
  EosVideoFrameDataPtr& get_eos_data() const {
    CHECK(tag_ == Tag::kEosData);
    return *(data_.eos_data);
  }

  
  void set_eos_data(
      EosVideoFrameDataPtr eos_data);
  
  bool is_shared_memory_data() const { return tag_ == Tag::kSharedMemoryData; }

  
  SharedMemoryVideoFrameDataPtr& get_shared_memory_data() const {
    CHECK(tag_ == Tag::kSharedMemoryData);
    return *(data_.shared_memory_data);
  }

  
  void set_shared_memory_data(
      SharedMemoryVideoFrameDataPtr shared_memory_data);
  
  bool is_gpu_memory_buffer_shared_image_data() const { return tag_ == Tag::kGpuMemoryBufferSharedImageData; }

  
  GpuMemoryBufferSharedImageVideoFrameDataPtr& get_gpu_memory_buffer_shared_image_data() const {
    CHECK(tag_ == Tag::kGpuMemoryBufferSharedImageData);
    return *(data_.gpu_memory_buffer_shared_image_data);
  }

  
  void set_gpu_memory_buffer_shared_image_data(
      GpuMemoryBufferSharedImageVideoFrameDataPtr gpu_memory_buffer_shared_image_data);
  
  bool is_shared_image_data() const { return tag_ == Tag::kSharedImageData; }

  
  SharedImageVideoFrameDataPtr& get_shared_image_data() const {
    CHECK(tag_ == Tag::kSharedImageData);
    return *(data_.shared_image_data);
  }

  
  void set_shared_image_data(
      SharedImageVideoFrameDataPtr shared_image_data);
  
  bool is_opaque_data() const { return tag_ == Tag::kOpaqueData; }

  
  OpaqueVideoFrameDataPtr& get_opaque_data() const {
    CHECK(tag_ == Tag::kOpaqueData);
    return *(data_.opaque_data);
  }

  
  void set_opaque_data(
      OpaqueVideoFrameDataPtr opaque_data);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoFrameData::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<VideoFrameData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  union Union_ {
    Union_() = default;
    ~Union_() = default;
    EosVideoFrameDataPtr* eos_data;
    SharedMemoryVideoFrameDataPtr* shared_memory_data;
    GpuMemoryBufferSharedImageVideoFrameDataPtr* gpu_memory_buffer_shared_image_data;
    SharedImageVideoFrameDataPtr* shared_image_data;
    OpaqueVideoFrameDataPtr* opaque_data;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};









class BLINK_PLATFORM_EXPORT AudioDecoderConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AudioDecoderConfig, T>::value>;
  using DataView = AudioDecoderConfigDataView;
  using Data_ = internal::AudioDecoderConfig_Data;

  template <typename... Args>
  static AudioDecoderConfigPtr New(Args&&... args) {
    return AudioDecoderConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AudioDecoderConfigPtr From(const U& u) {
    return mojo::TypeConverter<AudioDecoderConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AudioDecoderConfig>::Convert(*this);
  }


  AudioDecoderConfig();

  AudioDecoderConfig(
      AudioCodec codec,
      SampleFormat sample_format,
      ChannelLayout channel_layout,
      int32_t samples_per_second,
      WTF::Vector<uint8_t> extra_data,
      EncryptionScheme encryption_scheme,
      ::base::TimeDelta seek_preroll,
      int32_t codec_delay,
      AudioCodecProfile profile,
      ChannelLayout target_output_channel_layout,
      SampleFormat target_output_sample_format,
      bool should_discard_decoder_delay,
      WTF::Vector<uint8_t> aac_extra_data);


  ~AudioDecoderConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AudioDecoderConfigPtr>
  AudioDecoderConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AudioDecoderConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AudioDecoderConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AudioDecoderConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AudioDecoderConfig::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AudioDecoderConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AudioDecoderConfig_UnserializedMessageContext<
            UserType, AudioDecoderConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AudioDecoderConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AudioDecoderConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AudioDecoderConfig_UnserializedMessageContext<
            UserType, AudioDecoderConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AudioDecoderConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  AudioCodec codec;
  
  SampleFormat sample_format;
  
  ChannelLayout channel_layout;
  
  int32_t samples_per_second;
  
  WTF::Vector<uint8_t> extra_data;
  
  EncryptionScheme encryption_scheme;
  
  ::base::TimeDelta seek_preroll;
  
  int32_t codec_delay;
  
  AudioCodecProfile profile;
  
  ChannelLayout target_output_channel_layout;
  
  SampleFormat target_output_sample_format;
  
  bool should_discard_decoder_delay;
  
  WTF::Vector<uint8_t> aac_extra_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AudioDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AudioDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AudioDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AudioDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT VideoDecoderConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoDecoderConfig, T>::value>;
  using DataView = VideoDecoderConfigDataView;
  using Data_ = internal::VideoDecoderConfig_Data;

  template <typename... Args>
  static VideoDecoderConfigPtr New(Args&&... args) {
    return VideoDecoderConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoDecoderConfigPtr From(const U& u) {
    return mojo::TypeConverter<VideoDecoderConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoDecoderConfig>::Convert(*this);
  }


  VideoDecoderConfig();

  VideoDecoderConfig(
      VideoCodec codec,
      VideoCodecProfile profile,
      uint32_t level,
      bool has_alpha,
      VideoTransformationPtr transformation,
      const ::gfx::Size& coded_size,
      const ::gfx::Rect& visible_rect,
      const ::gfx::Size& natural_size,
      VideoAspectRatioPtr aspect_ratio,
      WTF::Vector<uint8_t> extra_data,
      EncryptionScheme encryption_scheme,
      VideoColorSpacePtr color_space_info,
      ::gfx::mojom::blink::HDRMetadataPtr hdr_metadata);

VideoDecoderConfig(const VideoDecoderConfig&) = delete;
VideoDecoderConfig& operator=(const VideoDecoderConfig&) = delete;

  ~VideoDecoderConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoDecoderConfigPtr>
  VideoDecoderConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoDecoderConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoDecoderConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoDecoderConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoDecoderConfig::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoDecoderConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoDecoderConfig_UnserializedMessageContext<
            UserType, VideoDecoderConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoDecoderConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoDecoderConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoDecoderConfig_UnserializedMessageContext<
            UserType, VideoDecoderConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoDecoderConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  VideoCodec codec;
  
  VideoCodecProfile profile;
  
  uint32_t level;
  
  bool has_alpha;
  
  VideoTransformationPtr transformation;
  
  ::gfx::Size coded_size;
  
  ::gfx::Rect visible_rect;
  
  ::gfx::Size natural_size;
  
  VideoAspectRatioPtr aspect_ratio;
  
  WTF::Vector<uint8_t> extra_data;
  
  EncryptionScheme encryption_scheme;
  
  VideoColorSpacePtr color_space_info;
  
  ::gfx::mojom::blink::HDRMetadataPtr hdr_metadata;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_PLATFORM_EXPORT DecryptConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DecryptConfig, T>::value>;
  using DataView = DecryptConfigDataView;
  using Data_ = internal::DecryptConfig_Data;

  template <typename... Args>
  static DecryptConfigPtr New(Args&&... args) {
    return DecryptConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DecryptConfigPtr From(const U& u) {
    return mojo::TypeConverter<DecryptConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DecryptConfig>::Convert(*this);
  }


  DecryptConfig();

  DecryptConfig(
      EncryptionScheme encryption_scheme,
      const std::string& key_id,
      const std::string& iv,
      WTF::Vector<SubsampleEntryPtr> subsamples,
      ::media::mojom::blink::EncryptionPatternPtr encryption_pattern);

DecryptConfig(const DecryptConfig&) = delete;
DecryptConfig& operator=(const DecryptConfig&) = delete;

  ~DecryptConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DecryptConfigPtr>
  DecryptConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DecryptConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DecryptConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DecryptConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DecryptConfig::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DecryptConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DecryptConfig_UnserializedMessageContext<
            UserType, DecryptConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DecryptConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DecryptConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DecryptConfig_UnserializedMessageContext<
            UserType, DecryptConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DecryptConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  EncryptionScheme encryption_scheme;
  
  std::string key_id;
  
  std::string iv;
  
  WTF::Vector<SubsampleEntryPtr> subsamples;
  
  ::media::mojom::blink::EncryptionPatternPtr encryption_pattern;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DecryptConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DecryptConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DecryptConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DecryptConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT DecoderBufferSideData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DecoderBufferSideData, T>::value>;
  using DataView = DecoderBufferSideDataDataView;
  using Data_ = internal::DecoderBufferSideData_Data;

  template <typename... Args>
  static DecoderBufferSideDataPtr New(Args&&... args) {
    return DecoderBufferSideDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DecoderBufferSideDataPtr From(const U& u) {
    return mojo::TypeConverter<DecoderBufferSideDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DecoderBufferSideData>::Convert(*this);
  }


  DecoderBufferSideData();

  DecoderBufferSideData(
      WTF::Vector<uint32_t> spatial_layers,
      WTF::Vector<uint8_t> alpha_data,
      uint64_t secure_handle,
      ::base::TimeDelta front_discard,
      ::base::TimeDelta back_discard);


  ~DecoderBufferSideData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DecoderBufferSideDataPtr>
  DecoderBufferSideDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DecoderBufferSideData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DecoderBufferSideData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DecoderBufferSideData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DecoderBufferSideData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DecoderBufferSideData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DecoderBufferSideData_UnserializedMessageContext<
            UserType, DecoderBufferSideData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DecoderBufferSideData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DecoderBufferSideData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DecoderBufferSideData_UnserializedMessageContext<
            UserType, DecoderBufferSideData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DecoderBufferSideData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  WTF::Vector<uint32_t> spatial_layers;
  
  WTF::Vector<uint8_t> alpha_data;
  
  uint64_t secure_handle;
  
  ::base::TimeDelta front_discard;
  
  ::base::TimeDelta back_discard;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DecoderBufferSideData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DecoderBufferSideData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DecoderBufferSideData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DecoderBufferSideData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT DataDecoderBuffer {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DataDecoderBuffer, T>::value>;
  using DataView = DataDecoderBufferDataView;
  using Data_ = internal::DataDecoderBuffer_Data;

  template <typename... Args>
  static DataDecoderBufferPtr New(Args&&... args) {
    return DataDecoderBufferPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DataDecoderBufferPtr From(const U& u) {
    return mojo::TypeConverter<DataDecoderBufferPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DataDecoderBuffer>::Convert(*this);
  }


  DataDecoderBuffer();

  DataDecoderBuffer(
      ::base::TimeDelta timestamp,
      ::base::TimeDelta duration,
      uint32_t data_size,
      bool is_key_frame,
      DecryptConfigPtr decrypt_config,
      DecoderBufferSideDataPtr side_data);

DataDecoderBuffer(const DataDecoderBuffer&) = delete;
DataDecoderBuffer& operator=(const DataDecoderBuffer&) = delete;

  ~DataDecoderBuffer();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DataDecoderBufferPtr>
  DataDecoderBufferPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DataDecoderBuffer::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DataDecoderBuffer::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DataDecoderBuffer::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DataDecoderBuffer::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DataDecoderBuffer::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DataDecoderBuffer_UnserializedMessageContext<
            UserType, DataDecoderBuffer::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DataDecoderBuffer::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DataDecoderBuffer::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DataDecoderBuffer_UnserializedMessageContext<
            UserType, DataDecoderBuffer::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DataDecoderBuffer::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::TimeDelta timestamp;
  
  ::base::TimeDelta duration;
  
  uint32_t data_size;
  
  bool is_key_frame;
  
  DecryptConfigPtr decrypt_config;
  
  DecoderBufferSideDataPtr side_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DataDecoderBuffer::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DataDecoderBuffer::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DataDecoderBuffer::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DataDecoderBuffer::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT EosDecoderBuffer {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EosDecoderBuffer, T>::value>;
  using DataView = EosDecoderBufferDataView;
  using Data_ = internal::EosDecoderBuffer_Data;

  template <typename... Args>
  static EosDecoderBufferPtr New(Args&&... args) {
    return EosDecoderBufferPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EosDecoderBufferPtr From(const U& u) {
    return mojo::TypeConverter<EosDecoderBufferPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EosDecoderBuffer>::Convert(*this);
  }


  EosDecoderBuffer();

  explicit EosDecoderBuffer(
      DecoderBufferSideDataNextConfigPtr next_config);

EosDecoderBuffer(const EosDecoderBuffer&) = delete;
EosDecoderBuffer& operator=(const EosDecoderBuffer&) = delete;

  ~EosDecoderBuffer();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EosDecoderBufferPtr>
  EosDecoderBufferPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EosDecoderBuffer::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EosDecoderBuffer::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EosDecoderBuffer::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EosDecoderBuffer::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EosDecoderBuffer::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EosDecoderBuffer_UnserializedMessageContext<
            UserType, EosDecoderBuffer::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EosDecoderBuffer::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EosDecoderBuffer::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EosDecoderBuffer_UnserializedMessageContext<
            UserType, EosDecoderBuffer::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EosDecoderBuffer::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  DecoderBufferSideDataNextConfigPtr next_config;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EosDecoderBuffer::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EosDecoderBuffer::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EosDecoderBuffer::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EosDecoderBuffer::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT AudioBuffer {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AudioBuffer, T>::value>;
  using DataView = AudioBufferDataView;
  using Data_ = internal::AudioBuffer_Data;

  template <typename... Args>
  static AudioBufferPtr New(Args&&... args) {
    return AudioBufferPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AudioBufferPtr From(const U& u) {
    return mojo::TypeConverter<AudioBufferPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AudioBuffer>::Convert(*this);
  }


  AudioBuffer();

  AudioBuffer(
      SampleFormat sample_format,
      ChannelLayout channel_layout,
      int32_t channel_count,
      int32_t sample_rate,
      int32_t frame_count,
      bool end_of_stream,
      ::base::TimeDelta timestamp,
      WTF::Vector<uint8_t> data);


  ~AudioBuffer();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AudioBufferPtr>
  AudioBufferPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AudioBuffer::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AudioBuffer::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AudioBuffer::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AudioBuffer::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AudioBuffer::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AudioBuffer_UnserializedMessageContext<
            UserType, AudioBuffer::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AudioBuffer::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AudioBuffer::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AudioBuffer_UnserializedMessageContext<
            UserType, AudioBuffer::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AudioBuffer::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  SampleFormat sample_format;
  
  ChannelLayout channel_layout;
  
  int32_t channel_count;
  
  int32_t sample_rate;
  
  int32_t frame_count;
  
  bool end_of_stream;
  
  ::base::TimeDelta timestamp;
  
  WTF::Vector<uint8_t> data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AudioBuffer::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AudioBuffer::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AudioBuffer::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AudioBuffer::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT VideoFrameMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoFrameMetadata, T>::value>;
  using DataView = VideoFrameMetadataDataView;
  using Data_ = internal::VideoFrameMetadata_Data;

  template <typename... Args>
  static VideoFrameMetadataPtr New(Args&&... args) {
    return VideoFrameMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoFrameMetadataPtr From(const U& u) {
    return mojo::TypeConverter<VideoFrameMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoFrameMetadata>::Convert(*this);
  }


  VideoFrameMetadata();

  VideoFrameMetadata(
      bool allow_overlay,
      std::optional<::base::TimeTicks> capture_begin_time,
      std::optional<::base::TimeTicks> capture_end_time,
      bool has_capture_counter,
      int32_t capture_counter,
      const std::optional<::gfx::Rect>& capture_update_rect,
      const std::optional<::gfx::Size>& source_size,
      const std::optional<::gfx::Rect>& region_capture_rect,
      uint32_t sub_capture_target_version,
      bool copy_required,
      bool end_of_stream,
      std::optional<::base::TimeDelta> frame_duration,
      bool has_frame_rate,
      double frame_rate,
      bool interactive_content,
      std::optional<::base::TimeTicks> reference_time,
      bool read_lock_fences_enabled,
      VideoTransformationPtr transformation,
      bool texture_owner,
      bool wants_promotion_hint,
      bool protected_video,
      bool hw_protected,
      bool needs_detiling,
      bool is_webgpu_compatible,
      const std::optional<::base::UnguessableToken>& tracking_token,
      bool power_efficient,
      bool has_device_scale_factor,
      double device_scale_factor,
      bool has_page_scale_factor,
      double page_scale_factor,
      bool has_root_scroll_offset_x,
      double root_scroll_offset_x,
      bool has_root_scroll_offset_y,
      double root_scroll_offset_y,
      bool has_top_controls_visible_height,
      double top_controls_visible_height,
      std::optional<::base::TimeTicks> decode_begin_time,
      std::optional<::base::TimeTicks> decode_end_time,
      std::optional<::base::TimeDelta> processing_time,
      bool has_rtp_timestamp,
      double rtp_timestamp,
      std::optional<::base::TimeTicks> receive_time,
      std::optional<::base::TimeDelta> wallclock_frame_duration,
      std::optional<uint64_t> frame_sequence,
      std::optional<uint64_t> source_id,
      EffectState background_blur);

VideoFrameMetadata(const VideoFrameMetadata&) = delete;
VideoFrameMetadata& operator=(const VideoFrameMetadata&) = delete;

  ~VideoFrameMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoFrameMetadataPtr>
  VideoFrameMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoFrameMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoFrameMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoFrameMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoFrameMetadata::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoFrameMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoFrameMetadata_UnserializedMessageContext<
            UserType, VideoFrameMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoFrameMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoFrameMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoFrameMetadata_UnserializedMessageContext<
            UserType, VideoFrameMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoFrameMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool allow_overlay;
  
  std::optional<::base::TimeTicks> capture_begin_time;
  
  std::optional<::base::TimeTicks> capture_end_time;
  
  bool has_capture_counter;
  
  int32_t capture_counter;
  
  std::optional<::gfx::Rect> capture_update_rect;
  
  std::optional<::gfx::Size> source_size;
  
  std::optional<::gfx::Rect> region_capture_rect;
  
  uint32_t sub_capture_target_version;
  
  bool copy_required;
  
  bool end_of_stream;
  
  std::optional<::base::TimeDelta> frame_duration;
  
  bool has_frame_rate;
  
  double frame_rate;
  
  bool interactive_content;
  
  std::optional<::base::TimeTicks> reference_time;
  
  bool read_lock_fences_enabled;
  
  VideoTransformationPtr transformation;
  
  bool texture_owner;
  
  bool wants_promotion_hint;
  
  bool protected_video;
  
  bool hw_protected;
  
  bool needs_detiling;
  
  bool is_webgpu_compatible;
  
  std::optional<::base::UnguessableToken> tracking_token;
  
  bool power_efficient;
  
  bool has_device_scale_factor;
  
  double device_scale_factor;
  
  bool has_page_scale_factor;
  
  double page_scale_factor;
  
  bool has_root_scroll_offset_x;
  
  double root_scroll_offset_x;
  
  bool has_root_scroll_offset_y;
  
  double root_scroll_offset_y;
  
  bool has_top_controls_visible_height;
  
  double top_controls_visible_height;
  
  std::optional<::base::TimeTicks> decode_begin_time;
  
  std::optional<::base::TimeTicks> decode_end_time;
  
  std::optional<::base::TimeDelta> processing_time;
  
  bool has_rtp_timestamp;
  
  double rtp_timestamp;
  
  std::optional<::base::TimeTicks> receive_time;
  
  std::optional<::base::TimeDelta> wallclock_frame_duration;
  
  std::optional<uint64_t> frame_sequence;
  
  std::optional<uint64_t> source_id;
  
  EffectState background_blur;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT VideoFrame {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoFrame, T>::value>;
  using DataView = VideoFrameDataView;
  using Data_ = internal::VideoFrame_Data;

  template <typename... Args>
  static VideoFramePtr New(Args&&... args) {
    return VideoFramePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoFramePtr From(const U& u) {
    return mojo::TypeConverter<VideoFramePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoFrame>::Convert(*this);
  }


  VideoFrame();

  VideoFrame(
      VideoPixelFormat format,
      const ::gfx::Size& coded_size,
      const ::gfx::Rect& visible_rect,
      const ::gfx::Size& natural_size,
      ::base::TimeDelta timestamp,
      VideoFrameDataPtr data,
      const ::media::VideoFrameMetadata& metadata,
      const ::gfx::ColorSpace& color_space,
      ::gfx::mojom::blink::HDRMetadataPtr hdr_metadata);

VideoFrame(const VideoFrame&) = delete;
VideoFrame& operator=(const VideoFrame&) = delete;

  ~VideoFrame();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoFramePtr>
  VideoFramePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoFrame::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoFrame::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoFrame::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoFrame::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoFrame_UnserializedMessageContext<
            UserType, VideoFrame::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoFrame::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoFrame::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoFrame_UnserializedMessageContext<
            UserType, VideoFrame::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoFrame::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  VideoPixelFormat format;
  
  ::gfx::Size coded_size;
  
  ::gfx::Rect visible_rect;
  
  ::gfx::Size natural_size;
  
  ::base::TimeDelta timestamp;
  
  VideoFrameDataPtr data;
  
  ::media::VideoFrameMetadata metadata;
  
  ::gfx::ColorSpace color_space;
  
  ::gfx::mojom::blink::HDRMetadataPtr hdr_metadata;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoFrame::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoFrame::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoFrame::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoFrame::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_PLATFORM_EXPORT SharedMemoryVideoFrameData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedMemoryVideoFrameData, T>::value>;
  using DataView = SharedMemoryVideoFrameDataDataView;
  using Data_ = internal::SharedMemoryVideoFrameData_Data;

  template <typename... Args>
  static SharedMemoryVideoFrameDataPtr New(Args&&... args) {
    return SharedMemoryVideoFrameDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedMemoryVideoFrameDataPtr From(const U& u) {
    return mojo::TypeConverter<SharedMemoryVideoFrameDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedMemoryVideoFrameData>::Convert(*this);
  }


  SharedMemoryVideoFrameData();

  SharedMemoryVideoFrameData(
      ::base::ReadOnlySharedMemoryRegion frame_data,
      WTF::Vector<int32_t> strides,
      WTF::Vector<uint32_t> offsets);

SharedMemoryVideoFrameData(const SharedMemoryVideoFrameData&) = delete;
SharedMemoryVideoFrameData& operator=(const SharedMemoryVideoFrameData&) = delete;

  ~SharedMemoryVideoFrameData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedMemoryVideoFrameDataPtr>
  SharedMemoryVideoFrameDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedMemoryVideoFrameData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedMemoryVideoFrameData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedMemoryVideoFrameData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedMemoryVideoFrameData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedMemoryVideoFrameData_UnserializedMessageContext<
            UserType, SharedMemoryVideoFrameData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedMemoryVideoFrameData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedMemoryVideoFrameData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedMemoryVideoFrameData_UnserializedMessageContext<
            UserType, SharedMemoryVideoFrameData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedMemoryVideoFrameData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::ReadOnlySharedMemoryRegion frame_data;
  
  WTF::Vector<int32_t> strides;
  
  WTF::Vector<uint32_t> offsets;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedMemoryVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedMemoryVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedMemoryVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedMemoryVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT GpuMemoryBufferSharedImageVideoFrameData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GpuMemoryBufferSharedImageVideoFrameData, T>::value>;
  using DataView = GpuMemoryBufferSharedImageVideoFrameDataDataView;
  using Data_ = internal::GpuMemoryBufferSharedImageVideoFrameData_Data;

  template <typename... Args>
  static GpuMemoryBufferSharedImageVideoFrameDataPtr New(Args&&... args) {
    return GpuMemoryBufferSharedImageVideoFrameDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GpuMemoryBufferSharedImageVideoFrameDataPtr From(const U& u) {
    return mojo::TypeConverter<GpuMemoryBufferSharedImageVideoFrameDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GpuMemoryBufferSharedImageVideoFrameData>::Convert(*this);
  }


  GpuMemoryBufferSharedImageVideoFrameData();

  GpuMemoryBufferSharedImageVideoFrameData(
      ::gfx::GpuMemoryBufferHandle gpu_memory_buffer_handle,
      const std::optional<::gpu::ExportedSharedImage>& shared_image,
      const ::gpu::SyncToken& sync_token);

GpuMemoryBufferSharedImageVideoFrameData(const GpuMemoryBufferSharedImageVideoFrameData&) = delete;
GpuMemoryBufferSharedImageVideoFrameData& operator=(const GpuMemoryBufferSharedImageVideoFrameData&) = delete;

  ~GpuMemoryBufferSharedImageVideoFrameData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GpuMemoryBufferSharedImageVideoFrameDataPtr>
  GpuMemoryBufferSharedImageVideoFrameDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GpuMemoryBufferSharedImageVideoFrameData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GpuMemoryBufferSharedImageVideoFrameData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GpuMemoryBufferSharedImageVideoFrameData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GpuMemoryBufferSharedImageVideoFrameData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GpuMemoryBufferSharedImageVideoFrameData_UnserializedMessageContext<
            UserType, GpuMemoryBufferSharedImageVideoFrameData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GpuMemoryBufferSharedImageVideoFrameData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GpuMemoryBufferSharedImageVideoFrameData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GpuMemoryBufferSharedImageVideoFrameData_UnserializedMessageContext<
            UserType, GpuMemoryBufferSharedImageVideoFrameData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GpuMemoryBufferSharedImageVideoFrameData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::GpuMemoryBufferHandle gpu_memory_buffer_handle;
  
  std::optional<::gpu::ExportedSharedImage> shared_image;
  
  ::gpu::SyncToken sync_token;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GpuMemoryBufferSharedImageVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GpuMemoryBufferSharedImageVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GpuMemoryBufferSharedImageVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GpuMemoryBufferSharedImageVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT SharedImageVideoFrameData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedImageVideoFrameData, T>::value>;
  using DataView = SharedImageVideoFrameDataDataView;
  using Data_ = internal::SharedImageVideoFrameData_Data;

  template <typename... Args>
  static SharedImageVideoFrameDataPtr New(Args&&... args) {
    return SharedImageVideoFrameDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedImageVideoFrameDataPtr From(const U& u) {
    return mojo::TypeConverter<SharedImageVideoFrameDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedImageVideoFrameData>::Convert(*this);
  }


  SharedImageVideoFrameData();

  SharedImageVideoFrameData(
      const ::gpu::ExportedSharedImage& shared_image,
      const ::gpu::SyncToken& sync_token,
      ::gpu::mojom::blink::VulkanYCbCrInfoPtr ycbcr_data);

SharedImageVideoFrameData(const SharedImageVideoFrameData&) = delete;
SharedImageVideoFrameData& operator=(const SharedImageVideoFrameData&) = delete;

  ~SharedImageVideoFrameData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedImageVideoFrameDataPtr>
  SharedImageVideoFrameDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedImageVideoFrameData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedImageVideoFrameData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedImageVideoFrameData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedImageVideoFrameData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedImageVideoFrameData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedImageVideoFrameData_UnserializedMessageContext<
            UserType, SharedImageVideoFrameData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedImageVideoFrameData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedImageVideoFrameData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedImageVideoFrameData_UnserializedMessageContext<
            UserType, SharedImageVideoFrameData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedImageVideoFrameData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gpu::ExportedSharedImage shared_image;
  
  ::gpu::SyncToken sync_token;
  
  ::gpu::mojom::blink::VulkanYCbCrInfoPtr ycbcr_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedImageVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedImageVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedImageVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedImageVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_PLATFORM_EXPORT PipelineStatistics {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PipelineStatistics, T>::value>;
  using DataView = PipelineStatisticsDataView;
  using Data_ = internal::PipelineStatistics_Data;

  template <typename... Args>
  static PipelineStatisticsPtr New(Args&&... args) {
    return PipelineStatisticsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PipelineStatisticsPtr From(const U& u) {
    return mojo::TypeConverter<PipelineStatisticsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PipelineStatistics>::Convert(*this);
  }


  PipelineStatistics();

  PipelineStatistics(
      uint64_t audio_bytes_decoded,
      uint64_t video_bytes_decoded,
      uint32_t video_frames_decoded,
      uint32_t video_frames_dropped,
      int64_t audio_memory_usage,
      int64_t video_memory_usage);


  ~PipelineStatistics();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PipelineStatisticsPtr>
  PipelineStatisticsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PipelineStatistics::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PipelineStatistics::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PipelineStatistics::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PipelineStatistics::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PipelineStatistics::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PipelineStatistics_UnserializedMessageContext<
            UserType, PipelineStatistics::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PipelineStatistics::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PipelineStatistics::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PipelineStatistics_UnserializedMessageContext<
            UserType, PipelineStatistics::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PipelineStatistics::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t audio_bytes_decoded;
  
  uint64_t video_bytes_decoded;
  
  uint32_t video_frames_decoded;
  
  uint32_t video_frames_dropped;
  
  int64_t audio_memory_usage;
  
  int64_t video_memory_usage;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PipelineStatistics::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PipelineStatistics::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PipelineStatistics::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PipelineStatistics::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT PredictionFeatures {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PredictionFeatures, T>::value>;
  using DataView = PredictionFeaturesDataView;
  using Data_ = internal::PredictionFeatures_Data;

  template <typename... Args>
  static PredictionFeaturesPtr New(Args&&... args) {
    return PredictionFeaturesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PredictionFeaturesPtr From(const U& u) {
    return mojo::TypeConverter<PredictionFeaturesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PredictionFeatures>::Convert(*this);
  }


  PredictionFeatures();

  PredictionFeatures(
      VideoCodecProfile profile,
      const ::gfx::Size& video_size,
      double frames_per_sec,
      const WTF::String& key_system,
      bool use_hw_secure_codecs);


  ~PredictionFeatures();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PredictionFeaturesPtr>
  PredictionFeaturesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PredictionFeatures::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PredictionFeatures::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PredictionFeatures::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PredictionFeatures::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PredictionFeatures::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PredictionFeatures_UnserializedMessageContext<
            UserType, PredictionFeatures::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PredictionFeatures::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PredictionFeatures::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PredictionFeatures_UnserializedMessageContext<
            UserType, PredictionFeatures::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PredictionFeatures::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  VideoCodecProfile profile;
  
  ::gfx::Size video_size;
  
  double frames_per_sec;
  
  WTF::String key_system;
  
  bool use_hw_secure_codecs;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PredictionFeatures::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PredictionFeatures::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PredictionFeatures::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PredictionFeatures::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class BLINK_PLATFORM_EXPORT StatusData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<StatusData, T>::value>;
  using DataView = StatusDataDataView;
  using Data_ = internal::StatusData_Data;

  template <typename... Args>
  static StatusDataPtr New(Args&&... args) {
    return StatusDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StatusDataPtr From(const U& u) {
    return mojo::TypeConverter<StatusDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StatusData>::Convert(*this);
  }


  StatusData();

  StatusData(
      const WTF::String& group,
      uint16_t code,
      const WTF::String& message,
      ::base::Value::List frames,
      StatusDataPtr cause,
      ::base::Value data,
      uint64_t packed_root_cause);

StatusData(const StatusData&) = delete;
StatusData& operator=(const StatusData&) = delete;

  ~StatusData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StatusDataPtr>
  StatusDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, StatusData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, StatusData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, StatusData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StatusData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StatusData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::StatusData_UnserializedMessageContext<
            UserType, StatusData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<StatusData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return StatusData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::StatusData_UnserializedMessageContext<
            UserType, StatusData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<StatusData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  WTF::String group;
  
  uint16_t code;
  
  WTF::String message;
  
  ::base::Value::List frames;
  
  StatusDataPtr cause;
  
  ::base::Value data;
  
  uint64_t packed_root_cause;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, StatusData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, StatusData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, StatusData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, StatusData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT EncoderStatus {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EncoderStatus, T>::value>;
  using DataView = EncoderStatusDataView;
  using Data_ = internal::EncoderStatus_Data;

  template <typename... Args>
  static EncoderStatusPtr New(Args&&... args) {
    return EncoderStatusPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EncoderStatusPtr From(const U& u) {
    return mojo::TypeConverter<EncoderStatusPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EncoderStatus>::Convert(*this);
  }


  EncoderStatus();

  explicit EncoderStatus(
      StatusDataPtr internal);

EncoderStatus(const EncoderStatus&) = delete;
EncoderStatus& operator=(const EncoderStatus&) = delete;

  ~EncoderStatus();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EncoderStatusPtr>
  EncoderStatusPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EncoderStatus::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EncoderStatus::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EncoderStatus::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EncoderStatus::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EncoderStatus::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EncoderStatus_UnserializedMessageContext<
            UserType, EncoderStatus::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EncoderStatus::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EncoderStatus::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EncoderStatus_UnserializedMessageContext<
            UserType, EncoderStatus::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EncoderStatus::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  StatusDataPtr internal;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EncoderStatus::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EncoderStatus::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EncoderStatus::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EncoderStatus::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT DecoderStatus {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DecoderStatus, T>::value>;
  using DataView = DecoderStatusDataView;
  using Data_ = internal::DecoderStatus_Data;

  template <typename... Args>
  static DecoderStatusPtr New(Args&&... args) {
    return DecoderStatusPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DecoderStatusPtr From(const U& u) {
    return mojo::TypeConverter<DecoderStatusPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DecoderStatus>::Convert(*this);
  }


  DecoderStatus();

  explicit DecoderStatus(
      StatusDataPtr internal);

DecoderStatus(const DecoderStatus&) = delete;
DecoderStatus& operator=(const DecoderStatus&) = delete;

  ~DecoderStatus();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DecoderStatusPtr>
  DecoderStatusPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DecoderStatus::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DecoderStatus::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DecoderStatus::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DecoderStatus::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DecoderStatus::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DecoderStatus_UnserializedMessageContext<
            UserType, DecoderStatus::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DecoderStatus::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DecoderStatus::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DecoderStatus_UnserializedMessageContext<
            UserType, DecoderStatus::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DecoderStatus::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  StatusDataPtr internal;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DecoderStatus::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DecoderStatus::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DecoderStatus::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DecoderStatus::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT PipelineStatus {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PipelineStatus, T>::value>;
  using DataView = PipelineStatusDataView;
  using Data_ = internal::PipelineStatus_Data;

  template <typename... Args>
  static PipelineStatusPtr New(Args&&... args) {
    return PipelineStatusPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PipelineStatusPtr From(const U& u) {
    return mojo::TypeConverter<PipelineStatusPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PipelineStatus>::Convert(*this);
  }


  PipelineStatus();

  explicit PipelineStatus(
      StatusDataPtr internal);

PipelineStatus(const PipelineStatus&) = delete;
PipelineStatus& operator=(const PipelineStatus&) = delete;

  ~PipelineStatus();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PipelineStatusPtr>
  PipelineStatusPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PipelineStatus::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PipelineStatus::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PipelineStatus::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PipelineStatus::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PipelineStatus::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PipelineStatus_UnserializedMessageContext<
            UserType, PipelineStatus::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PipelineStatus::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PipelineStatus::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PipelineStatus_UnserializedMessageContext<
            UserType, PipelineStatus::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PipelineStatus::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  StatusDataPtr internal;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PipelineStatus::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PipelineStatus::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PipelineStatus::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PipelineStatus::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
DecoderBufferSideDataNextConfigPtr DecoderBufferSideDataNextConfig::Clone() const {
  switch (tag_) {
    case Tag::kNextAudioConfig:
      return NewNextAudioConfig(
          mojo::Clone(*data_.next_audio_config));
    case Tag::kNextVideoConfig:
      return NewNextVideoConfig(
          mojo::Clone(*data_.next_video_config));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, DecoderBufferSideDataNextConfig>::value>::type*>
bool DecoderBufferSideDataNextConfig::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kNextAudioConfig:
      return mojo::Equals(*(data_.next_audio_config), *(other.data_.next_audio_config));
    case Tag::kNextVideoConfig:
      return mojo::Equals(*(data_.next_video_config), *(other.data_.next_video_config));
  }

  return false;
}
template <typename UnionPtrType>
DecoderBufferPtr DecoderBuffer::Clone() const {
  switch (tag_) {
    case Tag::kEos:
      return NewEos(
          mojo::Clone(*data_.eos));
    case Tag::kData:
      return NewData(
          mojo::Clone(*data_.data));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, DecoderBuffer>::value>::type*>
bool DecoderBuffer::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kEos:
      return mojo::Equals(*(data_.eos), *(other.data_.eos));
    case Tag::kData:
      return mojo::Equals(*(data_.data), *(other.data_.data));
  }

  return false;
}
template <typename UnionPtrType>
VideoFrameDataPtr VideoFrameData::Clone() const {
  switch (tag_) {
    case Tag::kEosData:
      return NewEosData(
          mojo::Clone(*data_.eos_data));
    case Tag::kSharedMemoryData:
      return NewSharedMemoryData(
          mojo::Clone(*data_.shared_memory_data));
    case Tag::kGpuMemoryBufferSharedImageData:
      return NewGpuMemoryBufferSharedImageData(
          mojo::Clone(*data_.gpu_memory_buffer_shared_image_data));
    case Tag::kSharedImageData:
      return NewSharedImageData(
          mojo::Clone(*data_.shared_image_data));
    case Tag::kOpaqueData:
      return NewOpaqueData(
          mojo::Clone(*data_.opaque_data));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, VideoFrameData>::value>::type*>
bool VideoFrameData::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kEosData:
      return mojo::Equals(*(data_.eos_data), *(other.data_.eos_data));
    case Tag::kSharedMemoryData:
      return mojo::Equals(*(data_.shared_memory_data), *(other.data_.shared_memory_data));
    case Tag::kGpuMemoryBufferSharedImageData:
      return mojo::Equals(*(data_.gpu_memory_buffer_shared_image_data), *(other.data_.gpu_memory_buffer_shared_image_data));
    case Tag::kSharedImageData:
      return mojo::Equals(*(data_.shared_image_data), *(other.data_.shared_image_data));
    case Tag::kOpaqueData:
      return mojo::Equals(*(data_.opaque_data), *(other.data_.opaque_data));
  }

  return false;
}
template <typename StructPtrType>
VideoTransformationPtr VideoTransformation::Clone() const {
  return New(
      mojo::Clone(rotation),
      mojo::Clone(mirrored)
  );
}

template <typename T, VideoTransformation::EnableIfSame<T>*>
bool VideoTransformation::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->rotation, other_struct.rotation))
    return false;
  if (!mojo::Equals(this->mirrored, other_struct.mirrored))
    return false;
  return true;
}

template <typename T, VideoTransformation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.rotation < rhs.rotation)
    return true;
  if (rhs.rotation < lhs.rotation)
    return false;
  if (lhs.mirrored < rhs.mirrored)
    return true;
  if (rhs.mirrored < lhs.mirrored)
    return false;
  return false;
}
template <typename StructPtrType>
VideoAspectRatioPtr VideoAspectRatio::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(value)
  );
}

template <typename T, VideoAspectRatio::EnableIfSame<T>*>
bool VideoAspectRatio::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, VideoAspectRatio::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
VideoColorSpacePtr VideoColorSpace::Clone() const {
  return New(
      mojo::Clone(primaries),
      mojo::Clone(transfer),
      mojo::Clone(matrix),
      mojo::Clone(range)
  );
}

template <typename T, VideoColorSpace::EnableIfSame<T>*>
bool VideoColorSpace::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->primaries, other_struct.primaries))
    return false;
  if (!mojo::Equals(this->transfer, other_struct.transfer))
    return false;
  if (!mojo::Equals(this->matrix, other_struct.matrix))
    return false;
  if (!mojo::Equals(this->range, other_struct.range))
    return false;
  return true;
}

template <typename T, VideoColorSpace::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.primaries < rhs.primaries)
    return true;
  if (rhs.primaries < lhs.primaries)
    return false;
  if (lhs.transfer < rhs.transfer)
    return true;
  if (rhs.transfer < lhs.transfer)
    return false;
  if (lhs.matrix < rhs.matrix)
    return true;
  if (rhs.matrix < lhs.matrix)
    return false;
  if (lhs.range < rhs.range)
    return true;
  if (rhs.range < lhs.range)
    return false;
  return false;
}
template <typename StructPtrType>
AudioDecoderConfigPtr AudioDecoderConfig::Clone() const {
  return New(
      mojo::Clone(codec),
      mojo::Clone(sample_format),
      mojo::Clone(channel_layout),
      mojo::Clone(samples_per_second),
      mojo::Clone(extra_data),
      mojo::Clone(encryption_scheme),
      mojo::Clone(seek_preroll),
      mojo::Clone(codec_delay),
      mojo::Clone(profile),
      mojo::Clone(target_output_channel_layout),
      mojo::Clone(target_output_sample_format),
      mojo::Clone(should_discard_decoder_delay),
      mojo::Clone(aac_extra_data)
  );
}

template <typename T, AudioDecoderConfig::EnableIfSame<T>*>
bool AudioDecoderConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->codec, other_struct.codec))
    return false;
  if (!mojo::Equals(this->sample_format, other_struct.sample_format))
    return false;
  if (!mojo::Equals(this->channel_layout, other_struct.channel_layout))
    return false;
  if (!mojo::Equals(this->samples_per_second, other_struct.samples_per_second))
    return false;
  if (!mojo::Equals(this->extra_data, other_struct.extra_data))
    return false;
  if (!mojo::Equals(this->encryption_scheme, other_struct.encryption_scheme))
    return false;
  if (!mojo::Equals(this->seek_preroll, other_struct.seek_preroll))
    return false;
  if (!mojo::Equals(this->codec_delay, other_struct.codec_delay))
    return false;
  if (!mojo::Equals(this->profile, other_struct.profile))
    return false;
  if (!mojo::Equals(this->target_output_channel_layout, other_struct.target_output_channel_layout))
    return false;
  if (!mojo::Equals(this->target_output_sample_format, other_struct.target_output_sample_format))
    return false;
  if (!mojo::Equals(this->should_discard_decoder_delay, other_struct.should_discard_decoder_delay))
    return false;
  if (!mojo::Equals(this->aac_extra_data, other_struct.aac_extra_data))
    return false;
  return true;
}

template <typename T, AudioDecoderConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.codec < rhs.codec)
    return true;
  if (rhs.codec < lhs.codec)
    return false;
  if (lhs.sample_format < rhs.sample_format)
    return true;
  if (rhs.sample_format < lhs.sample_format)
    return false;
  if (lhs.channel_layout < rhs.channel_layout)
    return true;
  if (rhs.channel_layout < lhs.channel_layout)
    return false;
  if (lhs.samples_per_second < rhs.samples_per_second)
    return true;
  if (rhs.samples_per_second < lhs.samples_per_second)
    return false;
  if (lhs.extra_data < rhs.extra_data)
    return true;
  if (rhs.extra_data < lhs.extra_data)
    return false;
  if (lhs.encryption_scheme < rhs.encryption_scheme)
    return true;
  if (rhs.encryption_scheme < lhs.encryption_scheme)
    return false;
  if (lhs.seek_preroll < rhs.seek_preroll)
    return true;
  if (rhs.seek_preroll < lhs.seek_preroll)
    return false;
  if (lhs.codec_delay < rhs.codec_delay)
    return true;
  if (rhs.codec_delay < lhs.codec_delay)
    return false;
  if (lhs.profile < rhs.profile)
    return true;
  if (rhs.profile < lhs.profile)
    return false;
  if (lhs.target_output_channel_layout < rhs.target_output_channel_layout)
    return true;
  if (rhs.target_output_channel_layout < lhs.target_output_channel_layout)
    return false;
  if (lhs.target_output_sample_format < rhs.target_output_sample_format)
    return true;
  if (rhs.target_output_sample_format < lhs.target_output_sample_format)
    return false;
  if (lhs.should_discard_decoder_delay < rhs.should_discard_decoder_delay)
    return true;
  if (rhs.should_discard_decoder_delay < lhs.should_discard_decoder_delay)
    return false;
  if (lhs.aac_extra_data < rhs.aac_extra_data)
    return true;
  if (rhs.aac_extra_data < lhs.aac_extra_data)
    return false;
  return false;
}
template <typename StructPtrType>
VideoDecoderConfigPtr VideoDecoderConfig::Clone() const {
  return New(
      mojo::Clone(codec),
      mojo::Clone(profile),
      mojo::Clone(level),
      mojo::Clone(has_alpha),
      mojo::Clone(transformation),
      mojo::Clone(coded_size),
      mojo::Clone(visible_rect),
      mojo::Clone(natural_size),
      mojo::Clone(aspect_ratio),
      mojo::Clone(extra_data),
      mojo::Clone(encryption_scheme),
      mojo::Clone(color_space_info),
      mojo::Clone(hdr_metadata)
  );
}

template <typename T, VideoDecoderConfig::EnableIfSame<T>*>
bool VideoDecoderConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->codec, other_struct.codec))
    return false;
  if (!mojo::Equals(this->profile, other_struct.profile))
    return false;
  if (!mojo::Equals(this->level, other_struct.level))
    return false;
  if (!mojo::Equals(this->has_alpha, other_struct.has_alpha))
    return false;
  if (!mojo::Equals(this->transformation, other_struct.transformation))
    return false;
  if (!mojo::Equals(this->coded_size, other_struct.coded_size))
    return false;
  if (!mojo::Equals(this->visible_rect, other_struct.visible_rect))
    return false;
  if (!mojo::Equals(this->natural_size, other_struct.natural_size))
    return false;
  if (!mojo::Equals(this->aspect_ratio, other_struct.aspect_ratio))
    return false;
  if (!mojo::Equals(this->extra_data, other_struct.extra_data))
    return false;
  if (!mojo::Equals(this->encryption_scheme, other_struct.encryption_scheme))
    return false;
  if (!mojo::Equals(this->color_space_info, other_struct.color_space_info))
    return false;
  if (!mojo::Equals(this->hdr_metadata, other_struct.hdr_metadata))
    return false;
  return true;
}

template <typename T, VideoDecoderConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.codec < rhs.codec)
    return true;
  if (rhs.codec < lhs.codec)
    return false;
  if (lhs.profile < rhs.profile)
    return true;
  if (rhs.profile < lhs.profile)
    return false;
  if (lhs.level < rhs.level)
    return true;
  if (rhs.level < lhs.level)
    return false;
  if (lhs.has_alpha < rhs.has_alpha)
    return true;
  if (rhs.has_alpha < lhs.has_alpha)
    return false;
  if (lhs.transformation < rhs.transformation)
    return true;
  if (rhs.transformation < lhs.transformation)
    return false;
  if (lhs.coded_size < rhs.coded_size)
    return true;
  if (rhs.coded_size < lhs.coded_size)
    return false;
  if (lhs.visible_rect < rhs.visible_rect)
    return true;
  if (rhs.visible_rect < lhs.visible_rect)
    return false;
  if (lhs.natural_size < rhs.natural_size)
    return true;
  if (rhs.natural_size < lhs.natural_size)
    return false;
  if (lhs.aspect_ratio < rhs.aspect_ratio)
    return true;
  if (rhs.aspect_ratio < lhs.aspect_ratio)
    return false;
  if (lhs.extra_data < rhs.extra_data)
    return true;
  if (rhs.extra_data < lhs.extra_data)
    return false;
  if (lhs.encryption_scheme < rhs.encryption_scheme)
    return true;
  if (rhs.encryption_scheme < lhs.encryption_scheme)
    return false;
  if (lhs.color_space_info < rhs.color_space_info)
    return true;
  if (rhs.color_space_info < lhs.color_space_info)
    return false;
  if (lhs.hdr_metadata < rhs.hdr_metadata)
    return true;
  if (rhs.hdr_metadata < lhs.hdr_metadata)
    return false;
  return false;
}
template <typename StructPtrType>
DecryptConfigPtr DecryptConfig::Clone() const {
  return New(
      mojo::Clone(encryption_scheme),
      mojo::Clone(key_id),
      mojo::Clone(iv),
      mojo::Clone(subsamples),
      mojo::Clone(encryption_pattern)
  );
}

template <typename T, DecryptConfig::EnableIfSame<T>*>
bool DecryptConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->encryption_scheme, other_struct.encryption_scheme))
    return false;
  if (!mojo::Equals(this->key_id, other_struct.key_id))
    return false;
  if (!mojo::Equals(this->iv, other_struct.iv))
    return false;
  if (!mojo::Equals(this->subsamples, other_struct.subsamples))
    return false;
  if (!mojo::Equals(this->encryption_pattern, other_struct.encryption_pattern))
    return false;
  return true;
}

template <typename T, DecryptConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.encryption_scheme < rhs.encryption_scheme)
    return true;
  if (rhs.encryption_scheme < lhs.encryption_scheme)
    return false;
  if (lhs.key_id < rhs.key_id)
    return true;
  if (rhs.key_id < lhs.key_id)
    return false;
  if (lhs.iv < rhs.iv)
    return true;
  if (rhs.iv < lhs.iv)
    return false;
  if (lhs.subsamples < rhs.subsamples)
    return true;
  if (rhs.subsamples < lhs.subsamples)
    return false;
  if (lhs.encryption_pattern < rhs.encryption_pattern)
    return true;
  if (rhs.encryption_pattern < lhs.encryption_pattern)
    return false;
  return false;
}
template <typename StructPtrType>
DecoderBufferSideDataPtr DecoderBufferSideData::Clone() const {
  return New(
      mojo::Clone(spatial_layers),
      mojo::Clone(alpha_data),
      mojo::Clone(secure_handle),
      mojo::Clone(front_discard),
      mojo::Clone(back_discard)
  );
}

template <typename T, DecoderBufferSideData::EnableIfSame<T>*>
bool DecoderBufferSideData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->spatial_layers, other_struct.spatial_layers))
    return false;
  if (!mojo::Equals(this->alpha_data, other_struct.alpha_data))
    return false;
  if (!mojo::Equals(this->secure_handle, other_struct.secure_handle))
    return false;
  if (!mojo::Equals(this->front_discard, other_struct.front_discard))
    return false;
  if (!mojo::Equals(this->back_discard, other_struct.back_discard))
    return false;
  return true;
}

template <typename T, DecoderBufferSideData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.spatial_layers < rhs.spatial_layers)
    return true;
  if (rhs.spatial_layers < lhs.spatial_layers)
    return false;
  if (lhs.alpha_data < rhs.alpha_data)
    return true;
  if (rhs.alpha_data < lhs.alpha_data)
    return false;
  if (lhs.secure_handle < rhs.secure_handle)
    return true;
  if (rhs.secure_handle < lhs.secure_handle)
    return false;
  if (lhs.front_discard < rhs.front_discard)
    return true;
  if (rhs.front_discard < lhs.front_discard)
    return false;
  if (lhs.back_discard < rhs.back_discard)
    return true;
  if (rhs.back_discard < lhs.back_discard)
    return false;
  return false;
}
template <typename StructPtrType>
DataDecoderBufferPtr DataDecoderBuffer::Clone() const {
  return New(
      mojo::Clone(timestamp),
      mojo::Clone(duration),
      mojo::Clone(data_size),
      mojo::Clone(is_key_frame),
      mojo::Clone(decrypt_config),
      mojo::Clone(side_data)
  );
}

template <typename T, DataDecoderBuffer::EnableIfSame<T>*>
bool DataDecoderBuffer::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  if (!mojo::Equals(this->duration, other_struct.duration))
    return false;
  if (!mojo::Equals(this->data_size, other_struct.data_size))
    return false;
  if (!mojo::Equals(this->is_key_frame, other_struct.is_key_frame))
    return false;
  if (!mojo::Equals(this->decrypt_config, other_struct.decrypt_config))
    return false;
  if (!mojo::Equals(this->side_data, other_struct.side_data))
    return false;
  return true;
}

template <typename T, DataDecoderBuffer::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.timestamp < rhs.timestamp)
    return true;
  if (rhs.timestamp < lhs.timestamp)
    return false;
  if (lhs.duration < rhs.duration)
    return true;
  if (rhs.duration < lhs.duration)
    return false;
  if (lhs.data_size < rhs.data_size)
    return true;
  if (rhs.data_size < lhs.data_size)
    return false;
  if (lhs.is_key_frame < rhs.is_key_frame)
    return true;
  if (rhs.is_key_frame < lhs.is_key_frame)
    return false;
  if (lhs.decrypt_config < rhs.decrypt_config)
    return true;
  if (rhs.decrypt_config < lhs.decrypt_config)
    return false;
  if (lhs.side_data < rhs.side_data)
    return true;
  if (rhs.side_data < lhs.side_data)
    return false;
  return false;
}
template <typename StructPtrType>
EosDecoderBufferPtr EosDecoderBuffer::Clone() const {
  return New(
      mojo::Clone(next_config)
  );
}

template <typename T, EosDecoderBuffer::EnableIfSame<T>*>
bool EosDecoderBuffer::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->next_config, other_struct.next_config))
    return false;
  return true;
}

template <typename T, EosDecoderBuffer::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.next_config < rhs.next_config)
    return true;
  if (rhs.next_config < lhs.next_config)
    return false;
  return false;
}
template <typename StructPtrType>
AudioBufferPtr AudioBuffer::Clone() const {
  return New(
      mojo::Clone(sample_format),
      mojo::Clone(channel_layout),
      mojo::Clone(channel_count),
      mojo::Clone(sample_rate),
      mojo::Clone(frame_count),
      mojo::Clone(end_of_stream),
      mojo::Clone(timestamp),
      mojo::Clone(data)
  );
}

template <typename T, AudioBuffer::EnableIfSame<T>*>
bool AudioBuffer::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->sample_format, other_struct.sample_format))
    return false;
  if (!mojo::Equals(this->channel_layout, other_struct.channel_layout))
    return false;
  if (!mojo::Equals(this->channel_count, other_struct.channel_count))
    return false;
  if (!mojo::Equals(this->sample_rate, other_struct.sample_rate))
    return false;
  if (!mojo::Equals(this->frame_count, other_struct.frame_count))
    return false;
  if (!mojo::Equals(this->end_of_stream, other_struct.end_of_stream))
    return false;
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, AudioBuffer::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.sample_format < rhs.sample_format)
    return true;
  if (rhs.sample_format < lhs.sample_format)
    return false;
  if (lhs.channel_layout < rhs.channel_layout)
    return true;
  if (rhs.channel_layout < lhs.channel_layout)
    return false;
  if (lhs.channel_count < rhs.channel_count)
    return true;
  if (rhs.channel_count < lhs.channel_count)
    return false;
  if (lhs.sample_rate < rhs.sample_rate)
    return true;
  if (rhs.sample_rate < lhs.sample_rate)
    return false;
  if (lhs.frame_count < rhs.frame_count)
    return true;
  if (rhs.frame_count < lhs.frame_count)
    return false;
  if (lhs.end_of_stream < rhs.end_of_stream)
    return true;
  if (rhs.end_of_stream < lhs.end_of_stream)
    return false;
  if (lhs.timestamp < rhs.timestamp)
    return true;
  if (rhs.timestamp < lhs.timestamp)
    return false;
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}
template <typename StructPtrType>
VideoFrameMetadataPtr VideoFrameMetadata::Clone() const {
  return New(
      mojo::Clone(allow_overlay),
      mojo::Clone(capture_begin_time),
      mojo::Clone(capture_end_time),
      mojo::Clone(has_capture_counter),
      mojo::Clone(capture_counter),
      mojo::Clone(capture_update_rect),
      mojo::Clone(source_size),
      mojo::Clone(region_capture_rect),
      mojo::Clone(sub_capture_target_version),
      mojo::Clone(copy_required),
      mojo::Clone(end_of_stream),
      mojo::Clone(frame_duration),
      mojo::Clone(has_frame_rate),
      mojo::Clone(frame_rate),
      mojo::Clone(interactive_content),
      mojo::Clone(reference_time),
      mojo::Clone(read_lock_fences_enabled),
      mojo::Clone(transformation),
      mojo::Clone(texture_owner),
      mojo::Clone(wants_promotion_hint),
      mojo::Clone(protected_video),
      mojo::Clone(hw_protected),
      mojo::Clone(needs_detiling),
      mojo::Clone(is_webgpu_compatible),
      mojo::Clone(tracking_token),
      mojo::Clone(power_efficient),
      mojo::Clone(has_device_scale_factor),
      mojo::Clone(device_scale_factor),
      mojo::Clone(has_page_scale_factor),
      mojo::Clone(page_scale_factor),
      mojo::Clone(has_root_scroll_offset_x),
      mojo::Clone(root_scroll_offset_x),
      mojo::Clone(has_root_scroll_offset_y),
      mojo::Clone(root_scroll_offset_y),
      mojo::Clone(has_top_controls_visible_height),
      mojo::Clone(top_controls_visible_height),
      mojo::Clone(decode_begin_time),
      mojo::Clone(decode_end_time),
      mojo::Clone(processing_time),
      mojo::Clone(has_rtp_timestamp),
      mojo::Clone(rtp_timestamp),
      mojo::Clone(receive_time),
      mojo::Clone(wallclock_frame_duration),
      mojo::Clone(frame_sequence),
      mojo::Clone(source_id),
      mojo::Clone(background_blur)
  );
}

template <typename T, VideoFrameMetadata::EnableIfSame<T>*>
bool VideoFrameMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->allow_overlay, other_struct.allow_overlay))
    return false;
  if (!mojo::Equals(this->capture_begin_time, other_struct.capture_begin_time))
    return false;
  if (!mojo::Equals(this->capture_end_time, other_struct.capture_end_time))
    return false;
  if (!mojo::Equals(this->has_capture_counter, other_struct.has_capture_counter))
    return false;
  if (!mojo::Equals(this->capture_counter, other_struct.capture_counter))
    return false;
  if (!mojo::Equals(this->capture_update_rect, other_struct.capture_update_rect))
    return false;
  if (!mojo::Equals(this->source_size, other_struct.source_size))
    return false;
  if (!mojo::Equals(this->region_capture_rect, other_struct.region_capture_rect))
    return false;
  if (!mojo::Equals(this->sub_capture_target_version, other_struct.sub_capture_target_version))
    return false;
  if (!mojo::Equals(this->copy_required, other_struct.copy_required))
    return false;
  if (!mojo::Equals(this->end_of_stream, other_struct.end_of_stream))
    return false;
  if (!mojo::Equals(this->frame_duration, other_struct.frame_duration))
    return false;
  if (!mojo::Equals(this->has_frame_rate, other_struct.has_frame_rate))
    return false;
  if (!mojo::Equals(this->frame_rate, other_struct.frame_rate))
    return false;
  if (!mojo::Equals(this->interactive_content, other_struct.interactive_content))
    return false;
  if (!mojo::Equals(this->reference_time, other_struct.reference_time))
    return false;
  if (!mojo::Equals(this->read_lock_fences_enabled, other_struct.read_lock_fences_enabled))
    return false;
  if (!mojo::Equals(this->transformation, other_struct.transformation))
    return false;
  if (!mojo::Equals(this->texture_owner, other_struct.texture_owner))
    return false;
  if (!mojo::Equals(this->wants_promotion_hint, other_struct.wants_promotion_hint))
    return false;
  if (!mojo::Equals(this->protected_video, other_struct.protected_video))
    return false;
  if (!mojo::Equals(this->hw_protected, other_struct.hw_protected))
    return false;
  if (!mojo::Equals(this->needs_detiling, other_struct.needs_detiling))
    return false;
  if (!mojo::Equals(this->is_webgpu_compatible, other_struct.is_webgpu_compatible))
    return false;
  if (!mojo::Equals(this->tracking_token, other_struct.tracking_token))
    return false;
  if (!mojo::Equals(this->power_efficient, other_struct.power_efficient))
    return false;
  if (!mojo::Equals(this->has_device_scale_factor, other_struct.has_device_scale_factor))
    return false;
  if (!mojo::Equals(this->device_scale_factor, other_struct.device_scale_factor))
    return false;
  if (!mojo::Equals(this->has_page_scale_factor, other_struct.has_page_scale_factor))
    return false;
  if (!mojo::Equals(this->page_scale_factor, other_struct.page_scale_factor))
    return false;
  if (!mojo::Equals(this->has_root_scroll_offset_x, other_struct.has_root_scroll_offset_x))
    return false;
  if (!mojo::Equals(this->root_scroll_offset_x, other_struct.root_scroll_offset_x))
    return false;
  if (!mojo::Equals(this->has_root_scroll_offset_y, other_struct.has_root_scroll_offset_y))
    return false;
  if (!mojo::Equals(this->root_scroll_offset_y, other_struct.root_scroll_offset_y))
    return false;
  if (!mojo::Equals(this->has_top_controls_visible_height, other_struct.has_top_controls_visible_height))
    return false;
  if (!mojo::Equals(this->top_controls_visible_height, other_struct.top_controls_visible_height))
    return false;
  if (!mojo::Equals(this->decode_begin_time, other_struct.decode_begin_time))
    return false;
  if (!mojo::Equals(this->decode_end_time, other_struct.decode_end_time))
    return false;
  if (!mojo::Equals(this->processing_time, other_struct.processing_time))
    return false;
  if (!mojo::Equals(this->has_rtp_timestamp, other_struct.has_rtp_timestamp))
    return false;
  if (!mojo::Equals(this->rtp_timestamp, other_struct.rtp_timestamp))
    return false;
  if (!mojo::Equals(this->receive_time, other_struct.receive_time))
    return false;
  if (!mojo::Equals(this->wallclock_frame_duration, other_struct.wallclock_frame_duration))
    return false;
  if (!mojo::Equals(this->frame_sequence, other_struct.frame_sequence))
    return false;
  if (!mojo::Equals(this->source_id, other_struct.source_id))
    return false;
  if (!mojo::Equals(this->background_blur, other_struct.background_blur))
    return false;
  return true;
}

template <typename T, VideoFrameMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.allow_overlay < rhs.allow_overlay)
    return true;
  if (rhs.allow_overlay < lhs.allow_overlay)
    return false;
  if (lhs.capture_begin_time < rhs.capture_begin_time)
    return true;
  if (rhs.capture_begin_time < lhs.capture_begin_time)
    return false;
  if (lhs.capture_end_time < rhs.capture_end_time)
    return true;
  if (rhs.capture_end_time < lhs.capture_end_time)
    return false;
  if (lhs.has_capture_counter < rhs.has_capture_counter)
    return true;
  if (rhs.has_capture_counter < lhs.has_capture_counter)
    return false;
  if (lhs.capture_counter < rhs.capture_counter)
    return true;
  if (rhs.capture_counter < lhs.capture_counter)
    return false;
  if (lhs.capture_update_rect < rhs.capture_update_rect)
    return true;
  if (rhs.capture_update_rect < lhs.capture_update_rect)
    return false;
  if (lhs.source_size < rhs.source_size)
    return true;
  if (rhs.source_size < lhs.source_size)
    return false;
  if (lhs.region_capture_rect < rhs.region_capture_rect)
    return true;
  if (rhs.region_capture_rect < lhs.region_capture_rect)
    return false;
  if (lhs.sub_capture_target_version < rhs.sub_capture_target_version)
    return true;
  if (rhs.sub_capture_target_version < lhs.sub_capture_target_version)
    return false;
  if (lhs.copy_required < rhs.copy_required)
    return true;
  if (rhs.copy_required < lhs.copy_required)
    return false;
  if (lhs.end_of_stream < rhs.end_of_stream)
    return true;
  if (rhs.end_of_stream < lhs.end_of_stream)
    return false;
  if (lhs.frame_duration < rhs.frame_duration)
    return true;
  if (rhs.frame_duration < lhs.frame_duration)
    return false;
  if (lhs.has_frame_rate < rhs.has_frame_rate)
    return true;
  if (rhs.has_frame_rate < lhs.has_frame_rate)
    return false;
  if (lhs.frame_rate < rhs.frame_rate)
    return true;
  if (rhs.frame_rate < lhs.frame_rate)
    return false;
  if (lhs.interactive_content < rhs.interactive_content)
    return true;
  if (rhs.interactive_content < lhs.interactive_content)
    return false;
  if (lhs.reference_time < rhs.reference_time)
    return true;
  if (rhs.reference_time < lhs.reference_time)
    return false;
  if (lhs.read_lock_fences_enabled < rhs.read_lock_fences_enabled)
    return true;
  if (rhs.read_lock_fences_enabled < lhs.read_lock_fences_enabled)
    return false;
  if (lhs.transformation < rhs.transformation)
    return true;
  if (rhs.transformation < lhs.transformation)
    return false;
  if (lhs.texture_owner < rhs.texture_owner)
    return true;
  if (rhs.texture_owner < lhs.texture_owner)
    return false;
  if (lhs.wants_promotion_hint < rhs.wants_promotion_hint)
    return true;
  if (rhs.wants_promotion_hint < lhs.wants_promotion_hint)
    return false;
  if (lhs.protected_video < rhs.protected_video)
    return true;
  if (rhs.protected_video < lhs.protected_video)
    return false;
  if (lhs.hw_protected < rhs.hw_protected)
    return true;
  if (rhs.hw_protected < lhs.hw_protected)
    return false;
  if (lhs.needs_detiling < rhs.needs_detiling)
    return true;
  if (rhs.needs_detiling < lhs.needs_detiling)
    return false;
  if (lhs.is_webgpu_compatible < rhs.is_webgpu_compatible)
    return true;
  if (rhs.is_webgpu_compatible < lhs.is_webgpu_compatible)
    return false;
  if (lhs.tracking_token < rhs.tracking_token)
    return true;
  if (rhs.tracking_token < lhs.tracking_token)
    return false;
  if (lhs.power_efficient < rhs.power_efficient)
    return true;
  if (rhs.power_efficient < lhs.power_efficient)
    return false;
  if (lhs.has_device_scale_factor < rhs.has_device_scale_factor)
    return true;
  if (rhs.has_device_scale_factor < lhs.has_device_scale_factor)
    return false;
  if (lhs.device_scale_factor < rhs.device_scale_factor)
    return true;
  if (rhs.device_scale_factor < lhs.device_scale_factor)
    return false;
  if (lhs.has_page_scale_factor < rhs.has_page_scale_factor)
    return true;
  if (rhs.has_page_scale_factor < lhs.has_page_scale_factor)
    return false;
  if (lhs.page_scale_factor < rhs.page_scale_factor)
    return true;
  if (rhs.page_scale_factor < lhs.page_scale_factor)
    return false;
  if (lhs.has_root_scroll_offset_x < rhs.has_root_scroll_offset_x)
    return true;
  if (rhs.has_root_scroll_offset_x < lhs.has_root_scroll_offset_x)
    return false;
  if (lhs.root_scroll_offset_x < rhs.root_scroll_offset_x)
    return true;
  if (rhs.root_scroll_offset_x < lhs.root_scroll_offset_x)
    return false;
  if (lhs.has_root_scroll_offset_y < rhs.has_root_scroll_offset_y)
    return true;
  if (rhs.has_root_scroll_offset_y < lhs.has_root_scroll_offset_y)
    return false;
  if (lhs.root_scroll_offset_y < rhs.root_scroll_offset_y)
    return true;
  if (rhs.root_scroll_offset_y < lhs.root_scroll_offset_y)
    return false;
  if (lhs.has_top_controls_visible_height < rhs.has_top_controls_visible_height)
    return true;
  if (rhs.has_top_controls_visible_height < lhs.has_top_controls_visible_height)
    return false;
  if (lhs.top_controls_visible_height < rhs.top_controls_visible_height)
    return true;
  if (rhs.top_controls_visible_height < lhs.top_controls_visible_height)
    return false;
  if (lhs.decode_begin_time < rhs.decode_begin_time)
    return true;
  if (rhs.decode_begin_time < lhs.decode_begin_time)
    return false;
  if (lhs.decode_end_time < rhs.decode_end_time)
    return true;
  if (rhs.decode_end_time < lhs.decode_end_time)
    return false;
  if (lhs.processing_time < rhs.processing_time)
    return true;
  if (rhs.processing_time < lhs.processing_time)
    return false;
  if (lhs.has_rtp_timestamp < rhs.has_rtp_timestamp)
    return true;
  if (rhs.has_rtp_timestamp < lhs.has_rtp_timestamp)
    return false;
  if (lhs.rtp_timestamp < rhs.rtp_timestamp)
    return true;
  if (rhs.rtp_timestamp < lhs.rtp_timestamp)
    return false;
  if (lhs.receive_time < rhs.receive_time)
    return true;
  if (rhs.receive_time < lhs.receive_time)
    return false;
  if (lhs.wallclock_frame_duration < rhs.wallclock_frame_duration)
    return true;
  if (rhs.wallclock_frame_duration < lhs.wallclock_frame_duration)
    return false;
  if (lhs.frame_sequence < rhs.frame_sequence)
    return true;
  if (rhs.frame_sequence < lhs.frame_sequence)
    return false;
  if (lhs.source_id < rhs.source_id)
    return true;
  if (rhs.source_id < lhs.source_id)
    return false;
  if (lhs.background_blur < rhs.background_blur)
    return true;
  if (rhs.background_blur < lhs.background_blur)
    return false;
  return false;
}
template <typename StructPtrType>
VideoFramePtr VideoFrame::Clone() const {
  return New(
      mojo::Clone(format),
      mojo::Clone(coded_size),
      mojo::Clone(visible_rect),
      mojo::Clone(natural_size),
      mojo::Clone(timestamp),
      mojo::Clone(data),
      mojo::Clone(metadata),
      mojo::Clone(color_space),
      mojo::Clone(hdr_metadata)
  );
}

template <typename T, VideoFrame::EnableIfSame<T>*>
bool VideoFrame::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->format, other_struct.format))
    return false;
  if (!mojo::Equals(this->coded_size, other_struct.coded_size))
    return false;
  if (!mojo::Equals(this->visible_rect, other_struct.visible_rect))
    return false;
  if (!mojo::Equals(this->natural_size, other_struct.natural_size))
    return false;
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  if (!mojo::Equals(this->metadata, other_struct.metadata))
    return false;
  if (!mojo::Equals(this->color_space, other_struct.color_space))
    return false;
  if (!mojo::Equals(this->hdr_metadata, other_struct.hdr_metadata))
    return false;
  return true;
}

template <typename T, VideoFrame::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.format < rhs.format)
    return true;
  if (rhs.format < lhs.format)
    return false;
  if (lhs.coded_size < rhs.coded_size)
    return true;
  if (rhs.coded_size < lhs.coded_size)
    return false;
  if (lhs.visible_rect < rhs.visible_rect)
    return true;
  if (rhs.visible_rect < lhs.visible_rect)
    return false;
  if (lhs.natural_size < rhs.natural_size)
    return true;
  if (rhs.natural_size < lhs.natural_size)
    return false;
  if (lhs.timestamp < rhs.timestamp)
    return true;
  if (rhs.timestamp < lhs.timestamp)
    return false;
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  if (lhs.metadata < rhs.metadata)
    return true;
  if (rhs.metadata < lhs.metadata)
    return false;
  if (lhs.color_space < rhs.color_space)
    return true;
  if (rhs.color_space < lhs.color_space)
    return false;
  if (lhs.hdr_metadata < rhs.hdr_metadata)
    return true;
  if (rhs.hdr_metadata < lhs.hdr_metadata)
    return false;
  return false;
}
template <typename StructPtrType>
EosVideoFrameDataPtr EosVideoFrameData::Clone() const {
  return New(
  );
}

template <typename T, EosVideoFrameData::EnableIfSame<T>*>
bool EosVideoFrameData::Equals(const T& other_struct) const {
  return true;
}

template <typename T, EosVideoFrameData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
SharedMemoryVideoFrameDataPtr SharedMemoryVideoFrameData::Clone() const {
  return New(
      mojo::Clone(frame_data),
      mojo::Clone(strides),
      mojo::Clone(offsets)
  );
}

template <typename T, SharedMemoryVideoFrameData::EnableIfSame<T>*>
bool SharedMemoryVideoFrameData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame_data, other_struct.frame_data))
    return false;
  if (!mojo::Equals(this->strides, other_struct.strides))
    return false;
  if (!mojo::Equals(this->offsets, other_struct.offsets))
    return false;
  return true;
}

template <typename T, SharedMemoryVideoFrameData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.frame_data < rhs.frame_data)
    return true;
  if (rhs.frame_data < lhs.frame_data)
    return false;
  if (lhs.strides < rhs.strides)
    return true;
  if (rhs.strides < lhs.strides)
    return false;
  if (lhs.offsets < rhs.offsets)
    return true;
  if (rhs.offsets < lhs.offsets)
    return false;
  return false;
}
template <typename StructPtrType>
GpuMemoryBufferSharedImageVideoFrameDataPtr GpuMemoryBufferSharedImageVideoFrameData::Clone() const {
  return New(
      mojo::Clone(gpu_memory_buffer_handle),
      mojo::Clone(shared_image),
      mojo::Clone(sync_token)
  );
}

template <typename T, GpuMemoryBufferSharedImageVideoFrameData::EnableIfSame<T>*>
bool GpuMemoryBufferSharedImageVideoFrameData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->gpu_memory_buffer_handle, other_struct.gpu_memory_buffer_handle))
    return false;
  if (!mojo::Equals(this->shared_image, other_struct.shared_image))
    return false;
  if (!mojo::Equals(this->sync_token, other_struct.sync_token))
    return false;
  return true;
}

template <typename T, GpuMemoryBufferSharedImageVideoFrameData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.gpu_memory_buffer_handle < rhs.gpu_memory_buffer_handle)
    return true;
  if (rhs.gpu_memory_buffer_handle < lhs.gpu_memory_buffer_handle)
    return false;
  if (lhs.shared_image < rhs.shared_image)
    return true;
  if (rhs.shared_image < lhs.shared_image)
    return false;
  if (lhs.sync_token < rhs.sync_token)
    return true;
  if (rhs.sync_token < lhs.sync_token)
    return false;
  return false;
}
template <typename StructPtrType>
SharedImageVideoFrameDataPtr SharedImageVideoFrameData::Clone() const {
  return New(
      mojo::Clone(shared_image),
      mojo::Clone(sync_token),
      mojo::Clone(ycbcr_data)
  );
}

template <typename T, SharedImageVideoFrameData::EnableIfSame<T>*>
bool SharedImageVideoFrameData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->shared_image, other_struct.shared_image))
    return false;
  if (!mojo::Equals(this->sync_token, other_struct.sync_token))
    return false;
  if (!mojo::Equals(this->ycbcr_data, other_struct.ycbcr_data))
    return false;
  return true;
}

template <typename T, SharedImageVideoFrameData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.shared_image < rhs.shared_image)
    return true;
  if (rhs.shared_image < lhs.shared_image)
    return false;
  if (lhs.sync_token < rhs.sync_token)
    return true;
  if (rhs.sync_token < lhs.sync_token)
    return false;
  if (lhs.ycbcr_data < rhs.ycbcr_data)
    return true;
  if (rhs.ycbcr_data < lhs.ycbcr_data)
    return false;
  return false;
}
template <typename StructPtrType>
OpaqueVideoFrameDataPtr OpaqueVideoFrameData::Clone() const {
  return New(
  );
}

template <typename T, OpaqueVideoFrameData::EnableIfSame<T>*>
bool OpaqueVideoFrameData::Equals(const T& other_struct) const {
  return true;
}

template <typename T, OpaqueVideoFrameData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
PipelineStatisticsPtr PipelineStatistics::Clone() const {
  return New(
      mojo::Clone(audio_bytes_decoded),
      mojo::Clone(video_bytes_decoded),
      mojo::Clone(video_frames_decoded),
      mojo::Clone(video_frames_dropped),
      mojo::Clone(audio_memory_usage),
      mojo::Clone(video_memory_usage)
  );
}

template <typename T, PipelineStatistics::EnableIfSame<T>*>
bool PipelineStatistics::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->audio_bytes_decoded, other_struct.audio_bytes_decoded))
    return false;
  if (!mojo::Equals(this->video_bytes_decoded, other_struct.video_bytes_decoded))
    return false;
  if (!mojo::Equals(this->video_frames_decoded, other_struct.video_frames_decoded))
    return false;
  if (!mojo::Equals(this->video_frames_dropped, other_struct.video_frames_dropped))
    return false;
  if (!mojo::Equals(this->audio_memory_usage, other_struct.audio_memory_usage))
    return false;
  if (!mojo::Equals(this->video_memory_usage, other_struct.video_memory_usage))
    return false;
  return true;
}

template <typename T, PipelineStatistics::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.audio_bytes_decoded < rhs.audio_bytes_decoded)
    return true;
  if (rhs.audio_bytes_decoded < lhs.audio_bytes_decoded)
    return false;
  if (lhs.video_bytes_decoded < rhs.video_bytes_decoded)
    return true;
  if (rhs.video_bytes_decoded < lhs.video_bytes_decoded)
    return false;
  if (lhs.video_frames_decoded < rhs.video_frames_decoded)
    return true;
  if (rhs.video_frames_decoded < lhs.video_frames_decoded)
    return false;
  if (lhs.video_frames_dropped < rhs.video_frames_dropped)
    return true;
  if (rhs.video_frames_dropped < lhs.video_frames_dropped)
    return false;
  if (lhs.audio_memory_usage < rhs.audio_memory_usage)
    return true;
  if (rhs.audio_memory_usage < lhs.audio_memory_usage)
    return false;
  if (lhs.video_memory_usage < rhs.video_memory_usage)
    return true;
  if (rhs.video_memory_usage < lhs.video_memory_usage)
    return false;
  return false;
}
template <typename StructPtrType>
PredictionFeaturesPtr PredictionFeatures::Clone() const {
  return New(
      mojo::Clone(profile),
      mojo::Clone(video_size),
      mojo::Clone(frames_per_sec),
      mojo::Clone(key_system),
      mojo::Clone(use_hw_secure_codecs)
  );
}

template <typename T, PredictionFeatures::EnableIfSame<T>*>
bool PredictionFeatures::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->profile, other_struct.profile))
    return false;
  if (!mojo::Equals(this->video_size, other_struct.video_size))
    return false;
  if (!mojo::Equals(this->frames_per_sec, other_struct.frames_per_sec))
    return false;
  if (!mojo::Equals(this->key_system, other_struct.key_system))
    return false;
  if (!mojo::Equals(this->use_hw_secure_codecs, other_struct.use_hw_secure_codecs))
    return false;
  return true;
}

template <typename T, PredictionFeatures::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.profile < rhs.profile)
    return true;
  if (rhs.profile < lhs.profile)
    return false;
  if (lhs.video_size < rhs.video_size)
    return true;
  if (rhs.video_size < lhs.video_size)
    return false;
  if (lhs.frames_per_sec < rhs.frames_per_sec)
    return true;
  if (rhs.frames_per_sec < lhs.frames_per_sec)
    return false;
  if (lhs.key_system < rhs.key_system)
    return true;
  if (rhs.key_system < lhs.key_system)
    return false;
  if (lhs.use_hw_secure_codecs < rhs.use_hw_secure_codecs)
    return true;
  if (rhs.use_hw_secure_codecs < lhs.use_hw_secure_codecs)
    return false;
  return false;
}
template <typename StructPtrType>
PredictionTargetsPtr PredictionTargets::Clone() const {
  return New(
      mojo::Clone(frames_decoded),
      mojo::Clone(frames_dropped),
      mojo::Clone(frames_power_efficient)
  );
}

template <typename T, PredictionTargets::EnableIfSame<T>*>
bool PredictionTargets::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frames_decoded, other_struct.frames_decoded))
    return false;
  if (!mojo::Equals(this->frames_dropped, other_struct.frames_dropped))
    return false;
  if (!mojo::Equals(this->frames_power_efficient, other_struct.frames_power_efficient))
    return false;
  return true;
}

template <typename T, PredictionTargets::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.frames_decoded < rhs.frames_decoded)
    return true;
  if (rhs.frames_decoded < lhs.frames_decoded)
    return false;
  if (lhs.frames_dropped < rhs.frames_dropped)
    return true;
  if (rhs.frames_dropped < lhs.frames_dropped)
    return false;
  if (lhs.frames_power_efficient < rhs.frames_power_efficient)
    return true;
  if (rhs.frames_power_efficient < lhs.frames_power_efficient)
    return false;
  return false;
}
template <typename StructPtrType>
AudioPipelineInfoPtr AudioPipelineInfo::Clone() const {
  return New(
      mojo::Clone(decoder_type),
      mojo::Clone(is_platform_decoder),
      mojo::Clone(has_decrypting_demuxer_stream),
      mojo::Clone(encryption_type)
  );
}

template <typename T, AudioPipelineInfo::EnableIfSame<T>*>
bool AudioPipelineInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->decoder_type, other_struct.decoder_type))
    return false;
  if (!mojo::Equals(this->is_platform_decoder, other_struct.is_platform_decoder))
    return false;
  if (!mojo::Equals(this->has_decrypting_demuxer_stream, other_struct.has_decrypting_demuxer_stream))
    return false;
  if (!mojo::Equals(this->encryption_type, other_struct.encryption_type))
    return false;
  return true;
}

template <typename T, AudioPipelineInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.decoder_type < rhs.decoder_type)
    return true;
  if (rhs.decoder_type < lhs.decoder_type)
    return false;
  if (lhs.is_platform_decoder < rhs.is_platform_decoder)
    return true;
  if (rhs.is_platform_decoder < lhs.is_platform_decoder)
    return false;
  if (lhs.has_decrypting_demuxer_stream < rhs.has_decrypting_demuxer_stream)
    return true;
  if (rhs.has_decrypting_demuxer_stream < lhs.has_decrypting_demuxer_stream)
    return false;
  if (lhs.encryption_type < rhs.encryption_type)
    return true;
  if (rhs.encryption_type < lhs.encryption_type)
    return false;
  return false;
}
template <typename StructPtrType>
VideoPipelineInfoPtr VideoPipelineInfo::Clone() const {
  return New(
      mojo::Clone(decoder_type),
      mojo::Clone(is_platform_decoder),
      mojo::Clone(has_decrypting_demuxer_stream),
      mojo::Clone(encryption_type)
  );
}

template <typename T, VideoPipelineInfo::EnableIfSame<T>*>
bool VideoPipelineInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->decoder_type, other_struct.decoder_type))
    return false;
  if (!mojo::Equals(this->is_platform_decoder, other_struct.is_platform_decoder))
    return false;
  if (!mojo::Equals(this->has_decrypting_demuxer_stream, other_struct.has_decrypting_demuxer_stream))
    return false;
  if (!mojo::Equals(this->encryption_type, other_struct.encryption_type))
    return false;
  return true;
}

template <typename T, VideoPipelineInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.decoder_type < rhs.decoder_type)
    return true;
  if (rhs.decoder_type < lhs.decoder_type)
    return false;
  if (lhs.is_platform_decoder < rhs.is_platform_decoder)
    return true;
  if (rhs.is_platform_decoder < lhs.is_platform_decoder)
    return false;
  if (lhs.has_decrypting_demuxer_stream < rhs.has_decrypting_demuxer_stream)
    return true;
  if (rhs.has_decrypting_demuxer_stream < lhs.has_decrypting_demuxer_stream)
    return false;
  if (lhs.encryption_type < rhs.encryption_type)
    return true;
  if (rhs.encryption_type < lhs.encryption_type)
    return false;
  return false;
}
template <typename StructPtrType>
StatusDataPtr StatusData::Clone() const {
  return New(
      mojo::Clone(group),
      mojo::Clone(code),
      mojo::Clone(message),
      mojo::Clone(frames),
      mojo::Clone(cause),
      mojo::Clone(data),
      mojo::Clone(packed_root_cause)
  );
}

template <typename T, StatusData::EnableIfSame<T>*>
bool StatusData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->group, other_struct.group))
    return false;
  if (!mojo::Equals(this->code, other_struct.code))
    return false;
  if (!mojo::Equals(this->message, other_struct.message))
    return false;
  if (!mojo::Equals(this->frames, other_struct.frames))
    return false;
  if (!mojo::Equals(this->cause, other_struct.cause))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  if (!mojo::Equals(this->packed_root_cause, other_struct.packed_root_cause))
    return false;
  return true;
}

template <typename T, StatusData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.group < rhs.group)
    return true;
  if (rhs.group < lhs.group)
    return false;
  if (lhs.code < rhs.code)
    return true;
  if (rhs.code < lhs.code)
    return false;
  if (lhs.message < rhs.message)
    return true;
  if (rhs.message < lhs.message)
    return false;
  if (lhs.frames < rhs.frames)
    return true;
  if (rhs.frames < lhs.frames)
    return false;
  if (lhs.cause < rhs.cause)
    return true;
  if (rhs.cause < lhs.cause)
    return false;
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  if (lhs.packed_root_cause < rhs.packed_root_cause)
    return true;
  if (rhs.packed_root_cause < lhs.packed_root_cause)
    return false;
  return false;
}
template <typename StructPtrType>
EncoderStatusPtr EncoderStatus::Clone() const {
  return New(
      mojo::Clone(internal)
  );
}

template <typename T, EncoderStatus::EnableIfSame<T>*>
bool EncoderStatus::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->internal, other_struct.internal))
    return false;
  return true;
}

template <typename T, EncoderStatus::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.internal < rhs.internal)
    return true;
  if (rhs.internal < lhs.internal)
    return false;
  return false;
}
template <typename StructPtrType>
DecoderStatusPtr DecoderStatus::Clone() const {
  return New(
      mojo::Clone(internal)
  );
}

template <typename T, DecoderStatus::EnableIfSame<T>*>
bool DecoderStatus::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->internal, other_struct.internal))
    return false;
  return true;
}

template <typename T, DecoderStatus::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.internal < rhs.internal)
    return true;
  if (rhs.internal < lhs.internal)
    return false;
  return false;
}
template <typename StructPtrType>
PipelineStatusPtr PipelineStatus::Clone() const {
  return New(
      mojo::Clone(internal)
  );
}

template <typename T, PipelineStatus::EnableIfSame<T>*>
bool PipelineStatus::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->internal, other_struct.internal))
    return false;
  return true;
}

template <typename T, PipelineStatus::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.internal < rhs.internal)
    return true;
  if (rhs.internal < lhs.internal)
    return false;
  return false;
}


}  // media::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::VideoTransformation::DataView,
                                         ::media::mojom::blink::VideoTransformationPtr> {
  static bool IsNull(const ::media::mojom::blink::VideoTransformationPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::VideoTransformationPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::VideoTransformation::rotation) rotation(
      const ::media::mojom::blink::VideoTransformationPtr& input) {
    return input->rotation;
  }

  static decltype(::media::mojom::blink::VideoTransformation::mirrored) mirrored(
      const ::media::mojom::blink::VideoTransformationPtr& input) {
    return input->mirrored;
  }

  static bool Read(::media::mojom::blink::VideoTransformation::DataView input, ::media::mojom::blink::VideoTransformationPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::VideoAspectRatio::DataView,
                                         ::media::mojom::blink::VideoAspectRatioPtr> {
  static bool IsNull(const ::media::mojom::blink::VideoAspectRatioPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::VideoAspectRatioPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::VideoAspectRatio::type) type(
      const ::media::mojom::blink::VideoAspectRatioPtr& input) {
    return input->type;
  }

  static decltype(::media::mojom::blink::VideoAspectRatio::value) value(
      const ::media::mojom::blink::VideoAspectRatioPtr& input) {
    return input->value;
  }

  static bool Read(::media::mojom::blink::VideoAspectRatio::DataView input, ::media::mojom::blink::VideoAspectRatioPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::VideoColorSpace::DataView,
                                         ::media::mojom::blink::VideoColorSpacePtr> {
  static bool IsNull(const ::media::mojom::blink::VideoColorSpacePtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::VideoColorSpacePtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::VideoColorSpace::primaries) primaries(
      const ::media::mojom::blink::VideoColorSpacePtr& input) {
    return input->primaries;
  }

  static decltype(::media::mojom::blink::VideoColorSpace::transfer) transfer(
      const ::media::mojom::blink::VideoColorSpacePtr& input) {
    return input->transfer;
  }

  static decltype(::media::mojom::blink::VideoColorSpace::matrix) matrix(
      const ::media::mojom::blink::VideoColorSpacePtr& input) {
    return input->matrix;
  }

  static decltype(::media::mojom::blink::VideoColorSpace::range) range(
      const ::media::mojom::blink::VideoColorSpacePtr& input) {
    return input->range;
  }

  static bool Read(::media::mojom::blink::VideoColorSpace::DataView input, ::media::mojom::blink::VideoColorSpacePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::AudioDecoderConfig::DataView,
                                         ::media::mojom::blink::AudioDecoderConfigPtr> {
  static bool IsNull(const ::media::mojom::blink::AudioDecoderConfigPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::AudioDecoderConfigPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::AudioDecoderConfig::codec) codec(
      const ::media::mojom::blink::AudioDecoderConfigPtr& input) {
    return input->codec;
  }

  static decltype(::media::mojom::blink::AudioDecoderConfig::sample_format) sample_format(
      const ::media::mojom::blink::AudioDecoderConfigPtr& input) {
    return input->sample_format;
  }

  static decltype(::media::mojom::blink::AudioDecoderConfig::channel_layout) channel_layout(
      const ::media::mojom::blink::AudioDecoderConfigPtr& input) {
    return input->channel_layout;
  }

  static decltype(::media::mojom::blink::AudioDecoderConfig::samples_per_second) samples_per_second(
      const ::media::mojom::blink::AudioDecoderConfigPtr& input) {
    return input->samples_per_second;
  }

  static const decltype(::media::mojom::blink::AudioDecoderConfig::extra_data)& extra_data(
      const ::media::mojom::blink::AudioDecoderConfigPtr& input) {
    return input->extra_data;
  }

  static decltype(::media::mojom::blink::AudioDecoderConfig::encryption_scheme) encryption_scheme(
      const ::media::mojom::blink::AudioDecoderConfigPtr& input) {
    return input->encryption_scheme;
  }

  static const decltype(::media::mojom::blink::AudioDecoderConfig::seek_preroll)& seek_preroll(
      const ::media::mojom::blink::AudioDecoderConfigPtr& input) {
    return input->seek_preroll;
  }

  static decltype(::media::mojom::blink::AudioDecoderConfig::codec_delay) codec_delay(
      const ::media::mojom::blink::AudioDecoderConfigPtr& input) {
    return input->codec_delay;
  }

  static decltype(::media::mojom::blink::AudioDecoderConfig::profile) profile(
      const ::media::mojom::blink::AudioDecoderConfigPtr& input) {
    return input->profile;
  }

  static decltype(::media::mojom::blink::AudioDecoderConfig::target_output_channel_layout) target_output_channel_layout(
      const ::media::mojom::blink::AudioDecoderConfigPtr& input) {
    return input->target_output_channel_layout;
  }

  static decltype(::media::mojom::blink::AudioDecoderConfig::target_output_sample_format) target_output_sample_format(
      const ::media::mojom::blink::AudioDecoderConfigPtr& input) {
    return input->target_output_sample_format;
  }

  static decltype(::media::mojom::blink::AudioDecoderConfig::should_discard_decoder_delay) should_discard_decoder_delay(
      const ::media::mojom::blink::AudioDecoderConfigPtr& input) {
    return input->should_discard_decoder_delay;
  }

  static const decltype(::media::mojom::blink::AudioDecoderConfig::aac_extra_data)& aac_extra_data(
      const ::media::mojom::blink::AudioDecoderConfigPtr& input) {
    return input->aac_extra_data;
  }

  static bool Read(::media::mojom::blink::AudioDecoderConfig::DataView input, ::media::mojom::blink::AudioDecoderConfigPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::VideoDecoderConfig::DataView,
                                         ::media::mojom::blink::VideoDecoderConfigPtr> {
  static bool IsNull(const ::media::mojom::blink::VideoDecoderConfigPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::VideoDecoderConfigPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::VideoDecoderConfig::codec) codec(
      const ::media::mojom::blink::VideoDecoderConfigPtr& input) {
    return input->codec;
  }

  static decltype(::media::mojom::blink::VideoDecoderConfig::profile) profile(
      const ::media::mojom::blink::VideoDecoderConfigPtr& input) {
    return input->profile;
  }

  static decltype(::media::mojom::blink::VideoDecoderConfig::level) level(
      const ::media::mojom::blink::VideoDecoderConfigPtr& input) {
    return input->level;
  }

  static decltype(::media::mojom::blink::VideoDecoderConfig::has_alpha) has_alpha(
      const ::media::mojom::blink::VideoDecoderConfigPtr& input) {
    return input->has_alpha;
  }

  static const decltype(::media::mojom::blink::VideoDecoderConfig::transformation)& transformation(
      const ::media::mojom::blink::VideoDecoderConfigPtr& input) {
    return input->transformation;
  }

  static const decltype(::media::mojom::blink::VideoDecoderConfig::coded_size)& coded_size(
      const ::media::mojom::blink::VideoDecoderConfigPtr& input) {
    return input->coded_size;
  }

  static const decltype(::media::mojom::blink::VideoDecoderConfig::visible_rect)& visible_rect(
      const ::media::mojom::blink::VideoDecoderConfigPtr& input) {
    return input->visible_rect;
  }

  static const decltype(::media::mojom::blink::VideoDecoderConfig::natural_size)& natural_size(
      const ::media::mojom::blink::VideoDecoderConfigPtr& input) {
    return input->natural_size;
  }

  static const decltype(::media::mojom::blink::VideoDecoderConfig::aspect_ratio)& aspect_ratio(
      const ::media::mojom::blink::VideoDecoderConfigPtr& input) {
    return input->aspect_ratio;
  }

  static const decltype(::media::mojom::blink::VideoDecoderConfig::extra_data)& extra_data(
      const ::media::mojom::blink::VideoDecoderConfigPtr& input) {
    return input->extra_data;
  }

  static decltype(::media::mojom::blink::VideoDecoderConfig::encryption_scheme) encryption_scheme(
      const ::media::mojom::blink::VideoDecoderConfigPtr& input) {
    return input->encryption_scheme;
  }

  static const decltype(::media::mojom::blink::VideoDecoderConfig::color_space_info)& color_space_info(
      const ::media::mojom::blink::VideoDecoderConfigPtr& input) {
    return input->color_space_info;
  }

  static const decltype(::media::mojom::blink::VideoDecoderConfig::hdr_metadata)& hdr_metadata(
      const ::media::mojom::blink::VideoDecoderConfigPtr& input) {
    return input->hdr_metadata;
  }

  static bool Read(::media::mojom::blink::VideoDecoderConfig::DataView input, ::media::mojom::blink::VideoDecoderConfigPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::DecryptConfig::DataView,
                                         ::media::mojom::blink::DecryptConfigPtr> {
  static bool IsNull(const ::media::mojom::blink::DecryptConfigPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::DecryptConfigPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::DecryptConfig::encryption_scheme) encryption_scheme(
      const ::media::mojom::blink::DecryptConfigPtr& input) {
    return input->encryption_scheme;
  }

  static const decltype(::media::mojom::blink::DecryptConfig::key_id)& key_id(
      const ::media::mojom::blink::DecryptConfigPtr& input) {
    return input->key_id;
  }

  static const decltype(::media::mojom::blink::DecryptConfig::iv)& iv(
      const ::media::mojom::blink::DecryptConfigPtr& input) {
    return input->iv;
  }

  static const decltype(::media::mojom::blink::DecryptConfig::subsamples)& subsamples(
      const ::media::mojom::blink::DecryptConfigPtr& input) {
    return input->subsamples;
  }

  static const decltype(::media::mojom::blink::DecryptConfig::encryption_pattern)& encryption_pattern(
      const ::media::mojom::blink::DecryptConfigPtr& input) {
    return input->encryption_pattern;
  }

  static bool Read(::media::mojom::blink::DecryptConfig::DataView input, ::media::mojom::blink::DecryptConfigPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::DecoderBufferSideData::DataView,
                                         ::media::mojom::blink::DecoderBufferSideDataPtr> {
  static bool IsNull(const ::media::mojom::blink::DecoderBufferSideDataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::DecoderBufferSideDataPtr* output) { output->reset(); }

  static const decltype(::media::mojom::blink::DecoderBufferSideData::spatial_layers)& spatial_layers(
      const ::media::mojom::blink::DecoderBufferSideDataPtr& input) {
    return input->spatial_layers;
  }

  static const decltype(::media::mojom::blink::DecoderBufferSideData::alpha_data)& alpha_data(
      const ::media::mojom::blink::DecoderBufferSideDataPtr& input) {
    return input->alpha_data;
  }

  static decltype(::media::mojom::blink::DecoderBufferSideData::secure_handle) secure_handle(
      const ::media::mojom::blink::DecoderBufferSideDataPtr& input) {
    return input->secure_handle;
  }

  static const decltype(::media::mojom::blink::DecoderBufferSideData::front_discard)& front_discard(
      const ::media::mojom::blink::DecoderBufferSideDataPtr& input) {
    return input->front_discard;
  }

  static const decltype(::media::mojom::blink::DecoderBufferSideData::back_discard)& back_discard(
      const ::media::mojom::blink::DecoderBufferSideDataPtr& input) {
    return input->back_discard;
  }

  static bool Read(::media::mojom::blink::DecoderBufferSideData::DataView input, ::media::mojom::blink::DecoderBufferSideDataPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::DataDecoderBuffer::DataView,
                                         ::media::mojom::blink::DataDecoderBufferPtr> {
  static bool IsNull(const ::media::mojom::blink::DataDecoderBufferPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::DataDecoderBufferPtr* output) { output->reset(); }

  static const decltype(::media::mojom::blink::DataDecoderBuffer::timestamp)& timestamp(
      const ::media::mojom::blink::DataDecoderBufferPtr& input) {
    return input->timestamp;
  }

  static const decltype(::media::mojom::blink::DataDecoderBuffer::duration)& duration(
      const ::media::mojom::blink::DataDecoderBufferPtr& input) {
    return input->duration;
  }

  static decltype(::media::mojom::blink::DataDecoderBuffer::data_size) data_size(
      const ::media::mojom::blink::DataDecoderBufferPtr& input) {
    return input->data_size;
  }

  static decltype(::media::mojom::blink::DataDecoderBuffer::is_key_frame) is_key_frame(
      const ::media::mojom::blink::DataDecoderBufferPtr& input) {
    return input->is_key_frame;
  }

  static const decltype(::media::mojom::blink::DataDecoderBuffer::decrypt_config)& decrypt_config(
      const ::media::mojom::blink::DataDecoderBufferPtr& input) {
    return input->decrypt_config;
  }

  static const decltype(::media::mojom::blink::DataDecoderBuffer::side_data)& side_data(
      const ::media::mojom::blink::DataDecoderBufferPtr& input) {
    return input->side_data;
  }

  static bool Read(::media::mojom::blink::DataDecoderBuffer::DataView input, ::media::mojom::blink::DataDecoderBufferPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::EosDecoderBuffer::DataView,
                                         ::media::mojom::blink::EosDecoderBufferPtr> {
  static bool IsNull(const ::media::mojom::blink::EosDecoderBufferPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::EosDecoderBufferPtr* output) { output->reset(); }

  static const decltype(::media::mojom::blink::EosDecoderBuffer::next_config)& next_config(
      const ::media::mojom::blink::EosDecoderBufferPtr& input) {
    return input->next_config;
  }

  static bool Read(::media::mojom::blink::EosDecoderBuffer::DataView input, ::media::mojom::blink::EosDecoderBufferPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::AudioBuffer::DataView,
                                         ::media::mojom::blink::AudioBufferPtr> {
  static bool IsNull(const ::media::mojom::blink::AudioBufferPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::AudioBufferPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::AudioBuffer::sample_format) sample_format(
      const ::media::mojom::blink::AudioBufferPtr& input) {
    return input->sample_format;
  }

  static decltype(::media::mojom::blink::AudioBuffer::channel_layout) channel_layout(
      const ::media::mojom::blink::AudioBufferPtr& input) {
    return input->channel_layout;
  }

  static decltype(::media::mojom::blink::AudioBuffer::channel_count) channel_count(
      const ::media::mojom::blink::AudioBufferPtr& input) {
    return input->channel_count;
  }

  static decltype(::media::mojom::blink::AudioBuffer::sample_rate) sample_rate(
      const ::media::mojom::blink::AudioBufferPtr& input) {
    return input->sample_rate;
  }

  static decltype(::media::mojom::blink::AudioBuffer::frame_count) frame_count(
      const ::media::mojom::blink::AudioBufferPtr& input) {
    return input->frame_count;
  }

  static decltype(::media::mojom::blink::AudioBuffer::end_of_stream) end_of_stream(
      const ::media::mojom::blink::AudioBufferPtr& input) {
    return input->end_of_stream;
  }

  static const decltype(::media::mojom::blink::AudioBuffer::timestamp)& timestamp(
      const ::media::mojom::blink::AudioBufferPtr& input) {
    return input->timestamp;
  }

  static const decltype(::media::mojom::blink::AudioBuffer::data)& data(
      const ::media::mojom::blink::AudioBufferPtr& input) {
    return input->data;
  }

  static bool Read(::media::mojom::blink::AudioBuffer::DataView input, ::media::mojom::blink::AudioBufferPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::VideoFrameMetadata::DataView,
                                         ::media::mojom::blink::VideoFrameMetadataPtr> {
  static bool IsNull(const ::media::mojom::blink::VideoFrameMetadataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::VideoFrameMetadataPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::VideoFrameMetadata::allow_overlay) allow_overlay(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->allow_overlay;
  }

  static const decltype(::media::mojom::blink::VideoFrameMetadata::capture_begin_time)& capture_begin_time(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->capture_begin_time;
  }

  static const decltype(::media::mojom::blink::VideoFrameMetadata::capture_end_time)& capture_end_time(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->capture_end_time;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::has_capture_counter) has_capture_counter(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->has_capture_counter;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::capture_counter) capture_counter(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->capture_counter;
  }

  static const decltype(::media::mojom::blink::VideoFrameMetadata::capture_update_rect)& capture_update_rect(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->capture_update_rect;
  }

  static const decltype(::media::mojom::blink::VideoFrameMetadata::source_size)& source_size(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->source_size;
  }

  static const decltype(::media::mojom::blink::VideoFrameMetadata::region_capture_rect)& region_capture_rect(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->region_capture_rect;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::sub_capture_target_version) sub_capture_target_version(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->sub_capture_target_version;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::copy_required) copy_required(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->copy_required;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::end_of_stream) end_of_stream(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->end_of_stream;
  }

  static const decltype(::media::mojom::blink::VideoFrameMetadata::frame_duration)& frame_duration(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->frame_duration;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::has_frame_rate) has_frame_rate(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->has_frame_rate;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::frame_rate) frame_rate(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->frame_rate;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::interactive_content) interactive_content(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->interactive_content;
  }

  static const decltype(::media::mojom::blink::VideoFrameMetadata::reference_time)& reference_time(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->reference_time;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::read_lock_fences_enabled) read_lock_fences_enabled(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->read_lock_fences_enabled;
  }

  static const decltype(::media::mojom::blink::VideoFrameMetadata::transformation)& transformation(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->transformation;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::texture_owner) texture_owner(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->texture_owner;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::wants_promotion_hint) wants_promotion_hint(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->wants_promotion_hint;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::protected_video) protected_video(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->protected_video;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::hw_protected) hw_protected(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->hw_protected;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::needs_detiling) needs_detiling(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->needs_detiling;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::is_webgpu_compatible) is_webgpu_compatible(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->is_webgpu_compatible;
  }

  static const decltype(::media::mojom::blink::VideoFrameMetadata::tracking_token)& tracking_token(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->tracking_token;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::power_efficient) power_efficient(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->power_efficient;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::has_device_scale_factor) has_device_scale_factor(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->has_device_scale_factor;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::device_scale_factor) device_scale_factor(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->device_scale_factor;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::has_page_scale_factor) has_page_scale_factor(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->has_page_scale_factor;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::page_scale_factor) page_scale_factor(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->page_scale_factor;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::has_root_scroll_offset_x) has_root_scroll_offset_x(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->has_root_scroll_offset_x;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::root_scroll_offset_x) root_scroll_offset_x(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->root_scroll_offset_x;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::has_root_scroll_offset_y) has_root_scroll_offset_y(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->has_root_scroll_offset_y;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::root_scroll_offset_y) root_scroll_offset_y(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->root_scroll_offset_y;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::has_top_controls_visible_height) has_top_controls_visible_height(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->has_top_controls_visible_height;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::top_controls_visible_height) top_controls_visible_height(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->top_controls_visible_height;
  }

  static const decltype(::media::mojom::blink::VideoFrameMetadata::decode_begin_time)& decode_begin_time(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->decode_begin_time;
  }

  static const decltype(::media::mojom::blink::VideoFrameMetadata::decode_end_time)& decode_end_time(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->decode_end_time;
  }

  static const decltype(::media::mojom::blink::VideoFrameMetadata::processing_time)& processing_time(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->processing_time;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::has_rtp_timestamp) has_rtp_timestamp(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->has_rtp_timestamp;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::rtp_timestamp) rtp_timestamp(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->rtp_timestamp;
  }

  static const decltype(::media::mojom::blink::VideoFrameMetadata::receive_time)& receive_time(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->receive_time;
  }

  static const decltype(::media::mojom::blink::VideoFrameMetadata::wallclock_frame_duration)& wallclock_frame_duration(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->wallclock_frame_duration;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::frame_sequence) frame_sequence(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->frame_sequence;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::source_id) source_id(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->source_id;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::background_blur) background_blur(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->background_blur;
  }

  static bool Read(::media::mojom::blink::VideoFrameMetadata::DataView input, ::media::mojom::blink::VideoFrameMetadataPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::VideoFrame::DataView,
                                         ::media::mojom::blink::VideoFramePtr> {
  static bool IsNull(const ::media::mojom::blink::VideoFramePtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::VideoFramePtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::VideoFrame::format) format(
      const ::media::mojom::blink::VideoFramePtr& input) {
    return input->format;
  }

  static const decltype(::media::mojom::blink::VideoFrame::coded_size)& coded_size(
      const ::media::mojom::blink::VideoFramePtr& input) {
    return input->coded_size;
  }

  static const decltype(::media::mojom::blink::VideoFrame::visible_rect)& visible_rect(
      const ::media::mojom::blink::VideoFramePtr& input) {
    return input->visible_rect;
  }

  static const decltype(::media::mojom::blink::VideoFrame::natural_size)& natural_size(
      const ::media::mojom::blink::VideoFramePtr& input) {
    return input->natural_size;
  }

  static const decltype(::media::mojom::blink::VideoFrame::timestamp)& timestamp(
      const ::media::mojom::blink::VideoFramePtr& input) {
    return input->timestamp;
  }

  static  decltype(::media::mojom::blink::VideoFrame::data)& data(
       ::media::mojom::blink::VideoFramePtr& input) {
    return input->data;
  }

  static const decltype(::media::mojom::blink::VideoFrame::metadata)& metadata(
      const ::media::mojom::blink::VideoFramePtr& input) {
    return input->metadata;
  }

  static const decltype(::media::mojom::blink::VideoFrame::color_space)& color_space(
      const ::media::mojom::blink::VideoFramePtr& input) {
    return input->color_space;
  }

  static const decltype(::media::mojom::blink::VideoFrame::hdr_metadata)& hdr_metadata(
      const ::media::mojom::blink::VideoFramePtr& input) {
    return input->hdr_metadata;
  }

  static bool Read(::media::mojom::blink::VideoFrame::DataView input, ::media::mojom::blink::VideoFramePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::EosVideoFrameData::DataView,
                                         ::media::mojom::blink::EosVideoFrameDataPtr> {
  static bool IsNull(const ::media::mojom::blink::EosVideoFrameDataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::EosVideoFrameDataPtr* output) { output->reset(); }

  static bool Read(::media::mojom::blink::EosVideoFrameData::DataView input, ::media::mojom::blink::EosVideoFrameDataPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::SharedMemoryVideoFrameData::DataView,
                                         ::media::mojom::blink::SharedMemoryVideoFrameDataPtr> {
  static bool IsNull(const ::media::mojom::blink::SharedMemoryVideoFrameDataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::SharedMemoryVideoFrameDataPtr* output) { output->reset(); }

  static  decltype(::media::mojom::blink::SharedMemoryVideoFrameData::frame_data)& frame_data(
       ::media::mojom::blink::SharedMemoryVideoFrameDataPtr& input) {
    return input->frame_data;
  }

  static const decltype(::media::mojom::blink::SharedMemoryVideoFrameData::strides)& strides(
      const ::media::mojom::blink::SharedMemoryVideoFrameDataPtr& input) {
    return input->strides;
  }

  static const decltype(::media::mojom::blink::SharedMemoryVideoFrameData::offsets)& offsets(
      const ::media::mojom::blink::SharedMemoryVideoFrameDataPtr& input) {
    return input->offsets;
  }

  static bool Read(::media::mojom::blink::SharedMemoryVideoFrameData::DataView input, ::media::mojom::blink::SharedMemoryVideoFrameDataPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::GpuMemoryBufferSharedImageVideoFrameData::DataView,
                                         ::media::mojom::blink::GpuMemoryBufferSharedImageVideoFrameDataPtr> {
  static bool IsNull(const ::media::mojom::blink::GpuMemoryBufferSharedImageVideoFrameDataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::GpuMemoryBufferSharedImageVideoFrameDataPtr* output) { output->reset(); }

  static  decltype(::media::mojom::blink::GpuMemoryBufferSharedImageVideoFrameData::gpu_memory_buffer_handle)& gpu_memory_buffer_handle(
       ::media::mojom::blink::GpuMemoryBufferSharedImageVideoFrameDataPtr& input) {
    return input->gpu_memory_buffer_handle;
  }

  static const decltype(::media::mojom::blink::GpuMemoryBufferSharedImageVideoFrameData::shared_image)& shared_image(
      const ::media::mojom::blink::GpuMemoryBufferSharedImageVideoFrameDataPtr& input) {
    return input->shared_image;
  }

  static const decltype(::media::mojom::blink::GpuMemoryBufferSharedImageVideoFrameData::sync_token)& sync_token(
      const ::media::mojom::blink::GpuMemoryBufferSharedImageVideoFrameDataPtr& input) {
    return input->sync_token;
  }

  static bool Read(::media::mojom::blink::GpuMemoryBufferSharedImageVideoFrameData::DataView input, ::media::mojom::blink::GpuMemoryBufferSharedImageVideoFrameDataPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::SharedImageVideoFrameData::DataView,
                                         ::media::mojom::blink::SharedImageVideoFrameDataPtr> {
  static bool IsNull(const ::media::mojom::blink::SharedImageVideoFrameDataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::SharedImageVideoFrameDataPtr* output) { output->reset(); }

  static const decltype(::media::mojom::blink::SharedImageVideoFrameData::shared_image)& shared_image(
      const ::media::mojom::blink::SharedImageVideoFrameDataPtr& input) {
    return input->shared_image;
  }

  static const decltype(::media::mojom::blink::SharedImageVideoFrameData::sync_token)& sync_token(
      const ::media::mojom::blink::SharedImageVideoFrameDataPtr& input) {
    return input->sync_token;
  }

  static const decltype(::media::mojom::blink::SharedImageVideoFrameData::ycbcr_data)& ycbcr_data(
      const ::media::mojom::blink::SharedImageVideoFrameDataPtr& input) {
    return input->ycbcr_data;
  }

  static bool Read(::media::mojom::blink::SharedImageVideoFrameData::DataView input, ::media::mojom::blink::SharedImageVideoFrameDataPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::OpaqueVideoFrameData::DataView,
                                         ::media::mojom::blink::OpaqueVideoFrameDataPtr> {
  static bool IsNull(const ::media::mojom::blink::OpaqueVideoFrameDataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::OpaqueVideoFrameDataPtr* output) { output->reset(); }

  static bool Read(::media::mojom::blink::OpaqueVideoFrameData::DataView input, ::media::mojom::blink::OpaqueVideoFrameDataPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::PipelineStatistics::DataView,
                                         ::media::mojom::blink::PipelineStatisticsPtr> {
  static bool IsNull(const ::media::mojom::blink::PipelineStatisticsPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::PipelineStatisticsPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::PipelineStatistics::audio_bytes_decoded) audio_bytes_decoded(
      const ::media::mojom::blink::PipelineStatisticsPtr& input) {
    return input->audio_bytes_decoded;
  }

  static decltype(::media::mojom::blink::PipelineStatistics::video_bytes_decoded) video_bytes_decoded(
      const ::media::mojom::blink::PipelineStatisticsPtr& input) {
    return input->video_bytes_decoded;
  }

  static decltype(::media::mojom::blink::PipelineStatistics::video_frames_decoded) video_frames_decoded(
      const ::media::mojom::blink::PipelineStatisticsPtr& input) {
    return input->video_frames_decoded;
  }

  static decltype(::media::mojom::blink::PipelineStatistics::video_frames_dropped) video_frames_dropped(
      const ::media::mojom::blink::PipelineStatisticsPtr& input) {
    return input->video_frames_dropped;
  }

  static decltype(::media::mojom::blink::PipelineStatistics::audio_memory_usage) audio_memory_usage(
      const ::media::mojom::blink::PipelineStatisticsPtr& input) {
    return input->audio_memory_usage;
  }

  static decltype(::media::mojom::blink::PipelineStatistics::video_memory_usage) video_memory_usage(
      const ::media::mojom::blink::PipelineStatisticsPtr& input) {
    return input->video_memory_usage;
  }

  static bool Read(::media::mojom::blink::PipelineStatistics::DataView input, ::media::mojom::blink::PipelineStatisticsPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::PredictionFeatures::DataView,
                                         ::media::mojom::blink::PredictionFeaturesPtr> {
  static bool IsNull(const ::media::mojom::blink::PredictionFeaturesPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::PredictionFeaturesPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::PredictionFeatures::profile) profile(
      const ::media::mojom::blink::PredictionFeaturesPtr& input) {
    return input->profile;
  }

  static const decltype(::media::mojom::blink::PredictionFeatures::video_size)& video_size(
      const ::media::mojom::blink::PredictionFeaturesPtr& input) {
    return input->video_size;
  }

  static decltype(::media::mojom::blink::PredictionFeatures::frames_per_sec) frames_per_sec(
      const ::media::mojom::blink::PredictionFeaturesPtr& input) {
    return input->frames_per_sec;
  }

  static const decltype(::media::mojom::blink::PredictionFeatures::key_system)& key_system(
      const ::media::mojom::blink::PredictionFeaturesPtr& input) {
    return input->key_system;
  }

  static decltype(::media::mojom::blink::PredictionFeatures::use_hw_secure_codecs) use_hw_secure_codecs(
      const ::media::mojom::blink::PredictionFeaturesPtr& input) {
    return input->use_hw_secure_codecs;
  }

  static bool Read(::media::mojom::blink::PredictionFeatures::DataView input, ::media::mojom::blink::PredictionFeaturesPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::PredictionTargets::DataView,
                                         ::media::mojom::blink::PredictionTargetsPtr> {
  static bool IsNull(const ::media::mojom::blink::PredictionTargetsPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::PredictionTargetsPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::PredictionTargets::frames_decoded) frames_decoded(
      const ::media::mojom::blink::PredictionTargetsPtr& input) {
    return input->frames_decoded;
  }

  static decltype(::media::mojom::blink::PredictionTargets::frames_dropped) frames_dropped(
      const ::media::mojom::blink::PredictionTargetsPtr& input) {
    return input->frames_dropped;
  }

  static decltype(::media::mojom::blink::PredictionTargets::frames_power_efficient) frames_power_efficient(
      const ::media::mojom::blink::PredictionTargetsPtr& input) {
    return input->frames_power_efficient;
  }

  static bool Read(::media::mojom::blink::PredictionTargets::DataView input, ::media::mojom::blink::PredictionTargetsPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::AudioPipelineInfo::DataView,
                                         ::media::mojom::blink::AudioPipelineInfoPtr> {
  static bool IsNull(const ::media::mojom::blink::AudioPipelineInfoPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::AudioPipelineInfoPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::AudioPipelineInfo::decoder_type) decoder_type(
      const ::media::mojom::blink::AudioPipelineInfoPtr& input) {
    return input->decoder_type;
  }

  static decltype(::media::mojom::blink::AudioPipelineInfo::is_platform_decoder) is_platform_decoder(
      const ::media::mojom::blink::AudioPipelineInfoPtr& input) {
    return input->is_platform_decoder;
  }

  static decltype(::media::mojom::blink::AudioPipelineInfo::has_decrypting_demuxer_stream) has_decrypting_demuxer_stream(
      const ::media::mojom::blink::AudioPipelineInfoPtr& input) {
    return input->has_decrypting_demuxer_stream;
  }

  static decltype(::media::mojom::blink::AudioPipelineInfo::encryption_type) encryption_type(
      const ::media::mojom::blink::AudioPipelineInfoPtr& input) {
    return input->encryption_type;
  }

  static bool Read(::media::mojom::blink::AudioPipelineInfo::DataView input, ::media::mojom::blink::AudioPipelineInfoPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::VideoPipelineInfo::DataView,
                                         ::media::mojom::blink::VideoPipelineInfoPtr> {
  static bool IsNull(const ::media::mojom::blink::VideoPipelineInfoPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::VideoPipelineInfoPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::VideoPipelineInfo::decoder_type) decoder_type(
      const ::media::mojom::blink::VideoPipelineInfoPtr& input) {
    return input->decoder_type;
  }

  static decltype(::media::mojom::blink::VideoPipelineInfo::is_platform_decoder) is_platform_decoder(
      const ::media::mojom::blink::VideoPipelineInfoPtr& input) {
    return input->is_platform_decoder;
  }

  static decltype(::media::mojom::blink::VideoPipelineInfo::has_decrypting_demuxer_stream) has_decrypting_demuxer_stream(
      const ::media::mojom::blink::VideoPipelineInfoPtr& input) {
    return input->has_decrypting_demuxer_stream;
  }

  static decltype(::media::mojom::blink::VideoPipelineInfo::encryption_type) encryption_type(
      const ::media::mojom::blink::VideoPipelineInfoPtr& input) {
    return input->encryption_type;
  }

  static bool Read(::media::mojom::blink::VideoPipelineInfo::DataView input, ::media::mojom::blink::VideoPipelineInfoPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::StatusData::DataView,
                                         ::media::mojom::blink::StatusDataPtr> {
  static bool IsNull(const ::media::mojom::blink::StatusDataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::StatusDataPtr* output) { output->reset(); }

  static const decltype(::media::mojom::blink::StatusData::group)& group(
      const ::media::mojom::blink::StatusDataPtr& input) {
    return input->group;
  }

  static decltype(::media::mojom::blink::StatusData::code) code(
      const ::media::mojom::blink::StatusDataPtr& input) {
    return input->code;
  }

  static const decltype(::media::mojom::blink::StatusData::message)& message(
      const ::media::mojom::blink::StatusDataPtr& input) {
    return input->message;
  }

  static const decltype(::media::mojom::blink::StatusData::frames)& frames(
      const ::media::mojom::blink::StatusDataPtr& input) {
    return input->frames;
  }

  static const decltype(::media::mojom::blink::StatusData::cause)& cause(
      const ::media::mojom::blink::StatusDataPtr& input) {
    return input->cause;
  }

  static const decltype(::media::mojom::blink::StatusData::data)& data(
      const ::media::mojom::blink::StatusDataPtr& input) {
    return input->data;
  }

  static decltype(::media::mojom::blink::StatusData::packed_root_cause) packed_root_cause(
      const ::media::mojom::blink::StatusDataPtr& input) {
    return input->packed_root_cause;
  }

  static bool Read(::media::mojom::blink::StatusData::DataView input, ::media::mojom::blink::StatusDataPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::EncoderStatus::DataView,
                                         ::media::mojom::blink::EncoderStatusPtr> {
  static bool IsNull(const ::media::mojom::blink::EncoderStatusPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::EncoderStatusPtr* output) { output->reset(); }

  static const decltype(::media::mojom::blink::EncoderStatus::internal)& internal(
      const ::media::mojom::blink::EncoderStatusPtr& input) {
    return input->internal;
  }

  static bool Read(::media::mojom::blink::EncoderStatus::DataView input, ::media::mojom::blink::EncoderStatusPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::DecoderStatus::DataView,
                                         ::media::mojom::blink::DecoderStatusPtr> {
  static bool IsNull(const ::media::mojom::blink::DecoderStatusPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::DecoderStatusPtr* output) { output->reset(); }

  static const decltype(::media::mojom::blink::DecoderStatus::internal)& internal(
      const ::media::mojom::blink::DecoderStatusPtr& input) {
    return input->internal;
  }

  static bool Read(::media::mojom::blink::DecoderStatus::DataView input, ::media::mojom::blink::DecoderStatusPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::PipelineStatus::DataView,
                                         ::media::mojom::blink::PipelineStatusPtr> {
  static bool IsNull(const ::media::mojom::blink::PipelineStatusPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::PipelineStatusPtr* output) { output->reset(); }

  static const decltype(::media::mojom::blink::PipelineStatus::internal)& internal(
      const ::media::mojom::blink::PipelineStatusPtr& input) {
    return input->internal;
  }

  static bool Read(::media::mojom::blink::PipelineStatus::DataView input, ::media::mojom::blink::PipelineStatusPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT UnionTraits<::media::mojom::blink::DecoderBufferSideDataNextConfig::DataView,
                                        ::media::mojom::blink::DecoderBufferSideDataNextConfigPtr> {
  static bool IsNull(const ::media::mojom::blink::DecoderBufferSideDataNextConfigPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::DecoderBufferSideDataNextConfigPtr* output) { output->reset(); }

  static ::media::mojom::blink::DecoderBufferSideDataNextConfig::Tag GetTag(const ::media::mojom::blink::DecoderBufferSideDataNextConfigPtr& input) {
    return input->which();
  }

  static const ::media::mojom::blink::AudioDecoderConfigPtr& next_audio_config(const ::media::mojom::blink::DecoderBufferSideDataNextConfigPtr& input) {
    return input->get_next_audio_config();
  }

  static const ::media::mojom::blink::VideoDecoderConfigPtr& next_video_config(const ::media::mojom::blink::DecoderBufferSideDataNextConfigPtr& input) {
    return input->get_next_video_config();
  }

  static bool Read(::media::mojom::blink::DecoderBufferSideDataNextConfig::DataView input, ::media::mojom::blink::DecoderBufferSideDataNextConfigPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT UnionTraits<::media::mojom::blink::DecoderBuffer::DataView,
                                        ::media::mojom::blink::DecoderBufferPtr> {
  static bool IsNull(const ::media::mojom::blink::DecoderBufferPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::DecoderBufferPtr* output) { output->reset(); }

  static ::media::mojom::blink::DecoderBuffer::Tag GetTag(const ::media::mojom::blink::DecoderBufferPtr& input) {
    return input->which();
  }

  static const ::media::mojom::blink::EosDecoderBufferPtr& eos(const ::media::mojom::blink::DecoderBufferPtr& input) {
    return input->get_eos();
  }

  static const ::media::mojom::blink::DataDecoderBufferPtr& data(const ::media::mojom::blink::DecoderBufferPtr& input) {
    return input->get_data();
  }

  static bool Read(::media::mojom::blink::DecoderBuffer::DataView input, ::media::mojom::blink::DecoderBufferPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT UnionTraits<::media::mojom::blink::VideoFrameData::DataView,
                                        ::media::mojom::blink::VideoFrameDataPtr> {
  static bool IsNull(const ::media::mojom::blink::VideoFrameDataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::VideoFrameDataPtr* output) { output->reset(); }

  static ::media::mojom::blink::VideoFrameData::Tag GetTag(const ::media::mojom::blink::VideoFrameDataPtr& input) {
    return input->which();
  }

  static const ::media::mojom::blink::EosVideoFrameDataPtr& eos_data(const ::media::mojom::blink::VideoFrameDataPtr& input) {
    return input->get_eos_data();
  }

  static  ::media::mojom::blink::SharedMemoryVideoFrameDataPtr& shared_memory_data( ::media::mojom::blink::VideoFrameDataPtr& input) {
    return input->get_shared_memory_data();
  }

  static  ::media::mojom::blink::GpuMemoryBufferSharedImageVideoFrameDataPtr& gpu_memory_buffer_shared_image_data( ::media::mojom::blink::VideoFrameDataPtr& input) {
    return input->get_gpu_memory_buffer_shared_image_data();
  }

  static const ::media::mojom::blink::SharedImageVideoFrameDataPtr& shared_image_data(const ::media::mojom::blink::VideoFrameDataPtr& input) {
    return input->get_shared_image_data();
  }

  static const ::media::mojom::blink::OpaqueVideoFrameDataPtr& opaque_data(const ::media::mojom::blink::VideoFrameDataPtr& input) {
    return input->get_opaque_data();
  }

  static bool Read(::media::mojom::blink::VideoFrameData::DataView input, ::media::mojom::blink::VideoFrameDataPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_MEDIA_TYPES_MOJOM_BLINK_H_