// media/mojo/mojom/speech_recognition_error.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_ERROR_MOJOM_SHARED_H_
#define MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_ERROR_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/speech_recognition_error.mojom-shared-internal.h"
#include "media/mojo/mojom/speech_recognition_error_code.mojom-shared.h"







namespace media::mojom {
class SpeechRecognitionErrorDataView;



}  // media::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::SpeechRecognitionErrorDataView> {
  using Data = ::media::mojom::internal::SpeechRecognitionError_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {


enum class SpeechAudioErrorDetails : int32_t {
  
  kNone = 0,
  
  kNoMic = 1,
  kMinValue = 0,
  kMaxValue = 1,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, SpeechAudioErrorDetails value);
inline bool IsKnownEnumValue(SpeechAudioErrorDetails value) {
  return internal::SpeechAudioErrorDetails_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline SpeechAudioErrorDetails ToKnownEnumValue(SpeechAudioErrorDetails value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return SpeechAudioErrorDetails::kDefaultValue;
}


class SpeechRecognitionErrorDataView {
 public:
  SpeechRecognitionErrorDataView() = default;

  SpeechRecognitionErrorDataView(
      internal::SpeechRecognitionError_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadCode(UserType* output) const {
    auto data_value = data_->code;
    return mojo::internal::Deserialize<::media::mojom::SpeechRecognitionErrorCode>(
        data_value, output);
  }
  ::media::mojom::SpeechRecognitionErrorCode code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::SpeechRecognitionErrorCode>(data_->code));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDetails(UserType* output) const {
    auto data_value = data_->details;
    return mojo::internal::Deserialize<::media::mojom::SpeechAudioErrorDetails>(
        data_value, output);
  }
  SpeechAudioErrorDetails details() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::SpeechAudioErrorDetails>(data_->details));
  }
 private:
  internal::SpeechRecognitionError_Data* data_ = nullptr;
};


}  // media::mojom

namespace std {

template <>
struct hash<::media::mojom::SpeechAudioErrorDetails>
    : public mojo::internal::EnumHashImpl<::media::mojom::SpeechAudioErrorDetails> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::SpeechAudioErrorDetails, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::SpeechAudioErrorDetails, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::SpeechAudioErrorDetails>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::SpeechRecognitionErrorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::SpeechRecognitionErrorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::SpeechRecognitionError_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::media::mojom::SpeechRecognitionErrorCode>(
        Traits::code(input), &fragment->code);
    mojo::internal::Serialize<::media::mojom::SpeechAudioErrorDetails>(
        Traits::details(input), &fragment->details);
  }

  static bool Deserialize(::media::mojom::internal::SpeechRecognitionError_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::SpeechRecognitionErrorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media::mojom {




}  // media::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::SpeechAudioErrorDetails> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::SpeechAudioErrorDetails value);
};

} // namespace perfetto

#endif  // MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_ERROR_MOJOM_SHARED_H_