// media/mojo/mojom/speech_recognition_grammar.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_GRAMMAR_MOJOM_H_
#define MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_GRAMMAR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/speech_recognition_grammar.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/speech_recognition_grammar.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/speech_recognition_grammar.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>








namespace media::mojom {








class  SpeechRecognitionGrammar {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SpeechRecognitionGrammar, T>::value>;
  using DataView = SpeechRecognitionGrammarDataView;
  using Data_ = internal::SpeechRecognitionGrammar_Data;

  template <typename... Args>
  static SpeechRecognitionGrammarPtr New(Args&&... args) {
    return SpeechRecognitionGrammarPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SpeechRecognitionGrammarPtr From(const U& u) {
    return mojo::TypeConverter<SpeechRecognitionGrammarPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SpeechRecognitionGrammar>::Convert(*this);
  }


  SpeechRecognitionGrammar();

  SpeechRecognitionGrammar(
      const ::GURL& url,
      double weight);


  ~SpeechRecognitionGrammar();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SpeechRecognitionGrammarPtr>
  SpeechRecognitionGrammarPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SpeechRecognitionGrammar::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SpeechRecognitionGrammar::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SpeechRecognitionGrammar::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SpeechRecognitionGrammar::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SpeechRecognitionGrammar::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SpeechRecognitionGrammar_UnserializedMessageContext<
            UserType, SpeechRecognitionGrammar::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SpeechRecognitionGrammar::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SpeechRecognitionGrammar::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SpeechRecognitionGrammar_UnserializedMessageContext<
            UserType, SpeechRecognitionGrammar::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SpeechRecognitionGrammar::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL url;
  
  double weight;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SpeechRecognitionGrammar::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SpeechRecognitionGrammar::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SpeechRecognitionGrammar::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SpeechRecognitionGrammar::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SpeechRecognitionGrammarPtr SpeechRecognitionGrammar::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(weight)
  );
}

template <typename T, SpeechRecognitionGrammar::EnableIfSame<T>*>
bool SpeechRecognitionGrammar::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->weight, other_struct.weight))
    return false;
  return true;
}

template <typename T, SpeechRecognitionGrammar::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.weight < rhs.weight)
    return true;
  if (rhs.weight < lhs.weight)
    return false;
  return false;
}


}  // media::mojom

namespace mojo {


template <>
struct  StructTraits<::media::mojom::SpeechRecognitionGrammar::DataView,
                                         ::media::mojom::SpeechRecognitionGrammarPtr> {
  static bool IsNull(const ::media::mojom::SpeechRecognitionGrammarPtr& input) { return !input; }
  static void SetToNull(::media::mojom::SpeechRecognitionGrammarPtr* output) { output->reset(); }

  static const decltype(::media::mojom::SpeechRecognitionGrammar::url)& url(
      const ::media::mojom::SpeechRecognitionGrammarPtr& input) {
    return input->url;
  }

  static decltype(::media::mojom::SpeechRecognitionGrammar::weight) weight(
      const ::media::mojom::SpeechRecognitionGrammarPtr& input) {
    return input->weight;
  }

  static bool Read(::media::mojom::SpeechRecognitionGrammar::DataView input, ::media::mojom::SpeechRecognitionGrammarPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_GRAMMAR_MOJOM_H_