// media/mojo/mojom/video_encode_accelerator.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_VIDEO_ENCODE_ACCELERATOR_MOJOM_BLINK_H_
#define MEDIA_MOJO_MOJOM_VIDEO_ENCODE_ACCELERATOR_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/video_encode_accelerator.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/video_encode_accelerator.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/video_encode_accelerator.mojom-blink-forward.h"  // IWYU pragma: export
#include "media/mojo/mojom/media_log.mojom-blink-forward.h"
#include "media/mojo/mojom/media_types.mojom-blink-forward.h"
#include "media/mojo/mojom/video_encoder_info.mojom-blink-forward.h"
#include "mojo/public/mojom/base/shared_memory.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"
#include "sandbox/policy/mojom/sandbox.mojom-blink-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "ui/gfx/mojom/color_space.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace media::mojom::blink {

class VideoEncodeAcceleratorProviderProxy;

template <typename ImplRefTraits>
class VideoEncodeAcceleratorProviderStub;

class VideoEncodeAcceleratorProviderRequestValidator;
class VideoEncodeAcceleratorProviderResponseValidator;


class BLINK_PLATFORM_EXPORT VideoEncodeAcceleratorProvider
    : public VideoEncodeAcceleratorProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    1401405140
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = VideoEncodeAcceleratorProviderInterfaceBase;
  using Proxy_ = VideoEncodeAcceleratorProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = VideoEncodeAcceleratorProviderStub<ImplRefTraits>;

  using RequestValidator_ = VideoEncodeAcceleratorProviderRequestValidator;
  using ResponseValidator_ = VideoEncodeAcceleratorProviderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateVideoEncodeAcceleratorMinVersion = 0,
    kGetVideoEncodeAcceleratorSupportedProfilesMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateVideoEncodeAccelerator_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetVideoEncodeAcceleratorSupportedProfiles_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~VideoEncodeAcceleratorProvider() = default;

  
  virtual void CreateVideoEncodeAccelerator(EncodeCommandBufferIdPtr command_buffer_id, ::mojo::PendingReceiver<VideoEncodeAccelerator> receiver) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetVideoEncodeAcceleratorSupportedProfiles(WTF::Vector<VideoEncodeAcceleratorSupportedProfilePtr>* out_profiles);

  using GetVideoEncodeAcceleratorSupportedProfilesCallback = base::OnceCallback<void(WTF::Vector<VideoEncodeAcceleratorSupportedProfilePtr>)>;
  
  virtual void GetVideoEncodeAcceleratorSupportedProfiles(GetVideoEncodeAcceleratorSupportedProfilesCallback callback) = 0;
};

class VideoEncodeAcceleratorProviderFactoryProxy;

template <typename ImplRefTraits>
class VideoEncodeAcceleratorProviderFactoryStub;

class VideoEncodeAcceleratorProviderFactoryRequestValidator;


class BLINK_PLATFORM_EXPORT VideoEncodeAcceleratorProviderFactory
    : public VideoEncodeAcceleratorProviderFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kHardwareVideoEncoding;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = VideoEncodeAcceleratorProviderFactoryInterfaceBase;
  using Proxy_ = VideoEncodeAcceleratorProviderFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = VideoEncodeAcceleratorProviderFactoryStub<ImplRefTraits>;

  using RequestValidator_ = VideoEncodeAcceleratorProviderFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateVideoEncodeAcceleratorProviderMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateVideoEncodeAcceleratorProvider_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~VideoEncodeAcceleratorProviderFactory() = default;

  
  virtual void CreateVideoEncodeAcceleratorProvider(::mojo::PendingReceiver<VideoEncodeAcceleratorProvider> receiver) = 0;
};

class VideoEncodeAcceleratorProxy;

template <typename ImplRefTraits>
class VideoEncodeAcceleratorStub;

class VideoEncodeAcceleratorRequestValidator;
class VideoEncodeAcceleratorResponseValidator;


class BLINK_PLATFORM_EXPORT VideoEncodeAccelerator
    : public VideoEncodeAcceleratorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    1487615310, 
    1591161539
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = VideoEncodeAcceleratorInterfaceBase;
  using Proxy_ = VideoEncodeAcceleratorProxy;

  template <typename ImplRefTraits>
  using Stub_ = VideoEncodeAcceleratorStub<ImplRefTraits>;

  using RequestValidator_ = VideoEncodeAcceleratorRequestValidator;
  using ResponseValidator_ = VideoEncodeAcceleratorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kInitializeMinVersion = 0,
    kEncodeMinVersion = 0,
    kUseOutputBitstreamBufferMinVersion = 0,
    kRequestEncodingParametersChangeWithLayersMinVersion = 0,
    kRequestEncodingParametersChangeWithBitrateMinVersion = 0,
    kIsFlushSupportedMinVersion = 0,
    kFlushMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Initialize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Encode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UseOutputBitstreamBuffer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestEncodingParametersChangeWithLayers_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestEncodingParametersChangeWithBitrate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IsFlushSupported_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Flush_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~VideoEncodeAccelerator() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool Initialize(VideoEncodeAcceleratorConfigPtr config, ::mojo::PendingAssociatedRemote<VideoEncodeAcceleratorClient> client, ::mojo::PendingRemote<::media::mojom::blink::MediaLog> media_log, bool* out_result);

  using InitializeCallback = base::OnceCallback<void(bool)>;
  
  virtual void Initialize(VideoEncodeAcceleratorConfigPtr config, ::mojo::PendingAssociatedRemote<VideoEncodeAcceleratorClient> client, ::mojo::PendingRemote<::media::mojom::blink::MediaLog> media_log, InitializeCallback callback) = 0;


  using EncodeCallback = base::OnceCallback<void()>;
  
  virtual void Encode(::media::mojom::blink::VideoFramePtr frame, VideoEncodeOptionsPtr options, EncodeCallback callback) = 0;

  
  virtual void UseOutputBitstreamBuffer(int32_t bitstream_buffer_id, ::base::UnsafeSharedMemoryRegion region) = 0;

  
  virtual void RequestEncodingParametersChangeWithLayers(VideoBitrateAllocationPtr bitrate_allocation, uint32_t framerate, const std::optional<::gfx::Size>& size) = 0;

  
  virtual void RequestEncodingParametersChangeWithBitrate(BitratePtr bitrate, uint32_t framerate, const std::optional<::gfx::Size>& size) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool IsFlushSupported(bool* out_result);

  using IsFlushSupportedCallback = base::OnceCallback<void(bool)>;
  
  virtual void IsFlushSupported(IsFlushSupportedCallback callback) = 0;


  using FlushCallback = base::OnceCallback<void(bool)>;
  
  virtual void Flush(FlushCallback callback) = 0;
};

class VideoEncodeAcceleratorClientProxy;

template <typename ImplRefTraits>
class VideoEncodeAcceleratorClientStub;

class VideoEncodeAcceleratorClientRequestValidator;


class BLINK_PLATFORM_EXPORT VideoEncodeAcceleratorClient
    : public VideoEncodeAcceleratorClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = VideoEncodeAcceleratorClientInterfaceBase;
  using Proxy_ = VideoEncodeAcceleratorClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = VideoEncodeAcceleratorClientStub<ImplRefTraits>;

  using RequestValidator_ = VideoEncodeAcceleratorClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kRequireBitstreamBuffersMinVersion = 0,
    kBitstreamBufferReadyMinVersion = 0,
    kNotifyErrorStatusMinVersion = 0,
    kNotifyEncoderInfoChangeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RequireBitstreamBuffers_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BitstreamBufferReady_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyErrorStatus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyEncoderInfoChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~VideoEncodeAcceleratorClient() = default;

  
  virtual void RequireBitstreamBuffers(uint32_t input_count, const ::gfx::Size& input_coded_size, uint32_t output_buffer_size) = 0;

  
  virtual void BitstreamBufferReady(int32_t bitstream_buffer_id, BitstreamBufferMetadataPtr metadata) = 0;

  
  virtual void NotifyErrorStatus(::media::mojom::blink::EncoderStatusPtr status) = 0;

  
  virtual void NotifyEncoderInfoChange(::media::mojom::blink::VideoEncoderInfoPtr info) = 0;
};



class BLINK_PLATFORM_EXPORT VideoEncodeAcceleratorProviderProxy
    : public VideoEncodeAcceleratorProvider {
 public:
  using InterfaceType = VideoEncodeAcceleratorProvider;

  explicit VideoEncodeAcceleratorProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateVideoEncodeAccelerator(EncodeCommandBufferIdPtr command_buffer_id, ::mojo::PendingReceiver<VideoEncodeAccelerator> receiver) final;
  
  bool GetVideoEncodeAcceleratorSupportedProfiles(WTF::Vector<VideoEncodeAcceleratorSupportedProfilePtr>* out_profiles) final;
  
  void GetVideoEncodeAcceleratorSupportedProfiles(GetVideoEncodeAcceleratorSupportedProfilesCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT VideoEncodeAcceleratorProviderFactoryProxy
    : public VideoEncodeAcceleratorProviderFactory {
 public:
  using InterfaceType = VideoEncodeAcceleratorProviderFactory;

  explicit VideoEncodeAcceleratorProviderFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateVideoEncodeAcceleratorProvider(::mojo::PendingReceiver<VideoEncodeAcceleratorProvider> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT VideoEncodeAcceleratorProxy
    : public VideoEncodeAccelerator {
 public:
  using InterfaceType = VideoEncodeAccelerator;

  explicit VideoEncodeAcceleratorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool Initialize(VideoEncodeAcceleratorConfigPtr config, ::mojo::PendingAssociatedRemote<VideoEncodeAcceleratorClient> client, ::mojo::PendingRemote<::media::mojom::blink::MediaLog> media_log, bool* out_result) final;
  
  void Initialize(VideoEncodeAcceleratorConfigPtr config, ::mojo::PendingAssociatedRemote<VideoEncodeAcceleratorClient> client, ::mojo::PendingRemote<::media::mojom::blink::MediaLog> media_log, InitializeCallback callback) final;
  
  void Encode(::media::mojom::blink::VideoFramePtr frame, VideoEncodeOptionsPtr options, EncodeCallback callback) final;
  
  void UseOutputBitstreamBuffer(int32_t bitstream_buffer_id, ::base::UnsafeSharedMemoryRegion region) final;
  
  void RequestEncodingParametersChangeWithLayers(VideoBitrateAllocationPtr bitrate_allocation, uint32_t framerate, const std::optional<::gfx::Size>& size) final;
  
  void RequestEncodingParametersChangeWithBitrate(BitratePtr bitrate, uint32_t framerate, const std::optional<::gfx::Size>& size) final;
  
  bool IsFlushSupported(bool* out_result) final;
  
  void IsFlushSupported(IsFlushSupportedCallback callback) final;
  
  void Flush(FlushCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT VideoEncodeAcceleratorClientProxy
    : public VideoEncodeAcceleratorClient {
 public:
  using InterfaceType = VideoEncodeAcceleratorClient;

  explicit VideoEncodeAcceleratorClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RequireBitstreamBuffers(uint32_t input_count, const ::gfx::Size& input_coded_size, uint32_t output_buffer_size) final;
  
  void BitstreamBufferReady(int32_t bitstream_buffer_id, BitstreamBufferMetadataPtr metadata) final;
  
  void NotifyErrorStatus(::media::mojom::blink::EncoderStatusPtr status) final;
  
  void NotifyEncoderInfoChange(::media::mojom::blink::VideoEncoderInfoPtr info) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT VideoEncodeAcceleratorProviderStubDispatch {
 public:
  static bool Accept(VideoEncodeAcceleratorProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VideoEncodeAcceleratorProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VideoEncodeAcceleratorProvider>>
class VideoEncodeAcceleratorProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VideoEncodeAcceleratorProviderStub() = default;
  ~VideoEncodeAcceleratorProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoEncodeAcceleratorProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoEncodeAcceleratorProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT VideoEncodeAcceleratorProviderFactoryStubDispatch {
 public:
  static bool Accept(VideoEncodeAcceleratorProviderFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VideoEncodeAcceleratorProviderFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VideoEncodeAcceleratorProviderFactory>>
class VideoEncodeAcceleratorProviderFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VideoEncodeAcceleratorProviderFactoryStub() = default;
  ~VideoEncodeAcceleratorProviderFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoEncodeAcceleratorProviderFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoEncodeAcceleratorProviderFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT VideoEncodeAcceleratorStubDispatch {
 public:
  static bool Accept(VideoEncodeAccelerator* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VideoEncodeAccelerator* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VideoEncodeAccelerator>>
class VideoEncodeAcceleratorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VideoEncodeAcceleratorStub() = default;
  ~VideoEncodeAcceleratorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoEncodeAcceleratorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoEncodeAcceleratorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT VideoEncodeAcceleratorClientStubDispatch {
 public:
  static bool Accept(VideoEncodeAcceleratorClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VideoEncodeAcceleratorClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VideoEncodeAcceleratorClient>>
class VideoEncodeAcceleratorClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VideoEncodeAcceleratorClientStub() = default;
  ~VideoEncodeAcceleratorClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoEncodeAcceleratorClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoEncodeAcceleratorClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT VideoEncodeAcceleratorProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT VideoEncodeAcceleratorProviderFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT VideoEncodeAcceleratorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT VideoEncodeAcceleratorClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT VideoEncodeAcceleratorProviderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT VideoEncodeAcceleratorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};







class BLINK_PLATFORM_EXPORT VariableBitratePeak {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VariableBitratePeak, T>::value>;
  using DataView = VariableBitratePeakDataView;
  using Data_ = internal::VariableBitratePeak_Data;

  template <typename... Args>
  static VariableBitratePeakPtr New(Args&&... args) {
    return VariableBitratePeakPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VariableBitratePeakPtr From(const U& u) {
    return mojo::TypeConverter<VariableBitratePeakPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VariableBitratePeak>::Convert(*this);
  }


  VariableBitratePeak();

  explicit VariableBitratePeak(
      uint32_t bps);


  ~VariableBitratePeak();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VariableBitratePeakPtr>
  VariableBitratePeakPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VariableBitratePeak::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VariableBitratePeak::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VariableBitratePeak::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VariableBitratePeak::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VariableBitratePeak::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VariableBitratePeak_UnserializedMessageContext<
            UserType, VariableBitratePeak::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VariableBitratePeak::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VariableBitratePeak::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VariableBitratePeak_UnserializedMessageContext<
            UserType, VariableBitratePeak::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VariableBitratePeak::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t bps;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VariableBitratePeak::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VariableBitratePeak::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VariableBitratePeak::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VariableBitratePeak::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class BLINK_PLATFORM_EXPORT ConstantBitrate {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ConstantBitrate, T>::value>;
  using DataView = ConstantBitrateDataView;
  using Data_ = internal::ConstantBitrate_Data;

  template <typename... Args>
  static ConstantBitratePtr New(Args&&... args) {
    return ConstantBitratePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ConstantBitratePtr From(const U& u) {
    return mojo::TypeConverter<ConstantBitratePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ConstantBitrate>::Convert(*this);
  }


  ConstantBitrate();

  explicit ConstantBitrate(
      uint32_t target_bps);


  ~ConstantBitrate();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ConstantBitratePtr>
  ConstantBitratePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ConstantBitrate::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ConstantBitrate::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ConstantBitrate::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ConstantBitrate::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ConstantBitrate::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ConstantBitrate_UnserializedMessageContext<
            UserType, ConstantBitrate::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ConstantBitrate::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ConstantBitrate::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ConstantBitrate_UnserializedMessageContext<
            UserType, ConstantBitrate::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ConstantBitrate::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t target_bps;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ConstantBitrate::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ConstantBitrate::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ConstantBitrate::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ConstantBitrate::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT VariableBitrate {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VariableBitrate, T>::value>;
  using DataView = VariableBitrateDataView;
  using Data_ = internal::VariableBitrate_Data;

  template <typename... Args>
  static VariableBitratePtr New(Args&&... args) {
    return VariableBitratePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VariableBitratePtr From(const U& u) {
    return mojo::TypeConverter<VariableBitratePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VariableBitrate>::Convert(*this);
  }


  VariableBitrate();

  VariableBitrate(
      uint32_t target_bps,
      uint32_t peak_bps);


  ~VariableBitrate();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VariableBitratePtr>
  VariableBitratePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VariableBitrate::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VariableBitrate::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VariableBitrate::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VariableBitrate::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VariableBitrate::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VariableBitrate_UnserializedMessageContext<
            UserType, VariableBitrate::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VariableBitrate::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VariableBitrate::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VariableBitrate_UnserializedMessageContext<
            UserType, VariableBitrate::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VariableBitrate::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t target_bps;
  
  uint32_t peak_bps;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VariableBitrate::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VariableBitrate::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VariableBitrate::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VariableBitrate::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT ExternalBitrate {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ExternalBitrate, T>::value>;
  using DataView = ExternalBitrateDataView;
  using Data_ = internal::ExternalBitrate_Data;

  template <typename... Args>
  static ExternalBitratePtr New(Args&&... args) {
    return ExternalBitratePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ExternalBitratePtr From(const U& u) {
    return mojo::TypeConverter<ExternalBitratePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ExternalBitrate>::Convert(*this);
  }


  ExternalBitrate();


  ~ExternalBitrate();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ExternalBitratePtr>
  ExternalBitratePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ExternalBitrate::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ExternalBitrate::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ExternalBitrate::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ExternalBitrate::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ExternalBitrate::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ExternalBitrate_UnserializedMessageContext<
            UserType, ExternalBitrate::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ExternalBitrate::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ExternalBitrate::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ExternalBitrate_UnserializedMessageContext<
            UserType, ExternalBitrate::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ExternalBitrate::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ExternalBitrate::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ExternalBitrate::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ExternalBitrate::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ExternalBitrate::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_PLATFORM_EXPORT VideoEncodeOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoEncodeOptions, T>::value>;
  using DataView = VideoEncodeOptionsDataView;
  using Data_ = internal::VideoEncodeOptions_Data;

  template <typename... Args>
  static VideoEncodeOptionsPtr New(Args&&... args) {
    return VideoEncodeOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoEncodeOptionsPtr From(const U& u) {
    return mojo::TypeConverter<VideoEncodeOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoEncodeOptions>::Convert(*this);
  }


  VideoEncodeOptions();

  VideoEncodeOptions(
      bool force_keyframe,
      int32_t quantizer);


  ~VideoEncodeOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoEncodeOptionsPtr>
  VideoEncodeOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoEncodeOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoEncodeOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoEncodeOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoEncodeOptions::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoEncodeOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoEncodeOptions_UnserializedMessageContext<
            UserType, VideoEncodeOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoEncodeOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoEncodeOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoEncodeOptions_UnserializedMessageContext<
            UserType, VideoEncodeOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoEncodeOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool force_keyframe;
  
  int32_t quantizer;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoEncodeOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoEncodeOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoEncodeOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoEncodeOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT DropFrameMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DropFrameMetadata, T>::value>;
  using DataView = DropFrameMetadataDataView;
  using Data_ = internal::DropFrameMetadata_Data;

  template <typename... Args>
  static DropFrameMetadataPtr New(Args&&... args) {
    return DropFrameMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DropFrameMetadataPtr From(const U& u) {
    return mojo::TypeConverter<DropFrameMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DropFrameMetadata>::Convert(*this);
  }


  DropFrameMetadata();

  DropFrameMetadata(
      uint8_t spatial_idx,
      bool end_of_picture);


  ~DropFrameMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DropFrameMetadataPtr>
  DropFrameMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DropFrameMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DropFrameMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DropFrameMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DropFrameMetadata::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DropFrameMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DropFrameMetadata_UnserializedMessageContext<
            UserType, DropFrameMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DropFrameMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DropFrameMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DropFrameMetadata_UnserializedMessageContext<
            UserType, DropFrameMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DropFrameMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint8_t spatial_idx;
  
  bool end_of_picture;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DropFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DropFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DropFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DropFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT H264Metadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<H264Metadata, T>::value>;
  using DataView = H264MetadataDataView;
  using Data_ = internal::H264Metadata_Data;

  template <typename... Args>
  static H264MetadataPtr New(Args&&... args) {
    return H264MetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static H264MetadataPtr From(const U& u) {
    return mojo::TypeConverter<H264MetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, H264Metadata>::Convert(*this);
  }


  H264Metadata();

  H264Metadata(
      uint8_t temporal_idx,
      bool layer_sync);


  ~H264Metadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = H264MetadataPtr>
  H264MetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, H264Metadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, H264Metadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, H264Metadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        H264Metadata::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        H264Metadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::H264Metadata_UnserializedMessageContext<
            UserType, H264Metadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<H264Metadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return H264Metadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::H264Metadata_UnserializedMessageContext<
            UserType, H264Metadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<H264Metadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint8_t temporal_idx;
  
  bool layer_sync;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, H264Metadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, H264Metadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, H264Metadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, H264Metadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT Vp8Metadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Vp8Metadata, T>::value>;
  using DataView = Vp8MetadataDataView;
  using Data_ = internal::Vp8Metadata_Data;

  template <typename... Args>
  static Vp8MetadataPtr New(Args&&... args) {
    return Vp8MetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static Vp8MetadataPtr From(const U& u) {
    return mojo::TypeConverter<Vp8MetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Vp8Metadata>::Convert(*this);
  }


  Vp8Metadata();

  Vp8Metadata(
      bool non_reference,
      uint8_t temporal_idx,
      bool layer_sync);


  ~Vp8Metadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = Vp8MetadataPtr>
  Vp8MetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Vp8Metadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Vp8Metadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Vp8Metadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Vp8Metadata::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Vp8Metadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Vp8Metadata_UnserializedMessageContext<
            UserType, Vp8Metadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Vp8Metadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Vp8Metadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Vp8Metadata_UnserializedMessageContext<
            UserType, Vp8Metadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Vp8Metadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool non_reference;
  
  uint8_t temporal_idx;
  
  bool layer_sync;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Vp8Metadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Vp8Metadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Vp8Metadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Vp8Metadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class BLINK_PLATFORM_EXPORT Bitrate {
 public:
  using DataView = BitrateDataView;
  using Data_ = internal::Bitrate_Data;
  using Tag = Data_::Bitrate_Tag;

  template <typename... Args>
  static BitratePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }
  // Construct an instance holding |constant|.
  static BitratePtr
  NewConstant(
      ConstantBitratePtr value) {
    auto result = BitratePtr(std::in_place);
    result->set_constant(std::move(value));
    return result;
  }
  // Construct an instance holding |variable|.
  static BitratePtr
  NewVariable(
      VariableBitratePtr value) {
    auto result = BitratePtr(std::in_place);
    result->set_variable(std::move(value));
    return result;
  }
  // Construct an instance holding |external|.
  static BitratePtr
  NewExternal(
      ExternalBitratePtr value) {
    auto result = BitratePtr(std::in_place);
    result->set_external(std::move(value));
    return result;
  }

  template <typename U>
  static BitratePtr From(const U& u) {
    return mojo::TypeConverter<BitratePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Bitrate>::Convert(*this);
  }

  Bitrate();
  ~Bitrate();
  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  Bitrate(const Bitrate& other) = delete;
  Bitrate& operator=(const Bitrate& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = BitratePtr>
  BitratePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, Bitrate>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, Bitrate>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }


  
  bool is_constant() const { return tag_ == Tag::kConstant; }

  
  ConstantBitratePtr& get_constant() const {
    CHECK(tag_ == Tag::kConstant);
    return *(data_.constant);
  }

  
  void set_constant(
      ConstantBitratePtr constant);
  
  bool is_variable() const { return tag_ == Tag::kVariable; }

  
  VariableBitratePtr& get_variable() const {
    CHECK(tag_ == Tag::kVariable);
    return *(data_.variable);
  }

  
  void set_variable(
      VariableBitratePtr variable);
  
  bool is_external() const { return tag_ == Tag::kExternal; }

  
  ExternalBitratePtr& get_external() const {
    CHECK(tag_ == Tag::kExternal);
    return *(data_.external);
  }

  
  void set_external(
      ExternalBitratePtr external);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Bitrate::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<Bitrate::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  union Union_ {
    Union_() = default;
    ~Union_() = default;
    ConstantBitratePtr* constant;
    VariableBitratePtr* variable;
    ExternalBitratePtr* external;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class BLINK_PLATFORM_EXPORT OptionalMetadata {
 public:
  using DataView = OptionalMetadataDataView;
  using Data_ = internal::OptionalMetadata_Data;
  using Tag = Data_::OptionalMetadata_Tag;

  template <typename... Args>
  static OptionalMetadataPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }
  // Construct an instance holding |drop|.
  static OptionalMetadataPtr
  NewDrop(
      DropFrameMetadataPtr value) {
    auto result = OptionalMetadataPtr(std::in_place);
    result->set_drop(std::move(value));
    return result;
  }
  // Construct an instance holding |h264|.
  static OptionalMetadataPtr
  NewH264(
      H264MetadataPtr value) {
    auto result = OptionalMetadataPtr(std::in_place);
    result->set_h264(std::move(value));
    return result;
  }
  // Construct an instance holding |vp8|.
  static OptionalMetadataPtr
  NewVp8(
      Vp8MetadataPtr value) {
    auto result = OptionalMetadataPtr(std::in_place);
    result->set_vp8(std::move(value));
    return result;
  }
  // Construct an instance holding |vp9|.
  static OptionalMetadataPtr
  NewVp9(
      Vp9MetadataPtr value) {
    auto result = OptionalMetadataPtr(std::in_place);
    result->set_vp9(std::move(value));
    return result;
  }

  template <typename U>
  static OptionalMetadataPtr From(const U& u) {
    return mojo::TypeConverter<OptionalMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OptionalMetadata>::Convert(*this);
  }

  OptionalMetadata();
  ~OptionalMetadata();
  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  OptionalMetadata(const OptionalMetadata& other) = delete;
  OptionalMetadata& operator=(const OptionalMetadata& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = OptionalMetadataPtr>
  OptionalMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, OptionalMetadata>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, OptionalMetadata>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }


  
  bool is_drop() const { return tag_ == Tag::kDrop; }

  
  DropFrameMetadataPtr& get_drop() const {
    CHECK(tag_ == Tag::kDrop);
    return *(data_.drop);
  }

  
  void set_drop(
      DropFrameMetadataPtr drop);
  
  bool is_h264() const { return tag_ == Tag::kH264; }

  
  H264MetadataPtr& get_h264() const {
    CHECK(tag_ == Tag::kH264);
    return *(data_.h264);
  }

  
  void set_h264(
      H264MetadataPtr h264);
  
  bool is_vp8() const { return tag_ == Tag::kVp8; }

  
  Vp8MetadataPtr& get_vp8() const {
    CHECK(tag_ == Tag::kVp8);
    return *(data_.vp8);
  }

  
  void set_vp8(
      Vp8MetadataPtr vp8);
  
  bool is_vp9() const { return tag_ == Tag::kVp9; }

  
  Vp9MetadataPtr& get_vp9() const {
    CHECK(tag_ == Tag::kVp9);
    return *(data_.vp9);
  }

  
  void set_vp9(
      Vp9MetadataPtr vp9);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OptionalMetadata::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<OptionalMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  union Union_ {
    Union_() = default;
    ~Union_() = default;
    DropFrameMetadataPtr* drop;
    H264MetadataPtr* h264;
    Vp8MetadataPtr* vp8;
    Vp9MetadataPtr* vp9;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class BLINK_PLATFORM_EXPORT VideoEncodeAcceleratorSupportedProfile {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoEncodeAcceleratorSupportedProfile, T>::value>;
  using DataView = VideoEncodeAcceleratorSupportedProfileDataView;
  using Data_ = internal::VideoEncodeAcceleratorSupportedProfile_Data;

  template <typename... Args>
  static VideoEncodeAcceleratorSupportedProfilePtr New(Args&&... args) {
    return VideoEncodeAcceleratorSupportedProfilePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoEncodeAcceleratorSupportedProfilePtr From(const U& u) {
    return mojo::TypeConverter<VideoEncodeAcceleratorSupportedProfilePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoEncodeAcceleratorSupportedProfile>::Convert(*this);
  }


  VideoEncodeAcceleratorSupportedProfile();

  VideoEncodeAcceleratorSupportedProfile(
      ::media::mojom::blink::VideoCodecProfile profile,
      const ::gfx::Size& min_resolution,
      const ::gfx::Size& max_resolution,
      uint32_t max_framerate_numerator,
      uint32_t max_framerate_denominator,
      WTF::Vector<VideoEncodeAcceleratorSupportedRateControlMode> rate_control_modes,
      WTF::Vector<::media::mojom::blink::SVCScalabilityMode> scalability_modes,
      bool is_software_codec,
      WTF::Vector<::media::mojom::blink::VideoPixelFormat> gpu_supported_pixel_formats,
      bool supports_gpu_shared_images);


  ~VideoEncodeAcceleratorSupportedProfile();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoEncodeAcceleratorSupportedProfilePtr>
  VideoEncodeAcceleratorSupportedProfilePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoEncodeAcceleratorSupportedProfile::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoEncodeAcceleratorSupportedProfile::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoEncodeAcceleratorSupportedProfile::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoEncodeAcceleratorSupportedProfile::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoEncodeAcceleratorSupportedProfile::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoEncodeAcceleratorSupportedProfile_UnserializedMessageContext<
            UserType, VideoEncodeAcceleratorSupportedProfile::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoEncodeAcceleratorSupportedProfile::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoEncodeAcceleratorSupportedProfile::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoEncodeAcceleratorSupportedProfile_UnserializedMessageContext<
            UserType, VideoEncodeAcceleratorSupportedProfile::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoEncodeAcceleratorSupportedProfile::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::media::mojom::blink::VideoCodecProfile profile;
  
  ::gfx::Size min_resolution;
  
  ::gfx::Size max_resolution;
  
  uint32_t max_framerate_numerator;
  
  uint32_t max_framerate_denominator;
  
  WTF::Vector<VideoEncodeAcceleratorSupportedRateControlMode> rate_control_modes;
  
  WTF::Vector<::media::mojom::blink::SVCScalabilityMode> scalability_modes;
  
  bool is_software_codec;
  
  WTF::Vector<::media::mojom::blink::VideoPixelFormat> gpu_supported_pixel_formats;
  
  bool supports_gpu_shared_images;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoEncodeAcceleratorSupportedProfile::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoEncodeAcceleratorSupportedProfile::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoEncodeAcceleratorSupportedProfile::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoEncodeAcceleratorSupportedProfile::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT EncodeCommandBufferId {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EncodeCommandBufferId, T>::value>;
  using DataView = EncodeCommandBufferIdDataView;
  using Data_ = internal::EncodeCommandBufferId_Data;

  template <typename... Args>
  static EncodeCommandBufferIdPtr New(Args&&... args) {
    return EncodeCommandBufferIdPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EncodeCommandBufferIdPtr From(const U& u) {
    return mojo::TypeConverter<EncodeCommandBufferIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EncodeCommandBufferId>::Convert(*this);
  }


  EncodeCommandBufferId();

  EncodeCommandBufferId(
      const ::base::UnguessableToken& channel_token,
      int32_t route_id);


  ~EncodeCommandBufferId();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EncodeCommandBufferIdPtr>
  EncodeCommandBufferIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EncodeCommandBufferId::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EncodeCommandBufferId::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EncodeCommandBufferId::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EncodeCommandBufferId::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EncodeCommandBufferId::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EncodeCommandBufferId_UnserializedMessageContext<
            UserType, EncodeCommandBufferId::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EncodeCommandBufferId::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EncodeCommandBufferId::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EncodeCommandBufferId_UnserializedMessageContext<
            UserType, EncodeCommandBufferId::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EncodeCommandBufferId::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken channel_token;
  
  int32_t route_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EncodeCommandBufferId::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EncodeCommandBufferId::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EncodeCommandBufferId::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EncodeCommandBufferId::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_PLATFORM_EXPORT VideoBitrateAllocation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoBitrateAllocation, T>::value>;
  using DataView = VideoBitrateAllocationDataView;
  using Data_ = internal::VideoBitrateAllocation_Data;

  template <typename... Args>
  static VideoBitrateAllocationPtr New(Args&&... args) {
    return VideoBitrateAllocationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoBitrateAllocationPtr From(const U& u) {
    return mojo::TypeConverter<VideoBitrateAllocationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoBitrateAllocation>::Convert(*this);
  }


  VideoBitrateAllocation();

  VideoBitrateAllocation(
      WTF::Vector<uint32_t> bitrates,
      VariableBitratePeakPtr variable_bitrate_peak);

VideoBitrateAllocation(const VideoBitrateAllocation&) = delete;
VideoBitrateAllocation& operator=(const VideoBitrateAllocation&) = delete;

  ~VideoBitrateAllocation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoBitrateAllocationPtr>
  VideoBitrateAllocationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoBitrateAllocation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoBitrateAllocation::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoBitrateAllocation::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoBitrateAllocation::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoBitrateAllocation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoBitrateAllocation_UnserializedMessageContext<
            UserType, VideoBitrateAllocation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoBitrateAllocation::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoBitrateAllocation::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoBitrateAllocation_UnserializedMessageContext<
            UserType, VideoBitrateAllocation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoBitrateAllocation::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  WTF::Vector<uint32_t> bitrates;
  
  VariableBitratePeakPtr variable_bitrate_peak;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoBitrateAllocation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoBitrateAllocation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoBitrateAllocation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoBitrateAllocation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT SpatialLayer {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SpatialLayer, T>::value>;
  using DataView = SpatialLayerDataView;
  using Data_ = internal::SpatialLayer_Data;

  template <typename... Args>
  static SpatialLayerPtr New(Args&&... args) {
    return SpatialLayerPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SpatialLayerPtr From(const U& u) {
    return mojo::TypeConverter<SpatialLayerPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SpatialLayer>::Convert(*this);
  }


  SpatialLayer();

  SpatialLayer(
      int32_t width,
      int32_t height,
      uint32_t bitrate_bps,
      uint32_t framerate,
      uint8_t max_qp,
      uint8_t num_of_temporal_layers);


  ~SpatialLayer();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SpatialLayerPtr>
  SpatialLayerPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SpatialLayer::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SpatialLayer::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SpatialLayer::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SpatialLayer::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SpatialLayer::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SpatialLayer_UnserializedMessageContext<
            UserType, SpatialLayer::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SpatialLayer::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SpatialLayer::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SpatialLayer_UnserializedMessageContext<
            UserType, SpatialLayer::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SpatialLayer::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t width;
  
  int32_t height;
  
  uint32_t bitrate_bps;
  
  uint32_t framerate;
  
  uint8_t max_qp;
  
  uint8_t num_of_temporal_layers;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SpatialLayer::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SpatialLayer::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SpatialLayer::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SpatialLayer::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class BLINK_PLATFORM_EXPORT VideoEncodeAcceleratorConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoEncodeAcceleratorConfig, T>::value>;
  using DataView = VideoEncodeAcceleratorConfigDataView;
  using Data_ = internal::VideoEncodeAcceleratorConfig_Data;
  using ContentType = VideoEncodeAcceleratorConfig_ContentType;
  using StorageType = VideoEncodeAcceleratorConfig_StorageType;
  using EncoderType = VideoEncodeAcceleratorConfig_EncoderType;

  template <typename... Args>
  static VideoEncodeAcceleratorConfigPtr New(Args&&... args) {
    return VideoEncodeAcceleratorConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoEncodeAcceleratorConfigPtr From(const U& u) {
    return mojo::TypeConverter<VideoEncodeAcceleratorConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoEncodeAcceleratorConfig>::Convert(*this);
  }


  VideoEncodeAcceleratorConfig();

  VideoEncodeAcceleratorConfig(
      ::media::mojom::blink::VideoPixelFormat input_format,
      const ::gfx::Size& input_visible_size,
      ::media::mojom::blink::VideoCodecProfile output_profile,
      BitratePtr bitrate,
      uint32_t framerate,
      VideoEncodeAcceleratorConfig::StorageType storage_type,
      VideoEncodeAcceleratorConfig::ContentType content_type,
      uint32_t gop_length,
      bool has_gop_length,
      uint8_t h264_output_level,
      bool has_h264_output_level,
      bool is_constrained_h264,
      uint8_t drop_frame_thresh_percentage,
      WTF::Vector<SpatialLayerPtr> spatial_layers,
      ::media::mojom::blink::SVCInterLayerPredMode inter_layer_pred,
      bool require_low_delay,
      VideoEncodeAcceleratorConfig::EncoderType required_encoder_type);

VideoEncodeAcceleratorConfig(const VideoEncodeAcceleratorConfig&) = delete;
VideoEncodeAcceleratorConfig& operator=(const VideoEncodeAcceleratorConfig&) = delete;

  ~VideoEncodeAcceleratorConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoEncodeAcceleratorConfigPtr>
  VideoEncodeAcceleratorConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoEncodeAcceleratorConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoEncodeAcceleratorConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoEncodeAcceleratorConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoEncodeAcceleratorConfig::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoEncodeAcceleratorConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoEncodeAcceleratorConfig_UnserializedMessageContext<
            UserType, VideoEncodeAcceleratorConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoEncodeAcceleratorConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoEncodeAcceleratorConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoEncodeAcceleratorConfig_UnserializedMessageContext<
            UserType, VideoEncodeAcceleratorConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoEncodeAcceleratorConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::media::mojom::blink::VideoPixelFormat input_format;
  
  ::gfx::Size input_visible_size;
  
  ::media::mojom::blink::VideoCodecProfile output_profile;
  
  BitratePtr bitrate;
  
  uint32_t framerate;
  
  VideoEncodeAcceleratorConfig::StorageType storage_type;
  
  VideoEncodeAcceleratorConfig::ContentType content_type;
  
  uint32_t gop_length;
  
  bool has_gop_length;
  
  uint8_t h264_output_level;
  
  bool has_h264_output_level;
  
  bool is_constrained_h264;
  
  uint8_t drop_frame_thresh_percentage;
  
  WTF::Vector<SpatialLayerPtr> spatial_layers;
  
  ::media::mojom::blink::SVCInterLayerPredMode inter_layer_pred;
  
  bool require_low_delay;
  
  VideoEncodeAcceleratorConfig::EncoderType required_encoder_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoEncodeAcceleratorConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoEncodeAcceleratorConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoEncodeAcceleratorConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoEncodeAcceleratorConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class BLINK_PLATFORM_EXPORT Vp9Metadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Vp9Metadata, T>::value>;
  using DataView = Vp9MetadataDataView;
  using Data_ = internal::Vp9Metadata_Data;

  template <typename... Args>
  static Vp9MetadataPtr New(Args&&... args) {
    return Vp9MetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static Vp9MetadataPtr From(const U& u) {
    return mojo::TypeConverter<Vp9MetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Vp9Metadata>::Convert(*this);
  }


  Vp9Metadata();

  Vp9Metadata(
      bool inter_pic_predicted,
      bool temporal_up_switch,
      bool referenced_by_upper_spatial_layers,
      bool reference_lower_spatial_layers,
      bool end_of_picture,
      uint8_t temporal_idx,
      uint8_t spatial_idx,
      WTF::Vector<::gfx::Size> spatial_layer_resolutions,
      uint8_t begin_active_spatial_layer_index,
      uint8_t end_active_spatial_layer_index,
      WTF::Vector<uint8_t> p_diffs);


  ~Vp9Metadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = Vp9MetadataPtr>
  Vp9MetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Vp9Metadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Vp9Metadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Vp9Metadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Vp9Metadata::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Vp9Metadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Vp9Metadata_UnserializedMessageContext<
            UserType, Vp9Metadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Vp9Metadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Vp9Metadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Vp9Metadata_UnserializedMessageContext<
            UserType, Vp9Metadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Vp9Metadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool inter_pic_predicted;
  
  bool temporal_up_switch;
  
  bool referenced_by_upper_spatial_layers;
  
  bool reference_lower_spatial_layers;
  
  bool end_of_picture;
  
  uint8_t temporal_idx;
  
  uint8_t spatial_idx;
  
  WTF::Vector<::gfx::Size> spatial_layer_resolutions;
  
  uint8_t begin_active_spatial_layer_index;
  
  uint8_t end_active_spatial_layer_index;
  
  WTF::Vector<uint8_t> p_diffs;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Vp9Metadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Vp9Metadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Vp9Metadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Vp9Metadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT SVCGenericMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SVCGenericMetadata, T>::value>;
  using DataView = SVCGenericMetadataDataView;
  using Data_ = internal::SVCGenericMetadata_Data;

  template <typename... Args>
  static SVCGenericMetadataPtr New(Args&&... args) {
    return SVCGenericMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SVCGenericMetadataPtr From(const U& u) {
    return mojo::TypeConverter<SVCGenericMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SVCGenericMetadata>::Convert(*this);
  }


  SVCGenericMetadata();

  SVCGenericMetadata(
      bool follow_svc_spec,
      uint8_t temporal_idx,
      uint8_t spatial_idx,
      std::optional<uint16_t> reference_flags,
      std::optional<uint16_t> refresh_flags);


  ~SVCGenericMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SVCGenericMetadataPtr>
  SVCGenericMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SVCGenericMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SVCGenericMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SVCGenericMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SVCGenericMetadata::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SVCGenericMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SVCGenericMetadata_UnserializedMessageContext<
            UserType, SVCGenericMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SVCGenericMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SVCGenericMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SVCGenericMetadata_UnserializedMessageContext<
            UserType, SVCGenericMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SVCGenericMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool follow_svc_spec;
  
  uint8_t temporal_idx;
  
  uint8_t spatial_idx;
  
  std::optional<uint16_t> reference_flags;
  
  std::optional<uint16_t> refresh_flags;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SVCGenericMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SVCGenericMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SVCGenericMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SVCGenericMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT BitstreamBufferMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BitstreamBufferMetadata, T>::value>;
  using DataView = BitstreamBufferMetadataDataView;
  using Data_ = internal::BitstreamBufferMetadata_Data;

  template <typename... Args>
  static BitstreamBufferMetadataPtr New(Args&&... args) {
    return BitstreamBufferMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BitstreamBufferMetadataPtr From(const U& u) {
    return mojo::TypeConverter<BitstreamBufferMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BitstreamBufferMetadata>::Convert(*this);
  }


  BitstreamBufferMetadata();

  BitstreamBufferMetadata(
      uint32_t payload_size_bytes,
      bool key_frame,
      ::base::TimeDelta timestamp,
      int32_t qp,
      OptionalMetadataPtr optional_metadata,
      SVCGenericMetadataPtr svc_generic,
      const std::optional<::gfx::Size>& encoded_size,
      const std::optional<::gfx::ColorSpace>& encoded_color_space);

BitstreamBufferMetadata(const BitstreamBufferMetadata&) = delete;
BitstreamBufferMetadata& operator=(const BitstreamBufferMetadata&) = delete;

  ~BitstreamBufferMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BitstreamBufferMetadataPtr>
  BitstreamBufferMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BitstreamBufferMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BitstreamBufferMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BitstreamBufferMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BitstreamBufferMetadata::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BitstreamBufferMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BitstreamBufferMetadata_UnserializedMessageContext<
            UserType, BitstreamBufferMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BitstreamBufferMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BitstreamBufferMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BitstreamBufferMetadata_UnserializedMessageContext<
            UserType, BitstreamBufferMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BitstreamBufferMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t payload_size_bytes;
  
  bool key_frame;
  
  ::base::TimeDelta timestamp;
  
  int32_t qp;
  
  OptionalMetadataPtr optional_metadata;
  
  SVCGenericMetadataPtr svc_generic;
  
  std::optional<::gfx::Size> encoded_size;
  
  std::optional<::gfx::ColorSpace> encoded_color_space;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BitstreamBufferMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BitstreamBufferMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BitstreamBufferMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BitstreamBufferMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
BitratePtr Bitrate::Clone() const {
  switch (tag_) {
    case Tag::kConstant:
      return NewConstant(
          mojo::Clone(*data_.constant));
    case Tag::kVariable:
      return NewVariable(
          mojo::Clone(*data_.variable));
    case Tag::kExternal:
      return NewExternal(
          mojo::Clone(*data_.external));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, Bitrate>::value>::type*>
bool Bitrate::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kConstant:
      return mojo::Equals(*(data_.constant), *(other.data_.constant));
    case Tag::kVariable:
      return mojo::Equals(*(data_.variable), *(other.data_.variable));
    case Tag::kExternal:
      return mojo::Equals(*(data_.external), *(other.data_.external));
  }

  return false;
}
template <typename UnionPtrType>
OptionalMetadataPtr OptionalMetadata::Clone() const {
  switch (tag_) {
    case Tag::kDrop:
      return NewDrop(
          mojo::Clone(*data_.drop));
    case Tag::kH264:
      return NewH264(
          mojo::Clone(*data_.h264));
    case Tag::kVp8:
      return NewVp8(
          mojo::Clone(*data_.vp8));
    case Tag::kVp9:
      return NewVp9(
          mojo::Clone(*data_.vp9));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, OptionalMetadata>::value>::type*>
bool OptionalMetadata::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kDrop:
      return mojo::Equals(*(data_.drop), *(other.data_.drop));
    case Tag::kH264:
      return mojo::Equals(*(data_.h264), *(other.data_.h264));
    case Tag::kVp8:
      return mojo::Equals(*(data_.vp8), *(other.data_.vp8));
    case Tag::kVp9:
      return mojo::Equals(*(data_.vp9), *(other.data_.vp9));
  }

  return false;
}
template <typename StructPtrType>
VideoEncodeAcceleratorSupportedProfilePtr VideoEncodeAcceleratorSupportedProfile::Clone() const {
  return New(
      mojo::Clone(profile),
      mojo::Clone(min_resolution),
      mojo::Clone(max_resolution),
      mojo::Clone(max_framerate_numerator),
      mojo::Clone(max_framerate_denominator),
      mojo::Clone(rate_control_modes),
      mojo::Clone(scalability_modes),
      mojo::Clone(is_software_codec),
      mojo::Clone(gpu_supported_pixel_formats),
      mojo::Clone(supports_gpu_shared_images)
  );
}

template <typename T, VideoEncodeAcceleratorSupportedProfile::EnableIfSame<T>*>
bool VideoEncodeAcceleratorSupportedProfile::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->profile, other_struct.profile))
    return false;
  if (!mojo::Equals(this->min_resolution, other_struct.min_resolution))
    return false;
  if (!mojo::Equals(this->max_resolution, other_struct.max_resolution))
    return false;
  if (!mojo::Equals(this->max_framerate_numerator, other_struct.max_framerate_numerator))
    return false;
  if (!mojo::Equals(this->max_framerate_denominator, other_struct.max_framerate_denominator))
    return false;
  if (!mojo::Equals(this->rate_control_modes, other_struct.rate_control_modes))
    return false;
  if (!mojo::Equals(this->scalability_modes, other_struct.scalability_modes))
    return false;
  if (!mojo::Equals(this->is_software_codec, other_struct.is_software_codec))
    return false;
  if (!mojo::Equals(this->gpu_supported_pixel_formats, other_struct.gpu_supported_pixel_formats))
    return false;
  if (!mojo::Equals(this->supports_gpu_shared_images, other_struct.supports_gpu_shared_images))
    return false;
  return true;
}

template <typename T, VideoEncodeAcceleratorSupportedProfile::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.profile < rhs.profile)
    return true;
  if (rhs.profile < lhs.profile)
    return false;
  if (lhs.min_resolution < rhs.min_resolution)
    return true;
  if (rhs.min_resolution < lhs.min_resolution)
    return false;
  if (lhs.max_resolution < rhs.max_resolution)
    return true;
  if (rhs.max_resolution < lhs.max_resolution)
    return false;
  if (lhs.max_framerate_numerator < rhs.max_framerate_numerator)
    return true;
  if (rhs.max_framerate_numerator < lhs.max_framerate_numerator)
    return false;
  if (lhs.max_framerate_denominator < rhs.max_framerate_denominator)
    return true;
  if (rhs.max_framerate_denominator < lhs.max_framerate_denominator)
    return false;
  if (lhs.rate_control_modes < rhs.rate_control_modes)
    return true;
  if (rhs.rate_control_modes < lhs.rate_control_modes)
    return false;
  if (lhs.scalability_modes < rhs.scalability_modes)
    return true;
  if (rhs.scalability_modes < lhs.scalability_modes)
    return false;
  if (lhs.is_software_codec < rhs.is_software_codec)
    return true;
  if (rhs.is_software_codec < lhs.is_software_codec)
    return false;
  if (lhs.gpu_supported_pixel_formats < rhs.gpu_supported_pixel_formats)
    return true;
  if (rhs.gpu_supported_pixel_formats < lhs.gpu_supported_pixel_formats)
    return false;
  if (lhs.supports_gpu_shared_images < rhs.supports_gpu_shared_images)
    return true;
  if (rhs.supports_gpu_shared_images < lhs.supports_gpu_shared_images)
    return false;
  return false;
}
template <typename StructPtrType>
EncodeCommandBufferIdPtr EncodeCommandBufferId::Clone() const {
  return New(
      mojo::Clone(channel_token),
      mojo::Clone(route_id)
  );
}

template <typename T, EncodeCommandBufferId::EnableIfSame<T>*>
bool EncodeCommandBufferId::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->channel_token, other_struct.channel_token))
    return false;
  if (!mojo::Equals(this->route_id, other_struct.route_id))
    return false;
  return true;
}

template <typename T, EncodeCommandBufferId::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.channel_token < rhs.channel_token)
    return true;
  if (rhs.channel_token < lhs.channel_token)
    return false;
  if (lhs.route_id < rhs.route_id)
    return true;
  if (rhs.route_id < lhs.route_id)
    return false;
  return false;
}
template <typename StructPtrType>
VariableBitratePeakPtr VariableBitratePeak::Clone() const {
  return New(
      mojo::Clone(bps)
  );
}

template <typename T, VariableBitratePeak::EnableIfSame<T>*>
bool VariableBitratePeak::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bps, other_struct.bps))
    return false;
  return true;
}

template <typename T, VariableBitratePeak::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bps < rhs.bps)
    return true;
  if (rhs.bps < lhs.bps)
    return false;
  return false;
}
template <typename StructPtrType>
VideoBitrateAllocationPtr VideoBitrateAllocation::Clone() const {
  return New(
      mojo::Clone(bitrates),
      mojo::Clone(variable_bitrate_peak)
  );
}

template <typename T, VideoBitrateAllocation::EnableIfSame<T>*>
bool VideoBitrateAllocation::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bitrates, other_struct.bitrates))
    return false;
  if (!mojo::Equals(this->variable_bitrate_peak, other_struct.variable_bitrate_peak))
    return false;
  return true;
}

template <typename T, VideoBitrateAllocation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bitrates < rhs.bitrates)
    return true;
  if (rhs.bitrates < lhs.bitrates)
    return false;
  if (lhs.variable_bitrate_peak < rhs.variable_bitrate_peak)
    return true;
  if (rhs.variable_bitrate_peak < lhs.variable_bitrate_peak)
    return false;
  return false;
}
template <typename StructPtrType>
SpatialLayerPtr SpatialLayer::Clone() const {
  return New(
      mojo::Clone(width),
      mojo::Clone(height),
      mojo::Clone(bitrate_bps),
      mojo::Clone(framerate),
      mojo::Clone(max_qp),
      mojo::Clone(num_of_temporal_layers)
  );
}

template <typename T, SpatialLayer::EnableIfSame<T>*>
bool SpatialLayer::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->width, other_struct.width))
    return false;
  if (!mojo::Equals(this->height, other_struct.height))
    return false;
  if (!mojo::Equals(this->bitrate_bps, other_struct.bitrate_bps))
    return false;
  if (!mojo::Equals(this->framerate, other_struct.framerate))
    return false;
  if (!mojo::Equals(this->max_qp, other_struct.max_qp))
    return false;
  if (!mojo::Equals(this->num_of_temporal_layers, other_struct.num_of_temporal_layers))
    return false;
  return true;
}

template <typename T, SpatialLayer::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.width < rhs.width)
    return true;
  if (rhs.width < lhs.width)
    return false;
  if (lhs.height < rhs.height)
    return true;
  if (rhs.height < lhs.height)
    return false;
  if (lhs.bitrate_bps < rhs.bitrate_bps)
    return true;
  if (rhs.bitrate_bps < lhs.bitrate_bps)
    return false;
  if (lhs.framerate < rhs.framerate)
    return true;
  if (rhs.framerate < lhs.framerate)
    return false;
  if (lhs.max_qp < rhs.max_qp)
    return true;
  if (rhs.max_qp < lhs.max_qp)
    return false;
  if (lhs.num_of_temporal_layers < rhs.num_of_temporal_layers)
    return true;
  if (rhs.num_of_temporal_layers < lhs.num_of_temporal_layers)
    return false;
  return false;
}
template <typename StructPtrType>
ConstantBitratePtr ConstantBitrate::Clone() const {
  return New(
      mojo::Clone(target_bps)
  );
}

template <typename T, ConstantBitrate::EnableIfSame<T>*>
bool ConstantBitrate::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->target_bps, other_struct.target_bps))
    return false;
  return true;
}

template <typename T, ConstantBitrate::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.target_bps < rhs.target_bps)
    return true;
  if (rhs.target_bps < lhs.target_bps)
    return false;
  return false;
}
template <typename StructPtrType>
VariableBitratePtr VariableBitrate::Clone() const {
  return New(
      mojo::Clone(target_bps),
      mojo::Clone(peak_bps)
  );
}

template <typename T, VariableBitrate::EnableIfSame<T>*>
bool VariableBitrate::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->target_bps, other_struct.target_bps))
    return false;
  if (!mojo::Equals(this->peak_bps, other_struct.peak_bps))
    return false;
  return true;
}

template <typename T, VariableBitrate::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.target_bps < rhs.target_bps)
    return true;
  if (rhs.target_bps < lhs.target_bps)
    return false;
  if (lhs.peak_bps < rhs.peak_bps)
    return true;
  if (rhs.peak_bps < lhs.peak_bps)
    return false;
  return false;
}
template <typename StructPtrType>
ExternalBitratePtr ExternalBitrate::Clone() const {
  return New(
  );
}

template <typename T, ExternalBitrate::EnableIfSame<T>*>
bool ExternalBitrate::Equals(const T& other_struct) const {
  return true;
}

template <typename T, ExternalBitrate::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
VideoEncodeAcceleratorConfigPtr VideoEncodeAcceleratorConfig::Clone() const {
  return New(
      mojo::Clone(input_format),
      mojo::Clone(input_visible_size),
      mojo::Clone(output_profile),
      mojo::Clone(bitrate),
      mojo::Clone(framerate),
      mojo::Clone(storage_type),
      mojo::Clone(content_type),
      mojo::Clone(gop_length),
      mojo::Clone(has_gop_length),
      mojo::Clone(h264_output_level),
      mojo::Clone(has_h264_output_level),
      mojo::Clone(is_constrained_h264),
      mojo::Clone(drop_frame_thresh_percentage),
      mojo::Clone(spatial_layers),
      mojo::Clone(inter_layer_pred),
      mojo::Clone(require_low_delay),
      mojo::Clone(required_encoder_type)
  );
}

template <typename T, VideoEncodeAcceleratorConfig::EnableIfSame<T>*>
bool VideoEncodeAcceleratorConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_format, other_struct.input_format))
    return false;
  if (!mojo::Equals(this->input_visible_size, other_struct.input_visible_size))
    return false;
  if (!mojo::Equals(this->output_profile, other_struct.output_profile))
    return false;
  if (!mojo::Equals(this->bitrate, other_struct.bitrate))
    return false;
  if (!mojo::Equals(this->framerate, other_struct.framerate))
    return false;
  if (!mojo::Equals(this->storage_type, other_struct.storage_type))
    return false;
  if (!mojo::Equals(this->content_type, other_struct.content_type))
    return false;
  if (!mojo::Equals(this->gop_length, other_struct.gop_length))
    return false;
  if (!mojo::Equals(this->has_gop_length, other_struct.has_gop_length))
    return false;
  if (!mojo::Equals(this->h264_output_level, other_struct.h264_output_level))
    return false;
  if (!mojo::Equals(this->has_h264_output_level, other_struct.has_h264_output_level))
    return false;
  if (!mojo::Equals(this->is_constrained_h264, other_struct.is_constrained_h264))
    return false;
  if (!mojo::Equals(this->drop_frame_thresh_percentage, other_struct.drop_frame_thresh_percentage))
    return false;
  if (!mojo::Equals(this->spatial_layers, other_struct.spatial_layers))
    return false;
  if (!mojo::Equals(this->inter_layer_pred, other_struct.inter_layer_pred))
    return false;
  if (!mojo::Equals(this->require_low_delay, other_struct.require_low_delay))
    return false;
  if (!mojo::Equals(this->required_encoder_type, other_struct.required_encoder_type))
    return false;
  return true;
}

template <typename T, VideoEncodeAcceleratorConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_format < rhs.input_format)
    return true;
  if (rhs.input_format < lhs.input_format)
    return false;
  if (lhs.input_visible_size < rhs.input_visible_size)
    return true;
  if (rhs.input_visible_size < lhs.input_visible_size)
    return false;
  if (lhs.output_profile < rhs.output_profile)
    return true;
  if (rhs.output_profile < lhs.output_profile)
    return false;
  if (lhs.bitrate < rhs.bitrate)
    return true;
  if (rhs.bitrate < lhs.bitrate)
    return false;
  if (lhs.framerate < rhs.framerate)
    return true;
  if (rhs.framerate < lhs.framerate)
    return false;
  if (lhs.storage_type < rhs.storage_type)
    return true;
  if (rhs.storage_type < lhs.storage_type)
    return false;
  if (lhs.content_type < rhs.content_type)
    return true;
  if (rhs.content_type < lhs.content_type)
    return false;
  if (lhs.gop_length < rhs.gop_length)
    return true;
  if (rhs.gop_length < lhs.gop_length)
    return false;
  if (lhs.has_gop_length < rhs.has_gop_length)
    return true;
  if (rhs.has_gop_length < lhs.has_gop_length)
    return false;
  if (lhs.h264_output_level < rhs.h264_output_level)
    return true;
  if (rhs.h264_output_level < lhs.h264_output_level)
    return false;
  if (lhs.has_h264_output_level < rhs.has_h264_output_level)
    return true;
  if (rhs.has_h264_output_level < lhs.has_h264_output_level)
    return false;
  if (lhs.is_constrained_h264 < rhs.is_constrained_h264)
    return true;
  if (rhs.is_constrained_h264 < lhs.is_constrained_h264)
    return false;
  if (lhs.drop_frame_thresh_percentage < rhs.drop_frame_thresh_percentage)
    return true;
  if (rhs.drop_frame_thresh_percentage < lhs.drop_frame_thresh_percentage)
    return false;
  if (lhs.spatial_layers < rhs.spatial_layers)
    return true;
  if (rhs.spatial_layers < lhs.spatial_layers)
    return false;
  if (lhs.inter_layer_pred < rhs.inter_layer_pred)
    return true;
  if (rhs.inter_layer_pred < lhs.inter_layer_pred)
    return false;
  if (lhs.require_low_delay < rhs.require_low_delay)
    return true;
  if (rhs.require_low_delay < lhs.require_low_delay)
    return false;
  if (lhs.required_encoder_type < rhs.required_encoder_type)
    return true;
  if (rhs.required_encoder_type < lhs.required_encoder_type)
    return false;
  return false;
}
template <typename StructPtrType>
VideoEncodeOptionsPtr VideoEncodeOptions::Clone() const {
  return New(
      mojo::Clone(force_keyframe),
      mojo::Clone(quantizer)
  );
}

template <typename T, VideoEncodeOptions::EnableIfSame<T>*>
bool VideoEncodeOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->force_keyframe, other_struct.force_keyframe))
    return false;
  if (!mojo::Equals(this->quantizer, other_struct.quantizer))
    return false;
  return true;
}

template <typename T, VideoEncodeOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.force_keyframe < rhs.force_keyframe)
    return true;
  if (rhs.force_keyframe < lhs.force_keyframe)
    return false;
  if (lhs.quantizer < rhs.quantizer)
    return true;
  if (rhs.quantizer < lhs.quantizer)
    return false;
  return false;
}
template <typename StructPtrType>
DropFrameMetadataPtr DropFrameMetadata::Clone() const {
  return New(
      mojo::Clone(spatial_idx),
      mojo::Clone(end_of_picture)
  );
}

template <typename T, DropFrameMetadata::EnableIfSame<T>*>
bool DropFrameMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->spatial_idx, other_struct.spatial_idx))
    return false;
  if (!mojo::Equals(this->end_of_picture, other_struct.end_of_picture))
    return false;
  return true;
}

template <typename T, DropFrameMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.spatial_idx < rhs.spatial_idx)
    return true;
  if (rhs.spatial_idx < lhs.spatial_idx)
    return false;
  if (lhs.end_of_picture < rhs.end_of_picture)
    return true;
  if (rhs.end_of_picture < lhs.end_of_picture)
    return false;
  return false;
}
template <typename StructPtrType>
H264MetadataPtr H264Metadata::Clone() const {
  return New(
      mojo::Clone(temporal_idx),
      mojo::Clone(layer_sync)
  );
}

template <typename T, H264Metadata::EnableIfSame<T>*>
bool H264Metadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->temporal_idx, other_struct.temporal_idx))
    return false;
  if (!mojo::Equals(this->layer_sync, other_struct.layer_sync))
    return false;
  return true;
}

template <typename T, H264Metadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.temporal_idx < rhs.temporal_idx)
    return true;
  if (rhs.temporal_idx < lhs.temporal_idx)
    return false;
  if (lhs.layer_sync < rhs.layer_sync)
    return true;
  if (rhs.layer_sync < lhs.layer_sync)
    return false;
  return false;
}
template <typename StructPtrType>
Vp8MetadataPtr Vp8Metadata::Clone() const {
  return New(
      mojo::Clone(non_reference),
      mojo::Clone(temporal_idx),
      mojo::Clone(layer_sync)
  );
}

template <typename T, Vp8Metadata::EnableIfSame<T>*>
bool Vp8Metadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->non_reference, other_struct.non_reference))
    return false;
  if (!mojo::Equals(this->temporal_idx, other_struct.temporal_idx))
    return false;
  if (!mojo::Equals(this->layer_sync, other_struct.layer_sync))
    return false;
  return true;
}

template <typename T, Vp8Metadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.non_reference < rhs.non_reference)
    return true;
  if (rhs.non_reference < lhs.non_reference)
    return false;
  if (lhs.temporal_idx < rhs.temporal_idx)
    return true;
  if (rhs.temporal_idx < lhs.temporal_idx)
    return false;
  if (lhs.layer_sync < rhs.layer_sync)
    return true;
  if (rhs.layer_sync < lhs.layer_sync)
    return false;
  return false;
}
template <typename StructPtrType>
Vp9MetadataPtr Vp9Metadata::Clone() const {
  return New(
      mojo::Clone(inter_pic_predicted),
      mojo::Clone(temporal_up_switch),
      mojo::Clone(referenced_by_upper_spatial_layers),
      mojo::Clone(reference_lower_spatial_layers),
      mojo::Clone(end_of_picture),
      mojo::Clone(temporal_idx),
      mojo::Clone(spatial_idx),
      mojo::Clone(spatial_layer_resolutions),
      mojo::Clone(begin_active_spatial_layer_index),
      mojo::Clone(end_active_spatial_layer_index),
      mojo::Clone(p_diffs)
  );
}

template <typename T, Vp9Metadata::EnableIfSame<T>*>
bool Vp9Metadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->inter_pic_predicted, other_struct.inter_pic_predicted))
    return false;
  if (!mojo::Equals(this->temporal_up_switch, other_struct.temporal_up_switch))
    return false;
  if (!mojo::Equals(this->referenced_by_upper_spatial_layers, other_struct.referenced_by_upper_spatial_layers))
    return false;
  if (!mojo::Equals(this->reference_lower_spatial_layers, other_struct.reference_lower_spatial_layers))
    return false;
  if (!mojo::Equals(this->end_of_picture, other_struct.end_of_picture))
    return false;
  if (!mojo::Equals(this->temporal_idx, other_struct.temporal_idx))
    return false;
  if (!mojo::Equals(this->spatial_idx, other_struct.spatial_idx))
    return false;
  if (!mojo::Equals(this->spatial_layer_resolutions, other_struct.spatial_layer_resolutions))
    return false;
  if (!mojo::Equals(this->begin_active_spatial_layer_index, other_struct.begin_active_spatial_layer_index))
    return false;
  if (!mojo::Equals(this->end_active_spatial_layer_index, other_struct.end_active_spatial_layer_index))
    return false;
  if (!mojo::Equals(this->p_diffs, other_struct.p_diffs))
    return false;
  return true;
}

template <typename T, Vp9Metadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.inter_pic_predicted < rhs.inter_pic_predicted)
    return true;
  if (rhs.inter_pic_predicted < lhs.inter_pic_predicted)
    return false;
  if (lhs.temporal_up_switch < rhs.temporal_up_switch)
    return true;
  if (rhs.temporal_up_switch < lhs.temporal_up_switch)
    return false;
  if (lhs.referenced_by_upper_spatial_layers < rhs.referenced_by_upper_spatial_layers)
    return true;
  if (rhs.referenced_by_upper_spatial_layers < lhs.referenced_by_upper_spatial_layers)
    return false;
  if (lhs.reference_lower_spatial_layers < rhs.reference_lower_spatial_layers)
    return true;
  if (rhs.reference_lower_spatial_layers < lhs.reference_lower_spatial_layers)
    return false;
  if (lhs.end_of_picture < rhs.end_of_picture)
    return true;
  if (rhs.end_of_picture < lhs.end_of_picture)
    return false;
  if (lhs.temporal_idx < rhs.temporal_idx)
    return true;
  if (rhs.temporal_idx < lhs.temporal_idx)
    return false;
  if (lhs.spatial_idx < rhs.spatial_idx)
    return true;
  if (rhs.spatial_idx < lhs.spatial_idx)
    return false;
  if (lhs.spatial_layer_resolutions < rhs.spatial_layer_resolutions)
    return true;
  if (rhs.spatial_layer_resolutions < lhs.spatial_layer_resolutions)
    return false;
  if (lhs.begin_active_spatial_layer_index < rhs.begin_active_spatial_layer_index)
    return true;
  if (rhs.begin_active_spatial_layer_index < lhs.begin_active_spatial_layer_index)
    return false;
  if (lhs.end_active_spatial_layer_index < rhs.end_active_spatial_layer_index)
    return true;
  if (rhs.end_active_spatial_layer_index < lhs.end_active_spatial_layer_index)
    return false;
  if (lhs.p_diffs < rhs.p_diffs)
    return true;
  if (rhs.p_diffs < lhs.p_diffs)
    return false;
  return false;
}
template <typename StructPtrType>
SVCGenericMetadataPtr SVCGenericMetadata::Clone() const {
  return New(
      mojo::Clone(follow_svc_spec),
      mojo::Clone(temporal_idx),
      mojo::Clone(spatial_idx),
      mojo::Clone(reference_flags),
      mojo::Clone(refresh_flags)
  );
}

template <typename T, SVCGenericMetadata::EnableIfSame<T>*>
bool SVCGenericMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->follow_svc_spec, other_struct.follow_svc_spec))
    return false;
  if (!mojo::Equals(this->temporal_idx, other_struct.temporal_idx))
    return false;
  if (!mojo::Equals(this->spatial_idx, other_struct.spatial_idx))
    return false;
  if (!mojo::Equals(this->reference_flags, other_struct.reference_flags))
    return false;
  if (!mojo::Equals(this->refresh_flags, other_struct.refresh_flags))
    return false;
  return true;
}

template <typename T, SVCGenericMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.follow_svc_spec < rhs.follow_svc_spec)
    return true;
  if (rhs.follow_svc_spec < lhs.follow_svc_spec)
    return false;
  if (lhs.temporal_idx < rhs.temporal_idx)
    return true;
  if (rhs.temporal_idx < lhs.temporal_idx)
    return false;
  if (lhs.spatial_idx < rhs.spatial_idx)
    return true;
  if (rhs.spatial_idx < lhs.spatial_idx)
    return false;
  if (lhs.reference_flags < rhs.reference_flags)
    return true;
  if (rhs.reference_flags < lhs.reference_flags)
    return false;
  if (lhs.refresh_flags < rhs.refresh_flags)
    return true;
  if (rhs.refresh_flags < lhs.refresh_flags)
    return false;
  return false;
}
template <typename StructPtrType>
BitstreamBufferMetadataPtr BitstreamBufferMetadata::Clone() const {
  return New(
      mojo::Clone(payload_size_bytes),
      mojo::Clone(key_frame),
      mojo::Clone(timestamp),
      mojo::Clone(qp),
      mojo::Clone(optional_metadata),
      mojo::Clone(svc_generic),
      mojo::Clone(encoded_size),
      mojo::Clone(encoded_color_space)
  );
}

template <typename T, BitstreamBufferMetadata::EnableIfSame<T>*>
bool BitstreamBufferMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->payload_size_bytes, other_struct.payload_size_bytes))
    return false;
  if (!mojo::Equals(this->key_frame, other_struct.key_frame))
    return false;
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  if (!mojo::Equals(this->qp, other_struct.qp))
    return false;
  if (!mojo::Equals(this->optional_metadata, other_struct.optional_metadata))
    return false;
  if (!mojo::Equals(this->svc_generic, other_struct.svc_generic))
    return false;
  if (!mojo::Equals(this->encoded_size, other_struct.encoded_size))
    return false;
  if (!mojo::Equals(this->encoded_color_space, other_struct.encoded_color_space))
    return false;
  return true;
}

template <typename T, BitstreamBufferMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.payload_size_bytes < rhs.payload_size_bytes)
    return true;
  if (rhs.payload_size_bytes < lhs.payload_size_bytes)
    return false;
  if (lhs.key_frame < rhs.key_frame)
    return true;
  if (rhs.key_frame < lhs.key_frame)
    return false;
  if (lhs.timestamp < rhs.timestamp)
    return true;
  if (rhs.timestamp < lhs.timestamp)
    return false;
  if (lhs.qp < rhs.qp)
    return true;
  if (rhs.qp < lhs.qp)
    return false;
  if (lhs.optional_metadata < rhs.optional_metadata)
    return true;
  if (rhs.optional_metadata < lhs.optional_metadata)
    return false;
  if (lhs.svc_generic < rhs.svc_generic)
    return true;
  if (rhs.svc_generic < lhs.svc_generic)
    return false;
  if (lhs.encoded_size < rhs.encoded_size)
    return true;
  if (rhs.encoded_size < lhs.encoded_size)
    return false;
  if (lhs.encoded_color_space < rhs.encoded_color_space)
    return true;
  if (rhs.encoded_color_space < lhs.encoded_color_space)
    return false;
  return false;
}


}  // media::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::VideoEncodeAcceleratorSupportedProfile::DataView,
                                         ::media::mojom::blink::VideoEncodeAcceleratorSupportedProfilePtr> {
  static bool IsNull(const ::media::mojom::blink::VideoEncodeAcceleratorSupportedProfilePtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::VideoEncodeAcceleratorSupportedProfilePtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::VideoEncodeAcceleratorSupportedProfile::profile) profile(
      const ::media::mojom::blink::VideoEncodeAcceleratorSupportedProfilePtr& input) {
    return input->profile;
  }

  static const decltype(::media::mojom::blink::VideoEncodeAcceleratorSupportedProfile::min_resolution)& min_resolution(
      const ::media::mojom::blink::VideoEncodeAcceleratorSupportedProfilePtr& input) {
    return input->min_resolution;
  }

  static const decltype(::media::mojom::blink::VideoEncodeAcceleratorSupportedProfile::max_resolution)& max_resolution(
      const ::media::mojom::blink::VideoEncodeAcceleratorSupportedProfilePtr& input) {
    return input->max_resolution;
  }

  static decltype(::media::mojom::blink::VideoEncodeAcceleratorSupportedProfile::max_framerate_numerator) max_framerate_numerator(
      const ::media::mojom::blink::VideoEncodeAcceleratorSupportedProfilePtr& input) {
    return input->max_framerate_numerator;
  }

  static decltype(::media::mojom::blink::VideoEncodeAcceleratorSupportedProfile::max_framerate_denominator) max_framerate_denominator(
      const ::media::mojom::blink::VideoEncodeAcceleratorSupportedProfilePtr& input) {
    return input->max_framerate_denominator;
  }

  static const decltype(::media::mojom::blink::VideoEncodeAcceleratorSupportedProfile::rate_control_modes)& rate_control_modes(
      const ::media::mojom::blink::VideoEncodeAcceleratorSupportedProfilePtr& input) {
    return input->rate_control_modes;
  }

  static const decltype(::media::mojom::blink::VideoEncodeAcceleratorSupportedProfile::scalability_modes)& scalability_modes(
      const ::media::mojom::blink::VideoEncodeAcceleratorSupportedProfilePtr& input) {
    return input->scalability_modes;
  }

  static decltype(::media::mojom::blink::VideoEncodeAcceleratorSupportedProfile::is_software_codec) is_software_codec(
      const ::media::mojom::blink::VideoEncodeAcceleratorSupportedProfilePtr& input) {
    return input->is_software_codec;
  }

  static const decltype(::media::mojom::blink::VideoEncodeAcceleratorSupportedProfile::gpu_supported_pixel_formats)& gpu_supported_pixel_formats(
      const ::media::mojom::blink::VideoEncodeAcceleratorSupportedProfilePtr& input) {
    return input->gpu_supported_pixel_formats;
  }

  static decltype(::media::mojom::blink::VideoEncodeAcceleratorSupportedProfile::supports_gpu_shared_images) supports_gpu_shared_images(
      const ::media::mojom::blink::VideoEncodeAcceleratorSupportedProfilePtr& input) {
    return input->supports_gpu_shared_images;
  }

  static bool Read(::media::mojom::blink::VideoEncodeAcceleratorSupportedProfile::DataView input, ::media::mojom::blink::VideoEncodeAcceleratorSupportedProfilePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::EncodeCommandBufferId::DataView,
                                         ::media::mojom::blink::EncodeCommandBufferIdPtr> {
  static bool IsNull(const ::media::mojom::blink::EncodeCommandBufferIdPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::EncodeCommandBufferIdPtr* output) { output->reset(); }

  static const decltype(::media::mojom::blink::EncodeCommandBufferId::channel_token)& channel_token(
      const ::media::mojom::blink::EncodeCommandBufferIdPtr& input) {
    return input->channel_token;
  }

  static decltype(::media::mojom::blink::EncodeCommandBufferId::route_id) route_id(
      const ::media::mojom::blink::EncodeCommandBufferIdPtr& input) {
    return input->route_id;
  }

  static bool Read(::media::mojom::blink::EncodeCommandBufferId::DataView input, ::media::mojom::blink::EncodeCommandBufferIdPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::VariableBitratePeak::DataView,
                                         ::media::mojom::blink::VariableBitratePeakPtr> {
  static bool IsNull(const ::media::mojom::blink::VariableBitratePeakPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::VariableBitratePeakPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::VariableBitratePeak::bps) bps(
      const ::media::mojom::blink::VariableBitratePeakPtr& input) {
    return input->bps;
  }

  static bool Read(::media::mojom::blink::VariableBitratePeak::DataView input, ::media::mojom::blink::VariableBitratePeakPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::VideoBitrateAllocation::DataView,
                                         ::media::mojom::blink::VideoBitrateAllocationPtr> {
  static bool IsNull(const ::media::mojom::blink::VideoBitrateAllocationPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::VideoBitrateAllocationPtr* output) { output->reset(); }

  static const decltype(::media::mojom::blink::VideoBitrateAllocation::bitrates)& bitrates(
      const ::media::mojom::blink::VideoBitrateAllocationPtr& input) {
    return input->bitrates;
  }

  static const decltype(::media::mojom::blink::VideoBitrateAllocation::variable_bitrate_peak)& variable_bitrate_peak(
      const ::media::mojom::blink::VideoBitrateAllocationPtr& input) {
    return input->variable_bitrate_peak;
  }

  static bool Read(::media::mojom::blink::VideoBitrateAllocation::DataView input, ::media::mojom::blink::VideoBitrateAllocationPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::SpatialLayer::DataView,
                                         ::media::mojom::blink::SpatialLayerPtr> {
  static bool IsNull(const ::media::mojom::blink::SpatialLayerPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::SpatialLayerPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::SpatialLayer::width) width(
      const ::media::mojom::blink::SpatialLayerPtr& input) {
    return input->width;
  }

  static decltype(::media::mojom::blink::SpatialLayer::height) height(
      const ::media::mojom::blink::SpatialLayerPtr& input) {
    return input->height;
  }

  static decltype(::media::mojom::blink::SpatialLayer::bitrate_bps) bitrate_bps(
      const ::media::mojom::blink::SpatialLayerPtr& input) {
    return input->bitrate_bps;
  }

  static decltype(::media::mojom::blink::SpatialLayer::framerate) framerate(
      const ::media::mojom::blink::SpatialLayerPtr& input) {
    return input->framerate;
  }

  static decltype(::media::mojom::blink::SpatialLayer::max_qp) max_qp(
      const ::media::mojom::blink::SpatialLayerPtr& input) {
    return input->max_qp;
  }

  static decltype(::media::mojom::blink::SpatialLayer::num_of_temporal_layers) num_of_temporal_layers(
      const ::media::mojom::blink::SpatialLayerPtr& input) {
    return input->num_of_temporal_layers;
  }

  static bool Read(::media::mojom::blink::SpatialLayer::DataView input, ::media::mojom::blink::SpatialLayerPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::ConstantBitrate::DataView,
                                         ::media::mojom::blink::ConstantBitratePtr> {
  static bool IsNull(const ::media::mojom::blink::ConstantBitratePtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::ConstantBitratePtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::ConstantBitrate::target_bps) target_bps(
      const ::media::mojom::blink::ConstantBitratePtr& input) {
    return input->target_bps;
  }

  static bool Read(::media::mojom::blink::ConstantBitrate::DataView input, ::media::mojom::blink::ConstantBitratePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::VariableBitrate::DataView,
                                         ::media::mojom::blink::VariableBitratePtr> {
  static bool IsNull(const ::media::mojom::blink::VariableBitratePtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::VariableBitratePtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::VariableBitrate::target_bps) target_bps(
      const ::media::mojom::blink::VariableBitratePtr& input) {
    return input->target_bps;
  }

  static decltype(::media::mojom::blink::VariableBitrate::peak_bps) peak_bps(
      const ::media::mojom::blink::VariableBitratePtr& input) {
    return input->peak_bps;
  }

  static bool Read(::media::mojom::blink::VariableBitrate::DataView input, ::media::mojom::blink::VariableBitratePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::ExternalBitrate::DataView,
                                         ::media::mojom::blink::ExternalBitratePtr> {
  static bool IsNull(const ::media::mojom::blink::ExternalBitratePtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::ExternalBitratePtr* output) { output->reset(); }

  static bool Read(::media::mojom::blink::ExternalBitrate::DataView input, ::media::mojom::blink::ExternalBitratePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::VideoEncodeAcceleratorConfig::DataView,
                                         ::media::mojom::blink::VideoEncodeAcceleratorConfigPtr> {
  static bool IsNull(const ::media::mojom::blink::VideoEncodeAcceleratorConfigPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::VideoEncodeAcceleratorConfigPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::VideoEncodeAcceleratorConfig::input_format) input_format(
      const ::media::mojom::blink::VideoEncodeAcceleratorConfigPtr& input) {
    return input->input_format;
  }

  static const decltype(::media::mojom::blink::VideoEncodeAcceleratorConfig::input_visible_size)& input_visible_size(
      const ::media::mojom::blink::VideoEncodeAcceleratorConfigPtr& input) {
    return input->input_visible_size;
  }

  static decltype(::media::mojom::blink::VideoEncodeAcceleratorConfig::output_profile) output_profile(
      const ::media::mojom::blink::VideoEncodeAcceleratorConfigPtr& input) {
    return input->output_profile;
  }

  static const decltype(::media::mojom::blink::VideoEncodeAcceleratorConfig::bitrate)& bitrate(
      const ::media::mojom::blink::VideoEncodeAcceleratorConfigPtr& input) {
    return input->bitrate;
  }

  static decltype(::media::mojom::blink::VideoEncodeAcceleratorConfig::framerate) framerate(
      const ::media::mojom::blink::VideoEncodeAcceleratorConfigPtr& input) {
    return input->framerate;
  }

  static decltype(::media::mojom::blink::VideoEncodeAcceleratorConfig::storage_type) storage_type(
      const ::media::mojom::blink::VideoEncodeAcceleratorConfigPtr& input) {
    return input->storage_type;
  }

  static decltype(::media::mojom::blink::VideoEncodeAcceleratorConfig::content_type) content_type(
      const ::media::mojom::blink::VideoEncodeAcceleratorConfigPtr& input) {
    return input->content_type;
  }

  static decltype(::media::mojom::blink::VideoEncodeAcceleratorConfig::gop_length) gop_length(
      const ::media::mojom::blink::VideoEncodeAcceleratorConfigPtr& input) {
    return input->gop_length;
  }

  static decltype(::media::mojom::blink::VideoEncodeAcceleratorConfig::has_gop_length) has_gop_length(
      const ::media::mojom::blink::VideoEncodeAcceleratorConfigPtr& input) {
    return input->has_gop_length;
  }

  static decltype(::media::mojom::blink::VideoEncodeAcceleratorConfig::h264_output_level) h264_output_level(
      const ::media::mojom::blink::VideoEncodeAcceleratorConfigPtr& input) {
    return input->h264_output_level;
  }

  static decltype(::media::mojom::blink::VideoEncodeAcceleratorConfig::has_h264_output_level) has_h264_output_level(
      const ::media::mojom::blink::VideoEncodeAcceleratorConfigPtr& input) {
    return input->has_h264_output_level;
  }

  static decltype(::media::mojom::blink::VideoEncodeAcceleratorConfig::is_constrained_h264) is_constrained_h264(
      const ::media::mojom::blink::VideoEncodeAcceleratorConfigPtr& input) {
    return input->is_constrained_h264;
  }

  static decltype(::media::mojom::blink::VideoEncodeAcceleratorConfig::drop_frame_thresh_percentage) drop_frame_thresh_percentage(
      const ::media::mojom::blink::VideoEncodeAcceleratorConfigPtr& input) {
    return input->drop_frame_thresh_percentage;
  }

  static const decltype(::media::mojom::blink::VideoEncodeAcceleratorConfig::spatial_layers)& spatial_layers(
      const ::media::mojom::blink::VideoEncodeAcceleratorConfigPtr& input) {
    return input->spatial_layers;
  }

  static decltype(::media::mojom::blink::VideoEncodeAcceleratorConfig::inter_layer_pred) inter_layer_pred(
      const ::media::mojom::blink::VideoEncodeAcceleratorConfigPtr& input) {
    return input->inter_layer_pred;
  }

  static decltype(::media::mojom::blink::VideoEncodeAcceleratorConfig::require_low_delay) require_low_delay(
      const ::media::mojom::blink::VideoEncodeAcceleratorConfigPtr& input) {
    return input->require_low_delay;
  }

  static decltype(::media::mojom::blink::VideoEncodeAcceleratorConfig::required_encoder_type) required_encoder_type(
      const ::media::mojom::blink::VideoEncodeAcceleratorConfigPtr& input) {
    return input->required_encoder_type;
  }

  static bool Read(::media::mojom::blink::VideoEncodeAcceleratorConfig::DataView input, ::media::mojom::blink::VideoEncodeAcceleratorConfigPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::VideoEncodeOptions::DataView,
                                         ::media::mojom::blink::VideoEncodeOptionsPtr> {
  static bool IsNull(const ::media::mojom::blink::VideoEncodeOptionsPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::VideoEncodeOptionsPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::VideoEncodeOptions::force_keyframe) force_keyframe(
      const ::media::mojom::blink::VideoEncodeOptionsPtr& input) {
    return input->force_keyframe;
  }

  static decltype(::media::mojom::blink::VideoEncodeOptions::quantizer) quantizer(
      const ::media::mojom::blink::VideoEncodeOptionsPtr& input) {
    return input->quantizer;
  }

  static bool Read(::media::mojom::blink::VideoEncodeOptions::DataView input, ::media::mojom::blink::VideoEncodeOptionsPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::DropFrameMetadata::DataView,
                                         ::media::mojom::blink::DropFrameMetadataPtr> {
  static bool IsNull(const ::media::mojom::blink::DropFrameMetadataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::DropFrameMetadataPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::DropFrameMetadata::spatial_idx) spatial_idx(
      const ::media::mojom::blink::DropFrameMetadataPtr& input) {
    return input->spatial_idx;
  }

  static decltype(::media::mojom::blink::DropFrameMetadata::end_of_picture) end_of_picture(
      const ::media::mojom::blink::DropFrameMetadataPtr& input) {
    return input->end_of_picture;
  }

  static bool Read(::media::mojom::blink::DropFrameMetadata::DataView input, ::media::mojom::blink::DropFrameMetadataPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::H264Metadata::DataView,
                                         ::media::mojom::blink::H264MetadataPtr> {
  static bool IsNull(const ::media::mojom::blink::H264MetadataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::H264MetadataPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::H264Metadata::temporal_idx) temporal_idx(
      const ::media::mojom::blink::H264MetadataPtr& input) {
    return input->temporal_idx;
  }

  static decltype(::media::mojom::blink::H264Metadata::layer_sync) layer_sync(
      const ::media::mojom::blink::H264MetadataPtr& input) {
    return input->layer_sync;
  }

  static bool Read(::media::mojom::blink::H264Metadata::DataView input, ::media::mojom::blink::H264MetadataPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::Vp8Metadata::DataView,
                                         ::media::mojom::blink::Vp8MetadataPtr> {
  static bool IsNull(const ::media::mojom::blink::Vp8MetadataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::Vp8MetadataPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::Vp8Metadata::non_reference) non_reference(
      const ::media::mojom::blink::Vp8MetadataPtr& input) {
    return input->non_reference;
  }

  static decltype(::media::mojom::blink::Vp8Metadata::temporal_idx) temporal_idx(
      const ::media::mojom::blink::Vp8MetadataPtr& input) {
    return input->temporal_idx;
  }

  static decltype(::media::mojom::blink::Vp8Metadata::layer_sync) layer_sync(
      const ::media::mojom::blink::Vp8MetadataPtr& input) {
    return input->layer_sync;
  }

  static bool Read(::media::mojom::blink::Vp8Metadata::DataView input, ::media::mojom::blink::Vp8MetadataPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::Vp9Metadata::DataView,
                                         ::media::mojom::blink::Vp9MetadataPtr> {
  static bool IsNull(const ::media::mojom::blink::Vp9MetadataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::Vp9MetadataPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::Vp9Metadata::inter_pic_predicted) inter_pic_predicted(
      const ::media::mojom::blink::Vp9MetadataPtr& input) {
    return input->inter_pic_predicted;
  }

  static decltype(::media::mojom::blink::Vp9Metadata::temporal_up_switch) temporal_up_switch(
      const ::media::mojom::blink::Vp9MetadataPtr& input) {
    return input->temporal_up_switch;
  }

  static decltype(::media::mojom::blink::Vp9Metadata::referenced_by_upper_spatial_layers) referenced_by_upper_spatial_layers(
      const ::media::mojom::blink::Vp9MetadataPtr& input) {
    return input->referenced_by_upper_spatial_layers;
  }

  static decltype(::media::mojom::blink::Vp9Metadata::reference_lower_spatial_layers) reference_lower_spatial_layers(
      const ::media::mojom::blink::Vp9MetadataPtr& input) {
    return input->reference_lower_spatial_layers;
  }

  static decltype(::media::mojom::blink::Vp9Metadata::end_of_picture) end_of_picture(
      const ::media::mojom::blink::Vp9MetadataPtr& input) {
    return input->end_of_picture;
  }

  static decltype(::media::mojom::blink::Vp9Metadata::temporal_idx) temporal_idx(
      const ::media::mojom::blink::Vp9MetadataPtr& input) {
    return input->temporal_idx;
  }

  static decltype(::media::mojom::blink::Vp9Metadata::spatial_idx) spatial_idx(
      const ::media::mojom::blink::Vp9MetadataPtr& input) {
    return input->spatial_idx;
  }

  static const decltype(::media::mojom::blink::Vp9Metadata::spatial_layer_resolutions)& spatial_layer_resolutions(
      const ::media::mojom::blink::Vp9MetadataPtr& input) {
    return input->spatial_layer_resolutions;
  }

  static decltype(::media::mojom::blink::Vp9Metadata::begin_active_spatial_layer_index) begin_active_spatial_layer_index(
      const ::media::mojom::blink::Vp9MetadataPtr& input) {
    return input->begin_active_spatial_layer_index;
  }

  static decltype(::media::mojom::blink::Vp9Metadata::end_active_spatial_layer_index) end_active_spatial_layer_index(
      const ::media::mojom::blink::Vp9MetadataPtr& input) {
    return input->end_active_spatial_layer_index;
  }

  static const decltype(::media::mojom::blink::Vp9Metadata::p_diffs)& p_diffs(
      const ::media::mojom::blink::Vp9MetadataPtr& input) {
    return input->p_diffs;
  }

  static bool Read(::media::mojom::blink::Vp9Metadata::DataView input, ::media::mojom::blink::Vp9MetadataPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::SVCGenericMetadata::DataView,
                                         ::media::mojom::blink::SVCGenericMetadataPtr> {
  static bool IsNull(const ::media::mojom::blink::SVCGenericMetadataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::SVCGenericMetadataPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::SVCGenericMetadata::follow_svc_spec) follow_svc_spec(
      const ::media::mojom::blink::SVCGenericMetadataPtr& input) {
    return input->follow_svc_spec;
  }

  static decltype(::media::mojom::blink::SVCGenericMetadata::temporal_idx) temporal_idx(
      const ::media::mojom::blink::SVCGenericMetadataPtr& input) {
    return input->temporal_idx;
  }

  static decltype(::media::mojom::blink::SVCGenericMetadata::spatial_idx) spatial_idx(
      const ::media::mojom::blink::SVCGenericMetadataPtr& input) {
    return input->spatial_idx;
  }

  static decltype(::media::mojom::blink::SVCGenericMetadata::reference_flags) reference_flags(
      const ::media::mojom::blink::SVCGenericMetadataPtr& input) {
    return input->reference_flags;
  }

  static decltype(::media::mojom::blink::SVCGenericMetadata::refresh_flags) refresh_flags(
      const ::media::mojom::blink::SVCGenericMetadataPtr& input) {
    return input->refresh_flags;
  }

  static bool Read(::media::mojom::blink::SVCGenericMetadata::DataView input, ::media::mojom::blink::SVCGenericMetadataPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::BitstreamBufferMetadata::DataView,
                                         ::media::mojom::blink::BitstreamBufferMetadataPtr> {
  static bool IsNull(const ::media::mojom::blink::BitstreamBufferMetadataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::BitstreamBufferMetadataPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::BitstreamBufferMetadata::payload_size_bytes) payload_size_bytes(
      const ::media::mojom::blink::BitstreamBufferMetadataPtr& input) {
    return input->payload_size_bytes;
  }

  static decltype(::media::mojom::blink::BitstreamBufferMetadata::key_frame) key_frame(
      const ::media::mojom::blink::BitstreamBufferMetadataPtr& input) {
    return input->key_frame;
  }

  static const decltype(::media::mojom::blink::BitstreamBufferMetadata::timestamp)& timestamp(
      const ::media::mojom::blink::BitstreamBufferMetadataPtr& input) {
    return input->timestamp;
  }

  static decltype(::media::mojom::blink::BitstreamBufferMetadata::qp) qp(
      const ::media::mojom::blink::BitstreamBufferMetadataPtr& input) {
    return input->qp;
  }

  static const decltype(::media::mojom::blink::BitstreamBufferMetadata::optional_metadata)& optional_metadata(
      const ::media::mojom::blink::BitstreamBufferMetadataPtr& input) {
    return input->optional_metadata;
  }

  static const decltype(::media::mojom::blink::BitstreamBufferMetadata::svc_generic)& svc_generic(
      const ::media::mojom::blink::BitstreamBufferMetadataPtr& input) {
    return input->svc_generic;
  }

  static const decltype(::media::mojom::blink::BitstreamBufferMetadata::encoded_size)& encoded_size(
      const ::media::mojom::blink::BitstreamBufferMetadataPtr& input) {
    return input->encoded_size;
  }

  static const decltype(::media::mojom::blink::BitstreamBufferMetadata::encoded_color_space)& encoded_color_space(
      const ::media::mojom::blink::BitstreamBufferMetadataPtr& input) {
    return input->encoded_color_space;
  }

  static bool Read(::media::mojom::blink::BitstreamBufferMetadata::DataView input, ::media::mojom::blink::BitstreamBufferMetadataPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT UnionTraits<::media::mojom::blink::Bitrate::DataView,
                                        ::media::mojom::blink::BitratePtr> {
  static bool IsNull(const ::media::mojom::blink::BitratePtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::BitratePtr* output) { output->reset(); }

  static ::media::mojom::blink::Bitrate::Tag GetTag(const ::media::mojom::blink::BitratePtr& input) {
    return input->which();
  }

  static const ::media::mojom::blink::ConstantBitratePtr& constant(const ::media::mojom::blink::BitratePtr& input) {
    return input->get_constant();
  }

  static const ::media::mojom::blink::VariableBitratePtr& variable(const ::media::mojom::blink::BitratePtr& input) {
    return input->get_variable();
  }

  static const ::media::mojom::blink::ExternalBitratePtr& external(const ::media::mojom::blink::BitratePtr& input) {
    return input->get_external();
  }

  static bool Read(::media::mojom::blink::Bitrate::DataView input, ::media::mojom::blink::BitratePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT UnionTraits<::media::mojom::blink::OptionalMetadata::DataView,
                                        ::media::mojom::blink::OptionalMetadataPtr> {
  static bool IsNull(const ::media::mojom::blink::OptionalMetadataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::OptionalMetadataPtr* output) { output->reset(); }

  static ::media::mojom::blink::OptionalMetadata::Tag GetTag(const ::media::mojom::blink::OptionalMetadataPtr& input) {
    return input->which();
  }

  static const ::media::mojom::blink::DropFrameMetadataPtr& drop(const ::media::mojom::blink::OptionalMetadataPtr& input) {
    return input->get_drop();
  }

  static const ::media::mojom::blink::H264MetadataPtr& h264(const ::media::mojom::blink::OptionalMetadataPtr& input) {
    return input->get_h264();
  }

  static const ::media::mojom::blink::Vp8MetadataPtr& vp8(const ::media::mojom::blink::OptionalMetadataPtr& input) {
    return input->get_vp8();
  }

  static const ::media::mojom::blink::Vp9MetadataPtr& vp9(const ::media::mojom::blink::OptionalMetadataPtr& input) {
    return input->get_vp9();
  }

  static bool Read(::media::mojom::blink::OptionalMetadata::DataView input, ::media::mojom::blink::OptionalMetadataPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_VIDEO_ENCODE_ACCELERATOR_MOJOM_BLINK_H_