// mojo/public/interfaces/bindings/interface_control_messages.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "mojo/public/interfaces/bindings/interface_control_messages.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "mojo/public/interfaces/bindings/interface_control_messages.mojom-params-data.h"
namespace mojo {
namespace interface_control {

namespace internal {
// static
bool RunInput_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const RunInput_Data* object = static_cast<const RunInput_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case RunInput_Tag::kQueryVersion: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_query_version, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_query_version, validation_context))
        return false;
      return true;
    }
    case RunInput_Tag::kFlushForTesting: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_flush_for_testing, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_flush_for_testing, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in RunInput");
      return false;
    }
  }
}
// static
bool RunOutput_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const RunOutput_Data* object = static_cast<const RunOutput_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case RunOutput_Tag::kQueryVersionResult: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_query_version_result, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_query_version_result, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in RunOutput");
      return false;
    }
  }
}
// static
bool RunOrClosePipeInput_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const RunOrClosePipeInput_Data* object = static_cast<const RunOrClosePipeInput_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case RunOrClosePipeInput_Tag::kRequireVersion: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_require_version, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_require_version, validation_context))
        return false;
      return true;
    }
    case RunOrClosePipeInput_Tag::kEnableIdleTracking: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_enable_idle_tracking, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_enable_idle_tracking, validation_context))
        return false;
      return true;
    }
    case RunOrClosePipeInput_Tag::kMessageAck: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_message_ack, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_message_ack, validation_context))
        return false;
      return true;
    }
    case RunOrClosePipeInput_Tag::kNotifyIdle: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_notify_idle, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_notify_idle, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in RunOrClosePipeInput");
      return false;
    }
  }
}


// static
bool RunMessageParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RunMessageParams_Data* object =
      static_cast<const RunMessageParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->input, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->input, validation_context))
    return false;

  return true;
}

RunMessageParams_Data::RunMessageParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RunResponseMessageParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RunResponseMessageParams_Data* object =
      static_cast<const RunResponseMessageParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnion(object->output, validation_context))
    return false;

  return true;
}

RunResponseMessageParams_Data::RunResponseMessageParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QueryVersion_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const QueryVersion_Data* object =
      static_cast<const QueryVersion_Data*>(data);

  return true;
}

QueryVersion_Data::QueryVersion_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QueryVersionResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const QueryVersionResult_Data* object =
      static_cast<const QueryVersionResult_Data*>(data);

  return true;
}

QueryVersionResult_Data::QueryVersionResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FlushForTesting_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FlushForTesting_Data* object =
      static_cast<const FlushForTesting_Data*>(data);

  return true;
}

FlushForTesting_Data::FlushForTesting_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RunOrClosePipeMessageParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RunOrClosePipeMessageParams_Data* object =
      static_cast<const RunOrClosePipeMessageParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->input, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->input, validation_context))
    return false;

  return true;
}

RunOrClosePipeMessageParams_Data::RunOrClosePipeMessageParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RequireVersion_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RequireVersion_Data* object =
      static_cast<const RequireVersion_Data*>(data);

  return true;
}

RequireVersion_Data::RequireVersion_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EnableIdleTracking_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const EnableIdleTracking_Data* object =
      static_cast<const EnableIdleTracking_Data*>(data);

  return true;
}

EnableIdleTracking_Data::EnableIdleTracking_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MessageAck_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MessageAck_Data* object =
      static_cast<const MessageAck_Data*>(data);

  return true;
}

MessageAck_Data::MessageAck_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NotifyIdle_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NotifyIdle_Data* object =
      static_cast<const NotifyIdle_Data*>(data);

  return true;
}

NotifyIdle_Data::NotifyIdle_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace interface_control
}  // namespace mojo